camera {
  location <0.9,3,-2.25>
  look_at <0.2,1.43,-0.7>
}

//The walls and the ceiling
union {
  union {
    box { <-7,0,7>,<7,4,7.5> }
    box { <-7.5,0,7.5><-7,4,-7.5> }
    box { <7,0,-7.5>,<7.5,4,7.5> }
    pigment {
      granite
      turbulence 0.2 omega 0.6
      color_map {
        [0 color rgb <0.5,0.5,0.5>]
        [1 color rgb <0.6,0.6,0.6>]
      }
      scale <0.1,2,0.1>
    }
    normal { bumps 0.5 scale 0.08 }
    finish { diffuse 0.45 }
  }
  box {
    <-7.5,4,-7.5>,<7.5,4.1,7.5>
    pigment { color rgb 0.4 }
    normal { granite 0.5 scale 0.05 }
    finish { diffuse 0.45 }
  }
}

// Some coordinates for the pentagram (The Y-coordinate isn't used in the P's)
#declare KK=180-((3*180)/5)
#declare P1 = <0,0,4.75>
#declare P2 = vrotate (P1,y*KK)
#declare P3 = vrotate (P2,y*KK)
#declare P4 = vrotate (P3,y*KK)
#declare P5 = vrotate (P4,y*KK)

// The floor with the pentagram engraving
union {
  height_field { tga "brick.tga" scale <14.5,0.1,14.5> translate <-7.25,-0.1,-7.25> }
  intersection {
    cylinder { <0,-0.025,0>,<0,0.005,0>,5 }
    union {
      difference {
        cylinder { <0,-0.025,0>,<0,0.001,0>,5 }
        cylinder { <0,-0.025,0>,<0,0.1,0>,4.75 }
      }
      cylinder { <P1.x,0,P1.z>,<P3.x,0,P3.z>,0.15 }
      cylinder { <P3.x,0,P3.z>,<P5.x,0,P5.z>,0.15 }
      cylinder { <P5.x,0,P5.z>,<P2.x,0,P2.z>,0.15 }
      cylinder { <P2.x,0,P2.z>,<P4.x,0,P4.z>,0.15 }
      cylinder { <P4.x,0,P4.z>,<P1.x,0,P1.z>,0.15 }
    }
    pigment { color rgb <0.7,0.3,0.4> }
    finish { brilliance 0.7 specular 1 roughness 0.001 metallic 1 ambient 0.15 }
    normal { bumps 0.2 scale 0.3 }
  }
  pigment {
    image_map { tga "brick.tga" once }
    scale 14.5
    translate -7.25
  }
}

// The altar
union {
  box { <-1,0,-0.5>,<1,1.25,0.5> }
  box { <-1.05,1.25,-0.55>,<1.05,1.3,0.55> }
  pigment {
    granite
    turbulence 0.5 omega 0.8
    color_map {
      [0 color rgb <0.56,0.56,0.57>]
      [0.3 color rgb <0.4,0.4,0.4>]
      [1 color rgb <0.6,0.6,0.6>]
    }
    scale <0.6,0.4,0.6>
  }
  normal { dents 0.4 turbulence 0.3 omega 0.6 scale 0.05 }
}

#declare CandleS=
union {
  difference {
    torus { 0.025,0.05 clipped_by{ torus { 0.02501,0.05 }} rotate x*90 }
    box { <-1,0,-1>,<1,1,1> }
    translate <0,0.05,0>
  }
  cylinder { <0,0.05,0>,<0,1.5,0>,0.025 }
  sor {
    7,
    <0.04,1.149>,<0.035,1.5>,<0.04,1.51>,
    <0.06,1.515>,<0.05,1.525>,<0.076,1.54>,
    <0.08,1.56>
  }
  pigment { color rgb <0.8,0.76,0.3> }
  finish { reflection 0.4 diffuse 0.3 metallic 1 specular 1 roughness 0.002 brilliance 1.15 }
  scale <1.75,1,1.75>
}

// Candles in the form of pentagram
#declare C_Seed=seed(789)
#declare Cand_Loop=1 #while (Cand_Loop<=5)
union {
  object { CandleS translate <0,0,3.5> }
  union {
    blob {
      threshold 0.1
      #declare C_End=rand(C_Seed)*2
      cylinder { <0,1.55,3.5>,<0,1.55+C_End,3.5>,0.07,1 }
      cylinder { <0,(1.55+C_End)-(0.2*C_End),3.5><0,1.55+(1.2*C_End),3.5>,0.03,-1 }
      #declare S_Loop=0 #while (S_Loop<=rand(C_Seed)*30)
      #declare Ste_Loc=vrotate (<0,1.55+(rand(C_Seed)*C_End),0.05>, y*360*rand(C_Seed))
      sphere { Ste_Loc+<0,0,3.5>,0.01+(rand(C_Seed)*0.03),1 }
      #declare S_Loop=S_Loop+1 #end
      pigment { color rgb 1 }
      finish { phong 1 phong_size 27 ambient 0.3 }
    }
    cylinder {
      <0,1.556,3.5>,<0,1.555+(1.5*C_End),3.5>,0.0075
      pigment {color rgb 0.2 }
    }
  }
  rotate y*KK*Cand_Loop
}
#declare CL=rand(C_Seed)*0.3
#declare Cand=
light_source {
  <0,0,0>
  color rgb <0.65+CL,0.65+CL,0.35+(0.5*CL)>
  area_light
  <0.04,0,0.04>,<-0.04,0,-0.04>
  4,4
  adaptive 1
  jitter
  fade_power 1
  fade_distance 0.5+(rand(C_Seed)*0.6)
}
#declare C_Switch=int(rand(C_Seed)*rand(C_Seed)*3)
#switch (C_Switch)
  #case (0)
  #debug concat("Light #", str(Cand_Loop,0,0)," is OFF.\n")
  #break
  #range (1,2)
  #debug concat("Light #", str(Cand_Loop,0,0)," is ON.\n")
  object { Cand translate <0,1.58,3.5>+<0,C_End*1.5,0> rotate y*KK*Cand_Loop }
  #break
#end
#declare Cand_Loop=Cand_Loop+1 #end

// The Picar or whatever it should be named.
// Or hey, maybe it's the unholy grail :)
#include "Picar.inc"
object {
  Picar
  scale 0.4
  translate <-0.3,1.25428,0.4>
  texture {
    pigment { color rgb <0.9,0.89,0.65> }
    finish {
      reflection 0.6 diffuse 1/8
      specular 1 roughness 0.004
      metallic 1
    }
  }
}

// The dagger
#include "dagger.inc"
object { SDagger scale 0.1 translate 0 rotate x*90.5 rotate y*37 translate <0,1.31,0> }

// Some blood on the altar
#declare B_Seed=seed(666) // Evil ;P
blob {
  threshold 0.3
  #declare B_Loop=0  #while (B_Loop<=50)
  sphere { <-0.25+(rand(B_Seed)*0.45),0,0.2-(rand(B_Seed)*0.4)>,rand(B_Seed)*0.1,0.4+(rand(B_Seed)*0.6) }
  #declare B_Loop=B_Loop+1 #end
  pigment { color rgb <0.645,0.02,0.132>}
  scale <1,0.1,1>
  translate <0.25,1.3,0>
}

// A Cloaked figure kneeling in front of the altar
#include "cloak.inc"
object { Cloaked_Figure scale 0.45 rotate y*180 translate <-0.1,0,-1.3> }

// Now a bit more detailed candle (sorry about the messy code :L)
#declare DC_Seed=seed(211)
union {
  blob {
    threshold 0.65
    cylinder { <0,-0.1,0>,<0,0.3,0>,0.2,1 }
    sphere { <0,0.3,0>,0.1,-1 }
    #declare Circ_Loop=0 #while (Circ_Loop<=20)
      #declare Circ_P=vrotate (<0.075,0.26,0>, y*360*rand(DC_Seed))
      sphere { Circ_P,0.01+(rand(DC_Seed)*0.015),0.4+(rand(DC_Seed)*0.6) }
    #declare Circ_Loop=Circ_Loop+1 #end
    #declare Ste_Loop=0 #while (Ste_Loop<=40)
      #declare S_Point=vrotate (<0.085,rand(DC_Seed)*0.2975,0>,y*360*rand(DC_Seed))
      #declare Y_M=rand(DC_Seed)*0.03
      #declare II_Loop=0 #while(II_Loop<=4)
        sphere { S_Point-<0,Y_M*II_Loop,0>,0.0035*(II_Loop+1)+(rand(DC_Seed)*0.01),0.5+(rand(DC_Seed)*0.5)}
        #declare II_Loop=II_Loop+1 #end
      #declare Ste_Loop=Ste_Loop+1 #end
    #declare B_Loop=0 #while (B_Loop<=30)
      #declare B_Point=vrotate(<0.1,0,0>,y*360*rand(DC_Seed))
      sphere { B_Point,0.015+(rand(DC_Seed)*0.025),0.5+(rand(DC_Seed)*0.5) }
      #declare B_Loop=B_Loop+1 #end
    sturm
    hollow
    no_shadow
    pigment { color rgb 1 }
    finish { ambient 0.1 phong 0.6 phong_size 40 }
  }
  cylinder { <0,0.25,0>,<0,0.28,0>,0.005 pigment { color rgb 0 }hollow }
  sphere {
    <0,0,0>,1
    pigment { color rgbt 1 }
    halo {
      spherical_mapping
      linear
      samples 10
      aa_level 2
      aa_threshold 0.2
      turbulence <0.1,0.1,0.1>
      omega 0.2
      color_map {
        [0 color rgbt <1,.5,0,1>]
        [0.05 color rgbt <1,1,.4,0.2>]
        [0.3 color rgbt <1,1,1,-1>]
        [0.7 color rgbt <1.2,1.2,1,-1>]
        [0.8 color rgbt <0.2,0.3,1,0.3>]
        [1 color rgbt <0,0,0,1>]
      }
      scale <0.35,0.8,0.35>
      translate <0,-0.3,0>
    }
    hollow
    scale <0.08,0.1,0.08>
    translate <0,0.325,0>
  }
  object { Cand translate <0,0.375,0> }
  translate <0.91,1.3,0.4>
}




