
// Glenn's POV-Ray Scene File - "Serenade"
// created 28-Apr-98
// last update 29-Apr-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//===============================================
//             Variables
//===============================================

#declare MoonPos =<120.00*Miles,1.00*Miles,36.00*Miles>

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  /* // Focal Blur section: uncomment to enable focal blur
  blur_samples 6
  aperture .5    //lower value = wider range in focus
  focal_point <0,0,0>
  */ // end focal blur
  location  <-2.6*Feet, -0.002*Feet, 13*Feet>
  look_at   <0, -3, 13.6*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//    angle 40
//    direction z*50
  location <-15, -16, 11>
  look_at <0, 0, 0>
  }

camera { // special cameras declared in GCamerasRH.inc
//    Special_Cam
    Render_Cam
 }

//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
//object {StdBulb100Watt translate <-10*Feet,2*Feet,8*Feet> }

#declare Sunlight = color rgb<15.0,13.0,10.0> // BRIGHT arbitrary yellowish value
#declare Earthlight = color Sunlight/6 // make it six times dimmer than Sun...
#declare Earthlight = color Earthlight * <0.3,1.4,1.6> // ...then tint it blue/green

#declare BrightSunToTheLeft =
  light_source {
//    <0,-93000,0> // full moon: sun behind camera (units = 1000 miles)
    <30000*Miles,43000*Miles,-1000*Miles> // half full: sun to the left
//     <-66000,-66000,0> // 3/4 moon gibbous
//    <-66000,66000,0> // 1/4 moon crescent
    color Sunlight
  }
object { BrightSunToTheLeft }

#declare DimEarthshine =
  light_source {
    <20*Miles,-40*Miles,-.12*Miles>
    color Earthlight*.2
//		spotlight
//		radius 40
//		point_at MoonPos
  }
object { DimEarthshine }

#declare MoonLight =
	light_source {
		MoonPos-<40*Miles,0,0>
		color Sunlight*.04
		spotlight
		point_at <0,0,0>
	}
object { MoonLight }

#declare HouseLight1 =
	light_source {
		<1030*Feet,-220*Feet,9*Feet>
		color rgb<1,1,.4>*.4
		fade_distance 22*Feet
		fade_power 1
		spotlight
		point_at <0,0,0>
	}
object { HouseLight1 }

#declare HouseLight2 =
	light_source {
		<1120*Feet,-560*Feet,13*Feet>
		color rgb<1,1,.4>*.24
		fade_distance 15*Feet
		fade_power 1
		spotlight
		point_at <0,0,0>
	}
object { HouseLight2 }

//===============================================
//             Textures
//===============================================

#declare MoonTexFirstPart = // this forms the wide grey maria
  texture {
    pigment {
      bumps
      color_map {
        [ 0.00 color rgb<0.2,0.2,0.4> ] // grey plains
        [ 0.50 color rgb<0.08,0.08,0.18> ] // lighter grey mixed in
        [ 1.00 color rgb<0.2,0.2,0.4> ] // grey plains
      }
      scale .2
    }
    finish { ambient Earthlight*.06 diffuse 0.02 specular .04 roughness .52 }
    // note: ambient is same color as earthshine, except much dimmer
    // note: no normal is used here -- the maria are glass smooth,
    // this helps eliminate the sharp transition line
 }

#declare MoonTexSecondPart = // this forms mountain ranges with scattered peaks
  texture {
    pigment {
      granite
      color_map {
        [ 0.00 color rgb<0.2,0.2,0.2> ] // mostly darkness
        [ 0.40 color rgb<0.1,0.4,0.4> ] // transition to a few bright mountain peaks
        [ 0.50 color rgb<0.1,0.4,0.4> ] // still bright mountain peaks
        [ 1.00 color rgb<0.2,0.2,0.2> ] // back to darkness
     }
      scale 1.5 // very rugged
    }
    normal {
      granite 0.8 // this MUST be the same as the pigment type for best effect
      scale 1.5 // this MUST be the same as the pigment type for best effect
    }
    finish { ambient Earthlight*.06 diffuse 0.02 specular .20 roughness .08 }
 }

#declare MoonTex =
  texture {
    bozo // now, mix the two textures together
    texture_map {
      [0.0 MoonTexFirstPart ] // start with wide maria
      [0.4 MoonTexFirstPart ] // quickly transition to...
      [0.6 MoonTexSecondPart ] // ... rugged mountains
      [1.0 MoonTexSecondPart ]
    }
    turbulence 0.8 // optional
    omega 0.66 // optional
    scale 1.3 // optional
    rotate y*90 // optional
  }

#declare StarTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient .9 }
	}

#declare SandyColor =
//	color rgb <.34,.321,.156> // light, slightly yellow brownish sand
	color rgb<.33,.301,.136> // just right
//	color rgb <.30,.281,.116> // a little too dark, like dirt

#declare SandyTex =
	texture {
			pigment { SandyColor }
			finish { ambient .01 }
		}
#declare BumpySandTex =
	texture {
			pigment { SandyColor }
			normal { bumps .4 scale <2,4,2> }
			finish { ambient .01 }
		}

#declare FenceTex =
	texture {
		pigment { color rgb<1,1,1> }
		normal { bumps .4 scale 1 }
		finish { ambient .01 specular .2 roughness .05 }
	}

//===============================================
//             Environment
//===============================================

//background { color rgb <0.2, 0.4, 0.8> } // light blue
background { color rgb <0.0, 0.0, 0.0> } // black
sky_sphere {
    pigment {
      gradient z
      color_map {
        [ 0.500  color rgb<.012,.012,.016> ]
        [ 0.505  color rgb<.07,.07,.12> ]
        [ 0.6  color rgb<.02,.02,.05> ]
      }
      scale 2
      translate -1
    }
  }

#declare StarShape =
	sphere {
		<0,0,0>,.013*Miles
		texture { StarTex }
	}
#declare StarCount = 1
#declare MaxStars = 100
#declare RS = seed(57343)
#declare StarField =
	union {
		#while ( StarCount < MaxStars )
			object { StarShape
				scale rand(RS)*.8+.2
				translate <12*Miles,0,0>
				rotate <0,-3+rand(RS)*(-32),-40+rand(RS)*80>
			}
			#declare StarCount = StarCount + 1
		#end
	}
object { StarField }
#declare StarCount = 1
#declare MaxStars = 200
#declare RS = seed(57343)
#declare DimStarField =
	union {
		#while ( StarCount < MaxStars )
			object { StarShape
				scale rand(RS)*.8+.2
				translate <12*Miles,0,0>
				rotate <0,-13+rand(RS)*(-32),-40+rand(RS)*80>
				texture { pigment{color rgb<1,1,1>} finish {ambient rand(RS)*.5} }
			}
			#declare StarCount = StarCount + 1
		#end
	}
object { DimStarField }

#declare WaterShape =
	box {
		<-20*Feet,-20*Miles,-18>,<100*Miles,20*Miles,-1>
	}
#declare WaterBelow =
	object { WaterShape
		texture {
			normal {
				average
				normal_map {
					[ 0.5 bumps .2 scale 30 ]
					[ 0.5 marble .8 scale 13 turbulence .3 ]
				}
			 }
			finish { ambient .1 specular 1 roughness .008 reflection .2 }
		}
	}
object { WaterBelow }

#declare DeepWater =
	object { WaterShape
		translate <0,0,-3*Feet>
		texture {
			pigment { color rgb<.4,.7,1.0> }
			normal { bumps .1 scale 100 }
			finish { ambient .1 specular 1 roughness .02 }
		}
	}
object { DeepWater }

#declare MilkyWay =
sphere {
	<0,0,0>,1
	pigment { color rgbt <1, 1, 1, 1> }
	halo {
		emitting
		spherical_mapping
		linear
		turbulence 1.8
		color_map {
			[ 0 color rgbt <.6, .6, .9, 1.0> ]
			[ 1 color rgbt <1, 1, 1, .8> ]
		}
		samples 10
		scale .8
	}
	hollow
	}
object { MilkyWay
	scale <80*Miles,80*Miles,260*Miles>
	rotate x*68
	translate <150*Miles,0,28*Miles>
	rotate <0,-4,28>
}

//===============================================
//             Objects
//===============================================

#declare SMoon =
  sphere {
//    <0,0,0>,21.55*Miles // scale is 1/100 real
    <0,0,0>,12.55*Miles // scale is 1/100 real
    texture { MoonTex scale 6*Miles}
  }
#declare CraterCount = 1
#declare Moon =
	difference {
		sphere { // main
//		<0,0,0>,21.55*Miles // scale is 1/100 real
			<0,0,0>,12.55*Miles // scale is 1/100 real
		}
		#while ( CraterCount < 400 )
			sphere {
				<0,0,0>,rand(RS)*1*Miles
				translate <12.55*Miles,0,0>
				rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
			}
		#declare CraterCount = CraterCount + 1
		#end
		texture { MoonTex scale 6*Miles}
	}

#declare DistantMountains =
	height_field {
		gif "HF2.gif"
		rotate x*90 // set up for RH coordinate system
		translate <-.5,.5,-0.005> //center on origin // sink it below local area
//		translate <-.5,.5,0> //center on origin
		texture { SandyTex }
		scale <40000,40000,1200> // finally, scale it up
// NOTE: because of scaling, center region is about 8 below zero
	}

#declare TestBox = // for checking angles
	box {
		<0,-16*Feet,-.3>,<.3*Feet,16*Feet,.3>
		texture { StarTex }
	}
//object { TestBox translate <25*Feet,0,0> rotate y*-20 translate <0,0,13*Feet> }
//object { TestBox translate <25*Feet,0,0> rotate y*-22.5 translate <0,0,13*Feet> }

#declare LitWindow =
	box {
		<0,-20,0>,<1,20,48>
		texture {
			pigment { color rgb<1,1,.35> }
			finish { ambient .8 }
		}
	}
#declare SymmHouse =
	union {
		object { LitWindow translate <0,-8*Feet,48> }
		object { LitWindow translate <0, 8*Feet,48> }
		object { LitWindow translate <0,-2*Feet,48+8*Feet> }
		object { LitWindow translate <0, 2*Feet,48+8*Feet> }
	}
#declare RandHouse =
	union {
		object { LitWindow translate <0,-4*Feet,48> }
		object { LitWindow translate <0, 8*Feet,48> }
		object { LitWindow scale .6 translate <0, 12*Feet,48+18*Feet> }
		object { LitWindow scale .6 translate <0, 16*Feet,48+10*Feet> }
	}


//===============================================
//             Object Placement
//===============================================

object { DistantMountains rotate z*99 translate <0,0,-30> } // image top = +X

object { Moon scale .27 translate MoonPos}

object { SymmHouse rotate z*-10 translate <1080*Feet,-230*Feet,6*Feet> }
object { RandHouse rotate z*-10 translate <1130*Feet,-580*Feet,12*Feet> }
object { LitWindow scale .3 rotate z*-10 translate <920*Feet,-48*Feet,16*Feet> } // left
object { LitWindow scale .5 rotate z*-10 translate <920*Feet,-76*Feet,28*Feet> } // left

object { LitWindow scale .5 rotate z*-10 translate <1000*Feet,-276*Feet,12*Feet> } // road
object { LitWindow scale .5 rotate z*-10 translate <1000*Feet,-347*Feet,12*Feet> } // road
object { LitWindow scale .5 rotate z*-10 translate <1000*Feet,-474*Feet,12*Feet> } // road

