                    
// Light20.pov           12 / 4 / 98   same as 17 + moths -lampglass

#include "colors.inc"
#include "textures.inc"     
#include "Glass.inc"
#include "Metals.inc" 

// background { color rgb < 0.3, 0, 0.36 > }

camera {
       location < 0, 32, -130 >
       angle 30
       look_at < 7, 14, 0 >
       }
light_source { < 100, 100, -100 > color Gray50 shadowless }
light_source { < 0, 18.4, 0 > color White }   // move this with mantle 
light_source { < 0, 20.4, -1.5 > color Gray40 }   // move this with mantle 
light_source { < 0, 20.4, 1.5 > color Gray40 }   // move this with mantle 
    
global_settings { max_trace_level 15 }

#declare Land =
              height_field {
                            tga "wrinc2.tga"
                            translate < -0.5, -0.5, 0 >
                            scale < 1000, 100, 2500 >  
                            rotate 15*y
                            translate < 0, -100, 50 >
                            pigment {  color rgb < 1, 0.6, 0.4 > }  
                            normal { bumps 0.25 scale 0.5 }
                            finish { ambient 0 
                                     diffuse 0.3 }
                            }
object { Land }
// GUMTREE
#declare Rudd =
             texture {
                      pigment {
                      bozo
                      turbulence 0.5
                           color_map {
                                     [ 0.0 color rgb < 0.6, 0.2, 0.2 > ]
                                     [ 0.2 color rgb < 0.6, 0.5, 0.2 > ]  
                                     [ 0.23 color rgb < 0.6, 0.5, 0.2 > ] 
                                     [ 0.23 color rgb < 0.5, 0.5, 0.1 > ] 
                                     [ 0.6 color rgb < 0.5, 0.5, 0.1 > ]  
                                     [ 0.67 color rgb < 0.6, 0.5, 0.2 > ]
                                     [ 0.8 color rgb < 0.6, 0.5, 0.2 > ] 
                                     [ 0.8 color rgb < 0.6, 0.5, 0.4 > ] 
                                     [ 0.9 color rgb < 0.3, 0.5, 0.5 > ]  
                                     [ 1.0 color Gray65 ]
                                     }
                              scale < 8, 40, 8 >
                              }
                      normal { bumps 0.2   scale 5 }
                      finish { ambient 0 
                               diffuse 0.15 }
                      }
#declare Trunk =
           union {
                    sphere { < 0, 0, 0 >,31.5    }
                    cone { < 0, 0, 0 >,30,< -5, 60, 5 >,25 }
                    sphere { < -5, 60, 5 >,25  }  
                    cone { < -5, 60, 5 >,25,< -10, 86, 7.5 >,22 }
                    sphere { < -10, 86, 7.5 >,22  }  
                    cone { < -10, 86, 7.5 >,22,< -18, 126, 12 >,20 } 
                    sphere { < -18, 126, 12 >,20  } 
                    cone { < -18, 126, 12 >,20,< -17, 186, 12 >,20 } 
                    sphere { < -17, 186, 12 >,20  } 
                    cone { < -17, 186, 12 >,20,< -22, 240, 0 >,19 }
                    sphere { < -22, 240, 0 >,19  }
                    cone { < -22, 240, 0 >,19,< -25, 300, 10 >,18 } 
                    texture { Rudd }
                 }           
                                   
object { Trunk translate < 260, -100, 1000 > }
object { Trunk scale < 0.8, 1.3, 0.8 > rotate 140*y
               translate < 275, -100, 950 > }  
#declare Runk =
           union {
                    sphere { < 0, 0, 0 >,31.5    }
                    cone { < 0, 0, 0 >,30,< 5, 60, -5 >,25 }  
                    sphere { < 5, 60, -5 >,25  }  
                    cone { < 5, 60, -5 >,25,< 20, 86, -7.5 >,22 }
                    sphere { < 20, 86, -7.5 >,22  }  
                    cone { < 20, 86, -7.5 >,22,< 25, 126, -12 >,20 } 
                    sphere { < 25, 126, -12 >,20  } 
                    cone { < 25, 126, -12 >,20,< 28, 186, -12 >,20 } 
                    sphere { < 28, 186, -12 >,20  } 
                    cone { < 28, 186, -12 >,20,< 27, 240, -14 >,19 }
                    sphere { < 27, 240, -14 >,19  }
                    cone { < 27, 240, -14 >,19,< 29, 300, -12 >,18 } 
                    texture { Rudd }
                 }           
               
object { Runk translate < 175, -90, 1400 > }
#declare Twig =
            union {
                cylinder { < 0, 1, 0 >,< 0, 0, -4 >,2 }
                cylinder { < -1, -1, 0 >,< -1, -1, -6 >,.5 }  
                cylinder { < 4, 0, 0 >,< 0, 0, -8 >,1 }  
                cone { < 0, 0, 0 >,5,< -2, 6, 19 >,4.5 }
                cone { < -2, 6, 17 >,4.5,< 0, 10, 31 >,4 }  
                cone { < 0, 10, 29 >,4,< 7, 4, 41 >,3.5 } 
                cone { < 7, 4, 39 >,3.5,< 10, 0, 51 >,3 }   
                cone { < 10, 0, 48 >,3,< 7, -1, 61 >,2.5 } 
                cone { < 7, -1, 58 >,2.5,< 5, -5, 70 >,2 } 
                cone { < 5, -5, 69 >,2,< 8, -2, 85 >,1 }  
                cone { < 0, 10, 30 >,4,< -7, 0, 40 >,2 }  
                  rotate 90*y
                   pigment { color rgb < 0.6, 0.5, 0.4 > }
                   normal { bumps 0.5 scale < 10, 1, 1 > }
                   finish { ambient 0
                            diffuse 0.15 }
                  }
object { Twig rotate < -60, 20, 0 > translate < 225, -100, 870 > }
object { Twig scale < 1.5, 0.8, 0.8 >
             rotate < 150, 130, -20 > translate < 200, -90, 1035 > } 
object { Twig scale < 1, 0.8, 0.8 >
             rotate < 180, 120, 20 > translate < 80, -60, 800 > } 

object { Twig  scale < 2, 1, 1 >
           rotate < -90, 180, -70 > translate < 255, -100, 965 > }  
object { Twig  scale < 0.8, 0.5, 0.5 >
           rotate < 0, 0, 10 > translate < 100, -100, 800 > }  


// TABLE
#declare Aboard =
               union {
                    box { < -0.1, 0, 20 >,< 9.9, -3, -100 > 
                           rotate 2*z 
                        }
                    box { < 0.1, 0, 20 >,< -4.9, -3, -100 > 
                           rotate -3*z 
                        }
         pigment { 
                   bozo
                   color_map {
                               [ 0.0 color rgb < 0.6, 0.5, 0.4 > ]
                               [ 0.23 color rgb < 0.6, 0.5, 0.4 > ]
                               [ 0.5 color rgb < 0.6, 0.45, 0.3 > ]
                               [ 0.7 color rgb < 0.65, 0.4, 0.3 > ]       
                               [ 0.85 color rgb < 0.6, 0.5, 0.4 > ]
                               [ 1.0 color rgb < 0.6, 0.5, 0.4 > ]
                             }
                             scale < 2, 1, 4 >
                  }
         normal { wrinkles 0.65 scale < 1, 1, 15 > }
         finish { ambient 0.2 }

                      }  
#declare Bboard =
               union {
                    box { < -0.1, 0, 20 >,< 7.9, -3, -100 > 
                           rotate -2*z 
                        }
                    box { < 0.1, 0, 20 >,< -6.9, -3, -100 > 
                           rotate 3*z 
                        }
         pigment { 
                   bozo
                   color_map {
                               [ 0.0 color rgb < 0.6, 0.5, 0.4 > ]
                               [ 0.4 color rgb < 0.6, 0.5, 0.4 > ]
                               [ 0.7 color rgb < 0.6, 0.45, 0.3 > ]
                               [ 0.8 color rgb < 0.5, 0.5, 0.3 > ]       
                               [ 0.95 color rgb < 0.6, 0.5, 0.4 > ]
                               [ 1.0 color rgb < 0.6, 0.5, 0.4 > ]
                             }
                             scale < 2, 1, 8 >
                  } 
         normal { wrinkles 0.65 scale < 1, 1, 10 > }  
         finish { ambient 0.2 }

                      }  
#declare Cboard =
               union {
                    box { < -0.1, 0, 20 >,< 6.1, -3, -100 >    
                        }
                    box { < -0.1, 0, 20 >,< 8, -3, -100 > 
                           rotate 3*z 
                           translate 6*x
                        }
                    box { < 0.1, 0, 20 >,< -3.9, -3, -100 > 
                           rotate -3*z 
                        }
         pigment { 
                   bozo
                   color_map {
                               [ 0.0 color rgb < 0.6, 0.5, 0.4 > ]
                               [ 0.23 color rgb < 0.6, 0.5, 0.4 > ]
                               [ 0.5 color rgb < 0.5, 0.45, 0.3 > ]
                               [ 0.7 color rgb < 0.5, 0.4, 0.3 > ]       
                               [ 0.85 color rgb < 0.6, 0.5, 0.4 > ]
                               [ 1.0 color rgb < 0.6, 0.5, 0.4 > ]
                             }
                             scale < 1, 1, 14 >
                  }   
         normal { wrinkles 0.8 scale < 1, 1, 15 > }  
         normal { bumps 0.2 scale < 0.8, 1, 10 > }  
         finish { ambient 0.2 }

                      }  

#declare Table =
              union {
                    object { Aboard translate -35*x }
                    object { Bboard translate -18*x }
                    object { Cboard translate -6*x }
                    object { Aboard translate 10*x }
                    object { Aboard rotate 90*y translate -3*y }  
                    }
#declare Dings =
               union {
                    cylinder { < 0, 2, 0 >,< 0, -2, 0 >,0.4 
                                scale < 1, 1, 18 > 
                                translate 18*z
                             }
                    cylinder { < 0, 2, 0 >,< 0, -2, 0 >,0.3 
                                scale < 1, 1, 8 >
                                translate 8*z
                             }  
                    box { < 0.2, 1, 3 >,< -0.2, -1, -12 > }         
                    box { < 0.25, 1, -0.25 >,< -0.25, -1, 0.25 >
                             rotate 45*y
                             translate -14*z
                        }
                    cylinder { < 0, 2, 0 >,< 0, -2, 0 >,0.25 
                                scale < 1, 1, 10 >  
                                translate -23*z
                             }
                    cylinder { < 0, 2, 0 >,< 0, -2, 0 >,0.25 
                                scale < 1, 1, 20 >  
                                translate -30*z
                             }

                        pigment { color rgb < 0.6, 0.5, 0.4 > }  
                        finish { ambient 0.15 }
                        }
#declare Wtable =
                difference {
                           object { Table }
                           object { Dings rotate 40*z translate 20.1*x }
                           }
#declare Enz =
             union {
                   cylinder { < 0, -1, 0 >,< 0, 1, 0 >,0.75 
                              scale < 2, 1, 1 >  
                              rotate -45*x
                              translate < 10, 0, 20 >
                            }
                   cylinder { < 0, -2, 0 >,< 0, 3, 0 >,0.75 
                              scale < 0.8, 1, 2 >  
                              rotate -75*x
                              translate < -20, 0, 20 >
                            }    
                        pigment { color rgb < 0.6, 0.5, 0.4 > }  
                        finish { ambient 0.15 }   
                   }
#declare Ztable =
                difference {
                           object { Wtable }
                           object { Enz }
                           }

object { Ztable rotate 15*y }
                              

// WALL
#declare Trim =
              superellipsoid { < 0.25, 0.25 >  scale < 3, 30, 3 >
                               pigment { color rgb < 0.7, 0.5, 0.4 > }
                               finish { ambient 0.1 }
                              }

#declare Corner =
              union {
                     object { Trim }
                     object { Trim rotate 2*x translate 50*y }
                     object { Trim rotate -2*x translate -50*y }
                    }
object { Corner translate < -41.75, 0, 50 > rotate 15*y }
#declare Wboard =
               difference {
                    union {   
                        box  { < 0, 0, -1000 >,< -3, 19, 50 > }
                        cylinder { < -1.5, 0, -1000 >,< -1.5, 0, 50 >,1.5  }
                          }
                        cylinder { < 0, 19, 50 >,< 0, 19, -1000 >,11
                                    scale < 0.19, 1, 1 >
                                    translate 0.5*x
                                 }
           pigment { color rgb < 0.7, 0.5, 0.4 > }
           finish { ambient 0.1 }
                          }
#declare Awall =                    
         union {
              object { Wboard }
              object { Wboard translate -18*y }
              object { Wboard translate -36*y } 
              object { Wboard translate -54*y } 
              object { Wboard translate -72*y } 
              object { Wboard translate -90*y } 
              object { Wboard translate -108*y }  
              object { Wboard translate 18*y } 
              object { Wboard translate 36*y } 
              object { Wboard translate 54*y } 
              object { Wboard translate 72*y } 
              object { Wboard translate 90*y } 
              object { Wboard translate 108*y } 
              object { Wboard translate 126*y } 
              object { Wboard translate 144*y } 
               }
#declare Knots =
             union { 
                   cylinder { < -0.2, 5, 0 >,< 0.2, 5, 0 >,3
                               scale < 1, 1, 0.6 >
                               rotate 60*x
                               translate  30*z
                            }
                   cylinder { < -0.3, 0, 0 >,< 0.1, 0, 0 >,4
                               scale < 1, 0.085, 5 >   
                               translate  < 0, 40, 45 >
                            }
           pigment { color rgb < 0.7, 0.5, 0.4 > }
           finish { ambient 0.1 }
                   }
#declare Wall =
              difference {
                         object { Awall }
                         object { Knots }
                         }
object { Wall translate -40*x rotate 15*y }

// VERANDAH
#declare Plate =
          box { < 193, 100, 50 >,< 200, 120, -1000 >
                pigment { color rgb < 0.7, 0.5, 0.4 > }
                finish { ambient 0.1 }
              }
#declare Barge =
          box { < 229, 116, 50 >,< 231, 126, -1000 >
                pigment { color rgb < 0.7, 0.5, 0.4 > }
                finish { ambient 0.1 }
              }

#declare Vpost =
           box { < 188, -90, 50 >,< 200, 120, 38 >              
                pigment { color rgb < 0.7, 0.5, 0.4 > }
                finish { ambient 0.1 }
               }
#declare Rafter =
          box { < 0, 0, 50 >,< 270, 10, 45 >
                  rotate -7*z
                  translate < -41, 150, 0 >
                pigment { color rgb < 0.7, 0.5, 0.4 > }
                finish { ambient 0.1 }
              }
#declare Iron =
          box { < 0, 0, 50 >,< 270, 10, -1000 >
                  rotate -7*z
                  translate < -41, 160, 0 >
                pigment { color Gray70 }
                finish { ambient 0.1 }
              }
            
#declare Roof =               
          union {
                object { Plate }
                object { Barge }
                object { Vpost }
                object { Vpost translate -330*z } 
                object { Vpost translate -660*z } 
                object { Vpost translate -990*z } 
                object { Iron }
                object { Rafter }
                object { Rafter translate -66*z }
                object { Rafter translate -132*z }  
                object { Rafter translate -264*z }  
                object { Rafter translate -330*z }  
                object { Rafter translate -396*z }  
                object { Rafter translate -462*z }
                object { Rafter translate -528*z }  
                object { Rafter translate -594*z }  
                object { Rafter translate -660*z }  
                object { Rafter translate -726*z }  
                object { Rafter translate -792*z }
                object { Rafter translate -858*z }  
                object { Rafter translate -924*z }  
                object { Rafter translate -990*z }  
                }

object { Roof rotate 15*y }
box { < -40, -85, 50 >,< 200, -100, -1000 >           // temp floor              
     rotate 15*y
     pigment { color Gray55 }
    }

// COLEMAN    
#declare Tank  =
     difference {
             union {
                cylinder { < 0, 0, 0 >,< 0, 5.5, 0 >,6 }
                torus { 6, 0.25  scale < 1, 4, 1 > }
                torus { 2, 4  translate 5.5*y } 
                       texture { T_Chrome_5C }
                }
                sphere { < 0, 9, 7 >,3.5  }
                       texture { T_Chrome_5C }
                 }
#declare Filler =
            union {
                 cylinder { < 0, 0, 0 >,< 0, 7.8, 0 >,0.6 }
                 cylinder { < 0, 6.5, 0 >,< 0, 8, 0 >,0.75 } 
                 cylinder { < 0, 8, 0 >,< 0, 8.5, 0 >,0.26 
                             texture { T_Chrome_5C } 
                          }
                 cylinder { < 0, 6.8, 0 >,< 0, 7.7, 0 >,0.85 }   // knurl
                  texture { T_Chrome_5C }    
                   rotate 15*x
                   translate 3.8*z
                   }
                  

#declare Pump =
             union {
                 cylinder { < 0, 0, 0 >,< 7.2, 0, 0 >,1.1 }
                 cylinder { < 7.2, 0, 0 >,< 8, 0, 0 >,1.2 } 
                 cylinder { < 6, 0, 0 >,< 6.4, 0, 0 >,1.15 } 
                 sphere { < 0, 0, 0 >,1.2  scale < 0.1, 1, 1 >
                           translate 8*x
                        }
                 cylinder { < 0, 0, 0 >,< 9, 0, 0 >,0.3 } 
                 cylinder { < 9, 0, 0 >,< 9.3, 0, 0 >,0.9 } 
                 sphere { < 0, 0, 0 >,0.9  scale < 0.1, 1, 1 >
                          translate 9.3*x
                          texture { T_Chrome_5C }
                        }
                 difference {
                         cylinder { < 8.5, 0, 0 >,< 9, 0, 0 >,0.9 } 
                         torus { 0.9, 0.5  rotate 90*z
                                 translate 8.5*x
                               }
                            }
                       rotate 75*y
                       texture { T_Chrome_4C }  
                    } 
#declare Hole =                                          // holes in collar
                cylinder { < -6, 0, 0 >,< 6, 0, 0 >,0.18 
                          pigment { color rgbt < 1, 1, 1, 1 > }
                         }
#declare Rim =
              union {
                    object { Hole }
                    object { Hole rotate 18*y }
                    object { Hole rotate 36*y }
                    object { Hole rotate 54*y }
                    object { Hole rotate 72*y }
                    object { Hole rotate 90*y }
                    object { Hole rotate 108*y }
                    object { Hole rotate 126*y }
                    object { Hole rotate 144*y }
                    object { Hole rotate 162*y }
                    }
#declare Vent =
            union { 
              object { Rim  }       
              object { Rim translate 2.6*y }
                  }
#declare Cutout =                                     // cutout of collar
                 union {
                        box { < -4, 0, -0.9 >,< 4, 2.4, 0.9 > }
                        cylinder { < -4, 2.4, 0 >,< 4, 2.4, 0 >,0.9 }
                             pigment { color rgbt < 1, 1, 1, 1 > }
                        }
#declare Ring =
            difference {
                       cylinder { < 0, 0, 0 >,< 0, 4.5, 0 >,3 }
                       object { Vent translate 1.2*y }
                       texture { T_Chrome_5C }  
                       }
#declare Collar =
            difference {
                         object { Ring }
                         object { Cutout }
                        }
#declare Side =                                        // part of nut
              box { < 0, 0.24, -0.6 >,< 1, -0.24, 0.6 >
                     pigment { color Yellow }
                  }
#declare Nut =
             union {
                    object { Side }
                    object { Side rotate 45*x }
                    object { Side rotate 90*x }
                    }
#declare Lump =
              cylinder { < 4.8, 1.3, 0 >,< 5.5, 1.3, 0 >,0.1
                         pigment { color Gray25 }
                         finish { ambient 0.2
                                  phong 1 }
                       }
#declare Knurls =
              union {
                     object { Lump }
                     object { Lump rotate 30*x }
                     object { Lump rotate 60*x }
                     object { Lump rotate 90*x }
                     object { Lump rotate 120*x }
                     object { Lump rotate 150*x }
                     object { Lump rotate 180*x }
                     object { Lump rotate 210*x }
                     object { Lump rotate 240*x }
                     object { Lump rotate 270*x }
                     object { Lump rotate 300*x }
                     object { Lump rotate 330*x }
                    }
#declare Knob =
             union {
                    object { Knurls translate 11.5*y }
                    cylinder { < 4.8, 11.5, 0 >,< 5.5, 11.5, 0 >,1.3 }
                    sphere { < 0, 0, 0 >,1.3  scale < 0.25, 1, 1 >
                              translate < 5.5, 11.5, 0 >
                           }
                         pigment { color Gray25 }
                         finish { ambient 0.2
                                  phong 1 }
                   }
#declare Pin =                     
          union {
             torus { 0.065, 0.04 rotate 90*x
                    clipped_by {
                            box { < -1, 0, -1 >,< 0, 1, 1 > }
                               }
                        translate -0.065*y
                   }
             cylinder { < 0, 0, 0 >,< 0.5, 0, 0 >,0.04 }         
             cylinder { < -1, 0, 0 >,< 0, 0, 0 >,0.04 
                           rotate 60*z } 
                       translate -0.5*x
                       pigment { color Yellow }      
                       finish { ambient 0.2 }
                 }

#declare Control =                                      // controls
             union {
                   cylinder { < 0, 11.5, 0 >, < 5.5, 11.5, 0 >, 0.3 }
                   object { Nut translate < 2.9, 11.5, 0 > }
                   object { Nut translate < -3.8, 11.5, 0 > }  
                   object { Nut scale 0.6 translate < -4.4, 11.5, 0 > }  
                   cylinder { < 4.5, 11.5, 0 >, < 4.8, 11.5, 0 >, 0.6 }
                   object { Knob }
                   object { Pin translate < -4.4, 11.5, 0 > }
                        pigment { color Gray75 }
                   }
#declare Optic =                                // Glass
                lathe {
                       cubic_spline
                       33,
                   < 3.85, 0.25 >,< 3.97, 0 >,< 4.1, 0.25 >,< 4.2, 0.75 >,
                   < 4.3, 1 >,< 4.55, 1.5 >,< 4.95, 2.5 >,< 5.2, 3.5 >,
                   < 5.35, 4.5 >,< 5.35, 5.5 >,< 5.2, 6.5 >,< 4.95, 7.5 >,
                   < 4.55, 8.5 >,< 4.3, 9.0 >,< 4.2, 9.25 >,< 4.1, 9.75 >,
                   < 3.97, 10 >, < 3.85, 9.75 >,
                   < 3.95, 9.25 >,< 4.05, 9.0 >,< 4.3, 8.5 >,< 4.7, 7.5 >,
                   < 4.95, 6.5 >,< 5.1, 5.5 >,< 5.1, 4.5 >,< 4.95, 3.5 >,
                   < 4.7, 2.5 >,< 4.3, 1.5 >,< 4.05, 1 >,
                   < 3.85, 0.25 >,< 3.95, 0.75 >,< 3.97, 0 >,< 4.1, 0.25 >
                        texture { 
                                pigment { color rgbf < 1, 1, 1, 0.85  > }
                                finish { F_Glass1 }
                       }
#declare Mantle =                            // main light source
              light_source { < 0, 20.5, 0 > color White
                        looks_like {
                                 sphere { < 0, 0, 0 >,2
                                          scale < 0.75, 1, 0.75 >
                                          pigment { color White }
                                          finish { ambient 1
                                                    diffuse 0 
                                                  }
                                        }
                                    }
                            }
#declare Hat =
                lathe {
                       cubic_spline
                       12,
                   < -0.1, 0 >,< 6.87, 0 >,< 6.88, 1.15 >,
                   < 6.87, 1.25 >,< 6, 1.5 >,< 5, 1.8 >,< 4.7, 2.2 >,
                   < 4.5, 3 >,< 4.25, 4 >,< 3, 4.5 >,< 0, 4.5 >,
                   < -0.1, 4.5 >
                   clipped_by {
                              box { < -9, 1, -9 >,< 9, 6, 9 > }  
                              }
                            pigment { color rgb < 0.3, 0.5, 0.2 > }
                            finish { ambient 0.2 
                                     phong 1 }
                      } 
                      
#declare Half =
              union {
                    torus { 1, 0.2 rotate 90*x  
                            clipped_by {
                               box { < -1.5, 0, -0.5 >,< 0, -1.5, 0.5 > }
                                       }
                           translate -4.5*x
                          }
                    cylinder { < -5.5, 0, 0 >,< -5.5, 14, 0 >,0.2 }
                         translate 1*y
                         pigment { color Gray75 }
                         finish { ambient 0.2 }
                      }

                     
#declare Handle =                                   // wire handle
                union {
                    torus { 5.5, 0.2 rotate 90*x   scale < 1, 1.5, 1 >
                            translate 14*y
                            clipped_by {
                               box { < -7, 13.98, -0.5 >,< 7, 25, 0.5 > }
                                       }    
                          }
                    object { Half }
                    object { Half rotate 180*y }
                       pigment { color Gray75 }
                       finish { ambient 0.2 }
                      }

                     
#declare Drl =                                        // holes in top vent
             cylinder { < -4, 0, 0 >,< 4, 0, 0 >,0.22 
                            pigment { color rgb < 0.3, 0.5, 0.2 > }
                            finish { ambient 0.2 }
                      }
#declare Rad =
             union {
                    object { Drl }
                    object { Drl rotate 9*y }
                    object { Drl rotate 18*y } 
                    object { Drl rotate 27*y } 
                    object { Drl rotate 36*y } 
                    object { Drl rotate 45*y } 
                    object { Drl rotate 54*y }
                    object { Drl rotate 63*y }
                    object { Drl rotate 72*y }
                    object { Drl rotate 81*y } 
                    object { Drl rotate 90*y } 
                    object { Drl rotate 99*y } 
                    object { Drl rotate 108*y } 
                    object { Drl rotate 117*y } 
                    object { Drl rotate 126*y } 
                    object { Drl rotate 135*y } 
                    object { Drl rotate 144*y }  
                    object { Drl rotate 153*y } 
                    object { Drl rotate 162*y } 
                    object { Drl rotate 171*y } 
                    }
#declare Smok =                    
          union {
                object { Rad }
                object { Rad rotate 4.5*y translate 0.5*y }
                object { Rad translate 1*y }
                object { Rad rotate 4.5*y translate 1.5*y } 
                object { Rad translate 2*y } 
                   translate 26.5*y 
                }
                       
#declare Topvent =
                 difference {
                            cylinder { < 0, 25.5, 0 >,< 0, 29, 0 >,3.25 }
                            object { Smok }
                            pigment { color rgb < 0.3, 0.5, 0.2 > }
                            finish { ambient 0.2 }
                            }
#declare Lid =
             union {
                    sphere { < 0, 0, 0 >,4.25  scale < 1, 0.21, 1 >
                              translate 0.5*y
                           }
                    cylinder { < 0, -0.1, 0 >,< 0, 0.5, 0 >,4.25 }
                      clipped_by {
                             cylinder { < 0, 0, 0 >,< 0, 2, 0 >,5 }
                                 }
                            pigment { color rgb < 0.3, 0.5, 0.2 > }
                            finish { ambient 0.2 }
                   }
#declare Screw =                               // nut at top of lamp
              union { 
                    cylinder { < 0, 25.5, 0 >,< 0, 32, 0 >,0.6 }
                    cylinder { < 0, 30, 0 >,< 0, 30.2, 0 >,0.8 }
                    cylinder { < 0, 30.6, 0 >,< 0, 31.4, 0 >,0.9 }
                      pigment { color rgb < 0.6, 0.4, 0.45 > }
                      finish { ambient 0.2 }
                     }
#declare Post =
             cylinder { < -3.5, 13.5, 0 >,< -3.5, 23, 0 >,0.45
                       pigment { color Gray70 }
                      }
#declare Line =                                             // fuel line
             cylinder { < -1.9, 5, 0 >,< -1.9, 23, 0 >,0.3
                       pigment { color Gray70 }
                      }
#declare Hoop =                                             // fuel line
             torus { 1.2, 0.4   rotate 90*x 
                 pigment { color Gray70 }
                   }
#declare Airin =
              cylinder { < 3.5, -0.1, 0 >,< 3.5, 0.1, 0 >,0.2 
                           pigment { color rgbt < 1, 1, 1, 1 > }
                       }
#declare Lovent =
               union {
                      object { Airin }
                      object { Airin rotate 20*y }
                      object { Airin rotate 40*y }
                      object { Airin rotate 60*y }
                      object { Airin rotate 80*y }
                      object { Airin rotate 100*y }
                      object { Airin rotate 120*y }
                      object { Airin rotate 140*y }
                      object { Airin rotate 160*y }
                      object { Airin rotate 180*y }
                      object { Airin rotate 200*y }
                      object { Airin rotate 220*y }
                      object { Airin rotate 240*y }
                      object { Airin rotate 260*y }
                      object { Airin rotate 280*y }
                      object { Airin rotate 300*y }
                      object { Airin rotate 320*y }
                      object { Airin rotate 340*y }
                    }
#declare Bplate =
           difference {
                 cylinder { < 0, 13.5, 0 >,< 0, 14.5, 0 >,4.5
                     clipped_by {
                              cylinder { < 0, 13, 0 >,< 0, 14.25, 0 >,5 }
                                 }
                      texture { T_Chrome_5C }  
                           }
                 object { Lovent translate 13.5*y }
                      }
                      }
             
// COLEMAN LANTERN
 #declare Light =
            union {  
object { Tank  }
object { Collar translate 9*y }
object { Bplate }
object { Optic translate 13.5*y }
object { Mantle }
object { Hat translate 21.5*y }
object { Topvent }
object { Lid translate 28.5*y }
object { Screw }
object { Post }
object { Post rotate 180*y }
object { Line }
object { Hoop translate < -1.2, 26.2, 0 > }
object { Control }
object { Handle rotate 45*x translate 24.5*y }
object { Pump rotate 40*x translate < -1, 4, 0 > }
object { Filler  }
                  }
object { Light rotate 35*y }

// CLOUD OF BUGS
#declare Abug =                                           // flying ant
     union {
        sphere { < 0, 0, 0 >,1 pigment { color Gray55 } }   // head
        sphere { < 0, 0, 0 >,1 scale < 1.5, 1, 1 >            // thorax
                  translate 2.5*x
                  pigment { color Gray65 } 
               }  
        sphere { < 0, 0, 0 >,1 scale < 3, 1, 1 >            // body
                  rotate -20*z
                  translate < 7, -1, 0 >
                  pigment { color Gray75 } 
               }  

        sphere { < 0, 0, 0 >,1                              // l wing
                 scale < 1.5, 0.01, 4 >
                 rotate 45*x
                 translate < 2.5, 3, -4 > 
                 pigment { color rgbt < 1, 1, 1, 0.75 > }       
                 finish { ambient 0.2 }
               }
        sphere { < 0, 0, 0 >,1                               // r wing
                 scale < 1.5, 0.01, 4 >
                 rotate -45*x
                 translate < 2.5, 3, 4 > 
                 pigment { color rgbt < 1, 1, 1, 0.75 > }       
                 finish { ambient 0.2 }
               }
        sphere { < 0, 0, 0 >,1                              // l f wing
                 scale < 1.5, 0.01, 4 >
                 rotate 60*x
                 translate < 3, 3.3, -2.5 > 
                 pigment { color rgbt < 1, 1, 1, 0.75 > }       
                 finish { ambient 0.2 }
               }
        sphere { < 0, 0, 0 >,1                               // r f wing
                 scale < 1.5, 0.01, 4 >
                 rotate -60*x
                 translate < 3, 3.3, 2.5 > 
                 pigment { color rgbt < 1, 1, 1, 0.75 > }       
                 finish { ambient 0.2 }
               }
              scale 0.1
              rotate -20*z
            }  
#declare Lwing =            
         union {                                       
               disc { < 0, 0, 0 >,< 0, 1, 0 >,4
                      scale < 0.65, 1, 1 >
                      translate < 6, 0, -5 >
                    }
               triangle { < 1, 0, 0 >,< 7, 0, 0 >,< 4, 0, -7 > }
                   pigment { color rgb < 1, 0.8, 0.4 > }
                   finish { ambient 0.2 }
               }
#declare Rwing =
         union {                                       
               disc { < 0, 0, 0 >,< 0, 1, 0 >,4
                      scale < 0.65, 1, 1 >
                      translate < 6, 0, 5 >
                    }
               triangle { < 1, 0, 0 >,< 7, 0, 0 >,< 4, 0, 7 > }
                   pigment { color rgb < 1, 0.8, 0.4 > }
                   finish { ambient 0.2 }
               }

            
#declare Bbug =                                           // moth

     union {
        sphere { < 0, 0, 0 >,0.5   translate 0.5*x
                   pigment { color Orange } }   // head 
        sphere { < 0, 0, 0 >,0.5  translate -0.5*z      // eye
                   pigment { color Black } 
                   finish { ambient 0.2
                            reflection 0.4 }   
               }             
        sphere { < 0, 0, 0 >,0.5  translate 0.5*z      // eye
                   pigment { color Black } 
                   finish { ambient 0.2
                            reflection 0.4 }   
               }             

          
        sphere { < 0, 0, 0 >,1 scale < 1.5, 1.25, 1.25 >            // thorax
                  translate 2*x
                  pigment { color Orange } 
                  finish { ambient 0.3 }
               }  
        sphere { < 0, 0, 0 >,1 scale < 2.6, 1.2, 1.2 >            // body
                  rotate -10*z
                  translate < 5.5, -0.5, 0 >
                  pigment { color rgb < 1, 0.8, 0.4 > } 
                  finish { ambient 0.3 }
               }  
        object { Lwing translate 1*y }
        object { Rwing translate 1*y }
              scale 0.12
              rotate -75*z
            }  
#declare Cbug =                                             // moth

     union {
        sphere { < 0, 0, 0 >,0.5   translate 0.5*x
                   pigment { color Orange } }   // head 
        sphere { < 0, 0, 0 >,0.5  translate -0.5*z      // eye
                   pigment { color Gray45 } 
                   finish { ambient 0.2
                            reflection 0.4 }   
               }             
        sphere { < 0, 0, 0 >,0.5  translate 0.5*z      // eye
                   pigment { color Gray45 } 
                   finish { ambient 0.2
                            reflection 0.4 }   
               }             

          
        sphere { < 0, 0, 0 >,1 scale < 1.65, 1.2, 1.2 >            // thorax
                  translate 2*x
                  pigment { color rgb < 1, 0.8, 0.4 > } 
                  finish { ambient 0.3 }
               }  
        sphere { < 0, 0, 0 >,1 scale < 2.85, 1.15, 1.15 >            // body
                  rotate -10*z
                  translate < 4.5, -0.5, 0 >
                  pigment { color rgb < 1, 0.8, 0.4 > } 
                  finish { ambient 0.3 }
               }  
        object { Lwing rotate 60*x translate 1*y }
        object { Lwing scale 0.75 rotate 60*x translate < 1.5, 1.2, 0 > }   
        object { Rwing rotate -60*x translate 1*y }
        object { Rwing scale 0.75 rotate -60*x translate < 1.5, 1.2, 0 > }  
              scale 0.18
              rotate -35*z
            }  
// New Moth  11/4/98
#declare Patn =
             texture {
                      pigment {
                               gradient x
                               turbulence 0.5
                               color_map {
                                          [ 0.0 color rgb < 0.5, 0.6, 0.1 > ]
                                          [ 0.3 color rgb < 0.5, 0.4, 0.2 > ]
                                          [ 0.6 color rgb < 0.5, 0.6, 0.1 > ]
                                          [ 0.9 color rgb < 0.6, 0.4, 0.2 > ]
                                          [ 1.0 color rgb < 0.5, 0.6, 0.1 > ]
                                          }
                                      scale 0.75
                                      
                              }
                       normal { bumps 0.3 scale 0.5 }
                       finish { ambient 0.2 }
                     }
#declare Awing =                                // wing panel
              union {
                     disc { < 0, 0, 0 >,< 0, 1, 0 >,2
                               scale < 1, 1, 0.75 >
                               translate 6.5*z
                          }
                     triangle { < 0, 0, 0 >,< -2, 0, 6.5 >,< 2, 0, 6.5 > }
                     texture { Patn }   
                     }
#declare Bwing =                                          // left wing
             union {                                      
               object { Awing scale < 1.1, 1, 1 > }
               object { Awing scale < 1.4, 1, 0.8 > 
                         rotate -30*y
                         translate -0.25*y
                      }
                   }
#declare Cwing =                                           // right wing
             union {
               object { Awing scale < 1.1, 1, 1 > rotate -180*x }
               object { Awing scale < 1.4, 1, 0.8 > 
                         rotate < -180, 30, 0 >
                         translate -0.25*y
                      }
                   }

#declare Pairw =                                    // wings down
             union {
                    object { Bwing rotate 20*x }
                    object { Cwing rotate -20*x }
                   }
#declare Upairw =                                    // wings up
             union {
                    object { Bwing rotate -60*x }
                    object { Cwing rotate 60*x }
                   }

#declare Cell =
             sphere { < 0, 0, 0 >,1    scale < 1.25, 1, 1 >
                       pigment { color Orange }
                       normal { bumps 0.8 scale 0.25 }
                       finish { ambient 0.2 }
                    }
#declare Bodd =
              union {                      
                    object { Cell scale < 1, 1.5, 1.5 > }
                    object { Cell scale < 1, 1.5, 1.5 > 
                              translate -1*x }    
                    object { Cell scale < 1, 1.25, 1.25 > 
                              translate -2*x }   
                    object { Cell scale < 1, 0.9, 0.9 > 
                              translate -3*x }   
                    object { Cell scale < 1, 0.7, 0.7 > 
                              translate -4*x }   
                    object { Cell scale < 1, 0.5, 0.5 > 
                              translate -5*x }   
                    sphere { < 0, 0, 0 >,1          
                              scale < 1, 0.5, 1 > 
                              rotate -20*z
                              translate < 1, 1, 0 > 
                              texture { Patn }
                           }   
                    object { Cell scale < 1, 1.2, 1 >
                              translate 1*x }  
                              
                    }
#declare Vis =
             sphere { < 0, 0, 0 >,0.3 scale < 1, 2, 1 >
                     pigment { color rgb < 0.2, 0.2, 0.23 > }
                     finish { ambient 0.5 }
                    }
#declare Annt =
             sphere { < 0, 0, 0 >,1
                      scale < 0.1, 1.85, 0.1 >
                      pigment { color Yellow }
                      finish { ambient 0.2 }
                    }
#declare Amoth =
      union {
object { Annt rotate < 45, 0, -45 > translate < 2.5, 1.6, 2.5 > }
object { Annt rotate < -45, 0, -45 > translate < 2.5, 1.6, -2.5 > }       
 // antennae above (2), legs below (6)
object { Annt rotate < 0, 0, -65 > translate < 0, -1, 0.5 > }
object { Annt rotate < 0, 0, -65 > translate < 0, -1, -0.5 > }       
object { Annt rotate < 0, 0, -65 > translate < -1, -1, 0.5 > }
object { Annt rotate < 0, 0, -65 > translate < -1, -1, -0.5 > }       
object { Annt rotate < 0, 0, -65 > translate < -1.5, -1, 0.5 > }
object { Annt rotate < 0, 0, -65 > translate < -1.5, -1, -0.5 > }       
 // probos
object { Annt scale 0.5 rotate < 0, 0, -35 > translate < 1.6, -1, 0 > }  

object { Vis translate < 2, 0.4, -0.5 > }            // eyes
object { Vis translate < 2, 0.4, 0.5 > }  
object { Pairw translate  < 0.8, 1.5, 0 > }
object { Bodd }
      scale 0.3    
            }
#declare Bmoth =
      union {
object { Annt rotate < 45, 0, -45 > translate < 2.5, 1.6, 2.5 > }
object { Annt rotate < -45, 0, -45 > translate < 2.5, 1.6, -2.5 > }       
 // antennae above (2), legs below (6)
object { Annt rotate < 0, 0, -65 > translate < 0, -1, 0.5 > }
object { Annt rotate < 0, 0, -65 > translate < 0, -1, -0.5 > }       
object { Annt rotate < 0, 0, -65 > translate < -1, -1, 0.5 > }
object { Annt rotate < 0, 0, -65 > translate < -1, -1, -0.5 > }       
object { Annt rotate < 0, 0, -65 > translate < -1.5, -1, 0.5 > }
object { Annt rotate < 0, 0, -65 > translate < -1.5, -1, -0.5 > }       
 // probos
object { Annt scale 0.5 rotate < 0, 0, -35 > translate < 1.6, -1, 0 > }  

object { Vis translate < 2, 0.4, -0.5 > }            // eyes
object { Vis translate < 2, 0.4, 0.5 > }  
object { Upairw translate  < 0.8, 0, 0 > }
object { Bodd }
        scale 0.3 
            }

// flying ants
object { Abug rotate 180*y  translate < -8, 23, 5 > }  
object { Abug rotate 90*y  translate < -12, 17, -4 > }  
object { Abug rotate 250*y  translate < -9, 11, 6 > }
object { Abug translate < 2, 15, -6 > }  
object { Abug rotate -70*x  translate < 11, 18, 4 > }  
object { Abug rotate < 90, 0, -90 >  translate < 15, 30, -10 > }
object { Abug rotate < 90, 180, 0 >  translate < 11, 20, 4 > }
object { Abug rotate < 90, 180, 0 >  translate < 21, 22, -4 > } 
object { Abug rotate 140*y  translate < -16, 0.1, 25 > }  
object { Abug rotate 45*y  translate < -10, 0.1, -20 > }  
object { Abug rotate -120*y  translate < -12, 0.2, -18 > }   
object { Abug rotate -45*y  translate < -14, 0.2, -20 > }  
object { Abug rotate 120*y  translate < -16, 0.3, -18 > }   


// moths
object { Bbug rotate < -90, -90, 0 >  translate < -2.5, 19, -8 > }  
object { Bbug rotate 45*x  translate < 26, 16, 6 > }
object { Bbug rotate < -45, 0, -45 >  translate < 12, 16, -5 > }   

object { Cbug rotate -60*z  translate < 7, 13, -6 > }  
object { Cbug rotate 30*x  translate < 9, 29, 5 > }
object { Cbug rotate 140*y  translate < 12, 5, 9 > } 

object { Amoth rotate < -30, 20, -30 >  translate < -14, 28, 8 > }     
object { Amoth rotate < 0, -40, 5 >  translate < -22, 0.25, -18 > }     
#declare Wbug =
object { Amoth rotate < 20, -20, 35 >  translate < -34, 22, 22 > }   
object { Wbug rotate 15*y }  // because wall is rotated
object { Bmoth rotate < 30, -70, 0 >  translate < 5, 1, -33 > }  // best

 // MATCHBOX and MATCHES
#declare Lbox =
          union {
             box { < 0, 0, 0.01 >,< 5, 3.5, 1.5 > 
                pigment { color rgb < 0.4, 0.35, 0.3 > }
                finish { ambient 0.2 }
                 }
             box { < 0, 0, 0 >,< 5, 3.5, 0.01 >
                 pigment { 
                          image_map { 
                                     gif "match.gif" once
                                    }
                              scale < 5, 3.5, 1 >
                         }
                 finish { ambient 0.3 
                          diffuse 0.2 }
                 }
                 }
#declare Mbox =
             difference {
                     object { Lbox }
                     box { < 4.8, 0.01, 0.015 >,< 5.5, 3.45, 1.45 >
                           pigment { color rgb < 0.5, 0.4, 0.6 > }
                           finish { ambient 0.1 }
                         }
                        }   
object { Mbox rotate < 90, 25, 0 > translate < -15, 1.5, -30 > }
#declare Amatch =
           union {
                 box { < 0, 0, 0 >,< 2, 0.2, 0.2 >
                    pigment { color rgb < 0.9, 0.9, 0.6 > }
                    finish { ambient 0.2 }
                     }
                 cone { < 1.95, 0.1, 0.1 >,0.08,< 2.2, 0.1, 0.1 >,0.06
                         pigment { color Gray50 }
                         finish { ambient 0.1 }
                      }
                 cone { < 2.15, 0.1, 0.1 >,0.06,< 2.8, 0.1, 0.3 >,0.05
                         pigment { color Black }
                         finish { ambient 0.1 }
                      }
                 cone { < 2.7, 0.1, 0.3 >,0.05,< 3, 0.3, 0.6 >,0.045
                         pigment { color Black }
                         finish { ambient 0.1 }
                      }
                 cone { < 2.9, 0.3, 0.6 >,0.045,< 3.3, 0.1, 0.5 >,0.04
                         pigment { color Black }
                         finish { ambient 0.1 }
                      }
                 sphere { < 0, 0, 0 >,0.06 scale < 1.5, 1, 1 >
                         translate  < 3.3, 0.1, 0.5 >
                         pigment { color Black }
                         finish { ambient 0.1 }
                        }
                  }
object { Amatch rotate -125*y translate < -8, 0, -22 > }
object { Amatch  translate < -6, 0, -18 > } 
#declare Bmatch =
           union {
                 box { < 0, 0, 0 >,< 1.5, 0.2, 0.2 >
                    pigment { color rgb < 0.9, 0.9, 0.6 > }
                    finish { ambient 0.2 }
                     }
                 cone { < 1.45, 0.1, 0.1 >,0.08,< 2, 0.1, 0.2 >,0.076
                         pigment { color Gray50 }
                         finish { ambient 0.1 }
                      }
                 cone { < 1.8, 0.1, 0.2 >,0.06,< 2.8, 0.1, 0.4 >,0.05
                         pigment { color Black }
                         finish { ambient 0.1 }
                      }
                 cone { < 2.7, 0.1, 0.4 >,0.05,< 3.2, 0.3, 0.6 >,0.045
                         pigment { color Black }
                         finish { ambient 0.1 }
                      }
                 cone { < 3.2, 0.3, 0.6 >,0.045,< 3.4, 0.1, 0.8 >,0.04
                         pigment { color Black }
                         finish { ambient 0.1 }
                      }
                 sphere { < 0, 0, 0 >,0.06 scale < 1, 1, 1.5 >
                         translate  < 3.4, 0.1, 0.8 >
                         pigment { color Black }
                         finish { ambient 0.1 }
                        }
                  }
object { Bmatch rotate 75*y translate < -8, 0, -25 > } 
