//candles.inc by CJ
#ifndef (DripCount)
#declare DripCount = 10
#end
#ifndef (height)
#declare height = 4
#end
#ifndef (Radius)
#declare Radius = .5
#end

#declare RS1 = seed(420)
#declare RS2 = seed (569)
#declare RS3 = seed(6969)

#ifndef (CandleColor)
#declare CandleColor = rgb <244/255, 244/255, 210/255>
#end

#declare C_WickBottom = rgb 0

#declare C_WickTop = rgb<1,0,0>

#declare T_Wick =
texture{
  pigment{
    gradient y
    pigment_map {
      [0.0 color C_WickBottom]
      [1.0 bozo
        color_map{
          [0.0 C_WickBottom]
          [1.0 C_WickTop]
        }
      ]
    }
  }
  finish{ambient 1}
}

///////////////////////


#declare O_Flame =
union{

  sphere{
    <0, 0, 0>, 1
    hollow
    no_shadow
    finish{ambient 1}
    pigment { color rgbf <1, 1, 1, 1> }

    halo {
      emitting
      spherical_mapping
      linear
      turbulence 0.2
      color_map {
        [ 0.0 color rgbt <1.0, 0.6, 0.0,  1> ]
        [ 0.5 color rgbt <1.0, 1.0, 0.8, -1> ]
        [ 1.0 color rgbt <1.0, 0.7, 0.0,  1> ]
      }
      samples 30
      scale 0.5
    }
    scale <Radius/2,height/3,Radius/2>
  }

scale height/3
translate <0,height,0>
}

#declare O_CandleBody =
difference{
  cylinder{
    <0,0,0>,
    <0,2,0>, 1
  }
  sphere{<0,20,0>, 19.1}
  intersection{
    height_field{
      gif
      "plasma3.gif"
      smooth
    }
    box{0,1}
    translate -0.5
    scale<1,1.25,1>
    rotate x*180
    translate y*1.0
    scale <10,1,10>
  }
texture{
  gradient y
  texture_map{
    [0.0 pigment{color CandleColor} finish{ambient 0.7}]
    [0.5 pigment{color CandleColor} finish{ambient 0}]
    [1.0 pigment{color CandleColor} finish{ambient 0}]
  }
  translate -0.5*y
  rotate z*180
  translate y*0.5
}
scale <Radius, height, Radius>
}

#declare CandleWax =
  #declare Drips = DripCount
  blob{
    threshold 0.01
    #while (Drips > 0)
      #declare Height = height - (height*.1428)
      #declare Stop = rand(RS1)*Height
      #declare Rotate = (360/(DripCount))*Drips
      #while (Height > Stop)
        #declare Size = rand(RS3);
        sphere{<0, Height, -Radius>, (Radius*.025)+Size/60, (Radius/2)+Size/65 rotate y*Rotate}
        sphere{<0, Height-0.01, -Radius>, ((Radius*.030)+Size/30)*1.5, ((Radius/1.75)+Size/35)*1.5 rotate y*Rotate}
        #declare Height = Height - 0.03
      #end //(While Height > Stop)
      #declare Drips = Drips-1
    #end //(While drips > 0)
    sphere{0, Radius+0.1, Radius+0.1 scale <1,1/2,1> translate (Radius/2*rand(RS1))*x + (Radius/2*rand(RS3))*z}
    texture{ gradient y
  texture_map{
    [0.0 pigment{color CandleColor} finish{ambient 0.7}]
    [0.5 pigment{color CandleColor} finish{ambient 0}]
    [1.0 pigment{color CandleColor} finish{ambient 0}]
  }
  translate -0.5*y
  rotate z*180
  translate y*0.5 scale <Radius, height, Radius>}
    clipped_by{box{<-Radius*4, 0, -Radius*4>,<Radius*4, height*4, Radius*4>}}
  }//blob

#declare Candle =
union{
  object{O_CandleBody}
  object{O_Flame translate y*0.85}
  object{CandleWax}
}

