global_settings {max_trace_level 30}
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "woods.inc"
#include "plant.inc"
#include "ash.map"
#include "stones.inc"
#include "skies.inc"
#include "whiteash.map"
#include "stones.inc"
#include "metals.inc"

#default {finish {phong_size 10000 phong 0.2 ambient .1 diffuse .8}}

//Hintergund
fog { distance 100 color Gray10 fog_type 2 fog_offset 2 fog_alt 10 turbulence 1}
difference {
plane { y, 0 pigment { image_map {gif "grasst.gif" interpolate 2 map_type 0}}normal{bump_map{gif "grass.gif" bump_size 10 map_type 0 }
scale <.2,10,.2>rotate x*90}finish { ambient 0.1 diffuse  .1 crand 0.2}}
cylinder {<30,0,50><30,0,-100>,10 pigment {Yellow}finish {ambient 0.1 diffuse 0.3 crand 0.1} scale <1,.2,1>}
}
plane { y,-.5  texture {pigment {color rgb<0.0,0.1,0.2,>}normal { bumps .8 scale .5}
finish {phong 1 reflection .5 ambient 0.1 diffuse 0.5}}}

//Kanal
union {
box { <20,20,50>,<40,22,200>}
box { <20,20,50>,<18,23,200>}
box { <40,20,50>,<42,23,200>}
difference {
cylinder {<30,0,55><30,0,60>,10 scale <1,2,1>}
cylinder {<30,0,54><30,0,61>,8 scale <1,2,1>}
}
difference {
cylinder {<20,0,50><22,0,50>,20 scale <1,1,2.7>}
cylinder {<19,0,50><23,0,50>,16 scale <1,1,2.7>}
}
difference {
cylinder {<40,0,50><38,0,50>,20 scale <1,1,2.7>}
cylinder {<41,0,50><27,0,50>,16 scale <1,1,2.7>}
}
pigment {bozo color_map {[0 rgb <.5, .475, .45>] [1 rgb <.7, .7, .65>]}
scale 4 }normal {bumps 1 scale .2}finish {ambient .1 diffuse .4}
}

// SPRAY OPTIONS
#declare spray_location = <30, 22, 50>
#declare spray_direction = -z
#declare spray_strength = 2
#declare spray_angle = 0
#declare spray_loop = true

#declare particle_life = 2
#declare particle_count = 300
#declare particle_size = 8
#declare particle_stretch = 6
#declare particle_dist = 1
#declare particle_sep = 1.5

#declare nozzle_width = 18
#declare nozzle_angle = 0

#declare spray_turb = .2
#declare spin_turb = 10

#declare use_blob = true
#declare spray_texture = texture {
pigment {color rgbt<0,0.1,0.2,.8>}
finish {phong 1 reflection .5 ambient 0.1 diffuse 0.5}}
#include "Spray.inc"


//Starfield
// COMMON GALAXY OPTIONS
   #declare galaxy_colour1 = <1.3, 1.2, .9>
   #declare galaxy_colour2 = <.4, .8, 1>
   #declare galaxy_seed = -.4*2e5
   #include "GALAXY.INC"

// STARFIELD BACKGROUND
   #declare galaxy_bgstars = 2
   #declare galaxy_bgnebula = false
   #declare galaxy_nebula_sphere = false
   #include "GALAXY.BG"
// OBJECTS
   #declare galaxy_object_name = concat("Comet", str(1,0,0))
   #declare galaxy_object_position = <5,20, 999>
   #include "GALAXY.OBJ"

   #declare galaxy_object_name = concat("Meteor", str(1,0,0))
   #declare galaxy_object_position = <20,0, 999>
   #include "GALAXY.OBJ"

   #declare galaxy_object_name = concat("Star", str(2,0,0))
   #declare galaxy_object_position = <10,-20, 999>
   #include "GALAXY.OBJ"


   #declare galaxy_object_name = concat("Star", str(4,0,0))
   #declare galaxy_object_position = <15,5, 999>
   #include "GALAXY.OBJ"

//Wolken
box {<-1000,100,-1000><1000,110,1000>texture {T_Cloud1}scale <20,1,30>}

//Brcke
union {
difference {
cylinder {<30,0,15><30,0,16>,12 scale <1,.2,1>}
cylinder {<30,0,14><30,0,18>,8 scale <1,.2,1>}
}
difference {
cylinder {<30,0,5><30,0,4>,12 scale <1,.2,1>}
cylinder {<30,0,6><30,0,2>,8 scale <1,.2,1>}
}
difference {
cylinder {<30,0,4><30,0,16>,10 scale <1,.2,1>}
cylinder {<30,0,2><30,0,18>,8 scale <1,.2,1>}
}
difference {
cylinder {<30,18,15><30,18,16>,12 scale <1,.2,1>}
cylinder {<30,18,14><30,18,18>,8 scale <1,.2,1>}
box {<17,3.6,14><43,-1,18>}
}
difference {
cylinder {<30,18,4><30,18,5>,12 scale <1,.2,1>}
cylinder {<30,18,2><30,18,6>,8 scale <1,.2,1>}
box {<17,3.6,2><43,-1,6>}
}
box {<18,3.6,4><22,0,5>}
box {<18,3.6,15><22,0,16>}
box {<38,3.6,4><42.0,0,5>}
box {<38,3.6,15><42.0,0,16>}
pigment{color rgbf <0.8, 0.8, 0.2, 0.5>}
finish { ambient 0.1 diffuse 0.8 specular 1.0 roughness 0.001 reflection 0.25 refraction on  ior 1.5 crand .05 caustics 1}
translate z*-2.5
}

//Decke &Boden
box {<-25,10.9,-6><7,12.5,21>
pigment {Gray}
normal {crackle scale 0.26}
}
difference {
box {<-25,0,-6><7,2,21>}
box {<-10,1.2,-4><5,3,18>}
texture { T_Stone34}
}

//Rand
#declare Obj1 =
lathe { cubic_spline  24
<5.270493, 5.515257>,<0.80601, 3.609162>,
<1.669128, 2.901066>,<1.640829, 2.646325>,
<0.611859, 1.814175>,<0.77713, 1.101017>,
<1.457466, 0.943865>,<1.230494, 0.665398>,
<0.70789, 0.282782>,<0.975803, -0.027926>,
<1.28918, -0.185078>,<1.786756, -0.306853>,
<1.448164, -0.707005>,<1.519189, -1.000177>,
<1.594251, -1.381035>,<1.069075, -1.505035>,
<0.78249, -1.892175>,<1.048598, -2.902829>,
<1.639584, -3.628213>,<2.201508, -4.878769>,
<1.967888, -5.297659>,<0.962551, -5.437289>,
<0.599512, -7.056999>,<2.364804, -10.850472>
rotate <180,0,180>
pigment {P_WoodGrain3A}
scale <.2,.4,.2>
translate <0,1.5,0>
}

difference {
union {
#declare zwert = -49/4
#while (zwert <= 49/4 )
object { Obj1 translate <0,0,zwert> translate <6,2,7.5>}
#declare zwert = zwert+2
#end

#declare xwert = -32/4
#while (xwert <= 32/4 )
object { Obj1 translate <xwert,0,0> translate <-2,2,-5>}
#declare xwert = xwert+2
#end

#declare xwert = -32/4
#while (xwert <= 32/4 )
object { Obj1 translate <xwert,0,0> translate <-2,2,19.1>}
#declare xwert = xwert+2
#end

union {
box {<6.25,4.8,-5.25><5.75,5.5,19.5>}
box {<6.25,4.8,-5.25><-10,5.5,-4.75>}
box {<6.25,4.8,19><-10,5.5,19.5>}
cone {<6,5.5,19.1>, .25 <6,11,19.1>, .25 }
cone {<6,5.5,-5>, .25 <6,11,-5>, .25 }
pigment {P_WoodGrain3A}}
}
box {<4,0,4.25><7,10,10>pigment {P_WoodGrain3A}}
}
union {
box {<6.25,1,4.25><5.75,5.5,4.5>}
box {<6.25,1,10><5.75,5.5,10.25>}
pigment {P_WoodGrain3A}
}

//Treppe
cylinder {<6,0,7.5><6,.35,7.5>,5 texture { T_Stone34}}
cylinder {<6,0,7.5><6,.7,7.5>,4 texture { T_Stone34}}
cylinder {<6,0,7.5><6,1,7.5>,3 texture { T_Stone34}}
cylinder {<6,0,7.5><6,1.35,7.5>,2 texture { T_Stone34}}


//Fensterscheiben
box {<-10.05,9,6><-10.2,4,16> pigment {White filter .9}
finish { ambient 0.1 diffuse 0.0 phong 0.3 phong_size 90.0 reflection 0.1 refraction on ior 1.5 caustics 1.0}}
box {<-10.05,5,-3.5><-10.2,9.5,1.5>pigment {White filter .9}
finish { ambient 0.1 diffuse 0.0 phong 0.3 phong_size 90.0reflection 0.1 refraction on ior 1.5 caustics 1.0}}

//Wnde
union {
difference {
box {<-10,0,-6><-10.25,12,21>}
box {<-9,10,-4><-11,.5,2>}
box {<-9,9,6><-11,4,16>}
}
difference {
box {<-12,0,-6><-10.25,12,21>}
box {<-9,10,-4><-13,.5,2>}
box {<-9,9,6><-13,4,16>}
}
box {<-12,0,-6><-10.25,12,21>rotate y*90 translate <-31,0,9>}
box {<-12,0,-6><-10.25,12,21>rotate y*-90 translate <-16,0,5>}
box {<-12,0,-6><-10.25,12,21>translate <-25,0,0>}
texture {
pigment { brick Gray80, rgb<0.65, 0.3, 0.25> brick_size <3,1,2> mortar 0.15 }
normal { brick -10 brick_size <3,1,2> mortar 0.175 ramp_wave}
normal {crackle scale 0.26 }
finish { ambient 0.0 diffuse 0.8 } scale .5}
}

//Tr
difference {
box {<-9.75,.5,-4><-10.5,10,2>}
box {<-9,2,-3.5><-11,9.5,1.5>}
pigment {P_WoodGrain3A color_map { M_WhiteAsh }}
}
box {<-9.75,6,-3.5><-10.5,5.5,1.5>pigment {P_WoodGrain3A color_map { M_WhiteAsh }}}
box {<-9.9,6,-3.5><-10,2,1.5>pigment {Gray filter 1}}

#declare ywert = -3
#while (ywert <= 2 )
box {<-9.7,5.9,-3.5><-10,5.8,1.5> pigment {P_WoodGrain3A color_map { M_WhiteAsh }}
translate <-.5,ywert-2,0>}
#declare ywert = ywert+.2
#end

#declare zwert = -3
#while (zwert <= 2 )
box {<-9.7,2,-3.5><-10,6,-3.4>pigment {P_WoodGrain3A color_map { M_WhiteAsh }}
translate <-.5,0,zwert+3>}
#declare zwert = zwert+.2
#end

//Fenster
difference {
box {<-9.75,9,6><-10.5,4,16>}
box {<-9,8.5,6.5><-11,4.5,15.5>}
pigment {P_WoodGrain3A color_map { M_WhiteAsh }}
}
box {<-9.75,8.5,11><-10.5,4.5,11.5>pigment {P_WoodGrain3A color_map { M_WhiteAsh }}}

//Tisch
#declare Tischbein =
lathe { cubic_spline 8
<0.932998, -2.909548>,<0.613819, -1.954816>,
<0.893388, -1.208268>,<0.743719, -0.29062>,
<0.978568, 0.553851>,<0.790787, 1.268384>,
<0.360235, 1.872923>,<0.899497, 2.331658>
texture { T_Stone17 }
finish {reflection .2 phong 1 phong_size 1000}
}
union {
prism { linear_sweep cubic_spline -1.0,0.0 11
<2.147404, 0.874372>,<0.055276, 1.829146>,
<-1.41876, 1.427136>,<-2.080402, 0.022781>,
<-2.214405, -1.661642>,<-1.120352, -2.642379>,
<2.323283, -2.465662>,<2.742044, -0.892797>,
<2.147404, 0.874372>,<0.055276, 1.829146>,
<-1.41876, 1.427136> rotate <90,90,0>
texture { T_Stone17 }
finish {reflection .2 phong 1 phong_size 1000}
rotate <0,0,90> scale <1,.25,1> translate  <0,6,0>
}
object {Tischbein scale <.2,1,.2> translate <.75,4,1.5>}
object {Tischbein scale <.2,1,.2> translate <-1.75,4,1.5>}
object {Tischbein scale <.2,1,.2> translate <.75,4,-2>}
object {Tischbein scale <.2,1,.2> translate <-1.75,4,-2>}
scale <1.3,1,1.3> rotate y*180 translate <1,-2,14>
}

//Bank
#declare Obj2 =
difference {
prism { linear_sweep cubic_spline -1.0,0.0 18
<-0.556114, -0.127504>,<-0.815745, -0.39263>,
<-1.0, -1.0>,<-0.733369, -1.086114>,
<-0.031758, -1.07352>,<0.847759, -1.081795>,
<1.0, -1.0>,<0.80737, -0.397253>,
<0.572864, -0.167002>,<0.664992, 0.463124>,
<1.0, 1.0>,<0.80412, 1.034189>,
<-0.830371, 1.032811>,<-1.0, 1.0>,
<-0.656616, 0.467002>,<-0.556114, -0.127504>,
<-0.815745, -0.39263>,<-1.0, -1.0>
rotate x*90 scale <2,2,.5>
}
sphere {<0,1,0>,1 scale <1,.5,1>}
}
union {
object {Obj2}
object {Obj2 translate <0,0,-7.5>}
superellipsoid {<0.25, 0.25>scale <3,.3,5>translate <0,2.5,-4>}
scale .4 translate <-3,2,15>
texture{pigment {P_WoodGrain10A color_map { M_Wood15A }scale 2 rotate x*90}}
}

//Stuhl
union {
superellipsoid {<0.3, 0.2> scale <1,0.16,1> }
cone {<-0.9,1.78,-0.8>, 0.05 <-0.8,0,-0.7> 0.1}
cone {<0.9,1.78,-0.8>, 0.05 <0.8,0,-0.7> 0.1 }
cone {<0.6,1.78,-0.85>, 0.025 <0.55,0,-0.75> 0.05 }
cone {<-0.6,1.78,-0.85>, 0.025 <-0.55,0,-0.75> 0.05 }
cone {<0.3,1.78,-0.85>, 0.020 <0.25,0,-0.88> 0.045 }
cone {<-0.3,1.78,-0.85>, 0.020 <-0.25,0,-0.88> 0.045 }
cone {<0,1.78,-0.88>, 0.020 <0,0,-0.88> 0.045 }
difference {
superellipsoid {<0.5, 0.2> scale <1.05,0.22,0.1> translate <0,1.9,-0.82> }
superellipsoid {<0.5, 0.2> scale <0.75,0.1,0.9> translate <0,1.9,-0.82> } }
cone {<-1,-2,-1>, 0.07 <-0.8,0,-0.7> 0.12}
cone {<1,-2,-1>, 0.07 <0.8,0,-0.7> 0.12}
cone {<-1,-2,1>, 0.07 <-0.8,0,0.7> 0.12}
cone {<1,-2,1>, 0.07 <0.8,0,0.7> 0.12}scale 0.9
texture{pigment {P_WoodGrain10A color_map { M_Wood6A }scale 2 rotate x*90}
}
translate <1,3,8>
}

//Teppich
union {
#declare Obj3 =
union {
#declare zwert = -10
#while (zwert <= 10 )
superellipsoid {<0.25, 0.25>pigment {Aquamarine}
scale <2,.25,2> normal{bump_map{tga "bumps.tga" bump_size 1 map_type 0}rotate x*90}
rotate x*0 translate <0,0,zwert>finish {ambient .1 diffuse .1}}
#declare zwert = zwert+5
#end
}

#declare xwert = -10
#while (xwert <= 10 )
object { Obj3 translate <xwert,0,0>}
#declare xwert = xwert+5
#end

superellipsoid {<0.25, 0.25>pigment {Aquamarine*1.5} scale <12,.125,12>
normal{bump_map{tga "bumps.tga" bump_size .5 map_type 0}rotate x*90}finish {ambient .1 diffuse .1}}

union {
#declare xwert = -12
#while (xwert <= 12 )
box { <0,0,0><.2,.2,1> translate <xwert+.2,0,-13>}
#declare xwert = xwert+.4
#end

#declare xwert = -12
#while (xwert <= 12 )
box { <0,0,0><.2,.2,1> translate <xwert+.2,0,12>}
#declare xwert = xwert+.4
#end

#declare zwert = -12
#while (zwert <= 12 )
box { <0,0,0><.2,.2,1> rotate y*90 translate <-13,0,zwert+.2>}
#declare zwert = zwert+.4
#end

#declare zwert = -12
#while (zwert <= 12 )
box { <0,0,0><.2,.2,1> rotate y*90 translate <12,0,zwert+.2>}
#declare zwert = zwert+.4
#end

box { <0,0,0><.2,.2,1>rotate y*45 translate <12,0,12>}
box { <0,0,0><.2,.2,1>rotate y*45 translate <-12.8,0,-12.8>}
box { <0,0,0><.2,.2,1>rotate y*-45 translate <12.8,0,-12.8>}
box { <0,0,0><.2,.2,1>rotate y*-45 translate <-12,0,12>}
pigment {Aquamarine*.75}
}
scale <.3,.3,.5>
translate <0,1.5,3>
}

//Pflanze
object{Pflanze1 scale <.5,.5,.5> translate <-7,1.5,2>}

//Parkett
#declare xwert = 0
#while (xwert <= 32 )
box {<-25,1.2,-5><-24.5,1.5,20> texture{DMFWood6 rotate x*90 scale <1,1,10>}
translate <xwert,0,0>}
#declare xwert = xwert+.75
#end

//Rollo
#declare Tex1 =
texture {pigment { color Gray95 }finish { ambient .1 diffuse .2 specular .4 roughness .02 }}

#declare Obj99 =
difference {
intersection {
superellipsoid { <.45, .45>
texture { Tex1 }
scale <17,1,1> translate x*17}
box {<0,-1,-.55>,<40,1,.55>	texture { Tex1 }}
cylinder { <0,-1.5,0>,<40,-1.5,0>,1.5 texture { Tex1 }}
cylinder { <0,-1.5,0>,<40,-1.5,0>,1.4 inverse texture { Tex1 }}}
cylinder { <5,-.2,-.35>,<5,.2,-.35>,.08	texture { Tex1 }}
cylinder { <5,-.2,.35>,<5,.2,.35>,.08 scale <1,1,3>	texture { Tex1 }}
box { <4.92,-.2,-.35>,<5.08,.2,.35>	texture { Tex1 }}}

#declare BaseBox =
union {
box {<0,0,-.5>,<40,.3,.5>texture {Tex1 }}
cylinder {<5,-.2,0>,<5,.2,0>,.25 texture { Tex1 }}}

#declare Obj100 =
cylinder {<0,0,0>,<0,40,0>,.02	texture {pigment {color rgb <.87,.94,.65> }	normal {bumps .4 scale .05}}}

#declare Offset = 1.2
#declare OpenAngle = 45

#declare Obj98 =
union {
object { BaseBox translate <-3.5,0,0>}
object { Obj100 translate <5,0,0> }
object { Obj100 translate <5,0,-.4> }
object { Obj100 translate <5,0,.4> }
#declare Count=1
#while (Count < 18)
object{Obj99 rotate x*OpenAngle translate <0,Offset*Count,0> }
#declare Count=Count+1
#end
}

object {Obj98 rotate y*90 scale <.125,.25,.6>translate <-11,5,16>}

//Berge
#declare Obj50 =
union {
object {
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
<-15.000000, -2.000000, 0.000000>, <-14.000000, -2.000000, 0.000000>, <-13.000000, -2.000000, 0.000000>, <-12.000000, -2.000000, 0.000000>,
<-15.000000, -1.000000, 0.000000>, <-14.011807, -1.000000, 1.340034>, <-13.011807, -1.000000, 1.340034>, <-11.940966, -0.964867, 1.809045>,
<-15.000000, 0.000000, 0.000000>, <-14.011807, 0.000000, 1.340034>, <-13.011807, 0.000000, 1.340034>, <-11.940966, 0.035133, 1.809045>,
<-15.000000, 1.000000, 0.000000>, <-14.000000, 1.000000, 0.000000>, <-13.000000, 1.000000, 0.000000>, <-12.000000, 1.000000, 0.000000>
}
}
object {
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
<-12.000000, -2.000000, 0.000000>, <-11.000000, -2.000000, 0.000000>, <-10.000000, -2.000000, 0.000000>, <-9.000000, -2.000000, 0.000000>,
<-11.940966, -0.964867, 1.809045>, <-10.870124, -0.929734, 2.278057>, <-10.118069, -0.561706, 3.015075>, <-9.118069, -0.561706, 3.015075>,
<-11.940966, 0.035133, 1.809045>, <-10.870124, 0.070266, 2.278057>, <-10.118069, 0.438294, 3.015075>, <-9.118069, 0.438294, 3.015075>,
<-12.000000, 1.000000, 0.000000>, <-11.000000, 1.000000, 0.000000>, <-10.000000, 1.000000, 0.000000>, <-9.000000, 1.000000, 0.000000>
}
}
object {
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
<-9.000000, -2.000000, 0.000000>, <-8.000000, -2.000000, 0.000000>, <-7.000000, -2.000000, 0.000000>, <-6.000000, -2.000000, 0.000000>,
<-9.118069, -0.561706, 3.015075>, <-8.118069, -0.561706, 3.015075>, <-6.102676, -0.858317, -0.603015>, <-5.551338, -0.929159, -0.301508>,
<-9.118069, 0.438294, 3.015075>, <-8.118069, 0.438294, 3.015075>, <-6.102676, 0.141683, -0.603015>, <-5.551338, 0.070841, -0.301508>,
<-9.000000, 1.000000, 0.000000>, <-8.000000, 1.000000, 0.000000>, <-7.000000, 1.000000, 0.000000>, <-6.000000, 1.000000, 0.000000>
}
}
object {
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
<-6.000000, -2.000000, 0.000000>, <-5.000000, -2.000000, 0.000000>, <-4.000000, -2.000000, 0.000000>, <-3.000000, -2.000000, 0.000000>,
<-5.551338, -0.929159, -0.301508>, <-5.000000, -1.000000, 0.000000>, <-3.650074, -0.574004, 1.876047>, <-2.825037, -0.787002, 1.876047>,
<-5.551338, 0.070841, -0.301508>, <-5.000000, 0.000000, 0.000000>, <-3.650074, 0.425996, 1.876047>, <-2.825037, 0.212998, 1.876047>,
<-6.000000, 1.000000, 0.000000>, <-5.000000, 1.000000, 0.000000>, <-4.000000, 1.000000, 0.000000>, <-3.000000, 1.000000, 0.000000>
}
}
object {
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
<-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>,
<-2.825037, -0.787002, 1.876047>, <-2.000000, -1.000000, 1.876047>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>,
<-2.825037, 0.212998, 1.876047>, <-2.000000, 0.000000, 1.876047>, <1.128543, 0.654209, 3.551089>, <2.128543, 0.654209, 3.551089>,
<-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>
}
}
object {
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
<0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>,
<0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <2.805140, -1.425996, 2.412060>,
<2.128543, 0.654209, 3.551089>, <3.128543, 0.654209, 3.551089>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>,
<0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>
}
}
object {
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
<3.000000, -2.000000, 0.000000>, <4.000000, -2.000000, 0.000000>, <5.000000, -2.000000, 0.000000>, <6.000000, -2.000000, 0.000000>,
<2.805140, -1.425996, 2.412060>, <3.610280, -1.851993, 4.824121>, <5.000000, -1.000000, 0.000000>, <5.281268, -0.885894, 1.742044>,
<3.000000, 0.000000, 0.000000>, <4.000000, 0.000000, 0.000000>, <5.000000, 0.000000, 0.000000>, <5.281268, 0.114106, 1.742044>,
<3.000000, 1.000000, 0.000000>, <4.000000, 1.000000, 0.000000>, <5.000000, 1.000000, 0.000000>, <6.000000, 1.000000, 0.000000>
}
}
object {
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
<6.000000, -2.000000, 0.000000>, <7.000000, -2.000000, 0.000000>, <8.000000, -2.000000, 0.000000>, <8.798995, -2.000000, -0.134003>,
<5.281268, -0.885894, 1.742044>, <5.562537, -0.771788, 3.484087>, <6.562537, -0.771788, 3.484087>, <8.147265, -0.885894, 2.412060>,
<5.281268, 0.114106, 1.742044>, <5.562537, 0.228212, 3.484087>, <6.562537, 0.228212, 3.484087>, <8.147265, 0.114106, 2.412060>,
<6.000000, 1.000000, 0.000000>, <7.000000, 1.000000, 0.000000>, <8.000000, 1.000000, 0.000000>, <8.798995, 1.000000, -0.134003>
}
}
object {
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
<8.798995, -2.000000, -0.134003>, <9.597990, -2.000000, -0.268007>, <11.000000, -2.000000, 0.000000>, <12.000000, -2.000000, 0.000000>,
<8.147265, -0.885894, 2.412060>, <9.731993, -1.000000, 1.340034>, <11.012290, -1.851993, 3.283082>, <11.811285, -1.851993, 4.053601>,
<8.147265, 0.114106, 2.412060>, <9.731993, 0.000000, 1.340034>, <11.012290, -0.851993, 3.283082>, <11.811285, -0.851993, 4.053601>,
<8.798995, 1.000000, -0.134003>, <9.597990, 1.000000, -0.268007>, <11.000000, 1.000000, 0.000000>, <12.000000, 1.000000, 0.000000>
}
}
object {
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
<12.000000, -2.000000, 0.000000>, <13.000000, -2.000000, 0.000000>, <14.000000, -2.000000, 0.000000>, <15.000000, -2.000000, 0.000000>,
<11.811285, -1.851993, 4.053601>, <12.610280, -1.851993, 4.824121>, <14.012290, -1.851993, 3.283082>, <15.000000, -1.000000, 0.000000>,
<11.811285, -0.851993, 4.053601>, <12.610280, -0.851993, 4.824121>, <14.012290, -0.851993, 3.283082>, <15.000000, 0.000000, 0.000000>,
<12.000000, 1.000000, 0.000000>, <13.000000, 1.000000, 0.000000>, <14.000000, 1.000000, 0.000000>, <15.000000, 1.000000, 0.000000>
}
}
pigment { image_map {gif "grasst.gif" interpolate 2 map_type 0}}
finish { ambient 0.1 diffuse  .1 crand 0.2}
rotate x*-90
}

object {Obj50 scale 10 translate<0,0,200>}
object {Obj50 scale 15 translate<-150,0,300>}

//Wege
box { <1500,0,100>,<-1500,1,150>pigment {Gray}finish {ambient 0.3 diffuse 0.3 crand 0.1}}
box { <20,0,5>,<5,.1,10>pigment {Yellow}finish {ambient 0.1 diffuse 0.3 crand 0.1}}

//Stadt
#include "stadt.inc"
object {Stadt scale 30 translate <400,9,200>}

//Lampe
#declare Lampe =
union {
cylinder {<0,5.5,0><0,8,0>.5 open pigment {White filter 1}finish {F_Glass2}}
union {
cylinder {<0,0,0><0,5,0>.4 texture { T_Chrome_5E }}
cylinder {<0,5,0><0,5.5,0>1.5 texture { T_Chrome_5E }}
union {
difference {
box {<.5,.5,.5><-.5,-.5,-.5> rotate <45,90,90>scale 2}
box {<.5,.5,.5><-.5,-.5,-.5> rotate <45,90,90>scale 1.8}
box {<2,0,2><-2,-2,-2>}
translate y*8
scale <1.5,1,1.5>
texture { T_Chrome_5E }
}
cylinder {<-.6,5.2,-.6><-1.75,8,-1.75>.1 }
cylinder {<.6,5.2,.6><1.75,8,1.75>.1 }
cylinder {<-.6,5.2,.6><-1.75,8,1.75>.1 }
cylinder {<.6,5.2,-.6><1.75,8,-1.75>.1 }
texture { T_Chrome_5E }
}
scale <.5,1,.5>
}
blob {
threshold 0.6
component 1, 1, <0,.7,0>component 1, .5, <0,0,0>
pigment { color Yellow/4+White filter 1}
translate y*5.75
}
light_source {<0,7,0> color rgb <1.0, 0.811765, 0.623529> fade_power 2 fade_distance 10}
}

object {Lampe rotate y*45 translate <10,0,4>}
object {Lampe rotate y*45 translate <10,0,11>}

//Zaun
#declare xwert = -100
#while (xwert <= 100 )
union {
cylinder {<0,0,0><0,8,0>,.3 }
cone {<0,7,0>,.6<0,10,0>,.0 }
cylinder {<2,3,0><-2,3,0>,.3 }
cylinder {<2,6,0><-2,6,0>,.3 }
pigment {color rgb <0.94, 0.93, 0.83>}
finish {ambient 0.25 diffuse 0.65 brilliance 6.0 phong 1.0 phong_size 100.0 reflection 0.45}scale <1,.5,1>
translate <xwert,0,80>}
#declare xwert = xwert+2
#end
#declare zwert = -80
#while (zwert <= 80 )
union {
cylinder {<0,0,0><0,8,0>,.3 }
cone {<0,7,0>,.6<0,10,0>,.0 }
cylinder {<2,3,0><-2,3,0>,.3 }
cylinder {<2,6,0><-2,6,0>,.3 }
pigment {color rgb <0.94, 0.93, 0.83>}
finish {ambient 0.25 diffuse 0.65 brilliance 6.0 phong 1.0 phong_size 100.0 reflection 0.45}scale <1,.5,1>
translate <100,0,zwert>}
#declare zwert = zwert+2
#end

//Kerze
#declare DripCount = 10
#declare height = 8
#declare Radius = 1

#include "candles.inc"

light_source{<0,6,14>color White+Yellow/4 fade_distance 2 fade_power 1}

object{Candle scale .2 translate <0,4,12>}

#declare camera_location = <-7.5,7,-10>
#declare camera_look_at = <10, 7,20>
#declare camera_angle = 100
#declare effect_scale = .5
#declare effect_brightness = 1
#declare effect_intensity = 1
#declare effect_type = "Candle"
#declare options_only = true
#include "LENS.INC"
#declare effect_location = <0,6,14> #include "LNSEFCTS.INC"

//Frau
#include "mbabe.inc"
object {Tussi rotate x*-90 scale <4,5,4> translate <-2.75,4,14>}

//Baume
#include "baum1.inc"
object {Baum1 scale <.125/8,.125/4,.125/8> translate <15,0,15>}
object {Baum1 scale <.125/8,.125/4,.125/8> translate <-10,0,20>}

#include "baum2.inc"
object {Baum2 scale <.125/4,.125/3,.125/4> translate <13,0,-5>}

//Lichtquellen
//light_source {<10,10,-15> color White }
light_source {<20,15,50> color Red fade_power 2 fade_distance 50}
light_source {<40,15,50> color Green fade_power 2 fade_distance 50}
light_source {<-18,8,10>  color rgb <1.0, 0.811765, 0.623529>*4}
light_source {<-18,8,-5>  color rgb <1.0, 0.811765, 0.623529>*4}
light_source {<50,200,1500> color White }

