
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1 beta 2
// Desc: Landscape
// Date: May 98
// Auth: Nathan O'Brien
// Mail: no13@ozemail.com.au
// Webp: http://www.ozemail.com.au/~no13


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions

#declare Soft_shadows = on;
#declare Hair = on;

camera {
	location <-.8,1.4,-1>
	look_at  <0,1.4,0>
	angle 75
}

light_source {<1,2,-3> color White
             fade_distance 2.5
             fade_power 1
			 #if (Soft_shadows = on)
			 area_light <1,0,0> <0,1,0> 5 5
			 #end
}

light_source {<-1,1.4,-1> color Gray25
	fade_distance 1
    fade_power 2
	shadowless
}

#if (Soft_shadows = on)
global_settings {
    radiosity {
        count 200                // Calculate reasonable accurate samples
        error_bound 0.3          // Main quality/time adjustment = sample spacing
        gray_threshold 0.5       // Try 0.33-0.50. Just a matter of taste
        distance_maximum 10      // Scene-dependent!  Leave 0 if unsure of proper value.
        low_error_factor 0.75
        nearest_count 7
        minimum_reuse 0.017      // reasonable number of samples in corners
        brightness 3.3           // doesn't really matter.  Not used in final output.
        recursion_limit 1        // 1 is quickest
    }
}
#end

#declare Object1Texture =
texture {pigment {
  image_map {gif "face2.gif"}
		translate <-0.5,-0.5,0>
		scale <9,6,1>
		scale .015
		translate <0,0.14,0>
  }
  normal {
		bump_map {gif "wrinkles.gif"} 0.75
		translate <-0.5,-0.5,0>
		scale <9,6,1>
		scale .015
		translate <0,0.14,0>
	}
	finish {phong 0.1}
}


#declare Object2Texture = texture{pigment{White} normal{wrinkles 0.25 scale .001}}
#declare Object3Texture = texture{pigment{color rgb<0.620, 0.286, 0.035>} normal{quilted 0.5 scale .001} finish{phong .25}}


#declare Object4Texture = texture
{
  pigment
  {
    bozo
    turbulence 0.8
    color_map
    {
      [0.00 color rgb<0.373, 0.129, 0.129>]
      [0.30 color rgb<0.443, 0.286, 0.227>]
      [0.57 color rgb<0.522, 0.224, 0.098>]
      [0.80 color rgb<0.565, 0.282, 0.020>]
      [0.95 color rgb<0.659, 0.373, 0.027>]
      [1.00 color rgb<0.620, 0.286, 0.035>]
    }
  }
  scale .001
}

#declare Object5Texture = texture
{
  pigment
  {
    gradient x+y
    color_map
    {
      [0.00 color rgb<0.373, 0.129, 0.129>]
      [0.30 color rgb<0.443, 0.286, 0.227>]
      [0.57 color rgb<0.522, 0.224, 0.098>]
      [0.80 color rgb<0.565, 0.282, 0.020>]
      [0.95 color rgb<0.659, 0.373, 0.027>]
      [1.00 color rgb<0.620, 0.286, 0.035>]
    }
  }
  scale .01
}

#include "darwin1.inc"

object {Darwin1 scale 10 translate <-.25,0,0>}

#if (Hair = on)
#include "hoh.inc"
object {Head_of_Hair scale 10 translate <-.25,0,0>}
#end

#include "landscape.inc"
