
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: Ballistics macro using a polygon (3 sided) launch window
// Date: June 1998
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: http://www.no13.net

/*
   This is the second revision, and first public release, of the ballistic macro.
   It is useful for creating realistic hair on polygon based models. It is intended
   for use in conjunction with the Perl script "ballistic.pl" .
*/

// SUB FUNCTIONS

// SUB FUNCTION 01
// CALCULATES THE FIRST ENTRY POINT THROUGH THE POLYGON WINDOW
#macro First_Vector (P1,P2,P3)
	#declare First_Entry = ((P1 + P2 + P3) / 3);
#end

// SUB FUNCTION 02
// CALCULATES THE SURFACE NORMAL OF THE POLYGON WINDOW
#macro Window_Normal (P1,P2,P3,Nsign)
	#local P4 = (P1 - P3);
	#local P5 = (P2 - P3);
	#local N1 = vcross (P4,P5);
	#local N2 = vnormalize (N1);
	#declare First_Normal = (N2 * Nsign);
#end

// SUB FUNCTION 03
// DRAWS A VECTOR SEGMENT
#macro Draw_Segment (P1,P2,R1)
	#declare T_Ballistic = texture{pigment{ rgb B_Pigment2}}
	cylinder {P1,P2,R1 texture {T_Ballistic} finish {F_Ballistic}}
	sphere {P2,R1 texture {T_Ballistic} finish {F_Ballistic}}
#end

// SUB FUNCTION 04
// CALCULATES THE END POINT OF A SEGMENT GIVEN ITS FINAL UNIT VECTOR
#macro Find_Point (P1,N1,V1)
	#if (Strand_Turbulence > 0)
		B_Turb (0)
		#declare End_Point = ((P1 + (N1 * V1)) + Turb_Move);
		#else
		#declare End_Point = (P1 + (N1 * V1));
	#end
#end

// SUB FUNCTION 05
// CALCULATES THE EFFECT OF AN APPLIED NORMAL TO THE CURRENT NORMAL
#macro Find_Normal (N1,N2)
	#local N3 = (N1 + N2);
	#declare New_Normal = vnormalize (N3);
#end

// SUB FUNCTION 06
// CALCULATES A STRAND LENGTH
#macro Find_Slength (void)
	#local R1 = (rand(B_Rand) * Length_Plus);
	#declare New_Length = (Strand_Length + R1);
#end

// SUB FUNCTION 07
// CHECKS FOR ALL NECESSARY EXTERNAL DECLARES
#macro Check_Declares (void)
	#ifndef (Strand_Length)
		#declare Strand_Length = 1;
	#end
	#ifndef (Cord_Length)
		#declare Cord_Length = 0.1;
	#end
	#ifndef (Cord_Radius)
		#declare Cord_Radius = 0.05;
	#end
	#ifndef (Normal_Effect)
		#declare Normal_Effect = <0,-1,0>;
	#end
	#ifndef (Strand_Turbulence)
		#declare Strand_Turbulence = 0;
	#end
	#ifndef (Length_Plus)
		#declare Length_Plus = 0;
	#end
	#ifndef (Ballistic_Nesting)
		#declare Ballistic_Nesting = 0;
	#end
	#ifndef (Ballistic_Quantity)
		#declare Ballistic_Quantity = 1;
	#end
#end

// SUB FUNCTION 08
// CALCULATES A NEW START POINT
#macro Get_New_Start (P1,P2,P3)
	#local R1 = rand(B_Rand);
	#local R2 = rand(B_Rand);
	#if ((R1 + R2) > 1)
		#local R1 = (1 - R1);
		#local R2 = (1 - R2);
	#end
	#local R3 = (1 - R1 - R2);
	#declare New_Start = ((R1 * P1) + (R2 * P2) + (R3 * P3));
#end

// SUB FUNCTION 09
// TURBULENCE FUNCTION
#macro B_Turb (void)
	#declare Turb_Move = <(rand(B_Rand) * Strand_Turbulence * Cord_Length),
	                      (rand(B_Rand) * Strand_Turbulence * Cord_Length),
						  (rand(B_Rand) * Strand_Turbulence * Cord_Length)>;
#end

// SUB FUNCTION 10
// JITTER FUNCTION
#macro J_Vector (void)
       #local S1 = rand(B_Rand);
       #if (S1 < 0.5) #local S1 = 1; #else #local S1 = -1; #end
       #local S2 = rand(B_Rand);
       #if (S2 < 0.5) #local S2 = 1; #else #local S2 = -1; #end
       #local S3 = rand(B_Rand);
       #if (S3 < 0.5) #local S3 = 1; #else #local S3 = -1; #end
       #local J_Adjust = <(rand(B_Rand)*S1*B_Jitter),
                            (rand(B_Rand)*S2*B_Jitter),
                            (rand(B_Rand)*S3*B_Jitter)>;
       #declare Normal_Effect_Jitter = (Normal_Effect + J_Adjust);
#end

// SUB FUNCTION 000
// DRAWS A SINGLE BALLISTIC PATH
#macro Single_Ballistic (P1,N1,Slength)
	#declare B_Pigment2 = (B_Pigment * ((rand(B_Rand) * 0.5) + 0.5));
	Find_Point (P1,N1,Cord_Length)
	Draw_Segment (P1,End_Point,Cord_Radius)					// draws the very first segment
	#local Counter1 = abs(Slength / Cord_Length);			// number of loops
	#local Counter2 = 0;									// loop counter
	#local I_Point = End_Point;
	#local L_Normal = First_Normal;
	#while (Counter2 < Counter1)
        #if (B_Jitter = 0)
            #declare Normal_Effect_Jitter = Normal_Effect;
            #else
            J_Vector (0)                                        // jitter
        #end
		Find_Normal (L_Normal,Normal_Effect_Jitter)
		Find_Point (I_Point,New_Normal,Cord_Length)
		Draw_Segment (I_Point,End_Point,Cord_Radius)
		#local I_Point = End_Point;
		#local L_Normal = New_Normal;
		#local Counter2 = (Counter2 + 1);
	#end
#end

// MAIN FUNCTION
#macro Poly_Ballistic (P1,P2,P3,Nsign)

	// STEP ONE . ASSIGN INITIAL DATA SET
//	Check_Declares (0)										// check external declares
//	#declare B_Rand = seed(Ballistic_Rand);					// rand function
	First_Vector (P1,P2,P3)									// find escape window start vector
	Window_Normal (P1,P2,P3,Nsign)							// find escape window normal
	Find_Slength (0)										// sets strand length

	// STEP TWO . DRAW FIRST ENTRY BALLISTIC
	Single_Ballistic (First_Entry,First_Normal,New_Length)

	// STEP THREE . DRAW MULTIPLE BALLISTIC
	#local Counter1 = 1;
	#while (Counter1 < Ballistic_Quantity)
		Get_New_Start (P1,P2,P3)
		Find_Slength (0)
		Single_Ballistic (New_Start,First_Normal,New_Length)
		#local Counter1 = (Counter1 + 1);
	#end

#end
