
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions


camera {
	location <0,0,-3>
	look_at  <0,0,0>
}

box {<20,20,0><-20,-20,1>
	pigment{White}
	normal {wrinkles .5 scale <.05,.2,.05> rotate <0,0,-45>}
}

#macro Beam (Fact,Brad,Pnt1) 
	light_source {
		<0,0,-50>
		color rgb (<1,1,1> * Fact)
		spotlight
		point_at Pnt1
		radius Brad
		tightness 50
		falloff 1
	}
#end
		
		
Beam (0.75,0.5,<0,0,0>)
Beam (1,0.5,<0.5,0.5,0>)

Beam (0.5,0.2,<-0.5,0,0>)
Beam (-0.5,0.1,<0.2,0,0>)
