
//  Tree.inc    05/05/98  (C) Neil Alexander

/*camera {
  location  <500, 50, 300>
  look_at   <80, 25, -80>
  angle 45
  }

light_source {
  <18000000, 6000000, 0>
  color rgb <1,0.95,0.8>
  }
background { color rgb <0,0,1>}*/

// ---------------- Leaves ------------------------

#declare Outline = union {
  intersection {
    cylinder { <0,-1,0>,<0,12,0>,1
      scale <3,1,4>
      translate <3,0,2.5>
      }
    cylinder { <0,-1,0>,<0,12,0>,1
      scale <3,1,4>
      translate <3,0,-2.5>
      }
    }
  box {<0,0,-0.062>,<2,11,0.062>}
  }  // end Outline

#declare Leaf = merge {
  sphere { <0,0,0>,1
    scale <8,10,5>
    translate <8,0,1.5>
    }
  sphere { <0,0,0>,1
    scale <8,10,5>
    translate <8,0,-1.5>
    }
  clipped_by {
    object { Outline }
    }
  texture {
    pigment { color rgb <0,0.9,0> }
    }
  }  // end Leaf

#declare Leaves = union {
  object { Leaf }
  object { Leaf
    rotate <30,0,0>
    translate <0,-2,0>
    }
  object { Leaf
    rotate <45,30,0>
    translate <0,-5,0>
    }
  object { Leaf
    rotate <-30,0,0>
    translate <0,-2,0>
    }
  object { Leaf
    rotate <-45,-30,0>
    translate <0,-5,0>
    }
  bounded_by {sphere { <3,2,0>,8  }}
  rotate <0,-90,0>
  }  // end Leaves


// --------------------------------------------------------

#declare Bark = pigment {  // Tree bark base color
  bozo
  color_map {
    [0.4 rgb <0.6, 0.55, 0.5>]
    [0.5 rgb <0.7,0.6,0.2>]
    [0.6 rgb <0.5,0.45,0.4>]
    [0.9 rgb <0.5,0.45,0.4>]
    [1 rgb <0.3,0.3,0.1>]
    }
  scale <1,20,1>
  }

// --------------------------------------------------------

#declare R1 = seed(85)//90.9

// ---------------- Tree Characteristics ------------------

#declare Baseloc = <-8,50,0>  // tree location
#declare Startloc = Baseloc  // top of base trunk section
#declare Maxrad = 12          // diameter of tree at top of trunk base
#declare Lengthfactor = 25    // factor for section length
#declare Size = Maxrad  // starting size
#declare Sizefactor = 0.667  // reduction factor for branch diameter

// ---------------- Starting Values ------------------------

#declare Dir = y        // starting direction (straight up)
#declare Count = 0      // section counter - 90 sections
#declare N1 = 0         // node place-holders
#declare N2 = 0         // for storing branching info
#declare N3 = 0
#declare N4 = 0
#declare N5 = 0
#declare N6 = 0
#declare N7 = 0
#declare N8 = 0
#declare N9 = 0

// ---------------- Tree -------------------------------------

#declare Tree = union {  // tree
  blob {
    threshold 0.56
    cylinder {<0,0,0>,Startloc,Maxrad*2,1}
    sphere {<0,15,2>,14,1}
    cylinder {<0,6,0>,<42,-6,0>,6,1}
    cylinder {<0,6,0>,<0,-6,-30>,6,1}
    sphere {<-22,28,-8>,21,-0.25}

    }
  sphere { Startloc,Maxrad }

  #while (N1 < 4)  // main loop

    #while (Count < 9)  // sub loop

      #declare Length = ((pow(Size,0.2))*Lengthfactor)*(rand(R1)/2 + 0.5)
      #declare Tilt = (5*(Maxrad-Size)+5)*(rand(R1))// random tilt angle, larger for smaller size
      #declare Rot = 360*rand(R1)       // random tilt direction
      #if ((Dir.x = 0) & (Dir.z = 0))  // find perpendicular vector to Dir for tilt
        #declare Dirx = x
        #else
          #declare Dirx = vcross(Dir, y)
        #end // if
      #declare Dir2 = vaxis_rotate(Dir,Dirx,Tilt) // tilt away from Dir
      #declare Dir2 = vaxis_rotate(Dir2,Dir,Rot)  // in random direction around Dir
      #declare Endloc = Length*Dir2 + Startloc
      #declare Size2 = Size*Sizefactor
      cone { Startloc, Size Endloc, Size2 }
      sphere { Endloc, Size2 }
      #declare Count = Count + 1
      #switch ( Count )
        #case (1)
          #declare E1 = Endloc
          #declare S1 = Size2*Sizefactor
          #declare D1 = Dir2
          #declare N1 = N1 + 1
          #break
        #case (2)
          #declare E2 = Endloc
          #declare S2 = Size2*Sizefactor
          #declare D2 = Dir2
          #declare N2 = N2 + 1
          #break
        #case (3)
          #declare E3 = Endloc
          #declare S3 = Size2*Sizefactor
          #declare D3 = Dir2
          #declare N3 = N3 + 1
          #break
        #case (4)
          #declare E4 = Endloc
          #declare S4 = Size2*Sizefactor
          #declare D4 = Dir2
          #declare N4 = N4 + 1
          #break
        #case (5)
          #declare E5 = Endloc
          #declare S5 = Size2*Sizefactor
          #declare D5 = Dir2
          #declare N5 = N5 + 1
          #break
        #case (6)
          #declare E6 = Endloc
          #declare S6 = Size2*Sizefactor
          #declare D6 = Dir2
          #declare N6 = N6 + 1
          #break
        #case (7)
          #declare E7 = Endloc
          #declare S7 = Size2*Sizefactor
          #declare D7 = Dir2
          #declare N7 = N7 + 1
          #break
        #case (8)
          #declare E8 = Endloc
          #declare S8 = Size2*Sizefactor
          #declare D8 = Dir2
          #declare N8 = N8 + 1
          #break
        #case (9)
          #declare N9 = N9 + 1
          //sphere { Endloc, 3 texture { pigment { color rgb <0,1,0> }}}
          object { Leaves
            rotate <degrees(acos(Dir2.y)),degrees(atan2(Dir2.x,Dir2.z)),0>
            translate Endloc
            }
          #break
        #end // switch - case
      #declare Size = Size2
      #declare Startloc = Endloc
      #declare Dir = Dir2

      #end // sub loop

     #declare Count = Count - 1
     #if (N9 = 2)
      #declare Count = Count - 1
      #declare N9 = 0
      #if (N8 = 2)
        #declare Count = Count - 1
        #declare N8 = 0
        #if (N7 = 2)
          #declare Count = Count - 1
          #declare N7 = 0
          #if (N6 = 2)
            #declare Count = Count - 1
            #declare N6 = 0
            #if (N5 = 3)                     // 3-way split
              #declare Count = Count - 1
              #declare N5 = 0
              #if (N4 = 2)
                #declare Count = Count - 1
                #declare N4 = 0
                #if (N3 = 2)
                  #declare Count = Count - 1
                  #declare N3 = 0
                  #if (N2 = 2)
                    #declare Count = Count - 1
                    #declare N2 = 0
                    #if (N1 = 3)        // 3-way split
                      #declare N1 = 4  // end tree condition
                      #end  // end if N1
                    #end  // end if N2
                  #end  // end if N3
                #end  // end if N4
              #end  // end if N5
            #end  // end if N6
          #end  // end if N7
        #end  // end if N8
      #end  // end if N9

    #switch ( Count )
      #case (0)
        #declare Startloc = Baseloc
        #declare Size = Maxrad*Sizefactor
        #declare Dir = y
        #break
      #case (1)
        #declare Startloc = E1
        #declare Size = S1
        #declare Dir = D1
        #break
      #case (2)
        #declare Startloc = E2
        #declare Size = S2
        #declare Dir = D2
        #break
      #case (3)
        #declare Startloc = E3
        #declare Size = S3
        #declare Dir = D3
        #break
      #case (4)
        #declare Startloc = E4
        #declare Size = S4
        #declare Dir = D4
        #break
      #case (5)
        #declare Startloc = E5
        #declare Size = S5
        #declare Dir = D5
        #break
      #case (6)
        #declare Startloc = E6
        #declare Size = S6
        #declare Dir = D6
        #break
      #case (7)
        #declare Startloc = E7
        #declare Size = S7
        #declare Dir = D7
        #break
      #case (8)
        #declare Startloc = E8
        #declare Size = S8
        #declare Dir = D8
        #break
      #end // end switch - case

    #end  // main loop

  texture {
    pigment { radial
      pigment_map {
        [0.4 Bark]
        [0.5 color rgb <0.2,0.18,0.1>]
        [0.6 Bark]
        }
      turbulence 0.5
      frequency 30
      scale 4
      warp {  // bulge
        black_hole <-20,50,3>, 8
        strength 3
        inverse
        }
      warp {  // bulge
        black_hole <-2,17,16>, 8
        strength 3
        inverse
        }
      }
    normal { bumps 0.5 scale 2 }
    }
  rotate <0,-90,0>
  }  // end tree

//object { Tree translate <-30,-10,30> }

