#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "eye.inc"
#include "stone2.inc"
#include "stones2.inc"
#include "woods.inc"
#include "darren.inc"
#include "stars.inc"
#include "stone2.inc"
#include "stones2.inc"
#include "woods.inc"
#include "darren.inc"
#include "stars.inc"
#include "fractal2.inc"


global_settings {
adc_bailout 1/255
#max_trace_level 10
assumed_gamma 2.2
}


camera {
//   fisheye
   location <0.0,  0.0,  -120>
   up  <0.0,  1.0,  0.0>
   right <1.33333, 0.0, 0.0>
   look_at <0, 0, 0>
 //  blur_samples 24
   //confidence 0.90            // default is 0.9
   //variance 1/128
   //aperture 2
   //focal_point <0, 0, 0>
   //normal {bumps 0.3005}
}



object {
   light_source {
      <100, 1000, -300>
      color Gold
   }
}

object {
   light_source {
      <-200, 1000, -1200>
      color White
   }
}


//  Add a Blue light source far away - adds wierdness to scene

object {
   light_source {
      <0, 2, 3000>
      color NeonBlue
   }
}

// ********  O B J E C T S *******
#declare mainMbody = box {
  <-1, -1, -1>, <1, 1, 1>
  	pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      box_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0 color rgbt <0, 1, 0,  1> ]
        [ 0.2 color rgbt <0.3,0.8,0,-1>]
        [ 0.3 color rgbft <0,0,1,0.3,-1>]
        [ 0.5 color rgbt <1.2,0.3,0,-1>]
        [ 1 color rgbt <1, 0, 0, -1> ]
      }
      frequency 2
      samples 12
      scale 0.8
    }
  hollow
  translate <0,0,0>

  scale <80.000000, 80.000000, 80.000000>
}

// This is the fire storm random generator - for the muli-coloured fire storm
// That surrounds the slimy creature!!


#declare R1 = seed(4)
#declare R2 = seed (4)
#declare R3 = seed (5)
#declare pos1 = 20
#declare pos2 = -20
#declare added_up = rand(R1) + rand(R2) + rand(R3)
#declare R0 = seed(added_up)
#declare R4 = (0.5 +rand(R0)/0.33)
#declare X1 = 30 * (R4*4)
#declare Y1 = X1/1.8
#declare Z1 = Y1*2

#declare top_sphere = object {
  sphere {<0,0,0>,1 hollow}
  pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.8
      color_map {
        [ 0 color rgbt <1, 0, 0,  1> ]

        [ 0.5 color rgbt <0,1,0,-1>]

        [ 1 color rgbt <0, 0, 1, -1> ]
      }
      frequency 1.2
      samples 20
      scale <0.75+(R4*5), 0.1+(added_up*8), 3>
      translate <0, 0, 0>
    }
    halo {
      emitting
      spherical_mapping
      poly
      turbulence 1* R4 + (0.5*added_up)
      color_map {
        [ 0 color rgbt <1, 0, 1,  1> ]
        [ 0.5 color rgbt <1, 1, 0, -1> ]

        [ 1 color rgbt <1, 0, 0, -1> ]
      }
      frequency 2.2
      samples 20
      scale <0.75, 0.5,3>
      translate <-0.1, 0, -1>
    }
    halo {
      emitting
      spherical_mapping
      poly
     turbulence 1.5 + rand(R2)
      color_map {
        [ 0 color rgbt <1, 0, 0,  1> ]
        [ 0.5 color rgbt <0,0.82+rand(R3),0,-1>]
        [ 1 color rgbt <1, 0, 0, -1> ]
      }
      frequency 1.6
      samples 20
      scale <0.5,0.7,1>
      translate <0, 0.2, 0>
    }
     hollow
  translate <0,0,0>
  scale <80.000000, 80.000000, 80.000000>
}

  

#declare midMsphere = object {
  sphere {<0,0,0>,1 hollow}
  texture {
    Glass
  }
  scale 81.2
}

//#include "albrain2.inc"

//#declare Creature = object {TheFormObject
//  scale <38.000000, 38.000000, 38.000000>
 // translate <0.000000, 0.000000, -20.000000>
//}



#declare dream_box =
union {   // dreamMbox
  object { mainMbody }
  object { top_sphere }
//  object { midMsphere }
//  object { Creature }
//union {
//#include"ballz.inc"
//translate <0,0,0>
//scale 1.25
//}
translate <0,0,0>
  scale <1.500000, 1.500000, 1.500000>
  scale 56
}

#declare sexy_height =
    pigment {
        image_map { gif "blot.gif" interpolate 2 }
    rotate x*90                  // rotate the image to the x/z plane
    translate <-0.5, 0, -0.5>    // center the whole shebang
}

#declare sexy_picture = texture {
                        sexy_height
                        finish {
                        Metal
                        }
                        scale 4
                        }

 light_source {<20, 30, -100> colour 1}

#declare eye_ball = object {
      sphere { <0, 0, 0>, 0.5 }
      texture {
         pigment {
            image_map {
               gif
               "eye.gif"
             //  interpolate Bi
            }
            translate <-0.5, -0.5, 0>
         }
         finish {
            ambient 0.3
            diffuse 0.45
            specular 0.9
            roughness 0.001
            phong 1.0
            phong_size 70
            reflection 0.25
         }
      }
      scale 2
      scale 20
   }







#include "skies.inc"

#declare Sky_Top = 2500  // The distance from ground to the top of the sky

// A few different color_maps for the clouds, all of these are ok.

#declare Colors1 = color_map
   {
   [0.0 0.1 color rgb <2/3, 2/3, 1> color rgb <2/3, 2/3, 1>]
   [1.0 color White]
   }

#declare Colors2 = color_map  // Realistic
   {
   [0.0 0.1 color SkyBlue color SkyBlue]
   [1.0 color White]
   }

#declare Colors3 = color_map  // Very realistic!
   {
   [0.0 0.1 color SkyBlue color SkyBlue]
   [0.70 color rgb <4/5, 4/5, 5/6>]
   [1.0 color White]
   }

#declare Storm = color_map  // looks quite heavy with SkyColor in the lower layer!
   {
   [0.0 0.1 color Clear color Clear]
   [0.70 color rgbf <4/5, 4/5, 5/6, 1/2>]
   [1.0 color White]
   }

#declare CloudSky = texture  // this is the cloud texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      octaves 3   // doesn't have much effect
      lambda 11    // bigger values are worth trying
      color_map { Colors3 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6   // please notice
   }

#declare CloudSky1 = texture  // this is the cloud texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      octaves 3   // doesn't have much effect
      lambda 11    // bigger values are worth trying
      color_map { Colors1 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6   // please notice
   }

   #declare CloudSky2 = texture  // this is the cloud texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      octaves 3   // doesn't have much effect
      lambda 11    // bigger values are worth trying
      color_map { Colors2 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6   // please notice
   }
#declare oops_aah = texture {
                    wood

                    texture_map {
                    [0.0 flame scale 0.1]
                    [0.2 nice_stone2 scale 2]
                    [0.3 Jade scale 2]
                    [0.5 Stone40 scale 2 finish {ambient 0.6 diffuse 0.4 reflection 0.9}]
                    [0.6 totally_twisted scale 2]
                    [0.7 metal_bozo2 scale 2]
                    [0.9 Stone21 scale 2]
                    [1.01 Chaos2 scale 0.8]
                    }
                    scale 1/6
                    translate <0,0,0>
                    rotate x*-90
                    scale 0.8
                    scale 2
                    scale 0.4
                    scale 2.5
                    scale 2.2
                    }






#declare gray_sky =

      texture {
         pigment {
            onion
            turbulence 0.8
            color_map {
               [0.00, 0.10 color Gray40 color Gray30]
               [0.10, 0.11 color Gray30 color Wheat]
               [0.11, 0.14 color Wheat color Gray30]
               [0.14, 0.30 color Gray30 color Black]
               [0.30, 0.32 color Black color White ]
               [0.32, 0.33 color White color Black ]
               [0.33, 1.01 color Black color Gray40]
            }
         }
         finish {
            ambient 0.8
            diffuse 0.0
         }
         scale <1.5, 1, 1>
         scale 0.32
         rotate <0, -5, 0>
         scale 2.5
      }

   #declare blue_sky = texture {
pigment {
   bozo
   octaves 3
   lambda 24
   turbulence 0.3
            color_map {
               [0.00, 0.10 color Scarlet color Orange]
               [0.10, 0.11 color Orange color NeonBlue]
               [0.11, 0.14 color NeonBlue color Orange]
               [0.14, 0.30 color Orange color Black]
               [0.30, 0.32 color Black color White ]
               [0.32, 0.33 color White color Black ]
               [0.33, 1.01 color Black color Scarlet]
            }}
            scale 1/6
            }

            #declare red_sky =

      texture {
         pigment {
            onion
            turbulence 0.8
            color_map {
               [0.00, 0.10 color Red color Scarlet]
               [0.10, 0.11 color Scarlet color Orange]
               [0.11, 0.14 color Orange color Scarlet]
               [0.14, 0.30 color Scarlet color Black]
               [0.30, 0.32 color Black color White ]
               [0.32, 0.33 color White color Black ]
               [0.33, 1.01 color Black color Red]
            }
         }
         finish {
            ambient 0.8
            diffuse 0.0
         }
         scale <1.5, 1, 1>
         scale 0.32
         rotate <0, -5, 0>
         scale 2.5
      }



#declare cloud_map = texture {
bozo
turbulence 1.10
texture_map {
[0.0 Bright_Blue_Sky]
[0.01 Stone40]
[0.02 flame scale 0.10]
[0.22 CloudSky2]
[0.3  CloudSky]
[0.5  CloudSky1]
[0.51 Chaos5 scale 0.1]
[0.7  Starfield3 scale 2]
[1.001 CloudSky1]
}
translate <0,0,0>
scale 1/6

scale <2.5,1.6,1.6>
rotate <0,-12,0>
scale 0.32
scale 2.5
translate <0,0,0>
}


#declare psyc_sky = texture {
                    radial
                    frequency 4
                    rotate -x * 90
                  //  octaves 2.5
                 //   lambda 8
                    turbulence 1.5
                    texture_map {
                    [0.0  Blue_Sky scale <4,2,3>]
                    [0.1  Chaos5 scale 0.8]
                    [0.22 red_sky scale 2]
                    [0.34 blue_sky scale 2]
                    [0.5  Starfield3 scale 1.4]
                    [0.7  P_Cloud1 scale 1.1]
                    [0.72 P_Cloud3 scale 1.1]
                    [0.74 P_Cloud4 scale 1.2]
                    [0.76 P_Cloud2 scale 1.2]
                    [0.8  Chaos3 scale 4]
                    [0.81 cloud_map scale 2]
                    [1.01 cloud_map scale 2]
                    }
                    scale 1/6
                    scale <12,7.5,8> * 1.25 * 1.33
                    }


#declare semi_mirror = finish {ambient 0.3 diffuse 0.01 reflection 0.4 specular 1.0 roughness 0.00001}

#declare skymap2 = texture_map {
[0.0 CloudSky finish {semi_mirror}]
[0.0 CloudSky finish {semi_mirror}]
[0.25 fractal_sky1 scale 0.1]
[0.25 fractal_sky1 scale 0.1]
[0.33 psyc_sky scale 2]
[0.5 sexy_picture scale 0.1]
[0.5 sexy_picture scale 0.1]
[0.6 psyc_sky scale 2]
[0.75 Chaos5 scale 0.8]
[0.75 Chaos5 scale 0.8]
[1.0 Silver_Texture finish {semi_mirror}]
[1.0 Silver_Texture finish {semi_mirror}]
}

#declare radial_sky =
                    texture {

   radial
   frequency 4.2
   phase 1.5
   turbulence 0.1
   rotate x*90
   translate <0,0,0>
   texture_map {skymap2}
   translate <0,0,0>
   scale 0.25

                    }

#declare wood_sky = texture {
                    bozo
                    turbulence 0.8

                    texture_map {
                    [0.0 psyc_sky scale 0.8]

                    [1.02 CloudSky]
                    }
                    scale 0.25
                    }




sphere  // the sky globe -- please notice the scalings!
   {
   <0, 0, 0>, 1
   texture { wood_sky scale 2}
   scale <Sky_Top*10, (Sky_Top*3.89), Sky_Top*10> * 2.5
   hollow
   no_shadow
   }


#include "eel.inc"

object {
		TheFormObject
                translate <0,0,0>
                scale 225
}




object {
dream_box
translate <0,0,0>
}
