//
// Just An Otter Day In Paradise
// by Dale E. Cieslak
// June 1998
//

// Camera 

camera
  {
  location  <-12.971, -19.977, 24.012>
  direction <0.0,     0.0,  3.4513>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-0.201, 1.430, 1.152>
  }

// Lights

light_source
  {
  <6.0, 3.0, 30>
  color rgb .8
  }

light_source
  {
  <6.3, 3.0, 27>
  color rgb .35
  }

light_source
  {
  <5.7, 3.0, 27>
  color rgb .3
  }

// Textures

#include "colors.inc"
#include "stones.inc"

// Objects

#include "bubbles.inc"

// otter body

blob
  {
  threshold 0.3
  cylinder                                         // main body
    {
    <0,0,6>, <0,0,0>, 1.25, 1
    scale <1.25, 0.6, 1.0>
    rotate -90.0*x
    }
  cylinder                                         // neck
    {
    <0,0,2>, <0,0,0>, 1.25, 1
    scale <1.0, 0.6, 1.0>
    rotate 90.0*x
    }
  sphere                                           // shoulders
    {
    <0,0,0>,1.25, 1
    scale <1.1, 1.1, 0.61>
    }
  sphere                                           // ribs
    {
    <0,0,0>,1.1, 1
    scale <1.2, 2.0, 0.61>
    translate  2.0*y
    }
  sphere                                           // head
    {
    <0,0,0>,1.25, 1
    scale <0.8, 0.8, 0.6>
    translate  -2.0*y
    }
  sphere                                           // left half of mouth
    {
    <0,0,0>,1.25, 1
    scale <0.35, 0.5, 0.333333>
    rotate -20.0*z
    translate  <-0.553322, -2.58741, 0.0>
    pigment
      {
      leopard
      color_map
        {
        [0.0 color rgb <1, .9, .8>]
        [0.7 color rgb <1, .9, .8>]
        [1.0 color rgb 0]
        }
      scale .01
      }
    normal
      {
      bumps .25
      scale .05
      }
    finish
      {
      ambient 0.35
      diffuse .2
      }
    }
  sphere                                            // right half of mouth
    {
    <0,0,0>,1.25, 1
    scale <0.35, 0.5, 0.333333>
    rotate -20.0*z
    translate  <-0.02191, -2.77716, 0.0>
    pigment
      {
      leopard
      color_map
        {
        [0.0 color rgb <1, .9, .8>]
        [0.7 color rgb <1, .9, .8>]
        [1.0 color rgb 0]
        }
      scale .01
      }
    normal
      {
      bumps .25
      scale .05
      }
    finish
      {
      ambient 0.35
      diffuse .2
      }
    }
  sphere                                          // posterior
    {
    <0,0,0>,1.25, 1
    scale <0.9, 1.2, 0.55>
    translate  6.0*y
    }
  sphere                                          // base of tail
    {
    <0,0,0>,1.25, 1
    scale <0.75, 1.0, 0.4>
    translate  <0.0, 6.48102, 0.208783>
    }
  sphere                                          // bridge of nose ?
    {
    <0,0,0>,1.25, 1
    scale <0.3, 0.5, 0.2>
    rotate <13.722857, 0.0, -20.0>
    translate  <-0.12928, -2.43307, 0.341224>
    }
  sphere                                          // tail
    {
    <0,0,0>,1.25, 2
    scale <0.6, 0.8, 0.3>
    translate  <0.0, 6.98102, 0.322664>
    }
  sphere                                          // more tail
    {
    <0,0,0>,1.25, 2
    scale <0.5, 0.7, 0.3>
    translate  <0.045279, 7.4051, 0.360625>
    }
  sphere                                          // even more tail
    {
    <0,0,0>,1.25, 2
    scale <0.5, 0.6, 0.3>
    translate  <0.090557, 7.75, 0.360625>
    }
  sphere                                          // still more tail
    {
    <0,0,0>,1.25, 2
    scale <0.475, 0.475, 0.285>
    translate  <0.137296, 8.01898, 0.360625>
    }
  sphere                                          // and yet again, tail
    {
    <0,0,0>,1.25, 2
    scale <0.45125, 0.45125, 0.27075>
    translate  <0.17162, 8.25, 0.360625>
    }
  sphere                                          // one guess...yep, tail
    {
    <0,0,0>,1.25, 2
    scale <0.428688, 0.428688, 0.257213>
    translate  <0.137296, 8.46568, 0.379605>
    }
  sphere                                          // and the tail continues
    {
    <0,0,0>,1.25, 2
    scale <0.407253, 0.407253, 0.244352>
    translate  <0.137296, 8.73102, 0.379605>
    }
  sphere                                          // just how long is this tail?
    {
    <0,0,0>,1.25, 2
    scale <0.38689, 0.38689, 0.232134>
    translate  <0.102972, 8.98102, 0.398586>
    }
  sphere                                          // tail, tail, tail
    {
    <0,0,0>,1.25, 2
    scale <0.367546, 0.367546, 0.220528>
    translate  <0.068648, 9.21204, 0.398586>
    }
  sphere                                          // STILL the tail
    {
    <0,0,0>,1.25, 2
    scale <0.349169, 0.349169, 0.209501>
    translate  <0.0, 9.49636, 0.379605>
    }
  sphere                                          // one more tail piece
    {
    <0,0,0>,1.25, 2
    scale <0.349169, 0.349169, 0.209501>
    translate  <-0.01, 9.69636, 0.379605>
    }
  sphere                                          // oh, oh, for the longest tail
    {
    <0,0,0>,1.25, 2
    scale <0.33171, 0.33171, 0.199026>
    translate  <-0.034324, 9.84934, 0.360625>
    }
  sphere                                          // oh, the tails I could tell
    {
    <0,0,0>,1.25, 2
    scale <0.33171, 0.33171, 0.199026>
    translate  <-0.045324, 9.95934, 0.360625>
    }
  sphere                                          // the tail, have mercy
    {
    <0,0,0>,1.25, 2
    scale <0.315125, 0.315125, 0.189075>
    translate  <0.068648, 10.06501, 0.360625>
    }
  sphere                                          // 2nd to last piece of tail
    {
    <0,0,0>,1.25, 2
    scale <0.315125, 0.315125, 0.189075>
    translate  <0.148648, 10.15501, 0.360625>
    }
  sphere                                          // the tip of the tail
    {
    <0,0,0>,1.25, 2
    scale <0.299368, 0.299368, 0.179621>
    translate  <0.240268, 10.23102, 0.322664>
    }
  sphere                                          // left "eyebrow"
     {
     <0,0,0>,1.25, 1
     scale 0.2
     rotate -20.0*z
     translate  <-0.462233, -2.16974, 0.302102>
     pigment
       {
       color rgb 1
       }
     finish
       {
       ambient 0.35
       diffuse .2
       }
     }
  sphere                                          // right "eyebrow"
     {
     <0,0,0>,1.25, 1
     scale 0.2
     rotate -20.0*z
     translate  <0.202273, -2.50526, 0.282102>
     pigment
       {
       color rgb 1
       }
     finish
       {
       ambient 0.35
       diffuse .2
       }
     }
  sphere                                          // front leg, section 1
    {
    <0,0,0>,1.1, 1
    scale <0.3, 0.4, 0.275>
    rotate 26.396276*z
    translate  <-0.7521284, -0.311238, -0.227367>
    }
  sphere                                          // front leg, section 2
    {
    <0,0,0>,1.1, 1
    scale <0.3, 0.4, 0.275>
    rotate 26.396276*z
    translate  <-0.921284, -0.211238, -0.227367>
    }
  sphere                                          // front leg, section 3
    {
    <0,0,0>,1.1, 1.25
    scale <0.25, 0.333333, 0.25>
    rotate 19.968737*z
    translate  <-1.047333, -0.084601, -0.227367>
    }
  sphere                                          // front leg, section 4
    {
    <0,0,0>,1.1, 1.25
    scale <0.2, 0.266667, 0.2>
    rotate 19.968737*z
    translate  <-1.160539, 0.059911, -0.227367>
    }
  sphere                                          // front leg, section 5
    {
    <0,0,0>,1.1, 1.25
    scale <0.2, 0.266667, 0.1>
    rotate 19.968737*z
    translate  <-1.160539, 0.189911, -0.227367>
    }
  sphere                                          // front foot webbing
    {
    <0,0,0>,2, 1.25
    scale <0.25, 0.266667, 0.04>
    rotate <-0.844902, 53.061436, -4.603447>
    translate  <-1.273744, 0.380798, -0.227367>
    pigment
      {
      color rgb 0
      }
    }
  cylinder                                        // front toe 1
    {
    <0,0,1>, <0,0,0>, 1.1, 1
    scale <0.1, 0.1, 0.3>
    rotate <-66.218269, 34.693832, 21.243994>
    translate  <-1.299056, 0.241068, -0.248432>
    pigment
      {
      color rgb 0
      }
    }
  cylinder                                        // front toe 2
    {
    <0,0,1>, <0,0,0>, 1.1, 1
    scale <0.1, 0.1, 0.3>
    rotate <-103.359398, 32.200764, -23.461895>
    translate  <-1.268791, 0.228962, -0.248432>
    pigment
      {
      color rgb 0
      }
    }
  cylinder                                        // front toe 3
    {
    <0,0,1>, <0,0,0>, 1.1, 1
    scale <0.1, 0.1, 0.3>
    rotate <-127.620659, 21.812115, -43.287056>
    translate  <-1.268791, 0.147565, -0.223387>
    pigment
      {
      color rgb 0
      }
    }
  sphere                                          // back foot webbing
    {
    <0,0,0>,2, 1
    scale <0.3, 0.288, 0.04>
    rotate <10.880809, 10.436781, 12.020343>
    translate  <-1.139523, 6.76134, -0.236681>
    pigment
      {
      color rgb <.5, .3, .2>
      }
    finish
      {
      diffuse .4
      }
    }
  sphere                                          // back leg 1
    {
    <0,0,0>,1.1, 1
    scale <0.25, 0.266667, 0.15>
    rotate 9.835549*z
    translate  <-1.127211, 6.368205, -0.227367>
    }
  sphere                                          // back leg 2
    {
    <0,0,0>,1.1, 1
    scale <0.3, 0.7, 0.2>
    rotate 10.052822*z
    translate  <-1.043172, 6.11918, -0.227367>
    }
  sphere                                          // back leg 3
    {
    <0,0,0>,1.1, 1
    scale <0.3, 0.4, 0.25>
    rotate 26.396276*z
    translate  <-1.013015, 5.74004, -0.227367>
    }
  sphere                                          // back leg 4
    {
    <0,0,0>,1.1, 1
    scale <0.3, 0.4, 0.25>
    rotate 26.396276*z
    translate  <-0.973015, 5.44004, -0.227367>
    }
  sphere                                          // back leg 5
    {
    <0,0,0>,1.1, 1
    scale <0.45, 0.6, 0.3>
    rotate 26.396276*z
    translate  <-0.922882, 5.38782, -0.227367>
    }
  cylinder                                        // back toe 1
    {
    <0,0,1>, <0,0,0>, 1.5, 1
    scale <0.1, 0.1, 0.3>
    rotate <-84.469818, 10.251554, 39.721569>
    translate  <-1.284159, 6.527355, -0.272635>
    pigment
      {
      color rgb <.4, .2, .1>
      }
    finish
      {
      diffuse 0
      }
    }
  cylinder                                        // back toe 2
    {
    <0,0,1>, <0,0,0>, 1.5, 1
    scale <0.1, 0.1, 0.275>
    rotate <-84.675064, 12.927206, 9.139853>
    translate  <-1.215539, 6.63311, -0.272635>
    pigment
      {
      color rgb <.4, .2, .1>
      }
    finish
      {
      diffuse 0
      }
    }
  cylinder                                        // back toe 3
    {
    <0,0,1>, <0,0,0>, 1.5,1
    scale <0.1, 0.1, 0.275>
    rotate <-85.024933, 14.815845, -13.642519>
    translate  <-1.107014, 6.62923, -0.272635>
    pigment
      {
      color rgb <.4, .2, .1>
      }
    finish
      {
      diffuse 0
      }
    }
  cylinder                                        // back toe 4
    {
    <0,0,1>, <0,0,0>, 1.5, 1
    scale <0.1, 0.1, 0.27>
    rotate <-85.793823, 15.590658, -36.775219>
    translate  <-1.035018, 6.54228, -0.272635>
    pigment
      {
      color rgb <.4, .2, .1>
      }
    finish
      {
      diffuse 0
      }
    }
  cylinder
    {
    <0,0,1>, <0,0,0>, 1.1,1
    scale <0.025, 0.025, 0.3>
    rotate <-50.900501, 20.999973, 43.182827>
    translate  <-1.299056, 0.138585, -0.248432>
    pigment
      {
      color rgb 0
      }
    }
  sphere
    {
    <0,0,0>,1.1, 1
    scale <0.3, 0.4, 0.3>
    rotate 26.396276*z
    translate  <-0.906577, -0.373257, -0.227367>
    }
  sphere
    {
    <0,0,0>,1.1, 1
    scale <0.45, 0.7, 0.4>
    rotate 26.396276*z
    translate  <-0.909801, 4.921509, -0.227367>
    }

  texture
    {
    pigment
      {
      granite
      color_map
        {
        [0.0 color rgb <.6, .4, .2>]
        [0.6 color rgb <.4, .2, .1>]
        [0.8 color rgb <.4, .2, .1>]
        [1.0 color rgb <.3, .1, 0>]
        }
      rotate 90*y
      scale 50
      }
    normal
      {
      wrinkles .9
      scale <.1, 2, .1>
      }
    finish
      {
      ambient 0.35
      }
    scale <.25, .25, .25>
    }
  }
// end otterBody

// nose
sphere
  {
  <0,0,0>,1
  texture
    {
    pigment
      {
      color rgb 0
      }
    normal
      {
      bumps 0.25
      scale .01
      }
    finish
      {
      phong .25
      phong_size 10
      }
    }
  scale <0.35, 0.35, 0.25>
  rotate -20.0*z
  translate  <-0.27876, -2.83193, 0.051027>
  }

// eyes

// left eye
sphere
  {
  <0,0,0>,1
  texture
    {
    pigment
      {
      color rgb 0
      }
    finish
      {
      phong 1
      phong_size 100
      reflection 0.25
      }
    }
  scale 0.2
  rotate -20.0*z
  translate  <-0.542233, -2.28974, 0.222102>
  }

// right eye
sphere
  {
  <0,0,0>,1
  texture
    {
    pigment
      {
      color rgb 0
      }
    finish
      {
      phong 1
      phong_size 100
      }
    }
  scale 0.2
  rotate -20.0*z
  translate  <0.212273, -2.58526, 0.222102>
  }

// eyelids

// left eyelid
sphere
  {
  <0,0,0>,1
  texture
    {
    pigment
      {
      color rgbf 1
      }
    finish
      {
      ambient 0.35
      diffuse .2
      }
    }
  scale <0.2, 0.15, 0.075>
  rotate -30*x
  rotate -20.0*z
  translate  <-0.492233, -2.21974, 0.342102>
  }

sphere { // Sphere22
  <0,0,0>,1
  texture {
     pigment {color rgbf 1}
     finish {ambient 0.35 diffuse .2}
  }
  scale <0.2, 0.15, 0.075>
  rotate -30*x
  rotate -20.0*z
  translate  <0.222273, -2.54526, 0.332102>
}

// whiskers
// whisker1
difference
  {
  torus
    {
    1.15, 0.005  rotate -x*90
    texture
      {
      pigment
        {
        color rgb 1
        }
      finish
        {
        ambient 0.2
        }
      }
    scale <1.0, 0.75, 1.0>
    rotate -90.0*x
    translate <0.0, -3.0, -1.0>
    }
  box
    {
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.1, 1.0>
    translate <0.0, -2.998714, -1.984863>
    }
  texture
    {
    pigment
      {
      color rgbf <1, 1, 1, .5>
      }
    finish
      {
      ambient 0.2
      }
    }
  scale <0.7, 1.0, 0.4>
  rotate -20.0*z
  translate <0.706063, -0.120235, 0.2>
  no_shadow
  }

// whisker2
difference
  {
  torus
    {
    1.15, 0.005  rotate -x*90
    texture
      {
      pigment
        {
        color rgb 1
        }
      finish
        {
        ambient 0.2
        }
      }
    scale <1.0, 0.75, 1.0>
    rotate -90.0*x
    translate <0.0, -3.0, -1.0>
    }
  box
    {
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.1, 1.0>
    translate <0.0, -2.998714, -1.984863>
    }
  texture
    {
    pigment
      {
      color rgbf <1, 1, 1, .5>
      }
    finish
      {
      ambient 0.2
      }
    }
  scale <0.75, 1.0, 0.25>
  rotate -20.0*z
  translate <0.706173, -0.175278, 0.2>
  no_shadow
  }

// whisker3
difference
  {
  torus
    {
    1.15, 0.005  rotate -x*90
    texture
      {
      pigment
        {
        color rgb 1
        }
      finish
        {
        ambient 0.2
        }
      }
    scale <1.0, 0.75, 1.0>
    rotate -90.0*x
    translate  <0.0, -3.0, -1.0>
    }
  box
    {
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.1, 1.0>
    translate <0.0, -2.998714, -1.984863>
    }
  texture
    {
    pigment
      {
      color rgbf <1, 1, 1, .5>
      }
    finish
      {
      ambient 0.2
      }
    }
  scale <0.75, 1.0, 0.25>
  rotate -20.0*z
  translate <0.716181, -0.150258, 0.2>
  no_shadow
  }

// whisker4
difference
  {
  torus
    {
    1.15, 0.005  rotate -x*90
    texture
      {
      pigment
        {
        color rgb 1
        }
      finish
        {
        ambient 0.2
        }
      }
    scale <1.0, 0.75, 1.0>
    rotate -90.0*x
    translate <0.0, -3.0, -1.0>
    }
  box
    {
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.1, 1.0>
    translate <0.0, -2.998714, -1.984863>
    }
  texture
    {
    pigment
      {
      color rgbf <1, 1, 1, .5>
      }
    finish
      {
      ambient 0.2
      }
    }
  scale <0.75, 1.0, 0.6>
  rotate -20.0*z
  translate <0.728745, -.1, .2>
  no_shadow
  }

// whisker5
difference
  {
  torus
    {
    1.15, 0.005
    rotate -x*90
    texture
      {
      pigment
        {
        color rgb 1
        }
      finish
        {
        ambient 0.2
        }
      }
    scale <1.0, 0.75, 1.0>
    rotate -90.0*x
    translate <0.0, -3.0, -1.0>
    }
  box
    {
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.1, 1.0>
    translate <0.0, -2.998714, -1.984863>
    }
  texture
    {
    pigment
      {
      color rgbf <1, 1, 1, .5>
      }
    finish
      {
      ambient 0.2
      }
    }
  scale <0.85, 1.0, 0.1>
  rotate -20.0*z
  translate <0.706063, -0.120235, 0.2>
  no_shadow
  }

// Background

// sea floor
height_field
  {
  tga               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "riverbed.tga"     // the file name to read
  smooth

  translate <-.5 0 -.5>
  rotate <90 0 0>
  scale <100, 100, 1.0>

  translate <50, 50, 0>
  translate <0 0 5>
  rotate <180 0 0>

  texture
    {
    pigment
      {
      granite
      color_map
        {
        [0.0 color rgb <.6, .5, .4>]
        [0.2 color rgb <.6, .4, .2>]
        [0.5 color rgb <.5, .5, .4>]
        [0.6 color rgb <.4, .3, .1>]
        [1.0 color rgb <.5, .3, .2>]
        }
      translate <25, 10, 0>
      scale 50
      }
    normal
      {
      wrinkles .8
      }
    finish
      {
      ambient .4
      }
    }
  translate <-50, 0, 0>
  hollow
  }

// water surface
plane
  {
  <0, 0, 1>, 6
  pigment
    {
    color rgbf <.9, 1, 1, .75>
    }
  normal
    {
    //bumps .5
    //dents .5
    //wrinkles .5
    //crackle .5
    spotted 1
    scale 1
    }
  finish
    {
    caustics 1
    refraction 1
    ior 1.05
    }
  hollow
  }

// Rocks

// Rock4
blob
  {
  sphere
    {
    <0,0,0>,1.25, 1
    }
  sphere
    {
    <0,0,0>,1.25, 1
    scale 0.750313
    translate  <0.712126, -0.430969, -0.249687>
    }
  sphere
    {
    <0,0,0>,1.25, 1
    scale 0.950063
    translate  -0.574626*y
    }
  texture
    {
    T_Grnt10a
    normal
      {
      bumps 1
      scale .1
      }
    }

  scale <1.0, 1.0, 0.5>
  translate  <-4.215485, 3.375925, -4.5>
  }

// Rock3
superellipsoid
  {
  <0.6, 0.8>
  texture
    {
    T_Grnt27
    scale 5
    normal
      {
      bumps 1
      scale .1
      }
    }
  scale <0.75, 0.75, 1.125>
  rotate <-80.0, -22.5, -86.0>
  translate <-1, 1, -4>
  }

// Rock2
superellipsoid
  {
  <0.5, 0.3>
  texture
    {
    T_Grnt18
    scale 8
    normal
      {
      dents 1
      scale .1
      }
    }
  scale <1.25, 0.9, 1.0>
  rotate <-45.0, -25.0, 0.0>
  translate <-2.035914, 6.663238, -4.25>
  }

// Rock1
superellipsoid
  {
  <0.3, 1.0>
  texture
    {
    T_Grnt4
    scale 5
    normal
      {
      dents 1
      scale .1
      }
    }
  scale <0.8, 1.2, 0.8>
  rotate <0 45 45>
  translate <4.543335, 5.80267, -4.5>
  }

// Rock4
blob
  {
  sphere
    {
    <0,0,0>,1.25, 1
    }
  sphere
    {
    <0,0,0>,1.25, 1
    scale 0.750313
    translate <0.712126, -0.430969, -0.249687>
    }
  sphere
    {
    <0,0,0>,1.25, 1
    scale 0.950063
    translate -0.574626*y
    }
  texture
    {
    T_Grnt10
    scale 8
    normal
      {
      wrinkles 1
      scale .1
      }
    }
  scale <1.0, 1.0, 0.5>
  scale 2
  rotate <0 0 45>
  translate <8.215485, 12.375925, -4.5>
  }

// Rock4
blob
  {
  sphere
    {
    <0,0,0>,1.25, 1
    }
  sphere
    {
    <0,0,0>,1.25, 1
    scale 0.750313
    translate <0.712126, -0.430969, -0.249687>
    }
  sphere
    {
    <0,0,0>,1.25, 1
    scale 0.950063
    translate -0.574626*y
    }
  texture
    {
    T_Grnt9a
    scale 8
    }
  scale <1.0, 1.0, 0.5>
  scale 1.75
  rotate <90 0 45>
  translate <11.215485, 10.375925, -4.75>
  }

// Rock4
blob
  {
  sphere
    {
    <0,0,0>,1.25, 1
    }
  sphere
    {
    <0,0,0>,1.25, 1
    scale 0.750313
    translate <0.712126, -0.430969, -0.249687>
    }
  sphere
    {
    <0,0,0>,1.25, 1
    scale 0.950063
    translate -0.574626*y
    }
  texture
    {
    T_Grnt10
    scale 8
    }
  scale <1.0, 1.0, 0.5>
  rotate <50 10 65>
  translate <8.215485, 2.375925, -4.5>
  }

// Rock4
blob
  {
  sphere
    {
    <0,0,0>,1.25, 1
    }
  sphere
    {
    <0,0,0>,1.25, 1
    scale 0.750313
    translate <0.712126, -0.430969, -0.249687>
    }
  sphere
    {
    <0,0,0>,1.25, 1
    scale 0.950063
    translate -0.574626*y
    }
  texture
    {
    T_Grnt10
    scale 8
    }
  scale <1.0, 1.0, 0.5>
  scale .75
  rotate <10 0 25>
  translate <7.215485, 1.375925, -4.5>
  }
