/* Biotex.inc : gepredefinieerde pigmenten en texturen
   Pigmenten : extra bovenop Color.inc
   Texturen :
      Tex : nog van oude formstempel
      Texwith : is Tex met granite normal
      Knap
      Kool
      PaarsRood : nog van oude formstempel
      Pukkels
      WitGeel : nog van oude formstempel
      WitBlauw : nog van oude formstempel
      Octo : nog van oude formstempel
      Negativ1
      EyeBall
      Spiderj
      Kwal (werkt nog niet fameus)
      HullTex
      GridTex
      Graniet
      Slime

*/

//   PIGMENTEN

#declare Apricot          = color red 1.00 green 0.33 blue 0.33 //
#declare Aquamarine       = color red 0.00 green 0.40 blue 0.60 //
#declare Banana           = color red 0.89 green 0.81 blue 0.34 //
#declare Black            = color red 0.00 green 0.00 blue 0.00 //
#declare Blue             = color red 0.00 green 0.00 blue 1.00 //
#declare Blue_green       = color red 0.00 green 0.60 blue 0.53 //
#declare Blue_gray        = color red 0.47 green 0.47 blue 0.60 //
#declare Blue_violet      = color red 0.60 green 0.00 blue 1.00 //
#declare Brick_red        = color red 0.80 green 0.27 blue 0.00 //
#declare Brown            = color red 0.67 green 0.27 blue 0.00 //
#declare Burnt_orange     = color red 1.00 green 0.40 blue 0.00 //
#declare Burnt_sienna     = color red 0.80 green 0.33 blue 0.00 //
#declare Burnt_umber      = color red 0.54 green 0.20 blue 0.14 //
#declare Cadet_blue       = color red 0.60 green 0.60 blue 0.80 //
#declare Carnation_pink   = color red 1.00 green 0.53 blue 0.67 //
#declare Cerulean_blue    = color red 0.02 green 0.72 blue 0.80 //
#declare Clear            = rgbf 1                              //
#declare Cobalt_blue      = color red 0.24 green 0.35 blue 0.67 //
#declare Copper           = color red 0.33 green 0.67 blue 0.00 //
#declare Coral            = color red 1.00 green 0.49 blue 0.31 //
#declare Cornflower       = color red 0.00 green 0.00 blue 0.80 //
#declare Cyan             = color red 0.00 green 1.00 blue 1.00 //
#declare Dark_gray        = color red 0.40 green 0.40 blue 0.40 //
#declare Dark_green        = color red 0.184 green 0.31 blue 0.184 //
#declare Dark_purple      = color red 0.47 green 0.00 blue 0.47 //
#declare Eggshell         = color red 0.99 green 0.90 blue 0.79 //
#declare Firebrick        = color red 0.69 green 0.13 blue 0.13 //
#declare Forest_green     = color red 0.67 green 0.40 blue 0.00 //
#declare Gold             = color red 1.00 green 0.80 blue 0.00 //
#declare Goldenrod        = color red 1.00 green 0.67 blue 0.00 //
#declare Gray             = color red 0.60 green 0.60 blue 0.60 //
#declare Green            = color red 0.00 green 1.00 blue 0.00 //
#declare Green_blue       = color red 0.00 green 0.67 blue 0.73 //
#declare Green_yellow     = color red 0.40 green 0.87 blue 0.00 //
#declare Indian_red       = color red 0.67 green 0.27 blue 0.00 //
#declare Khaki            = color red 0.94 green 0.90 blue 0.55 //
#declare Lavender         = color red 0.80 green 0.53 blue 0.80 //
#declare Lemon_yellow     = color red 0.93 green 1.00 blue 0.00 //
#declare Magenta          = color red 1.00 green 0.00 blue 1.00 //
#declare Mahogany         = color red 0.73 green 0.27 blue 0.00 //
#declare Maize            = color red 0.93 green 0.60 blue 0.00 //
#declare Maroon           = color red 0.73 green 0.20 blue 0.00 //
#declare Melon            = color red 1.00 green 0.47 blue 0.40 //
#declare Midnight_blue    = color red 0.00 green 0.00 blue 0.40 //
#declare Mulberry         = color red 0.80 green 0.00 blue 0.60 //
#declare Navy_blue        = color red 0.00 green 0.00 blue 0.80 //
#declare Ochre_deep       = color red 0.45 green 0.24 blue 0.10 //
#declare Ochre_flesh      = color red 1.00 green 0.34 blue 0.13 //
#declare Ochre_gold       = color red 0.78 green 0.47 blue 0.15 //
#declare Olive_green      = color red 0.53 green 0.47 blue 0.00 //
#declare Orange           = color red 1.00 green 0.40 blue 0.00 //
#declare Orange_red       = color red 1.00 green 0.27 blue 0.00 //
#declare Orange_yellow    = color red 1.00 green 0.73 blue 0.00 //
#declare Orchid           = color red 1.00 green 0.00 blue 0.80 //
#declare Peach            = color red 1.00 green 0.60 blue 0.40 //
#declare Periwinkle       = color red 0.80 green 0.73 blue 0.93 //
#declare Pine_green       = color red 0.07 green 0.40 blue 0.00 //
#declare Pink             = color red 1.00 green 0.60 blue 0.73 //
#declare Plum             = color red 0.80 green 0.07 blue 0.80 //
#declare Purple           = color red 0.80 green 0.33 blue 0.80 //
#declare Raw_sienna       = color red 0.60 green 0.40 blue 0.07 //
#declare Raw_umber        = color red 0.47 green 0.27 blue 0.00 //
#declare Red              = color red 1.00 green 0.00 blue 0.00 //
#declare Red_orange       = color red 1.00 green 0.47 blue 0.00 //
#declare Red_violet       = color red 0.87 green 0.07 blue 0.80 //
#declare Salmon           = color red 1.00 green 0.60 blue 0.60 //
#declare Sea_green        = color red 0.73 green 0.93 blue 0.80 //
#declare Sepia            = color red 0.47 green 0.27 blue 0.00 //
#declare Silver           = color red 0.47 green 0.47 blue 0.47 //
#declare Sky_blue         = color red 0.53 green 0.80 blue 1.00 //
#declare Steel_blue       = color red 0.53 green 0.53 blue 0.80 //
#declare Spring_green     = color red 0.73 green 1.00 blue 0.73 //
#declare Tan              = color red 0.87 green 0.47 blue 0.20 //
#declare Thistle          = color red 1.00 green 0.53 blue 0.87 //
#declare Turquoise_blue   = color red 0.27 green 0.33 blue 0.80 //
#declare Ultramarine      = color red 0.07 green 0.04 blue 0.56 //
#declare Violet           = color red 0.73 green 0.00 blue 0.80 //
#declare Violet_blue      = color red 0.73 green 0.00 blue 1.00 //
#declare Violet_red       = color red 1.00 green 0.00 blue 0.47 //
#declare White            = color red 1.00 green 1.00 blue 1.00 //
#declare Yellow           = color red 1.00 green 1.00 blue 0.00 //
#declare Yellow_green     = color red 0.00 green 0.87 blue 0.47 //
#declare Yellow_orange    = color red 1.00 green 0.60 blue 0.00 //


//   TEXTUREN

//--Tex---------------------------------------------------------

#declare Tex =
texture {
pigment {
               granite
                 color_map {
                   [0.1 color Eggshell]
                   [0.3 color Eggshell]
                   [0.45 color Sepia]
                   [0.5 color Burnt_orange]
                   [0.55 color Sepia]
                   [0.6 color Burnt_orange]
                   [0.8 color Peach]
                            }
                turbulence .4  scale .2
                      }
             finish {phong 0.3 phong_size 20 ambient .4 diffuse .6}}

//--Texwith------------------------------------------------------

#declare Texwith =
texture {
pigment {
               granite
                 color_map {
                   [0.1 color White ]
                   [0.3 color White]
                   [0.45 color Sepia]
                   [0.5 color Burnt_orange]
                   [0.55 color Sepia]
                   [0.6 color Burnt_orange]
                   [0.8 color Peach]
                            }
                turbulence .4  scale .2
                      }
    normal {
      granite 3.5
     scale .2
    }

             finish {phong 0.3 phong_size 20 ambient .4 diffuse .6 }
}



//--Knap------------------------------------------------------------------

#declare Knap =  texture {
   pigment {
     color red 0.556863 green 0.137255 blue 0.137255
   }
    normal {
      agate .5
    }
    finish {
      specular 0.5
      roughness 0.15
    }
  }

//--Kool--------------------------------------------------------------------

#declare Kool =
 texture {
   pigment { granite
     color_map {
       [0.000 color White ]
       [0.084 color Brown              ]
       [0.290 color Khaki          ]
       [0.590 color Coral              ]
       [0.830 color rgb <0.500, 0.000, 0.250 > ]
       [1.000 color Black ]
     }
     scale <0.1, 0.1, 0.1>
   }
    normal {
      granite 3.5
     scale <0.1, 0.1, 0.1>
    }
    finish {
      specular 0.5
      roughness 0.15
    }
}

//--PaarsRood------------------------------------------------------------------

#declare PaarsRood =
texture {
 pigment {
         granite
     color_map {
        [0.1 color Apricot ]
        [0.3 color Apricot]
        [0.45 color Midnight_blue]
        [0.5 color White]
        [0.55 color Midnight_blue]
        [0.6 color Apricot]
        [0.8 color Burnt_orange]
        }
    turbulence .4  scale 2
  }
finish {phong 0.4 phong_size 20 }
}

//--Pukkels---------------------------------------------------------------------

#declare Pukkels =
 texture {
   pigment {
     color red 0.556863 green 0.137255 blue 0.137255
   }
    normal {
      agate .5
    }
    finish {
      specular 0.3
      roughness 0.15
    } scale .007
}

//--WitGeel---------------------------------------------------------------------

 #declare WitGeel =
 texture {
  pigment {
        marble
     color_map {
        [0.1 color White ]
        [0.45 color White]
        [0.5 color Indian_red]
        [0.55 color Yellow]
        [0.8 color White]
        }
    turbulence .7  scale .3

  }
finish {phong .3}
}

//--WitBlauw----------------------------------------------------------------------

#declare WitBlauw =
texture {
pigment {
        marble
     color_map {
        [0.1 color White ]
        [0.45 color White]
        [0.5 color Indian_red]
        [0.55 color Blue]
        [0.8 color White]
        }
    turbulence .7  scale .3
  }
finish {phong .2 }
}

//--Octo----------------------------------------------------------------------------

#declare Octo =
texture {
 pigment {
        granite
     color_map {
        [0.1 color White filter.5]
        [0.3 color Salmon]
        [0.5 color Ochre_flesh]
        [0.7 color Olive_green]
        [0.8 color Pine_green]
        }
    turbulence .7  scale 0.3
  }
finish {phong .2}
}

//--Negativ1-------------------------------------------------------------------------

#declare Negativ1 =
   texture
   {
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.556863, 0.137255, 0.137255, 0.0, 0.0> ]
            [ 0.2     rgbft <0.556863, 0.137255, 0.137255, 0.0, 0.0> ]
            [ 1.0     rgbft <1.0, 0.5, 0.0, 0.0, 0.0> ]
         }
         turbulence -3.0
         octaves 2
         lambda 6.0
      }
      finish
      {
         ambient 0.0
         diffuse 1.0
      }
   }

//--EyeBall-----------------------------------------------------------------------------

#declare EyeBall =
  texture {
   pigment {
	image_map { gif "iris.gif"
//	map_type 1
	}
	scale <.9,.9,.9> translate <.5, .5, 0>
   }
  finish { phong 1 ambient 0.2}
 }

//--Spiderj-------------------------------------------------------------------------

#declare Spiderj =
  texture {
  pigment {
        gradient <1 0 0>
        color_map {
        [0  color Black ]
        [.2  color Violet ]
        [.6  color Dark_green ]
        }
        scale <5 1 1>}
 finish {
        ambient .2
        diffuse .3
        }
}
texture {
  pigment {
        color Gold filter .7 }
 normal {
        waves .5
        scale <.20 10 10>}
finish {
        phong 1
        phong_size 20 }

        }

//--Kwal---------------------------------------------------------

#declare Kwal =
texture {
pigment {
               granite
                 color_map {
                   [0.1 color rgbf <1, 1, 1, .9>]
                   [0.3 color rgbf <1, 1, 1, .9>]
                   [0.45 color rgbf <1, 1, 1, .4>]
                   [0.5 color rgbf <1, 1, 1, .6>]
                   [0.55 color rgbf <1, 1, 1, .4>]
                   [0.6 color rgbf <1, 1, 1, .6>]
                   [0.8 color rgbf <1, 1, 1, .7>]
                            }
                turbulence .4  scale .2
                      }
             finish {phong 0.3 phong_size 20 ambient .4 diffuse .6}
}

//--HullTex--------------------------------------------------------

#declare HullTex =
texture {
 pigment {
           bozo
            color_map {
             [0.25 color rgb <0.1812, 0.3262, 0.1631>]
             [0.50 color rgb <0.1380, 0.6086, 0.5019>]
             [0.85 color rgb <0.1380, 0.6400, 0.2698>]
             [1.00 color rgb <0.1129, 0.2572, 0.0000>]
             }
           }
 finish { ambient .25 specular .25 diffuse .8}
}

//--GridTex-------------------------------------------------------

#declare GridTex =
texture { pigment {
        marble
        color_map {
          [0,.10 color Green color Green]
          [.10,1 color rgb <1,1,1> filter 1 color rgb <1,1,1> filter 1]
          }
          rotate <90,0,0>
        }
       //finish {ambient 1 diffuse 0}
     }
texture { pigment {
        marble
        color_map {
         [0,.10 color Green color Green]
         [.10,1 color rgb <1,1,1> filter 1 color rgb <1,1,1> filter 1]
         }
         rotate <0,0,90>
        }
    // finish {ambient 1 diffuse 0}
     }


//--- Graniet --------------------------------------------------------

#declare Graniet =
texture {
pigment {color Eggshell  }
    normal {
      granite 3.5
     scale .2
    }
     finish {
    // phong 0.3 phong_size 20
    // ambient .2 diffuse .8
      crand 0.05 }
}

//-- Slime ------------------------------------------------------------

#declare Slime=
texture{
        pigment { Eggshell}

}
texture{
         pigment {
                 bozo
                 color_map{
                       [0.0   color rgbt<0  ,0  ,1 ,0.9>]
                       [0.35  color rgbt<1  ,1  ,1 ,1>]
                       [0.40  color rgb <0.1,0.2,0   >]
                       [0.5   color rgb <0.4,0.5,0   >]
                       [0.60  color rgb <0.1,0.2,0   >]
                       [0.65  color rgbt<1  ,1  ,1 ,1>]
                       [1     color rgbt<0  ,0  ,1 ,0.9>]
                 }
                 scale 0.3
         }
         normal{ bozo
                 slope_map{
                       [0.00  <1   , 0 >]
                       [0.49  <0   , 0 >]
                       [0.49  <0   , 3 >]
                       [0.50  <1   , 3 >]
                       [0.50  <1   ,-3 >]
                       [0.51  <0   ,-3>]
                       [0.51  <0   , 0>]
                       [1.00  <1   , 0>]
                 }
                 scale 0.3
         }
         finish{
                  phong 0.2
                  phong_size 20
                  // metallic
         }
         scale 0.7
          rotate <0,90,0>
}

//-----------------------------------------------------

#declare Zebra = 
texture {
    pigment {
        bozo
        turbulence 0.25
        octaves 2
        color_map {
            [0.0 0.3 color White color White ]
            [0.3 0.5 color Black color Black ]
            [0.5 1.0 color White color White ]
        }
        scale 0.5
    }
    normal {bozo scale 0.5}
}
