// I got this from the dkb-l list, but I forget exactly who did it
// (was it Jussi K.?).  At any rate, it's a very good use of the
// omega keyword in a texture.
//
// Be sure to save this as fire.tga before you raytrace world2.pov.

#include "colors.inc"
#include "textures.inc"

// parameters to change the 'look' of the fire:

#declare t = 0.275 //turbulence value
#declare o = 0.95 // omega value, higher means more detailed flames

#declare w = 4/3  // Width of the flame-wall (Height = 1)
#declare a = 0  // z-position where flame is rendered,
                // this allows animation of the flame by increasing
                // this value slightly, haven't tried it yet.

#declare Square_Z =  /* Scale-able plane in z */
  union
   {triangle {<-1, 1, 0>, <1, -1, 0>, <-1, -1, 0>}
    triangle {<-1, 1, 0>, <1, -1, 0>, < 1,  1, 0>}
   }

camera {
   location  <0, 0,-250>
   direction <0, 0,  15>
   up        <0, 1,  0>
   right   <4/3, 0,  0>
   look_at   <0, 0, 0>
}

object {Square_Z
        scale <w/5,1/5,1/5>
        translate <0,1/2+1/8,-a>
        pigment { gradient y
                  color_map {
                        [0 color Clear]
                        [0.2 color Yellow]
                        [0.3 color Yellow]
                        [0.55 color Red filter 0.3]
                        [0.65 color Red filter 1]
                        [0.75 color Clear]
                        [1 color Clear]
                            }
                  scale <1,5,5>
                  omega o
                  turbulence t
                  scale <1,1/5,1/5>
                  scale <0.3,1,1>
                }
        finish {Luminous}
        translate <0,-1/2-1/8,a>
        scale 40
        }
//=====================The=End=======================




