// RANDTEX.INC for the time shamelesly taken from TextureFarm  - 160598



#declare F1 = seed(400+TexSeed)  		// Not used
#declare N1 = seed(425+TexSeed*TexSeed)	// Decides which normal pattern is used also strength value for the normals
#declare P1 = seed(1005+TexSeed) 		// Decides which pigment pattern is used
#declare PG1 = seed(145+TexSeed)		// Decides which pigment is used single color or map
#declare Q1 = seed(1333+TexSeed)  		// Quilt pattern control number
#declare S1 = seed(52+TexSeed) 		// Number of arms in Spiral2 pattern
#declare S2 = seed(2+TexSeed)	 		// Not used
#declare PHNG1 = seed(593+TexSeed)  	// Phong strength
#declare PHNGS1 = seed(78940+TexSeed) 	// Phong size from 0 to 200
#declare RFLC1 = seed(940+TexSeed) 	// Reflection in finish statement
#declare SCL1 = seed(17+TexSeed) 		// Scale number 1 for pigment map
#declare SCL2 = seed(5741+TexSeed) 	// Scale number 2 for normal in Texture
#declare TRB1 = seed(2314+TexSeed*TexSeed)// Turbulence number 1 for pigment
#declare TRB2 = seed(1514+TexSeed) 	// Turbulence number 2 for normal
#declare TRB3 = seed(749+TexSeed) 		// Turbulence number 3 not used

#declare R1 = seed(90+TexSeed)			// Red 1
#declare R2 = seed(754+TexSeed*TexSeed)	// Red 2
#declare R3 = seed(234+TexSeed)		// Red 3
#declare R4 = seed(120+TexSeed) 		// Red 4

#declare G1 = seed(1544+TexSeed) 		// Green 1
#declare G2 = seed(2315+TexSeed*TexSeed)	// Green 2
#declare G3 = seed(8316+TexSeed) 		// Green 3
#declare G4 = seed(155+TexSeed) 		// Green 4

#declare B1 = seed(179+TexSeed) 		// Blue 1
#declare B2 = seed(12320+TexSeed) 		// Blue 2
#declare B3 = seed(321+TexSeed) 		// Blue 3
#declare B4 = seed(1224+TexSeed*TexSeed)	// Blue 4

#declare T1 = seed(2494+TexSeed) 		// Transmit 1
#declare T2 = seed(2555+TexSeed) 		// Transmit 2
#declare T3 = seed(5626+TexSeed) 		// Transmit 3
#declare T4 = seed(27+TexSeed) 		// Transmit 4



//---------------Normal --------------------
#declare NormalSeed =  int(rand(N1)*10)

#switch (NormalSeed)
 #case (0)
	#declare Norm = normal {bumps rand(N1)}
 #break
 #case(1)
	#declare Norm = normal {wrinkles rand(N1)}
 #break
 #case (2)
	#declare Norm = normal {spiral2 rand(N1)*10}
 #break
 #case (3)
	#declare Norm = normal {crackle rand(N1)}
 #break
 #case (4)
	#declare Norm = normal {ripples rand(N1)}
 #break
 #case (5)
	#declare Norm = normal {gradient x rand(N1)}
 #break
 #case (6)
	#declare Norm = normal {wood rand(N1)}
 #break
 #case (7)
	#declare Norm = normal {wrinkles rand(N1)}
 #break
 #case (8)
	#declare Norm = normal {quilted rand(N1) control0 -rand(Q1) control1 rand(Q1)}
 #break
 #range (9,10)
	#declare Norm = normal {granite}
#break
#end


//--------------Pigment --------------------

#declare PatternSeed =  rand(P1)
#declare TP = 13

#if (PatternSeed < 1/TP)
	#declare PatternType = pigment {bumps}
#else
#if (PatternSeed < 2/TP)
	#declare PatternType = pigment {wrinkles}
#else
#if (PatternSeed < 3/TP)
	#declare PatternType = pigment {spiral2 rand(S1)*10}
#else
#if (PatternSeed < 4/TP)
	#declare PatternType = pigment {crackle}
#else
#if (PatternSeed < 5/TP)
	#declare PatternType = pigment {ripples}
#else
#if (PatternSeed < 6/TP)
	#declare PatternType = pigment {gradient x}
#else
#if (PatternSeed < 7/TP)
	#declare PatternType = pigment {wood}
#else
#if (PatternSeed < 8/TP)
	#declare PatternType = pigment {wrinkles}
#else
#if (PatternSeed < 9/TP)
	#declare PatternType = pigment {quilted control0 -rand(Q1) control1 rand(Q1)}
#else
#if (PatternSeed < 10/TP)
	#declare PatternType = pigment {marble}
#else
#if (PatternSeed < 11/TP)
	#declare PatternType = pigment {agate}
#else
#if (PatternSeed < 12/TP)
	#declare PatternType = pigment {gradient y}
#else
	#declare PatternType = pigment {gradient z}
#end
#end
#end
#end
#end
#end
#end
#end
#end
#end
#end
#end
//--------------Pigment --------------------

#declare PigSeed =  rand(PG1)

#if (PigSeed < 0.5)
	#declare Pig = pigment {color rgb <rand(R1), rand(G2), rand(B3)>}
#else
	#declare Pig = pigment { PatternType
	color_map
		{
#if (rand(R1) < .5)
		[0.0 color rgbt <rand(R1), rand(G1), rand(B1)>]
#end
#if (rand(G1) < .5)
		[0.1 color rgbt <rand(R2), rand(G2), rand(B2)*rand(T3)>]
#end
#if (rand(B1) < .5)
		[0.2 color rgbt <rand(R3), rand(G3), rand(B3), rand(T3)*.5>]
#end
#if (rand(T1) < .5)
		[0.3 color rgbt <rand(R4), rand(G4), rand(B4)>]
#end
#if (rand(R2) < .5)
		[0.4 color rgbt <rand(R1), rand(G1), rand(B1), rand(T4)*.5>]
#end
#if (rand(G2) < .5)
		[0.5 color rgbt <rand(R2), rand(G3), rand(B4)>]
#end
#if (rand(B2) < .5)
		[0.6 color rgbt <rand(R3), rand(G4), rand(B1)*rand(T3)>]
#end
#if (rand(T2) < .5)
		[0.7 color rgbt <rand(R4), rand(G1), rand(B2), rand(T2)*.5>]
#end
#if (rand(R3) < .5)
		[0.8 color rgbt <rand(R2), rand(G1), rand(B2)>]
#end
#if (rand(G3) < .5)
		[0.9 color rgbt <rand(R3), rand(G2), rand(B3), rand(T3)*.5>]
#end
#if (rand(B3) < .5)
		[1.0 color rgbt <rand(R4), rand(G3), rand(B4)*rand(T3)>]
#end
		}
	}
#end

#declare TilePigment = pigment {Pig scale rand(SCL1) turbulence rand(TRB1)}
#declare TileNormal = normal { Norm scale rand(SCL2) turbulence rand(TRB2)}
#declare TileFinish = finish {reflection rand(RFLC1)*.2 phong rand(PHNG1) phong_size rand(PHNGS1)*200 }


#declare RandTex =
texture {
	pigment { TilePigment }
	normal  { TileNormal }
	finish  { TileFinish }
}
