// File: TRILO02.POV : Form of parms with bioform.include file  060598

/* The purpose of bioform.inc is to make bioforms, but also really bizarre
forms (scifi buildings, ...) are creatable ... depending on the segments, worms you use...
Like they say : Your imagination is the limit

Thanks to Matti Raitoharju for the basis of the Wave-routine
*/

#version 3
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "crayola.inc"
#declare Eggshell         = color red 0.99 green 0.90 blue 0.79 
#declare Graniet =
texture {
pigment {color Eggshell  }
    normal {
      granite 3.5
     scale .2
    }}
#include "biopred.inc"
#include "biotex.inc"

global_settings {assumed_gamma 2.2}


  #declare Kwal =
texture {
pigment {
               granite
                 color_map {
                   [0.1 color rgbf <1, 1, 1, .9>]
                   [0.3 color rgbf <1, 1, 1, .9>]
                   [0.45 color rgbf <1, 1, 1, .4>]
                   [0.5 color rgbf <1, 1, 1, .6>]
                   [0.55 color rgbf <1, 1, 1, .4>]
                   [0.6 color rgbf <1, 1, 1, .6>]
                   [0.8 color rgbf <1, 1, 1, .7>]
                            }
                turbulence .4  scale .2
                      }
             finish {phong 0.3 phong_size 20 ambient .4 diffuse .6}
}

//--HullTex--------------------------------------------------------

#declare HullTex =
texture {
 pigment {
           bozo
            color_map {
             [0.25 color rgb <0.1812, 0.3262, 0.1631>]
             [0.50 color rgb <0.1380, 0.6086, 0.5019>]
             [0.85 color rgb <0.1380, 0.6400, 0.2698>]
             [1.00 color rgb <0.1129, 0.2572, 0.0000>]
             }
           }
 finish { ambient .25 specular .25 diffuse .8}
}

//--GridTex-------------------------------------------------------


camera {
  location  <-1.0, 0.0, -40.0>
  direction 1.3*z
  right     1*x
  look_at   <-1.0, 0.0, 0.0>
}

// background { color red .8 green .8 blue 1 }

light_source {0*x color red 1.0  green 1.0  blue 1.0 translate <-10, 10, -30>}
light_source {0*x color red 0.60  green 0.60  blue 0.60 translate <40, 60, -60>}

#declare Reference = off  // reference-cross


/*** FORMSTART  *************************************************************************/

/* predef objects in biopred.inc : Bol, Doos, Spik, Torus, Thing2, Jan, Rib, Stulpsel,
            Stok (nog afmaken), Spik2, Spik3
*/

// USING PREDEF WORM      ---> if not ... goto Choose segments, ... ----------------------

  #declare PredefWorm = off
  #declare PredefWormName = object { Torus
                                 // pigment {color Eggshell}  finish {ambient .2 diffuse .7}
                                 //  texture {Tex scale 5}
                                    }

//  BUILDING WORM INTERACTIVELY  ------------------------------------------------------------

   #declare Segment = object {Bol
                              // pigment {color Eggshell} // if you want a texture over Worm, etc.
                              //  scale 2              // comment texture statement out
                               //  rotate <0,0,0>
                            }
#declare clock_type = "S-Curve"
#declare clock_start = 1
#declare clock_finish = 25
#declare clock_repeat = 2
#include "ClockMod.inc"


   #declare Number = 40+mclock        // Number of segments ...
   #declare Space = 25 - (mclock/4)        //  ... in the space taken by
   #declare OmwBasis = 0.1* (mclock/3)    // range -.6 (turning right) to .6 (turning left) ; 0 is straight up
   #declare LegTrig = 70 *(mclock/6)     // the segment where the routine should reverse, making a leg

   #declare AutoRot = off         // if off, you can define your own rotate
   #declare RotateFactorX = 0+((mclock/4))      // 360 = turning once across worm ; 360*# for more turns
   #declare RotateFactorY = 0-(mclock/3)
   #declare RotateFactorZ = 0+(mclock/6)



   #declare XMoveFactor = 1*(clock/5)/1.33   // you can limit in which plane the Worm will move (zero no move in that direction)
   #declare YMoveFactor = -.5*(clock/3.2)  // the Worm can also be placed in every quadrant you want (neg. vs pos.)
   #declare ZMoveFactor = -0.7*(clock/5)  // 0=no move, 1=ordinary move, -1=ordinary move in opposite direction

 #debug concat("  mclock = ",str(mclock,4,2),"\n")

   #declare ShrinkFactorX = -.1     // 0 is no shrink along the worm, pos is shrink - neg is grow
   #declare ShrinkFactorY = .5
   #declare ShrinkFactorZ = -.1

    #declare BranchOn = on         // on or off
      #declare WormAsBranch = off   // watch out, can become very hugh
         #declare PredBranch = Thing2
      #declare BranchNumber = 1       // number of branches
      #declare BranchScale = 1
      #declare BranchRot = 3    // rotate it around z-axis before fanning it
      #declare BranchTextureOn = on
      #declare BranchTexture = texture {EyeBall scale 6}
      #declare BranchTrigger = 15  // every n segment a branch


   #declare BaseOn = on        // on or off
      #declare WormAsBase = on   // if off, you can declare a predef Base
      #declare BranchedBase = off
         #declare PredBase = Torus
      #declare BaseNumber = 5
      #declare BaseScale = .4
      #declare BaseRot = 20    // rotate it around z-axis before fanning it
      #declare BaseTextureOn = off
      #declare BaseTexture = texture {Copper_Texture}


   #declare TopOn = off    // on en off
      #declare WormAsTop = off     // if off, you can declare a predef Top
      #declare BranchedTop = off
         #declare PredTop =   object {Stulpsel scale <1.5, 2, 1.5>}
      #declare TopNumber = 1
      #declare TopScale =  1
      #declare TopRot = 45    // rotate it around z-axis before fanning it
      #declare TopTextureOn = off
      #declare TopTexture = texture {pigment {color Green}}

                     // in case of WormAsTop is on, you can form a second Top
                #declare Top2On = off
                #declare Top2Number = 6
                #declare Top2Scale = .6
                #declare Top2Rot = 0
                #declare Top2TextureOn = on
                #declare Top2Texture = texture {Jade scale 4}


   #declare TopHartOn = off
      #declare TopHart = object {Bol
                               pigment {color Red} finish {phong .4}
                             scale 1 //  rotate <0, 0, 0>
                            }
      #declare TopHartUp = .5 // If you want your TopHart higher/lower than last segment



 // POSTSCALE, POSTROTATE, POSTTRANSLATE OF WORM ----------------------------

   #declare PostScaleX = 0.8   // absolute values (values as used in a scale statement)
   #declare PostScaleY = 0.8
   #declare PostScaleZ = 0.8

   #declare PostRotateX = 0   // rotates the Worm where you want it before fanning, wheeling, ...
   #declare PostRotateY = 90
   #declare PostRotateZ = 0

   #declare PostTranslateX = -1  // (with Torus for making a Shell -.3 is a good value with negative Tspread)
   #declare PostTranslateY = 0
   #declare PostTranslateZ = 0


// STATEMENTS FOR BUILDING THING (USING WORM) ------------------------------------------------


   #declare FAN = off          // Fan = rotate along y-axis
   #declare WHEEL = off          // Wheel/Shell = rotate along z-axis; for Shell posttranslate first
   #declare TRILOBYT = on       // Trilobyt = makes a rib, then copy it along x-axis
   #declare ANEMONE = off         // Anemone =


   // STATEMENTS FOR FAN, WHEEL/SHELL -------------------------------------

   #declare TNumber = 40      // Number of arms
   #declare TSpread = -360     // 360 degrees is one whole turn (also possible 360*#)
                              // neg. is clockwise, pos. is counterclockwise
                      // (Note : with Shell negative with a negative Posttranslate)

   #declare TScaleFactorX = 3   // 0 is no scale, pos is bigger - neg is smaller
   #declare TScaleFactorY = 1
   #declare TScaleFactorZ = 1

   #declare TOffsetTotaal = 0     // Fan (y-axis) : 0 is no offset, pos. is up - neg. is down
                                  // Wheel (z-axis) : 0 is no offset, pos. is away - neg. is towards

   #declare KropDegrees = 0      // Fan : 0 is no krop, pos. is down - neg. is up
                                 // Wheel : 0 is no krop, pos. is towards - neg. is away

   #declare Wave = off         // Up/down waving in Kropdegrees, divided in WaveNumber waves
     #declare WaveNumber = 3

   #declare TLinkOn = off     //
     #declare TLink = object { FanCyl  //WheelCyl
                                scale <1.5, 5, 1.5>
                               // rotate <0,0,0> translate <0,0,0>
                              }


   #declare Tentacle = off    // Isn't finished yet !!!!
     #declare TentName = object { Stulpsel texture {Pukkels scale 2.5} scale 6
                                  //  rotate <0, 0,0> translate <0, 0, 0>
                                    }
     #declare TentNumber = 1
     #declare TentSpread = 360


   // STATEMENTS FOR TRILOBYT ---------------------------------------------------------------

    #declare TrHeadOn = off  // you can define a head on top of your trilobyt
      #declare TrHead = object {Bol
                    // texture { EyeBall}
                    scale <2,4,2>
                    }

    #declare TrLinkOn = off
    #declare TrLink = cylinder { <0, 0, 0>, <2, 0, 0>, .5
                      pigment {Red}
                     // scale 2
                    }

    #declare Twisting = off
      #declare DistBase = 0.4
      #declare ARot = on        // Automates the UpFactor, RotZ ... Spindle stays manual

    #declare TrNumber = 12     // number of ribs
    #declare TrXStep = .5      // sidely step
    #declare TrYStep = 0   // up step
    #declare TrZStep = 0
    #declare TrScale = .5       // 0 is no scale, pos is smaller, neg bigger

    #declare UpFactor = 240    // y-rotate * degrees (also negative possible)
       #declare PowUp = on    // with PowUp NO neg. UpFactor - if off, linear UpFactor used

    #declare RotZAmount = 0    //  z-rotate * degrees (also negative)

    #declare SpindleAmount = 0    // x-rotate * degrees (also negative)
       #declare PowSpindle = off  // with PowSpindle NO neg. S.Amount - if off, linear S.Amount used



   // STATEMENTS FOR ANEMONE ------------------------------------------------------------------

    #declare ANumber = 60     // Number of worms to use for anemone
    #declare AScaleFactor = 0   // 0 no shrink, pos. is shrink, neg. is grow
    #declare MajorRad = 2    // Radius of the major turn
    #declare RadFactor = 0    // 0= circles even, pos smaller, neg. bigger
    #declare Turns = 360   // 360 is one major turn, can be less or more
    #declare XTrans = off  // offset along x-axis, how smaller factor the bigger the translate
      #declare XTransFactor = 2  // extra translate <LoopAmount/XTransFactor, 0, 0>
    #declare MinorRad = 3    // Radius of the minor revolutions
    #declare Revolutions = 2   // number of minor revolutions



// STATEMENTS FOR TEXTURES -----------------------------------------------------------------
    /* By using these textures take care there is no texture statement in segments
     Predef textures in biotex.inc : Tex, Texwith, Knap, Kool, PaarsRood, Pukkels,
                    WitGeel, WitBlauw, Octo, Negativ1, EyeBall, Spiderj, Kwal, HullTex(kleine scale)
                    GridTex (kleine scale), Nelson, Bg, Graniet, Slime (nog aan te passen)
    */

#declare TextureOverWorm = off
#declare TextureOverThing = on  // turn TextureOverWorm off, if you want a TextureOverThing

#declare ThingTexture = texture { Silver_Texture scale 2}

/******** DONT USE RANDOM FOR THE MOMENT, ALL ADDITIONS ARENT YET IMPLEMENTED YET *********/
// RANDOM MODE -----------------------------------------------------------------------------

/*  Computer defines Worm
       If you put "Debug_File=bioform.txt" in your povstart ini-file, you can redirect the debug-text in a textfile

*/

#declare RANDOMmode = off
   #declare MSeed = 5795                                                     #if (RANDOMmode = on)
   #declare ArmFactor = 2
             // ArmFactor : number of arms for fan/wheel/trilobyt (rand*10*ArmFactor)

     camera {            // camera statement repeated here for easy navigating
        location  <0.0, 0.0, -30.0>
        direction 1.8*z
        right     1*x
        look_at   <0.0, 0.0,  0.0>
      }

   // parameters we want to controll in randommode
   #declare BaseOn = on
     #declare WormAsBase = on
   #declare TopOn = off
     #declare WormAsTop = off
   #declare TopHartOn = off

   #declare FAN = on
   #declare WHEEL = off
   #declare SHELL = off
   #declare TRILOBYT = off
   #declare ANEMONE = off
        #declare XTrans = off
                                                                              #end


// SEE CREATED THING------------------------------------------------------------------------

/* Possibilities are : Worm, FanWorm, WheelWorm, TentWorm, LintWorm, AnemoneWorm ... (if on) , Thing
   Thing plus his mirror => Fan + scale <1,-1,1>, Wheel + scale <1,1,-1>.
      Doing this you can make a Hull of your Fan, Wheel, ...
   Here you can also postscale, postrotate or posttranslate your Thing
      and call the SAME Thing back again but slightly displaced.

*/

#include "bioform.inc"
object {Thing

translate <0,0,0>
rotate x*90
translate <0,0,0>
  rotate <0,-90,0>
  scale 0.8
  translate <-1,0,0>
      //    scale <1.3,1,1.3>
       }


/*  You can also change some parms and re-include bioform.inc to call
      back a DIFFERENT Thing.
    e.g.
    #declare BranchOn = on
    #include "bioform.inc"
   object {Thing rotate y*180}
*/


/***END FORM *******************************************************************************/

//declared box!!
#declare r1 = 12
#declare r2 = 16
#declare E = 0.1
#declare F = 0.25
#declare Count = ( clock/8) + 0.5

#declare r3 = ((r2-r1) * 8) / (2/Count)

#declare clock_type = "Oscillate"
#declare clock_start = 1
#declare clock_finish = 25
#declare clock_repeat = 3
#include "ClockMod.inc"

#declare r4 = (clock/100) * (mclock)

//#declare r5 = 0.75 * ((mclock * 1.115)/(clock/20)+0.1033)

#declare X=(r3*sin(E*Count)*cos(F*Count) * mclock)

#declare Y=(r3*sin(E*Count)*sin(F*Count) * mclock)

#declare Z= (r3*cos(F*Count) * mclock)

#declare block_color1 = <abs(X*1.35)/r1 ,0.5,0.5> + <0,0,1.35> * mclock

#declare block_color2 = <0.5,abs(Y)/r1,0.5>  - <1.35,0,0> * mclock

#declare block_color3 = <0.5,0.5,abs(Z*2)/r3> + <1.25,0,0.1045> * (mclock)

//for creeping 2
#declare block_color4 = <abs(Z*2)/r3,0.5,0.5> + <0,1.4,0> * mclock

#declare block_color5 = <0.5,abs(Y)/r1,0.5> + <0,0,1.4> * mclock

#declare block_color6 = <0.5,0.5,abs(X*1.35)/r1> + <0.1,1.2,0.05> * mclock

//for creeping 3
#declare block_color7 = <abs(X)/r1,0.5,0.5>

#declare block_color8 = <0.5,abs(Z*2)/r3,0.5>

#declare block_color9 = <0.5,abs(Y)/r1,0.5>

//for creeping 4 - a bit of average

#declare block1 = <abs(X*1.25)/r3,0.5,abs(Z*1.25)/r3>
#declare block2 = <0.5,abs(Y)/r3,abs(X)/r1>
#declare block3 = <abs(X*1.25)/r3,abs(Z*1.25)/r3,abs(Y*0.75)/r3>

// s-curve spots da are movin

#declare clock_type = "S-Curve"
#declare clock_start = 1
#declare clock_finish = 100
#include "ClockMod.inc"

// #declare clock_type = "S-Curve" #include "ClockMod.inc"
//   pigment {rgb <1, 0, 0> + <0, 1, 0> * mclock}

#declare block4 = <abs((X*1.25) * mclock)/r1,0.5,0.5*(mclock/r3)> + <0,0.01,0.2> * mclock
#declare block5 = <0.5,abs(Y*mclock)/(r3-r4),0.5>     - <0,1,0> * mclock
#declare block6 = <0.5,0.5,abs(Z*mclock)/r4> + <0.1025,0.102,0.102> * mclock

// for creep t

#declare clock_type = "Oscillate"
#declare clock_start = 1
#declare clock_finish = 100
#declare clock_repeat = 2
#include "ClockMod.inc"

#declare block7 = <0.75,0,0> + <0,abs(Y)/r3,0> * mclock

#declare block8 = <0.2,0.1175,0> + <0,0,abs(Z)/r3> * mclock

#declare block9 = <0,0,1> + <abs(X*1.33)/r1,abs(Y*1.33)/r3,abs(Z*1.33)/r3> * mclock



#declare clock_type = "S-Curve"
#declare clock_start = 1
#declare clock_finish = 10
#declare clock_repeat = 2
#include "ClockMod.inc"

// STARFIELD

   #declare star_count = 1200
   #declare star_scale = .5
   #declare debug_options = true
   #include "GALAXY.SF"

   #declare galaxy_seed = 112344
   #declare star_count = 120
   #declare star_type = 5
   #declare star_colour = 0.3 + <1, .9, .7>*.5 * mclock
   #declare star_scale = 1.5
   #declare debug_options = true
   #include "GALAXY.SF"

   #declare galaxy_colour1 = <2.2, 1, 1.1> + <0,0,1.2> * mclock
   #declare galaxy_colour2 = <2, .3, .6>   + <0,.25,.42> * mclock
   #declare galaxy_colour3 = <0.75,0.4,1.6> + <0.01,0.02,0.2> * mclock
   #declare galaxy_pattern_origin = (x*4*mclock) + (y*2.5*mclock) + (z*0.8*mclock) + <0.2,0.3,0.1> * mclock
   #declare galaxy_turb_origin = (x * -8) * mclock * y
   #declare galaxy_object_name = "Nebula3"
   #declare galaxy_object_scale = 2.22
   #declare galaxy_object_position = <0, 5, 0>
   #declare galaxy_cluster_name = ""
   #include "GALAXY.OBJ"

// BLUE NEBULA
   #declare galaxy_colour1 = <1.9, 0.1, 1.2> - <0.2,0,0> * mclock + <0,0,0.3> * mclock
   #declare galaxy_colour2 = <2, .3, .5>     + <0,0,0.2> * (mclock * 1.33)
   #declare galaxy_colour3 = <3,0.6,0.6>
   #declare galaxy_pattern_origin = (-x*0.4*mclock) + (-y*3.33*mclock) + (z*0.8*mclock) + <0.2,0.3,0.1> * mclock
   //#declare galaxy_pattern_origin = x * -20
   #declare galaxy_object_name = "Nebula2"
   #declare galaxy_object_scale = 2.1
   #declare galaxy_object_position = <10, -12, 0>
   #include "GALAXY.OBJ"


// PINK NEBULA

   #declare galaxy_star_colouration = 0.1 * mclock
   #declare galaxy_colour_turb = 0.6667
   #declare galaxy_colour1 = block_color1
   #declare galaxy_colour2 = block_color2
  #declare galaxy_colour3 = block_color3
   #declare galaxy_pattern_origin = x * ((0.668 * 4) * mclock)
   #declare galaxy_turb_origin = x * mclock * -8
   #declare galaxy_object_name = "Nebula3"
   #declare galaxy_object_scale = 2.1
   #declare galaxy_object_position = <0, 3, 0>
   #declare galaxy_cluster_name = ""
   #declare debug_options = true
//   #include "GALAXY.OBJ"

// BLUE NEBULA
   #declare galaxy_star_colouration = 0.1 * mclock
   #declare galaxy_colour1 = block_color2
   #declare galaxy_colour2 = <2, .01, .05> + <0.5,0.1,1.33> * mclock
   #declare galaxy_pattern_origin = x * -20 *(0.8*mclock)
   #declare galaxy_turb_origin = y * (mclock)
   #declare galaxy_object_name = "Nebula2"
   #declare galaxy_object_scale = 2.2


// PINK NEBULA
   #declare galaxy_colour1 = <1.2, 1, 1.1> * 0.8 * mclock
   #declare galaxy_colour2 = <1, .3, .6>   * 0.772 * (mclock/2.4)
   #declare galaxy_colour3 = block8
   #declare galaxy_pattern_origin = x * 1*mclock
   #declare galaxy_turb_origin = x * -4 * mclock
   #declare galaxy_object_name = "Nebula3"
   #declare galaxy_object_scale = 1.75
   #declare galaxy_object_position = <0, 3, 0>
   #declare galaxy_cluster_name = ""
//   #include "GALAXY.OBJ"


//   #declare galaxy_object_position = <0, 3, 0>
  //    #declare debug_options = true
 //  #include "GALAXY.OBJ"

// LARGE STAR
   #declare galaxy_object_name = "Star1"
   #declare galaxy_colour1 = <0.1, 1.5, 0.1>
   #declare galaxy_object_scale = 2
   #declare galaxy_object_position = <2, -10, 0>
   #declare debug_options = true
   #include "GALAXY.OBJ"

