// File: BIOFORM.INC : een Latham include file  160598

#debug "--------------------------------------------------\n"
#debug "BIOFORM (beta 0.96) by Jan Vanvoorden, Darren Fisher 16/05/98\n"

#if (Reference = on) union {
     box { <-3, -.05, -.05>, < 3,  .05,  .05>}
     box { <-.05, -3, -.05>, < .05,  3,  .05>}
     box { <-.05, -.05, -3>, < .05,  .05,  3>}
     pigment {color Blue}  no_shadow
     }
                 union {
     box {<-1.05, -1, - .05>,<-.95, 1, .05>}
     box {<-1, -1.05, - .05>,<1, -.95, .05>}
     box {<.95, -1, - .05>,<1.05, 1, .05>}
     box {<-1, .95, - .05>,<1, 1.05, .05>}
     pigment {color Red} no_shadow
     }
#end  // end if reference is on


// Voor oudere vbns waarin deze declares niet voorkomen
#ifndef (ShrinkTrig) #declare ShrinkTrig = Number + 1 #end
#ifndef (SeeSegment) #declare SeeSegment = off #end
#ifndef (RandTexOn) #declare RandTexOn = off #end
#ifndef (TexSeed) #declare TexSeed = 1 #end
#ifndef (TexScale) #declare TexScale = 1 #end


#if (SeeSegment = on) object {Segment} #else

#if (RANDOMmode = on)
#debug "RANDOM mode is on ... \n"
#debug concat(" Clock = ",str(clock,4,2)," - ")
#declare MSeed3 = seed (MSeed*3)
#declare MSeed4 = seed (MSeed+154)
#declare MSeed5 = seed (MSeed +298)
#declare MSeed6 = seed (MSeed*4)
#declare MSeed7 = seed (MSeed+840)
#declare MSeed8 = seed (MSeed+123)
#declare MSeed9 = seed (MSeed+628)
#declare MSeed10 = seed (MSeed*5)
#declare MSeed11 = seed (MSeed+365)
#declare MSeed12 = seed (MSeed+16)        //  tot en met MSeed22 gebruikt

#if (PredefWorm = off)
 #debug concat("MSeed = ",str(MSeed,1,0), " - ArmFactor = ", str(ArmFactor,1,0),"\n")
 #declare SeeSegment = off

#debug "SETTINGS IN RANDOM:\n"
#debug "WORM : \n"
#if (BranchOn = off) #debug " BranchOn = off\n" #else #debug " BranchOn = on\n" #end
#if (WormAsBranch = off) #debug "   WormAsBranch = off\n" #else #debug "   WormAsBranch = on\n" #end
#if (BaseOn = off) #debug " BaseOn = off\n" #else #debug " BaseOn = on\n" #end
#if (WormAsBase = off) #debug "   WormAsBase = off\n" #else #debug "   WormAsBase = on\n" #end
#if (BranchedBase = off) #debug "   BranchedBase = off\n" #else #debug "   BranchedBase = on\n" #end
#if (TopOn = off) #debug " TopOn = off\n" #else #debug " TopOn = on\n" #end
#if (WormAsTop = off) #debug "   WormAsTop = off\n" #else #debug "   WormAsTop = on\n" #end
#if (BranchedTop = off) #debug "   BranchedTop = off\n" #else #debug "   BranchedTop = on\n" #end
#if (TopHartOn = off) #debug " TopHartOn = off\n" #else #debug " TopHartOn = on\n" #end
#debug "THING : \n"
#if (FAN = off) #debug " Fan = off\n" #else #debug " FAN = on\n" #end
#if (WHEEL = off) #debug " Wheel = off\n" #else #debug " WHEEL = on\n" #end
#if (SHELL = off) #debug " Shell = off\n" #else #debug " SHELL = on\n" #end
#if (TRILOBYT = off) #debug " Trilobyt = off\n" #else #debug " TRILOBYT = on\n" #end
#if (Twisting = off) #debug "   Twisting = off\n" #else #debug "   Twisting = on\n" #end
#if (ANEMONE = off) #debug " Anemone = off\n" #else #debug " ANEMONE = on\n" #end
#if (XTrans = off) #debug "    XTrans = off\n" #else #debug "   XTrans = on\n" #end
#debug "RANDOM VALUES :\n"

#declare Number = int (rand(MSeed3)*80)
   #debug concat("  Number = ",str(Number,4,2),"\n")
#declare Space = int (rand(MSeed4)*40)
 #if (Space > Number) #declare Space = Number/2 #end
   #debug concat("  Space = ",str(Space,4,2),"\n")
#declare OmwBasis = rand(MSeed5)*.5
   #debug concat("  OmwBasis = ",str(OmwBasis,4,2),"\n")
#declare LegTrig = Number + 1
   #debug "  LegTrig disabled\n"
#declare AutoRot = on
   #debug "  AutoRot set to on \n"
#declare XMoveFactor = rand(MSeed8)
   #debug concat("  XMoveFactor = ",str(XMoveFactor,4,2),"\n")
#declare YMoveFactor = rand(MSeed6)
   #debug concat("  YMoveFactor = ",str(YMoveFactor,4,2),"\n")
#declare ZMoveFactor = rand(MSeed7)
   #debug concat("  ZMoveFactor = ",str(ZMoveFactor,4,2),"\n")
#declare ShrinkFactorX = rand (MSeed9)*2
   #debug concat("  ShrinkFactorX = ",str(ShrinkFactorX,4,2),"\n")
#declare ShrinkFactorY = rand(MSeed9)*2
   #debug concat("  ShrinkFactorY = ",str(ShrinkFactorY,4,2),"\n")
#declare ShrinkFactorZ = rand(MSeed9)*2
   #debug concat("  ShrinkFactorZ = ",str(ShrinkFactorZ,4,2),"\n")
#declare ShrinkTrig = Number + 1
    #debug "  ShrinkTrig disabled\n"

 #else #declare Worm = PredefWormName
 #debug concat("MSeed = ",str(MSeed,1,0), " - ArmFactor = ", str(ArmFactor,1,0),"\n")
  #debug "PredefWorm used ...\n"
#debug "THING : \n"
#if (FAN = off) #debug " FAN = off\n" #else #debug " FAN = on\n" #end
#if (WHEEL = off) #debug " WHEEL = off\n" #else #debug " WHEEL = on\n" #end
#if (SHELL = off) #debug " SHELL = off\n" #else #debug " SHELL = on\n" #end
#if (TRILOBYT = off) #debug " TRILOBYT = off\n" #else #debug " TRILOBYT = on\n" #end
#if (Twisting = off) #debug "   Twisting = off\n" #else #debug "   Twisting = on\n" #end
#if (ANEMONE = off) #debug " ANEMONE = off\n" #else #debug " ANEMONE = on\n" #end
#if (XTrans = off) #debug "    XTrans = off\n" #else #debug "   XTrans = on\n" #end
#end                 // end if PredefWorm is off

#end   // end if RANDOMmode on

// Start van Thing ------------------------------------------------

#declare Thing = union {

#if (PredefWorm = off)

 #declare Tx = 0
 #declare Ty = 0
 #declare Tz = 0
 #declare Sx = 1
 #declare Sy = 1
 #declare Sz = 1
 #declare Rx = 0
 #declare Ry = 0
 #declare Rz = 0
 #declare Omw = OmwBasis
 #declare Count = 1

 #if (RANDOMmode = off)
#debug "Worm()MoveFactors different from 1 : \n"
#if (XMoveFactor < 1) #debug concat ("  XMoveFactor = ", str(XMoveFactor,4,2), "\n") #end
#if (XMoveFactor > 1) #debug concat ("  XMoveFactor = ", str(XMoveFactor,4,2), "\n") #end
#if (YMoveFactor < 1) #debug concat ("  YMoveFactor = ", str(YMoveFactor,4,2), "\n") #end
#if (YMoveFactor > 1) #debug concat ("  YMoveFactor = ", str(YMoveFactor,4,2), "\n") #end
#if (ZMoveFactor < 1) #debug concat ("  ZMoveFactor = ", str(ZMoveFactor,4,2), "\n") #end
#if (ZMoveFactor > 1) #debug concat ("  ZMoveFactor = ", str(ZMoveFactor,4,2), "\n") #end
#end

#declare W0 =                    // Worm zonder Branch (thevens basis voor Branch)
union {
 #while (Count <= Number)
       object {Segment scale <Sx, Sy, Sz> rotate <Rx, Ry, Rz> translate <Tx, Ty, Tz>}

       #if (Count < ShrinkTrig)
         #declare Sx = Sx - (ShrinkFactorX/Number)
         #declare Sy = Sy - (ShrinkFactorY/Number)
         #declare Sz = Sz - (ShrinkFactorZ/Number)
         #else
         #declare Sx = Sx + (ShrinkFactorX/Number)
         #declare Sy = Sy + (ShrinkFactorY/Number)
         #declare Sz = Sz + (ShrinkFactorZ/Number)
       #end

         #if (AutoRot = off)
          #declare Rx = Rx + (RotateFactorX/Number)
          #declare Ry = Ry + (RotateFactorY/Number)
          #declare Rz = Rz + (RotateFactorZ/Number)
         #end // end if AutoRot is off

         #declare Straal = ((Space / Number)*(Sx+Sz/2)) /2

       #declare VerschilZ = Tz
       #declare VerschilX = Tx
       #declare A = 90*pi/180 + Omw
       #declare Tx = Tx + ((Straal * cos (A)) * XMoveFactor)
       #declare Tz = Tz + ((Straal * sin (A)) * ZMoveFactor)
         #if (Count < LegTrig)
         #declare Ty = Ty + ((Space/Number) * Sy * YMoveFactor)
         #else
         #declare Ty = Ty - ((Space/Number) * Sy * YMoveFactor)
         #end

       #if (AutoRot = on)
       #declare Rx = (Tz - VerschilZ) * (-90)
       #declare Rz = (Tx - VerschilX) * (-90)
       #end // end if AutoRot is on

       #declare Omw = Omw + OmwBasis
       #declare Count = Count + 1

 #end  // end while loop
  }  // afsluiten W0 union


// naar de Branch zelf nu ---------------------

#if (RANDOMmode = on)
   #if (BranchOn = on)
                   #declare BranchNumber = int(rand(MSeed3)*6)
                    #if (BranchNumber < 1) #declare BranchNumber = 1 #end
                        #debug concat ("   BranchNumber = ", str(BranchNumber,4,2), "\n")
                   #declare BranchScale = rand(MSeed4)*1.5
                        #debug concat ("   BranchScale = ", str(BranchScale,4,2), "\n")
                   #declare BranchRot = int(rand(MSeed5)*60)
                        #debug concat ("   BranchRot = ", str(BranchRot,4,2), "\n")
                   #declare BranchTextureOn = off
                        #debug "   BranchTextureOn set to off \n"
                   #declare BranchTrigger = int(rand(MSeed6)*10)
                        #debug concat ("   BranchTrigger = ", str(BranchTrigger,4,2), "\n")
            #end  // end if Branchon is on
#end  // if RandomMode is on

          #declare BranchTeller = 0
          #declare BranchRTotaal = 0
        #declare Branch = union {
            #while  (BranchTeller < BranchNumber)
           object {
           #if (WormAsBranch = off) PredBranch #else W0 #end

                scale BranchScale  rotate <0, 0, BranchRot>
                rotate <0, BranchRTotaal, 0>

           }
           #declare BranchRTotaal = BranchRTotaal + (360/BranchNumber)
           #declare BranchTeller = BranchTeller + 1
            #end  // end while BranchTeller ...
      object { Bol scale .001 pigment {color red 1 green 1 blue 1}}
      }  // end union Branch


// Naar de Worm met Branch------------------------------
#if (BranchOn = on)
 #declare Tx = 0
 #declare Ty = 0
 #declare Tz = 0
 #declare Sx = 1
 #declare Sy = 1
 #declare Sz = 1
 #declare Rx = 0
 #declare Ry = 0
 #declare Rz = 0
 #declare BranchDet = BranchTrigger
 #declare Omw = OmwBasis
 #declare Count = 1


// ---------- Start Loop voor Worm --------------------------------------------

#declare W1 =
union {
 #while (Count <= Number)
       object {Segment scale <Sx, Sy, Sz> rotate <Rx, Ry, Rz> translate <Tx, Ty, Tz>}

       #if (Count = BranchDet)
          object {Branch #if (BranchTextureOn = on) texture {BranchTexture} #end
          scale <Sx, Sy, Sz> rotate <Rx, Ry, Rz> translate <Tx, Ty, Tz>}
          #declare BranchDet = Count + BranchTrigger
       #end

         #if (Count < ShrinkTrig)
         #declare Sx = Sx - (ShrinkFactorX/Number)
         #declare Sy = Sy - (ShrinkFactorY/Number)
         #declare Sz = Sz - (ShrinkFactorZ/Number)
         #else
         #declare Sx = Sx + (ShrinkFactorX/Number)
         #declare Sy = Sy + (ShrinkFactorY/Number)
         #declare Sz = Sz + (ShrinkFactorZ/Number)
       #end

         #if (AutoRot = off)
          #declare Rx = Rx + (RotateFactorX/Number)
          #declare Ry = Ry + (RotateFactorY/Number)
          #declare Rz = Rz + (RotateFactorZ/Number)
         #end // end if AutoRot is off

         #declare Straal = ((Space / Number)*(Sx+Sz/2)) /2

       #declare VerschilZ = Tz
       #declare VerschilX = Tx
       #declare A = 90*pi/180 + Omw
       #declare Tx = Tx + ((Straal * cos (A)) * XMoveFactor)
       #declare Tz = Tz + ((Straal * sin (A)) * ZMoveFactor)
         #if (Count < LegTrig)
         #declare Ty = Ty + ((Space/Number) * Sy * YMoveFactor)
         #else
         #declare Ty = Ty - ((Space/Number) * Sy * YMoveFactor)
         #end

       #if (AutoRot = on)
       #declare Rx = (Tz - VerschilZ) * (-90)
       #declare Rz = (Tx - VerschilX) * (-90)
      //  #debug concat("  Rz = ",str(Rz,4,2),"\n")
       #end // end if AutoRot is on

       #declare Omw = Omw + OmwBasis
       #declare Count = Count + 1

 #end
  }  // afsluiten W1 union
#end // end if BranchOn is on
// ----------------------------------------------

 #if (RANDOMmode = on)
       #declare MSeed15 = seed (MSeed +2698)
       #declare MSeed16 = seed (MSeed*9)
       #declare MSeed17 = seed (MSeed+3640)
       #declare MSeed19 = seed (MSeed+1328)
       #declare MSeed20 = seed (MSeed*12)
       #declare MSeed21 = seed (MSeed+365)

            #if (BaseOn = on)
                   #declare BaseNumber = int(rand(MSeed15)*10)
                    #if (BaseNumber < 1) #declare BaseNumber = 1 #end
                        #debug concat ("   BaseNumber = ", str(BaseNumber,4,2), "\n")
                   #declare BaseScale = rand(MSeed16)*1.5
                        #debug concat ("   BaseScale = ", str(BaseScale,4,2), "\n")
                   #declare BaseRot = int(rand(MSeed17)*45)
                        #debug concat ("   BaseRot = ", str(BaseRot,4,2), "\n")
                   #declare BaseTextureOn = off
                        #debug "   BaseTextureOn set to off \n"
            #end

            #if (TopOn = on)
                   #declare TopNumber = int(rand(MSeed19)*10)
                    #if (TopNumber < 1) #declare TopNumber = 1 #end
                        #debug concat ("   TopNumber = ", str(TopNumber,4,2), "\n")
                   #declare TopScale = rand(MSeed20)*1.5
                        #debug concat ("   TopScale = ", str(TopScale,4,2), "\n")
                   #declare TopRot = int(rand(MSeed21)*45)
                        #debug concat ("   TopRot = ", str(TopRot,4,2), "\n")
                   #declare TopTextureOn = off
                        #debug "   TopTextureOn set to off \n"
            #end

         #declare Top2On = off

   #end // end if random on
 //---------------- Voor als Branched wordt gekozen en ...
#if (BranchOn = off)
  #if (BranchedBase = on & BranchOn = on)
  #declare BranchedBase = off #debug "... no BranchedBase since BranchOn is off ...\n"
  #end
  #if (BranchedTop = on & TopOn = on)
  #declare BranchedTop = off #debug "... no BranchedTop since BranchOn is off ...\n"
  #end
#end

//-----------------------------------------------
#declare Worm = union {
      object {#if (BranchOn = on) W1 #else W0 #end}
      object {Bol pigment {color red 1 green 1 blue 1} scale .001}  // om foutmelding
      //------------
     #if (BaseOn = on)
             #declare BaseTeller = 0
             #declare BaseRTotaal = 0
            #while  (BaseTeller < BaseNumber)
           object {
           #if (WormAsBase = off) PredBase #else
                                              #if (BranchedBase = off) W0
                                              #else W1
                                              #end
              #end
           #if (BaseTextureOn = on) texture {BaseTexture} #end
                scale BaseScale  rotate <0, 0, BaseRot>
                rotate <0, BaseRTotaal, 0>

           }
           #declare BaseRTotaal = BaseRTotaal + (360/BaseNumber)
           #declare BaseTeller = BaseTeller + 1
            #end  // end while BaseTeller ...

    #end // end if BaseOn is on
    //------------- (voorbereidng voor Top en Top2
                  #if (Top2On = on)
                    #declare Top2Teller = 0
                    #declare Top2RTotaal = 0
                 #declare W2 = union {
                   #while  (Top2Teller < Top2Number)
                  object { W0
                  #if (Top2TextureOn = on) texture {Top2Texture} #end
                       scale Top2Scale  rotate <0, 0, Top2Rot>
                       rotate <0, Top2RTotaal, 0>
                       translate <Tx*TopScale, Ty*TopScale, Tz*TopScale>
                   }
                  #declare Top2RTotaal = Top2RTotaal + (360/Top2Number)
                  #declare Top2Teller = Top2Teller + 1
                   #end  // end while TopTeller ...
               }  // afsluiten union W2
    #end // end if Top2On is on

    //-----------------
    #if (TopOn = on)
             #declare TopTeller = 0
             #declare TopRTotaal = 0
          #while  (TopTeller < TopNumber)
          object { Bol scale .001 pigment {color red 1 green 1 blue 1}}
           #if (WormAsTop = off) object {PredTop  #if (TopTextureOn = on) texture {TopTexture} #end
                                                        scale TopScale
                                                     rotate <0, TopRTotaal, 0>
                                                    translate <Tx, Ty, Tz>
                                                     }
             #else union { object {
                               #if (BranchedTop = off) W0 #else W1 #end
                       #if (TopTextureOn = on) texture {TopTexture} #end
                                             scale TopScale}
                               object { Bol scale .001 pigment {color red 1 green 1 blue 1}}  // foutmelding
                        #if (Top2On = on) object {W2} #end

                                                        rotate <0, 0, TopRot>
                                                        rotate <0, TopRTotaal, 0>
                                                         translate <Tx, Ty, Tz>
                        }
           #end // end is WormAsTop is off


           #declare TopRTotaal = TopRTotaal + (360/TopNumber)
           #declare TopTeller = TopTeller + 1
            #end  // end while TopTeller ...

    #end // end if Topon is on
    //--------------
    #if (TopHartOn = on) object { TopHart translate <Tx, Ty+TopHartUp, Tz>} #end
    #if (TextureOverWorm = on)
          #if (RandTexOn = off) texture {ThingTexture}
          #else texture {RandTex scale TexScale}
          #end
    #end  // als Texture over de ganse worm moet tellen

               #if (RANDOMmode = on)
                 #declare PostScaleX = 1
                 #declare PostScaleY = 1
                 #declare PostScaleZ = 1
                        #debug "  PostScale set to 1 \n"
                 #declare PostRotateX = 0
                        #debug "  PostRotateX set to 0 \n"
                 #declare PostRotateY = 0
                        #debug "  PostRotateY set to 0 \n"
                 #declare PostRotateZ = int(rand(MSeed12)*90)
                        #debug concat("  PostRotateZ = ",str(PostRotateZ,4,2), "\n")
                 #declare PostTranslateX = 0
                 #declare PostTranslateY = 0
                 #declare PostTranslateZ = 0
                 #debug "  PostTranslate set to 0 \n"
               #end   // end if randommode on
 scale <PostScaleX, PostScaleY, PostScaleZ>
 rotate <PostRotateX, PostRotateY, PostRotateZ>                   // zie opmerking postrotate
 translate <PostTranslateX, PostTranslateY, PostTranslateZ>
}

#end // end van if PredefWorm is off


#if (PredefWorm = on)
 #if (RANDOMmode = off) #debug "PredefWorm used ...\n" #end
 #declare Worm = object {PredefWormName
 scale <PostScaleX, PostScaleY, PostScaleZ>
 rotate <PostRotateX, PostRotateY, PostRotateZ>
 translate <PostTranslateX, PostTranslateY, PostTranslateZ>
 }
#end


/***************** FAN ***********************************************/
#if (FAN = on)
   #debug "FAN is on ... \n"
      #if (RANDOMmode = on)
      #declare MSeed1 = seed(MSeed*2)
  #declare MSeed2 = seed(MSeed*3)
  #declare TNumber = int(rand (MSeed1) *10 *ArmFactor)
   #debug concat("  Number of Arms = ",str(TNumber,4,2),"\n")
  #declare MSeed13 = seed(MSeed + 932)
  #declare TSpread = int(rand(MSeed13)*720)
  #if (TSpread < 360) #declare TSpread = 360 #end
   #debug concat("  TSpread = ",str(TSpread,4,2),"\n")
  #declare TScaleFactorX = 0
  #declare TScaleFactorY = 0
  #declare TScaleFactorZ = 0
   #debug "  TScaleFactor set to 0 \n"
  #declare TOffsetTotaal = 0
   #debug "  TOffsetTotaal set to 0 \n"
  #declare KropDegrees = int(rand(MSeed2)*90)
   #debug concat("  KropDegrees = ",str(KropDegrees,4,2),"\n")
  #declare TLinkOn = off
   #debug "  TLinkOn set to off \n"
  #declare Wave = off
   #debug "  Wave set to off \n"
 #end // end if randommode is on

 #declare FanTotaal = 0
 #declare KropTotaal = 0
 #declare FScaleTotaalX = 1
 #declare FScaleTotaalY = 1
 #declare FScaleTotaalZ = 1
 #declare FanOffset= 0
 #declare Teller = 0

 #declare FanWorm = union {
 #while (Teller < TNumber)
    #if (TLinkOn = on)
     object {TLink scale <FScaleTotaalX, FScaleTotaalY, FScaleTotaalZ>
                   translate <0,FanOffset, 0>}
    #end
#if (Wave = on)
    object {Worm scale <FScaleTotaalX, FScaleTotaalY, FScaleTotaalZ>  rotate <0, 0, sin(KropTotaal*pi/180*WaveNumber)*KropDegrees>
                       rotate <0, FanTotaal,0>  translate <0, FanOffset, 0>}
     #declare KropTotaal = KropTotaal + (360/TNumber)     // valt met die 360 te spelen ????
#end   // end if wave is on
#if (Wave = off)
    object {Worm scale <FScaleTotaalX, FScaleTotaalY, FScaleTotaalZ> rotate <0, 0, KropTotaal> rotate <0, FanTotaal,0>  translate <0, FanOffset, 0>}
         #declare KropTotaal = KropTotaal + (KropDegrees/TNumber)
#end // end if Wave is off)

     #declare FanTotaal = FanTotaal + (TSpread/TNumber)
     #declare FScaleTotaalX = FScaleTotaalX + (TScaleFactorX/TNumber)
     #declare FScaleTotaalY = FScaleTotaalY + (TScaleFactorY/TNumber)
     #declare FScaleTotaalZ = FScaleTotaalZ + (TScaleFactorZ/TNumber)

     #declare FanOffset = FanOffset + (TOffsetTotaal/TNumber)
     #declare Teller = Teller + 1
 #end // end while loop

 #if (TextureOverThing = on)
     #if (RandTexOn = off) texture {ThingTexture}
     #else texture { RandTex scale TexScale}
     #end
 #end
#if (RANDOMmode = on)
   #declare TPostRotateX = int(rand(MSeed10)*90)
     #debug concat("  TPostRotateX = ",str(TPostRotateX,4,2), "\n")
   #declare TPostRotateY = int(rand(MSeed11)*90)
     #debug concat("  TPostRotateY = ",str(TPostRotateY,4,2), "\n")
   #declare TPostRotateZ = int(rand(MSeed12)*90)
    #debug concat("  TPostRotateZ = ",str(TPostRotateZ,4,2), "\n")
   rotate <TPostRotateX, TPostRotateY, TPostRotateZ> #end
 } // afsluiten union FanWorm

object {FanWorm}

#end  // end if FAN on


#if (RANDOMmode = on)
     #if (SHELL = on)
     #declare PostTranslateX = -.5  #debug "PostTranslateX set to -.5 \n"
     #declare WHEEL = on
     #end  //end if shell is on
     #end  // end if randommode is on
/**********************WHEEL*********************************************/
#if (WHEEL = on)
#if (PostTranslateX = 0) #debug "WHEEL is on ... \n" #else
          #debug "SHELL is on ... \n"  #end

#if (RANDOMmode = on)
     #declare MSeed1 = seed(MSeed*2)
     #declare MSeed2 = seed(MSeed*3)
     #declare TNumber = int(rand (MSeed1) *10 *ArmFactor)
       #debug concat("  Number of Arms = ",str(TNumber,4,2),"\n")
      #declare MSeed13 = seed(MSeed + 932)
     #if (SHELL = off)
      #declare TSpread = int(rand(MSeed13)*720)
       #if (TSpread < 360) #declare TSpread = 360 #end
       #else #declare TSpread = -380
     #end
    #debug concat("  TSpread = ",str(TSpread,4,2),"\n")
     #if (SHELL = off)
      #declare TScaleFactorX = 0
      #declare TScaleFactorY = 0
      #declare TScaleFactorZ = 0
      #debug "  TScaleFactor set to 0 \n"
     #else
      #declare TScaleFactorX = 2
      #declare TScaleFactorY = 0
      #declare TScaleFactorZ = 0
      #debug "  TScaleFactorX set to 2 \n"
     #end
    #declare KropDegrees = int(rand(MSeed2)*90)
      #debug concat("  KropDegrees = ",str(KropDegrees,4,2),"\n")
  #declare TOffsetTotaal = 0
   #debug "  TOffsetTotaal set to 0 \n"
  #declare TLinkOn = off
   #debug "  TLinkOn set to off \n"
  #declare Wave = off
   #debug "  Wave set to off \n"
 #end // end if randommode is on

 #declare FanTotaal = 0
 #declare KropTotaal = 0
 #declare FScaleTotaalX = 1
 #declare FScaleTotaalY = 1
 #declare FScaleTotaalZ = 1

 #declare FanOffset= 0
 #declare SymScaleTotaal = 0
 #declare Teller = 0

 #declare WheelWorm = union {
 #while (Teller < TNumber)
    #if (TLinkOn = on)
     object {TLink scale <FScaleTotaalX, FScaleTotaalY, FScaleTotaalZ>
                    translate <0,0, FanOffset>}
    #end
#if (Wave = on)
  object {Worm scale <FScaleTotaalX, FScaleTotaalY, FScaleTotaalZ> rotate <0,0, FanTotaal>  rotate <0, sin(KropTotaal*pi/180*WaveNumber)*KropDegrees,0>
                         translate <0,0, FanOffset>}
     #declare KropTotaal = KropTotaal + (360/TNumber)     // valt met die 360 te spelen ????
#end  // en if Wave is on

#if (Wave = off)
    object {Worm scale <FScaleTotaalX, FScaleTotaalY, FScaleTotaalZ> rotate <0,0, FanTotaal> rotate <0, KropTotaal, 0>  translate <0,0, FanOffset>}
         #declare KropTotaal = KropTotaal + (KropDegrees/TNumber)
#end  // end if Wave is off
     #declare FanTotaal = FanTotaal + (TSpread/TNumber)
     #declare FScaleTotaalX = FScaleTotaalX + (TScaleFactorX/TNumber)
     #declare FScaleTotaalY = FScaleTotaalY + (TScaleFactorY/TNumber)
     #declare FScaleTotaalZ = FScaleTotaalZ + (TScaleFactorZ/TNumber)

     #declare FanOffset = FanOffset + (TOffsetTotaal/TNumber)
     #declare Teller = Teller + 1
 #end // end while loop

   #if (TextureOverThing = on)
     #if (RandTexOn = off) texture {ThingTexture}
     #else texture { RandTex scale TexScale}
     #end
 #end

   #if (RANDOMmode = on)
     #declare TPostRotateX = int(rand(MSeed10)*90)
        #debug concat("  TPostRotateX = ",str(TPostRotateX,4,2), "\n")
     #declare TPostRotateY = int(rand(MSeed11)*90)
        #debug concat("  TPostRotateY = ",str(TPostRotateY,4,2), "\n")
     #declare TPostRotateZ = int(rand(MSeed12)*90)
        #debug concat("  TPostRotateZ = ",str(TPostRotateZ,4,2), "\n")
     rotate <TPostRotateX, TPostRotateY, TPostRotateZ>
     #end // end if randommode = on
   } // afsluiten union FanWorm

object {WheelWorm}


#end  // end if WHEEL on


//-------------------- TENTACLE ------------------------------------------
       #if (Tentacle = on)
        #declare TentTotaal = TentSpread/TentNumber
        #declare Teller = 0
        #declare TentWorm = union {
        #while (Teller < TentNumber)

  #if (FAN = on)   object {TentName  rotate <0, TentTotaal,0> translate <0,FanOffset, 0>} #end
  #if (WHEEL = on) object {TentName rotate <TentTotaal, 0, 0> translate <0,0, FanOffset>} #end
           object { Bol scale .001 pigment {color red 1 green 1 blue 1}}  // foutmelding
       #declare TentTotaal = TentTotaal + (TentSpread/TentNumber)
       #declare Teller = Teller + 1
     #end // end while loop
      #if (RANDOMmode = on) rotate <TPostRotateX, TPostRotateY, TPostRotateZ> #end
     } // afsluiten union TWorm
     //-----------------------------
     object {TentWorm}
    #end  // end if Tentacle is on



/************* TRILOBYT ***********************************************************/
#if (TRILOBYT = on)
 #debug "TRILOBYT is on ... \n"
                    #if (RANDOMmode = on)
                       #declare MSeed23 = seed (MSeed+103)
                       #declare MSeed24 = seed (MSeed+56)
                       #declare MSeed25 = seed (MSeed+36)
                       #declare MSeed26 = seed (MSeed+16)
                       #declare MSeed27 = seed (MSeed+88)

                       #declare TrHeadOn = off
                       #declare TrNumber = int(rand (MSeed23)*10*ArmFactor)
                        #debug concat("  TrNumber = ",str(TrNumber,4,2),"\n")
                       #declare TrLinkOn = off
                       #declare TrScale = rand (MSeed24)*2
                        #debug concat("  TrScale = ",str(TrScale,4,2),"\n")

                       #if (Twisting = off)
                        #debug "  Twisting set to off\n"
                       #declare TrXStep = 1
                       #declare TrYStep = 0
                       #declare TrZStep = 0
                       #declare UpFactor = int(rand(MSeed25)*360)
                        #debug concat("  UpFactor = ",str(UpFactor,4,2),"\n")
                       #declare PowUp = off
                       #declare RotZAmount = int(rand(MSeed26)*360)
                        #debug concat("  RotZAmount = ",str(RotZAmount,4,2),"\n")
                       #declare SpindleAmount = int(rand(MSeed27)*360)
                        #debug concat("  SpindleAmount = ",str(SpindleAmount,4,2),"\n")
                       #declare PowSpindle = off

                       #end  // end if twisting is off

                       #if (Twisting = on)
                        #debug "  Twisting set to on\n"
                       #declare DistBase = rand(MSeed25)*.5
                        #debug concat("  DistBase = ",str(DistBase,4,2),"\n")
                       #declare ARot = on
                        #debug "  Arot set to on\n"
                       #declare TrXStep = rand(MSeed25)*2
                         #debug concat("  TrXStep = ",str(TrXStep,4,2),"\n")
                       #declare TrYStep = rand(MSeed25)*4
                         #debug concat("  TrYStep = ",str(TrYStep,4,2),"\n")
                       #declare TrZStep = rand(MSeed26)*(-3)
                        #debug concat("  TrZStep = ",str(TrZStep,4,2),"\n")
                       #declare UpFactor = 0
                       #declare RotZAmount = 0
                       #declare SpindleAmount = 0
                       #end  // end if twisting is on

                      #declare TPostRotateX = int(rand(MSeed10)*90)
                        #debug concat("  TPostRotateX = ",str(TPostRotateX,4,2), "\n")
                       #declare TPostRotateY = int(rand(MSeed11)*90)
                        #debug concat("  TPostRotateY = ",str(TPostRotateY,4,2), "\n")
                       #declare TPostRotateZ = int(rand(MSeed12)*90)
                        #debug concat("  TPostRotateZ = ",str(TPostRotateZ,4,2), "\n")

                    #end  // end if randommode is on
       #declare Worm2 = union {object {Worm} object {Worm scale <1,-1,1>}}
           #declare Omw = OmwBasis
           #declare LintXInc = 0
           #declare LintYInc = 0
           #declare LintZInc = 0
           #declare RotZTotaal = 0
           #declare Space = TrNumber
           #declare Dist = DistBase
           #declare UpTotaal = 0
           #declare SpindTotaal = 0
           #declare TrScaleTotaal = 1
           #declare LintTeller = 0

           #declare LWorm = union {
           #while (LintTeller < TrNumber)
             object {Worm2 scale TrScaleTotaal rotate <0, UpTotaal, RotZTotaal> rotate <SpindTotaal, 0, 0>
                               translate <LintXInc, LintYInc, LintZInc>}
             #if (TrLinkOn = on)
             object { TrLink scale TrScaleTotaal rotate <0, UpTotaal, RotZTotaal> rotate <SpindTotaal, 0, 0>
                               translate <LintXInc, LintYInc, LintZInc>
                 }
             #end   // end if TrLinkon is on

         #declare TrScaleTotaal = TrScaleTotaal - (TrScale/TrNumber)

         #declare TVersX = LintXInc
         #declare TVersY = LintYInc
         #declare TVersZ = LintZInc

         #if (Twisting = off)
            #declare ARot = off
             #declare LintXInc = LintXInc + (TrXStep*TrScaleTotaal)
             #declare LintYInc = LintYInc + (TrYStep*TrScaleTotaal)
             #declare LintZInc = LintZInc + (TrZStep*TrScaleTotaal)
         #else
            #declare Straal = ((Space/TrNumber)*TrScaleTotaal) /2
            #declare A = 180*pi/180 + Dist
            #declare LintXInc = LintXInc + ((Space/TrNumber) * TrXStep * TrScaleTotaal)
            #declare LintYInc = LintYInc + ((Straal * sin (A)) * TrYStep)
            #declare LintZInc = LintZInc + ((Space/TrNumber) * TrZStep * TrScaleTotaal)
            #declare Dist = Dist + DistBase
          #end  // end if twisting is off

       #if (ARot = on)

        #declare UpTotaal = (LintZInc - TVersZ) * (-90)
        #declare RotZTotaal = (LintYInc - TVersY) * (90)
            #if (PowSpindle = on)
             #declare SpindTotaal = pow(SpindleAmount, (LintTeller+1)/TrNumber)
          #else
             #declare SpindTotaal = SpindTotaal + (SpindleAmount/TrNumber)
          #end
        #else

          #if (PowUp = on)
             #declare UpTotaal = pow(UpFactor, (LintTeller+1)/TrNumber)
          #else
             #declare UpTotaal = UpTotaal + (UpFactor/TrNumber)
          #end
             #declare RotZTotaal = RotZTotaal + (RotZAmount/TrNumber)
          #if (PowSpindle = on)
             #declare SpindTotaal = pow(SpindleAmount, (LintTeller+1)/TrNumber)
          #else
             #declare SpindTotaal = SpindTotaal + (SpindleAmount/TrNumber)
          #end
        #end // end if Arot is on

             #declare LintTeller = LintTeller + 1
           #end

           }   // afsluiten LWorm
           #declare LintWorm = union {
           object {LWorm}
           #if (TrHeadOn = on) object {TrHead rotate <0, UpTotaal, RotZTotaal> rotate <SpindTotaal, 0, 0>
                       translate <LintXInc, LintYInc, LintZInc> } #end
           object {Bol pigment {color red 1 green 1 blue 1} scale .001 translate <LintXInc, LintYInc, LintZInc> }
              }

           object {LintWorm translate <-((TrNumber*TrXStep)/2), 0, 0>    // om beestje in midden te houden
  #if (TextureOverThing = on)
     #if (RandTexOn = off) texture {ThingTexture}
     #else texture { RandTex scale TexScale}
     #end
 #end
         #if (RANDOMmode = on)  rotate <TPostRotateX, TPostRotateY, TPostRotateZ> #end
            }  // afsluiten object LintWorm
      #end  // end if Trilobyt is on


/************* ANEMONE **************************************************/

#if (ANEMONE = on)
 #debug "ANEMONE is on ... \n"

  #if (RANDOMmode = on)
                       #declare MSeed28 = seed (MSeed+13)
                       #declare MSeed29 = seed (MSeed+256)
                       #declare MSeed30 = seed (MSeed+316)
                       #declare MSeed31 = seed (MSeed+162)
                       #declare MSeed32 = seed (MSeed+388)
                       #declare MSeed33 = seed (MSeed+112)
                       #declare MSeed34 = seed (MSeed+27)
                       #declare MSeed35 = seed (MSeed+33)
                       #declare MSeed36 = seed (MSeed+321)

                       #declare ANumber = int(rand (MSeed28)*60*ArmFactor)
                       #if (ANumber < 50) #declare ANumber = ANumber + 50 #end
                         #debug concat("  ANumber = ",str(ANumber,4,2),"\n")
                       #declare AScaleFactor = 0
                         #debug "  AScaleFactor set to 0 \n"
                       #declare MajorRad = int(rand(MSeed29)*7)
                        #debug concat("  MajorRad = ",str(MajorRad,4,2),"\n")
                       #declare Turns = int(rand(MSeed30)*720)
                        #debug concat("  Turns = ",str(Turns,4,2),"\n")
                       #if (XTrans = on)
                       #declare XTransFactor = rand(MSeed31)*8
                        #debug concat("  XTransFactor = ",str(XTransFactor,4,2),"\n")
                       #end
                       #declare MinorRad = rand(MSeed32)*3
                        #debug concat("  MinorRad = ",str(MinorRad,4,2),"\n")
                       #declare Revolutions = int(rand(MSeed33)*8)
                        #debug concat("  Revolutions = ",str(Revolutions,4,2),"\n")
                       #declare TPostRotateX = int(rand(MSeed34)*180)
                         #debug concat("  TPostRotateX = ",str(TPostRotateX,4,2), "\n")
                       #declare TPostRotateY = int(rand(MSeed35)*180)
                         #debug concat("  TPostRotateY = ",str(TPostRotateY,4,2), "\n")
                       #declare TPostRotateZ = int(rand(MSeed36)*180)
                        #debug concat("  TPostRotateZ = ",str(TPostRotateZ,4,2), "\n")
                    #end // end if randommode is on


#declare AnemoneWorm =
union {
  #declare LoopAmount = 0
  #declare ScaleTotaal = 1
  #declare Steps = Turns/ANumber
  #while (LoopAmount <= ANumber)
    object {Worm scale ScaleTotaal
        translate <0, 0, MinorRad> rotate <0, Steps*LoopAmount*Revolutions, 0>
        translate <0, 0, MajorRad > rotate <-(Steps*LoopAmount), 0, 0>
      #if (XTrans = on) translate <LoopAmount/XTransFactor, 0, 0> #end
       }
     #declare ScaleTotaal = ScaleTotaal - (AScaleFactor/ANumber)
     #declare MajorRad = MajorRad - (RadFactor/ANumber)
     #declare LoopAmount = LoopAmount + 1
   #end
} // end union AnemoneWorm
 // object {Bol pigment {color red 1 green 1 blue 1} scale .001}  // om foutmelding

object {AnemoneWorm
    #if (TextureOverThing = on)
     #if (RandTexOn = off) texture {ThingTexture}
     #else texture { RandTex scale TexScale}
     #end
    #end
  rotate y*90
  #if (RANDOMmode = on)  rotate <TPostRotateX, TPostRotateY, TPostRotateZ> #end
}
#end   // end if AnemoneWorm is on

#if (RANDOMmode = on & RandTexOn = on)  #debug concat("TexSeed = ",str(TexSeed,4,0)," - ")
                #debug concat("TexScale = ",str(TexScale,4,2),"\n")
#end

//---------Controle als er geen fan, wheel is, wordt 1 gewone Worm gegeven----
#if (FAN = off)
 #if (WHEEL = off)
  #if (TRILOBYT = off)
   #if (ANEMONE = off)
    object {Worm}
   #end
  #end
 #end
#end

//-------------------------------------------------------------------------

object {Bol pigment {color red 1 green 1 blue 1} scale .001}  // om foutmelding te voorkomen
} // end union Thing
#end       // end if SeeSegment is on
