// File: BIOFORM.POV : Form of parms with bioform.include file  160598

/* The purpose of bioform.inc is to make bioforms, but also really bizarre
forms (scifi buildings, ...) are creatable ... depending on the segments, worms you use...
Like they say : Your imagination is the limit
Thanks to Matti Raitoharju for the basis of the Wave-routine
*/

#version 3
#include "biopred.inc"
#include "biotex.inc"
#declare Bi = 2
global_settings {assumed_gamma 2.2}

camera {
  location  <0.0, 0.0, -55.0>
  direction 1.8*z
  right     1*x
  look_at   <0, 0.0, 0.0>
}

// background { color red .8 green .8 blue 1 }

light_source {0*x color red 1.0  green 1.0  blue 1.0 translate <-10, 10, -30>}
light_source {0*x color red 0.60  green 0.60  blue 0.60 translate <40, 60, -60>}

#declare Reference = off  // reference-cross


/*** FORMSTART  *************************************************************************/
/* predef objects in biopred.inc : Bol, Doos, Spik, Torus, Thing2, Jan, Rib, Stulpsel,
            Stok (nog afmaken), Spik2, Spik3
*/

// USING PREDEF WORM      ---> if not ... goto Choose segment, ... ------------------------

  #declare PredefWorm = off
  #declare PredefWormName = object { Jan
                                 // pigment {color Eggshell}  finish {ambient .2 diffuse .7} //  texture {Tex scale 5}
                                  scale 12
                                    }


// CHOOSE/MODEL/SEE SEGMENT  ---------------------------------------------------------------
#declare RandTexOn = on//off
  #declare TexSeed = 11386 * (clock +1)+3
  #if (RandTexOn = on) #include "RandTex.inc" #end
  #declare TexScale = 5.6

   #declare Segment = object {Bol
                            texture {RandTex}
                            }

         #declare SeeSegment = off    // only segment is visible (for modeling the segment)



//  BUILDING WORM INTERACTIVELY with Segment  -----------------------------------------------


   #declare Number = 40        // Number of segments ...
   #declare Space = 20         //  ... in the space taken by
   #declare OmwBasis = 0.3    // range -.6 (turning right) to .6 (turning left) ; 0 is straight up
   #declare LegTrig = 65     // the segment where the routine should reverse, making a leg

   #declare AutoRot = off         // when off, you can define your own rotate
   #declare RotateFactorX = 0       // 360 = turning once across worm ; 360*# for more turns
   #declare RotateFactorY = 0
   #declare RotateFactorZ = 0

   #declare XMoveFactor = 1   // you can limit in which plane the Worm will move (zero no move in that direction)
   #declare YMoveFactor = .5  // the Worm can also be placed in every quadrant you want (neg. vs pos.)
   #declare ZMoveFactor = 1   // 0=no move, 1=ordinary move, -1=ordinary move in opposite direction

   #declare ShrinkFactorX = .5     // 0 is no shrink along the worm, pos is shrink - neg is grow
   #declare ShrinkFactorY = .5
   #declare ShrinkFactorZ = .5
   #declare ShrinkTrig = 80

    #declare BranchOn = off         // on or off
         #declare WormAsBranch = off   // watch out, can become very hugh
            #declare PredBranch = object {Spik3 scale 1}
         #declare BranchNumber = 3       // number of branches
         #declare BranchScale = .5
         #declare BranchRot = 20    // rotate it around z-axis before fanning it
         #declare BranchTextureOn = off
         #declare BranchTexture = texture {pigment {Eggshell} finish {phong .3 phong_size 20 reflection .2}}
         #declare BranchTrigger = 6  // every n segment a branch


    #declare BaseOn = on        // on or off
         #declare WormAsBase = on   // when off, you can declare a predef Base
         #declare BranchedBase = on
            #declare PredBase = Spik3
         #declare BaseNumber = 4
         #declare BaseScale = .5
         #declare BaseRot = 20    // rotate it around z-axis before fanning it
         #declare BaseTextureOn = on

         #declare RandTexOn = on//off

  #declare TexSeed = (112*(clock+1)*2)+1          #if (RandTexOn = on) #include "RandTex.inc" #end
  #declare TexScale = 4

         #declare BaseTexture = texture {RandTex}


    #declare TopOn = off    // on en off
         #declare WormAsTop = on//off     // when off, you can declare a predef Top
         #declare BranchedTop = off
            #declare PredTop =  Spik3
         #declare TopNumber = 1
         #declare TopScale =  .5    //<1,.5,1>
         #declare TopRot = 20    // rotate it around z-axis before fanning it
         #declare TopTextureOn = off
         #declare TopTexture = texture {pigment {White}}

                     // in case of WormAsTop is on, you can form a second Top
                #declare Top2On = off
                #declare Top2Number = 5
                #declare Top2Scale = .3
                #declare Top2Rot = 0
                #declare Top2TextureOn = off
                #declare Top2Texture = texture {pigment {color Eggshell}}


    #declare TopHartOn = off
         #declare TopHart = object {Bol
                               texture {EyeBall}
                              // pigment {color rgbf <1,0,0,.6>} finish {phong .4 phong_size 20 reflection .4}
                             scale 2 //  rotate <0, 0, 0>
                            }
         #declare TopHartUp = -5 // If you want your TopHart higher/lower than last segment



 // POSTSCALE, POSTROTATE, POSTTRANSLATE OF WORM ----------------------------

   #declare PostScaleX = 1    // absolute values (values as used in a scale statement)
   #declare PostScaleY = 1
   #declare PostScaleZ = 1

   #declare PostRotateX = 0   // rotates the Worm where you want it before fanning, wheeling, ...
   #declare PostRotateY = 0
   #declare PostRotateZ = 0

   #declare PostTranslateX = 0  // (with Torus for making a Shell -.3 is a good value with negative Tspread)
   #declare PostTranslateY = 0
   #declare PostTranslateZ = 0


// STATEMENTS FOR BUILDING THING (USING WORM) ------------------------------------------------


   #declare FAN = off          // Fan = rotate along y-axis
   #declare WHEEL = off          // Wheel/Shell = rotate along z-axis; for Shell posttranslate first
   #declare TRILOBYT = off       // Trilobyt = makes a rib, then copy it along x-axis
   #declare ANEMONE = off         // Anemone =


   // STATEMENTS FOR FAN, WHEEL/SHELL------------------------------------------------

   #declare TNumber = 20      // Number of arms
   #declare TSpread = 360     // 360 degrees is one whole turn (also possible 360*#)
                              // neg. is clockwise, pos. is counterclockwise
                      // (Note : with Shell negative with a negative Posttranslate)

   #declare TScaleFactorX = 0   // 0 is no scale, pos is bigger - neg is smaller
   #declare TScaleFactorY = 0
   #declare TScaleFactorZ = 0

   #declare TOffsetTotaal = -10     // Fan (y-axis) : 0 is no offset, pos. is up - neg. is down
                                  // Wheel (z-axis) : 0 is no offset, pos. is away - neg. is towards

   #declare KropDegrees = 30      // Fan : 0 is no krop, pos. is down - neg. is up
                                 // Wheel : 0 is no krop, pos. is towards - neg. is away

   #declare Wave = off         // Up/down waving in Kropdegrees, divided in WaveNumber waves
        #declare WaveNumber = 2

   #declare TLinkOn = off
        #declare TLink = object { FanCyl  //WheelCyl
                                scale <1.5, 5, 1.5>
                               // rotate <0,0,0> translate <0,0,0>
                              }


   #declare Tentacle = off    // Isn't finished yet !!!!
        #declare TentName = object { Stulpsel texture {Pukkels scale 2.5} scale 6
                                  //  rotate <0, 0,0> translate <0, 0, 0>
                                    }
        #declare TentNumber = 1
        #declare TentSpread = 360


   // STATEMENTS FOR TRILOBYT---------------------------------------------------------

    #declare TrHeadOn = on  // you can define a head on top of your trilobyt
         #declare TrHead = object {Bol
                    // texture { EyeBall}
                    scale <2.5, 6, 2.5>
                    }

    #declare TrLinkOn = off
         #declare TrLink = cylinder { <0, 0, 0>, <2, 0, 0>, 1.2
                     // pigment {Red}
                     // scale 2
                    }

    #declare Twisting = on
         #declare DistBase = 0.33
         #declare ARot = on        // Automates the UpFactor, RotZ ... Spindle stays manual

    #declare TrNumber = 18     // number of ribs
    #declare TrXStep = 1.2      // sidely step
    #declare TrYStep = 1.6   // up step
    #declare TrZStep = -.5
    #declare TrScale = .5       // 0 is no scale, pos is smaller, neg bigger

    #declare UpFactor = 0    // y-rotate * degrees (also negative possible)
       #declare PowUp = off    // with PowUp NO neg. UpFactor - when off, linear UpFactor used

    #declare RotZAmount = 0    //  z-rotate * degrees (also negative)

    #declare SpindleAmount = 0    // x-rotate * degrees (also negative)
       #declare PowSpindle = off  // with PowSpindle NO neg. S.Amount - when off, linear S.Amount used



   // STATEMENTS FOR ANEMONE ----------------------------------------------------------

    #declare ANumber = 30     // Number of worms to use for anemone
    #declare AScaleFactor = 0   // 0 no shrink, pos. is shrink, neg. is grow
    #declare MajorRad = 2    // Radius of the major turn
    #declare RadFactor = 0    // 0= circles even, pos smaller, neg. bigger
    #declare Turns = 360   // 360 is one major turn, can be less or more
    #declare XTrans = off  // offset along x-axis, how smaller factor the bigger the translate
         #declare XTransFactor = 2  // extra translate <LoopAmount/XTransFactor, 0, 0>
    #declare MinorRad = 3    // Radius of the minor revolutions
    #declare Revolutions = 2   // number of minor revolutions



// STATEMENTS FOR TEXTURES --------------------------------------------------------------------
    /* By using these textures take care there is no texture statement in segments
     Predef textures in biotex.inc : Tex, Texwith, Knap, Kool, PaarsRood, Pukkels,
                    WitGeel, WitBlauw, Octo, Negativ1, EyeBall, Spiderj, Kwal, HullTex(kleine scale)
                    GridTex (kleine scale), Nelson, Bg, Graniet, Slime (nog aan te passen),
                    Zebra
    */

#declare TextureOverWorm = on
#declare TextureOverThing = on  // turn TextureOverWorm off, if you want a TextureOverThing
  #declare ThingTexture = texture { Graniet scale 20}



// RANDOM MODE -----------------------------------------------------------------------------

/*  Computer defines Worm
       If you put "Debug_File=bioform.txt" in your povstart ini-file, you can redirect the debug-text in a textfile
    You can use "clock"  and "animation" to do a bunch of randoms (Initial_Clock = #, Final_Clock = # ;
     Initial_Frame = # Final_Frame = # in your Ini-file)
*/

#declare zx = seed (clock*10000-5000)
#declare zz = rand (zx)

#declare RANDOMmode = on
                                                                #if (RANDOMmode = on)
   #declare MSeed = (clock*(zz*6)*500)*5 //3001*(clock+0.25)
   #declare ArmFactor = 2   // ArmFactor : number of arms for fan, ... (rand*10*ArmFactor)

   camera {            // camera statement repeated here for easy navigating
        location  <0.0, 0.0, -30.0>
        direction 1.8*z
        right     1*x
        look_at   <0.0, 0.0,  0.0>
   }

   // parameters we want to controll in randommode

   #declare PredefWorm = off    // when off making selfmade worm

   #declare BranchOn = off       // Watch out, it's a real CHOKER
       #declare WormAsBranch = on  // when off, taking the PredBranch

   #declare BaseOn = on
       #declare WormAsBase = off    // when off, taking PredBase
       #declare BranchedBase = on

   #declare TopOn = on
       #declare WormAsTop = on      // when off, taking PredTop
       #declare BranchedTop = off

   #declare TopHartOn = on

   #declare FAN = off
   #declare WHEEL = off
   #declare SHELL = on
   #declare TRILOBYT = on
       #declare Twisting = on
   #declare ANEMONE = off
       #declare XTrans = on
                                                                              #end


// SEE CREATED THING---------------------------------------------------------------------------

/* Thing plus his mirror => Fan + Fan scale <1,-1,1>, Wheel + Wheel scale <1,1,-1>.
      Doing this you can make a Hull of your Fan, Wheel, ...
   Here you can also postscale, postrotate or posttranslate your Thing
      and call the SAME Thing back again but slightly displaced.

*/

//#include "bioform.inc"
//object {Thing
// rotate <34,45,22>
  //        scale 0.8
    //      translate <3,0,0>
     //    no_shadow
      // }


/*  You can also change some parms and re-include bioform.inc to call
      back a DIFFERENT Thing.
    e.g.
    #declare BranchOn = on
    #include "bioform.inc"
   object {Thing rotate y*180}
*/

// ENVIRONMENT --------------------------------------------------------------------------------

// Galaxy ----------------------

/*  #declare galaxy_seed = 45 *(clock+1)
    #declare galaxy_colour1 = <1.3, 1.2, .8>
    #declare galaxy_colour2 = <1, .5, .3>
    #declare galaxy_rotate = <180, 0, 0>

    #include "galaxy.inc"
*/

// Skies --------------------------

    #include "randsky2.inc"
/***END FORM *******************************************************************************/

