// File: BIOFORM.POV : Form of parms with bioform.include file  120598

/* The purpose of bioform.inc is to make bioforms, but also really bizarre
forms (scifi buildings, ...) are creatable ... depending on the segments, worms you use...
Like they say : Your imagination is the limit
Many thanks to Darren Fisher for valuable testing, tips
Thanks to Matti Raitoharju for the basis of the Wave-routine
*/

#version 3
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "biopred.inc"
#include "biotex.inc"
#include "Skorupce.inc"
#include "eye.inc"
#include "stone2.inc"
#include "stones2.inc"
#include "woods.inc"
#include "darren.inc"
#include "stars.inc"
#include "fractal2.inc"

//global_settings {assumed_gamma 2.2}

global_settings {assumed_gamma 2.2
//     ambient_light <0.7,0.7,0.71>*0.7
     }

camera {
  location  <0.0, 0.0, -35.0>
  direction 1.8*z
  right     1*x
  look_at   <0.0, 0.0, 0.0>
}

// background { color red .8 green .8 blue 1 }

light_source {0*x color red 1.0  green 1.0  blue 1.0 translate <-10, 10, -30>*8}
//light_source {0*x color red 0.60  green 0.60  blue 0.60 translate <40, 60, -60>*9}



//object { light_source { <100, 600, -300>  color White}}
object { light_source { <-200, 600, -100> color White}}
//object { light_source { <200, 600, 100> color Gold}}

object {
   light_source {
      <0, 2, 3000>
      color NeonBlue
   }
}



#declare Reference = off  // reference-cross


/*** FORMSTART  *************************************************************************/
/* predef objects in biopred.inc : Bol, Doos, Spik, Torus, Thing2, Jan, Rib, Stulpsel,
            Stok (nog afmaken), Spik2, Spik3
*/

// USING PREDEF WORM      ---> if not ... goto Choose segment, ... ------------------------

  #declare PredefWorm = off
  #declare PredefWormName = object { Jan
                                texture {  Skorupiec_7 scale 1} //  texture {Tex scale 5}
                                  scale 7
                                    }


// CHOOSE/MODEL/SEE SEGMENT  ---------------------------------------------------------------

// now we will put a plane of mandel in
// with a bit of oscillating mclock

#declare clock_type = "O"
#declare clock_start = -1
#declare clock_finish = 1
//#declare clock_repeat = 0
#include "ClockMod.inc"



#declare ptext1 = texture {
pigment {
wood
#if (clock < 0)
lambda 0.76*-(-mclock*1)
omega  0.30*-(-mclock/2)
#else
lambda 0.76*-(mclock*1.32)
omega  0.30*-(mclock/2)
#end

frequency 1.5

#if (clock < 0)
turbulence 0.66*(-mclock*1.2)+0.2
#else
turbulence 0.66 *(mclock * 1.2) +0.2
#end

phase (clock/8.6)*1.33
color_map {
[0.0 color Green]
[0.4 color <1,0,0> + <0,0,1> * mclock]
[0.6 color <0,0,1> + <0.1,0.8,0> *mclock]
[0.8 color Black]
[1.001  color Orange]
}
}

finish {
ambient 0.998
diffuse 0.001
brilliance 32
metallic
}
translate <0,0,0>

#if (clock <0)
scale <1*(-mclock*1.33),1.8234*(-mclock*1.89),2.24> + 0.25
#else
scale <1*(mclock * 1.33),1.8*(mclock*1.89),2.25>
#end

scale 500
}


#declare ptext2 = texture {
pigment {
//spiral2 2
spiral2 3

#if (clock < 0)
lambda 0.76*-(-mclock*1)
omega  0.30*-(-mclock/2)
#else
lambda 0.76*-(mclock*1.32)
omega  0.30*-(mclock/2)
#end

frequency 1.5

#if (clock < 0)
turbulence 0.66*(-mclock*1.2)+0.2
#else
turbulence 0.66 *(mclock * 1.2) +0.2
#end

phase (clock/8.6)*1.33
color_map {
[0.0 color <1,0,0> + <0,0.5,0> * mclock]
[0.5 color <0,1,0> + <0.4,0,1> * mclock]
[0.75 color Orange]
[1.02 color NeonBlue]
}
}

finish {
ambient 0.2
diffuse 0.3
brilliance 8
metallic on
}
translate <0,0,0>

#if (clock <0)
scale <1*(-mclock*1.33),1.8234*(-mclock*1.89),2.24> + 0.25
#else
scale <1*(mclock * 1.33),1.8*(mclock*1.89),2.25>
#end

scale 500
}




#debug concat("  mclock = ",str(mclock,4,2),"\n")

#declare r1 = 12
#declare r2 = 16

#declare E = 0.1
#declare F = 0.25
#declare Count = ( clock/10) + 0.5

#declare r3 = ((r2-r1) * 8) / (2/Count)*2*(mclock+1)

#debug concat("  r3 = ",str(r3,4,2),"\n")

#declare X=r3*sin(E*Count)*cos(F*Count)
#declare Y=r3*sin(E*Count)*sin(F*Count)
#declare Z=r3*cos(F*Count)
// some debug messages
#debug concat("  Count = ",str(Count,4,2),"\n")
#debug concat("  X = ",str(X,4,2),"\n")
#debug concat("  Y = ",str(Y,4,2),"\n")
#debug concat("  Z = ",str(Z,4,2),"\n")

#declare block_color1 = <abs(X*1.35)/r1 ,0.5,0.5>
#declare block_color2 = <0.5,abs(Y)/r1,0.5>
#declare block_color3 = <0.5,0.5,abs(Z*2)/r3>
//for creeping 2
#declare block_color4 = <abs(Z*2)/r3,0.5,0.5>
#declare block_color5 = <0.5,abs(Y)/r1,0.5>
#declare block_color6 = <0.5,0.5,abs(X*1.35)/r1>
//for creeping 3
#declare block_color7 = <abs(X)/r1,0.5,0.5>
#declare block_color8 = <0.5,abs(Z*2)/r3,0.5>
#declare block_color9 = <0.5,abs(Y)/r1,0.5>
//for creeping 4 - a bit of average

#declare block1 = <abs(X*1.25)/r3,0.5,abs(Z*1.25)/r3>
#declare block2 = <0.5,abs(Y)/r3,abs(X)/r1>
#declare block3 = <abs(X*1.25)/r3,abs(Z*1.25)/r3,abs(Y*0.75)/r3>


#declare rot = (360/clock) + 1

#declare creeping = texture {
                    pigment {

                    crackle
                    turbulence 0.2
                    color_map {
                    [0.0  color block_color1]
                    //[0.25 color Red]
                    [0.33 color block_color3]
                   // [0.50 color Green]
                    [0.66 color block_color2]
                   // [0.75 color Blue]
                    [1.00 color block_color1]
                    }
                    }
                         finish {
         ambient 0.2
         diffuse 0.6
         phong 0.3
         phong_size 100
         specular 1.00
         roughness 0.0001
         reflection 0.3
         metallic on
         brilliance 6}



                    translate <0,0,0>
                   scale 0.09
                    }



#declare creeping2 = texture {
                    pigment {

                    crackle
                    turbulence 0.2
                    color_map {
                    [0.0  color block_color4]

                    [0.33 color block_color5]

                    [0.66 color block_color6]

                    [1.00 color block_color4]
                    }
                    }
                         finish {
         ambient 0.2
         diffuse 0.6
         phong 0.3
         phong_size 100
         specular 1.00
         roughness 0.0001
         reflection 0.3
         metallic on
         brilliance 6}



                    translate <0,0,0>
                   scale 0.09
                    }



#declare creeping3 = texture {
                    pigment {

                    crackle
                    turbulence 0.2
                    color_map {
                    [0.0  color block_color7]

                    [0.33 color block_color8]

                    [0.66 color block_color9]

                    [1.00 color block_color7]
                    }
                    }
                         finish {
         ambient 0.2
         diffuse 0.6
         phong 0.3
         phong_size 100
         specular 1.00
         roughness 0.0001
         reflection 0.3
         metallic on
         brilliance 6}



                    translate <0,0,0>
                   scale 0.09
                    }






#declare creeping4 = texture {
                    pigment {

                    crackle
                    turbulence 0.2
                    color_map {
                    [0.0  color block1]

                    [0.33 color block2]

                    [0.66 color block3]

                    [1.00 color block1]
                    }
                    }
                         finish {
         ambient 0.2
         diffuse 0.6
         phong 0.3
         phong_size 100
         specular 1.00
         roughness 0.0001
         reflection 0.3
         metallic on
         brilliance 6}



                    translate <0,0,0>
                   scale 0.09
                    }

#declare skystone = texture {
marble
//mandel 1220
//frequency 16

//translate <1.5,0,0>
//rotate <30,0,0>
//scale 90

turbulence 0.2
texture_map {
                    [0.0  T_Stone27 scale 4 ]
                    [0.125 fractal_soup0 scale 2]
                    [0.175 creeping scale 2]
                    [0.25 Polished_Chrome]
                    [0.33 crazy1 scale 12]
                    [0.5  T_Stone29 scale 4 ]
                    [0.61255 creeping4 scale 2]
                    [0.7  Copper_Texture]
                    [1.01 crazy2 scale 24]
}
translate <0,0,0>
scale 14
}




#declare rook =
plane {
z,5000
texture { ptext2
scale 17.8

}

}

//object {rook}


#declare Sculpt =
julia_fractal { < -.8, .4, .545, -.23> * 0.865

quaternion
    sqr
    max_iteration 8
    precision 100
translate <0,0,0>
scale 0.8
}



    #declare Segment = object {Bol
                               texture  {
                               Skorupiec_3b



                              translate <0,0,0>
                               scale 1.4

                               }





}



#declare dazzle =  texture  {
                               //average
                               crackle
                               turbulence 0.25
                               frequency 2
                               texture_map {
                               [0.0 Skorupiec_1 scale 4]
                               [0.3 Skorupiec_5 scale 4]
                               [1.0 Skorupiec_3b scale 2]

                               }
                               translate <0,0,0>
                               scale 1.5


                               } // if you want a texture over Worm, etc.
                              //  scale 7              // comment texture statement out
                               //  rotate <0,0,0>

         #declare SeeSegment = off    // only segment is visible (for modeling the segment)



//  BUILDING WORM INTERACTIVELY with Segment  -----------------------------------------------


   #declare Number = 32        // Number of segments ...
   #declare Space = 20         //  ... in the space taken by
   #declare OmwBasis = 0.2    // range -.6 (turning right) to .6 (turning left) ; 0 is straight up
   #declare LegTrig = 50     // the segment where the routine should reverse, making a leg

   #declare AutoRot = on         // if off, you can define your own rotate
   #declare RotateFactorX = 0       // 360 = turning once across worm ; 360*# for more turns
   #declare RotateFactorY = 0
   #declare RotateFactorZ = 0

   #declare XMoveFactor = 1   // you can limit in which plane the Worm will move (zero no move in that direction)
   #declare YMoveFactor = .5  // the Worm can also be placed in every quadrant you want (neg. vs pos.)
   #declare ZMoveFactor = 1   // 0=no move, 1=ordinary move, -1=ordinary move in opposite direction

   #declare ShrinkFactorX = .5     // 0 is no shrink along the worm, pos is shrink - neg is grow
   #declare ShrinkFactorY = .5
   #declare ShrinkFactorZ = .5

    #declare BranchOn = on         // on or off
         #declare WormAsBranch = on   // watch out, can become very hugh
            #declare PredBranch = object {Spik3 scale 5}
         #declare BranchNumber = 3       // number of branches
         #declare BranchScale = .5
         #declare BranchRot = 20    // rotate it around z-axis before fanning it
         #declare BranchTextureOn = on
         #declare BranchTexture = texture {pigment {Eggshell} finish {phong .3 phong_size 20 reflection .2}}
         #declare BranchTrigger = 6  // every n segment a branch


    #declare BaseOn = on       // on or off
         #declare WormAsBase = on   // if off, you can declare a predef Base
         #declare BranchedBase = off
            #declare PredBase = Torus
         #declare BaseNumber = 6
         #declare BaseScale = .5
         #declare BaseRot = 23    // rotate it around z-axis before fanning it
         #declare BaseTextureOn = on
         #declare BaseTexture = texture {Skorupiec_5 scale 2.275}


    #declare TopOn = off    // on en off
         #declare WormAsTop = off     // if off, you can declare a predef Top
         #declare BranchedTop = off
            #declare PredTop =  Spik3
         #declare TopNumber = 1
         #declare TopScale =  .5    //<1,.5,1>
         #declare TopRot = 20    // rotate it around z-axis before fanning it
         #declare TopTextureOn = on
         #declare TopTexture = texture {pigment {White}}

                     // in case of WormAsTop is on, you can form a second Top
                #declare Top2On = off
                #declare Top2Number = 5
                #declare Top2Scale = .3
                #declare Top2Rot = 0
                #declare Top2TextureOn = off
                #declare Top2Texture = texture {pigment {color Eggshell}}


    #declare TopHartOn = on
         #declare TopHart = object {Bol
                               texture {Negativ1}
                              // pigment {color rgbf <1,0,0,.6>} finish {phong .4 phong_size 20 reflection .4}
                             scale 2 //  rotate <0, 0, 0>
                            }
         #declare TopHartUp = -7 // If you want your TopHart higher/lower than last segment



 // POSTSCALE, POSTROTATE, POSTTRANSLATE OF WORM ----------------------------

   #declare PostScaleX = 1    // absolute values (values as used in a scale statement)
   #declare PostScaleY = 1
   #declare PostScaleZ = 1

   #declare PostRotateX = 0   // rotates the Worm where you want it before fanning, wheeling, ...
   #declare PostRotateY = 0
   #declare PostRotateZ = 0

   #declare PostTranslateX = 0  // (with Torus for making a Shell -.3 is a good value with negative Tspread)
   #declare PostTranslateY = 0
   #declare PostTranslateZ = 0


// STATEMENTS FOR BUILDING THING (USING WORM) ------------------------------------------------


   #declare FAN = off          // Fan = rotate along y-axis
   #declare WHEEL = off          // Wheel/Shell = rotate along z-axis; for Shell posttranslate first
   #declare TRILOBYT = off       // Trilobyt = makes a rib, then copy it along x-axis
   #declare ANEMONE = off         // Anemone =


   // STATEMENTS FOR FAN, WHEEL/SHELL------------------------------------------------

   #declare TNumber = 8      // Number of arms
   #declare TSpread = 360     // 360 degrees is one whole turn (also possible 360*#)
                              // neg. is clockwise, pos. is counterclockwise
                      // (Note : with Shell negative with a negative Posttranslate)

   #declare TScaleFactorX = 0   // 0 is no scale, pos is bigger - neg is smaller
   #declare TScaleFactorY = 0
   #declare TScaleFactorZ = 0

   #declare TOffsetTotaal = -4     // Fan (y-axis) : 0 is no offset, pos. is up - neg. is down
                                  // Wheel (z-axis) : 0 is no offset, pos. is away - neg. is towards

   #declare KropDegrees = 40      // Fan : 0 is no krop, pos. is down - neg. is up
                                 // Wheel : 0 is no krop, pos. is towards - neg. is away

   #declare Wave = off         // Up/down waving in Kropdegrees, divided in WaveNumber waves
        #declare WaveNumber = 2

   #declare TLinkOn = off
        #declare TLink = object { FanCyl  //WheelCyl
                                scale <1.5, 5, 1.5>
                               // rotate <0,0,0> translate <0,0,0>
                              }


   #declare Tentacle = off    // Isn't finished yet !!!!
        #declare TentName = object { Stulpsel texture {Pukkels scale 2.5} scale 6
                                  //  rotate <0, 0,0> translate <0, 0, 0>
                                    }
        #declare TentNumber = 1
        #declare TentSpread = 360


   // STATEMENTS FOR TRILOBYT---------------------------------------------------------

    #declare TrHeadOn = on  // you can define a head on top of your trilobyt
         #declare TrHead = object {Bol
                    // texture { EyeBall}
                    scale <2.5, 6, 2.5>
                    }

    #declare TrLinkOn = off
         #declare TrLink = cylinder { <0, 0, 0>, <2, 0, 0>, 1.2
                     // pigment {Red}
                     // scale 2
                    }

    #declare Twisting = on
         #declare DistBase = 0.3
         #declare ARot = on        // Automates the UpFactor, RotZ ... Spindle stays manual

    #declare TrNumber = 12     // number of ribs
    #declare TrXStep = 1      // sidely step
    #declare TrYStep = 3    // up step
    #declare TrZStep = -2
    #declare TrScale = .2       // 0 is no scale, pos is smaller, neg bigger

    #declare UpFactor = 0    // y-rotate * degrees (also negative possible)
       #declare PowUp = off    // with PowUp NO neg. UpFactor - if off, linear UpFactor used

    #declare RotZAmount = 0    //  z-rotate * degrees (also negative)

    #declare SpindleAmount = 0    // x-rotate * degrees (also negative)
       #declare PowSpindle = off  // with PowSpindle NO neg. S.Amount - if off, linear S.Amount used



   // STATEMENTS FOR ANEMONE ----------------------------------------------------------

    #declare ANumber = 60     // Number of worms to use for anemone
    #declare AScaleFactor = 0   // 0 no shrink, pos. is shrink, neg. is grow
    #declare MajorRad = 2    // Radius of the major turn
    #declare RadFactor = 0    // 0= circles even, pos smaller, neg. bigger
    #declare Turns = 360   // 360 is one major turn, can be less or more
    #declare XTrans = off  // offset along x-axis, how smaller factor the bigger the translate
         #declare XTransFactor = 2  // extra translate <LoopAmount/XTransFactor, 0, 0>
    #declare MinorRad = 3    // Radius of the minor revolutions
    #declare Revolutions = 2   // number of minor revolutions



// STATEMENTS FOR TEXTURES --------------------------------------------------------------------
    /* By using these textures take care there is no texture statement in segments
     Predef textures in biotex.inc : Tex, Texwith, Knap, Kool, PaarsRood, Pukkels,
                    WitGeel, WitBlauw, Octo, Negativ1, EyeBall, Spiderj, Kwal, HullTex(kleine scale)
                    GridTex (kleine scale), Nelson, Bg, Graniet, Slime (nog aan te passen),
                    Zebra
    */

#declare TextureOverWorm = off
#declare TextureOverThing = on  // turn TextureOverWorm off, if you want a TextureOverThing

#declare ThingTexture = texture {   Skorupiec_7 translate <0,0,0> rotate x*90 scale 1}


// RANDOM MODE -----------------------------------------------------------------------------

/*  Computer defines Worm
       If you put "Debug_File=bioform.txt" in your povstart ini-file, you can redirect the debug-text in a textfile
    You can use "clock"  and "animation" to do a bunch of randoms (Initial_Clock = #, Final_Clock = # ;
     Initial_Frame = # Final_Frame = # in your Ini-file)
*/

#declare RANDOMmode = on
                                                                #if (RANDOMmode = on)
   #declare MSeed = ((-33*clock+1) * 10) * 4
   #declare ArmFactor = 3   // ArmFactor : number of arms for fan, ... (rand*10*ArmFactor)

   camera {            // camera statement repeated here for easy navigating
        location  <0.0, 0.0, -30.0>
        direction 1.8*z
        right     1*x
        look_at   <0.0, 0.0,  0.0>
   }

   // parameters we want to controll in randommode

   #declare BranchOn = off        // Watch out, it's a real CHOKER
       #declare WormAsBranch = on
   #declare BaseOn = off
       #declare WormAsBase = off
       #declare BranchedBase = off
   #declare TopOn = on
       #declare WormAsTop = off
       #declare BranchedTop = on
   #declare TopHartOn = off

   #declare FAN = on//on
   #declare WHEEL = on
   #declare SHELL = on
   #declare TRILOBYT = on //on
       #declare Twisting = on
   #declare ANEMONE = off
       #declare XTrans = on
                                                                              #end


// SEE CREATED THING---------------------------------------------------------------------------

/* Thing plus his mirror => Fan + Fan scale <1,-1,1>, Wheel + Wheel scale <1,1,-1>.
      Doing this you can make a Hull of your Fan, Wheel, ...
   Here you can also postscale, postrotate or posttranslate your Thing
      and call the SAME Thing back again but slightly displaced.

*/

#include "bioform.inc"
object {Thing
translate <0,0,0>
scale 0.8

//texture { Skorupiec_7 scale 1}
      //    scale 2
       }


/***END FORM *******************************************************************************/

