// File: BIOFORM.POV : Form of parms with bioform.include file  120598

/* The purpose of bioform.inc is to make bioforms, but also really bizarre
forms (scifi buildings, ...) are creatable ... depending on the segments, worms you use...
Like they say : Your imagination is the limit
Many thanks to Darren Fisher for valuable testing, tips
Thanks to Matti Raitoharju for the basis of the Wave-routine
*/

#version 3


#include "biopred.inc"
#include "biotex.inc"
#include "Skorupce.inc"



global_settings {assumed_gamma 2.2

     }

camera {
  location  <0.0, 0.0, -35.0>
  direction 1.1*z
  right     1*x
  look_at   <0.0, 0.0, 0.0>
}



// Light source
object {
   light_source {
      <100, 200, -300>
      color White
   }
}

// Light source
object {
   light_source {
      <-200, 200, -100>
      color White
   }
}






// Light source
object {
   light_source {
      <1000, 0, 5000>
      color Gold
   }
}






#declare Reference = off  // reference-cross


/*** FORMSTART  *************************************************************************/
/* predef objects in biopred.inc : Bol, Doos, Spik, Torus, Thing2, Jan, Rib, Stulpsel,
            Stok (nog afmaken), Spik2, Spik3
*/

// USING PREDEF WORM      ---> if not ... goto Choose segment, ... ------------------------

  #declare PredefWorm = off
  #declare PredefWormName = object { Jan
                                texture {  Skorupiec_7 scale 1} //  texture {Tex scale 5}
                                  scale 7
                                    }


// CHOOSE/MODEL/SEE SEGMENT  ---------------------------------------------------------------

#declare SingleSeed =   10*(clock*3.33)+256
#declare ImgNo = 12*clock  // change this value to clock to grow a crop
#declare Time = 2.5 * clock

#debug concat("  Singleseed = ",str(SingleSeed,4,2),"\n")
#debug concat("  ImgNo =      ",str (ImgNo,4,2),"\n")


#include "TextureFarm.inc"

#declare sl1 = texture {TextureFarm scale 2}

#declare Time = clock * 4.5

#include "TextureFarm.inc"

#declare sl2 = texture {TextureFarm scale 2}


#declare ImgNo = 3*clock*1.5

#include "LayerFarm"





    #declare Segment = object {Bol

                               texture {

                                 marble

                                 turbulence 0.666

                               texture_map {



                       [0.0  Layer1 scale 6]
                       [0.25 Layer2 scale 8]
                       [0.50 Layer3 scale 7.5]
                       [0.75 sl1 scale 12]
                       [1.00 sl2 scale 14]
                 }
                 translate <0,0,0>

                 scale 20


}





}



#declare dazzle =  texture  {
                               //average
                               crackle
                               turbulence 0.25
                               frequency 2
                               texture_map {
                               [0.0 Skorupiec_1 scale 4]
                               [0.3 Skorupiec_5 scale 4]
                               [1.0 Skorupiec_3b scale 2]

                               }
                               translate <0,0,0>
                               scale 1.5


                               } // if you want a texture over Worm, etc.
                              //  scale 7              // comment texture statement out
                               //  rotate <0,0,0>

         #declare SeeSegment = off    // only segment is visible (for modeling the segment)

// now we will have a nice textured background or sksphere
#declare clock_type = "O"
#declare clock_start = -1
#declare clock_finish = 1

#include "ClockMod.inc"
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "eye.inc"
#include "stone2.inc"
#include "stones2.inc"
#include "woods.inc"
#include "darren.inc"
#include "stars.inc"
#include "fractal2.inc"



#declare sexy_height =
    pigment {
        image_map { gif "blot.gif" interpolate 2 }
    rotate x*90                  // rotate the image to the x/z plane
    translate <-0.5, 0, -0.5>    // center the whole shebang
}

#declare sexy_picture = texture {
                        sexy_height
                        finish {
                        Metal
                        }
                        scale 4

                         }


#include "skies.inc"

 // The distance from ground to the top of the sky

// A few different color_maps for the clouds, all of these are ok.

#declare Colors1 = color_map
   {
   [0.0 0.1 color rgb <2/3, 2/3, 1> color rgb <2/3, 2/3, 1>]
   [1.0 color White]
   }

#declare Colors2 = color_map  // Realistic
   {
   [0.0 0.1 color SkyBlue color SkyBlue]
   [1.0 color White]
   }

#declare Colors3 = color_map  // Very realistic!
   {
   [0.0 0.1 color SkyBlue color SkyBlue]
   [0.70 color rgb <4/5, 4/5, 5/6>]
   [1.0 color White]
   }

#declare Storm = color_map  // looks quite heavy with SkyColor in the lower layer!
   {
   [0.0 0.1 color Clear color Clear]
   [0.70 color rgbf <4/5, 4/5, 5/6, 1/2>]
   [1.0 color White]
   }

#declare CloudSky = texture  // this is the cloud texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      octaves 3   // doesn't have much effect
      lambda 11    // bigger values are worth trying
      color_map { Colors3 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6   // please notice
   }

#declare CloudSky1 = texture  // this is the cloud texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      octaves 3   // doesn't have much effect
      lambda 11    // bigger values are worth trying
      color_map { Colors1 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6   // please notice
   }

   #declare CloudSky2 = texture  // this is the cloud texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      octaves 3   // doesn't have much effect
      lambda 11    // bigger values are worth trying
      color_map { Colors2 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6   // please notice
   }
#declare oops_aah = texture {
                    wood

                    texture_map {
                    [0.0 flame scale 0.1]
                    [0.2 nice_stone2 scale 2]
                    [0.3 Jade scale 2]
                    [0.5 Stone40 scale 2 finish {ambient 0.6 diffuse 0.4 reflection 0.9}]
                    [0.6 totally_twisted scale 2]
                    [0.7 metal_bozo2 scale 2]
                    [0.9 Stone21 scale 2]
                    [1.01 Chaos2 scale 0.8]
                    }
                    scale 1/6
                    translate <0,0,0>
                    rotate x*-90
                    scale 0.8
                    scale 2
                    scale 0.4
                    scale 2.5
                    scale 2.2
                    }






#declare gray_sky =

      texture {
         pigment {
            onion
            turbulence 0.8
            color_map {
               [0.00, 0.10 color Gray40 color Gray30]
               [0.10, 0.11 color Gray30 color Wheat]
               [0.11, 0.14 color Wheat color Gray30]
               [0.14, 0.30 color Gray30 color Black]
               [0.30, 0.32 color Black color White ]
               [0.32, 0.33 color White color Black ]
               [0.33, 1.01 color Black color Gray40]
            }
         }
         finish {
            ambient 0.8
            diffuse 0.0
         }
         scale <1.5, 1, 1>
         scale 0.32
         rotate <0, -5, 0>
         scale 2.5
      }

   #declare blue_sky = texture {
pigment {
   bozo
   octaves 3
   lambda 24
   turbulence 0.3
            color_map {
               [0.00, 0.10 color Scarlet color Orange]
               [0.10, 0.11 color Orange color NeonBlue]
               [0.11, 0.14 color NeonBlue color Orange]
               [0.14, 0.30 color Orange color Black]
               [0.30, 0.32 color Black color White ]
               [0.32, 0.33 color White color Black ]
               [0.33, 1.01 color Black color Scarlet]
            }}
            scale 1/6
            }

            #declare red_sky =

      texture {
         pigment {
            onion
            turbulence 0.8
            color_map {
               [0.00, 0.10 color Red color Scarlet]
               [0.10, 0.11 color Scarlet color Orange]
               [0.11, 0.14 color Orange color Scarlet]
               [0.14, 0.30 color Scarlet color Black]
               [0.30, 0.32 color Black color White ]
               [0.32, 0.33 color White color Black ]
               [0.33, 1.01 color Black color Red]
            }
         }
         finish {
            ambient 0.8
            diffuse 0.0
         }
         scale <1.5, 1, 1>
         scale 0.32
         rotate <0, -5, 0>
         scale 2.5
      }



#declare cloud_map = texture {
bozo
turbulence 1.10
texture_map {
[0.0 Bright_Blue_Sky]
[0.01 Stone40]
[0.02 flame scale 0.10]
[0.22 CloudSky2]
[0.3  CloudSky]
[0.5  CloudSky1]
[0.51 Chaos5 scale 0.1]
[0.7  Starfield3 scale 2]
[1.001 CloudSky1]
}
translate <0,0,0>
scale 1/6

scale <2.5,1.6,1.6>
rotate <0,-12,0>
scale 0.32
scale 2.5
translate <0,0,0>
}


#declare psyc_sky = texture {
                    radial
                    frequency 4
                    rotate -x * 90

                    turbulence 1.5
                    texture_map {
                    [0.0  Blue_Sky scale <4,2,3>]
                    [0.1  Chaos5 scale 0.8]
                    [0.22 red_sky scale 2]
                    [0.34 blue_sky scale 2]
                    [0.5  Starfield3 scale 1.4]
                    [0.7  P_Cloud1 scale 1.1]
                    [0.72 P_Cloud3 scale 1.1]
                    [0.74 P_Cloud4 scale 1.2]
                    [0.76 P_Cloud2 scale 1.2]
                    [0.8  Chaos3 scale 4]
                    [0.81 cloud_map scale 2]
                    [1.01 cloud_map scale 2]
                    }
                    scale 1/6
                    scale <12,7.5,8> * 1.25 * 1.33
                    }


#declare semi_mirror = finish {ambient 0.3 diffuse 0.01 reflection 0.4 specular 1.0 roughness 0.00001}

#declare skymap2 = texture_map {
[0.0 CloudSky finish {semi_mirror}]
[0.0 CloudSky finish {semi_mirror}]
[0.25 fractal_sky1 scale 0.1]
[0.25 fractal_sky1 scale 0.1]
[0.33 psyc_sky scale 2]
[0.5 sexy_picture scale 0.1]
[0.5 sexy_picture scale 0.1]
[0.6 psyc_sky scale 2]
[0.75 Chaos5 scale 0.8]
[0.75 Chaos5 scale 0.8]
[1.0 Silver_Texture finish {semi_mirror}]
[1.0 Silver_Texture finish {semi_mirror}]
}

#declare radial_sky =
                    texture {

   radial
   frequency 4.2
   phase 1.5
   turbulence 0.1
   rotate x*90
   translate <0,0,0>
   texture_map {skymap2}
   translate <0,0,0>
   scale 0.25

                    }


// now to put some random texture creations in the mix (yes it is a bit like mixing!!)
#declare muddle = seed (125*mclock+1)
#declare muds   = rand(muddle) + 0.2


#declare SingleSeed= clock * 12

#declare ImgNo = clock
#declare Time = 2


#debug concat("  random no = ",str(muds,4,2),"\n")
#debug concat("  Singleseed = ",str(SingleSeed,4,2),"\n")
#debug concat("  ImgNo =      ",str (ImgNo,4,2),"\n")
#debug concat("  Time  =      ",str (ImgNo,4,2),"\n")


#include "TextureFarm.inc"
#declare pl1 = texture {TextureFarm translate <0,0,0> scale 4}

#declare Time = clock * 4 * clock

#include "TextureFarm.inc"
#declare pl2 = texture {TextureFarm}

#declare Time = (clock * 160 ) - 256

#include "TextureFarm.inc"
#declare pl3 = texture {TextureFarm}

#declare Time = (32*(clock*4)/(180*pi))+3

#include "TextureFarm.inc"
#declare pl4 = texture {TextureFarm}

#declare r1 = 12
#declare r2 = 16

#declare E = 0.1
#declare F = 0.25
#declare Count = ( clock/10) + 0.5

#declare r3 = ((r2-r1) * 8) / (2/Count)*2*(muds+1)

#debug concat("  r3 = ",str(r3,4,2),"\n")

#declare X=r3*sin(E*Count)*cos(F*Count)
#declare Y=r3*sin(E*Count)*sin(F*Count)
#declare Z=r3*cos(F*Count)


#debug concat("  X = ",str(X,4,2),"\n")

#debug concat("  Y = ",str(Y,4,2),"\n")


#debug concat("  Z = ",str(Z,4,2),"\n")

#declare Time = 1.2*(2*(X*Y)-(Z*E)+clock)



#include "TextureFarm.inc"
#declare pl5 = texture {TextureFarm}


#declare skymap3 = texture {
crackle
turbulence 0.1
frequency 4


texture_map {
[0.00 pl1 scale 4]
[0.32 pl3 scale 4]
[0.56 pl4 scale 4]
[0.75 pl5 scale 4]
[0.81 pl2 scale 4]
//[0.91 red_sky scale 1.2]
//[1.02 blue_sky scale 1.2]
}
translate <0,0,0>
 scale 1/6
 scale <12,7.5,8> * 1.25 * 1.33

}


#declare wood_sky = texture {
//                   mandel 1220
                   mandel 1220
frequency 16
//translate <1.5,0,0>
//rotate <30,0,0>
scale 1/102

                //   translate <1.5,0,0>
                   rotate x * 32
                  scale 14.5
                  phase 1*(clock/3)
                    //spiral1 3
                    //turbulence 0.3
                  //  turbulence 0.05
                    //frequency 2


                    texture_map {
                    [0.0 psyc_sky scale 4]
                    [0.5 skymap3 scale 4]
                    [1.0 CloudSky scale 4]
                    }
                    translate <0,0,0>
                    //scale (1/6) 
                    }

#declare Sky_Top = 3000
sphere  // the sky globe -- please notice the scalings!
   {
   <0, 0, 0>, 1
   texture { wood_sky }
   scale <Sky_Top*10, (Sky_Top*3.89), Sky_Top*10> * 1
   hollow
   no_shadow
   }





//texture
//{
//wood
//turbulence 0.2
//texture_map {
//[0.0 pl_texture scale 2]
//[0.33 pl2 scale 3.3]
//[0.65 pl3 scale 5]
//[1.00 Layer1 scale 2]
//}
//translate <0,0,0>
//scale 1212
//}
//translate <0,0,0>//
//}

//  BUILDING WORM INTERACTIVELY with Segment  -----------------------------------------------


   #declare Number = 32        // Number of segments ...
   #declare Space = 20         //  ... in the space taken by
   #declare OmwBasis = 0.2    // range -.6 (turning right) to .6 (turning left) ; 0 is straight up
   #declare LegTrig = 50     // the segment where the routine should reverse, making a leg

   #declare AutoRot = on         // if off, you can define your own rotate
   #declare RotateFactorX = 0       // 360 = turning once across worm ; 360*# for more turns
   #declare RotateFactorY = 0
   #declare RotateFactorZ = 0

   #declare XMoveFactor = 1   // you can limit in which plane the Worm will move (zero no move in that direction)
   #declare YMoveFactor = .5  // the Worm can also be placed in every quadrant you want (neg. vs pos.)
   #declare ZMoveFactor = 1   // 0=no move, 1=ordinary move, -1=ordinary move in opposite direction

   #declare ShrinkFactorX = .5     // 0 is no shrink along the worm, pos is shrink - neg is grow
   #declare ShrinkFactorY = .5
   #declare ShrinkFactorZ = .5

    #declare BranchOn = on         // on or off
         #declare WormAsBranch = on   // watch out, can become very hugh
            #declare PredBranch = object {Spik3 scale 5}
         #declare BranchNumber = 3       // number of branches
         #declare BranchScale = .5
         #declare BranchRot = 20    // rotate it around z-axis before fanning it
         #declare BranchTextureOn = on
         #declare BranchTexture = texture {pigment {Eggshell} finish {phong .3 phong_size 20 reflection .2}}
         #declare BranchTrigger = 6  // every n segment a branch


    #declare BaseOn = on       // on or off
         #declare WormAsBase = on   // if off, you can declare a predef Base
         #declare BranchedBase = off
            #declare PredBase = Torus
         #declare BaseNumber = 6
         #declare BaseScale = .5
         #declare BaseRot = 23    // rotate it around z-axis before fanning it
         #declare BaseTextureOn = on

         #declare SingleSeed = 4  	// This number is the single seed that starts it all.
							// Change this to creat a new batch of textures


#declare Cycle = 4
#declare ImgNo = 2+sin(clock*pi)*Cycle  // change this value to clock to grow a crop
#declare Time = ImgNo*1.2
#include "TextureFarm.inc"

         #declare BaseTexture = texture {TextureFarm scale 2.275}


    #declare TopOn = off    // on en off
         #declare WormAsTop = off     // if off, you can declare a predef Top
         #declare BranchedTop = off
            #declare PredTop =  Spik3
         #declare TopNumber = 1
         #declare TopScale =  .5    //<1,.5,1>
         #declare TopRot = 20    // rotate it around z-axis before fanning it
         #declare TopTextureOn = on
         #declare TopTexture = texture {pigment {White}}

                     // in case of WormAsTop is on, you can form a second Top
                #declare Top2On = off
                #declare Top2Number = 5
                #declare Top2Scale = .3
                #declare Top2Rot = 0
                #declare Top2TextureOn = off
                #declare Top2Texture = texture {pigment {color Eggshell}}


    #declare TopHartOn = on
         #declare TopHart = object {Bol
                               texture {EyeBall}

                             scale 2.5
                            }
         #declare TopHartUp = -5 // If you want your TopHart higher/lower than last segment



 // POSTSCALE, POSTROTATE, POSTTRANSLATE OF WORM ----------------------------

   #declare PostScaleX = 1    // absolute values (values as used in a scale statement)
   #declare PostScaleY = 1
   #declare PostScaleZ = 1

   #declare PostRotateX = 0   // rotates the Worm where you want it before fanning, wheeling, ...
   #declare PostRotateY = 0
   #declare PostRotateZ = 0

   #declare PostTranslateX = 0  // (with Torus for making a Shell -.3 is a good value with negative Tspread)
   #declare PostTranslateY = 0
   #declare PostTranslateZ = 0


// STATEMENTS FOR BUILDING THING (USING WORM) ------------------------------------------------


   #declare FAN = off          // Fan = rotate along y-axis
   #declare WHEEL = off          // Wheel/Shell = rotate along z-axis; for Shell posttranslate first
   #declare TRILOBYT = off       // Trilobyt = makes a rib, then copy it along x-axis
   #declare ANEMONE = off         // Anemone =


   // STATEMENTS FOR FAN, WHEEL/SHELL------------------------------------------------

   #declare TNumber = 8      // Number of arms
   #declare TSpread = 360     // 360 degrees is one whole turn (also possible 360*#)
                              // neg. is clockwise, pos. is counterclockwise
                      // (Note : with Shell negative with a negative Posttranslate)

   #declare TScaleFactorX = 0   // 0 is no scale, pos is bigger - neg is smaller
   #declare TScaleFactorY = 0
   #declare TScaleFactorZ = 0

   #declare TOffsetTotaal = -4     // Fan (y-axis) : 0 is no offset, pos. is up - neg. is down
                                  // Wheel (z-axis) : 0 is no offset, pos. is away - neg. is towards

   #declare KropDegrees = 40      // Fan : 0 is no krop, pos. is down - neg. is up
                                 // Wheel : 0 is no krop, pos. is towards - neg. is away

   #declare Wave = off         // Up/down waving in Kropdegrees, divided in WaveNumber waves
        #declare WaveNumber = 2

   #declare TLinkOn = off
        #declare TLink = object { FanCyl  //WheelCyl
                                scale <1.5, 5, 1.5>
                               // rotate <0,0,0> translate <0,0,0>
                              }


   #declare Tentacle = on//off    // Isn't finished yet !!!!
        #declare TentName = object { Stulpsel texture {Pukkels scale 2.5} scale 6
                                  //  rotate <0, 0,0> translate <0, 0, 0>
                                    }
        #declare TentNumber = 1
        #declare TentSpread = 360


   // STATEMENTS FOR TRILOBYT---------------------------------------------------------

    #declare TrHeadOn = on  // you can define a head on top of your trilobyt
         #declare TrHead = object {Bol
                     texture { EyeBall}
                    scale <2.5, 6, 2.5>
                    }

    #declare TrLinkOn = off
         #declare TrLink = cylinder { <0, 0, 0>, <2, 0, 0>, 1.2
                     // pigment {Red}
                     // scale 2
                    }

    #declare Twisting = on
         #declare DistBase = 0.3
         #declare ARot = on        // Automates the UpFactor, RotZ ... Spindle stays manual

    #declare TrNumber = 12     // number of ribs
    #declare TrXStep = 1      // sidely step
    #declare TrYStep = 3    // up step
    #declare TrZStep = -2
    #declare TrScale = .2       // 0 is no scale, pos is smaller, neg bigger

    #declare UpFactor = 0    // y-rotate * degrees (also negative possible)
       #declare PowUp = off    // with PowUp NO neg. UpFactor - if off, linear UpFactor used

    #declare RotZAmount = 0    //  z-rotate * degrees (also negative)

    #declare SpindleAmount = 0.1//0    // x-rotate * degrees (also negative)
       #declare PowSpindle = off  // with PowSpindle NO neg. S.Amount - if off, linear S.Amount used



   // STATEMENTS FOR ANEMONE ----------------------------------------------------------

    #declare ANumber = 60     // Number of worms to use for anemone
    #declare AScaleFactor = 0   // 0 no shrink, pos. is shrink, neg. is grow
    #declare MajorRad = 2    // Radius of the major turn
    #declare RadFactor = 0    // 0= circles even, pos smaller, neg. bigger
    #declare Turns = 360   // 360 is one major turn, can be less or more
    #declare XTrans = off  // offset along x-axis, how smaller factor the bigger the translate
         #declare XTransFactor = 2  // extra translate <LoopAmount/XTransFactor, 0, 0>
    #declare MinorRad = 3    // Radius of the minor revolutions
    #declare Revolutions = 2   // number of minor revolutions



// STATEMENTS FOR TEXTURES --------------------------------------------------------------------
    /* By using these textures take care there is no texture statement in segments
     Predef textures in biotex.inc : Tex, Texwith, Knap, Kool, PaarsRood, Pukkels,
                    WitGeel, WitBlauw, Octo, Negativ1, EyeBall, Spiderj, Kwal, HullTex(kleine scale)
                    GridTex (kleine scale), Nelson, Bg, Graniet, Slime (nog aan te passen),
                    Zebra
    */

#declare TextureOverWorm = off
#declare TextureOverThing = on  // turn TextureOverWorm off, if you want a TextureOverThing

#declare ThingTexture = texture {   TextureFarm translate <0,0,0> rotate x*90 scale 3}


// RANDOM MODE -----------------------------------------------------------------------------

/*  Computer defines Worm
       If you put "Debug_File=bioform.txt" in your povstart ini-file, you can redirect the debug-text in a textfile
    You can use "clock"  and "animation" to do a bunch of randoms (Initial_Clock = #, Final_Clock = # ;
     Initial_Frame = # Final_Frame = # in your Ini-file)
*/

#declare RANDOMmode = on
#declare zx = seed (clock*10000-5000)
#declare zz = rand (zx)
             //various clocks

   #if (RANDOMmode = on)
   #declare MSeed = (clock*(zz*6)*500)*5//(-zz*3*(clock*3*1000))//2.25*(zz+(1.33*((-33*clock+1) * 10) * 4)+0.1)
   #declare ArmFactor = 2//3   // ArmFactor : number of arms for fan, ... (rand*10*ArmFactor)

   camera {            // camera statement repeated here for easy navigating
        location  <0.0, 0.0, -30.0>
        direction 1.8*z
        right     1*x
        look_at   <0.0, 0.0,  0.0>
   }

   // parameters we want to controll in randommode

   #declare BranchOn = off        // Watch out, it's a real CHOKER
       #declare WormAsBranch = on
   #declare BaseOn = off
       #declare WormAsBase = off
       #declare BranchedBase = off//off
   #declare TopOn = on
       #declare WormAsTop = off
       #declare BranchedTop = off
   #declare TopHartOn = on

   #declare FAN = off//on
   #declare WHEEL = off
   #declare SHELL = on
   #declare TRILOBYT = on //on
       #declare Twisting = on
   #declare ANEMONE = off
       #declare XTrans = on
                                                                              #end


// SEE CREATED THING---------------------------------------------------------------------------

/* Thing plus his mirror => Fan + Fan scale <1,-1,1>, Wheel + Wheel scale <1,1,-1>.
      Doing this you can make a Hull of your Fan, Wheel, ...
   Here you can also postscale, postrotate or posttranslate your Thing
      and call the SAME Thing back again but slightly displaced.

*/










#include "bioform.inc"
object {Thing
translate <0,0,0>
scale 0.8


       }


/***END FORM *******************************************************************************/

