
//  a sea
 plane { y, -10.0
   texture {
    pigment {color rgb <0.39, 0.41, 0.43>}
    finish {
       ambient 0.15
       brilliance 5
       diffuse 0.6
       metallic
       specular 0.80
       roughness 1/100
       reflection 0.65
      }
    normal {
       waves 0.05
       frequency 5000.0
       scale 3000.0
      }
   }
   hollow
}


sky_sphere {
  pigment {
   gradient y
     color_map { [0 color rgb <.65, .7, .8>]
                 [1 color rgb <.2, .2, 1>]
     }
  }
  pigment {                        // high stratus clouds
    wrinkles
      turbulence .5
      octaves 6
      lambda 5  // 3 to 6
      omega .3  // .2 to .6
    color_map {
      [0 color rgbt <1, 1, 1, 1>]
      [.5 color rgbt <.98, .99, .99, .8>]
      [1 color rgbt <1, 1, 1, 1>]
    }
    scale <.8, .1, .8>
  }
}


// cloud layer 1

plane {y, 900
  texture {
    pigment { bozo
               turbulence .4
               omega .7
               color_map {
                 [0 color rgbt <.5, .5, .5, 1>]
                 [.5 color rgbt <.5, .5, .5, .6>]
                 [1 color rgbt <.5, .5, .5, .2>]
               }
    }
    finish {ambient 1 diffuse .5}
    scale 3000
    translate <-500, 900, -10000>
   }
   rotate y*45
   hollow
}


// cloud layer 2

plane {-y, -1200
  texture {
    pigment { bozo
               turbulence .4
               omega .7
               color_map {
                 [0 color rgbt <1, .8, .8, 1>]
                 [.5 color rgbt <1, .8, .8, .6>]
                 [1 color rgbt <1, .9, .9, .2>]
               }
    }
    finish {ambient 1 diffuse .3}
    scale 3000
    translate <1500, 900, -2000>
   }
   rotate y*45
   hollow
}



// foglayer 1

fog {
distance 2000                  //density of the fog
color rgbt <.5, .55, .65, .5>   // transparency of .5 means the fog never gets above 50% opacity
fog_type 2                     // fog_type 2 = groundfog
fog_offset 10                // fogstart along the y-axis
fog_alt 2                   //fading along x-axis, the greater the value the slower it fades
}



// foglayer 2

fog {
distance 2000
color rgbt <.6, .65, .75, .5>
fog_type 2
fog_offset 15
fog_alt 4
turbulence .2
turb_depth .2
}


// foglayer 3 : for a bright horizon

fog {
distance 2000
color rgbt <.65, .7, .8, .5>
fog_type 2
fog_offset 25
fog_alt 1
turbulence .1
turb_depth .2
}



/*  ----Test background gif etc  -------------------------------------------------
 plane { <0,0,1>,70
   pigment{
    image_map{ gif "bg22.gif"  //gif "lightng.gif"
    }
     translate <-.5,-.5,0>
     scale 40                  // scale <120,120,1>
  }
  hollow
}

*/
/*----Test Heightfield -----------------------------------------------------

height_field { gif "gforge.ghf"
   pigment { color White}
   finish { phong .5}
	// smooth
	scale <100,7.5,100> translate <-50,-10,-50>
	// water_level .3
}
*/

// Cone ------- effects ????? ------------
/*
cone { <0,0,0>, 50.0, <0,0,100>, .5   open    // END1, RADIUS1, END2, RADIUS2
 /* texture {// Slime  scale 10
    pigment {color rgb <0.39, 0.41, 0.43>}
    finish {
       ambient 0.15
       brilliance 5
       diffuse 0.6
       metallic
       specular 0.80
       roughness 1/100
       reflection 0.65
      }
    normal {
       waves 0.05
       frequency 5000.0
       scale 2000.0
      }

   } */
                   texture {
                      pigment {
                             image_map{ gif "bg22.gif"
                            map_type 0     // 0 = planar, 2 = cylindrical
                            interpolate 4   // normalized distribution
                            }
    rotate <-90,90,0>  scale <6,6,10>
    translate <-0.5, -0.5, 0> // center image
  }
   normal {
  bump_map{
        gif "bg22.gif"
      map_type 0     // planar
      interpolate 4   // normalized distribution
      bump_size 1.0
    }
    rotate <-90,90,0>  scale <6,6,10>
     translate <-0.5, -0.5, 0> // center image
  }
  finish {phong .5}
  scale 5
  }
 // translate <0,0,10>
}
*/
