// randsky version 2 - needs randtex.inc or texturefarm.inc (at moment).

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"


#include "stones2.inc"

#include "woods.inc"

#include "stars.inc"

#include "fractal2.inc"



#declare eye =
      texture {
         pigment {
            image_map {
               gif
               "eye.gif"
               interpolate Bi
            }
            translate <-0.5, -0.5, 0>
         }
         finish {
            ambient 0.3
            diffuse 0.45
            specular 0.9
            roughness 0.001
            phong 1.0
            phong_size 70
            reflection 0.25
         }
         translate <0,0,0>
         rotate <17.25,0,0>
         rotate <0,20,0>
         scale 4
      }


#declare flame = texture {
        pigment {
        gradient y
        color_map {
                        [0 color Clear]
                        [0.2 color Yellow]
                        [0.3 color Yellow]
                        [0.55 color Red filter 0.3]
                        [0.65 color Red filter 1]
                        [0.75 color Clear]
                        [1 color Clear]
                            }
                  scale <1,5,5>
                  omega 0.98
                  turbulence 0.275
                  scale <1,1/5,1/5>
                  scale <0.3,1,1>
                }
        finish {Luminous}
        translate <0,-1/2-1/8,0.05>
        scale 40
        }

#declare flamea = texture {
        pigment {
        gradient y
        color_map {
                        [0 color Clear]
                        [0.2 color Yellow filter 0.5]
                        [0.3 color Yellow filter 0.4]
                        [0.55 color Red filter 0.3]
                        [0.65 color Red filter 1]
                        [0.75 color Clear]
                        [1 color Clear]
                            }
                  scale <1,5,5>
                  omega 0.75
                  turbulence 0.275
                  scale <1,1/5,1/5>
                  scale <0.3,1,1>
                }
        finish {Luminous}
        translate <0,-1/2-1/8,0.05>
        scale 40
        }


#declare fire = texture {flame scale 0.75}
#declare fire2 = texture {flamea scale 0.75}

#declare purple_flame = texture {
        pigment {
        gradient y
        color_map {
                        [0 color Clear]
                        [0.2 color Magenta]
                        [0.3 color Magenta]
                        [0.55 color Green filter 0.3]
                        [0.65 color Green filter 1]
                        [0.75 color Clear]
                        [1 color Clear]
                            }
                  scale <1,5,5>
                  omega 1.02
                  turbulence 0.45
                  scale <1,1/5,1/5>
                  scale <0.3,1,1>
                }
        finish {Luminous}
        translate <0,-1/2-1/8,0.05>
        scale 40
        }

#declare psyc_flame = texture {
        pigment {
        gradient y
        color_map {
                        [0 color Clear]
                        [0.2 color Scarlet]
                        [0.3 color Blue]
                        [0.55 color Green filter 0.3]
                        [0.65 color Yellow filter 1]
                        [0.75 color Clear]
                        [1 color Clear]
                            }
                  scale <1,5,5>
                  omega 1.02
                  turbulence 0.75
                  scale <1,1/5,1/5>
                  scale <0.3,1,1>
                }
        finish {Luminous}
        translate <0,-1/2-1/8,0.05>
        scale 40
        }


#declare checs = texture {
                 pigment {
                 checker
                 color Silver
                 color Black
                 }

                 finish {
                 ambient 0.7
                 diffuse 0.05
                 phong 1
                 phong_size 1000
                 specular 0.77
                 roughness 0.0003
                 metallic
                 brilliance 12
                 reflection 0.32
                 }
                 scale 10
                 }


//=====================The=End=======================





//new texture maps
// by Darren Fisher
// first off some metal bozos

#declare metal_bozo1 =
texture {
bozo
turbulence 0.5*4.8
texture_map {
[0.0 Polished_Chrome]
[0.2 Polished_Green]
[0.3 Polished_Blue  ]
[0.4 Brass_Valley   ]
[0.5 Chaos5 scale 0.8]
[0.6 Polished_Red   ]
[0.82 Copper_Texture]
[1.001 Spun_Brass scale 1.5]
}
translate <0,0,0>
scale <3,1.2,1.2>
rotate <90,0,0>
translate <0,0,0>
scale 0.25
rotate <0,-120,0>
translate <0,0,0>
scale 4
translate <0,0,0>
scale 0.8
}


#declare metal_bozo2 = texture {
bozo
turbulence 1.78
texture_map {
[0.0  Polished_BozoFunk2 scale 2]
[0.2  Polished_Chrome]
[0.42 Stone21 finish {Metal} scale 2]
[0.43 Chaos5 scale 0.6]
[0.5  Silver_Texture]
[0.9  Polished_Green]
[1.03 Stone1 finish {Mirror} scale 4]
}
translate <0,0,0>
translate <0,0,0>
scale <4,1.8,1.8>
scale 0.4
scale 2.8
scale 0.72
}



#declare psyc_wood =
        texture {
        pigment {
        wood
        turbulence 0.6
        color_map  {
        [0.0 color Blue   filter 0.9            ]
        [0.6 color Yellow filter 0.2            ]
        [0.5 color Black  filter 0.9            ]
        [0.7 color Red    filter 0.8            ]
        [0.9 color Green  filter 0.8            ]
        [1.001 color Orange                     ]
        }
        }
        finish {
        ambient 0.6
        diffuse 0.1
        brilliance 34
        }
        }


#declare  firehose = texture {flame scale 0.05}

// Lightning Texture by Andy Wardley
#declare Flash = color  NeonBlue
#declare MBlue = color  Navy
#declare Bolt =  color red 0.6 green 0.6 blue 0.8

#declare Lightning_Sky = pigment {
	marble
        lambda 1.78
        omega  0.5
        turbulence 2.05
	color_map {
                [0.65, 0.85     color Clear     color MBlue]
		[0.85, 0.92	color MBlue	color Flash]
		[0.92, 0.99	color Flash	color Bolt]
                [0.99, 1.001    color Bolt        color White]
	}
}


#declare lightning = texture {Lightning_Sky }


#declare Stone40 =
texture {Grnt28    scale <2,1,2> rotate <40,0,0> rotate <0,80,0> rotate <0,0,20> }
texture {firehose  scale <1,3,1> rotate <40,0,0> rotate <0,0,30> }
texture {psyc_wood scale <1,1,2> rotate <0,0,50> }
texture {lightning scale <2,4,2>}
texture {Crack1    scale <0.5,1.5,0.5> rotate <0,0,50> rotate <23,45,90>       }




#declare Chaos =
    // Underlying surface is very subtly mottled with bozo
 texture
  {pigment
    {bozo
     turbulence 0.25
     color_map{
     [0.0 color Gold]
     [0.3 color Orange]
     [0.75 color Pink]
     [1.0 color Black]
      }
     scale 0.4
    }
   finish{
   ambient 0.3
   diffuse 0.6
   phong 1
   brilliance 8
   reflection 0.25
   }
  }

    // Second layer texture has some filter values, yet a fair amount of color
    // Viening is kept quite thin in color map and by the largish scale.
 texture
  {pigment
    {granite
     color_map
      {[0,   0.9 color DustyRose filter 1 color Green filter 0.5]
       [0.9, 1   color Silver     color DarkSlateGray]
      }
     scale 2       // Twice as large as unit shape
    }
        // I know this seem contradictory, but it seems to work!
   finish
    {specular 1   roughness 0.0001
     phong 0.25     phong_size 100
     brilliance 4
    }
    scale 8
  }

#declare Chaos2 =
    // Underlying surface is very subtly mottled with bozo
 texture
  {pigment
    {gradient x+y
     turbulence 0.25
     color_map{
     [0.0 color Gold]
     [0.6 color Silver]
     [0.8 color Copper]
     [1.0 color Red]
      }
     translate <0,0,0>
     rotate <90,180,45>
     scale 0.6
     translate <0,0,0>
    }
   finish{
   ambient 0.4
   diffuse 0.41
   phong 1
   phong_size 800
   reflection 0.34
   brilliance 12
   }
  }

 texture
  {pigment
    {bozo
     color_map{
     [0.0 color Orange filter 1.0]
     [0.3 color Blue filter 0.5]
     [0.6 color Orange]
     [0.7 color Red filter 0.25]
     [0.8 color DustyRose filter 1.0]
     [0.9 color Red]
     [1.0 color Green filter 0.75]
      }
     scale 2       // Twice as large as unit shape
    }
        // I know this seem contradictory, but it seems to work!
   finish
    {specular 1   roughness 0.0001
     phong 0.25     phong_size 75
     brilliance 4
    }
    scale <8,2,4>
  }

//*****************************************************************************
//                           SKY PIGMENTS
//*****************************************************************************


// Trippy swirly colours.
#declare Acid_Trip =
texture {
 pigment
  {bozo
   turbulence 3.0
   color_map
    {[0.0, 0.5  color red 0.196 green 0.8   blue 0.496
		color red 0.6   green 0.4   blue 0.4]
     [0.5, 0.6  color red 0.0   green 0.95  blue 0.9
		color red 0.0   green 0.5   blue 0.4]
     [0.6, 1.01 color red 0.0   green 0.8   blue 0.9
		color red 0.0   green 0.6   blue 0.5]
    }
  }
  finish {
  ambient 0.3
  diffuse 0.1
  brilliance 20
  reflection 0.101
  metallic
  }
  }



#declare Acid_Trip2 =
 pigment
  {bozo
   turbulence 3.0
   color_map
    {[0.0, 0.5  color red 0.196 green 0.8   blue 0.196
		color red 0.6   green 0.8   blue 0.1]
     [0.5, 0.6  color red 1.0   green 0.95  blue 0.1
		color red 1.0   green 0.5   blue 0.0]
     [0.6, 1.01 color red 1.0   green 1.0   blue 1.0
		color red 1.0   green 0.0   blue 0.5]
    }
  }

#declare Acid_Trip2a =
 pigment
  {bozo
   turbulence 3.0
   color_map
    {[0.0, 0.5  color red 0.196 green 0.8   blue 0.196 filter 0.8
                color red 0.6   green 0.8   blue 0.1   filter 0.3]
     [0.5, 0.6  color red 1.0   green 0.95  blue 0.1
                color red 1.0   green 0.5   blue 0.0    filter 0.9]
     [0.6, 1.01 color red 1.0   green 1.0   blue 1.0
		color red 1.0   green 0.0   blue 0.5]
    }
  }

#declare Acid_Trip3 =
 pigment
  {bozo
   turbulence 3.0
   color_map
    {[0.0, 0.5  color red 0.647 green 0.164 blue 0.164
		color red 0.623 green 0.623 blue 0.372]
     [0.5, 0.6  color red 0.309 green 0.309 blue 0.184
		color red 0.309 green 0.309 blue 0.184]
     [0.6, 1.01 color red 1.0   green 1.0   blue 1.0
		color red 0.647 green 0.164 blue 0.164]
    }
  }


#declare Acid_Trip4 =
 pigment
  {bozo
   frequency 2
   turbulence 3.0
   color_map
    {[0.0 color DarkPurple]
     [0.5 color Navy]
     [0.5 color Magenta]
     [0.6 color Green]
     [0.6 color Yellow]
     [1.01 color DeepPurple]
    }
  }

#declare Acid_Trip5 =
 pigment
  {bozo
   turbulence 3.0
   color_map
    {[0.0 color GreenYellow]
     [0.5 color Violet]
     [0.5 color NeonBlue]
     [0.6 color NeonPink]
     [0.6 color IndianRed]
     [1.01 color LightSteelBlue]
    }
  }

#declare Acid_Trip6 =
 pigment
  {bozo
   turbulence 3.0
   color_map
    {[0.0 color SeaGreen]
     [0.5 color Khaki]
     [0.5 color Firebrick]
     [0.6 color NeonPink]
     [0.6 color Black]
     [1.01 color Orchid]
    }
  }

#declare Acid_Trip8 =
texture {
pigment
  {
   bozo
   lambda 0.3
   omega  0.3
   frequency 2
   turbulence 3.0
   color_map
    {[0.0 color Red]
     [0.5 color Yellow]
     [0.5 color Blue]
     [0.6 color Orange]
     [0.6 color Silver]
     [1.01 color Cyan]

    }

    }

    finish {
    ambient 0.3
    diffuse 0.1
    brilliance 50
    metallic
    reflection 0.375
    }
    scale <145,35,177>
  }

#declare Acid_Trip9 =
texture {
pigment
  {bozo
   lambda 0.21
   omega  0.9
   frequency 8
   turbulence 3.0
   color_map
    {[0.0 color DarkPurple]
     [0.5 color Yellow]
     [0.5 color White]
     [0.6 color Grey]
     [0.6 color DustyRose]
     [1.01 color Scarlet]
    }
    }
    finish {
    ambient 0.3
    diffuse 0.1
    brilliance 50
    metallic
    reflection 0.9
    }
    scale <14.5,3.5,777>
  }

#declare Acid_Trip11 =
texture {
pigment
  {bozo
   lambda 0.01
   omega  0.32
   frequency 20
   turbulence 3.3
   color_map
    {[0.0 color Red]
     [0.5 color Yellow]
     [0.5 color Blue]
     [1.01 color Flesh]
    }
    }
    finish {
    ambient 0.3
    diffuse 0.1
    brilliance 50
    metallic
    reflection 0.375
    }
    scale <145,3.5,1.77>
  }




#declare Chaos3 =

 texture
  {pigment

    {
     gradient x+z

     turbulence 3.05

     color_map{

     [0.0 color Gold]
     [0.25 color Gold]
     [0.6 color Silver]
     [0.6 color Silver]
     [0.8 color Copper]
     [0.8 color Copper]
     [1.0 color Red]
     [1.0 color Red]
      }
     translate <0,0,0>
     scale 0.6
    }
   finish{
   ambient 0.4
   diffuse 0.345
   phong 0.8
   phong_size 1023
   brilliance 50
   reflection 0.3

   }
  }

 texture
  {pigment
    {gradient x+y

     color_map{
     [0.0 color Orange filter 1.0]
     [0.0 color Orange filter 1.0]
     [0.3 color Blue filter 0.5]
     [0.3 color Blue filter 1.3]
     [0.6 color Orange]
     [0.6 color Orange filter 1.2]
     [0.7 color Red filter 0.25]
     [0.7 color Red]
     [0.8 color DustyRose filter 1.0]
     [0.8 color DustyRose]
     [0.9 color Red]
     [1.0 color Green filter 0.75]
     [1.0 color Green]
      }
      translate <0,0,0>
      rotate <90,0,0>
     scale 4
    }

   finish
    {specular 1
    roughness 0.0001
     phong 0.25
     phong_size 75
     brilliance 6
    }
    scale <12,8,2>
  }

#declare chaos3 = texture {Chaos3}

#declare Chaos4 =

 texture
  {
  pigment
  {
     radial
     frequency 4.5
     lambda 0.82
     turbulence 3.05

     color_map{

     [0.0 color Green]
     [0.25 color Gold]
     [0.6 color Blue]
     [0.8 color Copper]
     [0.8 color Magenta]
     [1.0 color Red]
     [1.0 color Orange]
      }
     translate <0,0,0>
     scale 0.6
    }
   finish{
   ambient 0.8
   diffuse 0.15
   phong 0.8
   phong_size 1023
   brilliance 50
   reflection 0.1

   }
  }

 texture
  {pigment
    {
     bozo

     color_map{
     [0.0 color Orange filter 1.0]
     [0.0 color Clear]
     [0.3 color Clear]
     [0.3 color Blue filter 1.3]
     [0.6 color Orange]
     [0.6 color Orange filter 1.2]
     [0.7 color Red filter 0.25]
     [0.7 color Red]
     [1.0 color Green filter 0.75]
     [1.0 color Green]
      }
      translate <0,0,0>
      rotate <90,0,0>
     scale 4
    }

   finish
    {
     phong 0.25
     phong_size 75
     brilliance 6
    }
    scale <4,8,4>
  }



#declare chaos4b = texture {
                   pigment {
                   radial
                   frequency 3.3
                   lambda    0.8
                   turbulence 1.2
                   color_map {
                   [0.02 color Cyan]
                   [0.2  color Yellow]
                   [0.5  color Green ]
                   [0.8  color Red   ]
                   [1.0  color Magenta]
                   }
                   }
                   finish {
                   ambient 0.67
                   diffuse 0.02
                   brilliance 8
                   phong 0.3
                   phong_size 3456
                   reflection 0.1
                   }
                   scale <2,1.2,1.2>
                   }

#declare chaos4c = texture {
                   pigment {
                   leopard
                   frequency 2
                   turbulence 0.4
                   color_map {
                   [0.0 color Red]
                   [0.4 color Green]
                   [0.8 color Blue ]
                   [1.001 color Cyan]
                   }
                   }
                   finish {
                   ambient 0.8
                   diffuse 0.05
                   brilliance 12
                   phong 0.7
                   phong_size 1923
                   reflection 0.1
                   }
                   scale <3,1,1>
                   }




#declare Chaos5b =

 texture
  {
  pigment
  {
     crackle

     turbulence 3.05

     color_map{
     [0.0 color Blue]
     [0.5 color Red]
     [1.0 color Green]

      }
     translate <0,0,0>
     scale 0.6
    }
   finish{
   ambient 0.4
   diffuse 0.345
   phong 0.8
   phong_size 1023
   brilliance 50
   reflection 0.1

   }
  }

 texture
  {pigment
    {
     crackle

     color_map{
     [0.0 color Magenta filter 1.0]
     [0.25 color Orange filter 0.5]
     [0.50 color Magenta]
     [0.75 color Orange]
     [1.0 color White filter 0.75]
      }
      translate <0,0,0>
      rotate <90,90,2>
     scale <2,6,2>
    }

   finish
    {specular 1
     roughness 0.0001
     phong 0.25
     phong_size 75
     brilliance 6
    }
    scale <12,8,2>
  }



#declare Chaos5 =

 texture
  {
  pigment
  {
     bozo

     turbulence 3.05

     color_map{
     [0.0 color Blue]
     [0.5 color Red]
     [1.0 color Green]

      }
     translate <0,0,0>
     scale 0.6
    }
   finish{
   ambient 0.4
   diffuse 0.345
   phong 0.8
   phong_size 1023
   brilliance 50
   reflection 0.1

   }
  }

 texture
  {pigment
    {
     agate

     color_map{
     [0.0 color Magenta filter 1.0]
     [0.25 color Orange filter 0.5]
     [0.50 color Magenta]
     [0.75 color Orange]
     [1.0 color White filter 0.75]
      }
      translate <0,0,0>
      rotate <90,90,2>
     scale <2,6,2>
    }

   finish
    {specular 1
     roughness 0.0001
     phong 0.25
     phong_size 75
     brilliance 6
    }
    scale <12,8,2>
  }


#declare Chaos5a =

 texture
  {
  pigment
  {
     bozo

     turbulence 3.05

     color_map{
     [0.0 color Blue]
     [0.5 color Red]
     [1.0 color Green]

      }
     translate <0,0,0>
     scale 0.6
    }
   finish{
   ambient 0.7
   diffuse 0.1
   phong 0.8
   phong_size 1023
   brilliance 50
   reflection 0.1

   }
  }

 texture
  {pigment
    {
     marble
     frequency 2.2
     turbulence 0.45

     color_map{

     [0.0 color Magenta filter 1.20]
     [0.1 color Clear   filter 1.25]
     [0.25 color Orange filter 1.5]
     [0.50 color Magenta filter 1.5]
     [0.75 color Orange  filter 1.4]
     [0.80 color Clear ]
     [0.95 color Grey filter 1.98]
     [1.0 color White filter 1.75]
      }
      translate <0,0,0>
      rotate <90,90,2>
     scale <2,6,2>
    }

   finish
    {
    ambient 0.3
    diffuse 0.05
    specular 0.3
     roughness 0.0001
     phong 0.80
     phong_size 1000
     brilliance 12
    }
    scale <12,8,2>
  }


#declare Spun_chaos5a = texture { Chaos5a
    normal { waves 0.35 frequency 2 scale 0.01 }
}

#declare Chaos6 =

 texture
  {
  pigment
  {
     mandel 1024
     frequency 8.4
     translate <1.5,0.0,0.0>

     rotate <30,0,0>
     scale 64
     color_map{

     [0.0 color Blue]
     [0.2 color Yellow ]
     [0.1 color Grey]
     [0.25 color Orange ]
     [0.5 color Red     ]
     [0.75 color Black]
     [1.0 color Green   ]

      }

    }
   finish{
   ambient 0.4
   diffuse 0.345
   phong 0.8
   phong_size 1023
   brilliance 50
   reflection 0.8

   }
   scale 2
  }

#declare Chaos6a =

 texture
  {
  pigment
  {
     mandel 1024
     frequency 12.4
     translate <1.5,0.0,0.0>

     rotate <30,0,0>
     scale 128
     color_map{
     [0.0 color Blue]
     [0.3 color Orange]
     [0.5 color Yellow]
     [0.7 color Cyan]
     [0.9 color Red]
     [1.001 color Magenta]


      }

    }
   finish{
   ambient 0.3
   diffuse 0.1
   phong 0.8
   phong_size 1023
   brilliance 50
   reflection 0.8

   }
   scale 2
  }

#declare Chaos6b =

 texture
  {
  pigment
  {
     mandel 2000
     frequency 12
     turbulence 0.105
     translate <1.5,0.0,0.0>

     rotate <30,0,0>
     scale 56
     color_map{
     [0.0 color Blue]
     [0.1 color Navy]
     [0.2 color Coral]
     [0.3 color Orange]
     [0.4 color White]
     [0.5 color Yellow]
     [0.6 color LimeGreen]
     [0.7 color Cyan]
     [0.9 color Red]
     [1.001 color Magenta]


      }

    }
   finish{
   ambient 0.3
   diffuse 0.1
   phong 0.8
   phong_size 1023
   brilliance 50
  // reflection 0.8

   }
   scale 2
  }


#declare Chaos7 =

 texture
  {
  pigment
  {
     mandel 1024
     frequency 512
     translate <1.5,0.0,0.0>

     rotate <30,0,0>
     scale 122
     color_map{

     [0.0 color Silver]
     [0.1 color Gold]
     [0.25 color Copper]
     [0.5 color Scarlet]
     [0.75 color SpicyPink]
     [1.0 color DarkWood]

      }

    }
   finish{
   ambient 0.4
   diffuse 0.345
   phong 0.8
   phong_size 1023
   brilliance 50
   reflection 1.0

   }
   scale 4.5
  }

#declare Chaos8 =

 texture
  {
  pigment
  {
     mandel 4096
     frequency 1222
     translate <1.5,0.0,0.0>

     rotate <30,0,0>
     scale 232
     color_map{

     [0.0 color Blue]
     [0.1 color Yellow]
     [0.2 color Red]
     [0.3 color DustyRose]
     [0.4 color MediumVioletRed]
     [0.7 color Black]
     [0.8 color Sienna]
     [0.9 color YellowGreen]
     [0.91 color Violet]
     [0.92 color OldGold]
     [0.95 color DarkPurple]
     [0.99 color NeonBlue]
     [1.0 color Green]

      }

    }
   finish{
   ambient 0.4
   diffuse 0.345
   phong 0.8
   phong_size 1023
   brilliance 50
   reflection 0.8

   }
   scale 2
  }

#declare chaos8a =

 texture
  {
  pigment
  {
     mandel 1000
     frequency 3.2
     translate <1.5,0.0,0.0>
     rotate <30,0,0>
     scale 67
     color_map{
     [0.0 color Yellow]
     [0.2 color Blue  ]
     [0.4 color Green ]
     [0.5 color Orange]
     [0.6 color Cyan  ]
     [0.8 color Red   ]
     [1.001 color DeepPurple]

      }

    }
   finish{
   ambient 0.4
   diffuse 0.345
   phong 0.8
   phong_size 1023
   brilliance 50
   reflection 0.8

   }
   scale 2
  }




#declare sexy_height =
    pigment {
        image_map { gif "blot.gif" interpolate 2 }
    rotate x*90                  // rotate the image to the x/z plane
    translate <-0.5, 0, -0.5>    // center the whole shebang
}

#declare sexy_picture = texture {
                        sexy_height
                        finish {
                        Metal
                        }
                        scale 4

                         }






// now some crazy textures for the new creatures

#declare crazy1 = texture {
marble
turbulence 1.3
texture_map {
[0.0  Chaos5 scale 0.8]
[0.1  metal_bozo2 scale 6]
[0.4  Stone21 scale 3]
[0.62 Grnt28 scale 5]
[0.76 Chaos2 scale 2.4]
[0.85 Jade finish {Metal} scale 1.4]
[1.001 Spun_Brass scale 0.8]
}
translate <0,0,0>
scale <5,2,2>
scale 0.28
scale 2.9
scale 0.8
}


#declare crazy2 = texture {
bozo
turbulence 0.6
texture_map {
[0.0 Chaos2 scale 0.8]
[0.5 T_Stone33 scale 2.5]
[1.01 Chaos5 scale 0.8]
}

translate <0,0,0>
scale <6,2,2>
rotate <90,0,0>
translate <0,0,0>
rotate <0,-34,0>
scale 0.255
translate <0,0,0>
scale 4.5
scale 0.8
}


#declare crazy3 = texture {
onion
turbulence 0.8
texture_map {
[0.0 Copper_Texture]
[0.2 Grnt28 finish {Metal} scale 2]
[0.3 Grnt12 finish {Metal} scale 2.5]
[0.5 Sapphire_Agate finish {Metal} scale 0.8]
[0.62 Silver_Texture]
[0.73 Chaos8 scale 0.2]
[0.74 Chaos3 scale 0.2]
[0.7402 T_Wood32 scale 1.5]
[0.83   Gold_Texture]
[1.01   Stone4 scale 3]
}

translate <0,0,0>
scale <1.5,1,1>
scale 0.28
scale 2.78
translate <0,0,0>
rotate <0,12,0>
scale 1.125
}



#declare chaos_baby = texture {
                      marble
                      turbulence 0.7
                      texture_map {
                      [0.0 Chaos2 scale 12]
                      [0.3 Chaos7 scale 24]
                      [0.5 crazy3 scale 20]
                      [0.7 Chaos3 scale 12]
                      [1.01 metal_bozo2 scale 34.4]
                      }
                      translate <0,0,0>
                      scale <1.5,1,1>
                      scale 0.3
                      rotate <0,-5,0>
                      scale 2.5
                      }

#declare shot_up = texture {
                   onion
                   turbulence 0.42
                   texture_map {
                   [0.0  metal_bozo1 scale 1.01]
                   [0.25 metal_bozo2 scale 0.8]
                   [0.26 Stone21 scale 2]
                   [0.33 chaos_baby scale 0.4]
                   [0.48 crazy3 scale 0.8]
                   [0.5  Chaos5 scale 0.8]
                   [0.52 Brown_Agate scale 3]
                   [0.61 Polished_Chrome]
                   [0.63 Polished_Red]
                   [0.705 Silver_Texture]
                   [1.01  Candy_Cane scale 2]
                   }
                   translate <0,0,0>
                   rotate <0,-5,0>

                   scale <1.5,1,1>
                   scale 0.45
                   scale 4
                   }


#declare spotted_shot_up = texture {
                   spotted
                   turbulence 0.5
                   texture_map {
                   [0.0  metal_bozo1  scale 0.8]
                   [0.25 metal_bozo2  scale 0.8]
                   [0.26 Stone21 scale 2]
                   [0.33 chaos_baby scale 0.8]
                   [0.48 crazy3 scale 0.8]
                   [0.5  Chaos5 scale 0.8]
                   [0.52 Brown_Agate scale  0.8]
                   [0.61 Polished_Chrome]
                   [0.63 Polished_Red]
                   [0.705 Silver_Texture]
                   [1.01  Candy_Cane scale  0.8]
                   }
                   translate <0,0,0>
                   rotate <0,-5,0>


                   scale 4
                   }



#declare nice_stone1 = texture {
                       marble
                       turbulence 0.9
                       texture_map {
                       [0.0  Stone21 translate <0,0,0> rotate <90,0,0> rotate <0,-37,0> finish {Metal} scale 2]
                       [0.3  Grnt28 scale 4]
                       [0.32 Polished_Chrome]
                       [0.33 Stone5  scale 2]
                       [0.5  Stone13 scale 2]
                       [0.8  Grnt15a scale 2]
                       [1.01 Jade scale 2 finish {Metal}]
                       }
                       translate <0,0,0>

                       scale <1.5,1,1>
                       rotate <0,-5,0>
                       scale 0.3
                       scale 2.5
                       }

 #declare nice_stone2 = texture {
                        agate
                        turbulence 0.3
                        texture_map {
                        [0.0  T_Stone25 scale 4]
                        [0.5  T_Stone28 scale 2]
                        [0.6  Gold_Texture]
                        [0.63 T_Stone29 scale 0.8]
                        [0.8  Sapphire_Agate scale 2]
                        [1.01 White_Marble scale 2]
                        }
                        scale <1.5,1,1>
                        translate <0,0,0>
                        rotate <0,-6,0>
                        scale 0.3
                        scale 2.6
                        }

#declare nice_stone3 = texture {
                        onion
                        turbulence 0.3
                        texture_map {
                        [0.0 nice_stone2 scale 1.4]
                        [0.375 crazy2 scale 0.8]
                        [0.5 nice_stone1 scale 1.4]
                        [0.6 Jade scale 1.4]
                        [0.7 Grnt9 scale 1.4]
                        [1.01 crazy1 scale 10]
                        }
                        scale <1.5,1,1>
                        translate <0,0,0>
                        rotate <0,-6,0>
                        scale 0.3
                        scale 2.6
                        }


 #declare totally_twisted = texture {
                            marble
                            turbulence 2
                            texture_map {
                            [0.0  Candy_Cane scale 2]
                            [0.07 nice_stone1 scale 4]
                            [0.1  Polished_Chrome]
                            [0.25 Chaos5 scale 0.8]
                            [0.33 Chaos2 scale 0.8]
                            [0.45 crazy1 scale 3.25]
                            [0.56 crazy2 scale 3.25]
                            [0.67 flame scale 0.1]
                            [0.72 Brass_Valley scale 1.8]
                            [0.80 Silver_Texture]
                            [0.90 Copper_Texture]
                            [1.01 Gold_Texture]
                            }
                            scale <3,1.4,1.4>
                            translate <0,0,0>
                            rotate <0,-17.5,0>
                            scale 0.32
                            scale 2.5
                            }

                       #declare twisted_eyes = texture {
                                               radial
                                               turbulence 0.375
                                               frequency 2
                                               texture_map {
                                               [0.0 eye scale 1.5]
                                               [0.3 Stone40 scale 1.2]
                                               [0.5 eye scale 0.8]
                                               [0.7 flame scale 0.1]
                                               [0.9 eye scale 2]
                                               [1.01 Spun_Brass scale 4]
                                               }
                                               scale 2
                                               translate <0,0,0>
                                               rotate <0,-5,0>
                                               scale 0.3
                                               scale 3.5
                                               }








#declare polished_chrome_oil = texture {
Polished_Chrome
finish {
Shiny
            ambient 0.4
            diffuse 0.2
            irid {0.5 thickness 2 turbulence 1}                                               }
}



#declare metal_oil_blend = texture {
                           agate
                           octaves 2
                           lambda 8
                           turbulence 0.5
                           texture_map {
                           [ 0.0 polished_chrome_oil scale 2]
                           [ 0.3 nice_stone1  scale 2]
                           [ 0.5 Polished_Red finish {Shiny diffuse 0.2 irid {0.5 thickness 2 turbulence 1}}]
                           [ 0.8 Copper_Texture]
                           [ 1.01 polished_chrome_oil scale 2]
                           }
                           translate <0,0,0>
                           scale <1.5,1,1>
                           rotate <0,-5,0>
                           scale 0.3
                           scale 2.5
                           }




#include "skies.inc"

#declare Sky_Top = 3600

 // The distance from ground to the top of the sky

// A few different color_maps for the clouds, all of these are ok.

#declare Colors1 = color_map
   {
   [0.0 0.1 color rgb <2/3, 2/3, 1> color rgb <2/3, 2/3, 1>]
   [1.0 color White]
   }

#declare Colors2 = color_map  // Realistic
   {
   [0.0 0.1 color SkyBlue color SkyBlue]
   [1.0 color White]
   }

#declare Colors3 = color_map  // Very realistic!
   {
   [0.0 0.1 color SkyBlue color SkyBlue]
   [0.70 color rgb <4/5, 4/5, 5/6>]
   [1.0 color White]
   }

#declare Storm = color_map  // looks quite heavy with SkyColor in the lower layer!
   {
   [0.0 0.1 color Clear color Clear]
   [0.70 color rgbf <4/5, 4/5, 5/6, 1/2>]
   [1.0 color White]
   }

#declare CloudSky = texture  // this is the cloud texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      octaves 3   // doesn't have much effect
      lambda 11    // bigger values are worth trying
      color_map { Colors3 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6   // please notice
   }

#declare CloudSky1 = texture  // this is the cloud texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      octaves 3   // doesn't have much effect
      lambda 11    // bigger values are worth trying
      color_map { Colors1 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6   // please notice
   }

   #declare CloudSky2 = texture  // this is the cloud texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      octaves 3   // doesn't have much effect
      lambda 11    // bigger values are worth trying
      color_map { Colors2 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6   // please notice
   }
#declare oops_aah = texture {
                    wood

                    texture_map {
                    [0.0 flame scale 0.1]
                    [0.2 nice_stone2 scale 2]
                    [0.3 Jade scale 2]
                    [0.5 Stone40 scale 2 finish {ambient 0.6 diffuse 0.4 reflection 0.9}]
                    [0.6 totally_twisted scale 2]
                    [0.7 metal_bozo2 scale 2]
                    [0.9 Stone21 scale 2]
                    [1.01 Chaos2 scale 0.8]
                    }
                    scale 1/6
                    translate <0,0,0>
                    rotate x*-90
                    scale 0.8
                    scale 2
                    scale 0.4
                    scale 2.5
                    scale 2.2
                    }





#declare TexSeed = 6*(clock*5000-2350)/50

#declare P1 = seed(1005+TexSeed)
#declare Q1 = seed(715+TexSeed)
#declare S1 = seed(4+TexSeed)

#declare PatternSeed =  rand(P1)
#declare TP = 13

#if (PatternSeed < 1/TP)
	#declare PatternType1 = pigment {bumps}
#else
#if (PatternSeed < 2/TP)
	#declare PatternType1 = pigment {wrinkles}
#else
#if (PatternSeed < 3/TP)
	#declare PatternType1 = pigment {spiral2 rand(S1)*10}
#else
#if (PatternSeed < 4/TP)
	#declare PatternType1 = pigment {crackle}
#else
#if (PatternSeed < 5/TP)
	#declare PatternType1 = pigment {ripples}
#else
#if (PatternSeed < 6/TP)
	#declare PatternType1 = pigment {gradient x}
#else
#if (PatternSeed < 7/TP)
	#declare PatternType1 = pigment {wood}
#else
#if (PatternSeed < 8/TP)
	#declare PatternType1 = pigment {wrinkles}
#else
#if (PatternSeed < 9/TP)
	#declare PatternType1 = pigment {quilted control0 -rand(Q1) control1 rand(Q1)}
#else
#if (PatternSeed < 10/TP)
	#declare PatternType1 = pigment {marble}
#else
#if (PatternSeed < 11/TP)
	#declare PatternType1 = pigment {agate}
#else
#if (PatternSeed < 12/TP)
	#declare PatternType1 = pigment {gradient y}
#else
	#declare PatternType1 = pigment {gradient z}
#end
#end
#end
#end
#end
#end
#end
#end
#end
#end
#end
#end





#declare gray_sky =

      texture {
         pigment {
            PatternType1
            turbulence 0.8
            color_map {
               [0.00, 0.10 color Gray40 color Gray30]
               [0.10, 0.11 color Gray30 color Wheat]
               [0.11, 0.14 color Wheat color Gray30]
               [0.14, 0.30 color Gray30 color Black]
               [0.30, 0.32 color Black color White ]
               [0.32, 0.33 color White color Black ]
               [0.33, 1.01 color Black color Gray40]
            }
         }
         finish {
            ambient 0.8
            diffuse 0.0
         }
         scale <1.5, 1, 1>
         scale 0.32
         rotate <0, -5, 0>
         scale 2.5
      }

   #declare blue_sky = texture {
pigment {
   bozo
   octaves 3
   lambda 24
   turbulence 0.3
            color_map {
               [0.00, 0.10 color Scarlet color Orange]
               [0.10, 0.11 color Orange color NeonBlue]
               [0.11, 0.14 color NeonBlue color Orange]
               [0.14, 0.30 color Orange color Black]
               [0.30, 0.32 color Black color White ]
               [0.32, 0.33 color White color Black ]
               [0.33, 1.01 color Black color Scarlet]
            }}
            scale 1/6
            }

            #declare red_sky =

      texture {
         pigment {
            onion
            turbulence 0.8
            color_map {
               [0.00, 0.10 color Red color Scarlet]
               [0.10, 0.11 color Scarlet color Orange]
               [0.11, 0.14 color Orange color Scarlet]
               [0.14, 0.30 color Scarlet color Black]
               [0.30, 0.32 color Black color White ]
               [0.32, 0.33 color White color Black ]
               [0.33, 1.01 color Black color Red]
            }
         }
         finish {
            ambient 0.8
            diffuse 0.0
         }
         scale <1.5, 1, 1>
         scale 0.32
         rotate <0, -5, 0>
         scale 2.5
      }









#declare cloud_map = texture {
bozo
turbulence 1.10
texture_map {
[0.0 Bright_Blue_Sky]
[0.01 Stone40]
[0.02 flame scale 0.10]
[0.22 CloudSky2]
[0.3  CloudSky]
[0.5  CloudSky1]
[0.51 Chaos5 scale 0.1]
[0.7  Starfield3 scale 2]
[1.001 CloudSky1]
}
translate <0,0,0>
scale 1/6

scale <2.5,1.6,1.6>
rotate <0,-12,0>
scale 0.32
scale 2.5
translate <0,0,0>
}


#declare psyc_sky = texture {
                    radial
                    frequency 4
                    rotate -x * 90

                    turbulence 1.5
                    texture_map {
                    [0.0  Blue_Sky scale <4,2,3>]
                    [0.1  Chaos5 scale 0.8]
                    [0.22 red_sky scale 2]
                    [0.34 blue_sky scale 2]
                    [0.5  Starfield3 scale 1.4]
                    [0.7  P_Cloud1 scale 1.1]
                    [0.72 P_Cloud3 scale 1.1]
                    [0.74 P_Cloud4 scale 1.2]
                    [0.76 P_Cloud2 scale 1.2]
                    [0.8  Chaos3 scale 4]
                    [0.81 cloud_map scale 2]
                    [1.01 cloud_map scale 2]
                    }
                    scale 1/6
                    scale <12,7.5,8> * 1.25 * 1.33
                    }


#declare semi_mirror = finish {ambient 0.3 diffuse 0.01 reflection 0.4 specular 1.0 roughness 0.00001}

#declare skymap2 = texture_map {
[0.0 CloudSky finish {semi_mirror}]
[0.0 CloudSky finish {semi_mirror}]
[0.25 fractal_sky1 scale 0.1]
[0.25 fractal_sky1 scale 0.1]
[0.33 psyc_sky scale 2]
[0.5 sexy_picture scale 0.1]
[0.5 sexy_picture scale 0.1]
[0.6 psyc_sky scale 2]
[0.75 Chaos5 scale 0.8]
[0.75 Chaos5 scale 0.8]
[1.0 Silver_Texture finish {semi_mirror}]
[1.0 Silver_Texture finish {semi_mirror}]
}

#declare radial_sky =
                    texture {

   radial
   frequency 4.2
   phase 1.5
   turbulence 0.1
   rotate x*90
   translate <0,0,0>
   texture_map {skymap2}
   translate <0,0,0>
   scale 0.25

                    }


// now to put some random texture creations in the mix (yes it is a bit like mixing!!)
#declare muddle = seed (125*clock+1)
#declare muds   = rand(muddle) + 0.2


#declare SingleSeed= clock * 12

#declare ImgNo = clock
#declare Time = 2


#debug concat("  random no = ",str(muds,4,2),"\n")
#debug concat("  Singleseed = ",str(SingleSeed,4,2),"\n")
#debug concat("  ImgNo =      ",str (ImgNo,4,2),"\n")
#debug concat("  Time  =      ",str (ImgNo,4,2),"\n")


#include "TextureFarm.inc"
#declare pl1 = texture {TextureFarm translate <0,0,0> scale 4}

#declare Time = clock * 4 * clock

#include "TextureFarm.inc"
#declare pl2 = texture {TextureFarm}

#declare Time = (clock * 160 ) - 256

#include "TextureFarm.inc"
#declare pl3 = texture {TextureFarm}

#declare Time = (32*(clock*4)/(180*pi))+3

#include "TextureFarm.inc"
#declare pl4 = texture {TextureFarm}

#declare r1 = 12
#declare r2 = 16

#declare E = 0.1
#declare F = 0.25
#declare Count = ( clock/10) + 0.5

#declare r3 = ((r2-r1) * 8) / (2/Count)*2*(muds+1)

#debug concat("  r3 = ",str(r3,4,2),"\n")

#declare X=r3*sin(E*Count)*cos(F*Count)
#declare Y=r3*sin(E*Count)*sin(F*Count)
#declare Z=r3*cos(F*Count)


#debug concat("  X = ",str(X,4,2),"\n")

#debug concat("  Y = ",str(Y,4,2),"\n")


#debug concat("  Z = ",str(Z,4,2),"\n")

#declare Time = 1.2*(2*(X*Y)-(Z*E)+clock)



#include "TextureFarm.inc"

#declare pl5 = texture {TextureFarm}


#declare skymap3 = texture {
crackle
turbulence 0.1
frequency 4


texture_map {
[0.00 pl1 scale 4]
[0.32 pl3 scale 4]
[0.56 pl4 scale 4]
[0.75 pl5 scale 4]
[0.81 pl2 scale 4]
//[0.91 red_sky scale 1.2]
//[1.02 blue_sky scale 1.2]
}
translate <0,0,0>
 scale 1/6
 scale <12,7.5,8> * 1.25 * 1.33

}




#declare wood_sky = texture {

                   mandel 1220
                frequency 16

                    scale 1/102

                //   translate <1.5,0,0>
                   rotate x * 32
                  scale 14.5
                  phase 1*(clock/3)



                    texture_map {
                    [0.0 psyc_sky scale 4]
                    [0.5 skymap3 scale 4]
                    [1.0 CloudSky scale 4]
                    }
                    translate <0,0,0>
                    //scale (1/6)
                    }




// now create some random texture blocks

#declare TexSeed = (40*pi*clock)/100

#include "RandTex.inc"

#declare blocka = texture {RandTex scale 8}

#declare TexSeed = (33*(pi*clock*360)/180*(clock/33))/4

#include "RandTex.inc"

#declare blockb = texture {RandTex scale 8}

// now create a large texture map!!!!

#declare final_map = texture_map {
                     [0.000 blocka]
                     [0.125 blockb]
                     [0.250 psyc_sky]
                     [0.333 skymap3]
                     [0.500 CloudSky]
                     [0.666 Jade scale 2]
                     [0.75  Polished_Chrome]
                     [1.02  Chaos5 scale 0.8]
                     }




#declare myrandom = seed (10*clock)

#declare eee = int(rand(myrandom)*10)


#declare TP = 13

#declare cookie = (eee)


#debug concat("  cookie = ",str(cookie,4,2),"\n")

#switch (cookie)
        #case (0)
        #declare skytext = texture {
                           bozo
                           turbulence 0.33*(eee/TP)
                           texture_map {final_map}
                           translate <0,0,0>
                           scale 2
                           }
#break

#case(1)
#declare skytext = texture {
                   spotted
                   turbulence 0.33*(eee/TP)
                   texture_map {final_map}
                   translate <0,0,0>
                   scale 1.3
                   }
                   #break

#case(2)
#declare skytext = texture {
                   marble
                   turbulence 0.33*(eee/TP/clock)
                   texture_map {final_map}
                   translate <0,0,0>
                   scale 1.3
                   }
                   #break
#case(3)
#declare skytext = texture {
                   spiral2 1*(clock/10)
                   turbulence 0.2*(clock/TP)+1
                   texture_map {final_map}
                   translate <0,0,0>
                   scale 1.3
                   }
                   #break
#case(4)
#declare skytext = texture {
                   gradient x+y
                   turbulence 0.33
                   texture_map {final_map}
                   translate <0,0,0>
                   scale 4
                   }
                   #break
                   
#case(5)
#declare skytext = texture {
                   ripples
                   turbulence 0.25
                   texture_map {final_map}
                   translate <0,0,0>
                   scale 4
                   }
                   #break

#case(6)
#declare skytext = texture {
                   bumps
                   turbulence 0.5
                   texture_map {
                   [0.0 Acid_Trip6 scale 40]
                   [0.33 Chaos6 scale 8]
                   [0.56 final_map]
                   [0.75 sexy_height]
                   [1.02 Acid_Trip2 scale 40]
                   }
                   translate <0,0,0>
                   scale 2.4
                   }
                   #break

 #case(7)
 #declare skytext = texture {
                    quilted control0 -rand(Q1) control1 rand(Q1)
                    turbulence 0.125
                    texture_map {
                    [0.000 Apocalypse scale 20]
                    [0.125 Blood_Sky scale 4]
                    [0.255 sexy_height]
                    [0.333 Acid_Trip11 scale 32]
                //    [0.802 final_map]
                    [1.002 Acid_Trip3 scale 20]
                    }
                    translate <0,0,0>
                    scale 0.826
                    }                                                       
#else
#declare skytext = texture {
                   wood
                   turbulence 0.33
                  // frequency 1
                  // scale 1/102
                  // rotate x * 32
                  // scale 10
                   phase 1*(clock/15)
                   texture_map {final_map}
                   translate <0,0,0>
                   }
                   #end



// now to put it there

sphere  // the sky globe -- please notice the scalings!
   {
   <0, 0, 0>, 1
   texture { skytext scale <2,3,2>*0.8 }
   scale <Sky_Top*10, (Sky_Top*3.89), Sky_Top*10> * 1
   hollow
   no_shadow
   }





