
// some of the incs use random generators
// so needs to be declared early.

#declare R1 = seed (8348)

#include "colors.inc"
#include "textures.inc"

#include "flowers.inc"
#include "insects.inc"

// declares to save on trial renders
#declare Bushes_Only = 0
#declare Some_Plants = 1
#declare Most_Plants = 2
#declare All_Plants = 3

//#declare simple = Some_Plants
#declare simple = All_Plants

camera
{
  location  <30.0 , 25.0 ,-55.0>
  look_at   <20.0 , 10.0 , 0.01>
}

light_source { <100, 300, -200> color White}
light_source { <100, 200, -200> color Gold}

sphere {<0, 0, 0>, 1000
texture {
            pigment {
            gradient y
            color_map {
            [0.0 color SkyBlue]
            [1.0 color LightBlue]}
            translate <0, 0.5, 0>
            scale 500
            }
}

texture {
        pigment {
                bozo
                turbulence 0.8
                color_map {
                [0.0 color Gray80]
                [0.4 color Clear]
                [0.4 color Clear]
                [1.0 color Clear]}
                }
        scale <350, 100, 350>
        }
}

// --------------------------------------
// textures

#declare Stone =
texture {
        pigment {color rgb <0.9, 0.75, 0.65>}
        finish {Dull}
        normal {granite scale 0.5 }
}

#declare Brick =
texture {
    pigment {granite
              color_map {
                        [0.0 color IndianRed]
                        [0.5 color rgb <0.8, 0, 0>]
                        [1.0 color Khaki] }
             scale 2
             }
     finish {crand 0.2}
     normal {bozo turbulence 1 scale 0.5}
}

#declare Soil =
texture {
         pigment {bozo
                      turbulence 0.5
                      color_map {
                      [0.0 color Black]
                      [0.3 color Black]
                      [0.3 color DarkBrown]
                      [0.6 color DarkBrown]
                        [0.6 color Gray50]
                        [0.8 color Gray80]
                        [0.8 color VeryDarkBrown]
                        [1.0 color VeryDarkBrown]}
             }
             finish {crand 0.8}
}

#declare Moss =
texture {
        pigment {bozo
                turbulence 0.3
                color_map {
                [0.0 color DarkGreen]
                [0.2 color DarkGreen]
                [0.2 color Clear]
                [0.5 color Clear]
                [0.5 color rgb <0.5, 0.8, 0.3>]
                [0.7 color rgb <0.5, 0.8, 0.3>]
                [0.7 color Clear]
                [1.0 color Clear] }
                scale 0.01
                }
}

#declare Bark =
texture {
         pigment {marble
                  turbulence 0.6
                  color_map {
                        [0.0 color rgb <0.547, 0.264, 0.164>]
                        [0.2 color Gray50]
                        [0.5 color DarkOliveGreen]
                        [0.6 color Gray50]
                        [1.0 color DarkBrown]}
                  }
         normal {marble
                 turbulence 0.6
                 scale <1, 1, 5>
                 }
}


// -------------------------------------
// bits

#declare Rim =
union {
difference {
           box {<-1, 0, -1.5>, <1, 1, 0> }
           box {<-0.7, 0.9, -1.4>, <0.7, 1.1, -0.1> pigment {color Gray40} }
} // end diff
box {<-0.5, 0.8, -1.3>, <0.5, 1, -0.2>}
cylinder {<0, 0, -1.5>, <0, 1, -1.5>, 0.5
         clipped_by {plane {z, -1.5} }
}
rotate <-10, 0, 0>
texture {Stone}
} // end union

// ---------------------------------------
// back garden

height_field {
             gif
             "garden.gif"
             water_level 0.05
             translate <-0.515, 0, -0.48>
             scale <140, 10, 100>
             translate <0, 6, 0>
             texture {Soil}
}

object {Bush
        translate <20, 12, 15>
}

object {Bush
       scale <1, 1.2, 1>
       rotate <0, 90, 0>
       translate <40, 11, 7>
}

object {Bush
        scale <1.4, 1.4, 1>
        rotate <0, -70, 0>
        translate <-15, 13, -6>
}

object {Fern
       rotate <-20, 0, 0>
        translate <49, 13, -4>
}
object {Fern
        rotate <-15, -30, 0>
        translate <51, 15, -3.5>
}
object {Fern
        rotate <0, 40, 0>
        translate <6, 12, -25>
}
object {Fern
        rotate <0, -40, 0>
        translate <6, 12, -28>
}
object {Fern
        translate <4, 14, -25>
}
object {Fern
        translate <4, 14, -28>
}

#if (simple >= Some_Plants)
#declare Count = 0
#while (Count < 14)

object {Daisy_Head
        rotate <0, rand(R1)*360, 0>
        rotate <rand(R1)* -40, 0,  0>
        translate <28+Count, 15+rand(R1)*4, 3+rand(R1)*3>
}
object {Daisy_Head
        rotate <0, rand(R1)*360, 0>
        rotate <rand(R1)* -60, 0, 0>
        translate <29+rand(R1)*Count, 14+rand(R1)*2, 2+rand(R1)*2>
}
#declare Count=Count + 1.6
#end


#declare Count = 0
#while (Count < 25)
object {Delphinium
       rotate <rand(R1)*5, rand(R1)*360, 0>
       translate <-5+Count, 20+rand(R1)*8, 6+rand(R1)*5>
       pigment {color rgb <0.3+rand(R1)*0.2, 0.4+rand(R1)*0.2, 1>}
}

#declare Count=Count + rand(R1)*3
#end

#end // simple excluder

// ----------------------
// broken tree
height_field {
             gif
             "soil.gif"
             water_level 0.04
             translate <-0.5, 0, -0.5>
             scale 7
             texture {
                     pigment {wood
                              color_map{
                              [0.0 color rgb <0.9, 0.85, 0.8>]
                              [0.3 color rgb <0.9, 0.85, 0.8>]
                              [0.3 color DarkBrown]
                              [0.4 color DarkBrown]
                              [0.5 color rgb <0.9, 0.85, 0.8>]
                              [0.8 color rgb <0.9, 0.85, 0.8>]
                              [0.8 color DarkBrown]
                              [1.0 color rgb <0.9, 0.85, 0.8>]}
                              rotate <90, 0, 0>
                              }
             }
             translate <60, 32, 40>
}

blob {
   threshold 0.6
   component 1.000000, 1.974322, <0.008439, 0.059072, 0.000000>
   component 1.000000, 0.559781, <0.329641, 3.593091, 0.000000>
   component 1.000000, 0.439128, <0.725211, 3.724947, 0.000000>
   component 1.000000, 0.465766, <0.988924, 3.856804, 0.000000>
   component 1.000000, 0.439129, <1.120781, 3.988660, 0.000000>
   component 1.000000, 1.799326, <-0.362869, 1.274262, 0.000000>
   component 1.000000, 1.595621, <-0.597475, 2.616528, 0.000000>
   component 1.000000, 1.369419, <-0.906514, 3.807358, 0.000000>
   component 1.000000, 0.885092, <-1.710014, 4.841607, 0.000000>
   component 1.000000, 0.527925, <-2.616528, 5.047633, 0.000000>
   component 1.000000, 0.626456, <-3.523042, 5.130043, 0.000000>
   component 1.000000, 0.527925, <-4.635581, 4.965222, 0.000000>
   component 1.000000, 0.467381, <-5.377275, 4.965222, 0.000000>
   component 1.000000, 0.467381, <-6.118968, 5.418479, 0.000000>
   component 1.000000, 0.312928, <-6.658227, 5.789326, 0.008439>
   component 1.000000, 0.260791, <-6.819455, 6.077762, 0.000000>
   component 1.000000, 0.597279, <-4.367748, 5.059995, 0.000000>
   component 1.000000, 0.572554, <-3.148075, 5.092959, 0.000000>
   component 1.000000, 0.628736, <-2.291008, 5.059995, 0.000000>
   component 1.000000, 0.542283, <-5.752242, 5.257780, 0.000000>
   component 1.000000, 0.422340, <-5.125923, 4.994066, 0.000000>
   component 1.000000, 0.337250, <-5.358650, 4.506815, -0.649789>
   component 1.000000, 0.305807, <-5.594936, 4.455309, -0.717300>
   component 1.000000, 0.079490, <-6.253164, 4.300789, -0.936709>
   component 1.000000, 0.142197, <-6.103516, 4.300789, -0.886076>
   component 1.000000, 0.238472, <-5.932489, 4.352296, -0.818565>
   component 1.000000, 0.483524, <-4.852321, 4.661335, -0.329114>
   component 1.000000, 0.382878, <-5.071730, 4.609828, -0.531646>
   component 1.000000, 0.270736, <-5.746835, 4.558321, -0.767932>
   component 1.000000, 0.559781, <-0.131857, 3.494198, 0.000000>
   component 1.000000, 0.382878, <-6.388186, 5.742970, -0.008439>
   component 1.000000, 1.168890, <-1.302083, 4.301820, 0.000000>
   component 1.000000, 0.597279, <-3.906250, 5.125923, 0.000000>
   component 1.000000, 0.528781, <-2.917326, 5.092959, 0.000000>

scale 4
translate <65, 15, 40>
texture {Bark
        rotate <0, 0, 110>
        }
}


// bird house
union {
difference {
           box {<-1, 0, 0>, <1, 3, 1>}
           box {<-2, 0, -1>, <2, 2, 2>
                rotate <0, 0, -45>
                translate <1, 2, 0>}
           box {<-2, 0, -1>, <2, 2, 2>
                rotate <0, 0, 45>
                translate <-1, 2, 0>}
           cylinder {<0, 1.5, -1>, <0, 1.5, 1>, 0.5}

pigment {Cherry_Wood
         scale 0.25
         }
}
cylinder {<0, 0.5, 0>, <0, 0.5, -0.5>, 0.2 pigment {color DarkBrown} }
box {<-1.5, 0, -0.2>, <0, 0.3, 1>
     rotate <0, 0, 45>
     translate <0, 3, 0>
     pigment {Pine_Wood}
}
box {<1.5, 0, -0.2>, <0, 0.3, 1>
     rotate <0, 0, -45>
     translate <0, 3, 0>
     pigment {Pine_Wood}
}

rotate <0, -30, 20>
translate <63.8, 30, 35.5>
} // end bird house union

// bird feeder
union {
torus {1, 0.2
       rotate <0, 0, 90>
       scale <1, 1.5, 1>
       clipped_by{plane {y, 0 inverse } }
}

difference {
           cylinder {<0, 0, 0>, <0, -4, 0>, 1}
#declare Count = 0
#while (Count < 18)
box {<-1.2, -3.5, -0.07>, <1.2, -0.5, 0.07>
     rotate <0, Count * 10, 0>
}
#declare Count=Count + 1
#end
} // end diff
cylinder {<-1.3, -3.8, 0>,<1.3, -3.8, 0>, 0.1}
cylinder {<0, -2, 0>,<0, -3.6, 0>, 0.9
         pigment {color Khaki}
         normal {bozo}
}
texture {Aluminum}
rotate <0, -20, 0>
translate <43, 32, 37>

} // end union

// --------------------------------------
// Big planter
union {
#declare Count = 0
#while (Count < 36)

object {Rim
       translate <0, 0, -10>
       rotate <0, Count * 10, 0>
}

#declare Count = Count + 1
#end

sphere {<0, 0, 0>, 11
        clipped_by {plane { y, 0} }
}
torus { 8, 1.5
       translate <0, -8, 0> }

height_field {
             gif
             "soil.gif"
             water_level 0.04
             translate <-0.5, 0, -0.5>
             scale <25, 5, 25>
             texture {Soil}
}

#if (simple = All_Plants)
#include "lily.inc"
object {Lily_Cluster
       rotate <0, -7, 0>
       translate <5, 0, -5>
}
object {Lily_Cluster
       rotate <0, 5, 0>
       translate <-2, 1, -8>
}
#end // excluder

texture {Stone}
translate <11, 9, -11>
} // end planter union

// wall
box {<0, 0, 0.2>, <50, 8.6, 2>
    pigment {color Gray50}
    finish {crand 0.1}
}
box {<0, 0, 6.7>, <50, 8.6, 8>
    pigment {color Gray50}
    finish {crand 0.1}
}

box {<0, 0, 0>, <-1.9, 8.6, -50>
    pigment {color Gray50}
    finish {crand 0.1}
}


#declare Count = 0
#while (Count < 15)
union {
box {<0, 0, 0>, <4, 2, 2>
       translate <Count * 4.2, rand(R1) / 10, rand(R1) / 10>
}
box {<0, 0, 0>, <4, 2, 2>
       translate <-2 + Count * 4.2, 2.2 + rand(R1) / 10, rand(R1) / 10>
}
box {<0, 0, 0>, <4, 2, 2>
       translate <Count * 4.2, 4.4 + rand(R1) / 10, rand(R1) / 10>
}
box {<0, 0, 0>, <4, 2, 2>
       translate <-2 + Count * 4.2, 6.6 + rand(R1) / 10, rand(R1) / 10>
}
box {<0, 0, 0>, <4, 2, 2>
       translate <-2 + Count * 4.2, 6.6 + rand(R1) / 10, 6 + rand(R1) / 10>
}

box {<0, 0, 0>, <-2, 2, -4>
   translate <rand(R1) / 10, rand(R1) / 10, -Count * 4.2>
}
box {<0, 0, 0>, <-2, 2, -4>
    translate <rand(R1) / 10, 2.2 + rand(R1) / 10, -2 - Count * 4.2>
}
box {<0, 0, 0>, <-2, 2, -4>
    translate <rand(R1) / 10, 4.4 + rand(R1) / 10, -Count * 4.2>
}
box {<0, 0, 0>, <-2, 2, -4>
    translate <rand(R1) / 10, 6.6 + rand(R1) / 10, 2 - Count * 4.2>
}

// texture applied as a whole to give variation in each individual brick
texture {Brick}

}

#declare Count = Count + 1
#end

// forget me nots in wall
#if (simple >= Most_Plants)

#declare Count = 0

#while (Count < 50)
object {ForgetMeNot
        rotate <rand (R1)*30, rand(R1)*360, rand(R1)*30>
        translate <15 + rand(R1)*18, rand(R1)*1.5 + 10.5, 2+rand(R1)*2>
}
#declare Count = Count + 1
#end

object {Wort
        translate <40, 10, 1>
}
#end // simple switch

// --------------------------------------------------
// paving
box { <-2, -0.05, 2>, <60, -1, -30> pigment {color Gray40} }

#declare Xcount = 0
#while (Xcount < 50)

#declare Zcount = 0
#while (Zcount > -30)
box {<0, 0, 0>, <8, -0.5, -8>
     translate <Xcount, rand(R1)/10, Zcount>
     pigment {color rgb <0.7, 0.75, 0.6>}
     normal {ripples 0.2
            turbulence 0.8+rand(R1)*0.1
            scale 1.9+rand(R1)*0.2
            rotate <0, rand(R1)*360, 0>
            }
}
#declare Zcount = Zcount - 8.1 - rand(R1)/5
#end

#declare Xcount = Xcount + 8.1 - rand(R1)/5
#end

#declare Mossy =
union {
sphere {<0, 0, 0>, 0.5}
sphere {<0.75, 0, 0>, 0.6}
sphere {<1.2, 0, 0>, 0.3}
sphere {<1.8, 0, 0>, 0.4}
texture {Moss}
}

object {Mossy
        translate <13, 0, -24.3>
}
object {Mossy
        rotate <0, 90, 0>
        translate <24.3, 0, -1>
}
object {Mossy
        translate <38, 0, -16.2>
}
object {Mossy
        scale <3, 0.75, 0.5>
        translate <24, 0, -24.4>
}

// ant on patio
#declare Count = 0
#while (Count < 40)
object {Ant
       rotate <0, rand(R1)*360, 0>
       translate <rand(R1)*50, 0, rand(R1)*-20>
}
#declare Count=Count + 1
#end

object {Bee
        rotate <15, 220, 0>
        translate <40, 27, -12>
}

#declare Count = 0
#while (Count < 5)
object {Bee
        rotate <rand(R1)*20, rand(R1)*360, 0>
        translate <rand(R1)*50-10, rand(R1)*10+15, rand(R1)*30-15>
}        

#declare Count=Count + 1
#end
