//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 4 lights, 15 textures and 112 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 06/01/1998    (01.06.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

Copyright 1998 Angelo Colucci



This scene was created with Moray V3.01 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.125,0.208,0.031> }

camera {  //  Camera Camera2
  location  <26.600, -53.700, -3.300>
  direction <0.0,     0.0,  4.6651>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <2.50000,  0.0,  0.0>
  look_at   <19.800, 1.000, 1.950>
  // Focal blur settings
  focal_point  <19.800, 1.000, 1.950> // Always Lookat
  aperture     0.35
  blur_samples 200
  confidence   0.9999
  variance     0.0001
}

//    Other cameras are commented out.
/*
camera {  //  Camera Camera01
  location  <26.600, -53.700, -3.300>
  direction <0.0,     0.0,  4.6651>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <2.50000,  0.0,  0.0>
  look_at   <20.100, -1.400, 1.700>
  // Focal blur settings
  focal_point  <20.100, -1.400, 1.700> // Always Lookat
  aperture     1.0
  blur_samples 200
  confidence   0.5
  variance     0.02
}

*/

/*
camera {  //  Camera Camera02
  location  <14.300, -40.500, 20.450>
  direction <0.0,     0.0,  5.4538>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <2.92267,  0.0,  0.0>
  look_at   <15.200, -8.000, -1.900>
}

*/

//
// *******  L I G H T S *******
//

light_source { // AreaLite001
  <50.000, -25.000, 500.000>
  color  rgb<1.625, 1.625, 1.625>
  area_light <5.926, -0.098, -0.933>, <0.259, 5.907, 1.022>, 3, 3
  adaptive 1
  jitter
}


light_source {   // Light002
  <-15.900, -61.900, 4.900>
  color rgb <0.878, 0.878, 0.878>
  shadowless
  atmosphere off
}

light_source {   // Light001
  <15.600, -5.700, -87.700>
  color rgb <0.526, 0.526, 0.526>
  shadowless
  atmosphere off
}


//
// ********  TEXTURES  *******
//

#include "leafcutters.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare SingleLeaf = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.380525, 0.553669, 0.000000>, <0.019475, -0.146331, 0.000000>, <0.019475, -0.146331, 0.000000>, <0.419475, 0.553669, 0.000000>, 
      <-1.380525, 2.953669, 0.000000>, <-0.480525, 2.853669, 0.200000>, <0.519475, 2.853669, 0.200000>, <1.319475, 2.953669, 0.000000>, 
      <-1.480525, 4.053669, 0.000000>, <-0.480525, 4.053669, 0.200000>, <0.519475, 4.053669, 0.200000>, <1.519475, 4.053669, 0.000000>, 
      <-0.680525, 5.453669, 0.000000>, <0.019475, 6.453669, 0.000000>, <0.019475, 6.453669, 0.000000>, <0.719475, 5.453669, 0.000000>
    }
  }
}
#declare LeafSpray = union {
  object { // SingleLeaf1->SingleLeaf
    SingleLeaf
    scale 0.8
    rotate <-4.048632, 2.936483, 57.896187>
    translate  -0.05*y
  }
  object { // SingleLeaf2->SingleLeaf
    SingleLeaf
    scale 0.8
    rotate <-4.048635, -2.93648, -58.896179>
  }
  object { // SingleLeaf3->SingleLeaf
    SingleLeaf
    scale 0.65
    rotate <-4.819425, 9.411986, 113.56665>
    translate  -0.05*y
  }
  object { // SingleLeaf4->SingleLeaf
    SingleLeaf
    scale 0.65
    rotate <-5.133119, -10.861291, -113.511688>
    translate  -0.05*y
  }
  object { SingleLeaf }
  rotate <3.528648, 6.034832, 0.6053>
  translate  7.2*y
}
#declare LargerLeafSpray = union {
  object { LeafSpray }
  object { // LeafSpray1->LeafSpray
    LeafSpray
    scale 0.8
    rotate -60.0*z
    translate  <1.247077, 0.72, 0.0>
  }
  object { // LeafSpray2->LeafSpray
    LeafSpray
    scale 0.64
    rotate -120.0*z
    translate  <2.244738, -1.296, 0.0>
  }
  object { // LeafSpray3->LeafSpray
    LeafSpray
    scale 0.512
    rotate -180.0*z
    translate  <-0.0, -3.5136, 0.0>
  }
  rotate <-1.364293, -1.462569, 0.017415>
  translate  <-1.7, 2.5, 0.0>
}
#declare LargeLeafSpray = union {
  object { LargerLeafSpray }
  object { // LargerLeafSpray1->LargerLeafSpray
    LargerLeafSpray
    rotate -137.0*z
    translate  <1.5, -2.598076, 1.0>
  }
  object { // LargerLeafSpray2->LargerLeafSpray
    LargerLeafSpray
    rotate 86.0*z
    translate  <-0.0, -5.196152, 2.0>
  }
  object { // LargerLeafSpray3->LargerLeafSpray
    LargerLeafSpray
    rotate -51.0*z
    translate  <-3.0, -5.196152, 3.0>
  }
  translate  <-21.4, -7.5, -14.3>
}
#declare TreeLeafMass = union {
  object { LargeLeafSpray }
  object { // LargeLeafSpray1->LargeLeafSpray
    LargeLeafSpray
    rotate -15.0*z
    translate  <-12.901466, 5.83067, 4.0>
  }
  object { // LargeLeafSpray2->LargeLeafSpray
    LargeLeafSpray
    rotate -30.0*z
    translate  <2.914054, 12.868056, 8.0>
  }
  object { // LargeLeafSpray3->LargeLeafSpray
    LargeLeafSpray
    rotate -45.0*z
    translate  <-0.883824, -1.26938, 12.0>
  }
  object { // LargeLeafSpray4->LargeLeafSpray
    LargeLeafSpray
    rotate -60.0*z
    translate  <-4.415024, 12.626059, 16.0>
  }
  object { // LargeLeafSpray5->LargeLeafSpray
    LargeLeafSpray
    rotate -75.0*z
    translate  <11.113525, 4.942146, 20.0>
  }
  rotate <-26.756977, -34.609451, 127.202644>
  translate  <31.1, 132.7, 46.05>
  texture {
    Leafy1
  }
}


#declare LongLeaf1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, 
      <-0.079763, -1.323821, 3.786706>, <-0.079763, -1.323821, 3.786706>, <-0.056392, -1.333771, 3.778231>, <-0.056392, -1.333771, 3.778231>, 
      <-0.199684, -1.110918, 3.606993>, <-0.199684, -1.090533, 3.624355>, <-0.166221, -1.125975, 3.590338>, <-0.141578, -1.133950, 3.583546>, 
      <-0.265875, -0.959265, 3.452287>, <-0.265875, -0.938880, 3.469649>, <-0.212617, -0.984459, 3.430830>, <-0.187974, -0.992433, 3.424038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, 
      <-0.056392, -1.347562, 3.766485>, <-0.056392, -1.347562, 3.766485>, <-0.079763, -1.323821, 3.786706>, <-0.079763, -1.323821, 3.786706>, 
      <-0.141384, -1.168213, 3.553588>, <-0.172616, -1.150468, 3.568700>, <-0.199684, -1.140586, 3.581724>, <-0.199684, -1.110918, 3.606993>, 
      <-0.187974, -1.038403, 3.384885>, <-0.219206, -1.020659, 3.399998>, <-0.265875, -0.988933, 3.427019>, <-0.265875, -0.959265, 3.452287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, 
      <0.000000, -1.369137, 3.748109>, <0.000000, -1.369137, 3.748109>, <-0.056392, -1.347562, 3.766485>, <-0.056392, -1.347562, 3.766485>, 
      <0.000000, -1.220929, 3.505742>, <-0.063113, -1.220929, 3.505742>, <-0.090804, -1.196950, 3.529112>, <-0.141384, -1.168213, 3.553588>, 
      <0.000000, -1.110321, 3.323632>, <-0.063113, -1.110321, 3.323632>, <-0.137394, -1.067140, 3.360410>, <-0.187974, -1.038403, 3.384885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, 
      <0.056392, -1.347562, 3.766485>, <0.056392, -1.347562, 3.766485>, <0.000000, -1.369137, 3.748109>, <0.000000, -1.369137, 3.748109>, 
      <0.141384, -1.168213, 3.553588>, <0.090804, -1.196950, 3.529112>, <0.063113, -1.220929, 3.505742>, <0.000000, -1.220929, 3.505742>, 
      <0.187974, -1.038403, 3.384885>, <0.137394, -1.067140, 3.360410>, <0.063113, -1.110321, 3.323632>, <0.000000, -1.110321, 3.323632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, 
      <0.079763, -1.323821, 3.786706>, <0.079763, -1.323821, 3.786706>, <0.056392, -1.347562, 3.766485>, <0.056392, -1.347562, 3.766485>, 
      <0.199684, -1.110918, 3.606993>, <0.199684, -1.140586, 3.581724>, <0.172616, -1.150468, 3.568700>, <0.141384, -1.168213, 3.553588>, 
      <0.265875, -0.959265, 3.452287>, <0.265875, -0.988933, 3.427019>, <0.219206, -1.020659, 3.399998>, <0.187974, -1.038403, 3.384885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, 
      <0.056392, -1.333771, 3.778231>, <0.056392, -1.333771, 3.778231>, <0.079763, -1.323821, 3.786706>, <0.079763, -1.323821, 3.786706>, 
      <0.141578, -1.133950, 3.583546>, <0.166221, -1.125975, 3.590338>, <0.199684, -1.090533, 3.624355>, <0.199684, -1.110918, 3.606993>, 
      <0.187974, -0.992433, 3.424038>, <0.212617, -0.984459, 3.430830>, <0.265875, -0.938880, 3.469649>, <0.265875, -0.959265, 3.452287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, <0.000000, -1.480059, 3.930028>, 
      <0.000000, -1.349631, 3.764722>, <0.000000, -1.349631, 3.764722>, <0.056392, -1.333771, 3.778231>, <0.056392, -1.333771, 3.778231>, 
      <0.000000, -1.171941, 3.547234>, <0.060117, -1.171941, 3.547234>, <0.086251, -1.151853, 3.568298>, <0.141578, -1.133950, 3.583546>, 
      <0.000000, -1.045300, 3.379009>, <0.060117, -1.045300, 3.379009>, <0.132647, -1.010336, 3.408789>, <0.187974, -0.992433, 3.424038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.480059, 3.930028>, <0.000000, -1.349631, 3.764722>, <0.000000, -1.171941, 3.547234>, <0.000000, -1.045300, 3.379009>, 
      <0.000000, -1.480059, 3.930028>, <0.000000, -1.349631, 3.764722>, <-0.060117, -1.171941, 3.547234>, <-0.060117, -1.045300, 3.379009>, 
      <0.000000, -1.480059, 3.930028>, <-0.056392, -1.333771, 3.778231>, <-0.086251, -1.151853, 3.568298>, <-0.132647, -1.010336, 3.408789>, 
      <0.000000, -1.480059, 3.930028>, <-0.056392, -1.333771, 3.778231>, <-0.141578, -1.133950, 3.583546>, <-0.187974, -0.992433, 3.424038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.343472, -0.693111, 3.127238>, <-0.327329, -0.771043, 3.227699>, <-0.303325, -0.873461, 3.364756>, <-0.265875, -0.959265, 3.452287>, 
      <-0.343472, -0.664684, 3.146949>, <-0.327329, -0.742616, 3.247410>, <-0.303325, -0.853076, 3.382118>, <-0.265875, -0.938880, 3.469649>, 
      <-0.274671, -0.728245, 3.102878>, <-0.263298, -0.802885, 3.203219>, <-0.239315, -0.903026, 3.339044>, <-0.212617, -0.984459, 3.430830>, 
      <-0.242835, -0.739365, 3.095167>, <-0.231462, -0.814005, 3.195508>, <-0.214672, -0.911000, 3.332252>, <-0.187974, -0.992433, 3.424038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.242835, -0.803468, 3.050719>, <-0.231439, -0.874068, 3.151587>, <-0.214411, -0.964744, 3.289157>, <-0.187974, -1.038403, 3.384885>, 
      <-0.283182, -0.778724, 3.067876>, <-0.271786, -0.849323, 3.168744>, <-0.245643, -0.947000, 3.304270>, <-0.219206, -1.020659, 3.399998>, 
      <-0.343472, -0.734483, 3.098552>, <-0.327329, -0.812415, 3.199013>, <-0.303325, -0.903130, 3.339488>, <-0.265875, -0.988933, 3.427019>, 
      <-0.343472, -0.693111, 3.127238>, <-0.327329, -0.771043, 3.227699>, <-0.303325, -0.873461, 3.364756>, <-0.265875, -0.959265, 3.452287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.903757, 2.981180>, <0.000000, -0.967836, 3.082613>, <0.000000, -1.048038, 3.221086>, <0.000000, -1.110321, 3.323632>, 
      <-0.081533, -0.903757, 2.981180>, <-0.081533, -0.967836, 3.082613>, <-0.063113, -1.048038, 3.221086>, <-0.063113, -1.110321, 3.323632>, 
      <-0.177492, -0.843542, 3.022933>, <-0.166097, -0.914141, 3.123800>, <-0.163830, -0.993481, 3.264681>, <-0.137394, -1.067140, 3.360410>, 
      <-0.242835, -0.803468, 3.050719>, <-0.231439, -0.874068, 3.151587>, <-0.214411, -0.964744, 3.289157>, <-0.187974, -1.038403, 3.384885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242835, -0.803468, 3.050719>, <0.231439, -0.874068, 3.151587>, <0.214411, -0.964744, 3.289157>, <0.187974, -1.038403, 3.384885>, 
      <0.177492, -0.843542, 3.022933>, <0.166097, -0.914141, 3.123800>, <0.163830, -0.993481, 3.264681>, <0.137394, -1.067140, 3.360410>, 
      <0.081533, -0.903757, 2.981180>, <0.081533, -0.967836, 3.082613>, <0.063113, -1.048038, 3.221086>, <0.063113, -1.110321, 3.323632>, 
      <0.000000, -0.903757, 2.981180>, <0.000000, -0.967836, 3.082613>, <0.000000, -1.048038, 3.221086>, <0.000000, -1.110321, 3.323632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.343472, -0.693111, 3.127238>, <0.327329, -0.771043, 3.227699>, <0.303325, -0.873461, 3.364756>, <0.265875, -0.959265, 3.452287>, 
      <0.343472, -0.734483, 3.098552>, <0.327329, -0.812415, 3.199013>, <0.303325, -0.903130, 3.339488>, <0.265875, -0.988933, 3.427019>, 
      <0.283182, -0.778724, 3.067876>, <0.271786, -0.849323, 3.168744>, <0.245643, -0.947000, 3.304270>, <0.219206, -1.020659, 3.399998>, 
      <0.242835, -0.803468, 3.050719>, <0.231439, -0.874068, 3.151587>, <0.214411, -0.964744, 3.289157>, <0.187974, -1.038403, 3.384885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242835, -0.739365, 3.095167>, <0.231462, -0.814005, 3.195508>, <0.214672, -0.911000, 3.332252>, <0.187974, -0.992433, 3.424038>, 
      <0.274671, -0.728245, 3.102878>, <0.263298, -0.802885, 3.203219>, <0.239315, -0.903026, 3.339044>, <0.212617, -0.984459, 3.430830>, 
      <0.343472, -0.664684, 3.146949>, <0.327329, -0.742616, 3.247410>, <0.303325, -0.853076, 3.382118>, <0.265875, -0.938880, 3.469649>, 
      <0.343472, -0.693111, 3.127238>, <0.327329, -0.771043, 3.227699>, <0.303325, -0.873461, 3.364756>, <0.265875, -0.959265, 3.452287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.813088, 3.044049>, <0.000000, -0.882758, 3.144532>, <0.000000, -0.971761, 3.281322>, <0.000000, -1.045300, 3.379009>, 
      <0.077663, -0.813088, 3.044049>, <0.077663, -0.882758, 3.144532>, <0.060117, -0.971761, 3.281322>, <0.060117, -1.045300, 3.379009>, 
      <0.171361, -0.764331, 3.077856>, <0.159988, -0.838971, 3.178197>, <0.159345, -0.928903, 3.317003>, <0.132647, -1.010336, 3.408789>, 
      <0.242835, -0.739365, 3.095167>, <0.231462, -0.814005, 3.195508>, <0.214672, -0.911000, 3.332252>, <0.187974, -0.992433, 3.424038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.813088, 3.044049>, <-0.077663, -0.813088, 3.044049>, <-0.171361, -0.764331, 3.077856>, <-0.242835, -0.739365, 3.095167>, 
      <0.000000, -0.882758, 3.144532>, <-0.077663, -0.882758, 3.144532>, <-0.159988, -0.838971, 3.178197>, <-0.231462, -0.814005, 3.195508>, 
      <0.000000, -0.971761, 3.281322>, <-0.060117, -0.971761, 3.281322>, <-0.159345, -0.928903, 3.317003>, <-0.214672, -0.911000, 3.332252>, 
      <0.000000, -1.045300, 3.379009>, <-0.060117, -1.045300, 3.379009>, <-0.132647, -1.010336, 3.408789>, <-0.187974, -0.992433, 3.424038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.384147, -0.388280, 2.716243>, <-0.373130, -0.472976, 2.844382>, <-0.362868, -0.599473, 3.006531>, <-0.343472, -0.693111, 3.127238>, 
      <-0.384147, -0.354254, 2.734657>, <-0.373130, -0.438950, 2.862796>, <-0.362868, -0.571046, 3.026242>, <-0.343472, -0.664684, 3.146949>, 
      <-0.307197, -0.430333, 2.693485>, <-0.299436, -0.512411, 2.820744>, <-0.288403, -0.638117, 2.981716>, <-0.274671, -0.728245, 3.102878>, 
      <-0.271591, -0.443643, 2.686282>, <-0.263830, -0.525721, 2.813541>, <-0.256568, -0.649237, 2.974005>, <-0.242835, -0.739365, 3.095167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.271591, -0.520371, 2.644759>, <-0.263867, -0.598875, 2.770843>, <-0.256542, -0.718548, 2.929391>, <-0.242835, -0.803468, 3.050719>, 
      <-0.316717, -0.490754, 2.660787>, <-0.308993, -0.569257, 2.786871>, <-0.296889, -0.693804, 2.946549>, <-0.283182, -0.778724, 3.067876>, 
      <-0.384147, -0.437800, 2.689444>, <-0.373130, -0.522496, 2.817583>, <-0.362868, -0.640845, 2.977845>, <-0.343472, -0.734483, 3.098552>, 
      <-0.384147, -0.388280, 2.716243>, <-0.373130, -0.472976, 2.844382>, <-0.362868, -0.599473, 3.006531>, <-0.343472, -0.693111, 3.127238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.640410, 2.579797>, <0.000000, -0.713342, 2.703984>, <0.000000, -0.826838, 2.859423>, <0.000000, -0.903757, 2.981180>, 
      <-0.091188, -0.640410, 2.579797>, <-0.091188, -0.713342, 2.703984>, <-0.081533, -0.826838, 2.859423>, <-0.081533, -0.903757, 2.981180>, 
      <-0.198511, -0.568336, 2.618801>, <-0.190787, -0.646840, 2.744885>, <-0.191200, -0.758621, 2.901605>, <-0.177492, -0.843542, 3.022933>, 
      <-0.271591, -0.520371, 2.644759>, <-0.263867, -0.598875, 2.770843>, <-0.256542, -0.718548, 2.929391>, <-0.242835, -0.803468, 3.050719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.271591, -0.520371, 2.644759>, <0.263867, -0.598875, 2.770843>, <0.256542, -0.718548, 2.929391>, <0.242835, -0.803468, 3.050719>, 
      <0.198511, -0.568336, 2.618801>, <0.190787, -0.646840, 2.744885>, <0.191200, -0.758621, 2.901605>, <0.177492, -0.843542, 3.022933>, 
      <0.091188, -0.640410, 2.579797>, <0.091188, -0.713342, 2.703984>, <0.081533, -0.826838, 2.859423>, <0.081533, -0.903757, 2.981180>, 
      <0.000000, -0.640410, 2.579797>, <0.000000, -0.713342, 2.703984>, <0.000000, -0.826838, 2.859423>, <0.000000, -0.903757, 2.981180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.384147, -0.388280, 2.716243>, <0.373130, -0.472976, 2.844382>, <0.362868, -0.599473, 3.006531>, <0.343472, -0.693111, 3.127238>, 
      <0.384147, -0.437800, 2.689444>, <0.373130, -0.522496, 2.817583>, <0.362868, -0.640845, 2.977845>, <0.343472, -0.734483, 3.098552>, 
      <0.316717, -0.490754, 2.660787>, <0.308993, -0.569257, 2.786871>, <0.296889, -0.693804, 2.946549>, <0.283182, -0.778724, 3.067876>, 
      <0.271591, -0.520371, 2.644759>, <0.263867, -0.598875, 2.770843>, <0.256542, -0.718548, 2.929391>, <0.242835, -0.803468, 3.050719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.271591, -0.443643, 2.686282>, <0.263830, -0.525721, 2.813541>, <0.256568, -0.649237, 2.974005>, <0.242835, -0.739365, 3.095167>, 
      <0.307197, -0.430333, 2.693485>, <0.299436, -0.512411, 2.820744>, <0.288403, -0.638117, 2.981716>, <0.274671, -0.728245, 3.102878>, 
      <0.384147, -0.354254, 2.734657>, <0.373130, -0.438950, 2.862796>, <0.362868, -0.571046, 3.026242>, <0.343472, -0.664684, 3.146949>, 
      <0.384147, -0.388280, 2.716243>, <0.373130, -0.472976, 2.844382>, <0.362868, -0.599473, 3.006531>, <0.343472, -0.693111, 3.127238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.531885, 2.638528>, <0.000000, -0.609828, 2.764393>, <0.000000, -0.728734, 2.922388>, <0.000000, -0.813088, 3.044049>, 
      <0.086860, -0.531885, 2.638528>, <0.086860, -0.609828, 2.764393>, <0.077663, -0.728734, 2.922388>, <0.077663, -0.813088, 3.044049>, 
      <0.191653, -0.473526, 2.670110>, <0.183892, -0.555604, 2.797369>, <0.185093, -0.674203, 2.956694>, <0.171361, -0.764331, 3.077856>, 
      <0.271591, -0.443643, 2.686282>, <0.263830, -0.525721, 2.813541>, <0.256568, -0.649237, 2.974005>, <0.242835, -0.739365, 3.095167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.531885, 2.638528>, <-0.086860, -0.531885, 2.638528>, <-0.191653, -0.473526, 2.670110>, <-0.271591, -0.443643, 2.686282>, 
      <0.000000, -0.609828, 2.764393>, <-0.086860, -0.609828, 2.764393>, <-0.183892, -0.555604, 2.797369>, <-0.263830, -0.525721, 2.813541>, 
      <0.000000, -0.728734, 2.922388>, <-0.077663, -0.728734, 2.922388>, <-0.185093, -0.674203, 2.956694>, <-0.256568, -0.649237, 2.974005>, 
      <0.000000, -0.813088, 3.044049>, <-0.077663, -0.813088, 3.044049>, <-0.171361, -0.764331, 3.077856>, <-0.242835, -0.739365, 3.095167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.418457, -0.116670, 2.255121>, <-0.409452, -0.185648, 2.400184>, <-0.395657, -0.299797, 2.582375>, <-0.384147, -0.388280, 2.716243>, 
      <-0.418457, -0.078557, 2.273108>, <-0.409452, -0.147535, 2.418171>, <-0.395657, -0.265771, 2.600788>, <-0.384147, -0.354254, 2.734657>, 
      <-0.334635, -0.163774, 2.232892>, <-0.328239, -0.230974, 2.377439>, <-0.315362, -0.343977, 2.559595>, <-0.307197, -0.430333, 2.693485>, 
      <-0.295849, -0.178684, 2.225856>, <-0.289454, -0.245883, 2.370403>, <-0.279756, -0.357288, 2.552392>, <-0.271591, -0.443643, 2.686282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.295849, -0.264629, 2.185297>, <-0.289411, -0.329369, 2.329193>, <-0.279792, -0.437015, 2.510881>, <-0.271591, -0.520371, 2.644759>, 
      <-0.345005, -0.231453, 2.200953>, <-0.338566, -0.296193, 2.344849>, <-0.324918, -0.407397, 2.526909>, <-0.316717, -0.490754, 2.660787>, 
      <-0.418457, -0.172139, 2.228944>, <-0.409452, -0.241117, 2.374008>, <-0.395657, -0.349317, 2.555576>, <-0.384147, -0.437800, 2.689444>, 
      <-0.418457, -0.116670, 2.255121>, <-0.409452, -0.185648, 2.400184>, <-0.395657, -0.299797, 2.582375>, <-0.384147, -0.388280, 2.716243>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.399091, 2.121843>, <0.000000, -0.459925, 2.264725>, <0.000000, -0.561769, 2.445888>, <0.000000, -0.640410, 2.579797>, 
      <-0.099333, -0.399091, 2.121843>, <-0.099333, -0.459925, 2.264725>, <-0.091188, -0.561769, 2.445888>, <-0.091188, -0.640410, 2.579797>, 
      <-0.216241, -0.318357, 2.159942>, <-0.209803, -0.383097, 2.303838>, <-0.206712, -0.484980, 2.484924>, <-0.198511, -0.568336, 2.618801>, 
      <-0.295849, -0.264629, 2.185297>, <-0.289411, -0.329369, 2.329193>, <-0.279792, -0.437015, 2.510881>, <-0.271591, -0.520371, 2.644759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.295849, -0.264629, 2.185297>, <0.289411, -0.329369, 2.329193>, <0.279792, -0.437015, 2.510881>, <0.271591, -0.520371, 2.644759>, 
      <0.216241, -0.318357, 2.159942>, <0.209803, -0.383097, 2.303838>, <0.206712, -0.484980, 2.484924>, <0.198511, -0.568336, 2.618801>, 
      <0.099333, -0.399091, 2.121843>, <0.099333, -0.459925, 2.264725>, <0.091188, -0.561769, 2.445888>, <0.091188, -0.640410, 2.579797>, 
      <0.000000, -0.399091, 2.121843>, <0.000000, -0.459925, 2.264725>, <0.000000, -0.561769, 2.445888>, <0.000000, -0.640410, 2.579797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.418457, -0.116670, 2.255121>, <0.409452, -0.185648, 2.400184>, <0.395657, -0.299797, 2.582375>, <0.384147, -0.388280, 2.716243>, 
      <0.418457, -0.172139, 2.228944>, <0.409452, -0.241117, 2.374008>, <0.395657, -0.349317, 2.555576>, <0.384147, -0.437800, 2.689444>, 
      <0.345005, -0.231453, 2.200953>, <0.338566, -0.296193, 2.344849>, <0.324918, -0.407397, 2.526909>, <0.316717, -0.490754, 2.660787>, 
      <0.295849, -0.264629, 2.185297>, <0.289411, -0.329369, 2.329193>, <0.279792, -0.437015, 2.510881>, <0.271591, -0.520371, 2.644759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.295849, -0.178684, 2.225856>, <0.289454, -0.245883, 2.370403>, <0.279756, -0.357288, 2.552392>, <0.271591, -0.443643, 2.686282>, 
      <0.334635, -0.163774, 2.232892>, <0.328239, -0.230974, 2.377439>, <0.315362, -0.343977, 2.559595>, <0.307197, -0.430333, 2.693485>, 
      <0.418457, -0.078557, 2.273108>, <0.409452, -0.147535, 2.418171>, <0.395657, -0.265771, 2.600788>, <0.384147, -0.354254, 2.734657>, 
      <0.418457, -0.116670, 2.255121>, <0.409452, -0.185648, 2.400184>, <0.395657, -0.299797, 2.582375>, <0.384147, -0.388280, 2.716243>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.277527, 2.179210>, <0.000000, -0.341881, 2.322977>, <0.000000, -0.448957, 2.504613>, <0.000000, -0.531885, 2.638528>, 
      <0.094618, -0.277527, 2.179210>, <0.094618, -0.341881, 2.322977>, <0.086860, -0.448957, 2.504613>, <0.086860, -0.531885, 2.638528>, 
      <0.208771, -0.212157, 2.210060>, <0.202376, -0.279356, 2.354607>, <0.199818, -0.387171, 2.536220>, <0.191653, -0.473526, 2.670110>, 
      <0.295849, -0.178684, 2.225856>, <0.289454, -0.245883, 2.370403>, <0.279756, -0.357288, 2.552392>, <0.271591, -0.443643, 2.686282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.277527, 2.179210>, <-0.094618, -0.277527, 2.179210>, <-0.208771, -0.212157, 2.210060>, <-0.295849, -0.178684, 2.225856>, 
      <0.000000, -0.341881, 2.322977>, <-0.094618, -0.341881, 2.322977>, <-0.202376, -0.279356, 2.354607>, <-0.289454, -0.245883, 2.370403>, 
      <0.000000, -0.448957, 2.504613>, <-0.086860, -0.448957, 2.504613>, <-0.199818, -0.387171, 2.536220>, <-0.279756, -0.357288, 2.552392>, 
      <0.000000, -0.531885, 2.638528>, <-0.086860, -0.531885, 2.638528>, <-0.191653, -0.473526, 2.670110>, <-0.271591, -0.443643, 2.686282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.449236, 0.110287, 1.667738>, <-0.437441, 0.054698, 1.848136>, <-0.429044, -0.035577, 2.084579>, <-0.418457, -0.116670, 2.255121>, 
      <-0.449236, 0.153542, 1.681006>, <-0.437441, 0.097952, 1.861404>, <-0.429044, 0.002537, 2.102566>, <-0.418457, -0.078557, 2.273108>, 
      <-0.359249, 0.056828, 1.651341>, <-0.350944, 0.004041, 1.829478>, <-0.342091, -0.085435, 2.064382>, <-0.334635, -0.163774, 2.232892>, 
      <-0.317611, 0.039907, 1.646151>, <-0.309306, -0.012880, 1.824288>, <-0.303305, -0.100345, 2.057346>, <-0.295849, -0.178684, 2.225856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.317611, -0.057632, 1.616232>, <-0.309360, -0.106531, 1.791117>, <-0.303260, -0.190108, 2.019660>, <-0.295849, -0.264629, 2.185297>, 
      <-0.370382, -0.019981, 1.627781>, <-0.362131, -0.068880, 1.802666>, <-0.352416, -0.156932, 2.035316>, <-0.345005, -0.231453, 2.200953>, 
      <-0.449236, 0.047336, 1.648428>, <-0.437441, -0.008254, 1.828827>, <-0.429044, -0.091046, 2.058402>, <-0.418457, -0.172139, 2.228944>, 
      <-0.449236, 0.110287, 1.667738>, <-0.437441, 0.054698, 1.848136>, <-0.429044, -0.035577, 2.084579>, <-0.418457, -0.116670, 2.255121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.210233, 1.569424>, <0.000000, -0.253132, 1.739232>, <0.000000, -0.330482, 1.960698>, <0.000000, -0.399091, 2.121843>, 
      <-0.106639, -0.210233, 1.569424>, <-0.106639, -0.253132, 1.739232>, <-0.099333, -0.330482, 1.960698>, <-0.099333, -0.399091, 2.121843>, 
      <-0.232148, -0.118608, 1.597529>, <-0.223896, -0.167508, 1.772414>, <-0.223653, -0.243836, 1.994305>, <-0.216241, -0.318357, 2.159942>, 
      <-0.317611, -0.057632, 1.616232>, <-0.309360, -0.106531, 1.791117>, <-0.303260, -0.190108, 2.019660>, <-0.295849, -0.264629, 2.185297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.317611, -0.057632, 1.616232>, <0.309360, -0.106531, 1.791117>, <0.303260, -0.190108, 2.019660>, <0.295849, -0.264629, 2.185297>, 
      <0.232148, -0.118608, 1.597529>, <0.223896, -0.167508, 1.772414>, <0.223653, -0.243836, 1.994305>, <0.216241, -0.318357, 2.159942>, 
      <0.106639, -0.210233, 1.569424>, <0.106639, -0.253132, 1.739232>, <0.099333, -0.330482, 1.960698>, <0.099333, -0.399091, 2.121843>, 
      <0.000000, -0.210233, 1.569424>, <0.000000, -0.253132, 1.739232>, <0.000000, -0.330482, 1.960698>, <0.000000, -0.399091, 2.121843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.449236, 0.110287, 1.667738>, <0.437441, 0.054698, 1.848136>, <0.429044, -0.035577, 2.084579>, <0.418457, -0.116670, 2.255121>, 
      <0.449236, 0.047336, 1.648428>, <0.437441, -0.008254, 1.828827>, <0.429044, -0.091046, 2.058402>, <0.418457, -0.172139, 2.228944>, 
      <0.370382, -0.019981, 1.627781>, <0.362131, -0.068880, 1.802666>, <0.352416, -0.156932, 2.035316>, <0.345005, -0.231453, 2.200953>, 
      <0.317611, -0.057632, 1.616232>, <0.309360, -0.106531, 1.791117>, <0.303260, -0.190108, 2.019660>, <0.295849, -0.264629, 2.185297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.317611, 0.039907, 1.646151>, <0.309306, -0.012880, 1.824288>, <0.303305, -0.100345, 2.057346>, <0.295849, -0.178684, 2.225856>, 
      <0.359249, 0.056828, 1.651341>, <0.350944, 0.004041, 1.829478>, <0.342091, -0.085435, 2.064382>, <0.334635, -0.163774, 2.232892>, 
      <0.449236, 0.153542, 1.681006>, <0.437441, 0.097952, 1.861404>, <0.429044, 0.002537, 2.102566>, <0.418457, -0.078557, 2.273108>, 
      <0.449236, 0.110287, 1.667738>, <0.437441, 0.054698, 1.848136>, <0.429044, -0.035577, 2.084579>, <0.418457, -0.116670, 2.255121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.072270, 1.611742>, <0.000000, -0.120607, 1.786204>, <0.000000, -0.203563, 2.013974>, <0.000000, -0.277527, 2.179210>, 
      <0.101578, -0.072270, 1.611742>, <0.101578, -0.120607, 1.786204>, <0.094618, -0.203563, 2.013974>, <0.094618, -0.277527, 2.179210>, 
      <0.224128, 0.001918, 1.634499>, <0.215823, -0.050869, 1.812636>, <0.216227, -0.133818, 2.041550>, <0.208771, -0.212157, 2.210060>, 
      <0.317611, 0.039907, 1.646151>, <0.309306, -0.012880, 1.824288>, <0.303305, -0.100345, 2.057346>, <0.295849, -0.178684, 2.225856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.072270, 1.611742>, <-0.101578, -0.072270, 1.611742>, <-0.224128, 0.001918, 1.634499>, <-0.317611, 0.039907, 1.646151>, 
      <0.000000, -0.120607, 1.786204>, <-0.101578, -0.120607, 1.786204>, <-0.215823, -0.050869, 1.812636>, <-0.309306, -0.012880, 1.824288>, 
      <0.000000, -0.203563, 2.013974>, <-0.094618, -0.203563, 2.013974>, <-0.216227, -0.133818, 2.041550>, <-0.303305, -0.100345, 2.057346>, 
      <0.000000, -0.277527, 2.179210>, <-0.094618, -0.277527, 2.179210>, <-0.208771, -0.212157, 2.210060>, <-0.295849, -0.178684, 2.225856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.494081, 0.239749, 1.098475>, <-0.482164, 0.206301, 1.270504>, <-0.460190, 0.161914, 1.500198>, <-0.449236, 0.110287, 1.667738>, 
      <-0.494081, 0.288053, 1.110424>, <-0.482164, 0.254605, 1.282454>, <-0.460190, 0.205169, 1.513466>, <-0.449236, 0.153542, 1.681006>, 
      <-0.395111, 0.180049, 1.083706>, <-0.386673, 0.148801, 1.254914>, <-0.367030, 0.106283, 1.484448>, <-0.359249, 0.056828, 1.651341>, 
      <-0.349316, 0.161153, 1.079032>, <-0.340878, 0.129905, 1.250239>, <-0.325392, 0.089362, 1.479258>, <-0.317611, 0.039907, 1.646151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.349316, 0.052226, 1.052086>, <-0.340855, 0.024023, 1.222242>, <-0.325450, -0.011179, 1.450097>, <-0.317611, -0.057632, 1.616232>, 
      <-0.407355, 0.094272, 1.062487>, <-0.398894, 0.066069, 1.232644>, <-0.378221, 0.026472, 1.461646>, <-0.370382, -0.019981, 1.627781>, 
      <-0.494081, 0.169448, 1.081084>, <-0.482164, 0.136000, 1.253114>, <-0.460190, 0.098963, 1.480889>, <-0.449236, 0.047336, 1.648428>, 
      <-0.494081, 0.239749, 1.098475>, <-0.482164, 0.206301, 1.270504>, <-0.460190, 0.161914, 1.500198>, <-0.449236, 0.110287, 1.667738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.118189, 1.009929>, <0.000000, -0.141594, 1.178416>, <0.000000, -0.168569, 1.404501>, <0.000000, -0.210233, 1.569424>, 
      <-0.117284, -0.118189, 1.009929>, <-0.117284, -0.141594, 1.178416>, <-0.106639, -0.168569, 1.404501>, <-0.106639, -0.210233, 1.569424>, 
      <-0.255321, -0.015869, 1.035241>, <-0.246861, -0.044072, 1.205397>, <-0.239986, -0.072156, 1.431394>, <-0.232148, -0.118608, 1.597529>, 
      <-0.349316, 0.052226, 1.052086>, <-0.340855, 0.024023, 1.222242>, <-0.325450, -0.011179, 1.450097>, <-0.317611, -0.057632, 1.616232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.349316, 0.052226, 1.052086>, <0.340855, 0.024023, 1.222242>, <0.325450, -0.011179, 1.450097>, <0.317611, -0.057632, 1.616232>, 
      <0.255321, -0.015869, 1.035241>, <0.246861, -0.044072, 1.205397>, <0.239986, -0.072156, 1.431394>, <0.232148, -0.118608, 1.597529>, 
      <0.117284, -0.118189, 1.009929>, <0.117284, -0.141594, 1.178416>, <0.106639, -0.168569, 1.404501>, <0.106639, -0.210233, 1.569424>, 
      <0.000000, -0.118189, 1.009929>, <0.000000, -0.141594, 1.178416>, <0.000000, -0.168569, 1.404501>, <0.000000, -0.210233, 1.569424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.494081, 0.239749, 1.098475>, <0.482164, 0.206301, 1.270504>, <0.460190, 0.161914, 1.500198>, <0.449236, 0.110287, 1.667738>, 
      <0.494081, 0.169448, 1.081084>, <0.482164, 0.136000, 1.253114>, <0.460190, 0.098963, 1.480889>, <0.449236, 0.047336, 1.648428>, 
      <0.407355, 0.094272, 1.062487>, <0.398894, 0.066069, 1.232644>, <0.378221, 0.026472, 1.461646>, <0.370382, -0.019981, 1.627781>, 
      <0.349316, 0.052226, 1.052086>, <0.340855, 0.024023, 1.222242>, <0.325450, -0.011179, 1.450097>, <0.317611, -0.057632, 1.616232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.349316, 0.161153, 1.079032>, <0.340878, 0.129905, 1.250239>, <0.325392, 0.089362, 1.479258>, <0.317611, 0.039907, 1.646151>, 
      <0.395111, 0.180049, 1.083706>, <0.386673, 0.148801, 1.254914>, <0.367030, 0.106283, 1.484448>, <0.359249, 0.056828, 1.651341>, 
      <0.494081, 0.288053, 1.110424>, <0.482164, 0.254605, 1.282454>, <0.460190, 0.205169, 1.513466>, <0.449236, 0.153542, 1.681006>, 
      <0.494081, 0.239749, 1.098475>, <0.482164, 0.206301, 1.270504>, <0.460190, 0.161914, 1.500198>, <0.449236, 0.110287, 1.667738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.035880, 1.048042>, <0.000000, 0.008144, 1.217988>, <0.000000, -0.026293, 1.445799>, <0.000000, -0.072270, 1.611742>, 
      <0.111717, 0.035880, 1.048042>, <0.111717, 0.008144, 1.217988>, <0.101578, -0.026293, 1.445799>, <0.101578, -0.072270, 1.611742>, 
      <0.246501, 0.118729, 1.068537>, <0.238063, 0.087481, 1.239745>, <0.231909, 0.051373, 1.467605>, <0.224128, 0.001918, 1.634499>, 
      <0.349316, 0.161153, 1.079032>, <0.340878, 0.129905, 1.250239>, <0.325392, 0.089362, 1.479258>, <0.317611, 0.039907, 1.646151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.035880, 1.048042>, <-0.111717, 0.035880, 1.048042>, <-0.246501, 0.118729, 1.068537>, <-0.349316, 0.161153, 1.079032>, 
      <0.000000, 0.008144, 1.217988>, <-0.111717, 0.008144, 1.217988>, <-0.238063, 0.087481, 1.239745>, <-0.340878, 0.129905, 1.250239>, 
      <0.000000, -0.026293, 1.445799>, <-0.101578, -0.026293, 1.445799>, <-0.231909, 0.051373, 1.467605>, <-0.325392, 0.089362, 1.479258>, 
      <0.000000, -0.072270, 1.611742>, <-0.101578, -0.072270, 1.611742>, <-0.224128, 0.001918, 1.634499>, <-0.317611, 0.039907, 1.646151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.537694, 0.358563, 0.390811>, <-0.524588, 0.339929, 0.605272>, <-0.508713, 0.280816, 0.887259>, <-0.494081, 0.239749, 1.098475>, 
      <-0.537694, 0.412072, 0.399135>, <-0.524588, 0.393438, 0.613596>, <-0.508713, 0.329121, 0.899209>, <-0.494081, 0.288053, 1.110424>, 
      <-0.429988, 0.292431, 0.380524>, <-0.420726, 0.276271, 0.593026>, <-0.405442, 0.218305, 0.874103>, <-0.395111, 0.180049, 1.083706>, 
      <-0.380150, 0.271499, 0.377268>, <-0.370889, 0.255339, 0.589770>, <-0.359647, 0.199409, 0.869428>, <-0.349316, 0.161153, 1.079032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.380150, 0.150836, 0.358497>, <-0.370896, 0.138101, 0.568280>, <-0.359623, 0.086584, 0.844794>, <-0.349316, 0.052226, 1.052086>, 
      <-0.443312, 0.197413, 0.365743>, <-0.434058, 0.184678, 0.575525>, <-0.417662, 0.128631, 0.855196>, <-0.407355, 0.094272, 1.062487>, 
      <-0.537694, 0.280688, 0.378696>, <-0.524588, 0.262053, 0.593158>, <-0.508713, 0.210515, 0.869869>, <-0.494081, 0.169448, 1.081084>, 
      <-0.537694, 0.358563, 0.390811>, <-0.524588, 0.339929, 0.605272>, <-0.508713, 0.280816, 0.887259>, <-0.494081, 0.239749, 1.098475>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.037942, 0.329131>, <0.000000, -0.045328, 0.534652>, <0.000000, -0.089893, 0.806232>, <0.000000, -0.118189, 1.009929>, 
      <-0.127637, -0.037942, 0.329131>, <-0.127637, -0.045328, 0.534652>, <-0.117284, -0.089893, 0.806232>, <-0.117284, -0.118189, 1.009929>, 
      <-0.277858, 0.075404, 0.346763>, <-0.268604, 0.062669, 0.556546>, <-0.265629, 0.018490, 0.827949>, <-0.255321, -0.015869, 1.035241>, 
      <-0.380150, 0.150836, 0.358497>, <-0.370896, 0.138101, 0.568280>, <-0.359623, 0.086584, 0.844794>, <-0.349316, 0.052226, 1.052086>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.380150, 0.150836, 0.358497>, <0.370896, 0.138101, 0.568280>, <0.359623, 0.086584, 0.844794>, <0.349316, 0.052226, 1.052086>, 
      <0.277858, 0.075404, 0.346763>, <0.268604, 0.062669, 0.556546>, <0.265629, 0.018490, 0.827949>, <0.255321, -0.015869, 1.035241>, 
      <0.127637, -0.037942, 0.329131>, <0.127637, -0.045328, 0.534652>, <0.117284, -0.089893, 0.806232>, <0.117284, -0.118189, 1.009929>, 
      <0.000000, -0.037942, 0.329131>, <0.000000, -0.045328, 0.534652>, <0.000000, -0.089893, 0.806232>, <0.000000, -0.118189, 1.009929>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.537694, 0.358563, 0.390811>, <0.524588, 0.339929, 0.605272>, <0.508713, 0.280816, 0.887259>, <0.494081, 0.239749, 1.098475>, 
      <0.537694, 0.280688, 0.378696>, <0.524588, 0.262053, 0.593158>, <0.508713, 0.210515, 0.869869>, <0.494081, 0.169448, 1.081084>, 
      <0.443312, 0.197413, 0.365743>, <0.434058, 0.184678, 0.575525>, <0.417662, 0.128631, 0.855196>, <0.407355, 0.094272, 1.062487>, 
      <0.380150, 0.150836, 0.358497>, <0.370896, 0.138101, 0.568280>, <0.359623, 0.086584, 0.844794>, <0.349316, 0.052226, 1.052086>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.380150, 0.271499, 0.377268>, <0.370889, 0.255339, 0.589770>, <0.359647, 0.199409, 0.869428>, <0.349316, 0.161153, 1.079032>, 
      <0.429988, 0.292431, 0.380524>, <0.420726, 0.276271, 0.593026>, <0.405442, 0.218305, 0.874103>, <0.395111, 0.180049, 1.083706>, 
      <0.537694, 0.412072, 0.399135>, <0.524588, 0.393438, 0.613596>, <0.508713, 0.329121, 0.899209>, <0.494081, 0.288053, 1.110424>, 
      <0.537694, 0.358563, 0.390811>, <0.524588, 0.339929, 0.605272>, <0.508713, 0.280816, 0.887259>, <0.494081, 0.239749, 1.098475>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.132727, 0.355680>, <0.000000, 0.120506, 0.565054>, <0.000000, 0.069662, 0.841050>, <0.000000, 0.035880, 1.048042>, 
      <0.121579, 0.132727, 0.355680>, <0.121579, 0.120506, 0.565054>, <0.111717, 0.069662, 0.841050>, <0.111717, 0.035880, 1.048042>, 
      <0.268260, 0.224504, 0.369957>, <0.258999, 0.208344, 0.582459>, <0.256832, 0.156985, 0.858934>, <0.246501, 0.118729, 1.068537>, 
      <0.380150, 0.271499, 0.377268>, <0.370889, 0.255339, 0.589770>, <0.359647, 0.199409, 0.869428>, <0.349316, 0.161153, 1.079032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.132727, 0.355680>, <-0.121579, 0.132727, 0.355680>, <-0.268260, 0.224504, 0.369957>, <-0.380150, 0.271499, 0.377268>, 
      <0.000000, 0.120506, 0.565054>, <-0.121579, 0.120506, 0.565054>, <-0.258999, 0.208344, 0.582459>, <-0.370889, 0.255339, 0.589770>, 
      <0.000000, 0.069662, 0.841050>, <-0.111717, 0.069662, 0.841050>, <-0.256832, 0.156985, 0.858934>, <-0.359647, 0.199409, 0.869428>, 
      <0.000000, 0.035880, 1.048042>, <-0.111717, 0.035880, 1.048042>, <-0.246501, 0.118729, 1.068537>, <-0.349316, 0.161153, 1.079032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.580069, 0.362005, -0.308553>, <-0.564490, 0.373186, -0.099233>, <-0.550468, 0.376725, 0.181790>, <-0.537694, 0.358563, 0.390811>, 
      <-0.580069, 0.420252, -0.304050>, <-0.564490, 0.431433, -0.094730>, <-0.550468, 0.430234, 0.190115>, <-0.537694, 0.412072, 0.399135>, 
      <-0.463874, 0.290017, -0.314118>, <-0.452844, 0.303945, -0.106736>, <-0.439024, 0.308199, 0.173177>, <-0.429988, 0.292431, 0.380524>, 
      <-0.410109, 0.267232, -0.315880>, <-0.399079, 0.281160, -0.108497>, <-0.389187, 0.287267, 0.169921>, <-0.380150, 0.271499, 0.377268>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.410109, 0.135886, -0.326035>, <-0.399064, 0.153621, -0.121494>, <-0.389194, 0.163282, 0.153468>, <-0.380150, 0.150836, 0.358497>, 
      <-0.478249, 0.186587, -0.322115>, <-0.467204, 0.204321, -0.117574>, <-0.452356, 0.209859, 0.160714>, <-0.443312, 0.197413, 0.365743>, 
      <-0.580069, 0.277235, -0.315107>, <-0.564490, 0.288416, -0.105787>, <-0.550468, 0.298849, 0.169676>, <-0.537694, 0.280688, 0.378696>, 
      <-0.580069, 0.362005, -0.308553>, <-0.564490, 0.373186, -0.099233>, <-0.550468, 0.376725, 0.181790>, <-0.537694, 0.358563, 0.390811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.069604, -0.341923>, <0.000000, -0.045886, -0.141783>, <0.000000, -0.030703, 0.127721>, <0.000000, -0.037942, 0.329131>, 
      <-0.137696, -0.069604, -0.341923>, <-0.137696, -0.045886, -0.141783>, <-0.127637, -0.030703, 0.127721>, <-0.127637, -0.037942, 0.329131>, 
      <-0.299756, 0.053776, -0.332383>, <-0.288711, 0.071511, -0.127843>, <-0.286903, 0.087851, 0.141734>, <-0.277858, 0.075404, 0.346763>, 
      <-0.410109, 0.135886, -0.326035>, <-0.399064, 0.153621, -0.121494>, <-0.389194, 0.163282, 0.153468>, <-0.380150, 0.150836, 0.358497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.410109, 0.135886, -0.326035>, <0.399064, 0.153621, -0.121494>, <0.389194, 0.163282, 0.153468>, <0.380150, 0.150836, 0.358497>, 
      <0.299756, 0.053776, -0.332383>, <0.288711, 0.071511, -0.127843>, <0.286903, 0.087851, 0.141734>, <0.277858, 0.075404, 0.346763>, 
      <0.137696, -0.069604, -0.341923>, <0.137696, -0.045886, -0.141783>, <0.127637, -0.030703, 0.127721>, <0.127637, -0.037942, 0.329131>, 
      <0.000000, -0.069604, -0.341923>, <0.000000, -0.045886, -0.141783>, <0.000000, -0.030703, 0.127721>, <0.000000, -0.037942, 0.329131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.580069, 0.362005, -0.308553>, <0.564490, 0.373186, -0.099233>, <0.550468, 0.376725, 0.181790>, <0.537694, 0.358563, 0.390811>, 
      <0.580069, 0.277235, -0.315107>, <0.564490, 0.288416, -0.105787>, <0.550468, 0.298849, 0.169676>, <0.537694, 0.280688, 0.378696>, 
      <0.478249, 0.186587, -0.322115>, <0.467204, 0.204321, -0.117574>, <0.452356, 0.209859, 0.160714>, <0.443312, 0.197413, 0.365743>, 
      <0.410109, 0.135886, -0.326035>, <0.399064, 0.153621, -0.121494>, <0.389194, 0.163282, 0.153468>, <0.380150, 0.150836, 0.358497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.410109, 0.267232, -0.315880>, <0.399079, 0.281160, -0.108497>, <0.389187, 0.287267, 0.169921>, <0.380150, 0.271499, 0.377268>, 
      <0.463874, 0.290017, -0.314118>, <0.452844, 0.303945, -0.106736>, <0.439024, 0.308199, 0.173177>, <0.429988, 0.292431, 0.380524>, 
      <0.580069, 0.420252, -0.304050>, <0.564490, 0.431433, -0.094730>, <0.550468, 0.430234, 0.190115>, <0.537694, 0.412072, 0.399135>, 
      <0.580069, 0.362005, -0.308553>, <0.564490, 0.373186, -0.099233>, <0.550468, 0.376725, 0.181790>, <0.537694, 0.358563, 0.390811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.116175, -0.327559>, <0.000000, 0.134491, -0.123347>, <0.000000, 0.144675, 0.150997>, <0.000000, 0.132727, 0.355680>, 
      <0.131160, 0.116175, -0.327559>, <0.131160, 0.134491, -0.123347>, <0.121579, 0.144675, 0.150997>, <0.121579, 0.132727, 0.355680>, 
      <0.289401, 0.216077, -0.319835>, <0.278371, 0.230004, -0.112452>, <0.277296, 0.240272, 0.162610>, <0.268260, 0.224504, 0.369957>, 
      <0.410109, 0.267232, -0.315880>, <0.399079, 0.281160, -0.108497>, <0.389187, 0.287267, 0.169921>, <0.380150, 0.271499, 0.377268>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.116175, -0.327559>, <-0.131160, 0.116175, -0.327559>, <-0.289401, 0.216077, -0.319835>, <-0.410109, 0.267232, -0.315880>, 
      <0.000000, 0.134491, -0.123347>, <-0.131160, 0.134491, -0.123347>, <-0.278371, 0.230004, -0.112452>, <-0.399079, 0.281160, -0.108497>, 
      <0.000000, 0.144675, 0.150997>, <-0.121579, 0.144675, 0.150997>, <-0.277296, 0.240272, 0.162610>, <-0.389187, 0.287267, 0.169921>, 
      <0.000000, 0.132727, 0.355680>, <-0.121579, 0.132727, 0.355680>, <-0.268260, 0.224504, 0.369957>, <-0.380150, 0.271499, 0.377268>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.631878, 0.290963, -0.874680>, <-0.616335, 0.312276, -0.704842>, <-0.592807, 0.352862, -0.479711>, <-0.580069, 0.362005, -0.308553>, 
      <-0.631878, 0.354602, -0.874680>, <-0.616335, 0.375914, -0.704842>, <-0.592807, 0.411109, -0.475207>, <-0.580069, 0.420252, -0.304050>, 
      <-0.505305, 0.212313, -0.874680>, <-0.494316, 0.236257, -0.707040>, <-0.472867, 0.278662, -0.483197>, <-0.463874, 0.290017, -0.314118>, 
      <-0.446738, 0.187418, -0.874680>, <-0.435749, 0.211362, -0.707040>, <-0.419102, 0.255877, -0.484958>, <-0.410109, 0.267232, -0.315880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.446738, 0.043913, -0.874680>, <-0.435749, 0.071505, -0.710086>, <-0.419093, 0.121460, -0.492421>, <-0.410109, 0.135886, -0.326035>, 
      <-0.520964, 0.099307, -0.874680>, <-0.509975, 0.126899, -0.710086>, <-0.487233, 0.172160, -0.488501>, <-0.478249, 0.186587, -0.322115>, 
      <-0.631878, 0.198346, -0.874680>, <-0.616335, 0.219658, -0.704842>, <-0.592807, 0.268092, -0.486265>, <-0.580069, 0.277235, -0.315107>, 
      <-0.631878, 0.290963, -0.874680>, <-0.616335, 0.312276, -0.704842>, <-0.592807, 0.352862, -0.479711>, <-0.580069, 0.362005, -0.308553>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.180600, -0.874680>, <0.000000, -0.147301, -0.714853>, <0.000000, -0.088817, -0.504048>, <0.000000, -0.069604, -0.341923>, 
      <-0.149994, -0.180600, -0.874680>, <-0.149994, -0.147301, -0.714853>, <-0.137696, -0.088817, -0.504048>, <-0.137696, -0.069604, -0.341923>, 
      <-0.326529, -0.045798, -0.874680>, <-0.315540, -0.018206, -0.710086>, <-0.308740, 0.039350, -0.498769>, <-0.299756, 0.053776, -0.332383>, 
      <-0.446738, 0.043913, -0.874680>, <-0.435749, 0.071505, -0.710086>, <-0.419093, 0.121460, -0.492421>, <-0.410109, 0.135886, -0.326035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.446738, 0.043913, -0.874680>, <0.435749, 0.071505, -0.710086>, <0.419093, 0.121460, -0.492421>, <0.410109, 0.135886, -0.326035>, 
      <0.326529, -0.045798, -0.874680>, <0.315540, -0.018206, -0.710086>, <0.308740, 0.039350, -0.498769>, <0.299756, 0.053776, -0.332383>, 
      <0.149994, -0.180600, -0.874680>, <0.149994, -0.147301, -0.714853>, <0.137696, -0.088817, -0.504048>, <0.137696, -0.069604, -0.341923>, 
      <0.000000, -0.180600, -0.874680>, <0.000000, -0.147301, -0.714853>, <0.000000, -0.088817, -0.504048>, <0.000000, -0.069604, -0.341923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.631878, 0.290963, -0.874680>, <0.616335, 0.312276, -0.704842>, <0.592807, 0.352862, -0.479711>, <0.580069, 0.362005, -0.308553>, 
      <0.631878, 0.198346, -0.874680>, <0.616335, 0.219658, -0.704842>, <0.592807, 0.268092, -0.486265>, <0.580069, 0.277235, -0.315107>, 
      <0.520964, 0.099307, -0.874680>, <0.509975, 0.126899, -0.710086>, <0.487233, 0.172160, -0.488501>, <0.478249, 0.186587, -0.322115>, 
      <0.446738, 0.043913, -0.874680>, <0.435749, 0.071505, -0.710086>, <0.419093, 0.121460, -0.492421>, <0.410109, 0.135886, -0.326035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.446738, 0.187418, -0.874680>, <0.435749, 0.211362, -0.707040>, <0.419102, 0.255877, -0.484958>, <0.410109, 0.267232, -0.315880>, 
      <0.505305, 0.212313, -0.874680>, <0.494316, 0.236257, -0.707040>, <0.472867, 0.278662, -0.483197>, <0.463874, 0.290017, -0.314118>, 
      <0.631878, 0.354602, -0.874680>, <0.616335, 0.375914, -0.704842>, <0.592807, 0.411109, -0.475207>, <0.580069, 0.420252, -0.304050>, 
      <0.631878, 0.290963, -0.874680>, <0.616335, 0.312276, -0.704842>, <0.592807, 0.352862, -0.479711>, <0.580069, 0.362005, -0.308553>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.022377, -0.874680>, <0.000000, 0.050516, -0.710544>, <0.000000, 0.101299, -0.493424>, <0.000000, 0.116175, -0.327559>, 
      <0.142875, 0.022377, -0.874680>, <0.142875, 0.050516, -0.710544>, <0.131160, 0.101299, -0.493424>, <0.131160, 0.116175, -0.327559>, 
      <0.315249, 0.131527, -0.874680>, <0.304260, 0.155471, -0.707040>, <0.298394, 0.204721, -0.488913>, <0.289401, 0.216077, -0.319835>, 
      <0.446738, 0.187418, -0.874680>, <0.435749, 0.211362, -0.707040>, <0.419102, 0.255877, -0.484958>, <0.410109, 0.267232, -0.315880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.022377, -0.874680>, <-0.142875, 0.022377, -0.874680>, <-0.315249, 0.131527, -0.874680>, <-0.446738, 0.187418, -0.874680>, 
      <0.000000, 0.050516, -0.710544>, <-0.142875, 0.050516, -0.710544>, <-0.304260, 0.155471, -0.707040>, <-0.435749, 0.211362, -0.707040>, 
      <0.000000, 0.101299, -0.493424>, <-0.131160, 0.101299, -0.493424>, <-0.298394, 0.204721, -0.488913>, <-0.419102, 0.255877, -0.484958>, 
      <0.000000, 0.116175, -0.327559>, <-0.131160, 0.116175, -0.327559>, <-0.289401, 0.216077, -0.319835>, <-0.410109, 0.267232, -0.315880>
    }
  }
  texture {
    LongLeafy
  }
  scale 5.4
  rotate <49.427696, -9.068732, 117.562386>
  translate  <1.6, 17.5, -1.5>
}


#declare TreeTrunk1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.103716, -1.304886, -1.613899>, <0.279762, -1.296943, -1.498354>, <0.308713, -1.306994, -0.749980>, <0.608739, -1.311121, -0.484582>, 
      <-0.103731, -1.396822, -1.670416>, <0.279746, -1.388880, -1.554871>, <0.336600, -1.381820, -0.788764>, <0.636626, -1.385947, -0.523366>, 
      <-0.113247, -1.514412, -1.753241>, <0.305642, -1.507970, -1.654578>, <0.351778, -1.480352, -0.876988>, <0.672316, -1.477854, -0.589772>, 
      <-0.117332, -1.604210, -1.812959>, <0.301557, -1.597767, -1.714296>, <0.379026, -1.551809, -0.922070>, <0.699563, -1.549311, -0.634854>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.589033, -1.335929, -0.845480>, <-0.418781, -1.329549, -1.058554>, <-0.364878, -1.310295, -1.692589>, <-0.103716, -1.304886, -1.613899>, 
      <-0.620412, -1.410122, -0.872990>, <-0.450160, -1.403742, -1.086064>, <-0.364893, -1.402231, -1.749106>, <-0.103731, -1.396822, -1.670416>, 
      <-0.663844, -1.500321, -0.928120>, <-0.467569, -1.500173, -1.166113>, <-0.413484, -1.519030, -1.823958>, <-0.113247, -1.514412, -1.753241>, 
      <-0.695907, -1.570774, -0.963537>, <-0.499631, -1.570626, -1.201530>, <-0.417569, -1.608828, -1.883676>, <-0.117332, -1.604210, -1.812959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.410350, -1.353850, 0.021382>, <-1.383429, -1.351170, -0.335883>, <-0.812626, -1.344308, -0.565649>, <-0.589033, -1.335929, -0.845480>, 
      <-1.457718, -1.436318, 0.024106>, <-1.430798, -1.433638, -0.333159>, <-0.844005, -1.418501, -0.593158>, <-0.620412, -1.410122, -0.872990>, 
      <-1.543194, -1.529884, -0.004087>, <-1.513331, -1.529451, -0.396229>, <-0.914068, -1.500509, -0.624713>, <-0.663844, -1.500321, -0.928120>, 
      <-1.600127, -1.605327, -0.015002>, <-1.570264, -1.604894, -0.407144>, <-0.946130, -1.570963, -0.660130>, <-0.695907, -1.570774, -0.963537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.713582, -1.348326, 0.807397>, <-0.918955, -1.353677, 0.568455>, <-1.434028, -1.356207, 0.335602>, <-1.410350, -1.353850, 0.021382>, 
      <-0.740426, -1.418991, 0.834395>, <-0.945800, -1.424342, 0.595453>, <-1.481396, -1.438675, 0.338326>, <-1.457718, -1.436318, 0.024106>, 
      <-0.799756, -1.505466, 0.861804>, <-1.034383, -1.506971, 0.596439>, <-1.570091, -1.530273, 0.349108>, <-1.543194, -1.529884, -0.004087>, 
      <-0.836688, -1.572812, 0.885121>, <-1.071315, -1.574316, 0.619756>, <-1.627024, -1.605716, 0.338193>, <-1.600127, -1.605327, -0.015002>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005815, -1.316955, 1.669024>, <-0.330893, -1.323551, 1.660841>, <-0.494032, -1.342606, 1.062833>, <-0.713582, -1.348326, 0.807397>, 
      <0.006254, -1.401391, 1.719275>, <-0.330453, -1.407986, 1.711093>, <-0.520876, -1.413271, 1.089832>, <-0.740426, -1.418991, 0.834395>, 
      <0.029239, -1.511454, 1.788131>, <-0.358993, -1.511065, 1.770881>, <-0.542345, -1.503815, 1.152938>, <-0.799756, -1.505466, 0.861804>, 
      <0.039278, -1.594811, 1.839177>, <-0.348954, -1.594422, 1.821927>, <-0.579277, -1.571161, 1.176255>, <-0.836688, -1.572812, 0.885121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.930203, -1.316126, 0.847344>, <0.674086, -1.314244, 1.115801>, <0.376671, -1.309690, 1.678036>, <0.005815, -1.316955, 1.669024>, 
      <0.963919, -1.394401, 0.876362>, <0.707801, -1.392519, 1.144819>, <0.377111, -1.394126, 1.728288>, <0.006254, -1.401391, 1.719275>, 
      <0.995540, -1.497111, 0.931646>, <0.724560, -1.497990, 1.218240>, <0.423270, -1.511849, 1.805639>, <0.029239, -1.511454, 1.788131>, 
      <1.023542, -1.574676, 0.967775>, <0.752562, -1.575555, 1.254369>, <0.433309, -1.595206, 1.856685>, <0.039278, -1.594811, 1.839177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.117233, -1.002529, -1.443080>, <0.229466, -1.010241, -1.295511>, <0.207291, -0.987187, -0.592640>, <0.490039, -0.987127, -0.343463>, 
      <-0.121969, -1.099466, -1.481172>, <0.224729, -1.107178, -1.333604>, <0.241390, -1.088845, -0.624433>, <0.524138, -1.088785, -0.375255>, 
      <-0.103702, -1.216066, -1.559297>, <0.279776, -1.208123, -1.443752>, <0.273580, -1.212727, -0.701120>, <0.573606, -1.216854, -0.435721>, 
      <-0.103716, -1.304886, -1.613899>, <0.279762, -1.296943, -1.498354>, <0.308713, -1.306994, -0.749980>, <0.608739, -1.311121, -0.484582>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.440308, -0.966432, -0.739455>, <-0.294997, -0.968639, -0.920974>, <-0.331141, -0.997771, -1.534128>, <-0.117233, -1.002529, -1.443080>, 
      <-0.477046, -1.079667, -0.772892>, <-0.331735, -1.081874, -0.954410>, <-0.335878, -1.094708, -1.572220>, <-0.121969, -1.099466, -1.481172>, 
      <-0.543451, -1.228155, -0.805519>, <-0.373199, -1.221775, -1.018593>, <-0.364863, -1.221475, -1.637987>, <-0.103702, -1.216066, -1.559297>, 
      <-0.589033, -1.335929, -0.845480>, <-0.418781, -1.329549, -1.058554>, <-0.364878, -1.310295, -1.692589>, <-0.103716, -1.304886, -1.613899>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.244061, -0.985418, -0.035482>, <-1.203723, -0.978120, -0.353437>, <-0.640650, -0.963390, -0.489195>, <-0.440308, -0.966432, -0.739455>, 
      <-1.289891, -1.098945, -0.032704>, <-1.249552, -1.091647, -0.350660>, <-0.677388, -1.076625, -0.522632>, <-0.477046, -1.079667, -0.772892>, 
      <-1.349382, -1.247704, 0.017875>, <-1.322461, -1.245024, -0.339390>, <-0.767044, -1.236533, -0.525687>, <-0.543451, -1.228155, -0.805519>, 
      <-1.410350, -1.353850, 0.021382>, <-1.383429, -1.351170, -0.335883>, <-0.812626, -1.344308, -0.565649>, <-0.589033, -1.335929, -0.845480>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.618587, -0.998685, 0.665771>, <-0.799101, -0.993104, 0.449283>, <-1.279536, -0.991835, 0.244132>, <-1.244061, -0.985418, -0.035482>, 
      <-0.643054, -1.106983, 0.701727>, <-0.823568, -1.101402, 0.485239>, <-1.325365, -1.105363, 0.246909>, <-1.289891, -1.098945, -0.032704>, 
      <-0.674552, -1.245585, 0.768144>, <-0.879926, -1.250936, 0.529202>, <-1.373059, -1.250060, 0.332095>, <-1.349382, -1.247704, 0.017875>, 
      <-0.713582, -1.348326, 0.807397>, <-0.918955, -1.353677, 0.568455>, <-1.434028, -1.356207, 0.335602>, <-1.410350, -1.353850, 0.021382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.036314, -1.025001, 1.500054>, <-0.281385, -1.028335, 1.481036>, <-0.414794, -1.004986, 0.910177>, <-0.618587, -0.998685, 0.665771>, 
      <0.037277, -1.119649, 1.537005>, <-0.280422, -1.122984, 1.517987>, <-0.439261, -1.113283, 0.946133>, <-0.643054, -1.106983, 0.701727>, 
      <0.005361, -1.229640, 1.617058>, <-0.331347, -1.236235, 1.608875>, <-0.455002, -1.239866, 1.023580>, <-0.674552, -1.245585, 0.768144>, 
      <0.005815, -1.316955, 1.669024>, <-0.330893, -1.323551, 1.660841>, <-0.494032, -1.342606, 1.062833>, <-0.713582, -1.348326, 0.807397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.769174, -0.984121, 0.748845>, <0.551685, -0.987531, 0.976799>, <0.350815, -1.021700, 1.518881>, <0.036314, -1.025001, 1.500054>, 
      <0.804632, -1.088725, 0.779310>, <0.587142, -1.092135, 1.007265>, <0.351778, -1.116349, 1.555831>, <0.037277, -1.119649, 1.537005>, 
      <0.887297, -1.216513, 0.810416>, <0.631180, -1.214631, 1.078873>, <0.376217, -1.222375, 1.626070>, <0.005361, -1.229640, 1.617058>, 
      <0.930203, -1.316126, 0.847344>, <0.674086, -1.314244, 1.115801>, <0.376671, -1.309690, 1.678036>, <0.005815, -1.316955, 1.669024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.073505, -0.686555, -1.370919>, <0.245753, -0.667759, -1.219715>, <0.139590, -0.690730, -0.529001>, <0.402145, -0.695214, -0.291964>, 
      <-0.077270, -0.781201, -1.396497>, <0.241988, -0.762405, -1.245293>, <0.160557, -0.780441, -0.539747>, <0.423111, -0.784925, -0.302710>, 
      <-0.112776, -0.911307, -1.407233>, <0.233923, -0.919019, -1.259665>, <0.179011, -0.902877, -0.566273>, <0.461759, -0.902817, -0.317095>, 
      <-0.117233, -1.002529, -1.443080>, <0.229466, -1.010241, -1.295511>, <0.207291, -0.987187, -0.592640>, <0.490039, -0.987127, -0.343463>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.396413, -0.742229, -0.670170>, <-0.254266, -0.742666, -0.853614>, <-0.282947, -0.698886, -1.470113>, <-0.073505, -0.686555, -1.370919>, 
      <-0.405587, -0.810195, -0.690808>, <-0.263440, -0.810632, -0.874252>, <-0.286713, -0.793532, -1.495691>, <-0.077270, -0.781201, -1.396497>, 
      <-0.419029, -0.900845, -0.720089>, <-0.273718, -0.903052, -0.901607>, <-0.326684, -0.906549, -1.498281>, <-0.112776, -0.911307, -1.407233>, 
      <-0.440308, -0.966432, -0.739455>, <-0.294997, -0.968639, -0.920974>, <-0.331141, -0.997771, -1.534128>, <-0.117233, -1.002529, -1.443080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.139653, -0.683283, 0.004977>, <-1.098260, -0.687820, -0.293886>, <-0.581238, -0.741662, -0.431648>, <-0.396413, -0.742229, -0.670170>, 
      <-1.165423, -0.775953, -0.004626>, <-1.124030, -0.780490, -0.303490>, <-0.590412, -0.809628, -0.452286>, <-0.405587, -0.810195, -0.690808>, 
      <-1.207886, -0.895804, -0.037674>, <-1.167547, -0.888506, -0.355630>, <-0.619371, -0.897803, -0.469828>, <-0.419029, -0.900845, -0.720089>, 
      <-1.244061, -0.985418, -0.035482>, <-1.203723, -0.978120, -0.353437>, <-0.640650, -0.963390, -0.489195>, <-0.440308, -0.966432, -0.739455>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.572299, -0.722951, 0.599767>, <-0.725636, -0.715936, 0.406402>, <-1.173519, -0.679571, 0.249499>, <-1.139653, -0.683283, 0.004977>, 
      <-0.589157, -0.805307, 0.618762>, <-0.742494, -0.798292, 0.425397>, <-1.199289, -0.772242, 0.239896>, <-1.165423, -0.775953, -0.004626>, 
      <-0.600519, -0.918710, 0.639218>, <-0.781034, -0.913129, 0.422730>, <-1.243360, -0.902222, 0.241940>, <-1.207886, -0.895804, -0.037674>, 
      <-0.618587, -0.998685, 0.665771>, <-0.799101, -0.993104, 0.449283>, <-1.279536, -0.991835, 0.244132>, <-1.244061, -0.985418, -0.035482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000103, -0.735420, 1.441995>, <-0.305098, -0.743388, 1.426627>, <-0.382563, -0.731632, 0.839031>, <-0.572299, -0.722951, 0.599767>, 
      <0.004418, -0.822061, 1.463038>, <-0.300578, -0.830029, 1.447669>, <-0.399421, -0.813988, 0.858026>, <-0.589157, -0.805307, 0.618762>, 
      <0.035468, -0.941843, 1.467590>, <-0.282232, -0.945177, 1.448572>, <-0.396726, -0.925010, 0.883624>, <-0.600519, -0.918710, 0.639218>, 
      <0.036314, -1.025001, 1.500054>, <-0.281385, -1.028335, 1.481036>, <-0.414794, -1.004986, 0.910177>, <-0.618587, -0.998685, 0.665771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.717713, -0.689251, 0.664768>, <0.500800, -0.692964, 0.896862>, <0.317086, -0.727134, 1.457977>, <-0.000103, -0.735420, 1.441995>, 
      <0.729373, -0.777880, 0.691392>, <0.512461, -0.781593, 0.923486>, <0.321606, -0.813775, 1.479020>, <0.004418, -0.822061, 1.463038>, 
      <0.740309, -0.898965, 0.724043>, <0.522820, -0.902375, 0.951997>, <0.349969, -0.938542, 1.486417>, <0.035468, -0.941843, 1.467590>, 
      <0.769174, -0.984121, 0.748845>, <0.551685, -0.987531, 0.976799>, <0.350815, -1.021700, 1.518881>, <0.036314, -1.025001, 1.500054>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.096514, -0.481773, -1.302346>, <0.213681, -0.474441, -1.171978>, <0.119254, -0.483472, -0.504575>, <0.372968, -0.486214, -0.283460>, 
      <-0.092452, -0.546096, -1.311892>, <0.217743, -0.538764, -1.181525>, <0.125513, -0.546367, -0.508979>, <0.379227, -0.549109, -0.287864>, 
      <-0.071004, -0.623704, -1.353933>, <0.248254, -0.604907, -1.202729>, <0.125268, -0.629449, -0.521660>, <0.387823, -0.633932, -0.284623>, 
      <-0.073505, -0.686555, -1.370919>, <0.245753, -0.667759, -1.219715>, <0.139590, -0.690730, -0.529001>, <0.402145, -0.695214, -0.291964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.377883, -0.503961, -0.599025>, <-0.238950, -0.499717, -0.778937>, <-0.306058, -0.486726, -1.390412>, <-0.096514, -0.481773, -1.302346>, 
      <-0.386096, -0.577214, -0.611772>, <-0.247163, -0.572969, -0.791685>, <-0.301996, -0.551049, -1.399959>, <-0.092452, -0.546096, -1.311892>, 
      <-0.386831, -0.671241, -0.648614>, <-0.244684, -0.671677, -0.832058>, <-0.280446, -0.636035, -1.453128>, <-0.071004, -0.623704, -1.353933>, 
      <-0.396413, -0.742229, -0.670170>, <-0.254266, -0.742666, -0.853614>, <-0.282947, -0.698886, -1.470113>, <-0.073505, -0.686555, -1.370919>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.112642, -0.512820, 0.013493>, <-1.079168, -0.518795, -0.271473>, <-0.553259, -0.509320, -0.371922>, <-0.377883, -0.503961, -0.599025>, 
      <-1.122453, -0.563679, 0.015613>, <-1.088979, -0.569654, -0.269353>, <-0.561472, -0.582573, -0.384669>, <-0.386096, -0.577214, -0.611772>, 
      <-1.125833, -0.633585, 0.010127>, <-1.084440, -0.638122, -0.288736>, <-0.571655, -0.670673, -0.410092>, <-0.386831, -0.671241, -0.648614>, 
      <-1.139653, -0.683283, 0.004977>, <-1.098260, -0.687820, -0.293886>, <-0.581238, -0.741662, -0.431648>, <-0.396413, -0.742229, -0.670170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.512403, -0.479948, 0.546127>, <-0.665832, -0.482546, 0.360361>, <-1.140746, -0.507803, 0.252744>, <-1.112642, -0.512820, 0.013493>, 
      <-0.528126, -0.554435, 0.556169>, <-0.681555, -0.557033, 0.370403>, <-1.150557, -0.558662, 0.254863>, <-1.122453, -0.563679, 0.015613>, 
      <-0.557278, -0.649573, 0.582843>, <-0.710616, -0.642558, 0.389478>, <-1.159699, -0.629873, 0.254649>, <-1.125833, -0.633585, 0.010127>, 
      <-0.572299, -0.722951, 0.599767>, <-0.725636, -0.715936, 0.406402>, <-1.173519, -0.679571, 0.249499>, <-1.139653, -0.683283, 0.004977>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.008598, -0.493834, 1.371048>, <-0.283886, -0.495135, 1.359094>, <-0.326000, -0.476792, 0.771817>, <-0.512403, -0.479948, 0.546127>, 
      <0.006377, -0.567701, 1.386902>, <-0.286108, -0.569002, 1.374947>, <-0.341724, -0.551279, 0.781858>, <-0.528126, -0.554435, 0.556169>, 
      <-0.003930, -0.662068, 1.424180>, <-0.308926, -0.670036, 1.408812>, <-0.367543, -0.658254, 0.822107>, <-0.557278, -0.649573, 0.582843>, 
      <-0.000103, -0.735420, 1.441995>, <-0.305098, -0.743388, 1.426627>, <-0.382563, -0.731632, 0.839031>, <-0.572299, -0.722951, 0.599767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.702133, -0.474547, 0.595769>, <0.488776, -0.473992, 0.823576>, <0.320453, -0.492447, 1.383795>, <0.008598, -0.493834, 1.371048>, 
      <0.712081, -0.541230, 0.603081>, <0.498724, -0.540675, 0.830889>, <0.318232, -0.566314, 1.399648>, <0.006377, -0.567701, 1.386902>, 
      <0.709235, -0.624811, 0.645410>, <0.492322, -0.628524, 0.877504>, <0.313258, -0.653782, 1.440162>, <-0.003930, -0.662068, 1.424180>, 
      <0.717713, -0.689251, 0.664768>, <0.500800, -0.692964, 0.896862>, <0.317086, -0.727134, 1.457977>, <-0.000103, -0.735420, 1.441995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.103398, -0.213200, -1.300664>, <0.206016, -0.204894, -1.156440>, <0.099621, -0.218378, -0.485364>, <0.355166, -0.223110, -0.258911>, 
      <-0.102766, -0.293227, -1.310239>, <0.206648, -0.284921, -1.166015>, <0.105810, -0.297332, -0.491751>, <0.361355, -0.302064, -0.265299>, 
      <-0.101539, -0.402201, -1.290536>, <0.208656, -0.394869, -1.160168>, <0.111405, -0.404600, -0.499053>, <0.365120, -0.407342, -0.277938>, 
      <-0.096514, -0.481773, -1.302346>, <0.213681, -0.474441, -1.171978>, <0.119254, -0.483472, -0.504575>, <0.372968, -0.486214, -0.283460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.340304, -0.241779, -0.583083>, <-0.206161, -0.244034, -0.766027>, <-0.308961, -0.218718, -1.396481>, <-0.103398, -0.213200, -1.300664>, 
      <-0.344138, -0.321288, -0.582671>, <-0.209994, -0.323543, -0.765614>, <-0.308330, -0.298745, -1.406057>, <-0.102766, -0.293227, -1.310239>, 
      <-0.369144, -0.426012, -0.585461>, <-0.230211, -0.421767, -0.765373>, <-0.311083, -0.407154, -1.378602>, <-0.101539, -0.402201, -1.290536>, 
      <-0.377883, -0.503961, -0.599025>, <-0.238950, -0.499717, -0.778937>, <-0.306058, -0.486726, -1.390412>, <-0.096514, -0.481773, -1.302346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.045914, -0.197353, -0.015276>, <-1.015323, -0.202156, -0.285544>, <-0.501157, -0.239074, -0.363715>, <-0.340304, -0.241779, -0.583083>, 
      <-1.058586, -0.293560, -0.011338>, <-1.027995, -0.298363, -0.281606>, <-0.504991, -0.318583, -0.363302>, <-0.344138, -0.321288, -0.582671>, 
      <-1.094262, -0.417539, 0.009522>, <-1.060787, -0.423515, -0.275444>, <-0.544520, -0.431370, -0.358357>, <-0.369144, -0.426012, -0.585461>, 
      <-1.112642, -0.512820, 0.013493>, <-1.079168, -0.518795, -0.271473>, <-0.553259, -0.509320, -0.371922>, <-0.377883, -0.503961, -0.599025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.466543, -0.221958, 0.532227>, <-0.614703, -0.219391, 0.344383>, <-1.072818, -0.193129, 0.222424>, <-1.045914, -0.197353, -0.015276>, 
      <-0.469993, -0.300479, 0.536641>, <-0.618154, -0.297913, 0.348798>, <-1.085491, -0.289336, 0.226363>, <-1.058586, -0.293560, -0.011338>, 
      <-0.496283, -0.403586, 0.535833>, <-0.649712, -0.406184, 0.350067>, <-1.122366, -0.412522, 0.248772>, <-1.094262, -0.417539, 0.009522>, 
      <-0.512403, -0.479948, 0.546127>, <-0.665832, -0.482546, 0.360361>, <-1.140746, -0.507803, 0.252744>, <-1.112642, -0.512820, 0.013493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.015527, -0.215739, 1.330463>, <-0.263479, -0.214516, 1.309990>, <-0.293301, -0.224959, 0.751870>, <-0.466543, -0.221958, 0.532227>, 
      <0.010869, -0.298525, 1.345881>, <-0.268137, -0.297301, 1.325409>, <-0.296752, -0.303480, 0.756284>, <-0.469993, -0.300479, 0.536641>, 
      <0.011077, -0.411409, 1.353359>, <-0.281407, -0.412710, 1.341404>, <-0.309881, -0.400430, 0.761522>, <-0.496283, -0.403586, 0.535833>, 
      <0.008598, -0.493834, 1.371048>, <-0.283886, -0.495135, 1.359094>, <-0.326000, -0.476792, 0.771817>, <-0.512403, -0.479948, 0.546127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.648732, -0.226849, 0.614060>, <0.451750, -0.223252, 0.822561>, <0.301613, -0.216994, 1.351454>, <0.015527, -0.215739, 1.330463>, 
      <0.656350, -0.302677, 0.613203>, <0.459368, -0.299080, 0.821704>, <0.296955, -0.299779, 1.366872>, <0.010869, -0.298525, 1.345881>, 
      <0.690953, -0.399606, 0.587550>, <0.477596, -0.399051, 0.815358>, <0.322932, -0.410022, 1.366105>, <0.011077, -0.411409, 1.353359>, 
      <0.702133, -0.474547, 0.595769>, <0.488776, -0.473992, 0.823576>, <0.320453, -0.492447, 1.383795>, <0.008598, -0.493834, 1.371048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.100462, 0.018526, -1.242486>, <0.188866, 0.017201, -1.089039>, <0.082346, 0.043406, -0.453211>, <0.331014, 0.048997, -0.240161>, 
      <-0.102100, -0.052353, -1.253053>, <0.187227, -0.053678, -1.099607>, <0.092254, -0.038010, -0.457812>, <0.340923, -0.032419, -0.244761>, 
      <-0.103959, -0.142029, -1.292149>, <0.205455, -0.133723, -1.147925>, <0.093222, -0.136748, -0.478760>, <0.348767, -0.141481, -0.252307>, 
      <-0.103398, -0.213200, -1.300664>, <0.206016, -0.204894, -1.156440>, <0.099621, -0.218378, -0.485364>, <0.355166, -0.223110, -0.258911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.351072, 0.052121, -0.601909>, <-0.225834, 0.050222, -0.766215>, <-0.282982, 0.019361, -1.339286>, <-0.100462, 0.018526, -1.242486>, 
      <-0.358050, -0.035988, -0.604019>, <-0.232812, -0.037887, -0.768325>, <-0.284620, -0.051517, -1.349853>, <-0.102100, -0.052353, -1.253053>, 
      <-0.336047, -0.153473, -0.583542>, <-0.201903, -0.155728, -0.766485>, <-0.309523, -0.147547, -1.387966>, <-0.103959, -0.142029, -1.292149>, 
      <-0.340304, -0.241779, -0.583083>, <-0.206161, -0.244034, -0.766027>, <-0.308961, -0.218718, -1.396481>, <-0.103398, -0.213200, -1.300664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.040777, 0.032782, -0.008844>, <-1.007213, 0.036744, -0.279693>, <-0.516529, 0.054629, -0.384840>, <-0.351072, 0.052121, -0.601909>, 
      <-1.041204, -0.036277, -0.010664>, <-1.007640, -0.032315, -0.281513>, <-0.523507, -0.033479, -0.386949>, <-0.358050, -0.035988, -0.604019>, 
      <-1.036900, -0.128916, -0.018078>, <-1.006309, -0.133719, -0.288346>, <-0.496900, -0.150768, -0.364173>, <-0.336047, -0.153473, -0.583542>, 
      <-1.045914, -0.197353, -0.015276>, <-1.015323, -0.202156, -0.285544>, <-0.501157, -0.239074, -0.363715>, <-0.340304, -0.241779, -0.583083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.489743, 0.035751, 0.517135>, <-0.637198, 0.033425, 0.342554>, <-1.068878, 0.029465, 0.217930>, <-1.040777, 0.032782, -0.008844>, 
      <-0.490313, -0.041916, 0.520826>, <-0.637768, -0.044243, 0.346245>, <-1.069305, -0.039594, 0.216110>, <-1.041204, -0.036277, -0.010664>, 
      <-0.463135, -0.144398, 0.527866>, <-0.611295, -0.141831, 0.340023>, <-1.063804, -0.124692, 0.219622>, <-1.036900, -0.128916, -0.018078>, 
      <-0.466543, -0.221958, 0.532227>, <-0.614703, -0.219391, 0.344383>, <-1.072818, -0.193129, 0.222424>, <-1.045914, -0.197353, -0.015276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.039189, 0.049823, 1.269794>, <-0.235944, 0.041861, 1.249286>, <-0.311654, 0.038561, 0.727986>, <-0.489743, 0.035751, 0.517135>, 
      <0.039940, -0.031354, 1.281563>, <-0.235193, -0.039316, 1.261055>, <-0.312224, -0.039106, 0.731677>, <-0.490313, -0.041916, 0.520826>, 
      <0.020058, -0.135220, 1.315466>, <-0.258949, -0.133997, 1.294994>, <-0.289893, -0.147399, 0.747510>, <-0.463135, -0.144398, 0.527866>, 
      <0.015527, -0.215739, 1.330463>, <-0.263479, -0.214516, 1.309990>, <-0.293301, -0.224959, 0.751870>, <-0.466543, -0.221958, 0.532227>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.647560, 0.068663, 0.601908>, <0.465425, 0.068767, 0.802696>, <0.309414, 0.057643, 1.289937>, <0.039189, 0.049823, 1.269794>, 
      <0.647177, -0.019665, 0.610322>, <0.465042, -0.019561, 0.811110>, <0.310165, -0.023534, 1.301706>, <0.039940, -0.031354, 1.281563>, 
      <0.639863, -0.138570, 0.615058>, <0.442881, -0.134973, 0.823558>, <0.306144, -0.136475, 1.336458>, <0.020058, -0.135220, 1.315466>, 
      <0.648732, -0.226849, 0.614060>, <0.451750, -0.223252, 0.822561>, <0.301613, -0.216994, 1.351454>, <0.015527, -0.215739, 1.330463>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.091579, 0.297980, -1.224452>, <0.186183, 0.294188, -1.065761>, <0.053323, 0.266005, -0.440428>, <0.295203, 0.269596, -0.231072>, 
      <-0.095707, 0.214138, -1.228747>, <0.182055, 0.210346, -1.070056>, <0.058313, 0.199402, -0.446880>, <0.300194, 0.202992, -0.237525>, 
      <-0.098540, 0.101638, -1.230094>, <0.190787, 0.100313, -1.076648>, <0.074252, 0.109912, -0.449454>, <0.322921, 0.115503, -0.236403>, 
      <-0.100462, 0.018526, -1.242486>, <0.188866, 0.017201, -1.089039>, <0.082346, 0.043406, -0.453211>, <0.331014, 0.048997, -0.240161>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.299160, 0.277711, -0.570643>, <-0.172684, 0.279408, -0.733087>, <-0.270330, 0.300421, -1.326575>, <-0.091579, 0.297980, -1.224452>, 
      <-0.306604, 0.208547, -0.579111>, <-0.180128, 0.210244, -0.741554>, <-0.274457, 0.216579, -1.330870>, <-0.095707, 0.214138, -1.228747>, 
      <-0.345541, 0.121959, -0.600237>, <-0.220303, 0.120060, -0.764543>, <-0.281060, 0.102474, -1.326895>, <-0.098540, 0.101638, -1.230094>, 
      <-0.351072, 0.052121, -0.601909>, <-0.225834, 0.050222, -0.766215>, <-0.282982, 0.019361, -1.339286>, <-0.100462, 0.018526, -1.242486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.042930, 0.285216, -0.002556>, <-1.000833, 0.276936, -0.280039>, <-0.471649, 0.275397, -0.349103>, <-0.299160, 0.277711, -0.570643>, 
      <-1.047293, 0.209638, -0.005361>, <-1.005196, 0.201357, -0.282844>, <-0.479092, 0.206233, -0.357571>, <-0.306604, 0.208547, -0.579111>, 
      <-1.040309, 0.108511, -0.006848>, <-1.006745, 0.112473, -0.277697>, <-0.510997, 0.124467, -0.383167>, <-0.345541, 0.121959, -0.600237>, 
      <-1.040777, 0.032782, -0.008844>, <-1.007213, 0.036744, -0.279693>, <-0.516529, 0.054629, -0.384840>, <-0.351072, 0.052121, -0.601909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.462642, 0.309867, 0.506951>, <-0.611510, 0.306760, 0.329319>, <-1.077681, 0.292052, 0.226508>, <-1.042930, 0.285216, -0.002556>, 
      <-0.471919, 0.227788, 0.510819>, <-0.620787, 0.224681, 0.333187>, <-1.082044, 0.216473, 0.223703>, <-1.047293, 0.209638, -0.005361>, 
      <-0.489137, 0.118348, 0.513209>, <-0.636592, 0.116021, 0.338628>, <-1.068410, 0.105194, 0.219926>, <-1.040309, 0.108511, -0.006848>, 
      <-0.489743, 0.035751, 0.517135>, <-0.637198, 0.033425, 0.342554>, <-1.068878, 0.029465, 0.217930>, <-1.040777, 0.032782, -0.008844>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.010689, 0.307207, 1.254646>, <-0.254371, 0.312710, 1.240796>, <-0.292134, 0.313426, 0.710404>, <-0.462642, 0.309867, 0.506951>, 
      <0.015593, 0.229644, 1.258617>, <-0.249466, 0.235146, 1.244768>, <-0.301411, 0.231347, 0.714272>, <-0.471919, 0.227788, 0.510819>, 
      <0.038476, 0.126835, 1.258629>, <-0.236656, 0.118873, 1.238121>, <-0.311048, 0.121158, 0.724060>, <-0.489137, 0.118348, 0.513209>, 
      <0.039189, 0.049823, 1.269794>, <-0.235944, 0.041861, 1.249286>, <-0.311654, 0.038561, 0.727986>, <-0.489743, 0.035751, 0.517135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.650958, 0.286749, 0.565137>, <0.455427, 0.285049, 0.768817>, <0.292592, 0.301355, 1.269375>, <0.010689, 0.307207, 1.254646>, 
      <0.654405, 0.220771, 0.571323>, <0.458874, 0.219071, 0.775002>, <0.297497, 0.223792, 1.273347>, <0.015593, 0.229644, 1.258617>, 
      <0.647846, 0.134721, 0.595616>, <0.465712, 0.134825, 0.796404>, <0.308702, 0.134655, 1.278771>, <0.038476, 0.126835, 1.258629>, 
      <0.647560, 0.068663, 0.601908>, <0.465425, 0.068767, 0.802696>, <0.309414, 0.057643, 1.289937>, <0.039189, 0.049823, 1.269794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.076070, 0.514004, -1.217103>, <0.205411, 0.517288, -1.050950>, <0.049002, 0.534547, -0.408702>, <0.294296, 0.539018, -0.192692>, 
      <-0.075650, 0.449173, -1.221931>, <0.205831, 0.452458, -1.055778>, <0.048944, 0.452992, -0.412483>, <0.294237, 0.457463, -0.196472>, 
      <-0.088387, 0.362828, -1.221130>, <0.189375, 0.359035, -1.062439>, <0.047250, 0.347043, -0.432578>, <0.289131, 0.350633, -0.223222>, 
      <-0.091579, 0.297980, -1.224452>, <0.186183, 0.294188, -1.065761>, <0.053323, 0.266005, -0.440428>, <0.295203, 0.269596, -0.231072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.299413, 0.532091, -0.543149>, <-0.170448, 0.525738, -0.712636>, <-0.259547, 0.511863, -1.325407>, <-0.076070, 0.514004, -1.217103>, 
      <-0.303937, 0.455600, -0.547686>, <-0.174972, 0.449248, -0.717172>, <-0.259127, 0.447032, -1.330235>, <-0.075650, 0.449173, -1.221931>, 
      <-0.291007, 0.353469, -0.561369>, <-0.164530, 0.355166, -0.723812>, <-0.267137, 0.365268, -1.323253>, <-0.088387, 0.362828, -1.221130>, 
      <-0.299160, 0.277711, -0.570643>, <-0.172684, 0.279408, -0.733087>, <-0.270330, 0.300421, -1.326575>, <-0.091579, 0.297980, -1.224452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.010342, 0.560023, 0.010723>, <-0.976078, 0.555665, -0.257558>, <-0.463137, 0.540155, -0.327982>, <-0.299413, 0.532091, -0.543149>, 
      <-1.014715, 0.477028, 0.011639>, <-0.980451, 0.472670, -0.256642>, <-0.467661, 0.463665, -0.332518>, <-0.303937, 0.455600, -0.547686>, 
      <-1.038144, 0.368136, 0.000522>, <-0.996047, 0.359856, -0.276962>, <-0.463495, 0.351155, -0.339828>, <-0.291007, 0.353469, -0.561369>, 
      <-1.042930, 0.285216, -0.002556>, <-1.000833, 0.276936, -0.280039>, <-0.471649, 0.275397, -0.349103>, <-0.299160, 0.277711, -0.570643>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.431740, 0.548923, 0.492951>, <-0.575588, 0.554379, 0.318744>, <-1.038968, 0.563665, 0.234861>, <-1.010342, 0.560023, 0.010723>, 
      <-0.443195, 0.477573, 0.497943>, <-0.587043, 0.483030, 0.323736>, <-1.043341, 0.480670, 0.235777>, <-1.014715, 0.477028, 0.011639>, 
      <-0.454515, 0.381765, 0.503563>, <-0.603383, 0.378658, 0.325930>, <-1.072895, 0.374972, 0.229585>, <-1.038144, 0.368136, 0.000522>, 
      <-0.462642, 0.309867, 0.506951>, <-0.611510, 0.306760, 0.329319>, <-1.077681, 0.292052, 0.226508>, <-1.042930, 0.285216, -0.002556>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.009373, 0.521343, 1.245649>, <-0.251976, 0.524139, 1.229546>, <-0.265058, 0.542600, 0.694812>, <-0.431740, 0.548923, 0.492951>, 
      <0.008830, 0.457250, 1.250765>, <-0.252520, 0.460046, 1.234662>, <-0.276513, 0.471251, 0.699803>, <-0.443195, 0.477573, 0.497943>, 
      <0.006637, 0.371294, 1.251364>, <-0.258423, 0.376797, 1.237514>, <-0.284008, 0.385324, 0.707016>, <-0.454515, 0.381765, 0.503563>, 
      <0.010689, 0.307207, 1.254646>, <-0.254371, 0.312710, 1.240796>, <-0.292134, 0.313426, 0.710404>, <-0.462642, 0.309867, 0.506951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.623058, 0.537639, 0.557943>, <0.434902, 0.535101, 0.760610>, <0.285390, 0.518390, 1.262656>, <0.009373, 0.521343, 1.245649>, 
      <0.631539, 0.462416, 0.561010>, <0.443383, 0.459878, 0.763678>, <0.284847, 0.454298, 1.267772>, <0.008830, 0.457250, 1.250765>, 
      <0.647022, 0.362078, 0.558075>, <0.451491, 0.360378, 0.761755>, <0.288540, 0.365442, 1.266094>, <0.006637, 0.371294, 1.251364>, 
      <0.650958, 0.286749, 0.565137>, <0.455427, 0.285049, 0.768817>, <0.292592, 0.301355, 1.269375>, <0.010689, 0.307207, 1.254646>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094632, 0.768810, -1.189388>, <0.178153, 0.772820, -1.028613>, <0.053147, 0.749500, -0.412522>, <0.295549, 0.750787, -0.208767>, 
      <-0.094153, 0.692291, -1.198780>, <0.178632, 0.696302, -1.038005>, <0.053668, 0.685875, -0.409188>, <0.296071, 0.687162, -0.205433>, 
      <-0.076569, 0.590883, -1.211378>, <0.204912, 0.594168, -1.045224>, <0.049048, 0.598193, -0.405752>, <0.294341, 0.602664, -0.189742>, 
      <-0.076070, 0.514004, -1.217103>, <0.205411, 0.517288, -1.050950>, <0.049002, 0.534547, -0.408702>, <0.294296, 0.539018, -0.192692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.271677, 0.742448, -0.543082>, <-0.147819, 0.743013, -0.701627>, <-0.267944, 0.766262, -1.291536>, <-0.094632, 0.768810, -1.189388>, 
      <-0.273784, 0.678948, -0.546964>, <-0.149926, 0.679513, -0.705509>, <-0.267465, 0.689743, -1.300928>, <-0.094153, 0.692291, -1.198780>, 
      <-0.295662, 0.595522, -0.539388>, <-0.166697, 0.589170, -0.708874>, <-0.260046, 0.588742, -1.319682>, <-0.076569, 0.590883, -1.211378>, 
      <-0.299413, 0.532091, -0.543149>, <-0.170448, 0.525738, -0.712636>, <-0.259547, 0.511863, -1.325407>, <-0.076070, 0.514004, -1.217103>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.017667, 0.764597, -0.007847>, <-0.985335, 0.762817, -0.281459>, <-0.441295, 0.741674, -0.325961>, <-0.271677, 0.742448, -0.543082>, 
      <-1.023041, 0.703168, -0.007731>, <-0.990708, 0.701388, -0.281344>, <-0.443401, 0.678174, -0.329843>, <-0.273784, 0.678948, -0.546964>, 
      <-1.007097, 0.621598, 0.010044>, <-0.972833, 0.617239, -0.258237>, <-0.459386, 0.603587, -0.324220>, <-0.295662, 0.595522, -0.539388>, 
      <-1.010342, 0.560023, 0.010723>, <-0.976078, 0.555665, -0.257558>, <-0.463137, 0.540155, -0.327982>, <-0.299413, 0.532091, -0.543149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.392127, 0.749081, 0.476224>, <-0.544963, 0.749641, 0.294651>, <-1.045519, 0.766131, 0.227844>, <-1.017667, 0.764597, -0.007847>, 
      <-0.392745, 0.687834, 0.480759>, <-0.545582, 0.688394, 0.299186>, <-1.050892, 0.704702, 0.227959>, <-1.023041, 0.703168, -0.007731>, 
      <-0.422028, 0.609419, 0.488719>, <-0.565876, 0.614876, 0.314512>, <-1.035723, 0.625239, 0.234181>, <-1.007097, 0.621598, 0.010044>, 
      <-0.431740, 0.548923, 0.492951>, <-0.575588, 0.554379, 0.318744>, <-1.038968, 0.563665, 0.234861>, <-1.010342, 0.560023, 0.010723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.014538, 0.760817, 1.218437>, <-0.238675, 0.754024, 1.200758>, <-0.228610, 0.748482, 0.670485>, <-0.392127, 0.749081, 0.476224>, 
      <0.015170, 0.688560, 1.221415>, <-0.238043, 0.681767, 1.203736>, <-0.229229, 0.687235, 0.675020>, <-0.392745, 0.687834, 0.480759>, 
      <0.009985, 0.593432, 1.239895>, <-0.251364, 0.596228, 1.223791>, <-0.255345, 0.603097, 0.690579>, <-0.422028, 0.609419, 0.488719>, 
      <0.009373, 0.521343, 1.245649>, <-0.251976, 0.524139, 1.229546>, <-0.265058, 0.542600, 0.694812>, <-0.431740, 0.548923, 0.492951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.595839, 0.775586, 0.545203>, <0.412123, 0.773323, 0.738766>, <0.280672, 0.767957, 1.237019>, <0.014538, 0.760817, 1.218437>, 
      <0.598261, 0.703856, 0.550293>, <0.414545, 0.701593, 0.743857>, <0.281304, 0.695700, 1.239997>, <0.015170, 0.688560, 1.221415>, 
      <0.615002, 0.609078, 0.555030>, <0.426847, 0.606541, 0.757697>, <0.286002, 0.590480, 1.256901>, <0.009985, 0.593432, 1.239895>, 
      <0.623058, 0.537639, 0.557943>, <0.434902, 0.535101, 0.760610>, <0.285390, 0.518390, 1.262656>, <0.009373, 0.521343, 1.245649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.078910, 0.967196, -1.161478>, <0.191176, 0.957426, -1.020667>, <0.060011, 0.971528, -0.414383>, <0.290754, 0.970858, -0.215319>, 
      <-0.075820, 0.907080, -1.164802>, <0.194265, 0.897310, -1.023992>, <0.067476, 0.906137, -0.420135>, <0.298219, 0.905467, -0.221071>, 
      <-0.095007, 0.828646, -1.182044>, <0.177778, 0.832656, -1.021268>, <0.052605, 0.815474, -0.415979>, <0.295008, 0.816761, -0.212224>, 
      <-0.094632, 0.768810, -1.189388>, <0.178153, 0.772820, -1.028613>, <0.053147, 0.749500, -0.412522>, <0.295549, 0.750787, -0.208767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.284168, 0.991655, -0.515057>, <-0.160432, 0.992760, -0.676740>, <-0.259354, 0.973723, -1.255553>, <-0.078910, 0.967196, -1.161478>, 
      <-0.282993, 0.916360, -0.516912>, <-0.159257, 0.917465, -0.678594>, <-0.256265, 0.913607, -1.258878>, <-0.075820, 0.907080, -1.164802>, 
      <-0.269184, 0.817593, -0.538489>, <-0.145327, 0.818158, -0.697034>, <-0.268319, 0.826098, -1.284191>, <-0.095007, 0.828646, -1.182044>, 
      <-0.271677, 0.742448, -0.543082>, <-0.147819, 0.743013, -0.701627>, <-0.267944, 0.766262, -1.291536>, <-0.094632, 0.768810, -1.189388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.975426, 0.959191, 0.009973>, <-0.937593, 0.958565, -0.247859>, <-0.442542, 0.990241, -0.308115>, <-0.284168, 0.991655, -0.515057>, 
      <-0.982658, 0.899699, 0.007593>, <-0.944825, 0.899074, -0.250240>, <-0.441367, 0.914946, -0.309969>, <-0.282993, 0.916360, -0.516912>, 
      <-1.012441, 0.824345, -0.007959>, <-0.980109, 0.822565, -0.281571>, <-0.438802, 0.816819, -0.321368>, <-0.269184, 0.817593, -0.538489>, 
      <-1.017667, 0.764597, -0.007847>, <-0.985335, 0.762817, -0.281459>, <-0.441295, 0.741674, -0.325961>, <-0.271677, 0.742448, -0.543082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.427243, 0.994019, 0.459992>, <-0.560904, 0.993000, 0.294117>, <-1.006354, 0.959702, 0.220744>, <-0.975426, 0.959191, 0.009973>, 
      <-0.425010, 0.919818, 0.464827>, <-0.558671, 0.918799, 0.298951>, <-1.013586, 0.900211, 0.218364>, <-0.982658, 0.899699, 0.007593>, 
      <-0.391377, 0.823267, 0.470730>, <-0.544213, 0.823826, 0.289157>, <-1.040292, 0.825879, 0.227731>, <-1.012441, 0.824345, -0.007959>, 
      <-0.392127, 0.749081, 0.476224>, <-0.544963, 0.749641, 0.294651>, <-1.045519, 0.766131, 0.227844>, <-1.017667, 0.764597, -0.007847>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005481, 0.966668, 1.227296>, <-0.258344, 0.970625, 1.210310>, <-0.261350, 0.995284, 0.665870>, <-0.427243, 0.994019, 0.459992>, 
      <0.004800, 0.904806, 1.228183>, <-0.259025, 0.908763, 1.211197>, <-0.259116, 0.921083, 0.670704>, <-0.425010, 0.919818, 0.464827>, 
      <0.013998, 0.822635, 1.215890>, <-0.239216, 0.815841, 1.198211>, <-0.227860, 0.822668, 0.664992>, <-0.391377, 0.823267, 0.470730>, 
      <0.014538, 0.760817, 1.218437>, <-0.238675, 0.754024, 1.200758>, <-0.228610, 0.748482, 0.670485>, <-0.392127, 0.749081, 0.476224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.608170, 0.978493, 0.526656>, <0.416109, 0.979006, 0.726648>, <0.282157, 0.962520, 1.245110>, <0.005481, 0.966668, 1.227296>, 
      <0.606012, 0.917572, 0.532486>, <0.413951, 0.918085, 0.732478>, <0.281477, 0.900658, 1.245997>, <0.004800, 0.904806, 1.228183>, 
      <0.593777, 0.836636, 0.540870>, <0.410061, 0.834372, 0.734434>, <0.280132, 0.829774, 1.234471>, <0.013998, 0.822635, 1.215890>, 
      <0.595839, 0.775586, 0.545203>, <0.412123, 0.773323, 0.738766>, <0.280672, 0.767957, 1.237019>, <0.014538, 0.760817, 1.218437>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.115717, 1.179020, -1.166704>, <0.146510, 1.173445, -0.987437>, <0.003641, 1.166992, -0.375037>, <0.248257, 1.165039, -0.172330>, 
      <-0.114083, 1.114549, -1.164849>, <0.148144, 1.108974, -0.985583>, <0.010170, 1.106815, -0.382687>, <0.254785, 1.104862, -0.179980>, 
      <-0.082217, 1.031531, -1.157920>, <0.187869, 1.021761, -1.017110>, <0.053117, 1.031916, -0.409071>, <0.283860, 1.031246, -0.210007>, 
      <-0.078910, 0.967196, -1.161478>, <0.191176, 0.957426, -1.020667>, <0.060011, 0.971528, -0.414383>, <0.290754, 0.970858, -0.215319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.278444, 1.176238, -0.532400>, <-0.163612, 1.172181, -0.691748>, <-0.277871, 1.182468, -1.277558>, <-0.115717, 1.179020, -1.166704>, 
      <-0.275498, 1.120676, -0.531579>, <-0.160666, 1.116620, -0.690927>, <-0.276237, 1.117997, -1.275703>, <-0.114083, 1.114549, -1.164849>, 
      <-0.285036, 1.047276, -0.513688>, <-0.161300, 1.048381, -0.675370>, <-0.262661, 1.038058, -1.251996>, <-0.082217, 1.031531, -1.157920>, 
      <-0.284168, 0.991655, -0.515057>, <-0.160432, 0.992760, -0.676740>, <-0.259354, 0.973723, -1.255553>, <-0.078910, 0.967196, -1.161478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.963646, 1.208975, 0.009935>, <-0.930142, 1.210666, -0.250252>, <-0.431788, 1.181655, -0.319610>, <-0.278444, 1.176238, -0.532400>, 
      <-0.973346, 1.134609, 0.008107>, <-0.939842, 1.136299, -0.252081>, <-0.428842, 1.126094, -0.318789>, <-0.275498, 1.120676, -0.531579>, 
      <-0.966380, 1.033602, 0.012951>, <-0.928547, 1.032977, -0.244882>, <-0.443410, 1.045862, -0.306745>, <-0.285036, 1.047276, -0.513688>, 
      <-0.975426, 0.959191, 0.009973>, <-0.937593, 0.958565, -0.247859>, <-0.442542, 0.990241, -0.308115>, <-0.284168, 0.991655, -0.515057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.404793, 1.169863, 0.448807>, <-0.539727, 1.178473, 0.283581>, <-0.990912, 1.207600, 0.221680>, <-0.963646, 1.208975, 0.009935>, 
      <-0.407829, 1.116682, 0.450237>, <-0.542763, 1.125291, 0.285011>, <-1.000612, 1.133233, 0.219851>, <-0.973346, 1.134609, 0.008107>, 
      <-0.428843, 1.047170, 0.456529>, <-0.562504, 1.046151, 0.290653>, <-0.997308, 1.034113, 0.223722>, <-0.966380, 1.033602, 0.012951>, 
      <-0.427243, 0.994019, 0.459992>, <-0.560904, 0.993000, 0.294117>, <-1.006354, 0.959702, 0.220744>, <-0.975426, 0.959191, 0.009973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.018777, 1.146291, 1.212912>, <-0.242966, 1.147634, 1.197646>, <-0.239084, 1.159290, 0.651718>, <-0.404793, 1.169863, 0.448807>, 
      <0.016039, 1.092399, 1.218056>, <-0.245703, 1.093742, 1.202791>, <-0.242120, 1.106108, 0.653148>, <-0.407829, 1.116682, 0.450237>, 
      <0.006077, 1.020866, 1.226519>, <-0.257748, 1.024822, 1.209533>, <-0.262949, 1.048434, 0.662406>, <-0.428843, 1.047170, 0.456529>, 
      <0.005481, 0.966668, 1.227296>, <-0.258344, 0.970625, 1.210310>, <-0.261350, 0.995284, 0.665870>, <-0.427243, 0.994019, 0.459992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.609620, 1.164658, 0.507972>, <0.421143, 1.161169, 0.709561>, <0.294301, 1.144877, 1.228982>, <0.018777, 1.146291, 1.212912>, 
      <0.606322, 1.108627, 0.508611>, <0.417846, 1.105138, 0.710200>, <0.291563, 1.090985, 1.234126>, <0.016039, 1.092399, 1.218056>, 
      <0.610148, 1.034335, 0.521313>, <0.418087, 1.034848, 0.721304>, <0.282753, 1.016717, 1.244333>, <0.006077, 1.020866, 1.226519>, 
      <0.608170, 0.978493, 0.526656>, <0.416109, 0.979006, 0.726648>, <0.282157, 0.962520, 1.245110>, <0.005481, 0.966668, 1.227296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.088764, 1.355904, -1.172659>, <0.179683, 1.356223, -1.002148>, <0.010344, 1.338435, -0.376634>, <0.250923, 1.337998, -0.168646>, 
      <-0.091862, 1.302299, -1.173820>, <0.176585, 1.302617, -1.003310>, <0.011250, 1.286544, -0.377464>, <0.251829, 1.286107, -0.169476>, 
      <-0.117077, 1.232688, -1.168248>, <0.145150, 1.227113, -0.988981>, <-0.001913, 1.218187, -0.368528>, <0.242702, 1.216235, -0.165822>, 
      <-0.115717, 1.179020, -1.166704>, <0.146510, 1.173445, -0.987437>, <0.003641, 1.166992, -0.375037>, <0.248257, 1.165039, -0.172330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.302502, 1.337341, -0.520167>, <-0.184281, 1.337657, -0.688937>, <-0.262700, 1.355698, -1.283138>, <-0.088764, 1.355904, -1.172659>, 
      <-0.304776, 1.288397, -0.519286>, <-0.186555, 1.288713, -0.688057>, <-0.265798, 1.302092, -1.284300>, <-0.091862, 1.302299, -1.173820>, 
      <-0.281040, 1.225168, -0.533123>, <-0.166208, 1.221111, -0.692471>, <-0.279232, 1.236136, -1.279102>, <-0.117077, 1.232688, -1.168248>, 
      <-0.278444, 1.176238, -0.532400>, <-0.163612, 1.172181, -0.691748>, <-0.277871, 1.182468, -1.277558>, <-0.115717, 1.179020, -1.166704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.923973, 1.353674, 0.019672>, <-0.897743, 1.347066, -0.225850>, <-0.444217, 1.336963, -0.317857>, <-0.302502, 1.337341, -0.520167>, 
      <-0.927204, 1.308798, 0.016455>, <-0.900975, 1.302191, -0.229067>, <-0.446491, 1.288019, -0.316976>, <-0.304776, 1.288397, -0.519286>, 
      <-0.957814, 1.253689, 0.011035>, <-0.924310, 1.255380, -0.249153>, <-0.434383, 1.230585, -0.320334>, <-0.281040, 1.225168, -0.533123>, 
      <-0.963646, 1.208975, 0.009935>, <-0.930142, 1.210666, -0.250252>, <-0.431788, 1.181655, -0.319610>, <-0.278444, 1.176238, -0.532400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.406154, 1.363453, 0.450059>, <-0.533248, 1.365089, 0.293036>, <-0.945426, 1.359078, 0.220477>, <-0.923973, 1.353674, 0.019672>, 
      <-0.405096, 1.305383, 0.450160>, <-0.532190, 1.307020, 0.293138>, <-0.948657, 1.314203, 0.217259>, <-0.927204, 1.308798, 0.016455>, 
      <-0.401484, 1.227827, 0.447248>, <-0.536418, 1.236437, 0.282022>, <-0.985080, 1.252314, 0.222779>, <-0.957814, 1.253689, 0.011035>, 
      <-0.404793, 1.169863, 0.448807>, <-0.539727, 1.178473, 0.283581>, <-0.990912, 1.207600, 0.221680>, <-0.963646, 1.208975, 0.009935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.024519, 1.341458, 1.191519>, <-0.232182, 1.341968, 1.173637>, <-0.244267, 1.361368, 0.650068>, <-0.406154, 1.363453, 0.450059>, 
      <0.023063, 1.282564, 1.192805>, <-0.233638, 1.283074, 1.174923>, <-0.243209, 1.303298, 0.650169>, <-0.405096, 1.305383, 0.450160>, 
      <0.021753, 1.204876, 1.207320>, <-0.239990, 1.206219, 1.192054>, <-0.235775, 1.217254, 0.650159>, <-0.401484, 1.227827, 0.447248>, 
      <0.018777, 1.146291, 1.212912>, <-0.242966, 1.147634, 1.197646>, <-0.239084, 1.159290, 0.651718>, <-0.404793, 1.169863, 0.448807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.630704, 1.361394, 0.522286>, <0.444734, 1.359483, 0.719333>, <0.294817, 1.340922, 1.210348>, <0.024519, 1.341458, 1.191519>, 
      <0.634489, 1.302051, 0.519840>, <0.448519, 1.300140, 0.716887>, <0.293361, 1.282028, 1.211634>, <0.023063, 1.282564, 1.192805>, 
      <0.613116, 1.224065, 0.507293>, <0.424639, 1.220576, 0.708883>, <0.297277, 1.203462, 1.223389>, <0.021753, 1.204876, 1.207320>, 
      <0.609620, 1.164658, 0.507972>, <0.421143, 1.161169, 0.709561>, <0.294301, 1.144877, 1.228982>, <0.018777, 1.146291, 1.212912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094484, 1.546391, -1.158742>, <0.157787, 1.542303, -0.971165>, <0.003664, 1.552316, -0.371754>, <0.241462, 1.554182, -0.166106>, 
      <-0.092768, 1.489245, -1.162917>, <0.159503, 1.485157, -0.975341>, <0.006503, 1.487461, -0.372516>, <0.244300, 1.489327, -0.166868>, 
      <-0.085457, 1.413119, -1.171418>, <0.182990, 1.413438, -1.000908>, <0.009211, 1.403338, -0.375596>, <0.249790, 1.402901, -0.167608>, 
      <-0.088764, 1.355904, -1.172659>, <0.179683, 1.356223, -1.002148>, <0.010344, 1.338435, -0.376634>, <0.250923, 1.337998, -0.168646>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.260509, 1.562317, -0.539346>, <-0.149195, 1.563432, -0.696318>, <-0.248898, 1.548894, -1.273556>, <-0.094484, 1.546391, -1.158742>, 
      <-0.273107, 1.494824, -0.533593>, <-0.161793, 1.495939, -0.690564>, <-0.247182, 1.491748, -1.277731>, <-0.092768, 1.489245, -1.162917>, 
      <-0.299305, 1.406155, -0.521405>, <-0.181084, 1.406471, -0.690175>, <-0.259393, 1.412913, -1.281898>, <-0.085457, 1.413119, -1.171418>, 
      <-0.302502, 1.337341, -0.520167>, <-0.184281, 1.337657, -0.688937>, <-0.262700, 1.355698, -1.283138>, <-0.088764, 1.355904, -1.172659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.939962, 1.537920, 0.033521>, <-0.899524, 1.537542, -0.230114>, <-0.414791, 1.560771, -0.321784>, <-0.260509, 1.562317, -0.539346>, 
      <-0.935165, 1.482646, 0.029366>, <-0.894728, 1.482268, -0.234268>, <-0.427389, 1.493278, -0.316030>, <-0.273107, 1.494824, -0.533593>, 
      <-0.919988, 1.409026, 0.023641>, <-0.893758, 1.402418, -0.221881>, <-0.441021, 1.405776, -0.319095>, <-0.299305, 1.406155, -0.521405>, 
      <-0.923973, 1.353674, 0.019672>, <-0.897743, 1.347066, -0.225850>, <-0.444217, 1.336963, -0.317857>, <-0.302502, 1.337341, -0.520167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.411971, 1.563732, 0.448118>, <-0.540487, 1.560768, 0.292893>, <-0.970518, 1.538206, 0.232734>, <-0.939962, 1.537920, 0.033521>, 
      <-0.410226, 1.503648, 0.448701>, <-0.538742, 1.500684, 0.293476>, <-0.965722, 1.482932, 0.228580>, <-0.935165, 1.482646, 0.029366>, 
      <-0.407249, 1.423555, 0.449954>, <-0.534344, 1.425191, 0.292931>, <-0.941440, 1.414430, 0.224446>, <-0.919988, 1.409026, 0.023641>, 
      <-0.406154, 1.363453, 0.450059>, <-0.533248, 1.365089, 0.293036>, <-0.945426, 1.359078, 0.220477>, <-0.923973, 1.353674, 0.019672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.029008, 1.560273, 1.203871>, <-0.232720, 1.559033, 1.183766>, <-0.244585, 1.567594, 0.650292>, <-0.411971, 1.563732, 0.448118>, 
      <0.027661, 1.494628, 1.200165>, <-0.234067, 1.493389, 1.180060>, <-0.242840, 1.507510, 0.650874>, <-0.410226, 1.503648, 0.448701>, 
      <0.026143, 1.407185, 1.190084>, <-0.230558, 1.407695, 1.172202>, <-0.245362, 1.421470, 0.649963>, <-0.407249, 1.423555, 0.449954>, 
      <0.024519, 1.341458, 1.191519>, <-0.232182, 1.341968, 1.173637>, <-0.244267, 1.361368, 0.650068>, <-0.406154, 1.363453, 0.450059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583866, 1.568448, 0.524616>, <0.406919, 1.569051, 0.719368>, <0.291365, 1.561515, 1.224025>, <0.029008, 1.560273, 1.203871>, 
      <0.597917, 1.506332, 0.523917>, <0.420970, 1.506935, 0.718669>, <0.290018, 1.495871, 1.220319>, <0.027661, 1.494628, 1.200165>, 
      <0.626653, 1.424901, 0.524904>, <0.440684, 1.422990, 0.721951>, <0.296441, 1.406649, 1.208912>, <0.026143, 1.407185, 1.190084>, 
      <0.630704, 1.361394, 0.522286>, <0.444734, 1.359483, 0.719333>, <0.294817, 1.340922, 1.210348>, <0.024519, 1.341458, 1.191519>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.654246, -1.329068, -0.058830>, <1.735891, -1.330339, 0.279449>, <1.170415, -1.317891, 0.595560>, <0.930203, -1.316126, 0.847344>, 
      <1.702497, -1.411083, -0.063958>, <1.784142, -1.412354, 0.274321>, <1.204130, -1.396166, 0.624578>, <0.963919, -1.394401, 0.876362>, 
      <1.782052, -1.511006, -0.061013>, <1.860047, -1.517112, 0.324806>, <1.266005, -1.496234, 0.645595>, <0.995540, -1.497111, 0.931646>, 
      <1.836825, -1.588980, -0.061948>, <1.914820, -1.595086, 0.323871>, <1.294007, -1.573798, 0.681725>, <1.023542, -1.574676, 0.967775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.654246, -1.329068, -0.058830>, <1.702497, -1.411083, -0.063958>, <1.782052, -1.511006, -0.061013>, <1.836825, -1.588980, -0.061948>, 
      <1.574781, -1.327830, -0.388078>, <1.623032, -1.409845, -0.393207>, <1.706327, -1.505077, -0.435599>, <1.761101, -1.583051, -0.436535>, 
      <0.862417, -1.314610, -0.260181>, <0.890305, -1.389437, -0.298965>, <0.956965, -1.475636, -0.334714>, <0.984212, -1.547093, -0.379796>, 
      <0.608739, -1.311121, -0.484582>, <0.636626, -1.385947, -0.523366>, <0.672316, -1.477854, -0.589772>, <0.699563, -1.549311, -0.634854>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.491601, -1.002184, -0.025259>, <1.570259, -1.001337, 0.282546>, <0.988469, -0.980683, 0.518998>, <0.769174, -0.984121, 0.748845>, 
      <1.534572, -1.103422, -0.027082>, <1.613230, -1.102575, 0.280722>, <1.023927, -1.085287, 0.549463>, <0.804632, -1.088725, 0.779310>, 
      <1.598551, -1.234400, -0.052911>, <1.680196, -1.235671, 0.285368>, <1.127509, -1.218278, 0.558631>, <0.887297, -1.216513, 0.810416>, 
      <1.654246, -1.329068, -0.058830>, <1.735891, -1.330339, 0.279449>, <1.170415, -1.317891, 0.595560>, <0.930203, -1.316126, 0.847344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.491601, -1.002184, -0.025259>, <1.534572, -1.103422, -0.027082>, <1.598551, -1.234400, -0.052911>, <1.654246, -1.329068, -0.058830>, 
      <1.413536, -1.003024, -0.330741>, <1.456507, -1.104262, -0.332565>, <1.519086, -1.233162, -0.382159>, <1.574781, -1.327830, -0.388078>, 
      <0.726590, -0.987076, -0.134996>, <0.760689, -1.088734, -0.166789>, <0.827284, -1.220344, -0.211321>, <0.862417, -1.314610, -0.260181>, 
      <0.490039, -0.987127, -0.343463>, <0.524138, -1.088785, -0.375255>, <0.573606, -1.216854, -0.435721>, <0.608739, -1.311121, -0.484582>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.392154, -0.711585, -0.047707>, <1.484369, -0.709843, 0.231869>, <0.918715, -0.685810, 0.449697>, <0.717713, -0.689251, 0.664768>, 
      <1.418703, -0.799967, -0.043294>, <1.510918, -0.798225, 0.236281>, <0.930375, -0.774439, 0.476322>, <0.729373, -0.777880, 0.691392>, 
      <1.455508, -0.917150, -0.023727>, <1.534167, -0.916303, 0.284078>, <0.959604, -0.895527, 0.494196>, <0.740309, -0.898965, 0.724043>, 
      <1.491601, -1.002184, -0.025259>, <1.570259, -1.001337, 0.282546>, <0.988469, -0.980683, 0.518998>, <0.769174, -0.984121, 0.748845>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.392154, -0.711585, -0.047707>, <1.418703, -0.799967, -0.043294>, <1.455508, -0.917150, -0.023727>, <1.491601, -1.002184, -0.025259>, 
      <1.296321, -0.713396, -0.338253>, <1.322870, -0.801778, -0.333840>, <1.377443, -0.917991, -0.329209>, <1.413536, -1.003024, -0.330741>, 
      <0.629218, -0.699092, -0.086959>, <0.650185, -0.788803, -0.097705>, <0.698310, -0.902766, -0.108629>, <0.726590, -0.987076, -0.134996>, 
      <0.402145, -0.695214, -0.291964>, <0.423111, -0.784925, -0.302710>, <0.461759, -0.902817, -0.317095>, <0.490039, -0.987127, -0.343463>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.339937, -0.497298, -0.050464>, <1.435464, -0.493912, 0.204697>, <0.888392, -0.475031, 0.396894>, <0.702133, -0.474547, 0.595769>, 
      <1.350696, -0.562588, -0.050932>, <1.446223, -0.559202, 0.204228>, <0.898339, -0.541715, 0.404207>, <0.712081, -0.541230, 0.603081>, 
      <1.373139, -0.648283, -0.050867>, <1.465354, -0.646540, 0.228709>, <0.910237, -0.621370, 0.430340>, <0.709235, -0.624811, 0.645410>, 
      <1.392154, -0.711585, -0.047707>, <1.484369, -0.709843, 0.231869>, <0.918715, -0.685810, 0.449697>, <0.717713, -0.689251, 0.664768>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.339937, -0.497298, -0.050464>, <1.350696, -0.562588, -0.050932>, <1.373139, -0.648283, -0.050867>, <1.392154, -0.711585, -0.047707>, 
      <1.235318, -0.501006, -0.329911>, <1.246077, -0.566296, -0.330380>, <1.277305, -0.650093, -0.341413>, <1.296321, -0.713396, -0.338253>, 
      <0.597927, -0.488645, -0.087406>, <0.604186, -0.551540, -0.091810>, <0.614896, -0.637810, -0.079618>, <0.629218, -0.699092, -0.086959>, 
      <0.372968, -0.486214, -0.283460>, <0.379227, -0.549109, -0.287864>, <0.387823, -0.633932, -0.284623>, <0.402145, -0.695214, -0.291964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.314354, -0.239453, -0.044315>, <1.403886, -0.240593, 0.221923>, <0.841617, -0.230371, 0.409895>, <0.648732, -0.226849, 0.614060>, 
      <1.325537, -0.316312, -0.040650>, <1.415069, -0.317453, 0.225588>, <0.849235, -0.306198, 0.409038>, <0.656350, -0.302677, 0.613203>, 
      <1.327295, -0.420579, -0.049912>, <1.422822, -0.417193, 0.205248>, <0.877212, -0.400091, 0.388676>, <0.690953, -0.399606, 0.587550>, 
      <1.339937, -0.497298, -0.050464>, <1.435464, -0.493912, 0.204697>, <0.888392, -0.475031, 0.396894>, <0.702133, -0.474547, 0.595769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.314354, -0.239453, -0.044315>, <1.325537, -0.316312, -0.040650>, <1.327295, -0.420579, -0.049912>, <1.339937, -0.497298, -0.050464>, 
      <1.220354, -0.238256, -0.323842>, <1.231537, -0.315115, -0.320177>, <1.222676, -0.424287, -0.329360>, <1.235318, -0.501006, -0.329911>, 
      <0.575863, -0.227197, -0.063339>, <0.582052, -0.306151, -0.069726>, <0.590079, -0.409773, -0.081884>, <0.597927, -0.488645, -0.087406>, 
      <0.355166, -0.223110, -0.258911>, <0.361355, -0.302064, -0.265299>, <0.365120, -0.407342, -0.277938>, <0.372968, -0.486214, -0.283460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.260434, 0.049125, -0.076519>, <1.356944, 0.055121, 0.180216>, <0.831881, 0.068558, 0.398711>, <0.647560, 0.068663, 0.601908>, 
      <1.268381, -0.039111, -0.075456>, <1.364891, -0.033115, 0.181280>, <0.831498, -0.019771, 0.407125>, <0.647177, -0.019665, 0.610322>, 
      <1.301611, -0.151874, -0.048492>, <1.391143, -0.153014, 0.217747>, <0.832748, -0.142091, 0.410893>, <0.639863, -0.138570, 0.615058>, 
      <1.314354, -0.239453, -0.044315>, <1.403886, -0.240593, 0.221923>, <0.841617, -0.230371, 0.409895>, <0.648732, -0.226849, 0.614060>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.260434, 0.049125, -0.076519>, <1.268381, -0.039111, -0.075456>, <1.301611, -0.151874, -0.048492>, <1.314354, -0.239453, -0.044315>, 
      <1.160837, 0.042938, -0.341465>, <1.168784, -0.045299, -0.340401>, <1.207611, -0.150676, -0.328018>, <1.220354, -0.238256, -0.323842>, 
      <0.545980, 0.053831, -0.055986>, <0.555888, -0.027585, -0.060586>, <0.569464, -0.145567, -0.056735>, <0.575863, -0.227197, -0.063339>, 
      <0.331014, 0.048997, -0.240161>, <0.340923, -0.032419, -0.244761>, <0.348767, -0.141481, -0.252307>, <0.355166, -0.223110, -0.258911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.264137, 0.318106, -0.051037>, <1.370571, 0.323238, 0.187171>, <0.831674, 0.288320, 0.376890>, <0.650958, 0.286749, 0.565137>, 
      <1.269357, 0.237224, -0.052459>, <1.375791, 0.242355, 0.185749>, <0.835122, 0.222342, 0.383076>, <0.654405, 0.220771, 0.571323>, 
      <1.253163, 0.129856, -0.077493>, <1.349673, 0.135852, 0.179243>, <0.832167, 0.134615, 0.392419>, <0.647846, 0.134721, 0.595616>, 
      <1.260434, 0.049125, -0.076519>, <1.356944, 0.055121, 0.180216>, <0.831881, 0.068558, 0.398711>, <0.647560, 0.068663, 0.601908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.264137, 0.318106, -0.051037>, <1.269357, 0.237224, -0.052459>, <1.253163, 0.129856, -0.077493>, <1.260434, 0.049125, -0.076519>, 
      <1.143404, 0.312285, -0.321247>, <1.148624, 0.231402, -0.322670>, <1.153566, 0.123668, -0.342438>, <1.160837, 0.042938, -0.341465>, 
      <0.519009, 0.272918, -0.037362>, <0.524000, 0.206315, -0.043814>, <0.537886, 0.120336, -0.052229>, <0.545980, 0.053831, -0.055986>, 
      <0.295203, 0.269596, -0.231072>, <0.300194, 0.202992, -0.237525>, <0.322921, 0.115503, -0.236403>, <0.331014, 0.048997, -0.240161>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.228893, 0.537790, -0.067927>, <1.333730, 0.537350, 0.171440>, <0.800847, 0.540037, 0.366442>, <0.623058, 0.537639, 0.557943>, 
      <1.232811, 0.471021, -0.065185>, <1.337649, 0.470581, 0.174182>, <0.809328, 0.464814, 0.369509>, <0.631539, 0.462416, 0.561010>, 
      <1.259826, 0.384896, -0.049863>, <1.366260, 0.390028, 0.188346>, <0.827739, 0.363649, 0.369828>, <0.647022, 0.362078, 0.558075>, 
      <1.264137, 0.318106, -0.051037>, <1.370571, 0.323238, 0.187171>, <0.831674, 0.288320, 0.376890>, <0.650958, 0.286749, 0.565137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.228893, 0.537790, -0.067927>, <1.232811, 0.471021, -0.065185>, <1.259826, 0.384896, -0.049863>, <1.264137, 0.318106, -0.051037>, 
      <1.115411, 0.538266, -0.327031>, <1.119329, 0.471497, -0.324290>, <1.139093, 0.379075, -0.320073>, <1.143404, 0.312285, -0.321247>, 
      <0.506562, 0.542887, -0.005766>, <0.506504, 0.461332, -0.009546>, <0.512937, 0.353956, -0.029512>, <0.519009, 0.272918, -0.037362>, 
      <0.294296, 0.539018, -0.192692>, <0.294237, 0.457463, -0.196472>, <0.289131, 0.350633, -0.223222>, <0.295203, 0.269596, -0.231072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.237273, 0.775880, -0.069836>, <1.335871, 0.784023, 0.177724>, <0.779362, 0.777847, 0.351843>, <0.595839, 0.775586, 0.545203>, 
      <1.238452, 0.704577, -0.074632>, <1.337050, 0.712720, 0.172929>, <0.781784, 0.706117, 0.356933>, <0.598261, 0.703856, 0.550293>, 
      <1.224709, 0.609081, -0.070855>, <1.329547, 0.608641, 0.168512>, <0.792791, 0.611476, 0.363528>, <0.615002, 0.609078, 0.555030>, 
      <1.228893, 0.537790, -0.067927>, <1.333730, 0.537350, 0.171440>, <0.800847, 0.540037, 0.366442>, <0.623058, 0.537639, 0.557943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.237273, 0.775880, -0.069836>, <1.238452, 0.704577, -0.074632>, <1.224709, 0.609081, -0.070855>, <1.228893, 0.537790, -0.067927>, 
      <1.131619, 0.767155, -0.335111>, <1.132799, 0.695852, -0.339907>, <1.111227, 0.609557, -0.329959>, <1.115411, 0.538266, -0.327031>, 
      <0.514228, 0.751948, -0.024953>, <0.514750, 0.688323, -0.021619>, <0.506608, 0.606533, -0.002815>, <0.506562, 0.542887, -0.005766>, 
      <0.295549, 0.750787, -0.208767>, <0.296071, 0.687162, -0.205433>, <0.294341, 0.602664, -0.189742>, <0.294296, 0.539018, -0.192692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.221851, 0.963421, -0.039299>, <1.320367, 0.965791, 0.190986>, <0.781671, 0.978030, 0.345992>, <0.608170, 0.978493, 0.526656>, 
      <1.225287, 0.906338, -0.039989>, <1.323803, 0.908707, 0.190297>, <0.779513, 0.917109, 0.351822>, <0.606012, 0.917572, 0.532486>, 
      <1.236329, 0.832934, -0.065999>, <1.334927, 0.841077, 0.181562>, <0.777300, 0.838896, 0.347510>, <0.593777, 0.836636, 0.540870>, 
      <1.237273, 0.775880, -0.069836>, <1.335871, 0.784023, 0.177724>, <0.779362, 0.777847, 0.351843>, <0.595839, 0.775586, 0.545203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.221851, 0.963421, -0.039299>, <1.225287, 0.906338, -0.039989>, <1.236329, 0.832934, -0.065999>, <1.237273, 0.775880, -0.069836>, 
      <1.110041, 0.960731, -0.300660>, <1.113477, 0.903648, -0.301350>, <1.130675, 0.824209, -0.331274>, <1.131619, 0.767155, -0.335111>, 
      <0.506006, 0.970233, -0.029619>, <0.513471, 0.904843, -0.035371>, <0.513687, 0.817922, -0.028410>, <0.514228, 0.751948, -0.024953>, 
      <0.290754, 0.970858, -0.215319>, <0.298219, 0.905467, -0.221071>, <0.295008, 0.816761, -0.212224>, <0.295549, 0.750787, -0.208767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.213650, 1.168408, -0.065092>, <1.330828, 1.168285, 0.155507>, <0.780199, 1.167815, 0.325525>, <0.609620, 1.164658, 0.507972>, 
      <1.216746, 1.106516, -0.062369>, <1.333924, 1.106392, 0.158229>, <0.776902, 1.111784, 0.326164>, <0.606322, 1.108627, 0.508611>, 
      <1.218125, 1.025334, -0.038551>, <1.316641, 1.027704, 0.191735>, <0.783649, 1.033872, 0.340648>, <0.610148, 1.034335, 0.521313>, 
      <1.221851, 0.963421, -0.039299>, <1.320367, 0.965791, 0.190986>, <0.781671, 0.978030, 0.345992>, <0.608170, 0.978493, 0.526656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.213650, 1.168408, -0.065092>, <1.216746, 1.106516, -0.062369>, <1.218125, 1.025334, -0.038551>, <1.221851, 0.963421, -0.039299>, 
      <1.076952, 1.168553, -0.322440>, <1.080048, 1.106660, -0.319718>, <1.106315, 1.022645, -0.299912>, <1.110041, 0.960731, -0.300660>, 
      <0.472626, 1.163248, 0.013599>, <0.479155, 1.103071, 0.005949>, <0.499112, 1.030621, -0.024307>, <0.506006, 0.970233, -0.029619>, 
      <0.248257, 1.165039, -0.172330>, <0.254785, 1.104862, -0.179980>, <0.283860, 1.031246, -0.210007>, <0.290754, 0.970858, -0.215319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.202338, 1.353559, -0.056459>, <1.319842, 1.360798, 0.157316>, <0.798207, 1.363115, 0.344805>, <0.630704, 1.361394, 0.522286>, 
      <1.207611, 1.298106, -0.057277>, <1.325115, 1.305345, 0.156498>, <0.801991, 1.303772, 0.342359>, <0.634489, 1.302051, 0.519840>, 
      <1.210870, 1.223994, -0.067537>, <1.328048, 1.223871, 0.153062>, <0.783695, 1.227223, 0.324846>, <0.613116, 1.224065, 0.507293>, 
      <1.213650, 1.168408, -0.065092>, <1.330828, 1.168285, 0.155507>, <0.780199, 1.167815, 0.325525>, <0.609620, 1.164658, 0.507972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.202338, 1.353559, -0.056459>, <1.207611, 1.298106, -0.057277>, <1.210870, 1.223994, -0.067537>, <1.213650, 1.168408, -0.065092>, 
      <1.063941, 1.345034, -0.308243>, <1.069214, 1.289581, -0.309061>, <1.074172, 1.224139, -0.324885>, <1.076952, 1.168553, -0.322440>, 
      <0.468367, 1.337603, 0.019342>, <0.469273, 1.285712, 0.018512>, <0.467072, 1.214444, 0.020108>, <0.472626, 1.163248, 0.013599>, 
      <0.250923, 1.337998, -0.168646>, <0.251829, 1.286107, -0.169476>, <0.242702, 1.216235, -0.165822>, <0.248257, 1.165039, -0.172330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.176759, 1.556362, -0.059368>, <1.287636, 1.560982, 0.164302>, <0.751771, 1.567876, 0.339816>, <0.583866, 1.568448, 0.524616>, 
      <1.184432, 1.495521, -0.058495>, <1.295310, 1.500141, 0.165175>, <0.765822, 1.505760, 0.339117>, <0.597917, 1.506332, 0.523917>, 
      <1.196532, 1.414607, -0.055558>, <1.314037, 1.421845, 0.158217>, <0.794156, 1.426622, 0.347423>, <0.626653, 1.424901, 0.524904>, 
      <1.202338, 1.353559, -0.056459>, <1.319842, 1.360798, 0.157316>, <0.798207, 1.363115, 0.344805>, <0.630704, 1.361394, 0.522286>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.176759, 1.556362, -0.059368>, <1.184432, 1.495521, -0.058495>, <1.196532, 1.414607, -0.055558>, <1.202338, 1.353559, -0.056459>, 
      <1.051349, 1.551137, -0.312353>, <1.059023, 1.490296, -0.311480>, <1.058136, 1.406081, -0.307343>, <1.063941, 1.345034, -0.308243>, 
      <0.455070, 1.555857, 0.018623>, <0.457908, 1.491002, 0.017861>, <0.467234, 1.402507, 0.020380>, <0.468367, 1.337603, 0.019342>, 
      <0.241462, 1.554182, -0.166106>, <0.244300, 1.489327, -0.166868>, <0.249790, 1.402901, -0.167608>, <0.250923, 1.337998, -0.168646>
    }
  }
  scale 25.0
  rotate <90.0, -0.0, 160.0>
  translate  <21.4, 235.7, 27.2>
  texture {
    TreeBark
  }
}


#declare Abdomen = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 0.000000>, <0.500000, -0.234089, 0.000000>, <0.234089, -0.354203, 0.000000>, <0.000000, -0.354203, 0.000000>, 
      <0.500000, 0.234089, 0.000000>, <0.500000, 0.000000, 0.000000>, <0.234089, -0.354203, 0.223588>, <0.000000, -0.354203, 0.223588>, 
      <0.234089, 0.354203, 0.000000>, <0.234089, 0.354203, 0.223588>, <0.000000, 0.000000, 0.465909>, <0.000000, -0.342485, 0.465909>, 
      <0.000000, 0.354203, 0.000000>, <0.000000, 0.354203, 0.223588>, <0.000000, 0.342485, 0.465909>, <0.000000, 0.000000, 0.465909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 0.000000>, <0.500000, -0.234089, 0.000000>, <0.234089, -0.354203, 0.000000>, <0.000000, -0.354203, 0.000000>, 
      <0.500000, 0.234089, 0.000000>, <0.500000, 0.000000, 0.000000>, <0.234089, -0.354203, -0.356606>, <0.000000, -0.354203, -0.356606>, 
      <0.234089, 0.354203, 0.000000>, <0.234089, 0.354203, -0.356606>, <0.000000, 0.000000, -0.863636>, <0.000000, -0.181687, -0.863636>, 
      <0.000000, 0.354203, 0.000000>, <0.000000, 0.354203, -0.356606>, <0.000000, 0.181687, -0.863636>, <0.000000, 0.000000, -0.863636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.234089, 0.000000>, <0.234089, 0.354203, 0.000000>, <0.000000, 0.354203, 0.000000>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.234089, -0.381241>, <0.234089, 0.354203, -0.356606>, <0.000000, 0.354203, -0.356606>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.234089, -0.381241>, <0.194237, 0.181687, -0.863636>, <0.000000, 0.181687, -0.863636>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.381241>, <0.194237, 0.000000, -0.863636>, <0.000000, 0.000000, -0.863636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 0.000000>, <0.500000, -0.234089, 0.000000>, <0.234089, -0.354203, 0.000000>, <0.000000, -0.354203, 0.000000>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, -0.234089, -0.381241>, <0.234089, -0.354203, -0.356606>, <0.000000, -0.354203, -0.356606>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, -0.234089, -0.381241>, <0.194237, -0.181687, -0.863636>, <0.000000, -0.181687, -0.863636>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.381241>, <0.194237, 0.000000, -0.863636>, <0.000000, 0.000000, -0.863636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 0.000000>, <0.500000, -0.234089, 0.000000>, <0.234089, -0.354203, 0.000000>, <0.000000, -0.354203, 0.000000>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, -0.234089, 0.261090>, <0.234089, -0.354203, 0.223588>, <0.000000, -0.354203, 0.223588>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, -0.234089, 0.261090>, <0.399930, -0.342485, 0.465909>, <0.000000, -0.342485, 0.465909>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, 0.261090>, <0.399930, 0.000000, 0.465909>, <0.000000, 0.000000, 0.465909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, 0.261090>, <0.399930, 0.000000, 0.465909>, <0.000000, 0.000000, 0.465909>, 
      <0.500000, 0.000000, -0.381241>, <0.500000, 0.000000, -0.120151>, <0.399930, -0.342485, 0.465909>, <0.000000, -0.342485, 0.465909>, 
      <0.194237, 0.000000, -0.863636>, <0.194237, -0.181687, -0.863636>, <0.000000, -0.354203, -0.133018>, <0.000000, -0.354203, 0.223588>, 
      <0.000000, 0.000000, -0.863636>, <0.000000, -0.181687, -0.863636>, <0.000000, -0.354203, -0.356606>, <0.000000, -0.354203, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.234089, 0.000000>, <0.234089, 0.354203, 0.000000>, <0.000000, 0.354203, 0.000000>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.234089, 0.261090>, <0.234089, 0.354203, 0.223588>, <0.000000, 0.354203, 0.223588>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.234089, 0.261090>, <0.399930, 0.342485, 0.465909>, <0.000000, 0.342485, 0.465909>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, 0.261090>, <0.399930, 0.000000, 0.465909>, <0.000000, 0.000000, 0.465909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.381241>, <0.194237, 0.000000, -0.863636>, <0.000000, 0.000000, -0.863636>, 
      <0.500000, 0.000000, 0.261090>, <0.500000, 0.000000, -0.120151>, <0.194237, 0.181687, -0.863636>, <0.000000, 0.181687, -0.863636>, 
      <0.399930, 0.000000, 0.465909>, <0.399930, 0.342485, 0.465909>, <0.000000, 0.354203, -0.133018>, <0.000000, 0.354203, -0.356606>, 
      <0.000000, 0.000000, 0.465909>, <0.000000, 0.342485, 0.465909>, <0.000000, 0.354203, 0.223588>, <0.000000, 0.354203, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.234089, 0.000000>, <-0.234089, 0.354203, 0.000000>, <0.000000, 0.354203, 0.000000>, 
      <-0.500000, -0.234089, 0.000000>, <-0.500000, 0.000000, 0.000000>, <-0.234089, 0.354203, -0.356606>, <0.000000, 0.354203, -0.356606>, 
      <-0.234089, -0.354203, 0.000000>, <-0.234089, -0.354203, -0.356606>, <0.000000, 0.000000, -0.863636>, <0.000000, 0.181687, -0.863636>, 
      <0.000000, -0.354203, 0.000000>, <0.000000, -0.354203, -0.356606>, <0.000000, -0.181687, -0.863636>, <0.000000, 0.000000, -0.863636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.234089, 0.000000>, <-0.234089, 0.354203, 0.000000>, <0.000000, 0.354203, 0.000000>, 
      <-0.500000, -0.234089, 0.000000>, <-0.500000, 0.000000, 0.000000>, <-0.234089, 0.354203, 0.223588>, <0.000000, 0.354203, 0.223588>, 
      <-0.234089, -0.354203, 0.000000>, <-0.234089, -0.354203, 0.223588>, <0.000000, 0.000000, 0.465909>, <0.000000, 0.342485, 0.465909>, 
      <0.000000, -0.354203, 0.000000>, <0.000000, -0.354203, 0.223588>, <0.000000, -0.342485, 0.465909>, <0.000000, 0.000000, 0.465909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, -0.234089, 0.000000>, <-0.234089, -0.354203, 0.000000>, <0.000000, -0.354203, 0.000000>, 
      <-0.500000, 0.000000, 0.261090>, <-0.500000, -0.234089, 0.261090>, <0.000000, -0.354203, 0.000000>, <0.234089, -0.354203, 0.000000>, 
      <-0.399930, 0.000000, 0.465909>, <0.000000, 0.000000, 0.465909>, <0.500000, -0.234089, 0.261090>, <0.500000, -0.234089, 0.000000>, 
      <0.000000, 0.000000, 0.465909>, <0.399930, 0.000000, 0.465909>, <0.500000, 0.000000, 0.261090>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, 0.261090>, <-0.399930, 0.000000, 0.465909>, <0.000000, 0.000000, 0.465909>, 
      <-0.500000, 0.234089, 0.000000>, <-0.500000, 0.234089, 0.261090>, <0.000000, 0.000000, 0.465909>, <0.399930, 0.000000, 0.465909>, 
      <-0.234089, 0.354203, 0.000000>, <0.000000, 0.354203, 0.000000>, <0.500000, 0.234089, 0.261090>, <0.500000, 0.000000, 0.261090>, 
      <0.000000, 0.354203, 0.000000>, <0.234089, 0.354203, 0.000000>, <0.500000, 0.234089, 0.000000>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, 0.261090>, <-0.399930, 0.000000, 0.465909>, <0.000000, 0.000000, 0.465909>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, -0.234089, 0.261090>, <-0.399930, -0.342485, 0.465909>, <0.000000, -0.342485, 0.465909>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, -0.234089, 0.261090>, <-0.234089, -0.354203, 0.223588>, <0.000000, -0.354203, 0.223588>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, -0.234089, 0.000000>, <-0.234089, -0.354203, 0.000000>, <0.000000, -0.354203, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.234089, 0.000000>, <-0.234089, 0.354203, 0.000000>, <0.000000, 0.354203, 0.000000>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.234089, 0.261090>, <-0.234089, 0.354203, 0.223588>, <0.000000, 0.354203, 0.223588>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.234089, 0.261090>, <-0.399930, 0.342485, 0.465909>, <0.000000, 0.342485, 0.465909>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, 0.261090>, <-0.399930, 0.000000, 0.465909>, <0.000000, 0.000000, 0.465909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, -0.234089, 0.000000>, <-0.234089, -0.354203, 0.000000>, <0.000000, -0.354203, 0.000000>, 
      <-0.500000, 0.000000, -0.381241>, <-0.500000, -0.234089, -0.381241>, <0.000000, -0.354203, 0.000000>, <0.234089, -0.354203, 0.000000>, 
      <-0.194237, 0.000000, -0.863636>, <0.000000, 0.000000, -0.863636>, <0.500000, -0.234089, -0.381241>, <0.500000, -0.234089, 0.000000>, 
      <0.000000, 0.000000, -0.863636>, <0.194237, 0.000000, -0.863636>, <0.500000, 0.000000, -0.381241>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.234089, 0.000000>, <-0.234089, 0.354203, 0.000000>, <0.000000, 0.354203, 0.000000>, 
      <-0.500000, 0.000000, -0.381241>, <-0.500000, 0.234089, -0.381241>, <0.000000, 0.354203, 0.000000>, <0.234089, 0.354203, 0.000000>, 
      <-0.194237, 0.000000, -0.863636>, <0.000000, 0.000000, -0.863636>, <0.500000, 0.234089, -0.381241>, <0.500000, 0.234089, 0.000000>, 
      <0.000000, 0.000000, -0.863636>, <0.194237, 0.000000, -0.863636>, <0.500000, 0.000000, -0.381241>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.234089, 0.000000>, <-0.234089, 0.354203, 0.000000>, <0.000000, 0.354203, 0.000000>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.234089, -0.381241>, <-0.234089, 0.354203, -0.356606>, <0.000000, 0.354203, -0.356606>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.234089, -0.381241>, <-0.194237, 0.181687, -0.863636>, <0.000000, 0.181687, -0.863636>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, -0.381241>, <-0.194237, 0.000000, -0.863636>, <0.000000, 0.000000, -0.863636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, 0.261090>, <-0.399930, 0.000000, 0.465909>, <0.000000, 0.000000, 0.465909>, 
      <-0.500000, 0.000000, -0.381241>, <-0.500000, 0.000000, -0.120151>, <-0.399930, 0.342485, 0.465909>, <0.000000, 0.342485, 0.465909>, 
      <-0.194237, 0.000000, -0.863636>, <-0.194237, 0.181687, -0.863636>, <0.000000, 0.354203, -0.133018>, <0.000000, 0.354203, 0.223588>, 
      <0.000000, 0.000000, -0.863636>, <0.000000, 0.181687, -0.863636>, <0.000000, 0.354203, -0.356606>, <0.000000, 0.354203, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, -0.234089, 0.000000>, <-0.234089, -0.354203, 0.000000>, <0.000000, -0.354203, 0.000000>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, -0.234089, -0.381241>, <-0.234089, -0.354203, -0.356606>, <0.000000, -0.354203, -0.356606>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, -0.234089, -0.381241>, <-0.194237, -0.181687, -0.863636>, <0.000000, -0.181687, -0.863636>, 
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, -0.381241>, <-0.194237, 0.000000, -0.863636>, <0.000000, 0.000000, -0.863636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, -0.381241>, <-0.194237, 0.000000, -0.863636>, <0.000000, 0.000000, -0.863636>, 
      <-0.500000, 0.000000, 0.261090>, <-0.500000, 0.000000, -0.120151>, <-0.194237, -0.181687, -0.863636>, <0.000000, -0.181687, -0.863636>, 
      <-0.399930, 0.000000, 0.465909>, <-0.399930, -0.342485, 0.465909>, <0.000000, -0.354203, -0.133018>, <0.000000, -0.354203, -0.356606>, 
      <0.000000, 0.000000, 0.465909>, <0.000000, -0.342485, 0.465909>, <0.000000, -0.354203, 0.223588>, <0.000000, -0.354203, 0.000000>
    }
  }
  scale <145.0, 140.0, 160.0>
  rotate -70.0*x
  translate  <-7.6, -569.7, -66.5>
}
#declare LegJoiner1 = object {
  sphere { // LegJoiner1
    <0,0,0>,1
    scale <13.8, 9.8, 9.0>
    rotate <0.0, 25.0, 0.0>
    translate  <37.0, -341.7, -15.8>
  }
}
#declare LegJoiner4 = object {
  sphere { // LegJoiner4
    <0,0,0>,1
    scale <13.8, 9.8, 9.0>
    rotate -25.0*y
    translate  <-52.4, -341.7, -15.7>
  }
}
#declare RightLegJoiners = union {
  object { LegJoiner1 }
  object { // LegJoiner2->LegJoiner1
    LegJoiner1
    rotate <-0.0, 0.0, -0.0>
    translate  <-8.2, -59.6, -38.3>
  }
  object { // LegJoiner3->LegJoiner1
    LegJoiner1
    rotate <-0.0, 0.0, -0.0>
    translate  <-6.0, -112.4, -55.0>
  }
}
#declare MainThorax = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.337162, -0.032084, -1.038307>, <-0.260558, -0.032084, -1.121257>, <-0.112911, -0.032084, -1.205565>, <0.000000, -0.032084, -1.205565>, 
      <-0.337162, -0.032084, -1.038307>, <-0.260558, 0.153631, -1.121257>, <-0.112911, 0.082488, -1.205565>, <0.000000, 0.082488, -1.205565>, 
      <-0.337162, -0.032084, -1.038307>, <-0.260558, 0.153631, -1.121257>, <-0.185715, 0.232762, -1.121771>, <0.000000, 0.232762, -1.121771>, 
      <-0.337162, -0.032084, -1.038307>, <-0.337162, 0.153631, -1.038307>, <-0.185715, 0.311252, -1.038307>, <0.000000, 0.311252, -1.038307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.337162, -0.032084, -1.038307>, <-0.337162, 0.153631, -1.038307>, <-0.185715, 0.311252, -1.038307>, <0.000000, 0.311252, -1.038307>, 
      <-0.337162, -0.217800, -1.038307>, <-0.337162, -0.032084, -1.038307>, <-0.185715, 0.232762, -1.121771>, <0.000000, 0.232762, -1.121771>, 
      <-0.185715, -0.375420, -1.038307>, <-0.185715, -0.296930, -1.121771>, <0.000000, -0.032084, -1.205565>, <0.000000, 0.082488, -1.205565>, 
      <0.000000, -0.375420, -1.038307>, <0.000000, -0.296930, -1.121771>, <0.000000, -0.146657, -1.205565>, <0.000000, -0.032084, -1.205565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.337162, -0.032084, -1.038307>, <-0.260558, -0.032084, -1.121257>, <-0.112911, -0.032084, -1.205565>, <0.000000, -0.032084, -1.205565>, 
      <-0.337162, -0.032084, -1.038307>, <-0.260558, -0.217800, -1.121257>, <-0.112911, -0.146657, -1.205565>, <0.000000, -0.146657, -1.205565>, 
      <-0.337162, -0.032084, -1.038307>, <-0.260558, -0.217800, -1.121257>, <-0.185715, -0.296930, -1.121771>, <0.000000, -0.296930, -1.121771>, 
      <-0.337162, -0.032084, -1.038307>, <-0.337162, -0.217800, -1.038307>, <-0.185715, -0.375420, -1.038307>, <0.000000, -0.375420, -1.038307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337162, -0.032084, -1.038307>, <0.260558, -0.032084, -1.121257>, <0.112911, -0.032084, -1.205565>, <0.000000, -0.032084, -1.205565>, 
      <0.337162, -0.032084, -1.038307>, <0.260558, -0.217800, -1.121257>, <0.112911, -0.146657, -1.205565>, <0.000000, -0.146657, -1.205565>, 
      <0.337162, -0.032084, -1.038307>, <0.260558, -0.217800, -1.121257>, <0.185715, -0.296930, -1.121771>, <0.000000, -0.296930, -1.121771>, 
      <0.337162, -0.032084, -1.038307>, <0.337162, -0.217800, -1.038307>, <0.185715, -0.375420, -1.038307>, <0.000000, -0.375420, -1.038307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337162, -0.032084, -1.038307>, <0.260558, -0.032084, -1.121257>, <0.112911, -0.032084, -1.205565>, <0.000000, -0.032084, -1.205565>, 
      <0.337162, -0.217800, -1.038307>, <0.260558, -0.217800, -1.121257>, <0.000000, -0.032084, -1.205565>, <-0.112911, -0.032084, -1.205565>, 
      <0.185715, -0.375420, -1.038307>, <0.000000, -0.375420, -1.038307>, <-0.260558, -0.217800, -1.121257>, <-0.260558, -0.032084, -1.121257>, 
      <0.000000, -0.375420, -1.038307>, <-0.185715, -0.375420, -1.038307>, <-0.337162, -0.217800, -1.038307>, <-0.337162, -0.032084, -1.038307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337162, -0.032084, -1.038307>, <0.260558, -0.032084, -1.121257>, <0.112911, -0.032084, -1.205565>, <0.000000, -0.032084, -1.205565>, 
      <0.337162, 0.153631, -1.038307>, <0.260558, 0.153631, -1.121257>, <0.000000, -0.032084, -1.205565>, <-0.112911, -0.032084, -1.205565>, 
      <0.185715, 0.311252, -1.038307>, <0.000000, 0.311252, -1.038307>, <-0.260558, 0.153631, -1.121257>, <-0.260558, -0.032084, -1.121257>, 
      <0.000000, 0.311252, -1.038307>, <-0.185715, 0.311252, -1.038307>, <-0.337162, 0.153631, -1.038307>, <-0.337162, -0.032084, -1.038307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337162, -0.032084, -1.038307>, <0.337162, -0.217800, -1.038307>, <0.185715, -0.375420, -1.038307>, <0.000000, -0.375420, -1.038307>, 
      <0.337162, 0.153631, -1.038307>, <0.337162, -0.032084, -1.038307>, <0.185715, -0.296930, -1.121771>, <0.000000, -0.296930, -1.121771>, 
      <0.185715, 0.311252, -1.038307>, <0.185715, 0.232762, -1.121771>, <0.000000, -0.032084, -1.205565>, <0.000000, -0.146657, -1.205565>, 
      <0.000000, 0.311252, -1.038307>, <0.000000, 0.232762, -1.121771>, <0.000000, 0.082488, -1.205565>, <0.000000, -0.032084, -1.205565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337162, -0.032084, -1.038307>, <0.337162, 0.153631, -1.038307>, <0.185715, 0.311252, -1.038307>, <0.000000, 0.311252, -1.038307>, 
      <0.337162, -0.032084, -1.038307>, <0.260558, 0.153631, -1.121257>, <0.185715, 0.232762, -1.121771>, <0.000000, 0.232762, -1.121771>, 
      <0.337162, -0.032084, -1.038307>, <0.260558, 0.153631, -1.121257>, <0.112911, 0.082488, -1.205565>, <0.000000, 0.082488, -1.205565>, 
      <0.337162, -0.032084, -1.038307>, <0.260558, -0.032084, -1.121257>, <0.112911, -0.032084, -1.205565>, <0.000000, -0.032084, -1.205565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.335872, 0.007528, 0.971220>, <-0.259715, 0.007528, 1.045468>, <-0.110396, 0.007528, 1.110895>, <0.000000, 0.007528, 1.110895>, 
      <-0.335872, 0.007528, 0.971220>, <-0.259715, 0.185501, 1.045468>, <-0.110396, 0.115351, 1.110895>, <0.000000, 0.115351, 1.110895>, 
      <-0.335872, 0.007528, 0.971220>, <-0.259715, 0.185501, 1.045468>, <-0.185005, 0.261464, 1.045947>, <0.000000, 0.261464, 1.045947>, 
      <-0.335872, 0.007528, 0.971220>, <-0.335872, 0.185501, 0.971220>, <-0.185005, 0.336551, 0.971220>, <0.000000, 0.336551, 0.971220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.335872, 0.007528, 0.971220>, <-0.335872, 0.185501, 0.971220>, <-0.185005, 0.336551, 0.971220>, <0.000000, 0.336551, 0.971220>, 
      <-0.335872, -0.170445, 0.971220>, <-0.335872, 0.007528, 0.971220>, <-0.185005, 0.261464, 1.045947>, <0.000000, 0.261464, 1.045947>, 
      <-0.185005, -0.321495, 0.971220>, <-0.185005, -0.246408, 1.045947>, <0.000000, 0.007528, 1.110895>, <0.000000, 0.115351, 1.110895>, 
      <0.000000, -0.321495, 0.971220>, <0.000000, -0.246408, 1.045947>, <0.000000, -0.100295, 1.110895>, <0.000000, 0.007528, 1.110895>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.335872, 0.007528, 0.971220>, <-0.259715, 0.007528, 1.045468>, <-0.110396, 0.007528, 1.110895>, <0.000000, 0.007528, 1.110895>, 
      <-0.335872, 0.007528, 0.971220>, <-0.259715, -0.170445, 1.045468>, <-0.110396, -0.100295, 1.110895>, <0.000000, -0.100295, 1.110895>, 
      <-0.335872, 0.007528, 0.971220>, <-0.259715, -0.170445, 1.045468>, <-0.185005, -0.246408, 1.045947>, <0.000000, -0.246408, 1.045947>, 
      <-0.335872, 0.007528, 0.971220>, <-0.335872, -0.170445, 0.971220>, <-0.185005, -0.321495, 0.971220>, <0.000000, -0.321495, 0.971220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.335872, 0.007528, 0.971220>, <0.259715, 0.007528, 1.045468>, <0.110396, 0.007528, 1.110895>, <0.000000, 0.007528, 1.110895>, 
      <0.335872, 0.007528, 0.971220>, <0.259715, -0.170445, 1.045468>, <0.110396, -0.100295, 1.110895>, <0.000000, -0.100295, 1.110895>, 
      <0.335872, 0.007528, 0.971220>, <0.259715, -0.170445, 1.045468>, <0.185005, -0.246408, 1.045947>, <0.000000, -0.246408, 1.045947>, 
      <0.335872, 0.007528, 0.971220>, <0.335872, -0.170445, 0.971220>, <0.185005, -0.321495, 0.971220>, <0.000000, -0.321495, 0.971220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.335872, 0.007528, 0.971220>, <0.335872, -0.170445, 0.971220>, <0.185005, -0.321495, 0.971220>, <0.000000, -0.321495, 0.971220>, 
      <0.259715, 0.007528, 1.045468>, <0.259715, -0.170445, 1.045468>, <0.000000, -0.321495, 0.971220>, <-0.185005, -0.321495, 0.971220>, 
      <0.110396, 0.007528, 1.110895>, <0.000000, 0.007528, 1.110895>, <-0.259715, -0.170445, 1.045468>, <-0.335872, -0.170445, 0.971220>, 
      <0.000000, 0.007528, 1.110895>, <-0.110396, 0.007528, 1.110895>, <-0.259715, 0.007528, 1.045468>, <-0.335872, 0.007528, 0.971220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.335872, 0.007528, 0.971220>, <0.335872, -0.170445, 0.971220>, <0.185005, -0.321495, 0.971220>, <0.000000, -0.321495, 0.971220>, 
      <0.335872, 0.185501, 0.971220>, <0.335872, 0.007528, 0.971220>, <0.185005, -0.246408, 1.045947>, <0.000000, -0.246408, 1.045947>, 
      <0.185005, 0.336551, 0.971220>, <0.185005, 0.261464, 1.045947>, <0.000000, 0.007528, 1.110895>, <0.000000, -0.100295, 1.110895>, 
      <0.000000, 0.336551, 0.971220>, <0.000000, 0.261464, 1.045947>, <0.000000, 0.115351, 1.110895>, <0.000000, 0.007528, 1.110895>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.335872, 0.007528, 0.971220>, <0.259715, 0.007528, 1.045468>, <0.110396, 0.007528, 1.110895>, <0.000000, 0.007528, 1.110895>, 
      <0.335872, 0.007528, 0.971220>, <0.259715, 0.185501, 1.045468>, <0.110396, 0.115351, 1.110895>, <0.000000, 0.115351, 1.110895>, 
      <0.335872, 0.007528, 0.971220>, <0.259715, 0.185501, 1.045468>, <0.185005, 0.261464, 1.045947>, <0.000000, 0.261464, 1.045947>, 
      <0.335872, 0.007528, 0.971220>, <0.335872, 0.185501, 0.971220>, <0.185005, 0.336551, 0.971220>, <0.000000, 0.336551, 0.971220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.335872, 0.007528, 0.971220>, <0.259715, 0.007528, 1.045468>, <0.110396, 0.007528, 1.110895>, <0.000000, 0.007528, 1.110895>, 
      <0.335872, 0.185501, 0.971220>, <0.259715, 0.185501, 1.045468>, <0.000000, 0.007528, 1.110895>, <-0.110396, 0.007528, 1.110895>, 
      <0.185005, 0.336551, 0.971220>, <0.000000, 0.336551, 0.971220>, <-0.259715, 0.185501, 1.045468>, <-0.259715, 0.007528, 1.045468>, 
      <0.000000, 0.336551, 0.971220>, <-0.185005, 0.336551, 0.971220>, <-0.335872, 0.185501, 0.971220>, <-0.335872, 0.007528, 0.971220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.430385, -0.032084, -0.739525>, <0.426882, -0.032084, -0.833356>, <0.400865, -0.032084, -0.969326>, <0.337162, -0.032084, -1.038307>, 
      <0.430385, -0.269149, -0.739525>, <0.426882, -0.269149, -0.833356>, <0.400865, -0.217800, -0.969326>, <0.337162, -0.217800, -1.038307>, 
      <0.237064, -0.470350, -0.739525>, <0.237064, -0.475403, -0.833439>, <0.185715, -0.439851, -0.969793>, <0.185715, -0.375420, -1.038307>, 
      <0.000000, -0.470350, -0.739525>, <0.000000, -0.475403, -0.833439>, <0.000000, -0.439851, -0.969793>, <0.000000, -0.375420, -1.038307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.406182, -0.739525>, <0.000000, 0.411234, -0.833439>, <0.000000, 0.375682, -0.969793>, <0.000000, 0.311252, -1.038307>, 
      <0.237064, 0.406182, -0.739525>, <0.237064, 0.411234, -0.833439>, <0.185715, 0.375682, -0.969793>, <0.185715, 0.311252, -1.038307>, 
      <0.430385, 0.204980, -0.739525>, <0.426882, 0.204980, -0.833356>, <0.400865, 0.153631, -0.969326>, <0.337162, 0.153631, -1.038307>, 
      <0.430385, -0.032084, -0.739525>, <0.426882, -0.032084, -0.833356>, <0.400865, -0.032084, -0.969326>, <0.337162, -0.032084, -1.038307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.430385, -0.032084, -0.739525>, <-0.426882, -0.032084, -0.833356>, <-0.400865, -0.032084, -0.969326>, <-0.337162, -0.032084, -1.038307>, 
      <-0.430385, 0.204980, -0.739525>, <-0.426882, 0.204980, -0.833356>, <-0.400865, 0.153631, -0.969326>, <-0.337162, 0.153631, -1.038307>, 
      <-0.237064, 0.406182, -0.739525>, <-0.237064, 0.411234, -0.833439>, <-0.185715, 0.375682, -0.969793>, <-0.185715, 0.311252, -1.038307>, 
      <0.000000, 0.406182, -0.739525>, <0.000000, 0.411234, -0.833439>, <0.000000, 0.375682, -0.969793>, <0.000000, 0.311252, -1.038307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.430385, -0.032084, -0.739525>, <-0.430385, -0.269149, -0.739525>, <-0.237064, -0.470350, -0.739525>, <0.000000, -0.470350, -0.739525>, 
      <-0.426882, -0.032084, -0.833356>, <-0.426882, -0.269149, -0.833356>, <-0.237064, -0.475403, -0.833439>, <0.000000, -0.475403, -0.833439>, 
      <-0.400865, -0.032084, -0.969326>, <-0.400865, -0.217800, -0.969326>, <-0.185715, -0.439851, -0.969793>, <0.000000, -0.439851, -0.969793>, 
      <-0.337162, -0.032084, -1.038307>, <-0.337162, -0.217800, -1.038307>, <-0.185715, -0.375420, -1.038307>, <0.000000, -0.375420, -1.038307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.449054, -0.000523, 0.688650>, <0.449054, -0.238469, 0.688650>, <0.247347, -0.440420, 0.688650>, <0.000000, -0.440420, 0.688650>, 
      <0.443787, -0.000523, 0.783360>, <0.443787, -0.238469, 0.783360>, <0.247347, -0.444232, 0.783608>, <0.000000, -0.444232, 0.783608>, 
      <0.406294, -0.000523, 0.918114>, <0.406294, -0.178496, 0.918114>, <0.185005, -0.398072, 0.918571>, <0.000000, -0.398072, 0.918571>, 
      <0.335872, 0.007528, 0.971220>, <0.335872, -0.170445, 0.971220>, <0.185005, -0.321495, 0.971220>, <0.000000, -0.321495, 0.971220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.439374, 0.688650>, <0.247347, 0.439374, 0.688650>, <0.449054, 0.237423, 0.688650>, <0.449054, -0.000523, 0.688650>, 
      <0.000000, 0.443187, 0.783608>, <0.247347, 0.443187, 0.783608>, <0.443787, 0.237423, 0.783360>, <0.443787, -0.000523, 0.783360>, 
      <0.000000, 0.397026, 0.918571>, <0.185005, 0.397026, 0.918571>, <0.406294, 0.177450, 0.918114>, <0.406294, -0.000523, 0.918114>, 
      <0.000000, 0.336551, 0.971220>, <0.185005, 0.336551, 0.971220>, <0.335872, 0.185501, 0.971220>, <0.335872, 0.007528, 0.971220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.449054, -0.000523, 0.688650>, <-0.449054, 0.237423, 0.688650>, <-0.247347, 0.439374, 0.688650>, <0.000000, 0.439374, 0.688650>, 
      <-0.443787, -0.000523, 0.783360>, <-0.443787, 0.237423, 0.783360>, <-0.247347, 0.443187, 0.783608>, <0.000000, 0.443187, 0.783608>, 
      <-0.406294, -0.000523, 0.918114>, <-0.406294, 0.177450, 0.918114>, <-0.185005, 0.397026, 0.918571>, <0.000000, 0.397026, 0.918571>, 
      <-0.335872, 0.007528, 0.971220>, <-0.335872, 0.185501, 0.971220>, <-0.185005, 0.336551, 0.971220>, <0.000000, 0.336551, 0.971220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.449054, -0.000523, 0.688650>, <-0.443787, -0.000523, 0.783360>, <-0.406294, -0.000523, 0.918114>, <-0.335872, 0.007528, 0.971220>, 
      <-0.449054, -0.238469, 0.688650>, <-0.443787, -0.238469, 0.783360>, <-0.406294, -0.178496, 0.918114>, <-0.335872, -0.170445, 0.971220>, 
      <-0.247347, -0.440420, 0.688650>, <-0.247347, -0.444232, 0.783608>, <-0.185005, -0.398072, 0.918571>, <-0.185005, -0.321495, 0.971220>, 
      <0.000000, -0.440420, 0.688650>, <0.000000, -0.444232, 0.783608>, <0.000000, -0.398072, 0.918571>, <0.000000, -0.321495, 0.971220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.376232, 0.000000, 0.000109>, <0.376232, -0.164402, 0.000109>, <0.164402, -0.287035, 0.000109>, <0.000000, -0.287035, 0.000109>, 
      <0.376232, 0.000000, 0.195112>, <0.376232, -0.164402, 0.195112>, <0.164402, -0.287035, 0.198576>, <0.000000, -0.287035, 0.198576>, 
      <0.461099, -0.000523, 0.472067>, <0.461099, -0.238469, 0.472067>, <0.247347, -0.431564, 0.468091>, <0.000000, -0.431564, 0.468091>, 
      <0.449054, -0.000523, 0.688650>, <0.449054, -0.238469, 0.688650>, <0.247347, -0.440420, 0.688650>, <0.000000, -0.440420, 0.688650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.376232, 0.000000, 0.000109>, <0.376232, 0.000000, -0.195893>, <0.438775, 0.000000, -0.522818>, <0.430385, -0.032084, -0.739525>, 
      <0.376232, -0.164402, 0.000109>, <0.376232, -0.164402, -0.195893>, <0.438775, -0.237064, -0.522818>, <0.430385, -0.269149, -0.739525>, 
      <0.164402, -0.287035, 0.000109>, <0.164402, -0.287035, -0.199340>, <0.237064, -0.425972, -0.519038>, <0.237064, -0.470350, -0.739525>, 
      <0.000000, -0.287035, 0.000109>, <0.000000, -0.287035, -0.199340>, <0.000000, -0.425972, -0.519038>, <0.000000, -0.470350, -0.739525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.287035, 0.000109>, <0.000000, 0.287035, -0.199340>, <0.000000, 0.425972, -0.519038>, <0.000000, 0.406182, -0.739525>, 
      <0.164402, 0.287035, 0.000109>, <0.164402, 0.287035, -0.199340>, <0.237064, 0.425972, -0.519038>, <0.237064, 0.406182, -0.739525>, 
      <0.376232, 0.164402, 0.000109>, <0.376232, 0.164402, -0.195893>, <0.438775, 0.237064, -0.522818>, <0.430385, 0.204980, -0.739525>, 
      <0.376232, 0.000000, 0.000109>, <0.376232, 0.000000, -0.195893>, <0.438775, 0.000000, -0.522818>, <0.430385, -0.032084, -0.739525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.287035, 0.000109>, <0.164402, 0.287035, 0.000109>, <0.376232, 0.164402, 0.000109>, <0.376232, 0.000000, 0.000109>, 
      <0.000000, 0.287035, 0.198576>, <0.164402, 0.287035, 0.198576>, <0.376232, 0.164402, 0.195112>, <0.376232, 0.000000, 0.195112>, 
      <0.000000, 0.430518, 0.468091>, <0.247347, 0.430518, 0.468091>, <0.461099, 0.237423, 0.472067>, <0.461099, -0.000523, 0.472067>, 
      <0.000000, 0.439374, 0.688650>, <0.247347, 0.439374, 0.688650>, <0.449054, 0.237423, 0.688650>, <0.449054, -0.000523, 0.688650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.376232, 0.000000, 0.000109>, <-0.376232, 0.000000, -0.195893>, <-0.438775, 0.000000, -0.522818>, <-0.430385, -0.032084, -0.739525>, 
      <-0.376232, 0.164402, 0.000109>, <-0.376232, 0.164402, -0.195893>, <-0.438775, 0.237064, -0.522818>, <-0.430385, 0.204980, -0.739525>, 
      <-0.164402, 0.287035, 0.000109>, <-0.164402, 0.287035, -0.199340>, <-0.237064, 0.425972, -0.519038>, <-0.237064, 0.406182, -0.739525>, 
      <0.000000, 0.287035, 0.000109>, <0.000000, 0.287035, -0.199340>, <0.000000, 0.425972, -0.519038>, <0.000000, 0.406182, -0.739525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.376232, 0.000000, 0.000109>, <-0.376232, 0.164402, 0.000109>, <-0.164402, 0.287035, 0.000109>, <0.000000, 0.287035, 0.000109>, 
      <-0.376232, 0.000000, 0.195112>, <-0.376232, 0.164402, 0.195112>, <-0.164402, 0.287035, 0.198576>, <0.000000, 0.287035, 0.198576>, 
      <-0.461099, -0.000523, 0.472067>, <-0.461099, 0.237423, 0.472067>, <-0.247347, 0.430518, 0.468091>, <0.000000, 0.430518, 0.468091>, 
      <-0.449054, -0.000523, 0.688650>, <-0.449054, 0.237423, 0.688650>, <-0.247347, 0.439374, 0.688650>, <0.000000, 0.439374, 0.688650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.376232, 0.000000, 0.000109>, <-0.376232, 0.000000, 0.195112>, <-0.461099, -0.000523, 0.472067>, <-0.449054, -0.000523, 0.688650>, 
      <-0.376232, -0.164402, 0.000109>, <-0.376232, -0.164402, 0.195112>, <-0.461099, -0.238469, 0.472067>, <-0.449054, -0.238469, 0.688650>, 
      <-0.164402, -0.287035, 0.000109>, <-0.164402, -0.287035, 0.198576>, <-0.247347, -0.431564, 0.468091>, <-0.247347, -0.440420, 0.688650>, 
      <0.000000, -0.287035, 0.000109>, <0.000000, -0.287035, 0.198576>, <0.000000, -0.431564, 0.468091>, <0.000000, -0.440420, 0.688650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.376232, 0.000000, 0.000109>, <-0.376232, -0.164402, 0.000109>, <-0.164402, -0.287035, 0.000109>, <0.000000, -0.287035, 0.000109>, 
      <-0.376232, 0.000000, -0.195893>, <-0.376232, -0.164402, -0.195893>, <-0.164402, -0.287035, -0.199340>, <0.000000, -0.287035, -0.199340>, 
      <-0.438775, 0.000000, -0.522818>, <-0.438775, -0.237064, -0.522818>, <-0.237064, -0.425972, -0.519038>, <0.000000, -0.425972, -0.519038>, 
      <-0.430385, -0.032084, -0.739525>, <-0.430385, -0.269149, -0.739525>, <-0.237064, -0.470350, -0.739525>, <0.000000, -0.470350, -0.739525>
    }
  }
  scale <75.0, 75.0, 81.800003>
  rotate -68.0*x
  translate  <-7.1, -393.8, -33.2>
}
#declare LeftLeftJoiners = union {
  object { // LegJoiner6->LegJoiner4
    LegJoiner4
    rotate -0.0*z
    translate  <6.7, -112.4, -55.2>
  }
  object { // LegJoiner5->LegJoiner4
    LegJoiner4
    rotate -0.0*z
    translate  <6.3, -59.6, -38.6>
  }
  object { LegJoiner4 }
}
#declare Thorax = union {
  object { RightLegJoiners }
  object { MainThorax }
  object { LeftLeftJoiners }
}
#declare RightMandible = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.119414, -0.282448, 0.333704>, <0.082525, -0.313349, 0.339179>, <0.033339, -0.354550, 0.346479>, <-0.003551, -0.385450, 0.351954>, 
      <0.119414, -0.282448, 0.333704>, <0.156895, -0.315241, 0.287847>, <0.144599, -0.325541, 0.289672>, <0.107710, -0.356442, 0.295147>, 
      <0.119414, -0.282448, 0.333704>, <0.156895, -0.315241, 0.287847>, <0.181686, -0.315872, 0.270736>, <0.256057, -0.317763, 0.219404>, 
      <0.119414, -0.282448, 0.333704>, <0.193785, -0.284340, 0.282372>, <0.292946, -0.286863, 0.213929>, <0.367317, -0.288754, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.381810, -0.275512, -0.174743>, <0.266202, -0.308494, -0.016733>, <0.112057, -0.352469, 0.193945>, <-0.003551, -0.385450, 0.351954>, 
      <0.381810, -0.275512, -0.174743>, <0.187483, -0.310575, 0.135801>, <0.148947, -0.321568, 0.188470>, <0.033339, -0.354550, 0.346479>, 
      <0.381810, -0.275512, -0.174743>, <0.187483, -0.310575, 0.135801>, <0.161243, -0.311268, 0.186645>, <0.082525, -0.313349, 0.339179>, 
      <0.381810, -0.275512, -0.174743>, <0.303091, -0.277593, -0.022208>, <0.198133, -0.280368, 0.181170>, <0.119414, -0.282448, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.381810, -0.275512, -0.174743>, <0.266202, -0.308494, -0.016733>, <0.112057, -0.352469, 0.193945>, <-0.003551, -0.385450, 0.351954>, 
      <0.303091, -0.277593, -0.022208>, <0.187483, -0.310575, 0.135801>, <0.223318, -0.323460, 0.137138>, <0.107710, -0.356442, 0.295147>, 
      <0.198133, -0.280368, 0.181170>, <0.272504, -0.282259, 0.129838>, <0.181686, -0.315872, 0.270736>, <0.256057, -0.317763, 0.219404>, 
      <0.119414, -0.282448, 0.333704>, <0.193785, -0.284340, 0.282372>, <0.292946, -0.286863, 0.213929>, <0.367317, -0.288754, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.118375, -0.266684, -0.023603>, <0.081797, -0.302314, 0.089065>, <0.033027, -0.349820, 0.239287>, <-0.003551, -0.385450, 0.351954>, 
      <0.118375, -0.266684, -0.023603>, <0.160828, -0.304962, 0.043722>, <0.148635, -0.316839, 0.081278>, <0.112057, -0.352469, 0.193945>, 
      <0.118375, -0.266684, -0.023603>, <0.160828, -0.304962, 0.043722>, <0.187171, -0.305845, 0.028608>, <0.266202, -0.308494, -0.016733>, 
      <0.118375, -0.266684, -0.023603>, <0.197406, -0.269332, -0.068945>, <0.302780, -0.272864, -0.129401>, <0.381810, -0.275512, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.118375, -0.266684, -0.023603>, <0.197406, -0.269332, -0.068945>, <0.302780, -0.272864, -0.129401>, <0.381810, -0.275512, -0.174743>, 
      <0.081797, -0.302314, 0.089065>, <0.160828, -0.304962, 0.043722>, <0.224061, -0.274945, 0.023134>, <0.303091, -0.277593, -0.022208>, 
      <0.033027, -0.349820, 0.239287>, <0.069916, -0.318920, 0.233812>, <0.161243, -0.311268, 0.186645>, <0.198133, -0.280368, 0.181170>, 
      <-0.003551, -0.385450, 0.351954>, <0.033339, -0.354550, 0.346479>, <0.082525, -0.313349, 0.339179>, <0.119414, -0.282448, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.292952, -0.257856, -0.517748>, <0.204001, -0.296134, -0.256837>, <0.085400, -0.347172, 0.091044>, <-0.003551, -0.385450, 0.351954>, 
      <0.292952, -0.257856, -0.517748>, <0.151628, -0.298782, -0.108594>, <0.121978, -0.311542, -0.021623>, <0.033027, -0.349820, 0.239287>, 
      <0.292952, -0.257856, -0.517748>, <0.151628, -0.298782, -0.108594>, <0.134170, -0.299665, -0.059179>, <0.081797, -0.302314, 0.089065>, 
      <0.292952, -0.257856, -0.517748>, <0.240579, -0.260504, -0.369504>, <0.170748, -0.264035, -0.171846>, <0.118375, -0.266684, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.292952, -0.257856, -0.517748>, <0.240579, -0.260504, -0.369504>, <0.170748, -0.264035, -0.171846>, <0.118375, -0.266684, -0.023603>, 
      <0.204001, -0.296134, -0.256837>, <0.151628, -0.298782, -0.108594>, <0.249779, -0.266684, -0.217188>, <0.197406, -0.269332, -0.068945>, 
      <0.085400, -0.347172, 0.091044>, <0.201008, -0.314191, -0.066965>, <0.187171, -0.305845, 0.028608>, <0.302780, -0.272864, -0.129401>, 
      <-0.003551, -0.385450, 0.351954>, <0.112057, -0.352469, 0.193945>, <0.266202, -0.308494, -0.016733>, <0.381810, -0.275512, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.501037, -0.276143, -0.103274>, <-0.351795, -0.318240, 0.030724>, <-0.152797, -0.352658, 0.215386>, <-0.003551, -0.385450, 0.351954>, 
      <-0.501037, -0.276143, -0.103274>, <-0.399340, -0.325226, 0.189050>, <-0.310626, -0.327149, 0.243892>, <-0.161380, -0.359942, 0.380461>, 
      <-0.501037, -0.276143, -0.103274>, <-0.399340, -0.325226, 0.189050>, <-0.409916, -0.328545, 0.265060>, <-0.372501, -0.335650, 0.426076>, 
      <-0.501037, -0.276143, -0.103274>, <-0.548581, -0.283128, 0.055052>, <-0.567064, -0.293316, 0.285960>, <-0.529649, -0.300420, 0.446975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.229220, -0.256279, -0.553478>, <-0.154457, -0.305313, -0.285384>, <-0.071252, -0.346699, 0.080325>, <-0.003551, -0.385450, 0.351954>, 
      <-0.229220, -0.256279, -0.553478>, <-0.252352, -0.310773, -0.161637>, <-0.220497, -0.313907, -0.056244>, <-0.152797, -0.352658, 0.215386>, 
      <-0.229220, -0.256279, -0.553478>, <-0.252352, -0.310773, -0.161637>, <-0.306428, -0.311574, -0.120352>, <-0.351795, -0.318240, 0.030724>, 
      <-0.229220, -0.256279, -0.553478>, <-0.327115, -0.261739, -0.429731>, <-0.455670, -0.269477, -0.254350>, <-0.501037, -0.276143, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.229220, -0.256279, -0.553478>, <-0.154457, -0.305313, -0.285384>, <-0.071252, -0.346699, 0.080325>, <-0.003551, -0.385450, 0.351954>, 
      <-0.327115, -0.261739, -0.429731>, <-0.252352, -0.310773, -0.161637>, <-0.229081, -0.321190, 0.108831>, <-0.161380, -0.359942, 0.380461>, 
      <-0.455670, -0.269477, -0.254350>, <-0.503214, -0.276462, -0.096024>, <-0.409916, -0.328545, 0.265060>, <-0.372501, -0.335650, 0.426076>, 
      <-0.501037, -0.276143, -0.103274>, <-0.548581, -0.283128, 0.055052>, <-0.567064, -0.293316, 0.285960>, <-0.529649, -0.300420, 0.446975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.199962, -0.237046, -0.989390>, <0.138908, -0.281568, -0.586986>, <0.057503, -0.340929, -0.050449>, <-0.003551, -0.385450, 0.351954>, 
      <0.199962, -0.237046, -0.989390>, <0.166805, -0.287810, -0.445494>, <0.146454, -0.302651, -0.311359>, <0.085400, -0.347172, 0.091044>, 
      <0.199962, -0.237046, -0.989390>, <0.166805, -0.287810, -0.445494>, <0.176104, -0.289891, -0.398330>, <0.204001, -0.296134, -0.256837>, 
      <0.199962, -0.237046, -0.989390>, <0.227859, -0.243289, -0.847897>, <0.265055, -0.251613, -0.659240>, <0.292952, -0.257856, -0.517748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.199962, -0.237046, -0.989390>, <0.227859, -0.243289, -0.847897>, <0.265055, -0.251613, -0.659240>, <0.292952, -0.257856, -0.517748>, 
      <0.138908, -0.281568, -0.586986>, <0.166805, -0.287810, -0.445494>, <0.212682, -0.254261, -0.510997>, <0.240579, -0.260504, -0.369504>, 
      <0.057503, -0.340929, -0.050449>, <0.094081, -0.305299, -0.163116>, <0.134170, -0.299665, -0.059179>, <0.170748, -0.264035, -0.171846>, 
      <-0.003551, -0.385450, 0.351954>, <0.033027, -0.349820, 0.239287>, <0.081797, -0.302314, 0.089065>, <0.118375, -0.266684, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.199962, -0.237046, -0.989390>, <0.227859, -0.243289, -0.847897>, <0.265055, -0.251613, -0.659240>, <0.292952, -0.257856, -0.517748>, 
      <0.071208, -0.242816, -0.858616>, <0.099104, -0.249059, -0.717123>, <0.176104, -0.289891, -0.398330>, <0.204001, -0.296134, -0.256837>, 
      <-0.115371, -0.249930, -0.697391>, <-0.040608, -0.298964, -0.429298>, <0.017699, -0.308421, -0.180586>, <0.085400, -0.347172, 0.091044>, 
      <-0.229220, -0.256279, -0.553478>, <-0.154457, -0.305313, -0.285384>, <-0.071252, -0.346699, 0.080325>, <-0.003551, -0.385450, 0.351954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.199962, -0.237046, -0.989390>, <0.138908, -0.281568, -0.586986>, <0.057503, -0.340929, -0.050449>, <-0.003551, -0.385450, 0.351954>, 
      <0.199962, -0.237046, -0.989390>, <0.010153, -0.287338, -0.456213>, <-0.010198, -0.302178, -0.322078>, <-0.071252, -0.346699, 0.080325>, 
      <0.199962, -0.237046, -0.989390>, <0.010153, -0.287338, -0.456213>, <-0.040608, -0.298964, -0.429298>, <-0.154457, -0.305313, -0.285384>, 
      <0.199962, -0.237046, -0.989390>, <0.071208, -0.242816, -0.858616>, <-0.115371, -0.249930, -0.697391>, <-0.229220, -0.256279, -0.553478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.199962, -0.237046, -0.989390>, <0.138908, -0.281568, -0.586986>, <0.057503, -0.340929, -0.050449>, <-0.003551, -0.385450, 0.351954>, 
      <0.071208, -0.242816, -0.858616>, <0.010153, -0.287338, -0.456213>, <-0.091743, -0.308137, -0.187017>, <-0.152797, -0.352658, 0.215386>, 
      <-0.115371, -0.249930, -0.697391>, <-0.213267, -0.255390, -0.573644>, <-0.306428, -0.311574, -0.120352>, <-0.351795, -0.318240, 0.030724>, 
      <-0.229220, -0.256279, -0.553478>, <-0.327115, -0.261739, -0.429731>, <-0.455670, -0.269477, -0.254350>, <-0.501037, -0.276143, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.222067, -0.329112, 1.097271>, <-0.244999, -0.320295, 1.163440>, <-0.320791, -0.281549, 1.272466>, <-0.330181, -0.259860, 1.294427>, 
      <-0.432329, -0.326936, 1.047940>, <-0.455261, -0.318119, 1.114109>, <-0.276001, -0.298771, 1.143227>, <-0.285391, -0.277081, 1.165188>, 
      <-0.480809, -0.309694, 0.657159>, <-0.323661, -0.344923, 0.636259>, <-0.259369, -0.322264, 0.663203>, <-0.101540, -0.347773, 0.634696>, 
      <-0.529649, -0.300420, 0.446975>, <-0.372501, -0.335650, 0.426076>, <-0.161380, -0.359942, 0.380461>, <-0.003551, -0.385450, 0.351954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.222067, -0.329112, 1.097271>, <-0.146166, -0.358297, 0.878262>, <-0.069106, -0.368549, 0.575550>, <-0.003551, -0.385450, 0.351954>, 
      <-0.222067, -0.329112, 1.097271>, <-0.356427, -0.356120, 0.828930>, <-0.226935, -0.343040, 0.604056>, <-0.161380, -0.359942, 0.380461>, 
      <-0.222067, -0.329112, 1.097271>, <-0.356427, -0.356120, 0.828930>, <-0.323661, -0.344923, 0.636259>, <-0.372501, -0.335650, 0.426076>, 
      <-0.222067, -0.329112, 1.097271>, <-0.432329, -0.326936, 1.047940>, <-0.480809, -0.309694, 0.657159>, <-0.529649, -0.300420, 0.446975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.222067, -0.329112, 1.097271>, <-0.146166, -0.358297, 0.878262>, <-0.069106, -0.368549, 0.575550>, <-0.003551, -0.385450, 0.351954>, 
      <-0.432329, -0.326936, 1.047940>, <-0.356427, -0.356120, 0.828930>, <-0.218352, -0.335757, 0.438981>, <-0.152797, -0.352658, 0.215386>, 
      <-0.480809, -0.309694, 0.657159>, <-0.518224, -0.302590, 0.496143>, <-0.399340, -0.325226, 0.189050>, <-0.351795, -0.318240, 0.030724>, 
      <-0.529649, -0.300420, 0.446975>, <-0.567064, -0.293316, 0.285960>, <-0.548581, -0.283128, 0.055052>, <-0.501037, -0.276143, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.118375, 0.266882, -0.023603>, <0.085624, 0.299418, 0.086336>, <0.041955, 0.342799, 0.232921>, <0.009203, 0.375335, 0.342859>, 
      <0.118375, 0.266882, -0.023603>, <0.164654, 0.302066, 0.040994>, <0.153737, 0.312912, 0.077640>, <0.120986, 0.345447, 0.187579>, 
      <0.118375, 0.266882, -0.023603>, <0.164654, 0.302066, 0.040994>, <0.190998, 0.302949, 0.025880>, <0.270029, 0.305598, -0.019462>, 
      <0.118375, 0.266882, -0.023603>, <0.197406, 0.269530, -0.068945>, <0.302780, 0.273062, -0.129401>, <0.381811, 0.275711, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.292953, 0.258054, -0.517748>, <0.207828, 0.293238, -0.259566>, <0.094328, 0.340150, 0.084677>, <0.009203, 0.375335, 0.342859>, 
      <0.292953, 0.258054, -0.517748>, <0.155455, 0.295886, -0.111322>, <0.127080, 0.307614, -0.025261>, <0.041955, 0.342799, 0.232921>, 
      <0.292953, 0.258054, -0.517748>, <0.155455, 0.295886, -0.111322>, <0.137997, 0.296769, -0.061907>, <0.085624, 0.299418, 0.086336>, 
      <0.292953, 0.258054, -0.517748>, <0.240580, 0.260702, -0.369504>, <0.170749, 0.264233, -0.171846>, <0.118375, 0.266882, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.292953, 0.258054, -0.517748>, <0.207828, 0.293238, -0.259566>, <0.094328, 0.340150, 0.084677>, <0.009203, 0.375335, 0.342859>, 
      <0.240580, 0.260702, -0.369504>, <0.155455, 0.295886, -0.111322>, <0.206111, 0.310263, -0.070603>, <0.120986, 0.345447, 0.187579>, 
      <0.170749, 0.264233, -0.171846>, <0.249779, 0.266882, -0.217188>, <0.190998, 0.302949, 0.025880>, <0.270029, 0.305598, -0.019462>, 
      <0.118375, 0.266882, -0.023603>, <0.197406, 0.269530, -0.068945>, <0.302780, 0.273062, -0.129401>, <0.381811, 0.275711, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.119414, 0.282647, 0.333704>, <0.086351, 0.310453, 0.336451>, <0.042266, 0.347528, 0.340113>, <0.009203, 0.375335, 0.342859>, 
      <0.119414, 0.282647, 0.333704>, <0.165070, 0.308372, 0.183917>, <0.154049, 0.317641, 0.184832>, <0.120986, 0.345447, 0.187579>, 
      <0.119414, 0.282647, 0.333704>, <0.165070, 0.308372, 0.183917>, <0.191310, 0.307679, 0.133072>, <0.270029, 0.305598, -0.019462>, 
      <0.119414, 0.282647, 0.333704>, <0.198133, 0.280566, 0.181170>, <0.303092, 0.277791, -0.022208>, <0.381811, 0.275711, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.119414, 0.282647, 0.333704>, <0.198133, 0.280566, 0.181170>, <0.303092, 0.277791, -0.022208>, <0.381811, 0.275711, -0.174743>, 
      <0.086351, 0.310453, 0.336451>, <0.165070, 0.308372, 0.183917>, <0.224061, 0.275143, 0.023134>, <0.302780, 0.273062, -0.129401>, 
      <0.042266, 0.347528, 0.340113>, <0.075018, 0.314992, 0.230174>, <0.164654, 0.302066, 0.040994>, <0.197406, 0.269530, -0.068945>, 
      <0.009203, 0.375335, 0.342859>, <0.041955, 0.342799, 0.232921>, <0.085624, 0.299418, 0.086336>, <0.118375, 0.266882, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.367317, 0.288953, 0.162596>, <0.259883, 0.314867, 0.216675>, <0.116637, 0.349420, 0.288781>, <0.009203, 0.375335, 0.342859>, 
      <0.367317, 0.288953, 0.162596>, <0.185512, 0.312975, 0.268008>, <0.149701, 0.321614, 0.286034>, <0.042266, 0.347528, 0.340113>, 
      <0.367317, 0.288953, 0.162596>, <0.185512, 0.312975, 0.268008>, <0.160722, 0.312345, 0.285119>, <0.086351, 0.310453, 0.336451>, 
      <0.367317, 0.288953, 0.162596>, <0.292946, 0.287061, 0.213929>, <0.193785, 0.284538, 0.282372>, <0.119414, 0.282647, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.367317, 0.288953, 0.162596>, <0.292946, 0.287061, 0.213929>, <0.193785, 0.284538, 0.282372>, <0.119414, 0.282647, 0.333704>, 
      <0.259883, 0.314867, 0.216675>, <0.185512, 0.312975, 0.268008>, <0.272504, 0.282458, 0.129838>, <0.198133, 0.280566, 0.181170>, 
      <0.116637, 0.349420, 0.288781>, <0.228420, 0.319533, 0.133500>, <0.191310, 0.307679, 0.133072>, <0.303092, 0.277791, -0.022208>, 
      <0.009203, 0.375335, 0.342859>, <0.120986, 0.345447, 0.187579>, <0.270029, 0.305598, -0.019462>, <0.381811, 0.275711, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.199963, 0.237245, -0.989390>, <0.142735, 0.278672, -0.589715>, <0.066431, 0.333908, -0.056815>, <0.009203, 0.375335, 0.342859>, 
      <0.199963, 0.237245, -0.989390>, <0.170632, 0.284914, -0.448222>, <0.151556, 0.298723, -0.314997>, <0.094328, 0.340150, 0.084677>, 
      <0.199963, 0.237245, -0.989390>, <0.170632, 0.284914, -0.448222>, <0.179931, 0.286995, -0.401058>, <0.207828, 0.293238, -0.259566>, 
      <0.199963, 0.237245, -0.989390>, <0.227860, 0.243487, -0.847897>, <0.265056, 0.251811, -0.659240>, <0.292953, 0.258054, -0.517748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.199963, 0.237245, -0.989390>, <0.142735, 0.278672, -0.589715>, <0.066431, 0.333908, -0.056815>, <0.009203, 0.375335, 0.342859>, 
      <0.227860, 0.243487, -0.847897>, <0.170632, 0.284914, -0.448222>, <0.099183, 0.301372, -0.166754>, <0.041955, 0.342799, 0.232921>, 
      <0.265056, 0.251811, -0.659240>, <0.212683, 0.254459, -0.510997>, <0.137997, 0.296769, -0.061907>, <0.085624, 0.299418, 0.086336>, 
      <0.292953, 0.258054, -0.517748>, <0.240580, 0.260702, -0.369504>, <0.170749, 0.264233, -0.171846>, <0.118375, 0.266882, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.229220, 0.256478, -0.553478>, <-0.151840, 0.304638, -0.288170>, <-0.062324, 0.339678, 0.073958>, <0.009203, 0.375335, 0.342859>, 
      <-0.229220, 0.256478, -0.553478>, <-0.037992, 0.298288, -0.432083>, <-0.005096, 0.298250, -0.325716>, <0.066431, 0.333908, -0.056815>, 
      <-0.229220, 0.256478, -0.553478>, <-0.037992, 0.298288, -0.432083>, <0.013980, 0.284442, -0.458941>, <0.142735, 0.278672, -0.589715>, 
      <-0.229220, 0.256478, -0.553478>, <-0.115371, 0.250128, -0.697391>, <0.071208, 0.243014, -0.858616>, <0.199963, 0.237245, -0.989390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.229220, 0.256478, -0.553478>, <-0.151840, 0.304638, -0.288170>, <-0.062324, 0.339678, 0.073958>, <0.009203, 0.375335, 0.342859>, 
      <-0.115371, 0.250128, -0.697391>, <-0.037992, 0.298288, -0.432083>, <0.022801, 0.304493, -0.184224>, <0.094328, 0.340150, 0.084677>, 
      <0.071208, 0.243014, -0.858616>, <0.099105, 0.249257, -0.717123>, <0.179931, 0.286995, -0.401058>, <0.207828, 0.293238, -0.259566>, 
      <0.199963, 0.237245, -0.989390>, <0.227860, 0.243487, -0.847897>, <0.265056, 0.251811, -0.659240>, <0.292953, 0.258054, -0.517748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.501036, 0.276341, -0.103274>, <-0.349075, 0.317712, 0.028720>, <-0.143869, 0.345636, 0.209020>, <0.009203, 0.375335, 0.342859>, 
      <-0.501036, 0.276341, -0.103274>, <-0.303708, 0.311046, -0.122356>, <-0.215396, 0.309979, -0.059882>, <-0.062324, 0.339678, 0.073958>, 
      <-0.501036, 0.276341, -0.103274>, <-0.303708, 0.311046, -0.122356>, <-0.249736, 0.310098, -0.164423>, <-0.151840, 0.304638, -0.288170>, 
      <-0.501036, 0.276341, -0.103274>, <-0.455669, 0.269675, -0.254350>, <-0.327115, 0.261937, -0.429731>, <-0.229220, 0.256478, -0.553478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.501036, 0.276341, -0.103274>, <-0.349075, 0.317712, 0.028720>, <-0.143869, 0.345636, 0.209020>, <0.009203, 0.375335, 0.342859>, 
      <-0.455669, 0.269675, -0.254350>, <-0.303708, 0.311046, -0.122356>, <-0.086641, 0.304209, -0.190655>, <0.066431, 0.333908, -0.056815>, 
      <-0.327115, 0.261937, -0.429731>, <-0.213267, 0.255588, -0.573644>, <0.013980, 0.284442, -0.458941>, <0.142735, 0.278672, -0.589715>, 
      <-0.229220, 0.256478, -0.553478>, <-0.115371, 0.250128, -0.697391>, <0.071208, 0.243014, -0.858616>, <0.199963, 0.237245, -0.989390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.414554, 0.310393, 0.668505>, <0.292949, 0.329875, 0.570812>, <0.130808, 0.355852, 0.440553>, <0.009203, 0.375335, 0.342859>, 
      <0.414554, 0.310393, 0.668505>, <0.278778, 0.323443, 0.419039>, <0.238243, 0.329937, 0.386474>, <0.116637, 0.349420, 0.288781>, 
      <0.414554, 0.310393, 0.668505>, <0.278778, 0.323443, 0.419039>, <0.274054, 0.321299, 0.368448>, <0.259883, 0.314867, 0.216675>, 
      <0.414554, 0.310393, 0.668505>, <0.400383, 0.303961, 0.516733>, <0.381488, 0.295385, 0.314369>, <0.367317, 0.288953, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.414554, 0.310393, 0.668505>, <0.400383, 0.303961, 0.516733>, <0.381488, 0.295385, 0.314369>, <0.367317, 0.288953, 0.162596>, 
      <0.292949, 0.329875, 0.570812>, <0.278778, 0.323443, 0.419039>, <0.307117, 0.293493, 0.365702>, <0.292946, 0.287061, 0.213929>, 
      <0.130808, 0.355852, 0.440553>, <0.163872, 0.328046, 0.437807>, <0.160722, 0.312345, 0.285119>, <0.193785, 0.284538, 0.282372>, 
      <0.009203, 0.375335, 0.342859>, <0.042266, 0.347528, 0.340113>, <0.086351, 0.310453, 0.336451>, <0.119414, 0.282647, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.222067, 0.329310, 1.097271>, <-0.142988, 0.357804, 0.875548>, <-0.060178, 0.361527, 0.569183>, <0.009203, 0.375335, 0.342859>, 
      <-0.222067, 0.329310, 1.097271>, <0.081245, 0.360125, 0.928158>, <0.061427, 0.342044, 0.666877>, <0.130808, 0.355852, 0.440553>, 
      <-0.222067, 0.329310, 1.097271>, <0.081245, 0.360125, 0.928158>, <0.101963, 0.335550, 0.699441>, <0.292949, 0.329875, 0.570812>, 
      <-0.222067, 0.329310, 1.097271>, <0.002166, 0.331631, 1.149881>, <0.223568, 0.316068, 0.797135>, <0.414554, 0.310393, 0.668505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.222067, 0.329310, 1.097271>, <0.002166, 0.331631, 1.149881>, <0.223568, 0.316068, 0.797135>, <0.414554, 0.310393, 0.668505>, 
      <-0.142988, 0.357804, 0.875548>, <0.081245, 0.360125, 0.928158>, <0.209397, 0.309636, 0.645362>, <0.400383, 0.303961, 0.516733>, 
      <-0.060178, 0.361527, 0.569183>, <0.047256, 0.335612, 0.515104>, <0.274054, 0.321299, 0.368448>, <0.381488, 0.295385, 0.314369>, 
      <0.009203, 0.375335, 0.342859>, <0.116637, 0.349420, 0.288781>, <0.259883, 0.314867, 0.216675>, <0.367317, 0.288953, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.529648, 0.300619, 0.446975>, <-0.368788, 0.335339, 0.423973>, <-0.152452, 0.352920, 0.374094>, <0.009203, 0.375335, 0.342859>, 
      <-0.529648, 0.300619, 0.446975>, <-0.406203, 0.328235, 0.262957>, <-0.305524, 0.323222, 0.240254>, <-0.143869, 0.345636, 0.209020>, 
      <-0.529648, 0.300619, 0.446975>, <-0.406203, 0.328235, 0.262957>, <-0.396619, 0.324697, 0.187046>, <-0.349075, 0.317712, 0.028720>, 
      <-0.529648, 0.300619, 0.446975>, <-0.567063, 0.293515, 0.285960>, <-0.548580, 0.283326, 0.055052>, <-0.501036, 0.276341, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.529648, 0.300619, 0.446975>, <-0.368788, 0.335339, 0.423973>, <-0.152452, 0.352920, 0.374094>, <0.009203, 0.375335, 0.342859>, 
      <-0.567063, 0.293515, 0.285960>, <-0.406203, 0.328235, 0.262957>, <-0.223979, 0.317263, 0.105193>, <-0.062324, 0.339678, 0.073958>, 
      <-0.548580, 0.283326, 0.055052>, <-0.503213, 0.276660, -0.096024>, <-0.249736, 0.310098, -0.164423>, <-0.151840, 0.304638, -0.288170>, 
      <-0.501036, 0.276341, -0.103274>, <-0.455669, 0.269675, -0.254350>, <-0.327115, 0.261937, -0.429731>, <-0.229220, 0.256478, -0.553478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.529648, 0.300619, 0.446975>, <-0.368788, 0.335339, 0.423973>, <-0.152452, 0.352920, 0.374094>, <0.009203, 0.375335, 0.342859>, 
      <-0.529648, 0.300619, 0.446975>, <-0.319948, 0.344613, 0.634156>, <-0.221833, 0.339112, 0.600418>, <-0.060178, 0.361527, 0.569183>, 
      <-0.529648, 0.300619, 0.446975>, <-0.319948, 0.344613, 0.634156>, <-0.353249, 0.355627, 0.826216>, <-0.142988, 0.357804, 0.875548>, 
      <-0.529648, 0.300619, 0.446975>, <-0.480808, 0.309892, 0.657158>, <-0.432329, 0.327133, 1.047940>, <-0.222067, 0.329310, 1.097271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.529648, 0.300619, 0.446975>, <-0.480808, 0.309892, 0.657158>, <-0.432329, 0.327133, 1.047940>, <-0.222067, 0.329310, 1.097271>, 
      <-0.567063, 0.293515, 0.285960>, <-0.518223, 0.302788, 0.496143>, <-0.353249, 0.355627, 0.826216>, <-0.142988, 0.357804, 0.875548>, 
      <-0.548580, 0.283326, 0.055052>, <-0.396619, 0.324697, 0.187046>, <-0.213250, 0.331829, 0.435343>, <-0.060178, 0.361527, 0.569183>, 
      <-0.501036, 0.276341, -0.103274>, <-0.349075, 0.317712, 0.028720>, <-0.143869, 0.345636, 0.209020>, <0.009203, 0.375335, 0.342859>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.529648, 0.300619, 0.446975>, <-0.480808, 0.309892, 0.657158>, <-0.432329, 0.327133, 1.047940>, <-0.222067, 0.329310, 1.097271>, 
      <-0.368788, 0.335339, 0.423973>, <-0.319948, 0.344613, 0.634156>, <-0.208095, 0.329454, 1.100549>, <0.002166, 0.331631, 1.149881>, 
      <-0.152452, 0.352920, 0.374094>, <-0.030847, 0.333437, 0.471788>, <0.101963, 0.335550, 0.699441>, <0.223568, 0.316068, 0.797135>, 
      <0.009203, 0.375335, 0.342859>, <0.130808, 0.355852, 0.440553>, <0.292949, 0.329875, 0.570812>, <0.414554, 0.310393, 0.668505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.339696, -0.167177, -0.806201>, <0.288034, -0.170622, -0.605602>, <0.219151, -0.175216, -0.338136>, <0.167488, -0.178661, -0.137537>, 
      <0.325673, -0.194381, -0.719665>, <0.274010, -0.197826, -0.519065>, <0.204417, -0.201622, -0.303956>, <0.152754, -0.205067, -0.103356>, 
      <0.306975, -0.230652, -0.604283>, <0.254602, -0.233300, -0.456040>, <0.185482, -0.237628, -0.206026>, <0.133109, -0.240277, -0.057783>, 
      <0.292952, -0.257856, -0.517748>, <0.240579, -0.260504, -0.369504>, <0.170748, -0.264035, -0.171846>, <0.118375, -0.266684, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.218746, -0.140111, -1.419658>, <0.255031, -0.148231, -1.235621>, <0.303411, -0.159057, -0.990238>, <0.339696, -0.167177, -0.806201>, 
      <0.213111, -0.169191, -1.290577>, <0.249396, -0.177311, -1.106540>, <0.289388, -0.186261, -0.903702>, <0.325673, -0.194381, -0.719665>, 
      <0.205597, -0.207966, -1.118470>, <0.233494, -0.214208, -0.976978>, <0.279078, -0.224409, -0.745776>, <0.306975, -0.230652, -0.604283>, 
      <0.199962, -0.237046, -0.989390>, <0.227859, -0.243289, -0.847897>, <0.265055, -0.251613, -0.659240>, <0.292952, -0.257856, -0.517748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.339485, -0.165126, -0.852674>, <-0.191404, -0.156867, -1.039859>, <0.051277, -0.147615, -1.249562>, <0.218746, -0.140111, -1.419658>, 
      <-0.318635, -0.201630, -0.762499>, <-0.170554, -0.193371, -0.949685>, <0.045642, -0.176696, -1.120482>, <0.213111, -0.169191, -1.290577>, 
      <-0.255540, -0.239017, -0.647860>, <-0.141692, -0.232668, -0.791773>, <0.076843, -0.213735, -0.987696>, <0.205597, -0.207966, -1.118470>, 
      <-0.229220, -0.256279, -0.553478>, <-0.115371, -0.249930, -0.697391>, <0.071208, -0.242816, -0.858616>, <0.199962, -0.237046, -0.989390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.693032, -0.190964, -0.267101>, <-0.634024, -0.182294, -0.463603>, <-0.466816, -0.172228, -0.691718>, <-0.339485, -0.165126, -0.852674>, 
      <-0.648965, -0.230840, -0.213677>, <-0.589956, -0.222169, -0.410179>, <-0.445966, -0.208731, -0.601543>, <-0.318635, -0.201630, -0.762499>, 
      <-0.559231, -0.259727, -0.155524>, <-0.513864, -0.253061, -0.306600>, <-0.353436, -0.244477, -0.524112>, <-0.255540, -0.239017, -0.647860>, 
      <-0.501037, -0.276143, -0.103274>, <-0.455670, -0.269477, -0.254350>, <-0.327115, -0.261739, -0.429731>, <-0.229220, -0.256279, -0.553478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.730247, -0.222541, 0.448599>, <-0.778912, -0.213300, 0.239169>, <-0.754872, -0.200049, -0.061169>, <-0.693032, -0.190964, -0.267101>, 
      <-0.683315, -0.266316, 0.455578>, <-0.731980, -0.257076, 0.246148>, <-0.710804, -0.239926, -0.007745>, <-0.648965, -0.230840, -0.213677>, 
      <-0.592119, -0.286416, 0.455284>, <-0.629534, -0.279312, 0.294268>, <-0.606775, -0.266713, 0.002802>, <-0.559231, -0.259727, -0.155524>, 
      <-0.529649, -0.300420, 0.446975>, <-0.567064, -0.293316, 0.285960>, <-0.548581, -0.283128, 0.055052>, <-0.501037, -0.276143, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.730247, -0.222541, 0.448599>, <-0.683315, -0.266316, 0.455578>, <-0.592119, -0.286416, 0.455284>, <-0.529649, -0.300420, 0.446975>, 
      <-0.666721, -0.234602, 0.721981>, <-0.619789, -0.278378, 0.728960>, <-0.434971, -0.321645, 0.434384>, <-0.372501, -0.335650, 0.426076>, 
      <-0.455189, -0.258565, 1.265098>, <-0.410398, -0.275788, 1.135859>, <-0.259369, -0.322264, 0.663203>, <-0.161380, -0.359942, 0.380461>, 
      <-0.330181, -0.259860, 1.294427>, <-0.285391, -0.277081, 1.165188>, <-0.101540, -0.347773, 0.634696>, <-0.003551, -0.385450, 0.351954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.730247, -0.222541, 0.448599>, <-0.683315, -0.266316, 0.455578>, <-0.592119, -0.286416, 0.455284>, <-0.529649, -0.300420, 0.446975>, 
      <-0.666721, -0.234602, 0.721981>, <-0.619789, -0.278378, 0.728960>, <-0.543279, -0.295690, 0.665467>, <-0.480809, -0.309694, 0.657159>, 
      <-0.455189, -0.258565, 1.265098>, <-0.445798, -0.280255, 1.243137>, <-0.455261, -0.318119, 1.114109>, <-0.432329, -0.326936, 1.047940>, 
      <-0.330181, -0.259860, 1.294427>, <-0.320791, -0.281549, 1.272466>, <-0.244999, -0.320295, 1.163440>, <-0.222067, -0.329112, 1.097271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.223988, -0.199166, 0.188346>, <0.192616, -0.224150, 0.231954>, <0.150786, -0.257464, 0.290097>, <0.119414, -0.282448, 0.333704>, 
      <0.286817, -0.201626, 0.157258>, <0.255445, -0.226611, 0.200865>, <0.225157, -0.259355, 0.238765>, <0.193785, -0.284340, 0.282372>, 
      <0.370589, -0.204906, 0.115806>, <0.350759, -0.229323, 0.139170>, <0.312777, -0.262446, 0.190565>, <0.292946, -0.286863, 0.213929>, 
      <0.433418, -0.207367, 0.084717>, <0.413588, -0.231783, 0.108081>, <0.387147, -0.264338, 0.139233>, <0.367317, -0.288754, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439308, -0.190142, -0.342868>, <0.374712, -0.192849, -0.183503>, <0.288584, -0.196459, 0.028982>, <0.223988, -0.199166, 0.188346>, 
      <0.422059, -0.215753, -0.292430>, <0.357463, -0.218460, -0.133066>, <0.257212, -0.221443, 0.072590>, <0.192616, -0.224150, 0.231954>, 
      <0.399060, -0.249902, -0.225180>, <0.320341, -0.251982, -0.072646>, <0.229505, -0.255383, 0.137563>, <0.150786, -0.257464, 0.290097>, 
      <0.381810, -0.275512, -0.174743>, <0.303091, -0.277593, -0.022208>, <0.198133, -0.280368, 0.181170>, <0.119414, -0.282448, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439308, -0.190142, -0.342868>, <0.422059, -0.215753, -0.292430>, <0.399060, -0.249902, -0.225180>, <0.381810, -0.275512, -0.174743>, 
      <0.357762, -0.186698, -0.281268>, <0.340513, -0.212309, -0.230831>, <0.320029, -0.247253, -0.179838>, <0.302780, -0.272864, -0.129401>, 
      <0.249034, -0.182105, -0.199136>, <0.234300, -0.208512, -0.164956>, <0.212140, -0.242925, -0.103125>, <0.197406, -0.269332, -0.068945>, 
      <0.167488, -0.178661, -0.137537>, <0.152754, -0.205067, -0.103356>, <0.133109, -0.240277, -0.057783>, <0.118375, -0.266684, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.414554, -0.310194, 0.668505>, <0.439547, -0.287712, 0.688975>, <0.472870, -0.257736, 0.716268>, <0.497862, -0.235254, 0.736738>, 
      <0.223568, -0.315870, 0.797135>, <0.248560, -0.293388, 0.817605>, <0.224457, -0.265118, 0.883575>, <0.249449, -0.242635, 0.904045>, 
      <0.002166, -0.331434, 1.149881>, <-0.020766, -0.322616, 1.216050>, <-0.187476, -0.282929, 1.303744>, <-0.196867, -0.261240, 1.325706>, 
      <-0.222067, -0.329112, 1.097271>, <-0.244999, -0.320295, 1.163440>, <-0.320791, -0.281549, 1.272466>, <-0.330181, -0.259860, 1.294427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.414554, -0.310194, 0.668505>, <0.439547, -0.287712, 0.688975>, <0.472870, -0.257736, 0.716268>, <0.497862, -0.235254, 0.736738>, 
      <0.400383, -0.303762, 0.516733>, <0.425375, -0.281280, 0.537203>, <0.453536, -0.249370, 0.520662>, <0.478529, -0.226887, 0.541132>, 
      <0.381488, -0.295186, 0.314369>, <0.401319, -0.270770, 0.291005>, <0.432921, -0.240149, 0.303687>, <0.452751, -0.215733, 0.280324>, 
      <0.367317, -0.288754, 0.162596>, <0.387147, -0.264338, 0.139233>, <0.413588, -0.231783, 0.108081>, <0.433418, -0.207367, 0.084717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.414554, -0.310194, 0.668505>, <0.400383, -0.303762, 0.516733>, <0.381488, -0.295186, 0.314369>, <0.367317, -0.288754, 0.162596>, 
      <0.223568, -0.315870, 0.797135>, <0.209397, -0.309438, 0.645362>, <0.270228, -0.324195, 0.371177>, <0.256057, -0.317763, 0.219404>, 
      <0.002166, -0.331434, 1.149881>, <0.078067, -0.360618, 0.930872>, <0.042155, -0.339540, 0.518742>, <0.107710, -0.356442, 0.295147>, 
      <-0.222067, -0.329112, 1.097271>, <-0.146166, -0.358297, 0.878262>, <-0.069106, -0.368549, 0.575550>, <-0.003551, -0.385450, 0.351954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.339697, 0.160366, -0.806201>, <0.325674, 0.189672, -0.719665>, <0.306976, 0.228747, -0.604283>, <0.292953, 0.258054, -0.517748>, 
      <0.288034, 0.163811, -0.605602>, <0.274011, 0.193117, -0.519065>, <0.254603, 0.231396, -0.456040>, <0.240580, 0.260702, -0.369504>, 
      <0.219151, 0.168404, -0.338136>, <0.204417, 0.196914, -0.303956>, <0.185482, 0.235723, -0.206026>, <0.170749, 0.264233, -0.171846>, 
      <0.167488, 0.171849, -0.137537>, <0.152754, 0.200358, -0.103356>, <0.133109, 0.238372, -0.057783>, <0.118375, 0.266882, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.218747, 0.133299, -1.419658>, <0.213112, 0.164482, -1.290577>, <0.205598, 0.206061, -1.118470>, <0.199963, 0.237245, -0.989390>, 
      <0.255032, 0.141419, -1.235621>, <0.249397, 0.172602, -1.106540>, <0.233495, 0.212304, -0.976978>, <0.227860, 0.243487, -0.847897>, 
      <0.303412, 0.152246, -0.990238>, <0.289389, 0.181552, -0.903702>, <0.279079, 0.222504, -0.745776>, <0.265056, 0.251811, -0.659240>, 
      <0.339697, 0.160366, -0.806201>, <0.325674, 0.189672, -0.719665>, <0.306976, 0.228747, -0.604283>, <0.292953, 0.258054, -0.517748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.339485, 0.158315, -0.852674>, <-0.318462, 0.194501, -0.761752>, <-0.256829, 0.239294, -0.648138>, <-0.229220, 0.256478, -0.553478>, 
      <-0.191404, 0.150056, -1.039859>, <-0.170381, 0.186242, -0.948938>, <-0.142980, 0.232945, -0.792052>, <-0.115371, 0.250128, -0.697391>, 
      <0.051277, 0.140803, -1.249562>, <0.045642, 0.171987, -1.120482>, <0.076843, 0.211831, -0.987696>, <0.071208, 0.243014, -0.858616>, 
      <0.218747, 0.133299, -1.419658>, <0.213112, 0.164482, -1.290577>, <0.205598, 0.206061, -1.118470>, <0.199963, 0.237245, -0.989390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.693031, 0.184152, -0.267101>, <-0.648406, 0.223900, -0.213002>, <-0.560648, 0.260111, -0.155052>, <-0.501036, 0.276341, -0.103274>, 
      <-0.634023, 0.175482, -0.463603>, <-0.589398, 0.215230, -0.409504>, <-0.515281, 0.253446, -0.306129>, <-0.455669, 0.269675, -0.254350>, 
      <-0.466816, 0.165416, -0.691718>, <-0.445793, 0.201602, -0.600796>, <-0.354724, 0.244754, -0.524391>, <-0.327115, 0.261937, -0.429731>, 
      <-0.339485, 0.158315, -0.852674>, <-0.318462, 0.194501, -0.761752>, <-0.256829, 0.239294, -0.648138>, <-0.229220, 0.256478, -0.553478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.730246, 0.215729, 0.448599>, <-0.682424, 0.259692, 0.455711>, <-0.592910, 0.286964, 0.456022>, <-0.529648, 0.300619, 0.446975>, 
      <-0.778911, 0.206488, 0.239169>, <-0.731089, 0.250452, 0.246280>, <-0.630325, 0.279860, 0.295006>, <-0.567063, 0.293515, 0.285960>, 
      <-0.754871, 0.193238, -0.061168>, <-0.710246, 0.232986, -0.007070>, <-0.608192, 0.267097, 0.003274>, <-0.548580, 0.283326, 0.055052>, 
      <-0.693031, 0.184152, -0.267101>, <-0.648406, 0.223900, -0.213002>, <-0.560648, 0.260111, -0.155052>, <-0.501036, 0.276341, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.330181, 0.253047, 1.294427>, <-0.320648, 0.274777, 1.272133>, <-0.245822, 0.320750, 1.163876>, <-0.222067, 0.329310, 1.097271>, 
      <-0.455188, 0.251754, 1.265098>, <-0.445656, 0.273483, 1.242804>, <-0.456084, 0.318574, 1.114544>, <-0.432329, 0.327133, 1.047940>, 
      <-0.666721, 0.227790, 0.721981>, <-0.618898, 0.271754, 0.729092>, <-0.544070, 0.296237, 0.666205>, <-0.480808, 0.309892, 0.657158>, 
      <-0.730246, 0.215729, 0.448599>, <-0.682424, 0.259692, 0.455711>, <-0.592910, 0.286964, 0.456022>, <-0.529648, 0.300619, 0.446975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.497862, 0.228442, 0.736738>, <0.472870, 0.253027, 0.716268>, <0.439547, 0.285807, 0.688975>, <0.414554, 0.310393, 0.668505>, 
      <0.249449, 0.235823, 0.904045>, <0.224457, 0.260409, 0.883575>, <0.248560, 0.291482, 0.817605>, <0.223568, 0.316068, 0.797135>, 
      <-0.196867, 0.254428, 1.325706>, <-0.187334, 0.276157, 1.303411>, <-0.021589, 0.323071, 1.216486>, <0.002166, 0.331631, 1.149881>, 
      <-0.330181, 0.253047, 1.294427>, <-0.320648, 0.274777, 1.272133>, <-0.245822, 0.320750, 1.163876>, <-0.222067, 0.329310, 1.097271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.433418, 0.200555, 0.084717>, <0.413588, 0.227074, 0.108081>, <0.387147, 0.262433, 0.139233>, <0.367317, 0.288953, 0.162596>, 
      <0.452751, 0.208921, 0.280324>, <0.432921, 0.235440, 0.303687>, <0.401319, 0.268865, 0.291005>, <0.381488, 0.295385, 0.314369>, 
      <0.478529, 0.220076, 0.541132>, <0.453536, 0.244661, 0.520662>, <0.425375, 0.279375, 0.537203>, <0.400383, 0.303961, 0.516733>, 
      <0.497862, 0.228442, 0.736738>, <0.472870, 0.253027, 0.716268>, <0.439547, 0.285807, 0.688975>, <0.414554, 0.310393, 0.668505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.223988, 0.192354, 0.188346>, <0.192616, 0.219442, 0.231954>, <0.150786, 0.255559, 0.290097>, <0.119414, 0.282647, 0.333704>, 
      <0.286817, 0.194814, 0.157258>, <0.255445, 0.221902, 0.200865>, <0.225157, 0.257451, 0.238765>, <0.193785, 0.284538, 0.282372>, 
      <0.370589, 0.198094, 0.115806>, <0.350759, 0.224614, 0.139170>, <0.312777, 0.260541, 0.190565>, <0.292946, 0.287061, 0.213929>, 
      <0.433418, 0.200555, 0.084717>, <0.413588, 0.227074, 0.108081>, <0.387147, 0.262433, 0.139233>, <0.367317, 0.288953, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439309, 0.183331, -0.342868>, <0.422060, 0.211045, -0.292430>, <0.399060, 0.247997, -0.225180>, <0.381811, 0.275711, -0.174743>, 
      <0.374713, 0.186037, -0.183503>, <0.357463, 0.213752, -0.133066>, <0.320341, 0.250077, -0.072646>, <0.303092, 0.277791, -0.022208>, 
      <0.288584, 0.189647, 0.028982>, <0.257212, 0.216735, 0.072590>, <0.229505, 0.253478, 0.137563>, <0.198133, 0.280566, 0.181170>, 
      <0.223988, 0.192354, 0.188346>, <0.192616, 0.219442, 0.231954>, <0.150786, 0.255559, 0.290097>, <0.119414, 0.282647, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439309, 0.183331, -0.342868>, <0.357763, 0.179886, -0.281268>, <0.249034, 0.175293, -0.199136>, <0.167488, 0.171849, -0.137537>, 
      <0.422060, 0.211045, -0.292430>, <0.340513, 0.207600, -0.230831>, <0.234300, 0.203803, -0.164956>, <0.152754, 0.200358, -0.103356>, 
      <0.399060, 0.247997, -0.225180>, <0.320030, 0.245348, -0.179838>, <0.212140, 0.241020, -0.103125>, <0.133109, 0.238372, -0.057783>, 
      <0.381811, 0.275711, -0.174743>, <0.302780, 0.273062, -0.129401>, <0.197406, 0.269530, -0.068945>, <0.118375, 0.266882, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.452644, 0.002276, -1.135373>, <0.379556, 0.002276, -0.883089>, <0.282105, 0.002276, -0.546710>, <0.209017, 0.002276, -0.294427>, 
      <0.418760, -0.048560, -1.036621>, <0.345672, -0.048560, -0.784337>, <0.269647, -0.052005, -0.499644>, <0.196558, -0.052005, -0.247360>, 
      <0.373580, -0.116342, -0.904952>, <0.321918, -0.119787, -0.704353>, <0.231609, -0.120935, -0.385203>, <0.179947, -0.124380, -0.184604>, 
      <0.339696, -0.167177, -0.806201>, <0.288034, -0.170622, -0.605602>, <0.219151, -0.175216, -0.338136>, <0.167488, -0.178661, -0.137537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.452644, 0.002276, -1.135373>, <0.418760, 0.049703, -1.036621>, <0.373581, 0.112939, -0.904952>, <0.339697, 0.160366, -0.806201>, 
      <0.379556, 0.002276, -0.883089>, <0.345672, 0.049703, -0.784337>, <0.321919, 0.116384, -0.704353>, <0.288034, 0.163811, -0.605602>, 
      <0.282105, 0.002276, -0.546710>, <0.269647, 0.053148, -0.499644>, <0.231610, 0.117532, -0.385203>, <0.219151, 0.168404, -0.338136>, 
      <0.209017, 0.002276, -0.294427>, <0.196558, 0.053148, -0.247360>, <0.179947, 0.120977, -0.184604>, <0.167488, 0.171849, -0.137537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.304917, 0.002276, -1.885373>, <0.349235, 0.002276, -1.660373>, <0.408326, 0.002276, -1.360373>, <0.452644, 0.002276, -1.135373>, 
      <0.279066, -0.040440, -1.745658>, <0.323384, -0.040440, -1.520658>, <0.374441, -0.048560, -1.261621>, <0.418760, -0.048560, -1.036621>, 
      <0.244597, -0.097395, -1.559372>, <0.280882, -0.105515, -1.375335>, <0.337296, -0.108222, -1.088989>, <0.373580, -0.116342, -0.904952>, 
      <0.218746, -0.140111, -1.419658>, <0.255031, -0.148231, -1.235621>, <0.303411, -0.159057, -0.990238>, <0.339696, -0.167177, -0.806201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.304917, 0.002276, -1.885373>, <0.279066, 0.041583, -1.745658>, <0.244598, 0.093992, -1.559372>, <0.218747, 0.133299, -1.419658>, 
      <0.349235, 0.002276, -1.660373>, <0.323384, 0.041583, -1.520658>, <0.280883, 0.102112, -1.375335>, <0.255032, 0.141419, -1.235621>, 
      <0.408326, 0.002276, -1.360373>, <0.374442, 0.049703, -1.261621>, <0.337296, 0.104819, -1.088989>, <0.303412, 0.152246, -0.990238>, 
      <0.452644, 0.002276, -1.135373>, <0.418760, 0.049703, -1.036621>, <0.373581, 0.112939, -0.904952>, <0.339697, 0.160366, -0.806201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.376902, 0.002276, -1.192191>, <-0.376902, 0.114933, -1.192191>, <-0.363147, 0.117585, -0.955011>, <-0.339485, 0.158315, -0.852674>, 
      <-0.196037, 0.002276, -1.421040>, <-0.196037, 0.114933, -1.421040>, <-0.215066, 0.109326, -1.142197>, <-0.191404, 0.150056, -1.039859>, 
      <0.100371, 0.002276, -1.677418>, <0.074520, 0.041583, -1.537703>, <0.077129, 0.101497, -1.389277>, <0.051277, 0.140803, -1.249562>, 
      <0.304917, 0.002276, -1.885373>, <0.279066, 0.041583, -1.745658>, <0.244598, 0.093992, -1.559372>, <0.218747, 0.133299, -1.419658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.376902, 0.002276, -1.192191>, <-0.196037, 0.002276, -1.421040>, <0.100371, 0.002276, -1.677418>, <0.304917, 0.002276, -1.885373>, 
      <-0.376902, -0.111841, -1.192191>, <-0.196037, -0.111841, -1.421040>, <0.074520, -0.040440, -1.537703>, <0.279066, -0.040440, -1.745658>, 
      <-0.363400, -0.123258, -0.956103>, <-0.215319, -0.114999, -1.143289>, <0.077128, -0.104900, -1.389277>, <0.244597, -0.097395, -1.559372>, 
      <-0.339485, -0.165126, -0.852674>, <-0.191404, -0.156867, -1.039859>, <0.051277, -0.147615, -1.249562>, <0.218746, -0.140111, -1.419658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.808720, 0.002276, -0.476282>, <-0.736648, 0.002276, -0.716521>, <-0.532422, 0.002276, -0.995410>, <-0.376902, 0.002276, -1.192191>, 
      <-0.808720, -0.089938, -0.476282>, <-0.736649, -0.089938, -0.716521>, <-0.532422, -0.111841, -0.995410>, <-0.376902, -0.111841, -1.192191>, 
      <-0.743882, -0.144950, -0.328747>, <-0.684874, -0.136280, -0.525250>, <-0.490730, -0.130359, -0.795147>, <-0.363400, -0.123258, -0.956103>, 
      <-0.693032, -0.190964, -0.267101>, <-0.634024, -0.182294, -0.463603>, <-0.466816, -0.172228, -0.691718>, <-0.339485, -0.165126, -0.852674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.808720, 0.002276, -0.476282>, <-0.808720, 0.092385, -0.476282>, <-0.742914, 0.139719, -0.327575>, <-0.693031, 0.184152, -0.267101>, 
      <-0.736648, 0.002276, -0.716521>, <-0.736648, 0.092385, -0.716521>, <-0.683906, 0.131049, -0.524077>, <-0.634023, 0.175482, -0.463603>, 
      <-0.532422, 0.002276, -0.995410>, <-0.532422, 0.114933, -0.995410>, <-0.490478, 0.124687, -0.794056>, <-0.466816, 0.165416, -0.691718>, 
      <-0.376902, 0.002276, -1.192191>, <-0.376902, 0.114933, -1.192191>, <-0.363147, 0.117585, -0.955011>, <-0.339485, 0.158315, -0.852674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.854174, 0.002276, 0.398718>, <-0.913613, 0.002276, 0.142673>, <-0.884250, 0.002276, -0.224513>, <-0.808720, 0.002276, -0.476282>, 
      <-0.854174, -0.076178, 0.398718>, <-0.913613, -0.076178, 0.142673>, <-0.884251, -0.089938, -0.224513>, <-0.808720, -0.089938, -0.476282>, 
      <-0.787282, -0.169342, 0.440118>, <-0.835947, -0.160102, 0.230688>, <-0.805722, -0.154036, -0.122815>, <-0.743882, -0.144950, -0.328747>, 
      <-0.730247, -0.222541, 0.448599>, <-0.778912, -0.213300, 0.239169>, <-0.754872, -0.200049, -0.061169>, <-0.693032, -0.190964, -0.267101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.854174, 0.002276, 0.398718>, <-0.854174, 0.077819, 0.398718>, <-0.785529, 0.164906, 0.440379>, <-0.730246, 0.215729, 0.448599>, 
      <-0.913613, 0.002276, 0.142673>, <-0.913613, 0.077819, 0.142673>, <-0.834194, 0.155666, 0.230948>, <-0.778911, 0.206488, 0.239169>, 
      <-0.884250, 0.002276, -0.224513>, <-0.884250, 0.092385, -0.224513>, <-0.804754, 0.148805, -0.121643>, <-0.754871, 0.193238, -0.061168>, 
      <-0.808720, 0.002276, -0.476282>, <-0.808720, 0.092385, -0.476282>, <-0.742914, 0.139719, -0.327575>, <-0.693031, 0.184152, -0.267101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.365538, 0.002276, 1.432809>, <-0.365538, 0.088854, 1.432809>, <-0.341768, 0.226636, 1.321526>, <-0.330181, 0.253047, 1.294427>, 
      <-0.512129, 0.002276, 1.122582>, <-0.512129, 0.088854, 1.122582>, <-0.466775, 0.225342, 1.292196>, <-0.455188, 0.251754, 1.265098>, 
      <-0.776585, 0.002276, 0.732949>, <-0.776585, 0.077819, 0.732949>, <-0.722004, 0.176968, 0.713760>, <-0.666721, 0.227790, 0.721981>, 
      <-0.854174, 0.002276, 0.398718>, <-0.854174, 0.077819, 0.398718>, <-0.785529, 0.164906, 0.440379>, <-0.730246, 0.215729, 0.448599>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.365538, 0.002276, 1.432809>, <-0.512129, 0.002276, 1.122582>, <-0.776585, 0.002276, 0.732949>, <-0.854174, 0.002276, 0.398718>, 
      <-0.365538, -0.087281, 1.432809>, <-0.512129, -0.087281, 1.122582>, <-0.776585, -0.076178, 0.732949>, <-0.854174, -0.076178, 0.398718>, 
      <-0.342095, -0.232340, 1.322292>, <-0.467103, -0.231046, 1.292963>, <-0.723756, -0.181404, 0.713500>, <-0.787282, -0.169342, 0.440118>, 
      <-0.330181, -0.259860, 1.294427>, <-0.455189, -0.258565, 1.265098>, <-0.666721, -0.234602, 0.721981>, <-0.730247, -0.222541, 0.448599>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.645826, 0.002276, 0.750991>, <0.342417, 0.002276, 0.955537>, <-0.062129, 0.002276, 1.228264>, <-0.365538, 0.002276, 1.432809>, 
      <0.601437, -0.068983, 0.746715>, <0.298028, -0.068983, 0.951261>, <-0.062129, -0.087281, 1.228264>, <-0.365538, -0.087281, 1.432809>, 
      <0.542251, -0.163995, 0.741014>, <0.293838, -0.171376, 0.908321>, <-0.208781, -0.233720, 1.353570>, <-0.342095, -0.232340, 1.322292>, 
      <0.497862, -0.235254, 0.736738>, <0.249449, -0.242635, 0.904045>, <-0.196867, -0.261240, 1.325706>, <-0.330181, -0.259860, 1.294427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.645826, 0.002276, 0.750991>, <0.601437, 0.070125, 0.746715>, <0.542251, 0.160592, 0.741014>, <0.497862, 0.228442, 0.736738>, 
      <0.342417, 0.002276, 0.955537>, <0.298028, 0.070125, 0.951261>, <0.293838, 0.167974, 0.908321>, <0.249449, 0.235823, 0.904045>, 
      <-0.062129, 0.002276, 1.228264>, <-0.062129, 0.088854, 1.228264>, <-0.208454, 0.228016, 1.352804>, <-0.196867, 0.254428, 1.325706>, 
      <-0.365538, 0.002276, 1.432809>, <-0.365538, 0.088854, 1.432809>, <-0.341768, 0.226636, 1.321526>, <-0.330181, 0.253047, 1.294427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.564904, 0.002276, -0.041711>, <0.564904, 0.083102, -0.041711>, <0.472864, 0.141071, 0.046789>, <0.433418, 0.200555, 0.084717>, 
      <0.589181, 0.002276, 0.196100>, <0.589181, 0.083102, 0.196100>, <0.492197, 0.149437, 0.242395>, <0.452751, 0.208921, 0.280324>, 
      <0.621549, 0.002276, 0.513181>, <0.577160, 0.070125, 0.508905>, <0.522918, 0.152226, 0.545408>, <0.478529, 0.220076, 0.541132>, 
      <0.645826, 0.002276, 0.750991>, <0.601437, 0.070125, 0.746715>, <0.542251, 0.160592, 0.741014>, <0.497862, 0.228442, 0.736738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.564904, 0.002276, -0.041711>, <0.589181, 0.002276, 0.196100>, <0.621549, 0.002276, 0.513181>, <0.645826, 0.002276, 0.750991>, 
      <0.564904, -0.081091, -0.041711>, <0.589181, -0.081091, 0.196100>, <0.577160, -0.068983, 0.508905>, <0.601437, -0.068983, 0.746715>, 
      <0.472864, -0.144474, 0.046789>, <0.492197, -0.152840, 0.242395>, <0.522918, -0.155629, 0.545408>, <0.542251, -0.163995, 0.741014>, 
      <0.433418, -0.207367, 0.084717>, <0.452751, -0.215733, 0.280324>, <0.478529, -0.226887, 0.541132>, <0.497862, -0.235254, 0.736738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.230855, 0.002276, 0.183905>, <0.228795, 0.059299, 0.185238>, <0.226048, 0.135330, 0.187014>, <0.223988, 0.192354, 0.188346>, 
      <0.331070, 0.002276, 0.116221>, <0.329010, 0.059299, 0.117553>, <0.288877, 0.137791, 0.155925>, <0.286817, 0.194814, 0.157258>, 
      <0.464689, 0.002276, 0.025974>, <0.464689, 0.083102, 0.025974>, <0.410035, 0.138611, 0.077878>, <0.370589, 0.198094, 0.115806>, 
      <0.564904, 0.002276, -0.041711>, <0.564904, 0.083102, -0.041711>, <0.472864, 0.141071, 0.046789>, <0.433418, 0.200555, 0.084717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.230855, 0.002276, 0.183905>, <0.331070, 0.002276, 0.116221>, <0.464689, 0.002276, 0.025974>, <0.564904, 0.002276, -0.041711>, 
      <0.228795, -0.058157, 0.185238>, <0.329010, -0.058157, 0.117553>, <0.464689, -0.081091, 0.025974>, <0.564904, -0.081091, -0.041711>, 
      <0.226048, -0.138733, 0.187014>, <0.288877, -0.141194, 0.155925>, <0.410035, -0.142014, 0.077878>, <0.472864, -0.144474, 0.046789>, 
      <0.223988, -0.199166, 0.188346>, <0.286817, -0.201626, 0.157258>, <0.370589, -0.204906, 0.115806>, <0.433418, -0.207367, 0.084717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.562555, 0.002276, -0.556186>, <0.562555, 0.093997, -0.556186>, <0.476283, 0.129014, -0.406863>, <0.439309, 0.183331, -0.342868>, 
      <0.463045, 0.002276, -0.334158>, <0.463045, 0.093997, -0.334158>, <0.411687, 0.131721, -0.247499>, <0.374713, 0.186037, -0.183503>, 
      <0.330365, 0.002276, -0.038122>, <0.328305, 0.059299, -0.036790>, <0.290644, 0.132623, 0.027650>, <0.288584, 0.189647, 0.028982>, 
      <0.230855, 0.002276, 0.183905>, <0.228795, 0.059299, 0.185238>, <0.226048, 0.135330, 0.187014>, <0.223988, 0.192354, 0.188346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.562555, 0.002276, -0.556186>, <0.463045, 0.002276, -0.334158>, <0.330365, 0.002276, -0.038122>, <0.230855, 0.002276, 0.183905>, 
      <0.562555, -0.091505, -0.556186>, <0.463045, -0.091505, -0.334158>, <0.328305, -0.058157, -0.036790>, <0.228795, -0.058157, 0.185238>, 
      <0.476282, -0.132417, -0.406863>, <0.411686, -0.135124, -0.247499>, <0.290644, -0.136026, 0.027650>, <0.226048, -0.138733, 0.187014>, 
      <0.439308, -0.190142, -0.342868>, <0.374712, -0.192849, -0.183503>, <0.288584, -0.196459, 0.028982>, <0.223988, -0.199166, 0.188346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.562555, 0.002276, -0.556186>, <0.562555, -0.091505, -0.556186>, <0.476282, -0.132417, -0.406863>, <0.439308, -0.190142, -0.342868>, 
      <0.456494, 0.002276, -0.477658>, <0.456494, -0.091505, -0.477658>, <0.394736, -0.128972, -0.345264>, <0.357762, -0.186698, -0.281268>, 
      <0.315078, 0.002276, -0.372954>, <0.302620, -0.052005, -0.325887>, <0.261493, -0.127824, -0.246203>, <0.249034, -0.182105, -0.199136>, 
      <0.209017, 0.002276, -0.294427>, <0.196558, -0.052005, -0.247360>, <0.179947, -0.124380, -0.184604>, <0.167488, -0.178661, -0.137537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.562555, 0.002276, -0.556186>, <0.456494, 0.002276, -0.477658>, <0.315078, 0.002276, -0.372954>, <0.209017, 0.002276, -0.294427>, 
      <0.562555, 0.093997, -0.556186>, <0.456494, 0.093997, -0.477658>, <0.302620, 0.053148, -0.325887>, <0.196558, 0.053148, -0.247360>, 
      <0.476283, 0.129014, -0.406863>, <0.394737, 0.125570, -0.345264>, <0.261493, 0.124421, -0.246203>, <0.179947, 0.120977, -0.184604>, 
      <0.439309, 0.183331, -0.342868>, <0.357763, 0.179886, -0.281268>, <0.249034, 0.175293, -0.199136>, <0.167488, 0.171849, -0.137537>
    }
  }
  scale <16.5, 19.0, 16.5>
  rotate <-55.0, 0.0, -170.0>
  translate  <10.4, -200.1, -48.8>
}
#declare Leftmandible = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.054467, -0.282448, 0.333704>, <-0.017577, -0.313349, 0.339179>, <0.031609, -0.354550, 0.346479>, <0.068498, -0.385450, 0.351954>, 
      <-0.054467, -0.282448, 0.333704>, <-0.091948, -0.315241, 0.287847>, <-0.079652, -0.325541, 0.289672>, <-0.042762, -0.356442, 0.295147>, 
      <-0.054467, -0.282448, 0.333704>, <-0.091948, -0.315241, 0.287847>, <-0.116739, -0.315872, 0.270736>, <-0.191109, -0.317763, 0.219404>, 
      <-0.054467, -0.282448, 0.333704>, <-0.128838, -0.284340, 0.282372>, <-0.227999, -0.286863, 0.213929>, <-0.302370, -0.288754, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.316863, -0.275512, -0.174743>, <-0.201255, -0.308494, -0.016733>, <-0.047110, -0.352469, 0.193945>, <0.068498, -0.385450, 0.351954>, 
      <-0.316863, -0.275512, -0.174743>, <-0.122536, -0.310575, 0.135801>, <-0.084000, -0.321568, 0.188470>, <0.031609, -0.354550, 0.346479>, 
      <-0.316863, -0.275512, -0.174743>, <-0.122536, -0.310575, 0.135801>, <-0.096296, -0.311268, 0.186645>, <-0.017577, -0.313349, 0.339179>, 
      <-0.316863, -0.275512, -0.174743>, <-0.238144, -0.277593, -0.022208>, <-0.133186, -0.280368, 0.181170>, <-0.054467, -0.282448, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.316863, -0.275512, -0.174743>, <-0.201255, -0.308494, -0.016733>, <-0.047110, -0.352469, 0.193945>, <0.068498, -0.385450, 0.351954>, 
      <-0.238144, -0.277593, -0.022208>, <-0.122536, -0.310575, 0.135801>, <-0.158371, -0.323460, 0.137138>, <-0.042762, -0.356442, 0.295147>, 
      <-0.133186, -0.280368, 0.181170>, <-0.207557, -0.282259, 0.129838>, <-0.116739, -0.315872, 0.270736>, <-0.191109, -0.317763, 0.219404>, 
      <-0.054467, -0.282448, 0.333704>, <-0.128838, -0.284340, 0.282372>, <-0.227999, -0.286863, 0.213929>, <-0.302370, -0.288754, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.053428, -0.266684, -0.023603>, <-0.016850, -0.302314, 0.089065>, <0.031920, -0.349820, 0.239287>, <0.068498, -0.385450, 0.351954>, 
      <-0.053428, -0.266684, -0.023603>, <-0.095881, -0.304962, 0.043722>, <-0.083688, -0.316839, 0.081278>, <-0.047110, -0.352469, 0.193945>, 
      <-0.053428, -0.266684, -0.023603>, <-0.095881, -0.304962, 0.043722>, <-0.122224, -0.305845, 0.028608>, <-0.201255, -0.308494, -0.016733>, 
      <-0.053428, -0.266684, -0.023603>, <-0.132458, -0.269332, -0.068945>, <-0.237832, -0.272864, -0.129401>, <-0.316863, -0.275512, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.053428, -0.266684, -0.023603>, <-0.132458, -0.269332, -0.068945>, <-0.237832, -0.272864, -0.129401>, <-0.316863, -0.275512, -0.174743>, 
      <-0.016850, -0.302314, 0.089065>, <-0.095881, -0.304962, 0.043722>, <-0.159114, -0.274945, 0.023134>, <-0.238144, -0.277593, -0.022208>, 
      <0.031920, -0.349820, 0.239287>, <-0.004969, -0.318920, 0.233812>, <-0.096296, -0.311268, 0.186645>, <-0.133186, -0.280368, 0.181170>, 
      <0.068498, -0.385450, 0.351954>, <0.031609, -0.354550, 0.346479>, <-0.017577, -0.313349, 0.339179>, <-0.054467, -0.282448, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.228005, -0.257856, -0.517748>, <-0.139054, -0.296134, -0.256837>, <-0.020453, -0.347172, 0.091044>, <0.068498, -0.385450, 0.351954>, 
      <-0.228005, -0.257856, -0.517748>, <-0.086681, -0.298782, -0.108594>, <-0.057031, -0.311542, -0.021623>, <0.031920, -0.349820, 0.239287>, 
      <-0.228005, -0.257856, -0.517748>, <-0.086681, -0.298782, -0.108594>, <-0.069223, -0.299665, -0.059179>, <-0.016850, -0.302314, 0.089065>, 
      <-0.228005, -0.257856, -0.517748>, <-0.175632, -0.260504, -0.369504>, <-0.105801, -0.264035, -0.171846>, <-0.053428, -0.266684, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.228005, -0.257856, -0.517748>, <-0.175632, -0.260504, -0.369504>, <-0.105801, -0.264035, -0.171846>, <-0.053428, -0.266684, -0.023603>, 
      <-0.139054, -0.296134, -0.256837>, <-0.086681, -0.298782, -0.108594>, <-0.184832, -0.266684, -0.217188>, <-0.132458, -0.269332, -0.068945>, 
      <-0.020453, -0.347172, 0.091044>, <-0.136061, -0.314191, -0.066965>, <-0.122224, -0.305845, 0.028608>, <-0.237832, -0.272864, -0.129401>, 
      <0.068498, -0.385450, 0.351954>, <-0.047110, -0.352469, 0.193945>, <-0.201255, -0.308494, -0.016733>, <-0.316863, -0.275512, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.565984, -0.276143, -0.103274>, <0.416743, -0.318240, 0.030724>, <0.217744, -0.352658, 0.215386>, <0.068498, -0.385450, 0.351954>, 
      <0.565984, -0.276143, -0.103274>, <0.464287, -0.325226, 0.189050>, <0.375573, -0.327149, 0.243892>, <0.226327, -0.359942, 0.380461>, 
      <0.565984, -0.276143, -0.103274>, <0.464287, -0.325226, 0.189050>, <0.474863, -0.328545, 0.265060>, <0.437448, -0.335650, 0.426076>, 
      <0.565984, -0.276143, -0.103274>, <0.613528, -0.283128, 0.055052>, <0.632011, -0.293316, 0.285960>, <0.594596, -0.300420, 0.446975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.294167, -0.256279, -0.553478>, <0.219404, -0.305313, -0.285384>, <0.136199, -0.346699, 0.080325>, <0.068498, -0.385450, 0.351954>, 
      <0.294167, -0.256279, -0.553478>, <0.317299, -0.310773, -0.161637>, <0.285445, -0.313907, -0.056244>, <0.217744, -0.352658, 0.215386>, 
      <0.294167, -0.256279, -0.553478>, <0.317299, -0.310773, -0.161637>, <0.371375, -0.311574, -0.120352>, <0.416743, -0.318240, 0.030724>, 
      <0.294167, -0.256279, -0.553478>, <0.392062, -0.261739, -0.429731>, <0.520617, -0.269477, -0.254350>, <0.565984, -0.276143, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.294167, -0.256279, -0.553478>, <0.219404, -0.305313, -0.285384>, <0.136199, -0.346699, 0.080325>, <0.068498, -0.385450, 0.351954>, 
      <0.392062, -0.261739, -0.429731>, <0.317299, -0.310773, -0.161637>, <0.294028, -0.321190, 0.108831>, <0.226327, -0.359942, 0.380461>, 
      <0.520617, -0.269477, -0.254350>, <0.568161, -0.276462, -0.096024>, <0.474863, -0.328545, 0.265060>, <0.437448, -0.335650, 0.426076>, 
      <0.565984, -0.276143, -0.103274>, <0.613528, -0.283128, 0.055052>, <0.632011, -0.293316, 0.285960>, <0.594596, -0.300420, 0.446975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.135015, -0.237046, -0.989390>, <-0.073961, -0.281568, -0.586986>, <0.007444, -0.340929, -0.050449>, <0.068498, -0.385450, 0.351954>, 
      <-0.135015, -0.237046, -0.989390>, <-0.101858, -0.287810, -0.445494>, <-0.081507, -0.302651, -0.311359>, <-0.020453, -0.347172, 0.091044>, 
      <-0.135015, -0.237046, -0.989390>, <-0.101858, -0.287810, -0.445494>, <-0.111157, -0.289891, -0.398330>, <-0.139054, -0.296134, -0.256837>, 
      <-0.135015, -0.237046, -0.989390>, <-0.162912, -0.243289, -0.847897>, <-0.200108, -0.251613, -0.659240>, <-0.228005, -0.257856, -0.517748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.135015, -0.237046, -0.989390>, <-0.162912, -0.243289, -0.847897>, <-0.200108, -0.251613, -0.659240>, <-0.228005, -0.257856, -0.517748>, 
      <-0.073961, -0.281568, -0.586986>, <-0.101858, -0.287810, -0.445494>, <-0.147735, -0.254261, -0.510997>, <-0.175632, -0.260504, -0.369504>, 
      <0.007444, -0.340929, -0.050449>, <-0.029134, -0.305299, -0.163116>, <-0.069223, -0.299665, -0.059179>, <-0.105801, -0.264035, -0.171846>, 
      <0.068498, -0.385450, 0.351954>, <0.031920, -0.349820, 0.239287>, <-0.016850, -0.302314, 0.089065>, <-0.053428, -0.266684, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.135015, -0.237046, -0.989390>, <-0.162912, -0.243289, -0.847897>, <-0.200108, -0.251613, -0.659240>, <-0.228005, -0.257856, -0.517748>, 
      <-0.006260, -0.242816, -0.858616>, <-0.034157, -0.249059, -0.717123>, <-0.111157, -0.289891, -0.398330>, <-0.139054, -0.296134, -0.256837>, 
      <0.180319, -0.249930, -0.697391>, <0.105556, -0.298964, -0.429298>, <0.047248, -0.308421, -0.180586>, <-0.020453, -0.347172, 0.091044>, 
      <0.294167, -0.256279, -0.553478>, <0.219404, -0.305313, -0.285384>, <0.136199, -0.346699, 0.080325>, <0.068498, -0.385450, 0.351954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.135015, -0.237046, -0.989390>, <-0.073961, -0.281568, -0.586986>, <0.007444, -0.340929, -0.050449>, <0.068498, -0.385450, 0.351954>, 
      <-0.135015, -0.237046, -0.989390>, <0.054794, -0.287338, -0.456213>, <0.075145, -0.302178, -0.322078>, <0.136199, -0.346699, 0.080325>, 
      <-0.135015, -0.237046, -0.989390>, <0.054794, -0.287338, -0.456213>, <0.105556, -0.298964, -0.429298>, <0.219404, -0.305313, -0.285384>, 
      <-0.135015, -0.237046, -0.989390>, <-0.006260, -0.242816, -0.858616>, <0.180319, -0.249930, -0.697391>, <0.294167, -0.256279, -0.553478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.135015, -0.237046, -0.989390>, <-0.073961, -0.281568, -0.586986>, <0.007444, -0.340929, -0.050449>, <0.068498, -0.385450, 0.351954>, 
      <-0.006260, -0.242816, -0.858616>, <0.054794, -0.287338, -0.456213>, <0.156690, -0.308137, -0.187017>, <0.217744, -0.352658, 0.215386>, 
      <0.180319, -0.249930, -0.697391>, <0.278214, -0.255390, -0.573644>, <0.371375, -0.311574, -0.120352>, <0.416743, -0.318240, 0.030724>, 
      <0.294167, -0.256279, -0.553478>, <0.392062, -0.261739, -0.429731>, <0.520617, -0.269477, -0.254350>, <0.565984, -0.276143, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.287014, -0.329112, 1.097271>, <0.309946, -0.320295, 1.163440>, <0.385738, -0.281549, 1.272466>, <0.395128, -0.259860, 1.294427>, 
      <0.497276, -0.326936, 1.047940>, <0.520208, -0.318119, 1.114109>, <0.340948, -0.298771, 1.143227>, <0.350338, -0.277081, 1.165188>, 
      <0.545756, -0.309694, 0.657159>, <0.388608, -0.344923, 0.636259>, <0.324317, -0.322264, 0.663203>, <0.166487, -0.347773, 0.634696>, 
      <0.594596, -0.300420, 0.446975>, <0.437448, -0.335650, 0.426076>, <0.226327, -0.359942, 0.380461>, <0.068498, -0.385450, 0.351954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.287014, -0.329112, 1.097271>, <0.211113, -0.358297, 0.878262>, <0.134053, -0.368549, 0.575550>, <0.068498, -0.385450, 0.351954>, 
      <0.287014, -0.329112, 1.097271>, <0.421374, -0.356120, 0.828930>, <0.291882, -0.343040, 0.604056>, <0.226327, -0.359942, 0.380461>, 
      <0.287014, -0.329112, 1.097271>, <0.421374, -0.356120, 0.828930>, <0.388608, -0.344923, 0.636259>, <0.437448, -0.335650, 0.426076>, 
      <0.287014, -0.329112, 1.097271>, <0.497276, -0.326936, 1.047940>, <0.545756, -0.309694, 0.657159>, <0.594596, -0.300420, 0.446975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.287014, -0.329112, 1.097271>, <0.211113, -0.358297, 0.878262>, <0.134053, -0.368549, 0.575550>, <0.068498, -0.385450, 0.351954>, 
      <0.497276, -0.326936, 1.047940>, <0.421374, -0.356120, 0.828930>, <0.283299, -0.335757, 0.438981>, <0.217744, -0.352658, 0.215386>, 
      <0.545756, -0.309694, 0.657159>, <0.583171, -0.302590, 0.496143>, <0.464287, -0.325226, 0.189050>, <0.416743, -0.318240, 0.030724>, 
      <0.594596, -0.300420, 0.446975>, <0.632011, -0.293316, 0.285960>, <0.613528, -0.283128, 0.055052>, <0.565984, -0.276143, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.053428, 0.266882, -0.023603>, <-0.020676, 0.299418, 0.086336>, <0.022992, 0.342799, 0.232921>, <0.055744, 0.375335, 0.342859>, 
      <-0.053428, 0.266882, -0.023603>, <-0.099707, 0.302066, 0.040994>, <-0.088790, 0.312912, 0.077640>, <-0.056038, 0.345447, 0.187579>, 
      <-0.053428, 0.266882, -0.023603>, <-0.099707, 0.302066, 0.040994>, <-0.126051, 0.302949, 0.025880>, <-0.205082, 0.305598, -0.019462>, 
      <-0.053428, 0.266882, -0.023603>, <-0.132459, 0.269530, -0.068945>, <-0.237833, 0.273062, -0.129401>, <-0.316864, 0.275711, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.228006, 0.258054, -0.517748>, <-0.142881, 0.293238, -0.259566>, <-0.029381, 0.340150, 0.084677>, <0.055744, 0.375335, 0.342859>, 
      <-0.228006, 0.258054, -0.517748>, <-0.090508, 0.295886, -0.111322>, <-0.062133, 0.307614, -0.025261>, <0.022992, 0.342799, 0.232921>, 
      <-0.228006, 0.258054, -0.517748>, <-0.090508, 0.295886, -0.111322>, <-0.073050, 0.296769, -0.061907>, <-0.020676, 0.299418, 0.086336>, 
      <-0.228006, 0.258054, -0.517748>, <-0.175633, 0.260702, -0.369504>, <-0.105801, 0.264233, -0.171846>, <-0.053428, 0.266882, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.228006, 0.258054, -0.517748>, <-0.142881, 0.293238, -0.259566>, <-0.029381, 0.340150, 0.084677>, <0.055744, 0.375335, 0.342859>, 
      <-0.175633, 0.260702, -0.369504>, <-0.090508, 0.295886, -0.111322>, <-0.141163, 0.310263, -0.070603>, <-0.056038, 0.345447, 0.187579>, 
      <-0.105801, 0.264233, -0.171846>, <-0.184832, 0.266882, -0.217188>, <-0.126051, 0.302949, 0.025880>, <-0.205082, 0.305598, -0.019462>, 
      <-0.053428, 0.266882, -0.023603>, <-0.132459, 0.269530, -0.068945>, <-0.237833, 0.273062, -0.129401>, <-0.316864, 0.275711, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.054467, 0.282647, 0.333704>, <-0.021404, 0.310453, 0.336451>, <0.022681, 0.347528, 0.340113>, <0.055744, 0.375335, 0.342859>, 
      <-0.054467, 0.282647, 0.333704>, <-0.100123, 0.308372, 0.183917>, <-0.089102, 0.317641, 0.184832>, <-0.056038, 0.345447, 0.187579>, 
      <-0.054467, 0.282647, 0.333704>, <-0.100123, 0.308372, 0.183917>, <-0.126362, 0.307679, 0.133072>, <-0.205082, 0.305598, -0.019462>, 
      <-0.054467, 0.282647, 0.333704>, <-0.133186, 0.280566, 0.181170>, <-0.238145, 0.277791, -0.022208>, <-0.316864, 0.275711, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.054467, 0.282647, 0.333704>, <-0.133186, 0.280566, 0.181170>, <-0.238145, 0.277791, -0.022208>, <-0.316864, 0.275711, -0.174743>, 
      <-0.021404, 0.310453, 0.336451>, <-0.100123, 0.308372, 0.183917>, <-0.159114, 0.275143, 0.023134>, <-0.237833, 0.273062, -0.129401>, 
      <0.022681, 0.347528, 0.340113>, <-0.010071, 0.314992, 0.230174>, <-0.099707, 0.302066, 0.040994>, <-0.132459, 0.269530, -0.068945>, 
      <0.055744, 0.375335, 0.342859>, <0.022992, 0.342799, 0.232921>, <-0.020676, 0.299418, 0.086336>, <-0.053428, 0.266882, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.302370, 0.288953, 0.162596>, <-0.194936, 0.314867, 0.216675>, <-0.051690, 0.349420, 0.288781>, <0.055744, 0.375335, 0.342859>, 
      <-0.302370, 0.288953, 0.162596>, <-0.120565, 0.312975, 0.268008>, <-0.084753, 0.321614, 0.286034>, <0.022681, 0.347528, 0.340113>, 
      <-0.302370, 0.288953, 0.162596>, <-0.120565, 0.312975, 0.268008>, <-0.095774, 0.312345, 0.285119>, <-0.021404, 0.310453, 0.336451>, 
      <-0.302370, 0.288953, 0.162596>, <-0.227999, 0.287061, 0.213929>, <-0.128838, 0.284538, 0.282372>, <-0.054467, 0.282647, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.302370, 0.288953, 0.162596>, <-0.227999, 0.287061, 0.213929>, <-0.128838, 0.284538, 0.282372>, <-0.054467, 0.282647, 0.333704>, 
      <-0.194936, 0.314867, 0.216675>, <-0.120565, 0.312975, 0.268008>, <-0.207557, 0.282458, 0.129838>, <-0.133186, 0.280566, 0.181170>, 
      <-0.051690, 0.349420, 0.288781>, <-0.163472, 0.319533, 0.133500>, <-0.126362, 0.307679, 0.133072>, <-0.238145, 0.277791, -0.022208>, 
      <0.055744, 0.375335, 0.342859>, <-0.056038, 0.345447, 0.187579>, <-0.205082, 0.305598, -0.019462>, <-0.316864, 0.275711, -0.174743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.135016, 0.237245, -0.989390>, <-0.077788, 0.278672, -0.589715>, <-0.001484, 0.333908, -0.056815>, <0.055744, 0.375335, 0.342859>, 
      <-0.135016, 0.237245, -0.989390>, <-0.105685, 0.284914, -0.448222>, <-0.086609, 0.298723, -0.314997>, <-0.029381, 0.340150, 0.084677>, 
      <-0.135016, 0.237245, -0.989390>, <-0.105685, 0.284914, -0.448222>, <-0.114984, 0.286995, -0.401058>, <-0.142881, 0.293238, -0.259566>, 
      <-0.135016, 0.237245, -0.989390>, <-0.162913, 0.243487, -0.847897>, <-0.200109, 0.251811, -0.659240>, <-0.228006, 0.258054, -0.517748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.135016, 0.237245, -0.989390>, <-0.077788, 0.278672, -0.589715>, <-0.001484, 0.333908, -0.056815>, <0.055744, 0.375335, 0.342859>, 
      <-0.162913, 0.243487, -0.847897>, <-0.105685, 0.284914, -0.448222>, <-0.034236, 0.301372, -0.166754>, <0.022992, 0.342799, 0.232921>, 
      <-0.200109, 0.251811, -0.659240>, <-0.147735, 0.254459, -0.510997>, <-0.073050, 0.296769, -0.061907>, <-0.020676, 0.299418, 0.086336>, 
      <-0.228006, 0.258054, -0.517748>, <-0.175633, 0.260702, -0.369504>, <-0.105801, 0.264233, -0.171846>, <-0.053428, 0.266882, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.294167, 0.256478, -0.553478>, <0.216788, 0.304638, -0.288170>, <0.127271, 0.339678, 0.073958>, <0.055744, 0.375335, 0.342859>, 
      <0.294167, 0.256478, -0.553478>, <0.102939, 0.298288, -0.432083>, <0.070043, 0.298250, -0.325716>, <-0.001484, 0.333908, -0.056815>, 
      <0.294167, 0.256478, -0.553478>, <0.102939, 0.298288, -0.432083>, <0.050967, 0.284442, -0.458941>, <-0.077788, 0.278672, -0.589715>, 
      <0.294167, 0.256478, -0.553478>, <0.180318, 0.250128, -0.697391>, <-0.006261, 0.243014, -0.858616>, <-0.135016, 0.237245, -0.989390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.294167, 0.256478, -0.553478>, <0.216788, 0.304638, -0.288170>, <0.127271, 0.339678, 0.073958>, <0.055744, 0.375335, 0.342859>, 
      <0.180318, 0.250128, -0.697391>, <0.102939, 0.298288, -0.432083>, <0.042146, 0.304493, -0.184224>, <-0.029381, 0.340150, 0.084677>, 
      <-0.006261, 0.243014, -0.858616>, <-0.034158, 0.249257, -0.717123>, <-0.114984, 0.286995, -0.401058>, <-0.142881, 0.293238, -0.259566>, 
      <-0.135016, 0.237245, -0.989390>, <-0.162913, 0.243487, -0.847897>, <-0.200109, 0.251811, -0.659240>, <-0.228006, 0.258054, -0.517748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.565983, 0.276341, -0.103274>, <0.414022, 0.317712, 0.028720>, <0.208816, 0.345636, 0.209020>, <0.055744, 0.375335, 0.342859>, 
      <0.565983, 0.276341, -0.103274>, <0.368655, 0.311046, -0.122356>, <0.280343, 0.309979, -0.059882>, <0.127271, 0.339678, 0.073958>, 
      <0.565983, 0.276341, -0.103274>, <0.368655, 0.311046, -0.122356>, <0.314683, 0.310098, -0.164423>, <0.216788, 0.304638, -0.288170>, 
      <0.565983, 0.276341, -0.103274>, <0.520616, 0.269675, -0.254350>, <0.392062, 0.261937, -0.429731>, <0.294167, 0.256478, -0.553478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.565983, 0.276341, -0.103274>, <0.414022, 0.317712, 0.028720>, <0.208816, 0.345636, 0.209020>, <0.055744, 0.375335, 0.342859>, 
      <0.520616, 0.269675, -0.254350>, <0.368655, 0.311046, -0.122356>, <0.151588, 0.304209, -0.190655>, <-0.001484, 0.333908, -0.056815>, 
      <0.392062, 0.261937, -0.429731>, <0.278214, 0.255588, -0.573644>, <0.050967, 0.284442, -0.458941>, <-0.077788, 0.278672, -0.589715>, 
      <0.294167, 0.256478, -0.553478>, <0.180318, 0.250128, -0.697391>, <-0.006261, 0.243014, -0.858616>, <-0.135016, 0.237245, -0.989390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.349607, 0.310393, 0.668505>, <-0.228002, 0.329875, 0.570812>, <-0.065861, 0.355852, 0.440553>, <0.055744, 0.375335, 0.342859>, 
      <-0.349607, 0.310393, 0.668505>, <-0.213831, 0.323443, 0.419039>, <-0.173295, 0.329937, 0.386474>, <-0.051690, 0.349420, 0.288781>, 
      <-0.349607, 0.310393, 0.668505>, <-0.213831, 0.323443, 0.419039>, <-0.209107, 0.321299, 0.368448>, <-0.194936, 0.314867, 0.216675>, 
      <-0.349607, 0.310393, 0.668505>, <-0.335436, 0.303961, 0.516733>, <-0.316541, 0.295385, 0.314369>, <-0.302370, 0.288953, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.349607, 0.310393, 0.668505>, <-0.335436, 0.303961, 0.516733>, <-0.316541, 0.295385, 0.314369>, <-0.302370, 0.288953, 0.162596>, 
      <-0.228002, 0.329875, 0.570812>, <-0.213831, 0.323443, 0.419039>, <-0.242170, 0.293493, 0.365702>, <-0.227999, 0.287061, 0.213929>, 
      <-0.065861, 0.355852, 0.440553>, <-0.098924, 0.328046, 0.437807>, <-0.095774, 0.312345, 0.285119>, <-0.128838, 0.284538, 0.282372>, 
      <0.055744, 0.375335, 0.342859>, <0.022681, 0.347528, 0.340113>, <-0.021404, 0.310453, 0.336451>, <-0.054467, 0.282647, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.287014, 0.329310, 1.097271>, <0.207935, 0.357804, 0.875548>, <0.125125, 0.361527, 0.569183>, <0.055744, 0.375335, 0.342859>, 
      <0.287014, 0.329310, 1.097271>, <-0.016298, 0.360125, 0.928158>, <0.003520, 0.342044, 0.666877>, <-0.065861, 0.355852, 0.440553>, 
      <0.287014, 0.329310, 1.097271>, <-0.016298, 0.360125, 0.928158>, <-0.037015, 0.335550, 0.699441>, <-0.228002, 0.329875, 0.570812>, 
      <0.287014, 0.329310, 1.097271>, <0.062781, 0.331631, 1.149881>, <-0.158621, 0.316068, 0.797135>, <-0.349607, 0.310393, 0.668505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.287014, 0.329310, 1.097271>, <0.062781, 0.331631, 1.149881>, <-0.158621, 0.316068, 0.797135>, <-0.349607, 0.310393, 0.668505>, 
      <0.207935, 0.357804, 0.875548>, <-0.016298, 0.360125, 0.928158>, <-0.144450, 0.309636, 0.645362>, <-0.335436, 0.303961, 0.516733>, 
      <0.125125, 0.361527, 0.569183>, <0.017691, 0.335612, 0.515104>, <-0.209107, 0.321299, 0.368448>, <-0.316541, 0.295385, 0.314369>, 
      <0.055744, 0.375335, 0.342859>, <-0.051690, 0.349420, 0.288781>, <-0.194936, 0.314867, 0.216675>, <-0.302370, 0.288953, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.594595, 0.300619, 0.446975>, <0.433735, 0.335339, 0.423973>, <0.217399, 0.352920, 0.374094>, <0.055744, 0.375335, 0.342859>, 
      <0.594595, 0.300619, 0.446975>, <0.471150, 0.328235, 0.262957>, <0.370471, 0.323222, 0.240254>, <0.208816, 0.345636, 0.209020>, 
      <0.594595, 0.300619, 0.446975>, <0.471150, 0.328235, 0.262957>, <0.461566, 0.324697, 0.187046>, <0.414022, 0.317712, 0.028720>, 
      <0.594595, 0.300619, 0.446975>, <0.632010, 0.293515, 0.285960>, <0.613527, 0.283326, 0.055052>, <0.565983, 0.276341, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.594595, 0.300619, 0.446975>, <0.433735, 0.335339, 0.423973>, <0.217399, 0.352920, 0.374094>, <0.055744, 0.375335, 0.342859>, 
      <0.632010, 0.293515, 0.285960>, <0.471150, 0.328235, 0.262957>, <0.288926, 0.317263, 0.105193>, <0.127271, 0.339678, 0.073958>, 
      <0.613527, 0.283326, 0.055052>, <0.568160, 0.276660, -0.096024>, <0.314683, 0.310098, -0.164423>, <0.216788, 0.304638, -0.288170>, 
      <0.565983, 0.276341, -0.103274>, <0.520616, 0.269675, -0.254350>, <0.392062, 0.261937, -0.429731>, <0.294167, 0.256478, -0.553478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.594595, 0.300619, 0.446975>, <0.433735, 0.335339, 0.423973>, <0.217399, 0.352920, 0.374094>, <0.055744, 0.375335, 0.342859>, 
      <0.594595, 0.300619, 0.446975>, <0.384895, 0.344613, 0.634156>, <0.286780, 0.339112, 0.600418>, <0.125125, 0.361527, 0.569183>, 
      <0.594595, 0.300619, 0.446975>, <0.384895, 0.344613, 0.634156>, <0.418196, 0.355627, 0.826216>, <0.207935, 0.357804, 0.875548>, 
      <0.594595, 0.300619, 0.446975>, <0.545755, 0.309892, 0.657158>, <0.497276, 0.327133, 1.047940>, <0.287014, 0.329310, 1.097271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.594595, 0.300619, 0.446975>, <0.545755, 0.309892, 0.657158>, <0.497276, 0.327133, 1.047940>, <0.287014, 0.329310, 1.097271>, 
      <0.632010, 0.293515, 0.285960>, <0.583170, 0.302788, 0.496143>, <0.418196, 0.355627, 0.826216>, <0.207935, 0.357804, 0.875548>, 
      <0.613527, 0.283326, 0.055052>, <0.461566, 0.324697, 0.187046>, <0.278197, 0.331829, 0.435343>, <0.125125, 0.361527, 0.569183>, 
      <0.565983, 0.276341, -0.103274>, <0.414022, 0.317712, 0.028720>, <0.208816, 0.345636, 0.209020>, <0.055744, 0.375335, 0.342859>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.594595, 0.300619, 0.446975>, <0.545755, 0.309892, 0.657158>, <0.497276, 0.327133, 1.047940>, <0.287014, 0.329310, 1.097271>, 
      <0.433735, 0.335339, 0.423973>, <0.384895, 0.344613, 0.634156>, <0.273043, 0.329454, 1.100549>, <0.062781, 0.331631, 1.149881>, 
      <0.217399, 0.352920, 0.374094>, <0.095794, 0.333437, 0.471788>, <-0.037015, 0.335550, 0.699441>, <-0.158621, 0.316068, 0.797135>, 
      <0.055744, 0.375335, 0.342859>, <-0.065861, 0.355852, 0.440553>, <-0.228002, 0.329875, 0.570812>, <-0.349607, 0.310393, 0.668505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.274749, -0.167177, -0.806201>, <-0.223086, -0.170622, -0.605602>, <-0.154203, -0.175216, -0.338136>, <-0.102541, -0.178661, -0.137537>, 
      <-0.260726, -0.194381, -0.719665>, <-0.209063, -0.197826, -0.519065>, <-0.139469, -0.201622, -0.303956>, <-0.087807, -0.205067, -0.103356>, 
      <-0.242028, -0.230652, -0.604283>, <-0.189655, -0.233300, -0.456040>, <-0.120535, -0.237628, -0.206026>, <-0.068162, -0.240277, -0.057783>, 
      <-0.228005, -0.257856, -0.517748>, <-0.175632, -0.260504, -0.369504>, <-0.105801, -0.264035, -0.171846>, <-0.053428, -0.266684, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.153799, -0.140111, -1.419658>, <-0.190084, -0.148231, -1.235621>, <-0.238464, -0.159057, -0.990238>, <-0.274749, -0.167177, -0.806201>, 
      <-0.148164, -0.169191, -1.290577>, <-0.184449, -0.177311, -1.106540>, <-0.224441, -0.186261, -0.903702>, <-0.260726, -0.194381, -0.719665>, 
      <-0.140650, -0.207966, -1.118470>, <-0.168547, -0.214208, -0.976978>, <-0.214131, -0.224409, -0.745776>, <-0.242028, -0.230652, -0.604283>, 
      <-0.135015, -0.237046, -0.989390>, <-0.162912, -0.243289, -0.847897>, <-0.200108, -0.251613, -0.659240>, <-0.228005, -0.257856, -0.517748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.404432, -0.165126, -0.852674>, <0.256351, -0.156867, -1.039859>, <0.013670, -0.147615, -1.249562>, <-0.153799, -0.140111, -1.419658>, 
      <0.383582, -0.201630, -0.762499>, <0.235501, -0.193371, -0.949685>, <0.019306, -0.176696, -1.120482>, <-0.148164, -0.169191, -1.290577>, 
      <0.320487, -0.239017, -0.647860>, <0.206639, -0.232668, -0.791773>, <-0.011896, -0.213735, -0.987696>, <-0.140650, -0.207966, -1.118470>, 
      <0.294167, -0.256279, -0.553478>, <0.180319, -0.249930, -0.697391>, <-0.006260, -0.242816, -0.858616>, <-0.135015, -0.237046, -0.989390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.757979, -0.190964, -0.267101>, <0.698971, -0.182294, -0.463603>, <0.531763, -0.172228, -0.691718>, <0.404432, -0.165126, -0.852674>, 
      <0.713912, -0.230840, -0.213677>, <0.654904, -0.222169, -0.410179>, <0.510913, -0.208731, -0.601543>, <0.383582, -0.201630, -0.762499>, 
      <0.624178, -0.259727, -0.155524>, <0.578811, -0.253061, -0.306600>, <0.418383, -0.244477, -0.524112>, <0.320487, -0.239017, -0.647860>, 
      <0.565984, -0.276143, -0.103274>, <0.520617, -0.269477, -0.254350>, <0.392062, -0.261739, -0.429731>, <0.294167, -0.256279, -0.553478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.795194, -0.222541, 0.448599>, <0.843859, -0.213300, 0.239169>, <0.819819, -0.200049, -0.061169>, <0.757979, -0.190964, -0.267101>, 
      <0.748262, -0.266316, 0.455578>, <0.796927, -0.257076, 0.246148>, <0.775751, -0.239926, -0.007745>, <0.713912, -0.230840, -0.213677>, 
      <0.657066, -0.286416, 0.455284>, <0.694481, -0.279312, 0.294268>, <0.671723, -0.266713, 0.002802>, <0.624178, -0.259727, -0.155524>, 
      <0.594596, -0.300420, 0.446975>, <0.632011, -0.293316, 0.285960>, <0.613528, -0.283128, 0.055052>, <0.565984, -0.276143, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.795194, -0.222541, 0.448599>, <0.748262, -0.266316, 0.455578>, <0.657066, -0.286416, 0.455284>, <0.594596, -0.300420, 0.446975>, 
      <0.731669, -0.234602, 0.721981>, <0.684736, -0.278378, 0.728960>, <0.499918, -0.321645, 0.434384>, <0.437448, -0.335650, 0.426076>, 
      <0.520136, -0.258565, 1.265098>, <0.475345, -0.275788, 1.135859>, <0.324317, -0.322264, 0.663203>, <0.226327, -0.359942, 0.380461>, 
      <0.395128, -0.259860, 1.294427>, <0.350338, -0.277081, 1.165188>, <0.166487, -0.347773, 0.634696>, <0.068498, -0.385450, 0.351954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.795194, -0.222541, 0.448599>, <0.748262, -0.266316, 0.455578>, <0.657066, -0.286416, 0.455284>, <0.594596, -0.300420, 0.446975>, 
      <0.731669, -0.234602, 0.721981>, <0.684736, -0.278378, 0.728960>, <0.608226, -0.295690, 0.665467>, <0.545756, -0.309694, 0.657159>, 
      <0.520136, -0.258565, 1.265098>, <0.510745, -0.280255, 1.243137>, <0.520208, -0.318119, 1.114109>, <0.497276, -0.326936, 1.047940>, 
      <0.395128, -0.259860, 1.294427>, <0.385738, -0.281549, 1.272466>, <0.309946, -0.320295, 1.163440>, <0.287014, -0.329112, 1.097271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159041, -0.199166, 0.188346>, <-0.127669, -0.224150, 0.231954>, <-0.085839, -0.257464, 0.290097>, <-0.054467, -0.282448, 0.333704>, 
      <-0.221870, -0.201626, 0.157258>, <-0.190498, -0.226611, 0.200865>, <-0.160210, -0.259355, 0.238765>, <-0.128838, -0.284340, 0.282372>, 
      <-0.305642, -0.204906, 0.115806>, <-0.285812, -0.229323, 0.139170>, <-0.247829, -0.262446, 0.190565>, <-0.227999, -0.286863, 0.213929>, 
      <-0.368471, -0.207367, 0.084717>, <-0.348641, -0.231783, 0.108081>, <-0.322200, -0.264338, 0.139233>, <-0.302370, -0.288754, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.374361, -0.190142, -0.342868>, <-0.309765, -0.192849, -0.183503>, <-0.223637, -0.196459, 0.028982>, <-0.159041, -0.199166, 0.188346>, 
      <-0.357112, -0.215753, -0.292430>, <-0.292515, -0.218460, -0.133066>, <-0.192265, -0.221443, 0.072590>, <-0.127669, -0.224150, 0.231954>, 
      <-0.334112, -0.249902, -0.225180>, <-0.255394, -0.251982, -0.072646>, <-0.164558, -0.255383, 0.137563>, <-0.085839, -0.257464, 0.290097>, 
      <-0.316863, -0.275512, -0.174743>, <-0.238144, -0.277593, -0.022208>, <-0.133186, -0.280368, 0.181170>, <-0.054467, -0.282448, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.374361, -0.190142, -0.342868>, <-0.357112, -0.215753, -0.292430>, <-0.334112, -0.249902, -0.225180>, <-0.316863, -0.275512, -0.174743>, 
      <-0.292815, -0.186698, -0.281268>, <-0.275566, -0.212309, -0.230831>, <-0.255082, -0.247253, -0.179838>, <-0.237832, -0.272864, -0.129401>, 
      <-0.184087, -0.182105, -0.199136>, <-0.169353, -0.208512, -0.164956>, <-0.147192, -0.242925, -0.103125>, <-0.132458, -0.269332, -0.068945>, 
      <-0.102541, -0.178661, -0.137537>, <-0.087807, -0.205067, -0.103356>, <-0.068162, -0.240277, -0.057783>, <-0.053428, -0.266684, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.349607, -0.310194, 0.668505>, <-0.374599, -0.287712, 0.688975>, <-0.407923, -0.257736, 0.716268>, <-0.432915, -0.235254, 0.736738>, 
      <-0.158621, -0.315870, 0.797135>, <-0.183613, -0.293388, 0.817605>, <-0.159510, -0.265118, 0.883575>, <-0.184502, -0.242635, 0.904045>, 
      <0.062781, -0.331434, 1.149881>, <0.085713, -0.322616, 1.216050>, <0.252424, -0.282929, 1.303744>, <0.261814, -0.261240, 1.325706>, 
      <0.287014, -0.329112, 1.097271>, <0.309946, -0.320295, 1.163440>, <0.385738, -0.281549, 1.272466>, <0.395128, -0.259860, 1.294427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.349607, -0.310194, 0.668505>, <-0.374599, -0.287712, 0.688975>, <-0.407923, -0.257736, 0.716268>, <-0.432915, -0.235254, 0.736738>, 
      <-0.335436, -0.303762, 0.516733>, <-0.360428, -0.281280, 0.537203>, <-0.388589, -0.249370, 0.520662>, <-0.413582, -0.226887, 0.541132>, 
      <-0.316541, -0.295186, 0.314369>, <-0.336371, -0.270770, 0.291005>, <-0.367974, -0.240149, 0.303687>, <-0.387804, -0.215733, 0.280324>, 
      <-0.302370, -0.288754, 0.162596>, <-0.322200, -0.264338, 0.139233>, <-0.348641, -0.231783, 0.108081>, <-0.368471, -0.207367, 0.084717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.349607, -0.310194, 0.668505>, <-0.335436, -0.303762, 0.516733>, <-0.316541, -0.295186, 0.314369>, <-0.302370, -0.288754, 0.162596>, 
      <-0.158621, -0.315870, 0.797135>, <-0.144450, -0.309438, 0.645362>, <-0.205281, -0.324195, 0.371177>, <-0.191109, -0.317763, 0.219404>, 
      <0.062781, -0.331434, 1.149881>, <-0.013120, -0.360618, 0.930872>, <0.022793, -0.339540, 0.518742>, <-0.042762, -0.356442, 0.295147>, 
      <0.287014, -0.329112, 1.097271>, <0.211113, -0.358297, 0.878262>, <0.134053, -0.368549, 0.575550>, <0.068498, -0.385450, 0.351954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.274750, 0.160366, -0.806201>, <-0.260727, 0.189672, -0.719665>, <-0.242029, 0.228747, -0.604283>, <-0.228006, 0.258054, -0.517748>, 
      <-0.223087, 0.163811, -0.605602>, <-0.209064, 0.193117, -0.519065>, <-0.189656, 0.231396, -0.456040>, <-0.175633, 0.260702, -0.369504>, 
      <-0.154204, 0.168404, -0.338136>, <-0.139470, 0.196914, -0.303956>, <-0.120535, 0.235723, -0.206026>, <-0.105801, 0.264233, -0.171846>, 
      <-0.102541, 0.171849, -0.137537>, <-0.087807, 0.200358, -0.103356>, <-0.068162, 0.238372, -0.057783>, <-0.053428, 0.266882, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.153800, 0.133299, -1.419658>, <-0.148165, 0.164482, -1.290577>, <-0.140651, 0.206061, -1.118470>, <-0.135016, 0.237245, -0.989390>, 
      <-0.190085, 0.141419, -1.235621>, <-0.184450, 0.172602, -1.106540>, <-0.168548, 0.212304, -0.976978>, <-0.162913, 0.243487, -0.847897>, 
      <-0.238465, 0.152246, -0.990238>, <-0.224442, 0.181552, -0.903702>, <-0.214132, 0.222504, -0.745776>, <-0.200109, 0.251811, -0.659240>, 
      <-0.274750, 0.160366, -0.806201>, <-0.260727, 0.189672, -0.719665>, <-0.242029, 0.228747, -0.604283>, <-0.228006, 0.258054, -0.517748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.404432, 0.158315, -0.852674>, <0.383409, 0.194501, -0.761752>, <0.321776, 0.239294, -0.648138>, <0.294167, 0.256478, -0.553478>, 
      <0.256351, 0.150056, -1.039859>, <0.235328, 0.186242, -0.948938>, <0.207927, 0.232945, -0.792052>, <0.180318, 0.250128, -0.697391>, 
      <0.013670, 0.140803, -1.249562>, <0.019305, 0.171987, -1.120482>, <-0.011896, 0.211831, -0.987696>, <-0.006261, 0.243014, -0.858616>, 
      <-0.153800, 0.133299, -1.419658>, <-0.148165, 0.164482, -1.290577>, <-0.140651, 0.206061, -1.118470>, <-0.135016, 0.237245, -0.989390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.757978, 0.184152, -0.267101>, <0.713353, 0.223900, -0.213002>, <0.625595, 0.260111, -0.155052>, <0.565983, 0.276341, -0.103274>, 
      <0.698970, 0.175482, -0.463603>, <0.654346, 0.215230, -0.409504>, <0.580228, 0.253446, -0.306129>, <0.520616, 0.269675, -0.254350>, 
      <0.531763, 0.165416, -0.691718>, <0.510740, 0.201602, -0.600796>, <0.419671, 0.244754, -0.524391>, <0.392062, 0.261937, -0.429731>, 
      <0.404432, 0.158315, -0.852674>, <0.383409, 0.194501, -0.761752>, <0.321776, 0.239294, -0.648138>, <0.294167, 0.256478, -0.553478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.795193, 0.215729, 0.448599>, <0.747371, 0.259692, 0.455711>, <0.657857, 0.286964, 0.456022>, <0.594595, 0.300619, 0.446975>, 
      <0.843858, 0.206488, 0.239169>, <0.796036, 0.250452, 0.246280>, <0.695272, 0.279860, 0.295006>, <0.632010, 0.293515, 0.285960>, 
      <0.819818, 0.193238, -0.061168>, <0.775193, 0.232986, -0.007070>, <0.673139, 0.267097, 0.003274>, <0.613527, 0.283326, 0.055052>, 
      <0.757978, 0.184152, -0.267101>, <0.713353, 0.223900, -0.213002>, <0.625595, 0.260111, -0.155052>, <0.565983, 0.276341, -0.103274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.395128, 0.253047, 1.294427>, <0.385595, 0.274777, 1.272133>, <0.310769, 0.320750, 1.163876>, <0.287014, 0.329310, 1.097271>, 
      <0.520135, 0.251754, 1.265098>, <0.510603, 0.273483, 1.242804>, <0.521031, 0.318574, 1.114544>, <0.497276, 0.327133, 1.047940>, 
      <0.731668, 0.227790, 0.721981>, <0.683846, 0.271754, 0.729092>, <0.609017, 0.296237, 0.666205>, <0.545755, 0.309892, 0.657158>, 
      <0.795193, 0.215729, 0.448599>, <0.747371, 0.259692, 0.455711>, <0.657857, 0.286964, 0.456022>, <0.594595, 0.300619, 0.446975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.432915, 0.228442, 0.736738>, <-0.407923, 0.253027, 0.716268>, <-0.374599, 0.285807, 0.688975>, <-0.349607, 0.310393, 0.668505>, 
      <-0.184502, 0.235823, 0.904045>, <-0.159510, 0.260409, 0.883575>, <-0.183613, 0.291482, 0.817605>, <-0.158621, 0.316068, 0.797135>, 
      <0.261814, 0.254428, 1.325706>, <0.252281, 0.276157, 1.303411>, <0.086536, 0.323071, 1.216486>, <0.062781, 0.331631, 1.149881>, 
      <0.395128, 0.253047, 1.294427>, <0.385595, 0.274777, 1.272133>, <0.310769, 0.320750, 1.163876>, <0.287014, 0.329310, 1.097271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.368471, 0.200555, 0.084717>, <-0.348641, 0.227074, 0.108081>, <-0.322200, 0.262433, 0.139233>, <-0.302370, 0.288953, 0.162596>, 
      <-0.387804, 0.208921, 0.280324>, <-0.367974, 0.235440, 0.303687>, <-0.336371, 0.268865, 0.291005>, <-0.316541, 0.295385, 0.314369>, 
      <-0.413582, 0.220076, 0.541132>, <-0.388589, 0.244661, 0.520662>, <-0.360428, 0.279375, 0.537203>, <-0.335436, 0.303961, 0.516733>, 
      <-0.432915, 0.228442, 0.736738>, <-0.407923, 0.253027, 0.716268>, <-0.374599, 0.285807, 0.688975>, <-0.349607, 0.310393, 0.668505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159041, 0.192354, 0.188346>, <-0.127669, 0.219442, 0.231954>, <-0.085839, 0.255559, 0.290097>, <-0.054467, 0.282647, 0.333704>, 
      <-0.221870, 0.194814, 0.157258>, <-0.190498, 0.221902, 0.200865>, <-0.160210, 0.257451, 0.238765>, <-0.128838, 0.284538, 0.282372>, 
      <-0.305642, 0.198094, 0.115806>, <-0.285812, 0.224614, 0.139170>, <-0.247829, 0.260541, 0.190565>, <-0.227999, 0.287061, 0.213929>, 
      <-0.368471, 0.200555, 0.084717>, <-0.348641, 0.227074, 0.108081>, <-0.322200, 0.262433, 0.139233>, <-0.302370, 0.288953, 0.162596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.374362, 0.183331, -0.342868>, <-0.357113, 0.211045, -0.292430>, <-0.334113, 0.247997, -0.225180>, <-0.316864, 0.275711, -0.174743>, 
      <-0.309766, 0.186037, -0.183503>, <-0.292516, 0.213752, -0.133066>, <-0.255394, 0.250077, -0.072646>, <-0.238145, 0.277791, -0.022208>, 
      <-0.223637, 0.189647, 0.028982>, <-0.192265, 0.216735, 0.072590>, <-0.164558, 0.253478, 0.137563>, <-0.133186, 0.280566, 0.181170>, 
      <-0.159041, 0.192354, 0.188346>, <-0.127669, 0.219442, 0.231954>, <-0.085839, 0.255559, 0.290097>, <-0.054467, 0.282647, 0.333704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.374362, 0.183331, -0.342868>, <-0.292816, 0.179886, -0.281268>, <-0.184087, 0.175293, -0.199136>, <-0.102541, 0.171849, -0.137537>, 
      <-0.357113, 0.211045, -0.292430>, <-0.275566, 0.207600, -0.230831>, <-0.169353, 0.203803, -0.164956>, <-0.087807, 0.200358, -0.103356>, 
      <-0.334113, 0.247997, -0.225180>, <-0.255082, 0.245348, -0.179838>, <-0.147193, 0.241020, -0.103125>, <-0.068162, 0.238372, -0.057783>, 
      <-0.316864, 0.275711, -0.174743>, <-0.237833, 0.273062, -0.129401>, <-0.132459, 0.269530, -0.068945>, <-0.053428, 0.266882, -0.023603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.387697, 0.002276, -1.135373>, <-0.314609, 0.002276, -0.883089>, <-0.217158, 0.002276, -0.546710>, <-0.144070, 0.002276, -0.294427>, 
      <-0.353812, -0.048560, -1.036621>, <-0.280724, -0.048560, -0.784337>, <-0.204699, -0.052005, -0.499644>, <-0.131611, -0.052005, -0.247360>, 
      <-0.308633, -0.116342, -0.904952>, <-0.256971, -0.119787, -0.704353>, <-0.166662, -0.120935, -0.385203>, <-0.115000, -0.124380, -0.184604>, 
      <-0.274749, -0.167177, -0.806201>, <-0.223086, -0.170622, -0.605602>, <-0.154203, -0.175216, -0.338136>, <-0.102541, -0.178661, -0.137537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.387697, 0.002276, -1.135373>, <-0.353813, 0.049703, -1.036621>, <-0.308634, 0.112939, -0.904952>, <-0.274750, 0.160366, -0.806201>, 
      <-0.314609, 0.002276, -0.883089>, <-0.280725, 0.049703, -0.784337>, <-0.256971, 0.116384, -0.704353>, <-0.223087, 0.163811, -0.605602>, 
      <-0.217158, 0.002276, -0.546710>, <-0.204699, 0.053148, -0.499644>, <-0.166662, 0.117532, -0.385203>, <-0.154204, 0.168404, -0.338136>, 
      <-0.144070, 0.002276, -0.294427>, <-0.131611, 0.053148, -0.247360>, <-0.115000, 0.120977, -0.184604>, <-0.102541, 0.171849, -0.137537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.239970, 0.002276, -1.885373>, <-0.284288, 0.002276, -1.660373>, <-0.343379, 0.002276, -1.360373>, <-0.387697, 0.002276, -1.135373>, 
      <-0.214119, -0.040440, -1.745658>, <-0.258437, -0.040440, -1.520658>, <-0.309494, -0.048560, -1.261621>, <-0.353812, -0.048560, -1.036621>, 
      <-0.179650, -0.097395, -1.559372>, <-0.215935, -0.105515, -1.375335>, <-0.272348, -0.108222, -1.088989>, <-0.308633, -0.116342, -0.904952>, 
      <-0.153799, -0.140111, -1.419658>, <-0.190084, -0.148231, -1.235621>, <-0.238464, -0.159057, -0.990238>, <-0.274749, -0.167177, -0.806201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.239970, 0.002276, -1.885373>, <-0.214119, 0.041583, -1.745658>, <-0.179651, 0.093992, -1.559372>, <-0.153800, 0.133299, -1.419658>, 
      <-0.284288, 0.002276, -1.660373>, <-0.258437, 0.041583, -1.520658>, <-0.215936, 0.102112, -1.375335>, <-0.190085, 0.141419, -1.235621>, 
      <-0.343379, 0.002276, -1.360373>, <-0.309495, 0.049703, -1.261621>, <-0.272349, 0.104819, -1.088989>, <-0.238465, 0.152246, -0.990238>, 
      <-0.387697, 0.002276, -1.135373>, <-0.353813, 0.049703, -1.036621>, <-0.308634, 0.112939, -0.904952>, <-0.274750, 0.160366, -0.806201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.441849, 0.002276, -1.192191>, <0.441849, 0.114933, -1.192191>, <0.428094, 0.117585, -0.955011>, <0.404432, 0.158315, -0.852674>, 
      <0.260984, 0.002276, -1.421040>, <0.260984, 0.114933, -1.421040>, <0.280013, 0.109326, -1.142197>, <0.256351, 0.150056, -1.039859>, 
      <-0.035424, 0.002276, -1.677418>, <-0.009573, 0.041583, -1.537703>, <-0.012181, 0.101497, -1.389277>, <0.013670, 0.140803, -1.249562>, 
      <-0.239970, 0.002276, -1.885373>, <-0.214119, 0.041583, -1.745658>, <-0.179651, 0.093992, -1.559372>, <-0.153800, 0.133299, -1.419658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.441849, 0.002276, -1.192191>, <0.260984, 0.002276, -1.421040>, <-0.035424, 0.002276, -1.677418>, <-0.239970, 0.002276, -1.885373>, 
      <0.441849, -0.111841, -1.192191>, <0.260984, -0.111841, -1.421040>, <-0.009573, -0.040440, -1.537703>, <-0.214119, -0.040440, -1.745658>, 
      <0.428347, -0.123258, -0.956103>, <0.280266, -0.114999, -1.143289>, <-0.012181, -0.104900, -1.389277>, <-0.179650, -0.097395, -1.559372>, 
      <0.404432, -0.165126, -0.852674>, <0.256351, -0.156867, -1.039859>, <0.013670, -0.147615, -1.249562>, <-0.153799, -0.140111, -1.419658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.873667, 0.002276, -0.476282>, <0.801595, 0.002276, -0.716521>, <0.597370, 0.002276, -0.995410>, <0.441849, 0.002276, -1.192191>, 
      <0.873667, -0.089938, -0.476282>, <0.801596, -0.089938, -0.716521>, <0.597370, -0.111841, -0.995410>, <0.441849, -0.111841, -1.192191>, 
      <0.808830, -0.144950, -0.328747>, <0.749821, -0.136280, -0.525250>, <0.555678, -0.130359, -0.795147>, <0.428347, -0.123258, -0.956103>, 
      <0.757979, -0.190964, -0.267101>, <0.698971, -0.182294, -0.463603>, <0.531763, -0.172228, -0.691718>, <0.404432, -0.165126, -0.852674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.873667, 0.002276, -0.476282>, <0.873667, 0.092385, -0.476282>, <0.807862, 0.139719, -0.327575>, <0.757978, 0.184152, -0.267101>, 
      <0.801595, 0.002276, -0.716521>, <0.801595, 0.092385, -0.716521>, <0.748854, 0.131049, -0.524077>, <0.698970, 0.175482, -0.463603>, 
      <0.597370, 0.002276, -0.995410>, <0.597370, 0.114933, -0.995410>, <0.555425, 0.124687, -0.794056>, <0.531763, 0.165416, -0.691718>, 
      <0.441849, 0.002276, -1.192191>, <0.441849, 0.114933, -1.192191>, <0.428094, 0.117585, -0.955011>, <0.404432, 0.158315, -0.852674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.919121, 0.002276, 0.398718>, <0.978560, 0.002276, 0.142673>, <0.949198, 0.002276, -0.224513>, <0.873667, 0.002276, -0.476282>, 
      <0.919121, -0.076178, 0.398718>, <0.978560, -0.076178, 0.142673>, <0.949198, -0.089938, -0.224513>, <0.873667, -0.089938, -0.476282>, 
      <0.852229, -0.169342, 0.440118>, <0.900894, -0.160102, 0.230688>, <0.870669, -0.154036, -0.122815>, <0.808830, -0.144950, -0.328747>, 
      <0.795194, -0.222541, 0.448599>, <0.843859, -0.213300, 0.239169>, <0.819819, -0.200049, -0.061169>, <0.757979, -0.190964, -0.267101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.919121, 0.002276, 0.398718>, <0.919121, 0.077819, 0.398718>, <0.850476, 0.164906, 0.440379>, <0.795193, 0.215729, 0.448599>, 
      <0.978560, 0.002276, 0.142673>, <0.978560, 0.077819, 0.142673>, <0.899141, 0.155666, 0.230948>, <0.843858, 0.206488, 0.239169>, 
      <0.949198, 0.002276, -0.224513>, <0.949197, 0.092385, -0.224513>, <0.869701, 0.148805, -0.121643>, <0.819818, 0.193238, -0.061168>, 
      <0.873667, 0.002276, -0.476282>, <0.873667, 0.092385, -0.476282>, <0.807862, 0.139719, -0.327575>, <0.757978, 0.184152, -0.267101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.430485, 0.002276, 1.432809>, <0.430485, 0.088854, 1.432809>, <0.406715, 0.226636, 1.321526>, <0.395128, 0.253047, 1.294427>, 
      <0.577076, 0.002276, 1.122582>, <0.577076, 0.088854, 1.122582>, <0.531722, 0.225342, 1.292196>, <0.520135, 0.251754, 1.265098>, 
      <0.841532, 0.002276, 0.732949>, <0.841532, 0.077819, 0.732949>, <0.786951, 0.176968, 0.713760>, <0.731668, 0.227790, 0.721981>, 
      <0.919121, 0.002276, 0.398718>, <0.919121, 0.077819, 0.398718>, <0.850476, 0.164906, 0.440379>, <0.795193, 0.215729, 0.448599>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.430485, 0.002276, 1.432809>, <0.577076, 0.002276, 1.122582>, <0.841532, 0.002276, 0.732949>, <0.919121, 0.002276, 0.398718>, 
      <0.430485, -0.087281, 1.432809>, <0.577076, -0.087281, 1.122582>, <0.841532, -0.076178, 0.732949>, <0.919121, -0.076178, 0.398718>, 
      <0.407042, -0.232340, 1.322292>, <0.532050, -0.231046, 1.292963>, <0.788703, -0.181404, 0.713500>, <0.852229, -0.169342, 0.440118>, 
      <0.395128, -0.259860, 1.294427>, <0.520136, -0.258565, 1.265098>, <0.731669, -0.234602, 0.721981>, <0.795194, -0.222541, 0.448599>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.580879, 0.002276, 0.750991>, <-0.277470, 0.002276, 0.955537>, <0.127076, 0.002276, 1.228264>, <0.430485, 0.002276, 1.432809>, 
      <-0.536490, -0.068983, 0.746715>, <-0.233081, -0.068983, 0.951261>, <0.127076, -0.087281, 1.228264>, <0.430485, -0.087281, 1.432809>, 
      <-0.477304, -0.163995, 0.741014>, <-0.228891, -0.171376, 0.908321>, <0.273728, -0.233720, 1.353570>, <0.407042, -0.232340, 1.322292>, 
      <-0.432915, -0.235254, 0.736738>, <-0.184502, -0.242635, 0.904045>, <0.261814, -0.261240, 1.325706>, <0.395128, -0.259860, 1.294427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.580879, 0.002276, 0.750991>, <-0.536490, 0.070125, 0.746715>, <-0.477304, 0.160592, 0.741014>, <-0.432915, 0.228442, 0.736738>, 
      <-0.277470, 0.002276, 0.955537>, <-0.233081, 0.070125, 0.951261>, <-0.228891, 0.167974, 0.908321>, <-0.184502, 0.235823, 0.904045>, 
      <0.127076, 0.002276, 1.228264>, <0.127076, 0.088854, 1.228264>, <0.273401, 0.228016, 1.352804>, <0.261814, 0.254428, 1.325706>, 
      <0.430485, 0.002276, 1.432809>, <0.430485, 0.088854, 1.432809>, <0.406715, 0.226636, 1.321526>, <0.395128, 0.253047, 1.294427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.499957, 0.002276, -0.041711>, <-0.499957, 0.083102, -0.041711>, <-0.407917, 0.141071, 0.046789>, <-0.368471, 0.200555, 0.084717>, 
      <-0.524234, 0.002276, 0.196100>, <-0.524234, 0.083102, 0.196100>, <-0.427250, 0.149437, 0.242395>, <-0.387804, 0.208921, 0.280324>, 
      <-0.556602, 0.002276, 0.513181>, <-0.512213, 0.070125, 0.508905>, <-0.457971, 0.152226, 0.545408>, <-0.413582, 0.220076, 0.541132>, 
      <-0.580879, 0.002276, 0.750991>, <-0.536490, 0.070125, 0.746715>, <-0.477304, 0.160592, 0.741014>, <-0.432915, 0.228442, 0.736738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.499957, 0.002276, -0.041711>, <-0.524234, 0.002276, 0.196100>, <-0.556602, 0.002276, 0.513181>, <-0.580879, 0.002276, 0.750991>, 
      <-0.499957, -0.081091, -0.041711>, <-0.524234, -0.081091, 0.196100>, <-0.512213, -0.068983, 0.508905>, <-0.536490, -0.068983, 0.746715>, 
      <-0.407917, -0.144474, 0.046789>, <-0.427250, -0.152840, 0.242395>, <-0.457971, -0.155629, 0.545408>, <-0.477304, -0.163995, 0.741014>, 
      <-0.368471, -0.207367, 0.084717>, <-0.387804, -0.215733, 0.280324>, <-0.413582, -0.226887, 0.541132>, <-0.432915, -0.235254, 0.736738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165908, 0.002276, 0.183905>, <-0.163848, 0.059299, 0.185238>, <-0.161101, 0.135330, 0.187014>, <-0.159041, 0.192354, 0.188346>, 
      <-0.266123, 0.002276, 0.116221>, <-0.264062, 0.059299, 0.117553>, <-0.223930, 0.137791, 0.155925>, <-0.221870, 0.194814, 0.157258>, 
      <-0.399742, 0.002276, 0.025974>, <-0.399742, 0.083102, 0.025974>, <-0.345088, 0.138611, 0.077878>, <-0.305642, 0.198094, 0.115806>, 
      <-0.499957, 0.002276, -0.041711>, <-0.499957, 0.083102, -0.041711>, <-0.407917, 0.141071, 0.046789>, <-0.368471, 0.200555, 0.084717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165908, 0.002276, 0.183905>, <-0.266123, 0.002276, 0.116221>, <-0.399742, 0.002276, 0.025974>, <-0.499957, 0.002276, -0.041711>, 
      <-0.163848, -0.058157, 0.185238>, <-0.264062, -0.058157, 0.117553>, <-0.399742, -0.081091, 0.025974>, <-0.499957, -0.081091, -0.041711>, 
      <-0.161101, -0.138733, 0.187014>, <-0.223930, -0.141194, 0.155925>, <-0.345088, -0.142014, 0.077878>, <-0.407917, -0.144474, 0.046789>, 
      <-0.159041, -0.199166, 0.188346>, <-0.221870, -0.201626, 0.157258>, <-0.305642, -0.204906, 0.115806>, <-0.368471, -0.207367, 0.084717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.497608, 0.002276, -0.556186>, <-0.497608, 0.093997, -0.556186>, <-0.411336, 0.129014, -0.406863>, <-0.374362, 0.183331, -0.342868>, 
      <-0.398098, 0.002276, -0.334158>, <-0.398098, 0.093997, -0.334158>, <-0.346739, 0.131721, -0.247499>, <-0.309766, 0.186037, -0.183503>, 
      <-0.265418, 0.002276, -0.038122>, <-0.263358, 0.059299, -0.036790>, <-0.225697, 0.132623, 0.027650>, <-0.223637, 0.189647, 0.028982>, 
      <-0.165908, 0.002276, 0.183905>, <-0.163848, 0.059299, 0.185238>, <-0.161101, 0.135330, 0.187014>, <-0.159041, 0.192354, 0.188346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.497608, 0.002276, -0.556186>, <-0.398098, 0.002276, -0.334158>, <-0.265418, 0.002276, -0.038122>, <-0.165908, 0.002276, 0.183905>, 
      <-0.497608, -0.091505, -0.556186>, <-0.398098, -0.091505, -0.334158>, <-0.263358, -0.058157, -0.036790>, <-0.163848, -0.058157, 0.185238>, 
      <-0.411335, -0.132417, -0.406863>, <-0.346739, -0.135124, -0.247499>, <-0.225697, -0.136026, 0.027650>, <-0.161101, -0.138733, 0.187014>, 
      <-0.374361, -0.190142, -0.342868>, <-0.309765, -0.192849, -0.183503>, <-0.223637, -0.196459, 0.028982>, <-0.159041, -0.199166, 0.188346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.497608, 0.002276, -0.556186>, <-0.497608, -0.091505, -0.556186>, <-0.411335, -0.132417, -0.406863>, <-0.374361, -0.190142, -0.342868>, 
      <-0.391547, 0.002276, -0.477658>, <-0.391546, -0.091505, -0.477658>, <-0.329789, -0.128972, -0.345264>, <-0.292815, -0.186698, -0.281268>, 
      <-0.250131, 0.002276, -0.372954>, <-0.237673, -0.052005, -0.325887>, <-0.196546, -0.127824, -0.246203>, <-0.184087, -0.182105, -0.199136>, 
      <-0.144070, 0.002276, -0.294427>, <-0.131611, -0.052005, -0.247360>, <-0.115000, -0.124380, -0.184604>, <-0.102541, -0.178661, -0.137537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.497608, 0.002276, -0.556186>, <-0.391547, 0.002276, -0.477658>, <-0.250131, 0.002276, -0.372954>, <-0.144070, 0.002276, -0.294427>, 
      <-0.497608, 0.093997, -0.556186>, <-0.391547, 0.093997, -0.477658>, <-0.237673, 0.053148, -0.325887>, <-0.131611, 0.053148, -0.247360>, 
      <-0.411336, 0.129014, -0.406863>, <-0.329789, 0.125570, -0.345264>, <-0.196546, 0.124421, -0.246203>, <-0.115000, 0.120977, -0.184604>, 
      <-0.374362, 0.183331, -0.342868>, <-0.292816, 0.179886, -0.281268>, <-0.184087, 0.175293, -0.199136>, <-0.102541, 0.171849, -0.137537>
    }
  }
  scale <16.5, 19.0, 16.5>
  rotate <-55.0, 0.0, 180.0>
  translate  <-25.2, -200.2, -48.7>
}
#declare HeadGroup = union {
  sphere { // RightEye
    <0,0,0>,1
    scale <12.0, 12.0, 10.0>
    rotate <-39.97789, 53.405273, 0.148366>
    translate  <29.8, -242.2, 10.6>
  }
  object { // Head->Abdomen
    Abdomen
    scale <0.7, 0.66, 0.7>
    rotate <120.0, 0.0, -0.0>
    translate  <-2.8, -497.1, 309.9>
  }
  sphere { // LeftEye
    <0,0,0>,1
    scale <12.0, 12.0, 10.0>
    rotate <-39.97789, -53.40527, 0.148366>
    translate  <-45.7, -242.5, 10.6>
  }
  object { RightMandible }
  object { Leftmandible }
  cylinder { // Antenna1
    <0,0,1>, <0,0,0>, 1 
    scale <4.5, 4.5, 135.0>
    rotate <-38.935719, 24.33399, -18.109215>
    translate  <11.4, -226.3, -4.3>
  }
  cylinder { // Antenna3
    <0,0,1>, <0,0,0>, 1 
    scale <4.5, 4.5, 220.0>
    rotate <-94.241478, 22.560369, -32.977573>
    translate  <79.8, -158.0, 91.0>
  }
  cylinder { // Antenna2
    <0,0,1>, <0,0,0>, 1 
    scale <4.5, 4.5, 135.0>
    rotate <-35.913902, -32.964249, 9.050775>
    translate  <-29.0, -224.9, -2.9>
  }
  cylinder { // Antenna4
    <0,0,1>, <0,0,0>, 1 
    scale <4.5, 4.5, 220.0>
    rotate <-91.893158, 26.081533, 32.873726>
    translate  <-99.9, -156.5, 89.3>
  }
}
#declare FLLeg = union {
  cylinder { // TopLeg2
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 90.0>
    rotate <-71.717392, 43.450447, 62.577026>
    translate  <-61.4, -339.1, -14.9>
  }
  cylinder { // Ankle2
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 60.0>
    rotate <-141.65274, 18.810217, -18.679956>
    translate  <-155.7, -236.5, -80.3>
  }
  cylinder { // MidLeg2
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 100.0>
    rotate <-152.253052, 18.741678, -1.024127>
    translate  <-128.2, -282.7, 4.3>
  }
  cylinder { // Foot2
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 25.0>
    rotate <-122.844643, 25.466444, -5.967997>
    translate  <-158.2, -197.6, -124.1>
  }
}
#declare FRLeg = union {
  cylinder { // TopLeg1
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 90.0>
    rotate <-84.023521, -0.310008, -51.979115>
    translate  <46.4, -339.0, -16.8>
  }
  cylinder { // Ankle1
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 60.0>
    rotate <-149.381332, 11.334025, -25.541904>
    translate  <142.5, -222.2, -80.8>
  }
  cylinder { // MidLeg1
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 100.0>
    rotate <-137.902649, 7.90939, -30.381447>
    translate  <117.7, -284.0, -8.2>
  }
  cylinder { // Foot1
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 25.0>
    rotate <-121.874603, 20.601542, -16.519442>
    translate  <146.4, -192.0, -129.7>
  }
}
#declare MLLeg = union {
  cylinder { // TopLeg3
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 90.0>
    rotate <-75.215607, 33.928623, 113.109657>
    translate  <-59.0, -335.9, -17.9>
  }
  cylinder { // Ankle3
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 40.0>
    rotate <139.486237, -7.945269, -28.357>
    translate  <-144.3, -412.0, -64.2>
  }
  cylinder { // MidLeg3
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 85.0>
    rotate <141.156204, 2.410851, 3.655393>
    translate  <-144.4, -358.6, 2.0>
  }
  cylinder { // Foot3
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 25.0>
    rotate <112.855576, -4.5524, -19.972208>
    translate  <-153.4, -436.7, -94.7>
  }
  translate  <1.8, -67.4, -36.7>
}
#declare MRLeg = union {
  cylinder { // TopLeg4
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 90.0>
    rotate <-71.392517, 29.436211, -90.594872>
    translate  <-164.5, -352.2, -20.1>
  }
  cylinder { // Ankle4
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 40.0>
    rotate <145.773087, -26.020975, -17.583109>
    translate  <-80.2, -424.3, -62.1>
  }
  cylinder { // MidLeg4
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 85.0>
    rotate <140.153748, 2.430506, 2.421483>
    translate  <-80.1, -368.8, 3.7>
  }
  cylinder { // Foot4
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 25.0>
    rotate <121.803955, -34.766453, 3.713757>
    translate  <-72.6, -449.7, -92.8>
  }
  translate  <203.4, -49.7, -36.7>
}
#declare BLLeg = union {
  cylinder { // TopLeg5
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 80.0>
    rotate <-66.373627, 33.247513, 107.801071>
    translate  <-49.6, -336.5, -23.3>
  }
  cylinder { // Ankle5
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 50.0>
    rotate <143.024445, -9.090441, -27.31362>
    translate  <-130.1, -407.3, -59.7>
  }
  cylinder { // MidLeg5
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 90.0>
    rotate <134.778641, 4.809363, 1.939483>
    translate  <-127.1, -343.6, 4.1>
  }
  cylinder { // Foot5
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 25.0>
    rotate <120.032013, 6.244647, -30.739841>
    translate  <-138.1, -437.1, -99.2>
  }
  rotate <19.160196, 23.535532, 41.027493>
  translate  <-186.2, -160.1, 34.8>
}
#declare BRLeg = union {
  cylinder { // TopLeg6
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 80.0>
    rotate <-39.373055, 7.554862, 164.056107>
    translate  <18.5, -388.1, 24.4>
  }
  cylinder { // Ankle6
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 50.0>
    rotate <124.878357, -20.235281, -12.148963>
    translate  <-13.2, -502.2, 26.0>
  }
  cylinder { // MidLeg6
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 90.0>
    rotate <133.466232, 7.797774, -1.244599>
    translate  <-4.1, -436.3, 86.8>
  }
  cylinder { // Foot6
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 25.0>
    rotate <113.175827, -1.90882, -5.528273>
    translate  <-12.5, -545.3, -0.5>
  }
  rotate <19.160196, 23.535532, 41.027493>
  translate  <-186.2, -160.1, 34.8>
}
#declare Ant = union {
  object { Abdomen }
  sphere { // AbJoiner
    <0,0,0>,1
    scale <15.8, 18.0, 12.5>
    translate  <-6.3, -491.9, -44.1>
  }
  object { Thorax }
  object { HeadGroup }
  object { FLLeg }
  object { FRLeg }
  object { MLLeg }
  object { MRLeg }
  object { BLLeg }
  object { BRLeg }
  texture {
    AntBody
  }
  scale 0.004
  rotate <-4.5, 0.0, -90.0>
  translate  <8.4, -0.3, 2.35>
}


#declare Petal7 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 3,
      <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, 
      <-0.700000, 1.900000, 2.100000>, <-0.300000, 1.100000, 2.100000>, <0.300000, 1.100000, 2.100000>, <0.700000, 1.900000, 2.100000>, 
      <-1.300000, 2.100000, 3.400000>, <-0.500000, 2.851876, 3.589625>, <0.500000, 2.851876, 3.589625>, <1.300000, 2.100000, 3.400000>, 
      <-0.600000, 1.700000, 4.000000>, <-0.100000, 1.500000, 4.400000>, <0.100000, 1.500000, 4.400000>, <0.600000, 1.700000, 4.000000>
    }
  }
  texture {
    FlowerPetal
  }
  rotate <-25.0, 0.0, -1.0>
}
#declare Stigma1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.133581, 1.123770, -0.237764>, <-0.091573, 1.110402, -0.223440>, <-0.040429, 1.094126, -0.184446>, <-0.014467, 1.085863, -0.146946>, 
      <-0.165590, 1.081428, -0.179652>, <-0.123582, 1.068059, -0.165328>, <-0.102268, 1.109494, -0.138248>, <-0.076305, 1.101232, -0.100748>, 
      <-0.201998, 1.087110, -0.071329>, <-0.201998, 1.087110, -0.071329>, <-0.166264, 1.075738, -0.044084>, <-0.166264, 1.075738, -0.044084>, 
      <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.280813, 1.170626, -0.237764>, <-0.238805, 1.157257, -0.252088>, <-0.175589, 1.137139, -0.252088>, <-0.133581, 1.123770, -0.237764>, 
      <-0.258914, 1.159346, -0.163013>, <-0.216907, 1.145977, -0.177337>, <-0.207597, 1.094797, -0.193976>, <-0.165590, 1.081428, -0.179652>, 
      <-0.246167, 1.101167, -0.071329>, <-0.246167, 1.101167, -0.071329>, <-0.201998, 1.087110, -0.071329>, <-0.201998, 1.087110, -0.071329>, 
      <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.399927, 1.208533, -0.146946>, <-0.373964, 1.200270, -0.184446>, <-0.322821, 1.183994, -0.223440>, <-0.280813, 1.170626, -0.237764>, 
      <-0.367274, 1.146306, -0.111505>, <-0.341312, 1.138044, -0.149005>, <-0.300922, 1.172714, -0.148690>, <-0.258914, 1.159346, -0.163013>, 
      <-0.281901, 1.112539, -0.044084>, <-0.281901, 1.112539, -0.044084>, <-0.246167, 1.101167, -0.071329>, <-0.246167, 1.101167, -0.071329>, 
      <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.445424, 1.223012, 0.000000>, <-0.445424, 1.223012, -0.046352>, <-0.425889, 1.216795, -0.109446>, <-0.399927, 1.208533, -0.146946>, 
      <-0.371773, 1.195262, 0.000000>, <-0.371773, 1.195262, -0.046352>, <-0.393236, 1.154568, -0.074005>, <-0.367274, 1.146306, -0.111505>, 
      <-0.295551, 1.116883, 0.000000>, <-0.295551, 1.116883, 0.000000>, <-0.281901, 1.112539, -0.044084>, <-0.281901, 1.112539, -0.044084>, 
      <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.399927, 1.208533, 0.146946>, <-0.425889, 1.216795, 0.109446>, <-0.445424, 1.223012, 0.046352>, <-0.445424, 1.223012, 0.000000>, 
      <-0.367274, 1.146306, 0.111505>, <-0.393236, 1.154568, 0.074005>, <-0.371773, 1.195262, 0.046352>, <-0.371773, 1.195262, 0.000000>, 
      <-0.281901, 1.112539, 0.044084>, <-0.281901, 1.112539, 0.044084>, <-0.295551, 1.116883, 0.000000>, <-0.295551, 1.116883, 0.000000>, 
      <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.280813, 1.170626, 0.237764>, <-0.322821, 1.183994, 0.223440>, <-0.373964, 1.200270, 0.184446>, <-0.399927, 1.208533, 0.146946>, 
      <-0.258914, 1.159346, 0.163013>, <-0.300922, 1.172714, 0.148690>, <-0.341312, 1.138044, 0.149005>, <-0.367274, 1.146306, 0.111505>, 
      <-0.246167, 1.101167, 0.071329>, <-0.246167, 1.101167, 0.071329>, <-0.281901, 1.112539, 0.044084>, <-0.281901, 1.112539, 0.044084>, 
      <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.133581, 1.123770, 0.237764>, <-0.175589, 1.137139, 0.252088>, <-0.238805, 1.157257, 0.252088>, <-0.280813, 1.170626, 0.237764>, 
      <-0.165590, 1.081428, 0.179652>, <-0.207597, 1.094797, 0.193976>, <-0.216907, 1.145977, 0.177337>, <-0.258914, 1.159346, 0.163013>, 
      <-0.201998, 1.087110, 0.071329>, <-0.201998, 1.087110, 0.071329>, <-0.246167, 1.101167, 0.071329>, <-0.246167, 1.101167, 0.071329>, 
      <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014467, 1.085863, 0.146946>, <-0.040429, 1.094126, 0.184446>, <-0.091573, 1.110402, 0.223440>, <-0.133581, 1.123770, 0.237764>, 
      <-0.076305, 1.101232, 0.100748>, <-0.102268, 1.109494, 0.138248>, <-0.123582, 1.068059, 0.165328>, <-0.165590, 1.081428, 0.179652>, 
      <-0.166264, 1.075738, 0.044084>, <-0.166264, 1.075738, 0.044084>, <-0.201998, 1.087110, 0.071329>, <-0.201998, 1.087110, 0.071329>, 
      <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.066616, 1.465517, -0.540903>, <0.219762, 1.416779, -0.488683>, <-0.013362, 1.023829, -0.370256>, <0.081287, 0.993708, -0.233544>, 
      <0.006915, 1.414293, -0.413622>, <0.160061, 1.365556, -0.361402>, <-0.024321, 1.066875, -0.353185>, <0.070329, 1.036754, -0.216473>, 
      <-0.072728, 1.204269, -0.348243>, <-0.030720, 1.190900, -0.333919>, <-0.003041, 1.084834, -0.212379>, <0.022922, 1.076571, -0.174878>, 
      <-0.133581, 1.123770, -0.237764>, <-0.091573, 1.110402, -0.223440>, <-0.040429, 1.094126, -0.184446>, <-0.014467, 1.085863, -0.146946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342022, 1.128422, -0.377883>, <-0.191331, 1.080466, -0.429265>, <-0.084074, 1.513472, -0.592285>, <0.066616, 1.465517, -0.540903>, 
      <-0.322038, 1.161621, -0.350261>, <-0.171348, 1.113665, -0.401643>, <-0.143775, 1.462249, -0.465004>, <0.006915, 1.414293, -0.413622>, 
      <-0.294053, 1.177446, -0.282960>, <-0.252045, 1.164077, -0.297284>, <-0.114736, 1.217637, -0.362567>, <-0.072728, 1.204269, -0.348243>, 
      <-0.280813, 1.170626, -0.237764>, <-0.238805, 1.157257, -0.252088>, <-0.175589, 1.137139, -0.252088>, <-0.133581, 1.123770, -0.237764>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.539310, 1.658348, -0.334296>, <-0.444014, 1.628020, -0.471943>, <-0.496215, 1.177493, -0.325307>, <-0.342022, 1.128422, -0.377883>, 
      <-0.455091, 1.560189, -0.254362>, <-0.359794, 1.529862, -0.392008>, <-0.476231, 1.210692, -0.297685>, <-0.322038, 1.161621, -0.350261>, 
      <-0.463006, 1.328745, -0.215413>, <-0.437043, 1.320482, -0.252912>, <-0.336061, 1.190815, -0.268636>, <-0.294053, 1.177446, -0.282960>, 
      <-0.399927, 1.208533, -0.146946>, <-0.373964, 1.200270, -0.184446>, <-0.322821, 1.183994, -0.223440>, <-0.280813, 1.170626, -0.237764>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.603640, 1.211680, 0.000000>, <-0.603640, 1.211680, -0.168483>, <-0.633678, 1.688379, -0.197991>, <-0.539310, 1.658348, -0.334296>, 
      <-0.564533, 1.238793, 0.000000>, <-0.564533, 1.238793, -0.168483>, <-0.549459, 1.590221, -0.118056>, <-0.455091, 1.560189, -0.254362>, 
      <-0.489955, 1.239790, 0.000000>, <-0.489955, 1.239790, -0.046352>, <-0.488968, 1.337007, -0.177913>, <-0.463006, 1.328745, -0.215413>, 
      <-0.445424, 1.223012, 0.000000>, <-0.445424, 1.223012, -0.046352>, <-0.425889, 1.216795, -0.109446>, <-0.399927, 1.208533, -0.146946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.539310, 1.658348, 0.334296>, <-0.633678, 1.688379, 0.197991>, <-0.603640, 1.211680, 0.168483>, <-0.603640, 1.211680, 0.000000>, 
      <-0.455091, 1.560189, 0.254362>, <-0.549459, 1.590221, 0.118056>, <-0.564533, 1.238793, 0.168483>, <-0.564533, 1.238793, 0.000000>, 
      <-0.463006, 1.328745, 0.215413>, <-0.488968, 1.337007, 0.177913>, <-0.489955, 1.239790, 0.046352>, <-0.489955, 1.239790, 0.000000>, 
      <-0.399927, 1.208533, 0.146946>, <-0.425889, 1.216795, 0.109446>, <-0.445424, 1.223012, 0.046352>, <-0.445424, 1.223012, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342022, 1.128422, 0.377883>, <-0.496215, 1.177493, 0.325307>, <-0.444014, 1.628020, 0.471943>, <-0.539310, 1.658348, 0.334296>, 
      <-0.322038, 1.161621, 0.350261>, <-0.476231, 1.210692, 0.297685>, <-0.359794, 1.529862, 0.392008>, <-0.455091, 1.560189, 0.254362>, 
      <-0.294053, 1.177446, 0.282960>, <-0.336061, 1.190815, 0.268636>, <-0.437043, 1.320482, 0.252912>, <-0.463006, 1.328745, 0.215413>, 
      <-0.280813, 1.170626, 0.237764>, <-0.322821, 1.183994, 0.223440>, <-0.373964, 1.200270, 0.184446>, <-0.399927, 1.208533, 0.146946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.066616, 1.465517, 0.540903>, <-0.084074, 1.513472, 0.592285>, <-0.191331, 1.080466, 0.429265>, <-0.342022, 1.128422, 0.377883>, 
      <0.006915, 1.414293, 0.413622>, <-0.143775, 1.462249, 0.465004>, <-0.171348, 1.113665, 0.401643>, <-0.322038, 1.161621, 0.350261>, 
      <-0.072728, 1.204269, 0.348243>, <-0.114736, 1.217637, 0.362567>, <-0.252045, 1.164077, 0.297284>, <-0.294053, 1.177446, 0.282960>, 
      <-0.133581, 1.123770, 0.237764>, <-0.175589, 1.137139, 0.252088>, <-0.238805, 1.157257, 0.252088>, <-0.280813, 1.170626, 0.237764>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.081287, 0.993708, 0.233544>, <-0.013362, 1.023829, 0.370256>, <0.219762, 1.416779, 0.488683>, <0.066616, 1.465517, 0.540903>, 
      <0.070329, 1.036754, 0.216473>, <-0.024321, 1.066875, 0.353185>, <0.160061, 1.365556, 0.361402>, <0.006915, 1.414293, 0.413622>, 
      <0.022922, 1.076571, 0.174878>, <-0.003041, 1.084834, 0.212379>, <-0.030720, 1.190900, 0.333919>, <-0.072728, 1.204269, 0.348243>, 
      <-0.014467, 1.085863, 0.146946>, <-0.040429, 1.094126, 0.184446>, <-0.091573, 1.110402, 0.223440>, <-0.133581, 1.123770, 0.237764>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.089466, 1.315142, -0.713292>, <0.268346, 1.258215, -0.652298>, <-0.069431, 0.902683, -0.393228>, <0.041123, 0.867501, -0.233544>, 
      <0.115838, 1.373657, -0.738537>, <0.294718, 1.316730, -0.677542>, <-0.045914, 0.933254, -0.402774>, <0.064640, 0.898071, -0.243090>, 
      <0.094135, 1.489127, -0.599572>, <0.247281, 1.440390, -0.547352>, <-0.004212, 0.987887, -0.384510>, <0.090437, 0.957766, -0.247798>, 
      <0.066616, 1.465517, -0.540903>, <0.219762, 1.416779, -0.488683>, <-0.013362, 1.023829, -0.370256>, <0.081287, 0.993708, -0.233544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.382186, 1.002215, -0.377883>, <-0.203306, 0.945288, -0.438877>, <-0.089414, 1.372069, -0.774286>, <0.089466, 1.315142, -0.713292>, 
      <-0.375972, 1.038292, -0.393329>, <-0.197091, 0.981365, -0.454323>, <-0.063042, 1.430584, -0.799531>, <0.115838, 1.373657, -0.738537>, 
      <-0.358707, 1.100702, -0.400946>, <-0.208017, 1.052746, -0.452328>, <-0.056555, 1.537083, -0.650954>, <0.094135, 1.489127, -0.599572>, 
      <-0.342022, 1.128422, -0.377883>, <-0.191331, 1.080466, -0.429265>, <-0.084074, 1.513472, -0.592285>, <0.066616, 1.465517, -0.540903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.709573, 1.569430, -0.440839>, <-0.599019, 1.534247, -0.600523>, <-0.561066, 1.059142, -0.316889>, <-0.382186, 1.002215, -0.377883>, 
      <-0.711386, 1.633609, -0.455670>, <-0.600832, 1.598426, -0.615355>, <-0.554852, 1.095219, -0.332335>, <-0.375972, 1.038292, -0.393329>, 
      <-0.575811, 1.700889, -0.368939>, <-0.480514, 1.670562, -0.506587>, <-0.512901, 1.149773, -0.348370>, <-0.358707, 1.100702, -0.400946>, 
      <-0.539310, 1.658348, -0.334296>, <-0.444014, 1.628020, -0.471943>, <-0.496215, 1.177493, -0.325307>, <-0.342022, 1.128422, -0.377883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.643804, 1.085473, 0.000000>, <-0.643804, 1.085473, -0.197380>, <-0.820127, 1.604612, -0.281155>, <-0.709573, 1.569430, -0.440839>, 
      <-0.648283, 1.124953, 0.000000>, <-0.648283, 1.124953, -0.197380>, <-0.821940, 1.668792, -0.295986>, <-0.711386, 1.633609, -0.455670>, 
      <-0.636293, 1.189041, 0.000000>, <-0.636293, 1.189041, -0.168483>, <-0.670179, 1.730921, -0.232634>, <-0.575811, 1.700889, -0.368939>, 
      <-0.603640, 1.211680, 0.000000>, <-0.603640, 1.211680, -0.168483>, <-0.633678, 1.688379, -0.197991>, <-0.539310, 1.658348, -0.334296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.709573, 1.569430, 0.440839>, <-0.820127, 1.604612, 0.281155>, <-0.643804, 1.085473, 0.197380>, <-0.643804, 1.085473, 0.000000>, 
      <-0.711386, 1.633609, 0.455670>, <-0.821940, 1.668792, 0.295986>, <-0.648283, 1.124953, 0.197380>, <-0.648283, 1.124953, 0.000000>, 
      <-0.575811, 1.700889, 0.368939>, <-0.670179, 1.730921, 0.232634>, <-0.636293, 1.189041, 0.168483>, <-0.636293, 1.189041, 0.000000>, 
      <-0.539310, 1.658348, 0.334296>, <-0.633678, 1.688379, 0.197991>, <-0.603640, 1.211680, 0.168483>, <-0.603640, 1.211680, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.382186, 1.002215, 0.377883>, <-0.561066, 1.059142, 0.316889>, <-0.599019, 1.534247, 0.600523>, <-0.709573, 1.569430, 0.440839>, 
      <-0.375972, 1.038292, 0.393329>, <-0.554852, 1.095219, 0.332335>, <-0.600832, 1.598426, 0.615355>, <-0.711386, 1.633609, 0.455670>, 
      <-0.358707, 1.100702, 0.400946>, <-0.512901, 1.149773, 0.348370>, <-0.480514, 1.670562, 0.506587>, <-0.575811, 1.700889, 0.368939>, 
      <-0.342022, 1.128422, 0.377883>, <-0.496215, 1.177493, 0.325307>, <-0.444014, 1.628020, 0.471943>, <-0.539310, 1.658348, 0.334296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.089466, 1.315142, 0.713292>, <-0.089414, 1.372069, 0.774286>, <-0.203306, 0.945288, 0.438877>, <-0.382186, 1.002215, 0.377883>, 
      <0.115838, 1.373657, 0.738537>, <-0.063042, 1.430584, 0.799531>, <-0.197091, 0.981365, 0.454323>, <-0.375972, 1.038292, 0.393329>, 
      <0.094135, 1.489127, 0.599572>, <-0.056555, 1.537083, 0.650954>, <-0.208017, 1.052746, 0.452328>, <-0.358707, 1.100702, 0.400946>, 
      <0.066616, 1.465517, 0.540903>, <-0.084074, 1.513472, 0.592285>, <-0.191331, 1.080466, 0.429265>, <-0.342022, 1.128422, 0.377883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.041123, 0.867501, 0.233544>, <-0.069431, 0.902683, 0.393228>, <0.268346, 1.258215, 0.652298>, <0.089466, 1.315142, 0.713292>, 
      <0.064640, 0.898071, 0.243090>, <-0.045914, 0.933254, 0.402774>, <0.294718, 1.316730, 0.677542>, <0.115838, 1.373657, 0.738537>, 
      <0.090437, 0.957766, 0.247798>, <-0.004212, 0.987887, 0.384510>, <0.247281, 1.440390, 0.547352>, <0.094135, 1.489127, 0.599572>, 
      <0.081287, 0.993708, 0.233544>, <-0.013362, 1.023829, 0.370256>, <0.219762, 1.416779, 0.488683>, <0.066616, 1.465517, 0.540903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.300014, 0.652027, -0.189947>, <-0.266454, 0.641347, -0.178504>, <-0.225596, 0.628345, -0.147352>, <-0.204855, 0.621744, -0.117393>, 
      <-0.293787, 0.929137, -0.222331>, <-0.260227, 0.918457, -0.210888>, <-0.225834, 0.738263, -0.151000>, <-0.205093, 0.731662, -0.121041>, 
      <-0.017241, 1.078377, -0.611147>, <0.161639, 1.021450, -0.550153>, <-0.134524, 0.818067, -0.366805>, <-0.023971, 0.782884, -0.207121>, 
      <0.089466, 1.315142, -0.713292>, <0.268346, 1.258215, -0.652298>, <-0.069431, 0.902683, -0.393228>, <0.041123, 0.867501, -0.233544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.417635, 0.689460, -0.189947>, <-0.384076, 0.678779, -0.201390>, <-0.333573, 0.662707, -0.201390>, <-0.300014, 0.652027, -0.189947>, 
      <-0.424089, 0.799100, -0.195663>, <-0.390529, 0.788420, -0.207106>, <-0.327346, 0.939817, -0.233774>, <-0.293787, 0.929137, -0.222331>, 
      <-0.399387, 0.902357, -0.335130>, <-0.220507, 0.845430, -0.396124>, <-0.196121, 1.135304, -0.672141>, <-0.017241, 1.078377, -0.611147>, 
      <-0.382186, 1.002215, -0.377883>, <-0.203306, 0.945288, -0.438877>, <-0.089414, 1.372069, -0.774286>, <0.089466, 1.315142, -0.713292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.512794, 0.719743, -0.117393>, <-0.492053, 0.713142, -0.147352>, <-0.451195, 0.700140, -0.178504>, <-0.417635, 0.689460, -0.189947>, 
      <-0.540952, 0.996732, -0.136418>, <-0.520211, 0.990131, -0.166376>, <-0.457648, 0.809780, -0.184220>, <-0.424089, 0.799100, -0.195663>, 
      <-0.701894, 1.297633, -0.378029>, <-0.591341, 1.262450, -0.537714>, <-0.578267, 0.959284, -0.274136>, <-0.399387, 0.902357, -0.335130>, 
      <-0.709573, 1.569430, -0.440839>, <-0.599019, 1.534247, -0.600523>, <-0.561066, 1.059142, -0.316889>, <-0.382186, 1.002215, -0.377883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.549141, 0.731310, 0.000000>, <-0.549141, 0.731310, -0.037030>, <-0.533535, 0.726344, -0.087435>, <-0.512794, 0.719743, -0.117393>, 
      <-0.559246, 0.840824, 0.000000>, <-0.559246, 0.840824, -0.037030>, <-0.561693, 1.003332, -0.106460>, <-0.540952, 0.996732, -0.136418>, 
      <-0.631407, 0.976195, 0.000000>, <-0.631407, 0.976195, -0.197380>, <-0.812448, 1.332815, -0.218345>, <-0.701894, 1.297633, -0.378029>, 
      <-0.643804, 1.085473, 0.000000>, <-0.643804, 1.085473, -0.197380>, <-0.820127, 1.604612, -0.281155>, <-0.709573, 1.569430, -0.440839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.512794, 0.719743, 0.117393>, <-0.533535, 0.726344, 0.087435>, <-0.549141, 0.731310, 0.037030>, <-0.549141, 0.731310, 0.000000>, 
      <-0.540952, 0.996732, 0.136418>, <-0.561693, 1.003332, 0.106460>, <-0.559246, 0.840824, 0.037030>, <-0.559246, 0.840824, 0.000000>, 
      <-0.701894, 1.297633, 0.378029>, <-0.812448, 1.332815, 0.218345>, <-0.631407, 0.976195, 0.197380>, <-0.631407, 0.976195, 0.000000>, 
      <-0.709573, 1.569430, 0.440839>, <-0.820127, 1.604612, 0.281155>, <-0.643804, 1.085473, 0.197380>, <-0.643804, 1.085473, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.417635, 0.689460, 0.189947>, <-0.451195, 0.700140, 0.178504>, <-0.492053, 0.713142, 0.147352>, <-0.512794, 0.719743, 0.117393>, 
      <-0.424089, 0.799100, 0.195663>, <-0.457648, 0.809780, 0.184220>, <-0.520211, 0.990131, 0.166376>, <-0.540952, 0.996732, 0.136418>, 
      <-0.399387, 0.902357, 0.335130>, <-0.578267, 0.959284, 0.274136>, <-0.591341, 1.262450, 0.537714>, <-0.701894, 1.297633, 0.378029>, 
      <-0.382186, 1.002215, 0.377883>, <-0.561066, 1.059142, 0.316889>, <-0.599019, 1.534247, 0.600523>, <-0.709573, 1.569430, 0.440839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.300014, 0.652027, 0.189947>, <-0.333573, 0.662707, 0.201390>, <-0.384076, 0.678779, 0.201390>, <-0.417635, 0.689460, 0.189947>, 
      <-0.293787, 0.929137, 0.222331>, <-0.327346, 0.939817, 0.233774>, <-0.390529, 0.788420, 0.207106>, <-0.424089, 0.799100, 0.195663>, 
      <-0.017241, 1.078377, 0.611147>, <-0.196121, 1.135304, 0.672141>, <-0.220507, 0.845430, 0.396124>, <-0.399387, 0.902357, 0.335130>, 
      <0.089466, 1.315142, 0.713292>, <-0.089414, 1.372069, 0.774286>, <-0.203306, 0.945288, 0.438877>, <-0.382186, 1.002215, 0.377883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.204855, 0.621744, 0.117393>, <-0.225596, 0.628345, 0.147352>, <-0.266454, 0.641347, 0.178504>, <-0.300014, 0.652027, 0.189947>, 
      <-0.205093, 0.731662, 0.121041>, <-0.225834, 0.738263, 0.151000>, <-0.260227, 0.918457, 0.210888>, <-0.293787, 0.929137, 0.222331>, 
      <-0.023971, 0.782884, 0.207121>, <-0.134524, 0.818067, 0.366805>, <0.161639, 1.021450, 0.550153>, <-0.017241, 1.078377, 0.611147>, 
      <0.041123, 0.867501, 0.233544>, <-0.069431, 0.902683, 0.393228>, <0.268346, 1.258215, 0.652298>, <0.089466, 1.315142, 0.713292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.021299, -3.614354, -0.137204>, <0.004140, -3.614354, -0.128938>, <0.035111, -3.614354, -0.106436>, <0.050833, -3.614354, -0.084796>, 
      <-0.076588, -2.332834, -0.145666>, <-0.051149, -2.332834, -0.137400>, <-0.016300, -2.342223, -0.111648>, <-0.000578, -2.342223, -0.090008>, 
      <-0.328635, -0.621725, -0.041089>, <-0.295075, -0.632405, -0.029646>, <-0.222839, -0.644132, -0.105120>, <-0.202098, -0.650733, -0.075161>, 
      <-0.300014, 0.652027, -0.189947>, <-0.266454, 0.641347, -0.178504>, <-0.225596, 0.628345, -0.147352>, <-0.204855, 0.621744, -0.117393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.110459, -3.614354, -0.137204>, <-0.085020, -3.614354, -0.145469>, <-0.046738, -3.614354, -0.145469>, <-0.021299, -3.614354, -0.137204>, 
      <-0.170573, -2.321253, -0.145703>, <-0.145135, -2.321253, -0.153968>, <-0.102027, -2.332834, -0.153932>, <-0.076588, -2.332834, -0.145666>, 
      <-0.341675, -0.601083, -0.122666>, <-0.308116, -0.611763, -0.134109>, <-0.362194, -0.611045, -0.052532>, <-0.328635, -0.621725, -0.041089>, 
      <-0.417635, 0.689460, -0.189947>, <-0.384076, 0.678779, -0.201390>, <-0.333573, 0.662707, -0.201390>, <-0.300014, 0.652027, -0.189947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.182591, -3.614354, -0.084796>, <-0.166869, -3.614354, -0.106436>, <-0.135898, -3.614354, -0.128938>, <-0.110459, -3.614354, -0.137204>, 
      <-0.246636, -2.311904, -0.090067>, <-0.230914, -2.311904, -0.111707>, <-0.196012, -2.321253, -0.137437>, <-0.170573, -2.321253, -0.145703>, 
      <-0.381213, -0.574586, -0.028494>, <-0.360472, -0.581187, -0.058452>, <-0.375235, -0.590403, -0.111223>, <-0.341675, -0.601083, -0.122666>, 
      <-0.512794, 0.719743, -0.117393>, <-0.492053, 0.713142, -0.147352>, <-0.451195, 0.700140, -0.178504>, <-0.417635, 0.689460, -0.189947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.210144, -3.614354, 0.000000>, <-0.210144, -3.614354, -0.026748>, <-0.198314, -3.614354, -0.063157>, <-0.182591, -3.614354, -0.084796>, 
      <-0.275695, -2.308338, 0.000000>, <-0.275695, -2.308338, -0.026748>, <-0.262358, -2.311904, -0.068428>, <-0.246636, -2.311904, -0.090067>, 
      <-0.428992, -0.570818, 0.000000>, <-0.428992, -0.570818, -0.037030>, <-0.401954, -0.567985, 0.001465>, <-0.381213, -0.574586, -0.028494>, 
      <-0.549141, 0.731310, 0.000000>, <-0.549141, 0.731310, -0.037030>, <-0.533535, 0.726344, -0.087435>, <-0.512794, 0.719743, -0.117393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.182591, -3.614354, 0.084796>, <-0.198314, -3.614354, 0.063157>, <-0.210144, -3.614354, 0.026748>, <-0.210144, -3.614354, 0.000000>, 
      <-0.246636, -2.311904, 0.090067>, <-0.262358, -2.311904, 0.068428>, <-0.275695, -2.308338, 0.026748>, <-0.275695, -2.308338, 0.000000>, 
      <-0.381213, -0.574586, 0.028494>, <-0.401954, -0.567985, -0.001465>, <-0.428992, -0.570818, 0.037030>, <-0.428992, -0.570818, 0.000000>, 
      <-0.512794, 0.719743, 0.117393>, <-0.533535, 0.726344, 0.087435>, <-0.549141, 0.731310, 0.037030>, <-0.549141, 0.731310, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.110459, -3.614354, 0.137204>, <-0.135898, -3.614354, 0.128938>, <-0.166869, -3.614354, 0.106436>, <-0.182591, -3.614354, 0.084796>, 
      <-0.170573, -2.321253, 0.145703>, <-0.196012, -2.321253, 0.137437>, <-0.230914, -2.311904, 0.111707>, <-0.246636, -2.311904, 0.090067>, 
      <-0.341675, -0.601083, 0.122666>, <-0.375235, -0.590403, 0.111223>, <-0.360472, -0.581187, 0.058452>, <-0.381213, -0.574586, 0.028494>, 
      <-0.417635, 0.689460, 0.189947>, <-0.451195, 0.700140, 0.178504>, <-0.492053, 0.713142, 0.147352>, <-0.512794, 0.719743, 0.117393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.021299, -3.614354, 0.137204>, <-0.046738, -3.614354, 0.145469>, <-0.085020, -3.614354, 0.145469>, <-0.110459, -3.614354, 0.137204>, 
      <-0.076588, -2.332834, 0.145666>, <-0.102027, -2.332834, 0.153932>, <-0.145135, -2.321253, 0.153968>, <-0.170573, -2.321253, 0.145703>, 
      <-0.328635, -0.621725, 0.041089>, <-0.362194, -0.611045, 0.052532>, <-0.308116, -0.611763, 0.134109>, <-0.341675, -0.601083, 0.122666>, 
      <-0.300014, 0.652027, 0.189947>, <-0.333573, 0.662707, 0.201390>, <-0.384076, 0.678779, 0.201390>, <-0.417635, 0.689460, 0.189947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.050833, -3.614354, 0.084796>, <0.035111, -3.614354, 0.106436>, <0.004140, -3.614354, 0.128938>, <-0.021299, -3.614354, 0.137204>, 
      <-0.000578, -2.342223, 0.090008>, <-0.016300, -2.342223, 0.111648>, <-0.051149, -2.332834, 0.137400>, <-0.076588, -2.332834, 0.145666>, 
      <-0.202098, -0.650733, 0.075161>, <-0.222839, -0.644132, 0.105120>, <-0.295075, -0.632405, 0.029646>, <-0.328635, -0.621725, 0.041089>, 
      <-0.204855, 0.621744, 0.117393>, <-0.225596, 0.628345, 0.147352>, <-0.266454, 0.641347, 0.178504>, <-0.300014, 0.652027, 0.189947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.044580, -7.335230, -0.137204>, <0.070019, -7.335230, -0.128938>, <0.100990, -7.335230, -0.106436>, <0.116712, -7.335230, -0.084796>, 
      <0.024816, -6.218967, -0.137204>, <0.050255, -6.218967, -0.128938>, <0.081226, -6.218967, -0.106436>, <0.096949, -6.218967, -0.084796>, 
      <0.026822, -4.729730, -0.129838>, <0.052260, -4.729730, -0.121573>, <0.080193, -4.729872, -0.101866>, <0.095915, -4.729872, -0.080226>, 
      <-0.021299, -3.614354, -0.137204>, <0.004140, -3.614354, -0.128938>, <0.035111, -3.614354, -0.106436>, <0.050833, -3.614354, -0.084796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.044580, -7.335230, -0.137204>, <-0.019141, -7.335230, -0.145469>, <0.019141, -7.335230, -0.145469>, <0.044580, -7.335230, -0.137204>, 
      <-0.064344, -6.218967, -0.137204>, <-0.038905, -6.218967, -0.145469>, <-0.000623, -6.218967, -0.145469>, <0.024816, -6.218967, -0.137204>, 
      <-0.058615, -4.729563, -0.129874>, <-0.033176, -4.729563, -0.138139>, <0.001383, -4.729730, -0.138104>, <0.026822, -4.729730, -0.129838>, 
      <-0.110459, -3.614354, -0.137204>, <-0.085020, -3.614354, -0.145469>, <-0.046738, -3.614354, -0.145469>, <-0.021299, -3.614354, -0.137204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.116712, -7.335230, -0.084796>, <-0.100990, -7.335230, -0.106436>, <-0.070019, -7.335230, -0.128938>, <-0.044580, -7.335230, -0.137204>, 
      <-0.136476, -6.218967, -0.084796>, <-0.120754, -6.218967, -0.106436>, <-0.089783, -6.218967, -0.128938>, <-0.064344, -6.218967, -0.137204>, 
      <-0.127760, -4.729436, -0.080284>, <-0.112038, -4.729436, -0.101924>, <-0.084054, -4.729563, -0.121608>, <-0.058615, -4.729563, -0.129874>, 
      <-0.182591, -3.614354, -0.084796>, <-0.166869, -3.614354, -0.106436>, <-0.135898, -3.614354, -0.128938>, <-0.110459, -3.614354, -0.137204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.144264, -7.335230, 0.000000>, <-0.144264, -7.335230, -0.026748>, <-0.132434, -7.335230, -0.063157>, <-0.116712, -7.335230, -0.084796>, 
      <-0.164028, -6.218967, 0.000000>, <-0.164028, -6.218967, -0.026748>, <-0.152198, -6.218967, -0.063157>, <-0.136476, -6.218967, -0.084796>, 
      <-0.154178, -4.729388, 0.000000>, <-0.154178, -4.729388, -0.026748>, <-0.143482, -4.729436, -0.058644>, <-0.127760, -4.729436, -0.080284>, 
      <-0.210144, -3.614354, 0.000000>, <-0.210144, -3.614354, -0.026748>, <-0.198314, -3.614354, -0.063157>, <-0.182591, -3.614354, -0.084796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.116712, -7.335230, 0.084796>, <-0.132434, -7.335230, 0.063157>, <-0.144264, -7.335230, 0.026748>, <-0.144264, -7.335230, 0.000000>, 
      <-0.136476, -6.218967, 0.084796>, <-0.152198, -6.218967, 0.063157>, <-0.164028, -6.218967, 0.026748>, <-0.164028, -6.218967, 0.000000>, 
      <-0.127760, -4.729436, 0.080284>, <-0.143482, -4.729436, 0.058644>, <-0.154178, -4.729388, 0.026748>, <-0.154178, -4.729388, 0.000000>, 
      <-0.182591, -3.614354, 0.084796>, <-0.198314, -3.614354, 0.063157>, <-0.210144, -3.614354, 0.026748>, <-0.210144, -3.614354, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.044580, -7.335230, 0.137204>, <-0.070019, -7.335230, 0.128938>, <-0.100990, -7.335230, 0.106436>, <-0.116712, -7.335230, 0.084796>, 
      <-0.064344, -6.218967, 0.137204>, <-0.089783, -6.218967, 0.128938>, <-0.120754, -6.218967, 0.106436>, <-0.136476, -6.218967, 0.084796>, 
      <-0.058615, -4.729563, 0.129874>, <-0.084054, -4.729563, 0.121608>, <-0.112038, -4.729436, 0.101924>, <-0.127760, -4.729436, 0.080284>, 
      <-0.110459, -3.614354, 0.137204>, <-0.135898, -3.614354, 0.128938>, <-0.166869, -3.614354, 0.106436>, <-0.182591, -3.614354, 0.084796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.044580, -7.335230, 0.137204>, <0.019141, -7.335230, 0.145469>, <-0.019141, -7.335230, 0.145469>, <-0.044580, -7.335230, 0.137204>, 
      <0.024816, -6.218967, 0.137204>, <-0.000623, -6.218967, 0.145469>, <-0.038905, -6.218967, 0.145469>, <-0.064344, -6.218967, 0.137204>, 
      <0.026822, -4.729730, 0.129838>, <0.001383, -4.729730, 0.138104>, <-0.033176, -4.729563, 0.138139>, <-0.058615, -4.729563, 0.129874>, 
      <-0.021299, -3.614354, 0.137204>, <-0.046738, -3.614354, 0.145469>, <-0.085020, -3.614354, 0.145469>, <-0.110459, -3.614354, 0.137204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.116712, -7.335230, 0.084796>, <0.100990, -7.335230, 0.106436>, <0.070019, -7.335230, 0.128938>, <0.044580, -7.335230, 0.137204>, 
      <0.096949, -6.218967, 0.084796>, <0.081226, -6.218967, 0.106436>, <0.050255, -6.218967, 0.128938>, <0.024816, -6.218967, 0.137204>, 
      <0.095915, -4.729872, 0.080226>, <0.080193, -4.729872, 0.101866>, <0.052260, -4.729730, 0.121573>, <0.026822, -4.729730, 0.129838>, 
      <0.050833, -3.614354, 0.084796>, <0.035111, -3.614354, 0.106436>, <0.004140, -3.614354, 0.128938>, <-0.021299, -3.614354, 0.137204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.031031, 1.071384, 0.000000>, <0.031031, 1.071384, 0.046352>, <0.011495, 1.077601, 0.109446>, <-0.014467, 1.085863, 0.146946>, 
      <-0.041820, 1.041597, 0.000000>, <-0.041820, 1.041597, 0.046352>, <-0.050343, 1.092969, 0.063248>, <-0.076305, 1.101232, 0.100748>, 
      <-0.152614, 1.071394, 0.000000>, <-0.152614, 1.071394, 0.000000>, <-0.166264, 1.075738, 0.044084>, <-0.166264, 1.075738, 0.044084>, 
      <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>, <-0.231319, 1.071399, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.031031, 1.071384, 0.000000>, <-0.041820, 1.041597, 0.000000>, <-0.152614, 1.071394, 0.000000>, <-0.231319, 1.071399, 0.000000>, 
      <0.031031, 1.071384, -0.046352>, <-0.041820, 1.041597, -0.046352>, <-0.152614, 1.071394, 0.000000>, <-0.231319, 1.071399, 0.000000>, 
      <0.011495, 1.077601, -0.109446>, <-0.050343, 1.092969, -0.063248>, <-0.166264, 1.075738, -0.044084>, <-0.231319, 1.071399, 0.000000>, 
      <-0.014467, 1.085863, -0.146946>, <-0.076305, 1.101232, -0.100748>, <-0.166264, 1.075738, -0.044084>, <-0.231319, 1.071399, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.031031, 1.071384, 0.000000>, <0.168128, 1.127441, 0.000000>, <0.294771, 1.323396, 0.000000>, <0.441098, 1.346341, 0.000000>, 
      <0.031031, 1.071384, 0.046352>, <0.168128, 1.127441, 0.046352>, <0.294771, 1.323396, 0.166590>, <0.441098, 1.346341, 0.166590>, 
      <0.011495, 1.077601, 0.109446>, <0.048884, 1.068309, 0.137379>, <0.163637, 1.007059, 0.081699>, <0.174595, 0.964013, 0.098770>, 
      <-0.014467, 1.085863, 0.146946>, <0.022922, 1.076571, 0.174878>, <0.070329, 1.036754, 0.216473>, <0.081287, 0.993708, 0.233544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.031031, 1.071384, 0.000000>, <0.031031, 1.071384, -0.046352>, <0.011495, 1.077601, -0.109446>, <-0.014467, 1.085863, -0.146946>, 
      <0.168128, 1.127441, 0.000000>, <0.168128, 1.127441, -0.046352>, <0.048884, 1.068309, -0.137379>, <0.022922, 1.076571, -0.174878>, 
      <0.294771, 1.323396, 0.000000>, <0.294771, 1.323396, -0.166590>, <0.163637, 1.007059, -0.081699>, <0.070329, 1.036754, -0.216473>, 
      <0.441098, 1.346341, 0.000000>, <0.441098, 1.346341, -0.166590>, <0.174595, 0.964013, -0.098770>, <0.081287, 0.993708, -0.233544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583299, 1.157984, 0.000000>, <0.583299, 1.157984, 0.197380>, <0.151677, 0.832318, 0.073860>, <0.041123, 0.867501, 0.233544>, 
      <0.628456, 1.212516, 0.000000>, <0.628456, 1.212516, 0.197380>, <0.175194, 0.862888, 0.083406>, <0.064640, 0.898071, 0.243090>, 
      <0.511046, 1.357309, 0.000000>, <0.511046, 1.357309, 0.166590>, <0.183745, 0.928071, 0.113024>, <0.090437, 0.957766, 0.247798>, 
      <0.441098, 1.346341, 0.000000>, <0.441098, 1.346341, 0.166590>, <0.174595, 0.964013, 0.098770>, <0.081287, 0.993708, 0.233544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583299, 1.157984, 0.000000>, <0.628456, 1.212516, 0.000000>, <0.511046, 1.357309, 0.000000>, <0.441098, 1.346341, 0.000000>, 
      <0.583299, 1.157984, -0.197380>, <0.628456, 1.212516, -0.197380>, <0.511046, 1.357309, -0.166590>, <0.441098, 1.346341, -0.166590>, 
      <0.151677, 0.832318, -0.073860>, <0.175194, 0.862888, -0.083406>, <0.183745, 0.928071, -0.113024>, <0.174595, 0.964013, -0.098770>, 
      <0.041123, 0.867501, -0.233544>, <0.064640, 0.898071, -0.243090>, <0.090437, 0.957766, -0.247798>, <0.081287, 0.993708, -0.233544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.168508, 0.610177, 0.000000>, <-0.168508, 0.610177, 0.037030>, <-0.184114, 0.615143, 0.087435>, <-0.204855, 0.621744, 0.117393>, 
      <-0.139147, 0.887693, 0.000000>, <-0.139147, 0.887693, 0.037030>, <-0.184352, 0.725061, 0.091083>, <-0.205093, 0.731662, 0.121041>, 
      <0.405313, 0.943046, 0.000000>, <0.405313, 0.943046, 0.197380>, <0.086583, 0.747701, 0.047437>, <-0.023971, 0.782884, 0.207121>, 
      <0.583299, 1.157984, 0.000000>, <0.583299, 1.157984, 0.197380>, <0.151677, 0.832318, 0.073860>, <0.041123, 0.867501, 0.233544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.168508, 0.610177, 0.000000>, <-0.139147, 0.887693, 0.000000>, <0.405313, 0.943046, 0.000000>, <0.583299, 1.157984, 0.000000>, 
      <-0.168508, 0.610177, -0.037030>, <-0.139147, 0.887693, -0.037030>, <0.405313, 0.943046, -0.197380>, <0.583299, 1.157984, -0.197380>, 
      <-0.184114, 0.615143, -0.087435>, <-0.184352, 0.725061, -0.091083>, <0.086583, 0.747701, -0.047437>, <0.151677, 0.832318, -0.073860>, 
      <-0.204855, 0.621744, -0.117393>, <-0.205093, 0.731662, -0.121041>, <-0.023971, 0.782884, -0.207121>, <0.041123, 0.867501, -0.233544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.078385, -3.614354, 0.000000>, <0.078385, -3.614354, 0.026748>, <0.066555, -3.614354, 0.063157>, <0.050833, -3.614354, 0.084796>, 
      <0.028449, -2.345815, 0.000000>, <0.028449, -2.345815, 0.026748>, <0.015144, -2.342223, 0.068368>, <-0.000578, -2.342223, 0.090008>, 
      <-0.302078, -0.652299, 0.000000>, <-0.302078, -0.652299, 0.037030>, <-0.181357, -0.657333, 0.045203>, <-0.202098, -0.650733, 0.075161>, 
      <-0.168508, 0.610177, 0.000000>, <-0.168508, 0.610177, 0.037030>, <-0.184114, 0.615143, 0.087435>, <-0.204855, 0.621744, 0.117393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.078385, -3.614354, 0.000000>, <0.028449, -2.345815, 0.000000>, <-0.302078, -0.652299, 0.000000>, <-0.168508, 0.610177, 0.000000>, 
      <0.078385, -3.614354, -0.026748>, <0.028449, -2.345815, -0.026748>, <-0.302078, -0.652299, -0.037030>, <-0.168508, 0.610177, -0.037030>, 
      <0.066555, -3.614354, -0.063157>, <0.015144, -2.342223, -0.068368>, <-0.181357, -0.657333, -0.045203>, <-0.184114, 0.615143, -0.087435>, 
      <0.050833, -3.614354, -0.084796>, <-0.000578, -2.342223, -0.090008>, <-0.202098, -0.650733, -0.075161>, <-0.204855, 0.621744, -0.117393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.144264, -7.335230, 0.000000>, <0.144264, -7.335230, 0.026748>, <0.132434, -7.335230, 0.063157>, <0.116712, -7.335230, 0.084796>, 
      <0.124501, -6.218967, 0.000000>, <0.124501, -6.218967, 0.026748>, <0.112671, -6.218967, 0.063157>, <0.096949, -6.218967, 0.084796>, 
      <0.122300, -4.729928, 0.000000>, <0.122300, -4.729928, 0.026748>, <0.111637, -4.729872, 0.058587>, <0.095915, -4.729872, 0.080226>, 
      <0.078385, -3.614354, 0.000000>, <0.078385, -3.614354, 0.026748>, <0.066555, -3.614354, 0.063157>, <0.050833, -3.614354, 0.084796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.144264, -7.335230, 0.000000>, <0.124501, -6.218967, 0.000000>, <0.122300, -4.729928, 0.000000>, <0.078385, -3.614354, 0.000000>, 
      <0.144264, -7.335230, -0.026748>, <0.124501, -6.218967, -0.026748>, <0.122300, -4.729928, -0.026748>, <0.078385, -3.614354, -0.026748>, 
      <0.132434, -7.335230, -0.063157>, <0.112671, -6.218967, -0.063157>, <0.111637, -4.729872, -0.058587>, <0.066555, -3.614354, -0.063157>, 
      <0.116712, -7.335230, -0.084796>, <0.096949, -6.218967, -0.084796>, <0.095915, -4.729872, -0.080226>, <0.050833, -3.614354, -0.084796>
    }
  }
  texture {
    StigmaGreen
  }
  scale <0.205714, 0.3, 0.205714>
  rotate <90.0, 86.0, 90.0>
  translate  <0.0, 2.262742, 0.15>
}
#declare AntherUnion = union {
  sphere { // Anther
    <0,0,0>,1
    scale <0.05, 0.15, 0.033333>
    translate  2.0*z
    texture {
      Pollen
      // Transform to world space
      rotate x*-75.000000
      rotate x*180.000000
      translate <-17.600000, 17.100000, 3.600000>
      rotate z*-34.466209
      rotate y*-8.839866
      rotate x*-154.096176
      scale <1.0/0.500000, 1.0/0.500000, 1.0/0.500000>
      translate <7.500000, -14.900000, -1.100000>
      scale <1.0/1.300000, 1.0/1.300000, 1.0/1.300000>
    }
  }
  cylinder { // AntherStem
    <0,0,1>, <0,0,0>, 1 
    texture {
      StigmaGreen
    }
    scale <0.02, 0.02, 2.0>
  }
  rotate 75.0*x
}
#declare AntherGroup = union {
  object { AntherUnion }
  object { // AntherUnion1->AntherUnion
    AntherUnion
    rotate <-0.0, -60.0, 0.0>
  }
  object { // AntherUnion2->AntherUnion
    AntherUnion
    rotate <-180.0, -60.0, -180.0>
  }
  object { // AntherUnion3->AntherUnion
    AntherUnion
    rotate <-180.0, 0.0, -180.0>
  }
  object { // AntherUnion4->AntherUnion
    AntherUnion
    rotate <-180.0, 60.0, -180.0>
  }
  object { // AntherUnion5->AntherUnion
    AntherUnion
    rotate <-0.0, 60.0, 0.0>
  }
  rotate -180.0*x
}
#declare Flower = union {
  object { Petal7 }
  object { // Petal8->Petal7
    Petal7
    rotate <0.0, 60.0, 0.0>
  }
  object { // Petal9->Petal7
    Petal7
    rotate <-180.0, 60.0, -180.0>
  }
  object { // Petal10->Petal7
    Petal7
    rotate <180.0, -0.0, -180.0>
  }
  object { // Petal11->Petal7
    Petal7
    rotate <180.0, -60.0, -180.0>
  }
  object { // Petal12->Petal7
    Petal7
    rotate <-0.0, -60.0, 0.0>
  }
  object { Stigma1 }
  object { AntherGroup }
  scale 0.5
  rotate <154.096176, 8.839866, 34.466209>
  translate  <17.6, -17.1, -3.6>
}




//
// ********  OBJECTS  *******
//

#declare LeafBit1 = prism {
  linear_sweep
  cubic_spline
  -0.02,0.0
  16  // control points
  <-0.96083, 0.650707>,
  <-0.784962, 0.083436>,
  <-0.262505, -0.576488>,
  <0.53283, -0.835787>,
  <1.087623, -1.131435>,
  <1.242893, -1.08307>,
  <1.178656, -0.508129>,
  <1.105792, 0.148785>,
  <0.647155, 0.608721>,
  <0.204024, 1.275247>,
  <-0.533406, 1.540343>,
  <-1.233662, 1.978459>,
  <-1.285761, 1.259981>,
  <-0.96083, 0.650707>,
  <-0.784962, 0.083436>,
  <-0.262505, -0.576488>
  rotate -x*90
  rotate <100.0, 35.0, 180.0>
  translate  <8.0, -0.07, 3.9>
  texture {
    LeafyBit1
  }
}
#declare LeafBit2 = prism {
  linear_sweep
  cubic_spline
  -0.02,0.0
  22  // control points
  <-0.901911, 0.741816>,
  <-0.361246, 0.825176>,
  <0.161008, 0.715225>,
  <0.686017, 0.890471>,
  <1.140666, 1.192599>,
  <1.441526, 0.500827>,
  <1.368662, -0.177993>,
  <1.362745, -0.608721>,
  <1.152069, -0.792968>,
  <0.839292, -0.880943>,
  <0.350128, -1.138737>,
  <-0.004382, -0.939846>,
  <-0.452355, -0.73713>,
  <-0.739793, -0.410499>,
  <-1.109076, -0.239163>,
  <-1.271157, 0.127387>,
  <-1.544071, 0.423404>,
  <-1.600327, 0.97395>,
  <-1.45674, 1.048364>,
  <-0.901911, 0.741816>,
  <-0.361246, 0.825176>,
  <0.161008, 0.715225>
  rotate -x*90
  rotate <-95.0, 40.0, -19.0>
  translate  <24.65, -2.5, 1.45>
  texture {
    LeafyBit2
  }
}
#declare LeafBit3 = prism {
  linear_sweep
  cubic_spline
  -0.02,0.0
  22  // control points
  <-0.953025, 0.968176>,
  <-0.499983, 0.817874>,
  <0.044177, 0.941585>,
  <0.715225, 0.868565>,
  <1.140666, 1.192599>,
  <1.41962, 0.537337>,
  <1.229925, 0.223613>,
  <1.136385, -0.104888>,
  <0.801576, -0.405966>,
  <0.525309, -0.859037>,
  <-0.09529, -0.919679>,
  <-0.60314, -1.078582>,
  <-1.160643, -0.970792>,
  <-1.586817, -1.01656>,
  <-1.861176, -0.735695>,
  <-2.067068, -0.442164>,
  <-1.872659, -0.051222>,
  <-1.775573, 0.513929>,
  <-1.339909, 0.697871>,
  <-0.953025, 0.968176>,
  <-0.499983, 0.817874>,
  <0.044177, 0.941585>
  rotate -x*90
  rotate <-114.504486, 50.223618, -49.381832>
  translate  <30.72, -4.23, -0.85>
  texture {
    LeafyBit3
  }
}
union { // LeafBits
  object { LeafBit1 }
  object { LeafBit2 }
  object { LeafBit3 }
}


union { // TreeLeaves
  object { TreeLeafMass }
  object { // TreeLeafMass1->TreeLeafMass
    TreeLeafMass
    rotate <-166.529327, -0.896074, 34.576569>
    translate  <-170.6, 346.3, 111.1>
  }
  object { // TreeLeafMass2->TreeLeafMass
    TreeLeafMass
    rotate <77.61734, 3.620151, -164.417038>
    translate  <3.45, 335.4, -52.8>
  }
}


union { // LongLeaves
  object { LongLeaf1 }
  object { // LongLeaf2->LongLeaf1
    LongLeaf1
    rotate <-27.905638, -2.726314, -166.466278>
    translate  <33.5, 19.6, 9.8>
  }
  object { // LongLeaf3->LongLeaf1
    LongLeaf1
    scale 0.7
    rotate <13.127978, 0.534144, -42.319847>
    translate  <-8.3, 6.1, -2.4>
  }
  object { // LongLeaf4->LongLeaf1
    LongLeaf1
    scale 0.6
    rotate <2.524009, 23.334192, -79.177261>
    translate  <-9.4, 9.5, -2.9>
  }
}


union { // Trees
  object { TreeTrunk1 }
  object { // TreeTrunk2->TreeTrunk1
    TreeTrunk1
    scale <0.75, 0.75, 2.0>
    rotate <-0.0, -0.0, -135.0>
    translate  <-244.8, 697.2, 5.0>
    texture {
      TreeBark
    }
  }
}


union { // Ants
  object { Ant }
  object { // Ant1->Ant
    Ant
    rotate <-5.0, -20.0, -71.491638>
    translate  <10.4, 5.9, -2.85>
  }
  object { // Ant2->Ant
    Ant
    rotate <-5.0, -4.0, -168.0>
    translate  <24.5, -0.05, -1.7>
  }
  object { // Ant3->Ant
    Ant
    rotate <3.0, 12.0, -16.0>
    translate  <17.15, -0.05, -0.65>
  }
  object { // Ant4->Ant
    Ant
    rotate <-5.638867, 20.451109, -34.580818>
    translate  <23.8, 0.1, -1.75>
  }
}


union { // Flowers
  object { Flower }
  object { // Flower1->Flower
    Flower
    rotate <-15.832925, -5.034498, -61.406807>
    translate  <23.4, 6.9, -6.7>
  }
  object { // Flower2->Flower
    Flower
    rotate <-6.951051, -9.805919, 35.597004>
    translate  <-5.8, -11.2, -5.1>
  }
  object { // Flower3->Flower
    Flower
    rotate <-49.368279, -70.676819, 78.697121>
    translate  <4.4, -8.0, -22.9>
  }
  sphere { // Droplet1
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.153846, 0.153846, 0.076923>
    rotate <10.964779, 4.732519, -5.0708>
    translate  <19.307693, -17.846155, -3.423077>
  }
  sphere { // Droplet16
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.115385, 0.115385, 0.057692>
    rotate <36.769512, 19.95112, -1.02467>
    translate  <15.846154, -16.000001, -1.538462>
  }
  sphere { // Droplet15
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.153846, 0.153846, 0.076923>
    rotate <39.632538, 51.287338, -25.139704>
    translate  <15.269231, -17.115385, -2.307692>
  }
  sphere { // Droplet14
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.153846, 0.153846, 0.076923>
    rotate <-1.115329, 50.780437, -20.470999>
    translate  <19.961539, -14.346154, -2.153846>
  }
  sphere { // Droplet2
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.076923, 0.076923, 0.038462>
    rotate <25.973083, 5.575089, -2.777877>
    translate  <19.153847, -18.000001, -3.653846>
  }
  sphere { // Droplet5
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.153846, 0.153846, 0.076923>
    rotate <-4.225251, 46.725319, -32.380451>
    translate  <17.807693, -19.076924, -3.307692>
  }
  sphere { // Droplet8
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.115385, 0.115385, 0.057692>
    rotate <50.032665, 17.207617, 5.102944>
    translate  <15.769231, -17.115385, -2.384615>
  }
  sphere { // Droplet10
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.115385, 0.115385, 0.057692>
    rotate <25.973083, 5.575089, -2.777877>
    translate  <15.346154, -18.384616, -3.692308>
  }
  sphere { // Droplet9
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.153846, 0.153846, 0.076923>
    rotate <-4.225251, 46.725319, -32.380451>
    translate  <15.000001, -17.653847, -3.115385>
  }
  sphere { // Droplet12
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.115385, 0.115385, 0.057692>
    rotate <9.50561, 16.443987, -7.533327>
    translate  <19.192308, -17.346154, -2.230769>
  }
  sphere { // Droplet13
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.115385, 0.115385, 0.057692>
    rotate <44.35173, -1.488921, -1.34666>
    translate  <17.384616, -14.884616, -0.807692>
  }
  sphere { // Droplet11
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.076923, 0.076923, 0.038462>
    rotate <25.973083, 5.575089, -2.777877>
    translate  <15.576924, -18.653847, -3.846154>
  }
  sphere { // Droplet7
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.076923, 0.076923, 0.038462>
    rotate <34.880684, 15.756758, 5.215243>
    translate  <20.576924, -14.846154, -3.230769>
  }
  sphere { // Droplet6
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.153846, 0.153846, 0.076923>
    rotate <36.000771, 5.793742, -1.159441>
    translate  <20.192308, -14.73077, -3.038462>
  }
  sphere { // Droplet4
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.115385, 0.115385, 0.057692>
    rotate <23.557236, 16.863205, -6.931289>
    translate  <18.192308, -17.73077, -1.538462>
  }
  sphere { // Droplet3
    <0,0,0>,1
    texture {
      Water
    }
    scale <0.076923, 0.076923, 0.038462>
    rotate <25.973083, 5.575089, -2.777877>
    translate  <19.461539, -18.076924, -3.730769>
  }
  scale 1.3
  translate  <-7.5, 14.9, 1.1>
}








box { // Background
  <-1, -1, -1>, <1, 1, 1>
  scale <250.0, 1.0, 150.0>
  translate  <-80.0, 800.0, 80.0>
  texture {
    Jungle
  }
}


union { // Branch
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-1.097722, 0.000000, 0.000000>, <-1.097722, -0.603747, 0.000000>, <-0.603747, -1.097722, 0.000000>, <0.000000, -1.097722, 0.000000>, 
      <-1.097722, 0.000000, 0.548861>, <-1.097722, -0.603747, 0.548861>, <-0.603747, -1.097722, 0.548861>, <0.000000, -1.097722, 0.548861>, 
      <-1.058996, -0.098500, 0.955606>, <-1.058996, -0.645601, 0.899213>, <-0.608996, -1.093230, 0.853074>, <-0.058996, -1.093230, 0.853074>, 
      <-0.910311, -0.164519, 1.362092>, <-0.910311, -0.679672, 1.308992>, <-0.486590, -1.101160, 1.265547>, <0.031292, -1.101160, 1.265547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.000000, -1.097722, 0.000000>, <0.603747, -1.097722, 0.000000>, <1.097722, -0.603747, 0.000000>, <1.097722, 0.000000, 0.000000>, 
      <0.000000, -1.097722, 0.548861>, <0.603747, -1.097722, 0.548861>, <1.097722, -0.603747, 0.548861>, <1.097722, 0.000000, 0.548861>, 
      <-0.058996, -1.093230, 0.853074>, <0.491004, -1.093230, 0.853074>, <0.941004, -0.645601, 0.899213>, <0.941004, -0.098500, 0.955606>, 
      <0.031292, -1.101160, 1.265547>, <0.549174, -1.101160, 1.265547>, <0.972895, -0.679672, 1.308992>, <0.972895, -0.164519, 1.362092>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.097722, 0.000000, 0.000000>, <1.097722, 0.603747, 0.000000>, <0.603747, 1.097722, 0.000000>, <0.000000, 1.097722, 0.000000>, 
      <1.097722, 0.000000, 0.548861>, <1.097722, 0.603747, 0.548861>, <0.603747, 1.097722, 0.548861>, <0.000000, 1.097722, 0.548861>, 
      <0.941004, -0.098500, 0.955606>, <0.941004, 0.448601, 1.011999>, <0.491004, 0.896230, 1.058139>, <-0.058996, 0.896230, 1.058139>, 
      <0.972895, -0.164519, 1.362092>, <0.972895, 0.350633, 1.415192>, <0.549174, 0.772121, 1.458637>, <0.031292, 0.772121, 1.458637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.000000, 1.097722, 0.000000>, <-0.603747, 1.097722, 0.000000>, <-1.097722, 0.603747, 0.000000>, <-1.097722, 0.000000, 0.000000>, 
      <0.000000, 1.097722, 0.548861>, <-0.603747, 1.097722, 0.548861>, <-1.097722, 0.603747, 0.548861>, <-1.097722, 0.000000, 0.548861>, 
      <-0.058996, 0.896230, 1.058139>, <-0.608996, 0.896230, 1.058139>, <-1.058996, 0.448601, 1.011999>, <-1.058996, -0.098500, 0.955606>, 
      <0.031292, 0.772121, 1.458637>, <-0.486590, 0.772121, 1.458637>, <-0.910311, 0.350633, 1.415192>, <-0.910311, -0.164519, 1.362092>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.910311, -0.164519, 1.362092>, <-0.910311, -0.679672, 1.308992>, <-0.486590, -1.101160, 1.265547>, <0.031292, -1.101160, 1.265547>, 
      <-0.761627, -0.230539, 1.768578>, <-0.761627, -0.713742, 1.718772>, <-0.364184, -1.109091, 1.678021>, <0.121580, -1.109091, 1.678021>, 
      <-0.761627, -0.275818, 2.207854>, <-0.761627, -0.759021, 2.158048>, <-0.364184, -1.154369, 2.117297>, <0.121580, -1.154369, 2.117297>, 
      <-0.435414, -0.616297, 2.653469>, <-0.435414, -1.097312, 2.587663>, <-0.065510, -1.484379, 2.495828>, <0.415878, -1.476649, 2.450587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.031292, -1.101160, 1.265547>, <0.549174, -1.101160, 1.265547>, <0.972895, -0.679672, 1.308992>, <0.972895, -0.164519, 1.362092>, 
      <0.121580, -1.109091, 1.678021>, <0.607344, -1.109091, 1.678021>, <1.004787, -0.713742, 1.718772>, <1.004787, -0.230539, 1.768578>, 
      <0.121580, -1.154369, 2.117297>, <0.607344, -1.154369, 2.117297>, <1.004787, -0.759021, 2.158048>, <1.004787, -0.275818, 2.207854>, 
      <0.415878, -1.476649, 2.450587>, <0.897266, -1.468920, 2.405345>, <1.291128, -1.069039, 2.422170>, <1.291128, -0.588024, 2.487975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.972895, -0.164519, 1.362092>, <0.972895, 0.350633, 1.415192>, <0.549174, 0.772121, 1.458637>, <0.031292, 0.772121, 1.458637>, 
      <1.004787, -0.230539, 1.768578>, <1.004787, 0.252665, 1.818385>, <0.607344, 0.648013, 1.859136>, <0.121580, 0.648013, 1.859136>, 
      <1.004787, -0.275818, 2.207854>, <1.004787, 0.207386, 2.257661>, <0.607344, 0.602734, 2.298412>, <0.121580, 0.602734, 2.298412>, 
      <1.291128, -0.588024, 2.487975>, <1.291128, -0.107009, 2.553781>, <0.897266, 0.280224, 2.644638>, <0.415878, 0.272495, 2.689879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.031292, 0.772121, 1.458637>, <-0.486590, 0.772121, 1.458637>, <-0.910311, 0.350633, 1.415192>, <-0.910311, -0.164519, 1.362092>, 
      <0.121580, 0.648013, 1.859136>, <-0.364184, 0.648013, 1.859136>, <-0.761627, 0.252665, 1.818385>, <-0.761627, -0.230539, 1.768578>, 
      <0.121580, 0.602734, 2.298412>, <-0.364184, 0.602734, 2.298412>, <-0.761627, 0.207386, 2.257661>, <-0.761627, -0.275818, 2.207854>, 
      <0.415878, 0.272495, 2.689879>, <-0.065510, 0.264766, 2.735121>, <-0.435414, -0.135283, 2.719274>, <-0.435414, -0.616297, 2.653469>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.435414, -0.616297, 2.653469>, <-0.435414, -1.097312, 2.587663>, <-0.065510, -1.484379, 2.495828>, <0.415878, -1.476649, 2.450587>, 
      <-0.109201, -0.956777, 3.099083>, <-0.109201, -1.435603, 3.017279>, <0.233164, -1.814388, 2.874360>, <0.710176, -1.798929, 2.783876>, 
      <-0.138332, -1.318580, 3.632730>, <-0.138332, -1.480089, 3.473408>, <0.250787, -1.858229, 3.326720>, <0.726378, -1.841575, 3.229239>, 
      <0.720427, -1.821116, 4.149786>, <0.720427, -2.108349, 4.010957>, <1.086000, -2.456702, 3.826141>, <1.532811, -2.436574, 3.700324>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.415878, -1.476649, 2.450587>, <0.897266, -1.468920, 2.405345>, <1.291128, -1.069039, 2.422170>, <1.291128, -0.588024, 2.487975>, 
      <0.710176, -1.798929, 2.783876>, <1.187188, -1.783471, 2.693393>, <1.577470, -1.379056, 2.686292>, <1.577470, -0.900230, 2.768097>, 
      <0.726378, -1.841575, 3.229239>, <1.201968, -1.824921, 3.131759>, <1.591088, -1.419529, 3.118933>, <1.591088, -0.940703, 3.200737>, 
      <1.532811, -2.436574, 3.700324>, <1.979622, -2.397785, 3.574508>, <2.345195, -2.001227, 3.553443>, <2.345195, -1.555334, 3.653513>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.291128, -0.588024, 2.487975>, <1.291128, -0.107009, 2.553781>, <0.897266, 0.280224, 2.644638>, <0.415878, 0.272495, 2.689879>, 
      <1.577470, -0.900230, 2.768097>, <1.577470, -0.421404, 2.849901>, <1.187188, -0.042285, 2.990864>, <0.710176, -0.057744, 3.081347>, 
      <1.591088, -0.940703, 3.200737>, <1.591088, -0.461877, 3.282541>, <1.201968, -0.083736, 3.429229>, <0.726378, -0.100390, 3.526710>, 
      <2.345195, -1.555334, 3.653513>, <2.345195, -1.090780, 3.753584>, <1.979622, -0.742427, 3.938400>, <1.532811, -0.781217, 4.064217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.415878, 0.272495, 2.689879>, <-0.065510, 0.264766, 2.735121>, <-0.435414, -0.135283, 2.719274>, <-0.435414, -0.616297, 2.653469>, 
      <0.710176, -0.057744, 3.081347>, <0.233164, -0.073202, 3.171830>, <-0.109201, -0.477951, 3.180887>, <-0.109201, -0.956777, 3.099083>, 
      <0.726378, -0.100390, 3.526710>, <0.250787, -0.117044, 3.624191>, <-0.138332, -1.157072, 3.792051>, <-0.138332, -1.318580, 3.632730>, 
      <1.532811, -0.781217, 4.064217>, <1.086000, -0.801345, 4.190033>, <0.720427, -1.515220, 4.288615>, <0.720427, -1.821116, 4.149786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.720427, -1.821116, 4.149786>, <0.720427, -2.108349, 4.010957>, <1.086000, -2.456702, 3.826141>, <1.532811, -2.436574, 3.700324>, 
      <1.579186, -2.304989, 4.666843>, <1.579186, -2.736610, 4.548507>, <1.921212, -3.055175, 4.325561>, <2.339244, -3.012912, 4.171409>, 
      <1.724496, -2.405473, 5.033347>, <1.724496, -2.837094, 4.915011>, <2.066522, -3.155659, 4.692065>, <2.484554, -3.113395, 4.537913>, 
      <1.914646, -2.612093, 5.716265>, <1.914646, -3.043713, 5.597929>, <2.256673, -3.362278, 5.374984>, <2.674705, -3.236038, 5.062209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.532811, -2.436574, 3.700324>, <1.979622, -2.397785, 3.574508>, <2.345195, -2.001227, 3.553443>, <2.345195, -1.555334, 3.653513>, 
      <2.339244, -3.012912, 4.171409>, <2.757277, -2.970648, 4.017257>, <3.099303, -2.582925, 3.987953>, <3.099303, -2.151304, 4.106290>, 
      <2.484554, -3.113395, 4.537913>, <2.902586, -3.071132, 4.383761>, <3.244613, -2.683408, 4.354457>, <3.244613, -2.251787, 4.472794>, 
      <2.674705, -3.236038, 5.062209>, <3.092737, -3.109799, 4.749435>, <3.434763, -2.722075, 4.720131>, <3.434763, -2.290454, 4.838468>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <2.345195, -1.555334, 3.653513>, <2.345195, -1.090780, 3.753584>, <1.979622, -0.742427, 3.938400>, <1.532811, -0.781217, 4.064217>, 
      <3.099303, -2.151304, 4.106290>, <3.099303, -1.719683, 4.224626>, <2.757277, -1.401118, 4.447571>, <2.339244, -1.443382, 4.601723>, 
      <3.244613, -2.251787, 4.472794>, <3.244613, -1.820167, 4.591130>, <2.902586, -1.501602, 4.814075>, <2.484554, -1.543865, 4.968227>, 
      <3.434763, -2.290454, 4.838468>, <3.434763, -1.858834, 4.956804>, <3.092737, -1.540269, 5.179749>, <2.674705, -1.666509, 5.492523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.532811, -0.781217, 4.064217>, <1.086000, -0.801345, 4.190033>, <0.720427, -1.515220, 4.288615>, <0.720427, -1.821116, 4.149786>, 
      <2.339244, -1.443382, 4.601723>, <1.921212, -1.485645, 4.755875>, <1.579186, -1.873369, 4.785179>, <1.579186, -2.304989, 4.666843>, 
      <2.484554, -1.543865, 4.968227>, <2.066522, -1.586129, 5.122380>, <1.724496, -1.973852, 5.151683>, <1.724496, -2.405473, 5.033347>, 
      <2.674705, -1.666509, 5.492523>, <2.256673, -1.792748, 5.805298>, <1.914646, -2.180472, 5.834602>, <1.914646, -2.612093, 5.716265>
    }
  }
  scale <2.0, 2.0, 6.7>
  rotate 90.0*y
  texture {
    RoughBranch
  }
}


