
// Glenn's POV-Ray Scene File - "Backdrop"
// created 23-May-98 for the May/Jun 1998 Internet Ray Tracing Competition
// at http://www.irtc.org
// last update 7-Jun-98
// copyright 1998 Glenn McCarter

// A distant mountain jungle background

#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//===============================================
//             Variables
//===============================================

#declare CamPos = <0,0,700*Feet> // scene position over valley floor
#declare CamLoc = <-1.3*Feet, -0.002*Feet, 5> // camera position from local origin

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  /* // Focal Blur section: uncomment to enable focal blur
  blur_samples 6
  aperture .5    //lower value = wider range in focus
  focal_point <0,0,0>
  */ // end focal blur
  location  CamPos+CamLoc
  look_at   <0, 0, 4>+CamPos
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//    angle 40
//    direction z*50
//  location  <-1.3*Feet, -0.002*Feet, 7>+CamPos // render view
//  location <-5, -36, 11>+CamPos // off to the side
  location <-15*Feet, -3, 11*Feet>+CamPos // above and behind
//	location < -13*Feet,1,120*Feet>+CamPos // helicoptor view
//	location < -60*Feet,1,600*Feet>+CamPos // blimp view
//	location < -600*Feet,1,13000*Feet>+CamPos // missile view
  look_at <-6, 0, 0>+CamPos
  }

#declare DummyCam =
	box {
		<-1.5,-1,-1>,<1.5,1,1>
		texture { WhitePaint }
	}
//object { DummyCam translate <-1.3*Feet, -0.002*Feet, 7>+CamPos }

camera { // special cameras declared in GCamerasRH.inc
//    Special_Cam
    Render_Cam
 }

//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
//object {StdBulb100Watt translate <-7*Miles,2*Miles,12*Miles> } // Sun

#declare Sun =
  light_source {
 	  <0,0,0>
//   	colour rgb <5.0, 4.0, 3.0> // blindingly bright
//   	colour rgb <3.7, 2.8, 2.0> // pretty darn bright
   	colour rgb <1.5, 1.2, .9> // fairly bright
//   	colour rgb <1, .8, .6> // rather dimmish
//		area_light <.2*Miles,0,0>,<0,.2*Miles,0> 3, 3
	}
object { Sun translate <-7*Miles,2*Miles,12*Miles> }

//===============================================
//             Textures
//===============================================

#declare Rock1Tex =
	texture {
		pigment { color rgb<.8,.85,.5> } // nice tan
		finish { ambient .1 specular .2 roughness .08 }
	}


//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black

sky_sphere {
	pigment {
		gradient z
		color_map {
			[ 0.50  color rgb<.60,.60,.80> ] // bright blue
			[ .70  color rgb<.20,.20,.50> ] // deep blue
		}
	scale 2 // otherwise would repeat twice
	translate -1 // moves the color at index zero to the bottom of the sky sphere
	}
}


#declare NoFog = 0
#include "Environ.inc"

object { DistantMountains
	rotate z*0 translate <3200*Feet,0*Feet,-10*Feet>
	texture { MountainTex }
}
object { DistantJungle
	rotate z*0 translate <3200*Feet,0*Feet,00*Feet>
	texture { JungleTex }
}

//object { GroundPlaneWhite translate CamPos-<0,0,.3*Feet> }


//===============================================
//             Objects
//===============================================


/*
// this is for testing the fog
#declare BigCyl = cylinder{<0,0,0>,<0,0,600*Feet>,40*Feet texture { PaperWhite}}
object { BigCyl translate <520*Feet,-40*Feet,0> }
object { BigCyl translate <720*Feet,-240*Feet,0> }
object { BigCyl translate <920*Feet,240*Feet,0> }
object { BigCyl translate <1220*Feet,40*Feet,0> }
object { BigCyl translate <1520*Feet,180*Feet,0> }
object { BigCyl translate <1920*Feet,-240*Feet,0> }
object { BigCyl translate <2320*Feet,840*Feet,0> }
*/

//===============================================
//             Object Placement
//===============================================
