
// Glenn's POV-Ray Scene File - Bubbles
// created 30-May-98
// last update 30-Nov-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Bubbles.inc" in another .pov file
//
// a group of bubbles
//

//================================================================
//      Remove this section -- only used for test renders!
//================================================================
/*
#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  /* // Focal Blur section: uncomment to enable focal blur
  blur_samples 6
  aperture .5    //lower value = wider range in focus
  focal_point <0,0,0>
  */ // end focal blur
  location  <-1.6*Feet, -2.2*Feet, .9*Feet>
  look_at   <0.000, 0.000, 0.000>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//    angle 40
//    direction z*50
  location <-1, -1, 11> // top view
//  location <1, -11, 0> // side view
//  location <-11, -1, 0> // rear view
  look_at <0, 0, 0>
  }

camera { // special cameras declared in GCamerasRH.inc
    Special_Cam
//    Render_Cam
//    Back4Inch_Cam // use values 1,2,4,8,12,16,32,64,or 128
//    location <6*Feet, 6*Feet, 5*Feet> // "Reverse Angle"
//    location <-42, -24, 10> // Standard Position
    angle 40
    look_at <0, 0, 0>
  }
object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
object {StdBulb60Watt translate <-10*Feet,2*Feet,8*Feet> }
background { color rgb <0.2, 0.4, 0.8> } // light blue
//object {GroundPlaneWhite translate z*-0}
*/


//===============================================
//             Textures
//===============================================

#declare BubbleTex =
	texture {
//		pigment { color rgb<.99,.99,.99> } // test
//		pigment { color rgbt<.78,.99,.93,.90> } // render
		pigment { color rgbt<.74,.7,1.0,.80> } // render test
		normal { bumps .001 }
//		finish { ambient .1 specular .9 roughness .001 } // test
		finish { ambient .1 specular .99 roughness .001 reflection .42 } // render
	}


//===============================================
//             Objects
//===============================================

#declare Bubble =
	sphere {
		<0,0,0>,.5
		texture { BubbleTex }
	}

#declare BubbleGroup =
	union {
		object { Bubble scale 1 translate < 0, 0, 0> }
		object { Bubble scale 1 translate <-1, 0, 0> }
		object { Bubble scale 1 translate < 0, 1, 0> }
		object { Bubble scale 1 translate < 0,-1, 0> }
	}

//===============================================
//             Object Placement
//===============================================

//object { TestSphere scale 4 translate <0,-6,3> }
