
// Glenn's POV-Ray Scene File - "Dominion"
// created for the May/Jun 1998 Internet Ray Tracing Competition
// at http://www.irtc.org
// created 19-May-98
// last update 28-Jun-98
// copyright 1998 Glenn McCarter

// A lizard suns himself on a rock

#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//===============================================
//             Variables
//===============================================

#declare CamPos = <0,0,700*Feet> // scene position over valley floor
#declare CamLoc = <-1.3*Feet, -0.002*Feet, 5> // camera position from local origin

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  /* // Focal Blur section: uncomment to enable focal blur
  blur_samples 6
  aperture .5    //lower value = wider range in focus
  focal_point <0,0,0>
  */ // end focal blur
  location  CamPos+CamLoc
  look_at   <0, 0, 4>+CamPos
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//    angle 40
//    direction z*50
//  location  <-1.3*Feet, -0.002*Feet, 7>+CamPos // render view
//  location <-5, -36, 11>+CamPos // off to the side
//  location <-5*Feet, -66*Feet, 11*Feet>+CamPos // off to the side, distant
  location <-15*Feet, -3, 11*Feet>+CamPos // above and behind
//  location <-65*Feet, -3, 11*Feet>+CamPos // above and behind, distant
//	location < -13*Feet,1,120*Feet>+CamPos // helicoptor view
//	location < -60*Feet,1,600*Feet>+CamPos // blimp view
//	location < -600*Feet,1,13000*Feet>+CamPos // missile view
  look_at <-6, 0, 0>+CamPos
  }

#declare DummyCam = // test, for viewing the camera itself
	box {
		<-1.5,-1,-1>,<1.5,1,1>
		texture { WhitePaint }
	}
//object { DummyCam translate <-1.3*Feet, -0.002*Feet, 7>+CamPos }

camera { // special cameras declared in GCamerasRH.inc
//    Special_Cam
    Render_Cam
 }

//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
//object {StdBulb100Watt translate <-7*Miles,2*Miles,12*Miles> } // Sun

#declare Sun =
  light_source {
 	  <0,0,0>
//   	colour rgb <5.0, 4.0, 3.0> // blindingly bright
//   	colour rgb <3.7, 2.8, 2.0> // pretty darn bright
   	colour rgb <1.5, 1.2, .9> // fairly bright
//   	colour rgb <1, .8, .6> // rather dimmish
//		area_light <.2*Miles,0,0>,<0,.2*Miles,0> 3, 3
	}
object { Sun translate <-7*Miles,2*Miles,12*Miles> }

#declare SunBeam = // for testing ray direction
	cylinder {
		<0,0,0>,<-7*Miles,2*Miles,12*Miles>,2
		scale .5
		texture { BrightWhite }
	}


//===============================================
//             Textures
//===============================================

#declare Rock1Tex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0 rgb<.834,.853,.508> ] // nice tan
				[ 0.5 rgb<.864,.854,.802> ] // grey
				[ 1.0 rgb<.724,.663,.412> ]
			}
		}
		normal { bumps .3 scale .3 }
		finish { ambient .01 specular .2 roughness .08 crand .1 }
	}

#declare LizardTex =
	texture {
		pigment { color rgb<.004,.508,.006> } // bright deep green
		finish { ambient .3 specular .4 roughness .008 }
	}
#declare LizardEyesTex =
	texture {
		pigment { color rgb<.004,.008,.006> } // black
		finish { ambient .3 specular 1.0 roughness .008 }
	}

#declare TrunkVineTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0 rgb<.114,.313,.008> ] // deep brownish green
				[ 0.5 rgb<.264,.154,.002> ]
				[ 1.0 rgb<.264,.203,.012> ]
			}
			scale <.4,.4,1>
		}
		normal { bumps .4 scale <2,2,4> }
		finish { ambient .3 specular .4 roughness .008 }
	}

#declare WaterTex =
	texture {
//		pigment { color rgb<.99,.99,.99> } // test
//		pigment { color rgbt<.78,.99,.93,.90> } // render
		pigment { color rgbt<.74,.7,1.0,.80> } // render test
		normal { bumps .001 }
//		finish { ambient .1 specular .9 roughness .001 } // test
		finish { ambient .1 specular .99 roughness .001 reflection .42 } // render
	}

//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black

#include "Ground.inc"
object { NearbyDirt translate <0,0,-3> rotate x*-12 translate CamPos texture { DirtTex } }

//object { GroundPlaneWhite translate CamPos-<0,0,.3*Feet> }

#declare TestSlab =
	box {
		<-6*Feet,-6*Feet,-10>,<6*Feet,6*Feet,0>
		texture { Rock1Tex }
	}

#declare ImageRatio = 640/480 // = 4/3
#declare ImageWidth = 1500 // inches
#declare ImageHeight = ImageWidth/ImageRatio
#declare BackDrop =
	box {//sits on xy plane, at z=0
		<0,0,0>,<ImageWidth,ImageWidth,.001>
//		texture { PaperWhite } // test
		texture {
		  pigment {
					image_map { // image is always projected from -z
					png "Backdrop.png" //lo-res mountainous background image
					once
					}
			}
			scale <ImageWidth,ImageWidth,1> rotate <00,0,0> translate <0,0,0>
			finish { ambient .4 }
		}
		scale <1,1/ImageRatio,1> // rescale to correct aspect ratio
		rotate <90,0,-90> // camera orientation (yz-plane, x=0)
		translate <0,ImageWidth/2,-ImageHeight/2> // origin at center of image
	}

#declare ImageRatio = 640/480 // = 4/3
#declare ImageWidth = 15 // inches
#declare ImageHeight = ImageWidth/ImageRatio
#declare ForeGround =
	box {//sits on xy plane, at z=0
		<0,0,0>,<ImageWidth,ImageWidth,.001>
//		texture { PaperWhite } // test
		texture {
		  pigment {
					image_map { // image is always projected from -z
					png "ForegroundTest.png" //lo-res overhanging leaves foreground image
					once
					}
			}
			scale <ImageWidth,ImageWidth,1> rotate <00,0,0> translate <0,0,0>
			finish { ambient .4 }
		}
		scale <1,1/ImageRatio,1> // rescale to correct aspect ratio
		rotate <90,0,-90> // camera orientation (yz-plane, x=0)
		translate <0,ImageWidth/2,-ImageHeight/2> // origin at center of image
	}

//===============================================
//             Objects
//===============================================


//#include "TrunkVine.pov"
//#include "Lizard2Body.pov"
//#include "Lizard2Eyes.pov"
#include "DeadStuff.inc"
//#include "Rock1.pov"

#include "Weeds.inc"
//#include "Plants.inc"
#include "Trees.inc"
#include "ShadowTrees.inc"


#include "Bubbles.inc"
#include "Bubbles2.pov"

//#declare BT  = 0.75 // Blob Threshold
//#declare BRF = 1.6  // Blob Radius Factor
//#declare BSF = 1.0  // Blob Strength Factor
//#declare BNSF = 24.0 // Negative Strength Factor ( divisor )
#declare BT  = 0.5 // Blob Threshold
#declare BRF = 1.1  // Blob Radius Factor
#declare BSF = 1.0  // Blob Strength Factor
#declare BNSF = 24.0 // Negative Strength Factor ( divisor )
#declare RS = seed(13590)

#declare StreamWater =
	blob {
		threshold BT
		#declare BallCount = 1
		#while ( BallCount < 280 )
			sphere { // main water surface
//				<0,0,0>,BRF*7.2,BSF
				<0,0,0>,BRF*2.2,BSF
				scale <1,1,1>
				translate <rand(RS)*12,rand(RS)*36,rand(RS)*1,>
			}
			#declare BallCount = BallCount +1
		#end
		#declare SplashCount = 1
		#while ( SplashCount < 60 )
			sphere { // little splashes
//				<0,0,0>,BRF*7.2,BSF
				<0,0,0>,BRF*1.8,BSF*.4
				scale <1,1,1>
				translate <rand(RS)*12,rand(RS)*36,rand(RS)*1+2,>
			}
			#declare SplashCount = SplashCount +1
		#end
		texture { WaterTex }
	}



//===============================================
//             Object Placement
//===============================================

#declare AllStuff =
union {
//object { ForeGround translate <-6,0,4> } // overhanging leaves image map
object { BackDrop translate <920,0,-2> } // mountains image map
object { ShadowTrees scale .06 translate <-12*Feet,3*Feet,18*Feet> }
//object { TestSlab translate <0,0,-8> } // dummy ground
//object { SunBeam } // test ray
//object { TrunkVine scale <3,3,3.2> rotate <-170,0,98> translate <12,0,6> }

object { StreamWater scale <.6,.8,.3> rotate <-12,-5,-5> translate <-5,-13,.1> }
object { BubbleGroup2 scale .4 rotate <0,0,90> rotate <-7,0,0> translate <0,0,-2> } // center
object { BubbleGroup2 scale .24 rotate <0,0,-64> rotate <-7,0,0> translate <-0,-8,0> } // upper

//object { Rock1 scale 3 translate <4,-6,2> } // main
//object { Rock1 scale 2 rotate <23,160,125> translate <-4,9,-4> } // side

//object { Lizard2Body scale 1.6 rotate <90,0,-230> translate <4,-7,5.5> } // top dog
//object { Lizard2Eyes scale 1.6 rotate <90,0,-230> translate <4,-7,5.5> } // top dog
//object { Lizard2Body scale 1.6 rotate <90,-20,-73> translate <1,0,-1> } // onlooker
//object { Lizard2Eyes scale 1.6 rotate <90,-20,-73> translate <1,0,-1> } // onlooker

object { DeadGroup }

object { Weeds1 scale <1,1,.7> translate <12,-12,-1> } // right
object { Weeds2 scale <1,1,1> translate <18,-5,-4> } // left center
object { Weeds1 scale <1,1,1> translate <18,10,-7> } // left
object { WeedBlades1 scale <1,1,1> translate <7,-14,-7> } // left

//object { SquatPlant1 scale 1 rotate <7,0,0> translate <12,7,-3> }
//object { SquatPlant1 scale 1.1 rotate <0,3,49> translate <12,13,-5> }

//object { SquatPlant2 scale 1 rotate <-4,0,0> translate <3,12,-3> } // center left
//object { SquatPlant2 scale 1.1 rotate <0,-3,52> translate <9,-16,1> } // right edge

//object { Branch1Main scale 1.4 rotate <0,0,-20> translate <12,-12,0> } // stems on the right
//object { Branch1Main scale 1.6 rotate <0,0,-66> translate <16,-18,0> } // stems on the right

//object { StraightBranch2 scale .26 rotate <-6,44,0> translate CamLoc+<3,0,4> } // overhead, connected to cam
//object { StraightBranch2 scale .31 rotate <-6,44,30> translate CamLoc+<3,2,4> } // overhead, connected to cam
//object { StraightBranch2 scale .31 rotate <-6,44,-30> translate CamLoc+<3,2,5> } // overhead, connected to cam
object { WeedBlades1 scale .8 rotate <-6,4,-3> translate CamLoc+<5,2,-5> } //connected to cam
object { WeedBlades1 scale .7 rotate <-6,4,-230> translate CamLoc+<7,-3,-5> } //connected to cam



//object { WhiteSphere scale 3*Feet }
} // end union
object { AllStuff translate CamPos } // raise everything above the valley floor,
// because ground fogs cannot be translated, they always begin at zero height.


