
// Glenn's POV-Ray Scene File - Plants
// created 31-May-98
// last update 31-May-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Plants.inc" in another .pov file
//
// SquatPlant1 - 7 inches high, 8 leaves
//
// All plants have stems beginning at the origin.
// Plants mostly extend into +Z


//================================================================
//      Remove this section -- only used for test renders!
//================================================================
/*
#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//    angle 40
//    direction z*50
//  location <-12, -12, 21> // normal view
//  location <-1, -1, 21> // top view
//  location <1, -21, 4> // side view
  location <-15, -1, 0> // rear view
  look_at <0, 0, 8>
  }

camera { // special cameras declared in GCamerasRH.inc
    Special_Cam
//    Back16Inch_Cam // use values 1,2,4,8,12,16,32,64,or 128
//    location <6*Feet, 6*Feet, 5*Feet> // "Reverse Angle"
//    location <-42, -24, 10> // Standard Position
    angle 40
    look_at <0, 0, 0>
  }
object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
object {StdBulb60Watt translate <-10*Feet,2*Feet,8*Feet> }
background { color rgb <0.2, 0.4, 0.8> } // light blue
//object {GroundPlaneWhite translate z*-0}
*/

//===============================================
//             Textures
//===============================================

#declare Branch1Tex = // stem texture
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0 rgb<.334,.453,.008> ] // green
				[ 0.5 rgb<.134,.554,.002> ] // green
				[ 1.0 rgb<.024,.263,.012> ] // green
			}
			scale <.12,.15,1.6>
		}
		normal { bumps .6 scale .2 }
	}


//===============================================
//             Objects
//===============================================

#include "Leaves.inc"
#include "BranchStem.pov"
#declare Branch1Main =
	object { BranchStem1 }
//#declare RS = seed(73538)
//#declare BaseX = 3.0
//#declare Split = .1

#declare SquatPlant1 = // 7-inches high, 8 leaves
	union {
		object { BranchStem1 scale <0.5,0.5,0.5> translate <0,0,-9> } // along z-axis

		object { ThickLeaf1 scale 1.0 rotate <0,-26,0> translate <0.65,-0.7,2.2> }
		object { ThickLeaf1 scale 1.0 rotate <0,-26,182> translate <0.65,-0.7,2.2> }

		object { ThickLeaf1 scale 0.88 rotate <2,-30,93> translate <0.4,-0.5,3.4> }
		object { ThickLeaf1 scale 0.88 rotate <3,-30,272> translate <0.4,-0.5,3.4> }

		object { ThickLeaf1 scale 0.70 rotate <4,-34,-3> translate <0.2,-0.35,4.2> }
		object { ThickLeaf1 scale 0.70 rotate <-4,-34,175> translate <0.2,-0.35,4.2> }

		object { ThickLeaf1 scale 0.38 rotate <-5,-38,90> translate <0,0,5.4> }
		object { ThickLeaf1 scale 0.38 rotate <-4,-38,275> translate <0, 0,5.4> }

	} // end union

#declare SquatPlant2 = // 7-inches high, 12 leaves
	union {

		object { ThickLeaf2 scale 1.0 rotate <2,-64,93> translate <0.4,-0.5,0> }
		object { ThickLeaf2 scale 1.0 rotate <3,-65,272> translate <0.4,-0.5,0> }

		object { ThickLeaf2 scale 0.95 rotate <0,-66,0> translate <0.65,-0.7,2.2> }
		object { ThickLeaf2 scale 0.95 rotate <0,-66,182> translate <0.65,-0.7,2.2> }

		object { ThickLeaf2 scale 0.88 rotate <2,-70,93> translate <0.4,-0.5,3.4> }
		object { ThickLeaf2 scale 0.88 rotate <3,-70,272> translate <0.4,-0.5,3.4> }

		object { ThickLeaf2 scale 0.70 rotate <4,-74,-3> translate <0.2,-0.35,4.2> }
		object { ThickLeaf2 scale 0.70 rotate <-4,-74,175> translate <0.2,-0.35,4.2> }

		object { ThickLeaf2 scale 0.58 rotate <-5,-76,90> translate <0,0,5.4> }
		object { ThickLeaf2 scale 0.58 rotate <-4,-76,275> translate <0, 0,5.4> }

		object { ThickLeaf2 scale 0.42 rotate <4,-84,-3> translate <0.2,-0.35,6.2> }
		object { ThickLeaf2 scale 0.42 rotate <-4,-84,175> translate <0.2,-0.35,6.2> }

	} // end union

//===============================================
//             Object Placement
//===============================================

//object { TestSphere scale 4 translate <0,-6,3> }
//object { StraightBranch2 translate <-8,-1,0> }
//object { SquatPlant1 translate <0,0,-4> }

