//==========================================================================================
//  Wasp originally created by N.B.  (modified by Fabien Mosen)
//==========================================================================================
#declare WSP_TEX=
texture {
   finish {
      ambient <0.4,0.25,.15>
      diffuse 0.7
      phong 0.5
      phong_size 40
      }
   normal {bumps 0.3 scale 0.03}
   pigment {color rgb <.2,.12,.1>}
}

#declare WSP_WNG=
texture {
   finish {
      irid {0.3
          thickness 0.3
          turbulence .6
          }
      ambient <.3, .1, 0.02>
      diffuse 0.2
      reflection .25
      refraction 0
      ior 1.2
      specular 1
      roughness 0.001}
   normal {wrinkles .8}
   pigment { rgbt <.3, .1, 0.02, 0.4>}
}

#declare WSP_EYE=
texture {
   finish {
      ambient <.2,.12,.1>
      diffuse .5
      reflection .2
      specular .8
      roughness 0.001}
pigment { color rgb <.2,.12,.1>}
}

#declare X0=0
#declare Y0=0
#declare XS=0
#declare YS=0
#declare R=2
#declare r=3.5
#declare RC=17
#declare A0=0
#declare n=1.05
#declare LX0=(RC*cos(A0))
#declare LY0=(RC*sin(A0))
#declare Count=12
#declare Countn=((Count+1)/2)
#declare WASP02=
blob{threshold 0.6
     cylinder {<0,0,0>,<-10,-10,0>,10,-5 scale<1,.1,1>translate<0,-2,0>}
     sphere {<0,0,0>,R,5 scale<.6,1,.6> rotate<0,0,A0> translate<XS,YS,0>}
        #while (Count>=1)
           #if (Count<=10)
           #declare n=.9
           #else
           #end
           #if (Count<=9)
           #declare n=.78
           #else
           #end
           #declare R=(R*n)
           #declare A=(A0+(2*asin(R/(RC*r))))
           #declare LX=(RC*cos(A))
           #declare LY=(RC*sin(A))
           #declare X=(X0+(LX-LX0))
           #declare Y=(Y0+(LY-LY0))
           #declare X1=(X+XS)
           #declare Y1=(Y+YS)
           #declare AA=degrees(A)
           sphere { <0,0,0>,R,5 scale<.6,1,.6> rotate<0,0,AA> translate<X1,Y1,0>}
           #declare A0=A
           #declare Y0=Y
           #declare X0=X
           #declare LX0=LX
           #declare LY0=LY
           #declare Count=Count-1
        #end
rotate z*85
scale <.55,1,.95>
rotate z*-90
rotate y*180
rotate x*180
texture {WSP_TEX pigment { image_map {gif "w001b.gif" map_type 2} scale 4.9 translate y*.9}}
}

#declare WASP01=
blob{threshold 0.6
   sphere {<0,0,0>,1.45,4 scale<1,1.4,.9> rotate z*25 translate<-.2,1.9,0>}
   cylinder {<0,0,0>,<-10,-10,0>,8,-5 scale<1,.1,1> rotate z*-13}
   texture {WSP_TEX
      pigment {image_map {gif "w002.gif" map_type 2} scale 2.8 translate y*0.4}}
}

#declare WSP_H01=
blob{threshold 0.6
     cylinder {<-.65,0,0>,<.65,0,0>,1.5,4 scale<1,1,.6>}
     sphere {<0,0,0>,1.5,3 scale<1,1.1,.65> translate <0,-.4,0>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,2 scale<1.45,1,1> translate <0,.45,-.2>}
     sphere {<0,0,0>,.4,2 scale<.9,1,1> translate <-.17,-.69,-.4> rotate z*-30}
     sphere {<0,0,0>,.4,2 scale<.9,1,1> translate <.17,-.69,-.4> rotate z*30}
     sphere {<0,0,0>,.5,3 scale<1.5,1.3,1.1> translate <0,0.17,-.4>}
     sphere {<0,0,0>,.45,3 scale<1,1.1,1> translate <-.2,0.2,-.4> rotate z*10}
     sphere {<0,0,0>,.45,3 scale<1,1.1,1> translate <.2,0.2,-.4> rotate z*-10}
     sphere {<0,0,0>,.6,-4 scale<1,1,5> translate <0,-1.75,0>}
     sphere {<0,0,0>,.55,-4 scale<.7,1,5> translate <-.92,-1.25,0> rotate z*10}
     sphere {<0,0,0>,.55,-4 scale<.7,1,5> translate <.92,-1.25,0> rotate z*-10}
     }

#declare WSP_H02=
blob{threshold 0.6
     cylinder {<-.8,0,0>,<.8,0,0>,1.4,5 scale<1,.9,.6> translate <0,0,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-3 scale<.9,1,10> translate <0,.7,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-3 scale<1,2,10> translate <0,0,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-3 scale<1.1,1,10> translate <0,.1,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-3 scale<1.2,1,10> translate <0,.2,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-3 scale<1.25,1,10> translate <0,.32,-.2>}
     cylinder {<-.7,0,0>,<.7,0,0>,.3,-4 scale<1.45,1,10> translate <0,.45,-.2>}
     cylinder {<0,0,0>,<0,1,0>,.5,-3 scale<2,1,10> translate <0,.4,-.2>}
     cylinder {<0,0,0>,<0,-2,0>,.6,-5 scale<2.2,1,15> translate <0,.4,-.2>}
     }

#declare WSP_H03=
difference {
blob{threshold 0.6
     cylinder {<-.65,0,0>,<.65,0,0>,1.5,4.2 scale<1,1,.6>}
     sphere {<0,0,0>,1.5,3.2 scale<.85,1,.7> translate <0,-.1,0>}
     sphere {<0,0,0>,1.5,3.2 scale<1,1.1,.65> translate <0,-.4,0>}
     sphere {<0,0,0>,.2,3 translate <0,-0.45,-.5>}
     sphere {<0,0,0>,.4,2 scale<.3,1.4,1> translate <0,-.6,-.4>}
     sphere {<0,0,0>,.4,2 scale<1.5,1,1> translate <0,-.7,-.4>}
     sphere {<0,0,0>,.42,-3 scale<1,1.1,1> translate <-.2,0.2,-.5> rotate z*10}
     sphere {<0,0,0>,.42,-3 scale<1,1.1,1> translate <.2,0.2,-.5> rotate z*-10}
     sphere {<0,0,0>,.50,-4 scale<.9,1.4,2> translate <-1.3,.2,-.5> rotate z*10}
     sphere {<0,0,0>,.50,-4 scale<.9,1.4,2> translate <1.3,0.2,-.5> rotate z*-10}
     sphere {<0,0,0>,.42,-2 scale<.9,1.05,2> translate <-.12,-.67,-.5> rotate z*-35}
     sphere {<0,0,0>,.42,-2 scale<.9,1.05,2> translate <.12,-.67,-.5> rotate z*35}
     sphere {<0,0,0>,.3,-2 scale<.5,1,2> translate <-.3,-.9,-.5> rotate z*-35}
     sphere {<0,0,0>,.3,-2 scale<.5,1,2> translate <.3,-.9,-.5> rotate z*35}
     sphere {<0,0,0>,1.5,-4 scale<2,1.1,10> translate <0,-2.2,0>}
     }
box { <5,-.95,-5><-5,-3,5>}
}

#declare WSP_H04=
difference{
    sphere {<0,0,0>,1 scale<.5,1,.5> rotate z*55 translate <-0.25,-1.3,0>}
    sphere {<0,0,0>,1.1 scale<.4,1.2,10> rotate z*5 translate <0.4,-.9,0>}
    texture {WSP_TEX pigment {color rgb <.98,.85,.05>}}
}

#declare X0=0
#declare Y0=0
#declare XS=0
#declare YS=0
#declare R=.3
#declare r=1.85
#declare RC=3
#declare A0=0
#declare n=1.1
#declare m=(1/n)
#declare LX0=(RC*cos(A0))
#declare LY0=(RC*sin(A0))
#declare Count=12
#declare Countn=((Count+1)/2)
#declare WSP_ANT01=
blob{threshold 0.6
     cylinder {<XS,YS,0>,<XS,YS-1,0>,R*1.5,5 scale<.4,1,.4>}
     sphere {<0,0,0>,R,5 scale<.4,1,.4> rotate<0,0,A0> translate<XS,YS,0>}
        #while (Count>=1)
           #if (Count<Countn)
           #declare n=m
           #else
           #end
           #declare R=(R*n)
           #declare A=(A0+(2*asin(R/(RC*r))))
           #declare LX=(RC*cos(A))
           #declare LY=(RC*sin(A))
           #declare X=(X0+(LX-LX0))
           #declare Y=(Y0+(LY-LY0))
           #declare X1=(X+XS)
           #declare Y1=(Y+YS)
           #declare AA=degrees(A)
           sphere { <0,0,0>,R,5 scale<.4,1,.4> rotate<0,0,AA> translate<X1,Y1,0>
           }
           #declare A0=A
           #declare Y0=Y
           #declare X0=X
           #declare LX0=LX
           #declare LY0=LY
           #declare Count=Count-1
        #end
texture{WSP_TEX pigment { rgb <.20,.12,.08>}}
}

#declare WSP_H=
union{
   union{
      object {WSP_H01 texture {WSP_TEX pigment {color rgb <.95,.82,0>}}}
      object {WSP_H02 rotate x*5 texture {WSP_EYE}}
      object {WSP_H03 texture {WSP_TEX pigment {color rgb <.20,.12,.08>}}}
      object {WSP_H04}
      object {WSP_H04 scale<1,1,.9> rotate y*180 rotate z*-4 translate <0.1,.1,0>}
   scale <.8,1,1> rotate z*180 rotate x*90}
   object {WSP_ANT01 scale .3 translate <0,1,0> rotate y*70 rotate x*-45 rotate z*30 translate <-.5,.5,.2>}
   object {WSP_ANT01 scale .3 translate <0,1,0> rotate y*110 rotate x*-45 rotate z*-30 translate <.5,.5,.2>}
}


#declare WSP_RND=seed(0)

#declare WASP00_f=
union {
object {WASP02 rotate y*-90}
object {WASP01 rotate y*-90}

#include "wasp01.inc"
//#declare WSP_RW=
union{
   union{
      object {W_Wing012}
      object {W_Wing011}
      sphere {0,.7}
      rotate x*(-10+6*(0.5-rand(WSP_RND)))
      rotate y*(15+6*(0.5-rand(WSP_RND)))
   }
   union{
      object {W_Wing022}
      object {W_Wing021}
      sphere {0,.65}
      rotate x*(-5+6*(0.5-rand(WSP_RND)))
      rotate y*(10+6*(0.5-rand(WSP_RND)))
      translate <0.025, -2.719, .9>
   }
scale .16 translate <.7,1.85,-1.2> texture {WSP_WNG}}
// object {WSP_RW}
//#declare WSP_LW=
union{
   union{
      object {W_Wing012}
      object {W_Wing011}
      sphere {0,.7}
      rotate x*(10+6*(0.5-rand(WSP_RND)))
      rotate y*(165+6*(0.5-rand(WSP_RND)))
   }
   union{
      object {W_Wing022}
      object {W_Wing021}
      sphere {0,.65}
      rotate x*(5+6*(0.5-rand(WSP_RND)))
      rotate y*(170+6*(0.5-rand(WSP_RND)))
      translate <0.025, -2.719, .9>
   }
scale .16 translate <-.7,1.85,-1.2> texture {WSP_WNG} }
// object {WSP_LW}

object {WSP_H /* scale 0.7 */ scale<.7,.8,.7>*.95 rotate x*10 translate <0,3.6,0.2>}
union{
   sphere{0,.07 translate <0,4.1,-.37>}
   sphere{0,.07 translate <-0.12,4,-.5>}
   sphere{0,.07 translate <0.12,4,-.5>}
texture {WSP_EYE}
}

//leg01_right
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 10+20*(0.5-rand(WSP_RND))
#declare LANG02B = -98+20*(0.5-rand(WSP_RND))
#declare SIDE07B = -51+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .075  rotate x*-90 translate <.3,2.3,1.1> texture{WSP_TEX}}

//leg02_right
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = -10+20*(0.5-rand(WSP_RND))
#declare LANG02B = -85+20*(0.5-rand(WSP_RND))
#declare SIDE07B = 36+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .081  rotate x*-90 translate <.3,1.2,1.5> texture{WSP_TEX}}

//leg03_right
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = -12+20*(0.5-rand(WSP_RND))
#declare LANG02B = -75+20*(0.5-rand(WSP_RND))
#declare SIDE07B = 61+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .085  rotate x*-90 translate <.2,.7,1.5> texture{WSP_TEX}}

//leg01_left
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 10+20*(0.5-rand(WSP_RND))
#declare LANG02B = -98+20*(0.5-rand(WSP_RND))
#declare SIDE07B = 50+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .075 rotate y*180 rotate x*-90 translate <-.3,2.3,1.1> texture{WSP_TEX}}

//leg02_left
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = -10+20*(0.5-rand(WSP_RND))
#declare LANG02B = -85+20*(0.5-rand(WSP_RND))
#declare SIDE07B = -35+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .081 rotate y*180 rotate x*-90 translate <-.3,1.2,1.5> texture{WSP_TEX}}

//leg03_left
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = -12+20*(0.5-rand(WSP_RND))
#declare LANG02B = -75+20*(0.5-rand(WSP_RND))
#declare SIDE07B = -60+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .085 rotate y*180 rotate x*-90 translate <-.2,.7,1.5> texture{WSP_TEX}}

scale 2.3
}
// object {WASP00_f}

// #declare WSP_RND=seed(0)

#declare WASP00_s=
union {
object {WASP02 rotate y*-90}
object {WASP01 rotate y*-90}

#include "wasp01.inc"
//#declare WSP_RW=
union{
   union{
      object {W_Wing012}
      object {W_Wing011}
      sphere {0,.7}
      rotate x*10
      rotate y*5
      rotate z*-99
   }
   union{
      object {W_Wing022}
      object {W_Wing021}
      sphere {0,.65}
      rotate x*5
      rotate y*0
      rotate z*-86
      translate <0.025, -2.719, .9>
   }
scale .16 translate <.7,1.85,-1.2> texture {WSP_WNG}}
// object {WSP_RW}
//#declare WSP_LW=
union{
   union{
      object {W_Wing012}
      object {W_Wing011}
      sphere {0,.7}
      rotate x*-10
      rotate y*175
      rotate z*99
   }
   union{
      object {W_Wing022}
      object {W_Wing021}
      sphere {0,.65}
      rotate x*-5
      rotate y*180
      rotate z*86
      translate <0.025, -2.719, .9>
   }
scale .16 translate <-.7,1.85,-1.2> texture {WSP_WNG} }
// object {WSP_LW}

object {WSP_H /* scale 0.7 */ scale<.7,.8,.7>*.95 rotate x*10 translate <0,3.6,0.2>}
union{
   sphere{0,.07 translate <0,4.1,-.37>}
   sphere{0,.07 translate <-0.12,4,-.5>}
   sphere{0,.07 translate <0.12,4,-.5>}
texture {WSP_EYE}
}

//leg01_right
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 10+20*(0.5-rand(WSP_RND))
#declare LANG02B = -98+20*(0.5-rand(WSP_RND))
#declare SIDE07B = -51+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .075  rotate x*-90 translate <.3,2.3,1.1> texture{WSP_TEX}}

//leg02_right
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 16+20*(0.5-rand(WSP_RND))
#declare LANG02B = -89+20*(0.5-rand(WSP_RND))
#declare SIDE07B = 36+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .081  rotate x*-90 translate <.3,1.2,1.5> texture{WSP_TEX}}

//leg03_right
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 15+20*(0.5-rand(WSP_RND))
#declare LANG02B = -56+20*(0.5-rand(WSP_RND))
#declare SIDE07B = 61+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .085  rotate x*-90 translate <.2,.7,1.5> texture{WSP_TEX}}

//leg01_left
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 10+20*(0.5-rand(WSP_RND))
#declare LANG02B = -98+20*(0.5-rand(WSP_RND))
#declare SIDE07B = 50+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .075 rotate y*180 rotate x*-90 translate <-.3,2.3,1.1> texture{WSP_TEX}}

//leg02_left
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 17+20*(0.5-rand(WSP_RND))
#declare LANG02B = -85+20*(0.5-rand(WSP_RND))
#declare SIDE07B = -35+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .081 rotate y*180 rotate x*-90 translate <-.3,1.2,1.5> texture{WSP_TEX}}

//leg03_left
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 16+20*(0.5-rand(WSP_RND))
#declare LANG02B = -55+20*(0.5-rand(WSP_RND))
#declare SIDE07B = -60+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .085 rotate y*180 rotate x*-90 translate <-.2,.7,1.5> texture{WSP_TEX}}

scale 2.3
}
// object {WASP00_s}

#declare WASP00_i=
union {
object {WASP02 rotate y*-90}
object {WASP01 rotate y*-90}
object {WSP_H /* scale 0.7 */ scale<.7,.8,.7>*.95 rotate x*10 translate <0,3.6,0.2>}
union{
   sphere{0,.07 translate <0,4.1,-.37>}
   sphere{0,.07 translate <-0.12,4,-.5>}
   sphere{0,.07 translate <0.12,4,-.5>}
texture {WSP_EYE}
}
scale 2.3
}

#declare WASP00_f1=
union {
object {WASP02 rotate y*-90}
object {WASP01 rotate y*-90}

#include "wasp01.inc"
//#declare WSP_RW=
union{
   union{
      object {W_Wing012}
      object {W_Wing011}
      sphere {0,.7}
      rotate x*(-10+8*(0.5-rand(WSP_RND)))*(0.5-rand(WSP_RND))
      rotate y*(15+8*(0.5-rand(WSP_RND)))
   }
   union{
      object {W_Wing022}
      object {W_Wing021}
      sphere {0,.65}
      rotate x*(-5+8*(0.5-rand(WSP_RND)))*(0.5-rand(WSP_RND))
      rotate y*(10+8*(0.5-rand(WSP_RND)))
      translate <0.025, -2.719, .9>
   }
scale .16 translate <.7,1.85,-1.2> texture {WSP_WNG}}
// object {WSP_RW}
//#declare WSP_LW=
union{
   union{
      object {W_Wing012}
      object {W_Wing011}
      sphere {0,.7}
      rotate x*(10+8*(0.5-rand(WSP_RND)))*(0.5-rand(WSP_RND))
      rotate y*(165+8*(0.5-rand(WSP_RND)))
   }
   union{
      object {W_Wing022}
      object {W_Wing021}
      sphere {0,.65}
      rotate x*(5+8*(0.5-rand(WSP_RND)))*(0.5-rand(WSP_RND))
      rotate y*(170+8*(0.5-rand(WSP_RND)))
      translate <0.025, -2.719, .9>
   }
scale .16 translate <-.7,1.85,-1.2> texture {WSP_WNG}}

// object {WSP_LW}

object {WSP_H /* scale 0.7 */ scale<.7,.8,.7>*.95 rotate x*10 translate <0,3.6,0.2>}
union{
   sphere{0,.07 translate <0,4.1,-.37>}
   sphere{0,.07 translate <-0.12,4,-.5>}
   sphere{0,.07 translate <0.12,4,-.5>}
texture {WSP_EYE}
}

//leg01_right
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 15-20*(0.5-rand(WSP_RND))
#declare LANG02B = -48+20*(0.5-rand(WSP_RND))
#declare SIDE07B = -49+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .075  rotate x*-90 translate <.3,2.3,1.1> texture{WSP_TEX}}

//leg02_right
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 17+20*(0.5-rand(WSP_RND))
#declare LANG02B = -73+20*(0.5-rand(WSP_RND))
#declare SIDE07B = 39+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .081  rotate x*-90 translate <.3,1.2,1.5> texture{WSP_TEX}}

//leg03_right
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 18+20*(0.5-rand(WSP_RND))
#declare LANG02B = -46+20*(0.5-rand(WSP_RND))
#declare SIDE07B = 61+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .085  rotate x*-90 translate <.2,.7,1.5> texture{WSP_TEX}}

//leg01_left
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 14-20*(0.5-rand(WSP_RND))
#declare LANG02B = -64+20*(0.5-rand(WSP_RND))
#declare SIDE07B = 52+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .075 rotate y*180 rotate x*-90 translate <-.3,2.3,1.1> texture{WSP_TEX}}

//leg02_left
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 15+20*(0.5-rand(WSP_RND))
#declare LANG02B = -71+20*(0.5-rand(WSP_RND))
#declare SIDE07B = -38+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .081 rotate y*180 rotate x*-90 translate <-.3,1.2,1.5> texture{WSP_TEX}}

//leg03_left
#declare RADI07B = .8
#declare STRE07B = 2
#declare DENS07B = STRE07B*pow((1-pow(RADI07B,2)),2)
#declare SECT07B = 7
#declare ANGL07B = 7
#declare ANGL17B = 0
#declare LANG01B = 19+20*(0.5-rand(WSP_RND))
#declare LANG02B = -52+20*(0.5-rand(WSP_RND))
#declare SIDE07B = -67+20*(0.5-rand(WSP_RND))
#include "wsp_lg.inc"
object{L07B scale .085 rotate y*180 rotate x*-90 translate <-.2,.7,1.5> texture{WSP_TEX}}

scale 2.3
}
