
// Persistence of Vision Ray Tracer Scene Description File
// File: fnp.pov
// Vers: 3
// Desc: see the TXT file
// Date: Jun 29 1998
// Auth: Micha Riser (mriser@usa.net)
//       http://www.geocities.com/SiliconValley/Pines/7992/

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "skies.inc"

global_settings{max_trace_level 40}

#declare c1=camera
{
 location  <0.672 , .21 ,0.458>*10
 look_at  <0.4475 , -0.1795 , .75>*10 //<0.45 , -0.175 , .75>*10
  angle 51
}

#declare c2=camera
{

location <0.66,0.21,0.469>*10
look_at <0.66,0.,0.469>*10
 angle 55
}

light_source
{
  0*x // light's position (translated below)
  color 1.25  // light's color
  translate <30,100,12>
}


sky_sphere { S_Cloud1 }

//********************************************************
//------------------ Schlucht height field --------------- (Precipice)
//********************************************************

#declare hftexture=texture{pigment{
gradient y
pigment_map{
[0 rgb<240/255,158/255,0>]
[0.25 rgb<131/255,55/255,21/255>*1.5]
[0.35 rgb<135/255,70/255,30/255>*1.5]
[0.9 rgb<1,173/255,6/255>]
}
turbulence -0.05
scale<1,0.25,1>*10
}
}

#declare schlucht=union{

height_field
{
  tga
  "f:\hfschl7.tga"
scale <1,0.25,1>*10
smooth  //---SMOOTH 

translate <0,-0.020,-0.01>
}

intersection{

height_field
{
  tga
  "f:\gforge.tga"
  scale <0.25,0.075,0.25>
  translate <0.649,0.186,0.455>*10
}

height_field
{
  tga
  "f:\hfschl7.tga"
  texture{pigment{Red}}

scale <1,0.25,1>*10
translate <0.0345,0.05,-0.03782>
}

}

texture{hftexture}

}


// River:
plane{ y,0  translate <0,0.03,0> pigment{rgb<0.1,0.1,0.4>} finish{reflection 0.97 roughness 0.06 specular 0.3} normal{bumps scale<5,1,1>*0.006}}



//**************************************************
//------------------- Flower begin -----------------
//**************************************************


//-------------------- Stengel ---------------------
#declare stengel=union{
#declare mm=0
#declare zus=0
#declare zmm=1
#declare zzmm=0
#while (mm<65)
#declare zzmm=zzmm+0.001
#declare zmm=zmm+zzmm
#declare mm=mm+0.125
#declare zus=zus+pow((100-mm),2)*0.000003*0.5*0.4987*.4987

#if (mm>8)
sphere{<0,0,0>,(0.175-mm*0.0015)*0.4
scale<2,1,1>
pigment{radial
  pigment_map{
  [0.05 Green*0.85]
  [0.45 Green*0.85]
  [0.65 rgb<0.4,1,0.4>]
  [0.85 rgb<0.4,1,0.4>]
  }
  frequency 40
}

translate<0.4,0,0>
rotate z*mm*1.75
translate<0,mm*0.015+zus,0>
}
#end

#end
scale 0.3
translate<0,0,0>
}

//------------------- Bltter ---------------------- (leafs)

#declare Blatt1=
blob{threshold 0.1
sphere{<0,0,0>,1,1 scale <0.45,1,0.4>}
sphere{<0,0,0>,2,-2500
scale<0.45,3,1>
translate<0.1,-.1,-1.77>
}
sphere{<0,0,0>,0.8,-5
translate<-0.75,0.73,0>}
sphere{<0,0,0>,0.75,-1
translate<-0.6,0.3,0>}



scale 0.35
scale 0.75
rotate x*23
rotate y*90
translate <0.18,0.22,-0.03>
pigment{Green}
translate <-.05,0.15,-.1>
}

#declare Blatt2=difference{
blob{threshold 0.1
sphere{<0,0,0>,1,1 scale <0.45,1,0.4>}
sphere{<0,0,0>,2,-2500
scale<0.45,3,1>
translate<0.1,-.1,-1.77>
}
sphere{<0,0,0>,0.8,-5
translate<-0.75,0.73,0>}
sphere{<0,0,0>,0.75,-1
translate<-0.6,0.3,0>}
}

scale 0.35
scale 0.75
rotate x*23
rotate y*270
translate <0.05,0.22,0>
pigment{Green}
translate <-.05,0.15,-.1>

}


//------------------ Bltenobjekt ---------------------

#declare detailfact=0.5

#declare blute=union{

#declare r1=seed(191)
#declare z2=0
#while (z2<8)
#declare z2=z2+1

#declare minus=0
#declare xkor=0
#declare ykor=0
#declare zkor=0
#declare zahler=-1
#declare winkel1=0
#declare winkel2=0

#while (zahler<100)
#declare zahler=zahler+detailfact
#declare dwinkel2=-13.5/5 *detailfact
#declare dwinkel1=15/5 *detailfact
#declare winkel1=winkel1+dwinkel1
#declare winkel2=winkel2+dwinkel2

#if (zahler>80) #declare minus=minus+0.3*detailfact
                          #end

 cylinder{<0,0,0>,<0,0,0.65/5*detailfact>,(0.2)

 pigment{radial
   pigment_map{
    [0 White]
    [0.47 White]
    [0.55 rgb<1,1,1>]
    [0.63 White]
   }
   rotate x*90
   frequency 15
   }

finish{diffuse 0.7}


 rotate x*winkel2
 scale <2+(zahler*0.2/5)-minus,1,1>

 rotate y*winkel1
 translate <xkor,ykor,zkor>
 rotate y*z2*45
 translate <0,0,1.5>
scale 0.35

}

#declare zkor=zkor+cos(radians(winkel1))*cos(radians(winkel2))*0.5/5*detailfact
#declare xkor=xkor+cos(radians(winkel2))*sin(radians(winkel1))*0.5/5*detailfact
#declare ykor=ykor+sin(radians(-winkel2))*0.5/5*detailfact
#end

cylinder{<0,0,0>,<0,1.5,0>,0.017 pigment{Yellow}
  translate<0.3,0,0>
  rotate y*z2*45
 translate<0,0,.5>
}

blob{threshold 0.3
sphere{<0,0,0>,0.07,1  scale<0.8,2,1>}
sphere{<-0.05,0,0>,0.04,-1 scale<1,7,0.2> }//pigment{Blue}}

  pigment{Yellow}
 scale 1.5*0.85
 normal{bumps scale <0.01,0.05,0.01>*1.35}
  rotate z*-30
  translate<0.3,0,0>
  rotate y*z2*45
  translate<0,1.5,.5>
}

#end

blob{threshold 0.2
sphere{<0,0,0>,0.05,1 scale<1,3,1> translate<0,0.3,0> scale 2.5}
sphere{<0,0,0>,0.04,1 scale<1,3,1> translate<0,0.38,0> scale 2.5}
cylinder{<0,0,0>,<0,1.75,0>,0.03,1}
#declare pp=0
#while (pp<4)
#declare pp=pp+1
#declare pq=0
#while (pq<50)
#declare pq=pq+1
sphere{<-0.2,0,0>,0.03/75*pq,1  rotate -z*(10+pq*3) translate<-0.2,0,0> rotate y*pp*90 translate<0,1.7,0>
   pigment{Green}  normal{bumps scale 0.01}}
#end
#end

translate<0,0,.5>
pigment{Green}}


cylinder{<0,-1.5,0>,<0,0,0>,0.2 pigment{Green}
translate <0,0,0.5>}
}

//----------------- Blte 1 bis 5 ------------------- (blooms)

#declare sdw=60

#declare b1=object{
blute
scale 0.05
translate <0,0.04,0>
rotate x*35
rotate y*50
translate<0.055,0.5,0>

rotate y*sdw}

#declare b2=object{
blute
translate <0,0.8,0>
scale 0.046
rotate x*35
rotate y*130
translate<0.02,0.55,0>

rotate y*sdw
}

#declare b3=object{
blute
translate <0,0.8,0>
scale 0.042
rotate x*35
rotate y*25
translate<0,0.6,0>

rotate y*sdw
}

#declare b4=object{
blute
translate <0,0.8,0>
scale 0.038
rotate x*30
rotate y*125
translate <-0.03,0.65,0>

rotate y*sdw
}

#declare b5=object{
blute
translate <0,0.8,0>
scale 0.034
rotate x*29
rotate y*35
translate <-0.05,0.69,0>

rotate y*sdw
}

//------------------ Zusammenstellung ---------------

#declare flower=union{
object{Blatt1}
object{Blatt2}
object{b1}
object{b2}
object{b3}
object{b4}
object{b5}
object{stengel
rotate y*sdw}

}


//*************************************************
//----------------- Flower end --------------------
//*************************************************
//----------------- Bee begin ---------------------
//*************************************************


#declare beewing=prism {
  linear_sweep
  quadratic_spline
  0,
  0,
  10,
  <0.8,1.2>,
  <0,0>, <2.3,0.9> ,<5,1.25> ,<5.2,2.75>, <4.5,3.3>, <2.3,2.2>, <0.8,1.2>, <0,0>
  ,<2.3,0.9>
rotate x*-90
pigment{rgbt<0.7,0.7,0.7,0.85>}
normal{crackle scale <1,0.4,0.4> rotate z*30}
finish{roughness 0.03 specular 0.3}
}

#declare beesitting_wing=union{
object{
beewing scale<0.23,0.27,0.27>*1.4
rotate x*-90
rotate y*-20
rotate x*-20
rotate z*-5
pigment{rgbt<.7,.7,.7,0.5>}
translate<-.65,0.2,-.25>
}

object{
beewing scale<0.23,0.27,0.27>*1.4
rotate x*90
rotate y*-20
rotate x*20
rotate z*-5
pigment{rgbt<.7,.7,.7,0.4>}
translate<-.65,0.2,-.25>
}

}

#declare beewings=union{

#declare bz=10
#while (bz<170)
#declare bz=bz+10
object{beewing scale <0.23,0.27,0.27>*1.4
rotate z*30
rotate x*-bz
translate<-0.65,0,-0.25>
}

object{beewing scale <0.23,0.27,0.27>*1.4
rotate z*30
rotate x*bz
translate<-0.65,0,0.25>
}
#end

#declare beeyellow=pigment{
checker rgb<1,0.8,0.15>, rgb<0.6,0.5,0.175> scale 0.4 turbulence 5}
}

#declare beekoerper=union{

intersection{   //--- Hinterleib ---
sphere{<0,0,0>,1}
sphere{<1,0,0>,1.8}

pigment{gradient y
 pigment_map{
 [0 rgb<0.3,0.3,0.3>]
 [0.0 rgb<0.3,0.3,0.3>]
 [0.3 rgb<1,0.8,0.15>*0.7]
 [0.5
gradient x
 pigment_map{
  [0 rgb<0.2,0.2,0.2>*1.5]
  [0.35 rgb<0.2,0.2,0.2>]
  [0.5 beeyellow]//rgb<1,0.8,0.15>]
  [0.8 beeyellow]//rgb<1,0.8,0.15>]
  [0.9 rgb<0.2,0.2,0.2>*1.5]
  }
  translate -4.4
  scale 0.375
  turbulence 0.1]
  }
  translate<0,-0.4,0>
  scale<1,2,1>
  }

finish{specular 0.5 roughness 0.015}
scale<1,0.45,0.45>*0.9
translate <0.4,0,0>
rotate z*-10
}


sphere{<0,0,0>,0.4   //--- Koerper --- (body)

scale <1.01,1,1>
pigment{checker rgb<1,0.8,0.15>, rgb<0.6,0.5,0.175>*0.7 turbulence 0.4 scale <0.1,0.1,0.1>*0.4 }
translate <-0.6,0,0>
}

sphere{<0,0,0>,0.4   //---- Kopf --- (head)
scale<0.45,1,0.95>
rotate z*-10
translate <-1.15,0.07,0>
pigment{checker rgb<1,0.8,0.4>*0.7, rgb<0.2,0.2,0.2> turbulence 0.4 scale <0.1,0.1,0.1>*0.4 }
}

sphere{<0,0,0>,0.35 //--- Auge --- (eye)
scale<0.25,0.7,0.45>
rotate x*5
rotate z*-10
translate <-1.135,0.1,-0.3>
rotate x*10
pigment{rgb<0.2,0.2,0.2>}
finish{specular 1 roughness 0.015 }
}


sphere{<0,0,0>,0.35  //--- Auge --- (eye)
scale<0.25,0.7,0.45>
rotate x*5
rotate z*-10
translate <-1.135,0.1,0.3>
rotate x*-10
finish{specular 1 roughness 0.015 }
}

union{  //--- Beine ---- (legs)

union{
cylinder{<0,0,0>,<0,0.5,0>,0.05}
cylinder{<0,0,0>,<0,0.5,0>,0.045  rotate z*-30 translate<0,0.5,0>}
cylinder{<0,0,0>,<0,0.4,0>,0.04 rotate z*20 translate<0,0.5,0> rotate z*-30 translate<0,0.5,0>}

rotate z*-100
rotate y*20
translate<-0.4,-0.26,-0.25>
}

union{
cylinder{<0,0,0>,<0,0.5,0>,0.05}
cylinder{<0,0,0>,<0,0.5,0>,0.045  rotate z*-30 translate<0,0.5,0>}
cylinder{<0,0,0>,<0,0.4,0>,0.04 rotate z*20 translate<0,0.5,0> rotate z*-30 translate<0,0.5,0>}

rotate z*-100
rotate y*-20
translate<-0.4,-0.26,0.25>
}


union{
cylinder{<0,0,0>,<0,0.45,0>,0.045}
cylinder{<0,0,0>,<0,0.4,0>,0.04 rotate z*-30 rotate y*-40  translate<0,0.45,0>}
cylinder{<0,0,0>,<0,0.4,0>,0.036 rotate z*20 translate<0,0.4,0> rotate z*-30 rotate y*-40 translate<0,0.45,0>}

rotate z*-110
rotate y*40
translate<-0.55,-0.26,-0.25>
}

union{
cylinder{<0,0,0>,<0,0.45,0>,0.045}
cylinder{<0,0,0>,<0,0.4,0>,0.04 rotate z*-30 rotate y*40  translate<0,0.45,0>}
cylinder{<0,0,0>,<0,0.4,0>,0.036 rotate z*20 translate<0,0.4,0> rotate z*-30 rotate y*40 translate<0,0.45,0>}

rotate z*-110
rotate y*-40
translate<-0.55,-0.26,0.25>
}

union{
cylinder{<0,0,0>,<0,0.35,0>,0.04}
cylinder{<0,0,0>,<0,0.35,0>,0.037 rotate z*70 translate<0,0.35,0>}
cylinder{<0,0,0>,<0,0.3,0>,0.034  rotate z*-30 translate <0,0.35,0> rotate z*70 translate <0,0.35,0>}

rotate z*90
rotate y*-30
translate<-0.7,-0.3,-0.25>
}

union{
cylinder{<0,0,0>,<0,0.35,0>,0.04}
cylinder{<0,0,0>,<0,0.35,0>,0.037 rotate z*70 translate<0,0.35,0>}
cylinder{<0,0,0>,<0,0.3,0>,0.034  rotate z*-30 translate <0,0.35,0> rotate z*70 translate <0,0.35,0>}

rotate z*90
rotate y*30
translate<-0.7,-0.3,0.25>
}

pigment{rgb<0.2,0.2,0.2>}
finish{specular 0.5 roughness 0.015}
}

union{  //--- Fhler --- (tentacles)
cylinder{<0,0,0>,<0,0.5,0>,0.02}
cylinder{<0,0,0>,<0,0.7,0>,0.02 rotate z*70 rotate y*20 translate<0,0.5,0>}

rotate z*40
rotate y*-40
translate<-1.25,0.1,-0.1>
pigment{rgb<0.2,0.2,0.2>}
finish{specular 0.5 roughness 0.015}
}

union{
cylinder{<0,0,0>,<0,0.5,0>,0.02}
cylinder{<0,0,0>,<0,0.7,0>,0.02 rotate z*70 rotate y*-20 translate<0,0.5,0>}

rotate z*40
rotate y*40
translate<-1.25,0.1,0.1>
pigment{rgb<0.2,0.2,0.2>}
finish{specular 0.5 roughness 0.015}
}


}


#declare bee=union{object{beewings} object{beekoerper}}
#declare bee_sitting=union{object{beesitting_wing} object{beekoerper}}

//*****************************************************
//--------------Bee end -------------------------------
//*****************************************************

object{bee scale 0.003 
   translate<0.66069,0.20017,0.47025>*10}
object{bee scale 0.003 
   rotate y*100 translate<0.6608,0.1971,0.466>*10}
object{bee_sitting scale 0.003 
   rotate y*0 translate<0.6642,0.1951,0.46867>*10}

object{schlucht}
object{flower rotate y*-30 scale 0.25 translate<0.66,0.181,0.469>*10}
camera{c1}
