// this file is used to create a height field image

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


camera
{
  location  <0.0 , 0.55 ,-0.65>
  look_at   <0.0 , 0.55   , 0.0>
}

global_settings { hf_gray_16 }


#declare cm=color_map{[0 rgb<0.2,0.2,0.2>] [1 White]}
#declare cmi=color_map{[0 White] [1 rgb<0.2,0.2,0.2>]}

light_source
{
  0*x 
  color <1,1,1>*2.5  
  translate <-20, 40, -20>
}

#declare sf=0.7

#declare ufer=pigment{average pigment_map{ [1 rgb<0.05,0.05,0.05>*sf]
                                           [0.008 bumps scale 0.009]}
                                           }

#declare bach=pigment{
   gradient y
     pigment_map{
       [0 ufer]
       [0.56 ufer]
       [0.575 rgb<0,0,0>*sf]

     [0.58 ufer]
  
       [1 ufer]
       }

       turbulence 0.07
       translate<3.5,0,0>
 
      }


#declare streifencm=pigment{gradient x
   pigment_map{
     [0 rgb<0.3,0.3,0.3>]
     [0.25 White]//rgb<0.2,0.2,0.2>]
     [0.5 rgb<0.3,0.3,0.3>]
     [0.75 White]//rgb<0.2,0.2,0.2>]
     [1 rgb<0.3,0.3,0.3>]

  }
  turbulence 0.4
}

plane
{
  z, 
  1.0 



texture{gradient y
  texture_map{
    [0 pigment{White}]
    [0.4 pigment{White}]
    [0.55 pigment{average pigment_map{[1 streifencm scale 0.15] [1 color 0.65] }}]

    [0.6 pigment{average pigment_map{ [1 bach]
                                      [1 bach translate <10,0,0>]

                                     }
                 translate<0,-0.88,0> scale 1}]
    [0.8 pigment{average pigment_map{ [1 bach]
                                      [1 bach translate <10,0,0>]

                                      }
                 translate<0,-0.88,0> scale 1}]
       [0.85 pigment{average pigment_map{[1 streifencm  scale 0.15] [1 color 0.65] }}]

    [1 pigment{ White}]

   }
turbulence 0.25
}


}


