
// Persistence of Vision Ray Tracer Scene Description File
// File: Grenouille.pov
// Vers: 3.02
// Desc: IRTC (The Internet Raytracing Competition)
// Date: 25.05.98
// Auth: (c) R.Martial Martial.Rameaux@wanadoo.fr

#include "colors.inc"
#include "textures.inc"
#include "consts.inc"
#declare Rad_Quality = 3
#include "rad_def.inc"

global_settings { assumed_gamma 2.2
                  max_trace_level 6
                  max_intersections 60
                   }

#include "Grenouille.inc"

// Set a color of the background (sky)
//background { color red 0.9 green 0.9 blue 0.2 }

camera  {
  location  <0.0 , 2.0 ,-15.0>
  look_at   <0.0 , 0.0 , 0.0>
            }

light_source
{
  0*x color red 1.0  green 1.0  blue 1.0
  translate <20, 10, -20>
}


#declare Grenouille=
union {
// tte et corps
blob {
     threshold 0.6
// *** Tete
sphere { <0.0,   0,0>,1.5,4  scale <1.5,1,1.5> }
// *** bouche
sphere { <0.5,   0,0>,1.5,2  scale <1.5,0.4,1.5> texture {LipsTex }}
sphere { <0.5,-0.5,0>,1.5,2  scale <1.5,0.4,1.5> texture {LipsTex }}
// *** Yeux
sphere { <0.9,0.9,-1.0>,1,0.8  texture {YeuxBleuTex  } }
sphere { <0.9,0.9, 1.0>,1,0.8  texture {YeuxBleuTex  } }
// *** Corps
sphere {<-1.8,-1.1,0>,3 ,3 scale <1.5,0.9,0.5> rotate z*20}
sphere {<-1.8,-1.8,0>,3 ,3 scale <1.5,0.9,1> rotate z*20}

// *** pattes avant
cylinder { <-1,0.8,-0>,<0,-3,-3>, 0.7, 0.95}
cylinder { <0,-3,-3>,<0.5,-5,-1>, 0.7, 0.95}

cylinder { <-1,0.8,0>,<0,-3, 3>, 0.7, 0.95}
cylinder { <0,-3, 3>,<0.4,-5, 1>, 0.7, 0.95}

// *** main
cylinder { <0.5,-5, -1.0>,<1.5,-5,-1.0>,0.45,0.8 }
cylinder { <1.5,-5, -1.0>,<2.2,-5,-1.0>,0.35,0.8 }
cylinder { <0.5,-5, -1.0>,<1.5,-5,-1.5>,0.45,0.8 }
cylinder { <1.5,-5, -1.5>,<2.2,-5,-1.5>,0.35,0.8 }
cylinder { <0.5,-5, -1.0>,<1.5,-5,-2.2>,0.45,0.8 }
cylinder { <1.5,-5, -2.2>,<2.2,-5,-2.8>,0.35,0.8 }
cylinder { <0.4,-5,  1.0>,<1.4,-5, 1.0>,0.45,0.8 }
cylinder { <1.5,-5,  1.0>,<2.2,-5, 1.0>,0.35,0.8 }
cylinder { <0.4,-5,  1.0>,<1.4,-5, 1.5>,0.45,0.8 }
cylinder { <1.5,-5,  1.5>,<2.2,-5, 1.8>,0.35,0.8 }
cylinder { <0.4,-5,  1.0>,<1.4,-5, 2.2>,0.45,0.8 }
cylinder { <1.5,-5,  2.2>,<2.2,-5, 2.8>,0.35,0.8 }



//Pattes Arriere
cylinder { <-5,-4,-1>,<-2, 0,-3>, 0.9, 0.95}
cylinder { <-2, 0,-3>,<-2,-5,-3>, 0.7, 0.95}

cylinder { <-5,-4, 1>,<-2, 0, 3>, 0.9, 0.95}
cylinder { <-2, 0, 3>,<-2,-5, 3>, 0.7, 0.95}

//Pieds
cylinder { < -2,-5, -3.0>,<1.0,-5,-4.0>,0.45,0.8 }
cylinder { <1.0,-5, -4.0>,<2.2,-5,-4.2>,0.35,0.8 }
cylinder { < -2,-5, -3.0>,<1.0,-5,-4.5>,0.45,0.8 }
cylinder { <1.0,-5, -4.5>,<2.2,-5,-4.7>,0.35,0.8 }
cylinder { < -2,-5, -3.0>,<1.0,-5,-5.0>,0.45,0.8 }
cylinder { <1.0,-5, -5.0>,<2.2,-5,-5.8>,0.35,0.8 }

cylinder { < -2,-5,  3.0>,<1.0,-5, 4.0>,0.45,0.8 }
cylinder { <1.0,-5,  4.0>,<2.2,-5, 4.2>,0.35,0.8 }
cylinder { < -2,-5,  3.0>,<1.0,-5, 4.5>,0.45,0.8 }
cylinder { <1.0,-5,  4.5>,<2.2,-5, 4.7>,0.35,0.8 }
cylinder { < -2,-5,  3.0>,<1.0,-5, 5.0>,0.45,0.8 }
cylinder { <1.0,-5,  5.0>,<2.2,-5, 5.6>,0.35,0.8 }
 texture {GrenouilleTex }

rotate y*45
sturm
}
}

#declare Grenouille2=
union {
// tte et corps
blob {
     threshold 0.6
// *** Tete
sphere { <0.0,   0,0>,1.5,4  scale <1.5,1,1.5> }
// *** bouche
sphere { <0.5,   0,0>,1.5,2  scale <1.5,0.4,1.5> texture {LipsTex }}
sphere { <0.5,-0.5,0>,1.5,2  scale <1.5,0.4,1.5> texture {LipsTex }}
// *** Yeux
sphere { <0.9,0.9,-1.0>,1,0.8  texture {YeuxBleuTex  } }
sphere { <0.9,0.9, 1.0>,1,0.8  texture {YeuxBleuTex  } }
// *** Corps
sphere {<-1.8,-1.1,0>,3 ,3 scale <1.5,0.9,0.5> rotate z*20}
sphere {<-1.8,-1.8,0>,3 ,3 scale <1.5,0.9,1> rotate z*20}

// *** pattes avant
cylinder { <-1,0.8,-0>,<0,-3,-3>, 0.7, 0.95}
cylinder { <0,-3,-3>,<0.5,-5,-1>, 0.7, 0.95}

cylinder { <-1,0.8,0>,<0,-3, 3>, 0.7, 0.95}
cylinder { <0,-3, 3>,<0.4,-5, 1>, 0.7, 0.95}

// *** main
cylinder { <0.5,-5, -1.0>,<1.5,-5,-1.0>,0.45,0.8 }
cylinder { <1.5,-5, -1.0>,<2.2,-5,-1.0>,0.35,0.8 }
cylinder { <0.5,-5, -1.0>,<1.5,-5,-1.5>,0.45,0.8 }
cylinder { <1.5,-5, -1.5>,<2.2,-5,-1.5>,0.35,0.8 }
cylinder { <0.5,-5, -1.0>,<1.5,-5,-2.2>,0.45,0.8 }
cylinder { <1.5,-5, -2.2>,<2.2,-5,-2.8>,0.35,0.8 }
cylinder { <0.4,-5,  1.0>,<1.4,-5, 1.0>,0.45,0.8 }
cylinder { <1.5,-5,  1.0>,<2.2,-5, 1.0>,0.35,0.8 }
cylinder { <0.4,-5,  1.0>,<1.4,-5, 1.5>,0.45,0.8 }
cylinder { <1.5,-5,  1.5>,<2.2,-5, 1.8>,0.35,0.8 }
cylinder { <0.4,-5,  1.0>,<1.4,-5, 2.2>,0.45,0.8 }
cylinder { <1.5,-5,  2.2>,<2.2,-5, 2.8>,0.35,0.8 }



//Pattes Arriere
cylinder { <-5,-4,-1>,<-2, 0,-3>, 0.9, 0.95}
cylinder { <-2, 0,-3>,<-2,-5,-3>, 0.7, 0.95}

cylinder { <-5,-4, 1>,<-2, 0, 3>, 0.9, 0.95}
cylinder { <-2, 0, 3>,<-2,-5, 3>, 0.7, 0.95}

//Pieds
cylinder { < -2,-5, -3.0>,<1.0,-5,-4.0>,0.45,0.8 }
cylinder { <1.0,-5, -4.0>,<2.2,-5,-4.2>,0.35,0.8 }
cylinder { < -2,-5, -3.0>,<1.0,-5,-4.5>,0.45,0.8 }
cylinder { <1.0,-5, -4.5>,<2.2,-5,-4.7>,0.35,0.8 }
cylinder { < -2,-5, -3.0>,<1.0,-5,-5.0>,0.45,0.8 }
cylinder { <1.0,-5, -5.0>,<2.2,-5,-5.8>,0.35,0.8 }

cylinder { < -2,-5,  3.0>,<1.0,-5, 4.0>,0.45,0.8 }
cylinder { <1.0,-5,  4.0>,<2.2,-5, 4.2>,0.35,0.8 }
cylinder { < -2,-5,  3.0>,<1.0,-5, 4.5>,0.45,0.8 }
cylinder { <1.0,-5,  4.5>,<2.2,-5, 4.7>,0.35,0.8 }
cylinder { < -2,-5,  3.0>,<1.0,-5, 5.0>,0.45,0.8 }
cylinder { <1.0,-5,  5.0>,<2.2,-5, 5.6>,0.35,0.8 }
 texture { GrenouilleTex }

rotate y*45
}
}

object { Grenouille2 rotate y*45 translate <9,-4.6,10>}
object { Grenouille }

// *** Nenuphare

#declare Bord=
         difference {
                  cylinder { <0, 0.0,0>,<0,0.90,0>,1.10}
                  cylinder { <0,-0.3,0>,<0,1.22,0>,1.08}
                  box {< -1.5,-0.4,0.5>,<1.5,2.5,-1.5> }
                  rotate  x*10
                  translate <0,0,9>
         }


#declare T=0
#declare BordNph=
merge {
#while (T<360)
object {Bord rotate y*T }
#declare T=T+10
#end
}

#declare Nenuphare=
union {
cylinder { <0,0,0>,<0,0.2,0>,10  texture { NenuphaTex}       }
object  { BordNph texture { NenuphbTex}}
scale <1,1,1>
  // translate <0,-5.3,3>
}
object { Nenuphare  translate <0,-5.3,3> }
object { Nenuphare  translate <1,-5.3,22>}
object { Nenuphare  translate <20,-5.3,14>}
object { Nenuphare  translate <-20,-5.3,14>}
object { Nenuphare  translate <30,-5.3,28>}
object { Nenuphare  translate <20,-5.3,44>}
// *** Mare
plane {
       y, -5.3
       texture {
       pigment {color rgb<0.0,0.2,0.2>}
       normal  {bumps 0.5 scale .8}
       finish {phong 1 reflection .5 ambient 0.1 diffuse 0.2}
     }

}

// *** Ciel mon mari

object {
	sphere {<0,0,0>,5000}
	hollow
	texture {
		pigment {
			gradient y
			color_map {
				[0   	color rgb <0.0,0,0.9>]
                [0.01	color rgb <0,0.3,0.8>]
                [0.09	color rgb <0,0.4,0.9>]
				[1.0	color rgb <0,0.8,0.9>]
			}
			scale <1,5000,1>
		}
	}
    // Nuages
	texture {
		pigment {
			bozo
			turbulence 0.5
			octaves 3
			lambda 6.0
			color_map {
				[0.0 color rgbf <1, 1, 1, 1>]
				[0.8 color rgb <0.737, 0.788, 0.820>]
				[1.0 color rgb <1, 1, 1>]
			}
		}

		finish {
			ambient 1.0
			diffuse 0.0
		}
		scale <3000, 1500, 2000>
	}

}

// Montagnes

#declare ImageMapTxtr = texture {
  finish {
    ambient   0.85
    diffuse   0.85
  }
  pigment {
    image_map {
 gif "lac.gif"  map_type 0
    }
  }
}

  height_field {
 gif  "lac.gif"
   hierarchy
   smooth
    water_level 0.0
rotate y*0
    texture {
     ImageMapTxtr
      rotate    <90, 0, 0> // Rotation de faon  obtenir une projection suivant l'axe Y
       }

  scale <800,230,800>
//  rotate y*10
   translate <-80,-100,-500>
 no_shadow
}
