
//SeaMonster.inc
//Create Claw--------------------------------------

#declare Claw = union{
#declare Rad = 1
#declare StAngle = 0.25//Increasing gives tighter curve
#declare Inc = 0.15
#declare SDiam = 1
#declare SDiam_inc = 0.01
#declare Count = 0.5

#while (Count <450)
       #declare Angle = radians(StAngle * Count)

            #declare Cox = (Rad + Inc) *(sin(Angle))
            #declare Coy = Rad*(cos(Angle))
            #declare Point = <Cox,Coy,0>

                object{sphere{<0,0,0>,SDiam - SDiam_inc}
                translate Point
                scale <2,1,1>}

            #declare SDiam_inc = SDiam_inc + 0.01
        #declare Count = Count + 5
#end

hollow
}
//---------------------claw2--------------------
#declare Claw2 = union{
#declare Rad = 7
#declare StAngle = 0.25//Increasing gives tighter curve
#declare Inc = 0.15
#declare SDiam = 0.6
#declare SDiam_inc = 0.01
#declare Count = 0.5

#while (Count <250)
       #declare Angle = radians(StAngle * Count)

            #declare Cox = (Rad + Inc) *(sin(Angle))
            #declare Coy = Rad*(cos(Angle))
            #declare Point = <Cox,Coy,0>

                object{sphere{<0,0,0>,SDiam - SDiam_inc
                        }
                        translate Point
                            scale <2,1,1>}

            #declare SDiam_inc = SDiam_inc + 0.01
        #declare Count = Count + 5
#end

hollow
}
//--------------------Head------------------------
#declare Head = union{
#declare Rad = 1
#declare Count = 0
#declare Inc = 0.025
#declare Xpos = 0
#declare Xinc = 0.15

#while (Count <300)

object{sphere{<Xpos,0,0>,Rad}}

#declare Rad = Rad +Inc
#declare Xpos = Xpos + Xinc
#declare Count = Count + 5
#end
}

#declare Eyelid = union{
object{sphere{0,1.7 }
clipped_by { object { plane {y,0} } }}
object{torus{1.7,0.2}}
}


#declare SeaMonHead = union{

object {Claw}

object {Head
rotate y*180
translate<0.1,1,0>
}
}

#declare Sea_monster = union{
object{SeaMonHead scale <1,1.25,1>}
object{SeaMonHead scale <0.8,0.35,0.3>
                  rotate x*180
                  translate<-0.175,-0.25,0>}

object {sphere{0,1.5} texture{Lightening1 finish{phong 2 phong_size 50}} translate<-6.75,1.65,-1> }
object{Eyelid rotate x*210 rotate z*7.5 translate<-6.75,1.5,-1>}
object{Eyelid rotate x*-30 rotate z*-5 translate<-6.75,1.95,-1>}
object{Claw2 rotate y*165 rotate z*-12 translate<-6.75,-3.7,-1.25>}
object{Claw2 rotate y*165 rotate z*-12 translate<-6.75,-3.7,1.25>}
object{torus{0.5,0.25 rotate x*60 translate<0,1.35,-1>}}
//object{cone{<-14,-15,0>,3 <-10,1,0>,2}translate<0.35,0,0>}
}


