
// ------------------------Claw.inc----------------

#declare Claw = union{
#declare Rad = 2
#declare StAngle = 0.35//Increasing gives tighter curve
#declare Inc = 0.005
#declare SDiam = 0.6
#declare SDiam_inc = 0.1
#declare Count = 0.5

#while (Count <250)
       #declare Angle = radians(StAngle * Count)

            #declare Cox = (Rad + Inc) *(sin(Angle))
            #declare Coy = Rad*(cos(Angle))
            #declare Point = <Cox,Coy,0>

                object{sphere{<0,0,0>,SDiam - SDiam_inc
                        }
                        translate Point
                            scale <1.5,1,1>}

            #declare SDiam_inc = SDiam_inc + 0.01
        #declare Count = Count + 5
#end
rotate x*180
}

