#ifndef ( __JGB_TEXTURES__ )
#declare __JGB_TEXTURES__ = true

  #declare Rocky =
    texture
    {
      pigment
      {
        gradient y
        turbulence 0.1
        color_map
        {
          [ 0.0 color rgb <0.6,0.5,0.4> ]
          [ 0.3 color rgb <0.8,0.6,0.4> ]
          [ 0.6 color rgb <0.7,0.6,0.5> ]
          [ 0.7 color rgb <0.6,0.4,0.2> ]
          [ 0.9 color rgb <0.7,0.6,0.5> ]
          [ 1.0 color rgb <0.6,0.5,0.4> ]
        }
        frequency 3
      }
      normal
      {
        average
        normal_map
        {
          [ 0.5 bumps 1.0 turbulence 1.0 frequency 30 ]
          [ 1.0 crackle 0.5 ramp_wave turbulence 0.4 frequency 30 ]
        }
      }
      finish
      {
        specular  0.4
        roughness 0.2
        crand     0.1
      }
    }

  #declare Snowy =
    texture
    {
      pigment { color rgb 1.3 }
      finish
      {
        specular  0.9
        roughness 0.2
        ambient   0.3
      }
    }

  #declare DirtTexture =
    texture
    {
      pigment
      {
        wrinkles
        turbulence 1.0
        color_map
        {
          [ 0.0 color rgb <0.608,0.533,0.388> ]
          [ 0.2 color rgb <0.686,0.616,0.478> ]
          [ 0.5 color rgb <0.686,0.592,0.412> ]
          [ 0.8 color rgb <0.624,0.522,0.322> ]
          [ 1.0 color rgb <0.647,0.588,0.475> ]
        }
      }
      normal
      {
        bumps 1.0 turbulence 1.0 scale 0.01
      }
      finish
      {
        crand 0.2
      }
    }

  #declare GrassySplotches =
    texture
    {
      pigment
      {
        gradient z-x
        turbulence 1.0
        omega 0.707
        color_map
        {
          [ 0.0 color rgbf <0.584,0.859,0.329,0.100> ]
          //[ 0.2 color rgbf 1 ]
          [ 0.5 color rgbf <0.420,0.882,0.290,0.100> ]
          //[ 0.7 color rgbf 1 ]
          //[ 1.0 color rgbf 1 ]
          [ 1.0 color rgbf <0.584,0.859,0.329,0.100> ]
        }
        frequency 0.25
        triangle_wave
      }
      normal { wrinkles 0.6 scale 0.01 turbulence 0.6 }
    }

  #declare ForestSplotches =
    texture
    {
      pigment
      {
        bozo
        turbulence 0.3
        color_map
        {
          [ 0.0 color rgb <0.412,0.592,0.141> ]
          [ 0.4 color rgb <0.412,0.592,0.318> ]
          [ 1.0 color rgb <0.294,0.612,0.067> ]
        }
      }
      normal { bumps 1.0 scale 0.005 turbulence 0.5 }
      finish
      {
        specular 0.2 roughness 0.1
      }
      scale 2
    }

  #declare LowlandsLevelTexture =
    texture
    {
      slope y
      texture_map
      {
        [ 0.5 DirtTexture ]
        [ 0.6 DirtTexture ]
        [ 0.7 GrassySplotches ]
        [ 0.8 ForestSplotches ]
        [ 1.0 ForestSplotches ]
      }
    }

  #declare LowlandsTexture =
    texture
    {
      slope y
      texture_map
      {
        [ 0.5 Rocky ]
        [ 0.7 Rocky ]
        [ 0.8 LowlandsLevelTexture ]
        [ 1.0 LowlandsLevelTexture ]
      }
    }

  #declare HighlandsTexture =
    texture
    {
      slope y
      texture_map
      {
        [ 0.5  Rocky ]
        [ 0.75 Rocky ]
        [ 0.8  Snowy ]
        [ 1.0  Snowy ]
      }
    }

  #declare LandscapeTexture =
    texture
    {
      gradient y
      turbulence 0.3
      texture_map
      {
        [ 0.0 LowlandsTexture scale 0.5 ]
        [ 0.3 LowlandsTexture scale 0.5 ]
        [ 0.6 Rocky ]
        [ 0.7 HighlandsTexture ]
        [ 1.0 HighlandsTexture ]
      }
      scale 1.1
    }

#end
