// Les valeurs par defaut...
#ifndef (cm_location)	#declare cm_location=<0,0,-50>	#end
#ifndef (cm_angle)	#declare cm_angle=20		#end
#ifndef (cm_roll)	#declare cm_roll=0		#end
#ifndef (cm_prop)	#declare cm_prop=<2,1,0>		#end

#ifndef(cm_dir)
   #ifndef (cm_look_at)
      #declare cm_dir=<0,0,1>
      #declare cm_look_at=cm_location+cm_dir
   #else
      #declare cm_dir = ( cm_look_at - cm_location )
   #end
#else
   #ifdef (cm_look_at)
      #warning "\nBoth direction and look at vector are define\n"
      #warning "ignoring look at vector\n"
   #end
   #declare cm_look_at=cm_location+cm_dir
#end

#declare cx=cm_dir.x
#declare cy=cm_dir.y
#declare cz=cm_dir.z
#declare cn = vlength(cm_dir)
#declare cn2 = sqrt(cx*cx+cz*cz)

#if (cn = 0) #error "cm_look_at and cm_location points must be different" #end


#declare ca=atan2(cz,cx)*180/pi
#declare cb=atan2(cy, cn2)*180/pi

// Premiere chose, le roll, c'est autour de x
#declare cm_up=vrotate(<0,cm_prop.y,0>, x*cm_roll)
#declare cm_right=vrotate(<0,0,-cm_prop.x>, x*cm_roll)

// Premiere rotation, autour de z...
#declare cm_dir=vrotate(<cn,0,0>, cb*z)
#declare cm_up=vrotate(cm_up, cb*z)
#declare cm_right=vrotate(cm_right, cb*z)

// Seconde rotation, autour de y...
#declare cm_dir=vrotate(cm_dir, -ca*y)
#declare cm_up=vrotate(cm_up, -ca*y)
#declare cm_right=vrotate(cm_right, -ca*y)

#debug concat("Rotation    : Alpha=", str(ca, 3,1), " - Beta=", str(cb,3,1), "\n")
#debug concat("cm_dir      : (", str(cm_dir.x,3,3), ", ", str(cm_dir.y,3,3), ", ", str(cm_dir.z,3,3), ")\n")
#debug concat("cm_location : (", str(cm_location.x,3,3), ", ", str(cm_location.y,3,3), ", ", str(cm_location.z,3,3), ")\n")


camera {
   location cm_location
   direction cm_dir
   up cm_up
   right cm_right
   angle cm_angle
}
   
