#declare cm_location=<0,1,-30>
#declare cm_dir=<0,0,1>
#declare cm_angle=15
#declare cm_prop=<1,2,0>
#include "camera/Camera.inc"

#declare quickRend=off
#declare blobRend=on
#declare bloodRend=on
#declare spirRend=on

#declare waterTex1=texture {
   pigment {
      rgbt <1,1,1,1>
   }
   
   finish { 
      reflection 0.3
      refraction 0.7
      ior 1.33
      phong 0.5
   }
}

#declare waterTex2=texture {
   pigment {
      rgbt <1,1,1,0.5>
   }
   
   finish { 
      reflection 0.8
      refraction 0.5
      ior 1.33
      phong 0.5
   }
   
   normal {
      bumps 0.5
   }
}

#declare bloodTex=texture {
   pigment { rgb <0.7,0,0> }
   
   finish {
      reflection 0.2
      diffuse 0.8
      phong 1
   }
}

#if (quickRend)
   #declare waterTex1=texture {
      pigment {
	 rgb <1,1,1>
      }
      
      finish { 
	 diffuse 1
	 phong 0.5
      }
      normal {
	 bumps 0.3
	 scale 0.2
      }
   }
   
#end
   
sphere {
   <0,0,0>,
   1
      
      texture {
	 pigment {
	    gradient y
	    color_map {
	       [ 0.0 rgb <1,1,1.0> ]
	       [ 0.25 rgb <0,0.5,1.0> ]
	       [ 1.0 rgb <0,0,1.0> ]
	 }
      }
      
      finish {
	 ambient 1
	 diffuse 0
	 reflection 0
	 refraction 0
      }
   }
   
   no_shadow
   hollow
   
   scale 10000
   translate cm_location
}

light_source {
   <0, 20, -100>
   color <1,1,1>
   
   rotate -y*30
}

#render "\nMasse d'eau !\n"
#declare truc=
  blob {
     // La spirale...
     
     
     #declare ray=0
     #declare ht=-0.5
     #declare ang=0
     #declare rsph=1
     #declare s1=seed(1)
     #declare flotchSeed=seed(4)
      #while (rsph>0)
	 #if (spirRend)
	    // Le gros de la spirale
	    sphere { <0,0,0>, rsph,1 
	       translate x*ray rotate ang*y translate y*ht 
	    }
	    
	    #declare i=0
	    #while (i < 5)
	       // On ajoute des petites merde partout...
	       sphere { <0,0,0>, rsph/(5*(rand(s1)+1)), 1
		  translate x*ray*(1.5+rand(s1)) 
		  rotate ang*(2+rand(s1))*y
		  translate y*ht*(1.1+rand(s1)*0.5) }
	       
	       #declare i=i+1
	    #end
	  
	    
	 #end
	    
	 #declare rsph=rsph-0.005
	 #declare ang = ang + (10*rand(s1)+10)
	 #declare ht = ht + 0.05
	 #declare ray = rand(s1)*2.5
	 
      #end
      
      // Le cone
      #declare htCone=ht/4
      #declare ray=htCone
      #declare ht=0
      #while ( ray > 0 )
	 #declare ang=0
	 #while (ang < 360)
	    #declare rsph=rand(s1)*0.5+0.5
	    #if (spirRend)
	       sphere { <0,0,0>, rsph, 1
		  translate x*ray rotate (ang+rand(s1)*30)*y translate y*ht

	       }
	       // On ajoute des petites merde partout...
	       sphere { <0,0,0>, rsph/5, 1
		  translate x*ray*(1.5+rand(s1)) 
		  rotate ang*(2+rand(s1))*y
		  translate y*ht*(1.1+rand(s1)*0.5) }
	    #end
	    
	    #declare ang=ang+30
	 #end
	 #declare ray=ray-0.05
	 #declare ht=ht-0.05
      #end

      #declare htBlob=ht
      
  /*    // Les blood drips
      #declare htDrop=-htBlob/20
      #declare ang=0
      #while (ang < 360)
      #declare ht=0.1
      #declare ray=rand(s1)*htCone
	 
      #while (ht < -htBlob*2-rand(s1)*htBlob)
	 #declare rsph=rand(s1)*ht/40+ht/40
	 sphere {
	    <0,0,0>, rsph, 0.5
	    scale <0.5,2.5,0.5>
	    translate ray*x
	    rotate y*ang
	    translate -y*ht
	    texture { pigment { rgb <1,0,0> } }
	 }
	 // #declare ht=ht+rand(s1)*htDrop/2+htDrop/2+0.05
	 #declare ht=ht+rsph
      #end
      #declare ang=ang+rand(s1)*30
      #end */
     
     texture { waterTex1 }
     
     
     // cylinder { <0, 0, 0>, <0, -ht/8, 0>, ht/4 }
     // sphere { <0,0, 0>, ht/4 scale <1,0.5,1> translate -y*ht/8 }
     
     translate -y*(htBlob/4)
     
     
} // Truc


#render "\nLes Gouttes de sang et leur flottch\n"
#declare flotchRay=2
#declare flotchHtVar=0.25
#declare flotchAngVar=45
#declare flotchRayVar=0.1
#declare flotchBaseEp=0.5
#declare flotchBlob=true
#declare flotchSeed=seed(12)
#declare flotchTex=texture { bloodTex }

#if (bloodRend)
   // Les blood drips
   #declare htDrop=-htBlob/20
   #declare ang=0
   #while (ang < 360)
      #declare ht=0.1
      #declare ray=rand(s1)*htCone
      
      union {
	 #include "Flotch.inc"
	 object {
	    flotch
	    scale 0.3
	    translate y*htBlob*2
	    // texture { bloodTex }
	 }
	 
	 blob {
	    #while (ht < -htBlob*2-rand(s1)*htBlob)
	       #declare rsph=rand(s1)*ht/40+ht/40
	       sphere {
		  <0,0,0>, rsph, 0.5
		  scale <0.5,2.5,0.5>
		  translate -y*ht
	       }
	       // #declare ht=ht+rand(s1)*htDrop/2+htDrop/2+0.05
	       #declare ht=ht+rsph
	    #end
	 }
	 
	texture { bloodTex }
	 no_shadow
	
	 translate ray*x
	 rotate y*ang
      }
      #declare ang=ang+rand(s1)*30
   #end
#end
   
#if (blobRend=on)
   object { truc no_shadow }
#end

merge {
   plane { 
      <0,1,0>, htBlob*2
      
      texture { waterTex2 }
      
      hollow
      no_shadow
   }
   
   height_field {
      tga "flaque.tga"
      smooth
      water_level 0.06
      
      translate <-0.5,0,-0.5>
      
      scale <10,1,15>
      
      texture { bloodTex }
      
      scale <1,0.1,1>
      translate y*htBlob*2.01
   }
}
      

fog {
   fog_type 2	// Ground Fog
   distance 1000
   color <1,1,1>
   turbulence 1
   fog_offset 0
   fog_alt -htBlob
}
