
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: butterflies flying towards the sun
// Date: Jun 28 1998
// Auth: Micha Riser (mriser@usa.net)
//       http://www.geocities.com/SilcionValley/Pines/7992/
// visit my POVRay Objects Collection at http://thor.prohosting.com/~mriser


#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "skies.inc"

camera
{
  location  <0.0 , 4.0 ,-5.0>
  look_at   <0.05 , 2.9 , 0.0>
  angle 60
}

light_source
{
  0*x 
  color rgb<1,0.4,0>*2  
  translate <-170,50,1000>*10
}

sphere{0,1  //--- sun


pigment{ gradient y
pigment_map
 {[0 rgb<1,0.25,0>]
  [1 rgb<1,0.6,0>]
   }
   scale 2
   translate<0,-1,0>
}

scale 550
translate <-170,75,1000>*10

finish{ambient 1} no_shadow}

plane{ y,0  translate <0,0.03,0> pigment{rgb<0.1,0.1,0.4>*1.3}  //-- the sea
 finish{reflection 0.75 roughness 0.25 specular 0.25} normal{bumps 0.5 scale<1.5,.5,.5>*0.3}
 }


#declare fluegel=box{<0,0,0>,<1,1,0>  //-- wing
 pigment{
  image_map{
   gif "sf1.gif"
   filter 0,1
   }
   }
   finish{ambient 0.75}
   finish{diffuse 2}
   scale <0.5596,1,1>
   translate<-0.5796,0,0>
 }

#declare butterfly_body=union{
sphere{0,0.1
  scale<0.35,1.45,0.35>
  translate<0,0.4,0>
  }
sphere{0,0.1
  scale<0.39,1,0.39>
  translate<0,0.54,0>
  }

sphere{0,0.09
  scale<0.18,0.5,0.18>
  translate<0,0.63,0>
  }

cylinder{<0.007,0.65,-0.005>,<0.07,0.77,-0.075>,0.003
 }

cylinder{<-0.007,0.65,-0.005>,<-0.07,0.77,-0.075>,0.003
 }
sphere{<-0.07,0.77,-0.075>,0.008 }
sphere{<0.07,0.77,-0.075>,0.008 }
pigment{Brown}
finish{ambient 0.2 diffuse 1}
}


#declare butterfly_eyes=union{
sphere{0,0.01
  scale 1
  translate<0.013,0.648,-0.0095>
  }

sphere{0,0.01
  scale 1
  translate<-0.013,0.648,-0.0095>
  }
 pigment{rgb<0.2,0.2,0.2>}
  finish{ roughness 0.05 specular 0.2}
}

#declare za=0
#declare r=seed(94)//770)

#while (za<150)
#declare za=za+1

#if (za<4 | za=9 | za=10 | za=11 | za=13 | za=16 | za=17 | za=20
     | za=22 | za=24 | za=21 |za=27 | za=32 | za=34 |za=37
     | za=43 | za=49 | za=47 |za=48 | za=55 |za=64 | za=67
     | za=76 | za=74 | za=84 |za=90 | za=95 | za=97 | za=100
     | za=102 |za=126
     |za >150)

 union{  //-- putting the butterflies together
  #declare fluegelwinkel=rand(r)*60+5
  object{butterfly_body}
  object{butterfly_eyes}
  object{fluegel rotate y*-fluegelwinkel}
  object{fluegel rotate y*180 rotate y*fluegelwinkel}
  rotate x*(80+rand(r)*15)
  scale 1
  rotate y*(-10-rand(r)*10)
  #declare position=<rand(r)*7-3.5,.5+rand(r)*3.5,rand(r)*4-1>
  translate position
 }

 #else
 #declare uber=rand(r)+rand(r)+rand(r)+rand(r)+rand(r)+rand(r)


 #end
#end

sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb<1,144/255,65/255>]//rgb <0.847, 0.749, 0.847> ] // horizon
            [0.35 P_Cloud2 scale 0.25 rotate z*5]
            [0.60 P_Cloud3 scale <0.25, 0.15, 0.25> rotate z*10]
        }
        translate<3.13,0,0>
    }
}


height_field  //-- island in the background
{
  gif
  "huegel.gif"
  scale <800,13,100>
  translate <-330,-5,800>
  pigment{Brown}
  smooth
}

