
// Persistence of Vision Ray Tracer Scene Description File
// File: mr_frog.pov
// Vers: 3.02
// Desc: my image for the IRTC (subject nature)
// Date: 25-08-98
// Auth: M.J.Reuvers

//  Contains 3 lights, 38 textures and 1180 primitives.
//
//  This file was generated for POV-Ray V3.0 by Moray V3.0



global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-12.538, 4.469, -4.803>
  direction <0.0,     0.0,  0.7945>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-19.168, -3.585, -4.707>
}


// *******  L I G H T S *******
//

light_source {   // Light001
  <-22.133, -5.936, 48.458>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Spotlight SpotLite001
  <-12.867, 4.090, -4.754>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-13.493, 3.311, -4.801>
    falloff   34.82  // outer radius (in deg)
      radius    34.82  // inner radius
}

light_source {   // Light1
  <-25.571, -0.989, 48.496>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  INCLUDE FILES  *******
//
#include "colors.inc"
#include "stones.inc"
#include "mr_frog.inc"



//
// ********  OBJECTS  *******
//
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.2 color blue 0.4] [1.0 color rgb 1] }
  }
}


#declare BezPtch188 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.216685, 0.009011, -2.257436>, <3.216066, -0.133072, -2.254861>, <3.216436, -0.138223, -2.432283>, <3.217055, 0.003861, -2.434858>,
      <3.937827, 0.025414, -1.229621>, <3.937208, -0.116669, -1.227046>, <3.937578, -0.121820, -1.404468>, <3.938197, 0.020264, -1.407043>,
      <5.269569, 0.016705, -0.026609>, <5.268950, -0.125377, -0.024035>, <5.269320, -0.130528, -0.201456>, <5.269939, 0.011555, -0.204031>,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.217055, 0.003861, -2.434858>, <3.217673, 0.145944, -2.437432>, <3.217303, 0.151094, -2.260010>, <3.216685, 0.009011, -2.257436>,
      <3.938197, 0.020264, -1.407043>, <3.938816, 0.162347, -1.409617>, <3.938445, 0.167497, -1.232195>, <3.937827, 0.025414, -1.229621>,
      <5.269939, 0.011555, -0.204031>, <5.270557, 0.153639, -0.206605>, <5.270187, 0.158788, -0.029184>, <5.269569, 0.016705, -0.026609>,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>,
      <7.999804, 0.009010, 0.073990>, <7.999804, -0.133074, 0.076564>, <8.000196, -0.138223, -0.100858>, <8.000196, 0.003862, -0.103432>,
      <9.991770, -0.043210, 0.074171>, <9.999804, -0.133074, 0.076745>, <10.000196, -0.138223, -0.100677>, <9.992162, -0.048359, -0.103251>,
      <12.022759, -0.005525, 0.074352>, <12.030813, -0.017016, 0.076927>, <12.031207, -0.017674, -0.100495>, <12.023152, -0.006183, -0.103070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>,
      <8.000196, 0.003862, -0.103432>, <8.000196, 0.145946, -0.106007>, <7.999804, 0.151094, 0.071415>, <7.999804, 0.009010, 0.073990>,
      <9.992162, -0.048359, -0.103251>, <9.984128, 0.041506, -0.105825>, <9.983736, 0.046654, 0.071596>, <9.991770, -0.043210, 0.074171>,
      <12.023152, -0.006183, -0.103070>, <12.015098, 0.005307, -0.105644>, <12.014704, 0.005965, 0.071778>, <12.022759, -0.005525, 0.074352>
    }
  }
  translate  <-7.547783, -0.005938, -0.02014>
}
#declare BezPtch189 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  translate  0.688547*x
}
#declare BezPtch190 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  translate  <1.932764, 0.0, 0.02416>
}
#declare BezPtch191 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  translate  <3.019945, 0.0, 0.0>
}
#declare BezPtch192 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate 18.008755*y
  translate  <3.998407, 0.0, 0.0>
}
#declare BezPtch193 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  translate  <3.418577, 0.0, 0.01208>
}
#declare BezPtch194 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate 4.213355*y
  translate  <3.756811, 0.0, 0.048319>
}
#declare BezPtch195 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  translate  <1.340855, 0.0, 0.036239>
}
#declare BezPtch196 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate 64.398323*y
  translate  <4.433279, 0.0, 0.01208>
}
#declare BezPtch197 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate 37.852127*y
  translate  <4.203763, 0.0, 0.02416>
}
#declare BezPtch198 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  translate  <2.524674, 0.0, 0.0>
}
#declare BezPtch199 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
}
#declare BezPtch200 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <-0.0, -9.919693, 0.0>
  translate  <-0.363724, 0.0, 0.03031>
}
#declare BezPtch201 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <-0.0, -16.600996, 0.0>
  translate  <-0.757758, -0.0, -0.060621>
}
#declare bladhelft12 = union {
  object { BezPtch189 }
  object { BezPtch190 }
  object { BezPtch191 }
  object { BezPtch192 }
  object { BezPtch193 }
  object { BezPtch194 }
  object { BezPtch195 }
  object { BezPtch196 }
  object { BezPtch197 }
  object { BezPtch198 }
  object { BezPtch199 }
  object { BezPtch200 }
  object { BezPtch201 }
  rotate 90.0*x
}
#declare BezPtch202 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <90.0, 0.0, -180.0>
  translate  <1.343798, -0.015998, 0.0>
}
#declare BezPtch203 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  rotate <90.0, 0.0, -180.0>
  translate  <1.93571, -0.047993, 0.0>
}
#declare BezPtch204 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  rotate <90.0, 0.0, -180.0>
  translate  <2.991551, -0.095986, 0.0>
}
#declare BezPtch205 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  rotate <90.0, 0.0, -180.0>
  translate  <3.425209, -0.04556, 0.0>
}
#declare BezPtch206 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate <90.0, -0.0, 162.731384>
  translate  <4.000057, 0.01495, 0.0>
}
#declare BezPtch207 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate <90.0, -0.0, 143.62674>
  translate  <4.4438, -0.015305, 0.0>
}
#declare BezPtch208 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -180.0>
  translate  <0.712683, -0.096309, 0.0>
}
#declare BezPtch209 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate <90.0, 0.0, -180.0>
  translate  <3.758016, -0.035475, 0.0>
}
#declare BezPtch210 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate <90.0, -0.0, 158.457932>
  translate  <4.211844, -0.015305, 0.0>
}
#declare BezPtch211 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  rotate <90.0, 0.0, -180.0>
  translate  <2.511623, 0.015998, 0.0>
}
#declare BezPtch212 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  rotate <90.0, 0.0, -180.0>
  translate  -0.038523*y
}
#declare BezPtch213 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -170.391083>
  translate  <-0.363724, 0.022097, 0.0>
}
#declare BezPtch214 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale <0.8, 0.8, 0.78>
  rotate <90.0, 0.0, -162.149979>
  translate  <-0.757758, 0.022097, 0.0>
}
#declare bladhelft13 = union {
  object { BezPtch202 }
  object { BezPtch203 }
  object { BezPtch204 }
  object { BezPtch205 }
  object { BezPtch206 }
  object { BezPtch207 }
  object { BezPtch208 }
  object { BezPtch209 }
  object { BezPtch210 }
  object { BezPtch211 }
  object { BezPtch212 }
  object { BezPtch213 }
  object { BezPtch214 }
}
#declare blad30 = union {
  object { bladhelft12 }
  object { bladhelft13 }
}
#declare stengel12 = union {
  object { BezPtch188 }
  object { blad30 }
  texture {
    Texture1_1
  }
  rotate -39.233891*y
  translate  <1.444903, 0.0, 3.34609>
}
#declare BezPtch215 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.216685, 0.009011, -2.257436>, <3.216066, -0.133072, -2.254861>, <3.216436, -0.138223, -2.432283>, <3.217055, 0.003861, -2.434858>,
      <3.937827, 0.025414, -1.229621>, <3.937208, -0.116669, -1.227046>, <3.937578, -0.121820, -1.404468>, <3.938197, 0.020264, -1.407043>,
      <5.269569, 0.016705, -0.026609>, <5.268950, -0.125377, -0.024035>, <5.269320, -0.130528, -0.201456>, <5.269939, 0.011555, -0.204031>,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.217055, 0.003861, -2.434858>, <3.217673, 0.145944, -2.437432>, <3.217303, 0.151094, -2.260010>, <3.216685, 0.009011, -2.257436>,
      <3.938197, 0.020264, -1.407043>, <3.938816, 0.162347, -1.409617>, <3.938445, 0.167497, -1.232195>, <3.937827, 0.025414, -1.229621>,
      <5.269939, 0.011555, -0.204031>, <5.270557, 0.153639, -0.206605>, <5.270187, 0.158788, -0.029184>, <5.269569, 0.016705, -0.026609>,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>,
      <7.999804, 0.009010, 0.073990>, <7.999804, -0.133074, 0.076564>, <8.000196, -0.138223, -0.100858>, <8.000196, 0.003862, -0.103432>,
      <9.991770, -0.043210, 0.074171>, <9.999804, -0.133074, 0.076745>, <10.000196, -0.138223, -0.100677>, <9.992162, -0.048359, -0.103251>,
      <12.022759, -0.005525, 0.074352>, <12.030813, -0.017016, 0.076927>, <12.031207, -0.017674, -0.100495>, <12.023152, -0.006183, -0.103070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>,
      <8.000196, 0.003862, -0.103432>, <8.000196, 0.145946, -0.106007>, <7.999804, 0.151094, 0.071415>, <7.999804, 0.009010, 0.073990>,
      <9.992162, -0.048359, -0.103251>, <9.984128, 0.041506, -0.105825>, <9.983736, 0.046654, 0.071596>, <9.991770, -0.043210, 0.074171>,
      <12.023152, -0.006183, -0.103070>, <12.015098, 0.005307, -0.105644>, <12.014704, 0.005965, 0.071778>, <12.022759, -0.005525, 0.074352>
    }
  }
  translate  <-7.547783, -0.005938, -0.02014>
}
#declare BezPtch216 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  translate  0.688547*x
}
#declare BezPtch217 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  translate  <1.932764, 0.0, 0.02416>
}
#declare BezPtch218 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  translate  <3.019945, 0.0, 0.0>
}
#declare BezPtch219 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate 18.008755*y
  translate  <3.998407, 0.0, 0.0>
}
#declare BezPtch220 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  translate  <3.418577, 0.0, 0.01208>
}
#declare BezPtch221 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate 4.213355*y
  translate  <3.756811, 0.0, 0.048319>
}
#declare BezPtch222 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  translate  <1.340855, 0.0, 0.036239>
}
#declare BezPtch223 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate 64.398323*y
  translate  <4.433279, 0.0, 0.01208>
}
#declare BezPtch224 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate 37.852127*y
  translate  <4.203763, 0.0, 0.02416>
}
#declare BezPtch225 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  translate  <2.524674, 0.0, 0.0>
}
#declare BezPtch226 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
}
#declare BezPtch227 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <-0.0, -9.919693, 0.0>
  translate  <-0.363724, 0.0, 0.03031>
}
#declare BezPtch228 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <-0.0, -16.600996, 0.0>
  translate  <-0.757758, -0.0, -0.060621>
}
#declare bladhelft14 = union {
  object { BezPtch216 }
  object { BezPtch217 }
  object { BezPtch218 }
  object { BezPtch219 }
  object { BezPtch220 }
  object { BezPtch221 }
  object { BezPtch222 }
  object { BezPtch223 }
  object { BezPtch224 }
  object { BezPtch225 }
  object { BezPtch226 }
  object { BezPtch227 }
  object { BezPtch228 }
  rotate 90.0*x
}
#declare BezPtch229 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <90.0, 0.0, -180.0>
  translate  <1.343798, -0.015998, 0.0>
}
#declare BezPtch230 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  rotate <90.0, 0.0, -180.0>
  translate  <1.93571, -0.047993, 0.0>
}
#declare BezPtch231 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  rotate <90.0, 0.0, -180.0>
  translate  <2.991551, -0.095986, 0.0>
}
#declare BezPtch232 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  rotate <90.0, 0.0, -180.0>
  translate  <3.425209, -0.04556, 0.0>
}
#declare BezPtch233 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate <90.0, -0.0, 162.731384>
  translate  <4.000057, 0.01495, 0.0>
}
#declare BezPtch234 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate <90.0, -0.0, 143.62674>
  translate  <4.4438, -0.015305, 0.0>
}
#declare BezPtch235 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -180.0>
  translate  <0.712683, -0.096309, 0.0>
}
#declare BezPtch236 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate <90.0, 0.0, -180.0>
  translate  <3.758016, -0.035475, 0.0>
}
#declare BezPtch237 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate <90.0, -0.0, 158.457932>
  translate  <4.211844, -0.015305, 0.0>
}
#declare BezPtch238 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  rotate <90.0, 0.0, -180.0>
  translate  <2.511623, 0.015998, 0.0>
}
#declare BezPtch239 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  rotate <90.0, 0.0, -180.0>
  translate  -0.038523*y
}
#declare BezPtch240 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -170.391083>
  translate  <-0.363724, 0.022097, 0.0>
}
#declare BezPtch241 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale <0.8, 0.8, 0.78>
  rotate <90.0, 0.0, -162.149979>
  translate  <-0.757758, 0.022097, 0.0>
}
#declare bladhelft15 = union {
  object { BezPtch229 }
  object { BezPtch230 }
  object { BezPtch231 }
  object { BezPtch232 }
  object { BezPtch233 }
  object { BezPtch234 }
  object { BezPtch235 }
  object { BezPtch236 }
  object { BezPtch237 }
  object { BezPtch238 }
  object { BezPtch239 }
  object { BezPtch240 }
  object { BezPtch241 }
}
#declare blad31 = union {
  object { bladhelft14 }
  object { bladhelft15 }
}
#declare stengel13 = union {
  object { BezPtch215 }
  object { blad31 }
  texture {
    Texture1_1
  }
  scale 0.9
  rotate <-0.0, -39.233891, 137.29274>
  translate  <-1.688238, 1.187311, 2.985795>
}
#declare BezPtch242 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.216685, 0.009011, -2.257436>, <3.216066, -0.133072, -2.254861>, <3.216436, -0.138223, -2.432283>, <3.217055, 0.003861, -2.434858>,
      <3.937827, 0.025414, -1.229621>, <3.937208, -0.116669, -1.227046>, <3.937578, -0.121820, -1.404468>, <3.938197, 0.020264, -1.407043>,
      <5.269569, 0.016705, -0.026609>, <5.268950, -0.125377, -0.024035>, <5.269320, -0.130528, -0.201456>, <5.269939, 0.011555, -0.204031>,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.217055, 0.003861, -2.434858>, <3.217673, 0.145944, -2.437432>, <3.217303, 0.151094, -2.260010>, <3.216685, 0.009011, -2.257436>,
      <3.938197, 0.020264, -1.407043>, <3.938816, 0.162347, -1.409617>, <3.938445, 0.167497, -1.232195>, <3.937827, 0.025414, -1.229621>,
      <5.269939, 0.011555, -0.204031>, <5.270557, 0.153639, -0.206605>, <5.270187, 0.158788, -0.029184>, <5.269569, 0.016705, -0.026609>,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>,
      <7.999804, 0.009010, 0.073990>, <7.999804, -0.133074, 0.076564>, <8.000196, -0.138223, -0.100858>, <8.000196, 0.003862, -0.103432>,
      <9.991770, -0.043210, 0.074171>, <9.999804, -0.133074, 0.076745>, <10.000196, -0.138223, -0.100677>, <9.992162, -0.048359, -0.103251>,
      <12.022759, -0.005525, 0.074352>, <12.030813, -0.017016, 0.076927>, <12.031207, -0.017674, -0.100495>, <12.023152, -0.006183, -0.103070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>,
      <8.000196, 0.003862, -0.103432>, <8.000196, 0.145946, -0.106007>, <7.999804, 0.151094, 0.071415>, <7.999804, 0.009010, 0.073990>,
      <9.992162, -0.048359, -0.103251>, <9.984128, 0.041506, -0.105825>, <9.983736, 0.046654, 0.071596>, <9.991770, -0.043210, 0.074171>,
      <12.023152, -0.006183, -0.103070>, <12.015098, 0.005307, -0.105644>, <12.014704, 0.005965, 0.071778>, <12.022759, -0.005525, 0.074352>
    }
  }
  translate  <-7.547783, -0.005938, -0.02014>
}
#declare BezPtch243 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  translate  0.688547*x
}
#declare BezPtch244 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  translate  <1.932764, 0.0, 0.02416>
}
#declare BezPtch245 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  translate  <3.019945, 0.0, 0.0>
}
#declare BezPtch246 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate 18.008755*y
  translate  <3.998407, 0.0, 0.0>
}
#declare BezPtch247 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  translate  <3.418577, 0.0, 0.01208>
}
#declare BezPtch248 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate 4.213355*y
  translate  <3.756811, 0.0, 0.048319>
}
#declare BezPtch249 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  translate  <1.340855, 0.0, 0.036239>
}
#declare BezPtch250 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate 64.398323*y
  translate  <4.433279, 0.0, 0.01208>
}
#declare BezPtch251 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate 37.852127*y
  translate  <4.203763, 0.0, 0.02416>
}
#declare BezPtch252 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  translate  <2.524674, 0.0, 0.0>
}
#declare BezPtch253 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
}
#declare BezPtch254 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <-0.0, -9.919693, 0.0>
  translate  <-0.363724, 0.0, 0.03031>
}
#declare BezPtch255 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <-0.0, -16.600996, 0.0>
  translate  <-0.757758, -0.0, -0.060621>
}
#declare bladhelft16 = union {
  object { BezPtch243 }
  object { BezPtch244 }
  object { BezPtch245 }
  object { BezPtch246 }
  object { BezPtch247 }
  object { BezPtch248 }
  object { BezPtch249 }
  object { BezPtch250 }
  object { BezPtch251 }
  object { BezPtch252 }
  object { BezPtch253 }
  object { BezPtch254 }
  object { BezPtch255 }
  rotate 90.0*x
}
#declare BezPtch256 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <90.0, 0.0, -180.0>
  translate  <1.343798, -0.015998, 0.0>
}
#declare BezPtch257 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  rotate <90.0, 0.0, -180.0>
  translate  <1.93571, -0.047993, 0.0>
}
#declare BezPtch258 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  rotate <90.0, 0.0, -180.0>
  translate  <2.991551, -0.095986, 0.0>
}
#declare BezPtch259 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  rotate <90.0, 0.0, -180.0>
  translate  <3.425209, -0.04556, 0.0>
}
#declare BezPtch260 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate <90.0, -0.0, 162.731384>
  translate  <4.000057, 0.01495, 0.0>
}
#declare BezPtch261 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate <90.0, -0.0, 143.62674>
  translate  <4.4438, -0.015305, 0.0>
}
#declare BezPtch262 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -180.0>
  translate  <0.712683, -0.096309, 0.0>
}
#declare BezPtch263 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate <90.0, 0.0, -180.0>
  translate  <3.758016, -0.035475, 0.0>
}
#declare BezPtch264 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate <90.0, -0.0, 158.457932>
  translate  <4.211844, -0.015305, 0.0>
}
#declare BezPtch265 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  rotate <90.0, 0.0, -180.0>
  translate  <2.511623, 0.015998, 0.0>
}
#declare BezPtch266 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  rotate <90.0, 0.0, -180.0>
  translate  -0.038523*y
}
#declare BezPtch267 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -170.391083>
  translate  <-0.363724, 0.022097, 0.0>
}
#declare BezPtch268 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale <0.8, 0.8, 0.78>
  rotate <90.0, 0.0, -162.149979>
  translate  <-0.757758, 0.022097, 0.0>
}
#declare bladhelft17 = union {
  object { BezPtch256 }
  object { BezPtch257 }
  object { BezPtch258 }
  object { BezPtch259 }
  object { BezPtch260 }
  object { BezPtch261 }
  object { BezPtch262 }
  object { BezPtch263 }
  object { BezPtch264 }
  object { BezPtch265 }
  object { BezPtch266 }
  object { BezPtch267 }
  object { BezPtch268 }
}
#declare blad32 = union {
  object { bladhelft16 }
  object { bladhelft17 }
}
#declare stengel14 = union {
  object { BezPtch242 }
  object { blad32 }
  texture {
    Texture2_1
  }
  scale 0.7
  rotate <0.0, -39.233891, -104.827202>
  translate  <-0.797636, -1.254474, 1.980476>
}
union { // varen2
  object { stengel12 }
  object { stengel13 }
  object { stengel14 }
  rotate <5.49159, 5.445736, -144.977707>
  translate  <-20.574137, -21.314081, -5.140283>
}






sphere { // lelie
  <0,0,0>,1
  texture {
    Green_Vein_Pistachio_Plastic
  }
  scale <5.0, 5.0, 0.2>
  rotate 0.225502*x
  translate  <-18.275711, -4.610329, -8.125445>
}


plane { // water
  z,0
  texture {
     pigment { Turquoise }
   normal {  	waves 0.1
      			frequency 6000
      			scale 10 }
   		finish {	ambient 0.1
      				diffuse 0.1
      				reflection 0.8
  } }
  scale <40.0, 20.0, 1.0>
  translate  <-39.881638, -3.143524, -8.098159>
}

object {   // land
  height_field {
    tga "C:\Mijn documenten\Mofiles\heightmaps\water.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    mountainMrock
  }
  scale <400.0, 200.0, 42.0>
  translate  <-106.008056, -26.252412, 25.023258>
}




#declare blad1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>,
      <-5.911110, 0.301031, 6.018708>, <-5.907548, -1.677396, 6.022361>, <-5.708263, -1.636578, 6.226686>, <-5.711826, 0.341851, 6.223033>,
      <-7.502055, 0.301031, 7.873211>, <-7.498420, -1.677396, 7.876791>, <-7.295101, -1.636578, 8.077102>, <-7.298736, 0.341851, 8.073521>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>,
      <-5.711826, 0.341851, 6.223033>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 0.301031, 6.018708>,
      <-7.298736, 0.341851, 8.073521>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 0.301031, 7.873211>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_1
  }
  scale <1.0, 0.5, 1.0>
  translate  <-1.21971, -0.189983, -10.919306>
}
#declare Group2 = union {
  sphere { // Sphere10
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere11
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere12
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere13
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere14
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere15
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere16
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere17
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture2_2
  }
}
#declare Group001 = union {
  sphere { // Sphere9
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere8
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere7
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere6
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere5
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  object { Group2 }
  texture {
    Texture2_2
  }
}
#declare Group3 = union {
  sphere { // Sphere18
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere19
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere20
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere21
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere22
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere23
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere24
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere25
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture2_2
  }
  rotate -20.0*z
}
#declare bloemkop = union {
  object { Group001 }
  sphere { // knop
    <0,0,0>,1
    texture {
      Texture3_1
    }
    scale <1.2, 1.2, 0.2>
    translate  <0.035568, 0.0, -0.556193>
  }
  object { Group3 }
  rotate 90.0*y
}
#declare blad3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.462065, 0.301031, 1.206538>, <-3.457852, -1.677396, 1.209135>, <-3.222154, -1.636578, 1.354364>, <-3.226368, 0.341851, 1.351767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-3.226368, 0.341851, 1.351767>, <-3.230581, 2.320280, 1.349171>, <-3.466279, 2.279458, 1.203942>, <-3.462065, 0.301031, 1.206538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.462065, 0.301031, 1.206538>, <-3.457852, -1.677396, 1.209135>, <-3.222154, -1.636578, 1.354364>, <-3.226368, 0.341851, 1.351767>,
      <-6.529815, 0.301031, -1.096392>, <-6.526252, -1.677396, -1.092740>, <-6.326968, -1.636578, -0.888415>, <-6.330530, 0.341851, -0.892067>,
      <-8.120759, 0.301031, 0.758110>, <-8.117124, -1.677396, 0.761691>, <-7.913806, -1.636578, 0.962002>, <-7.917440, 0.341851, 0.958421>,
      <-9.072559, 0.321312, 0.965436>, <-9.070726, 0.308805, 0.966872>, <-8.968163, 0.309063, 1.047168>, <-8.969997, 0.321570, 1.045733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.226368, 0.341851, 1.351767>, <-3.230581, 2.320280, 1.349171>, <-3.466279, 2.279458, 1.203942>, <-3.462065, 0.301031, 1.206538>,
      <-6.330530, 0.341851, -0.892067>, <-6.334093, 2.320280, -0.895720>, <-6.533377, 2.279458, -1.100045>, <-6.529815, 0.301031, -1.096392>,
      <-7.917440, 0.341851, 0.958421>, <-7.921075, 2.320280, 0.954840>, <-8.124394, 2.279458, 0.754529>, <-8.120759, 0.301031, 0.758110>,
      <-8.969997, 0.321570, 1.045733>, <-8.971830, 0.334078, 1.044298>, <-9.074393, 0.333820, 0.964001>, <-9.072559, 0.321312, 0.965436>
    }
  }
  texture {
    Texture4_1
  }
  scale <1.0, 0.5, 1.0>
  rotate -187.0*z
  translate  <-0.834792, 0.253424, -10.980845>
}
#declare blad2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-1.316230, 0.273828, 3.314536>, <-0.776142, -1.677396, 3.511009>, <-0.504031, -1.636578, 3.597142>, <-1.064662, 0.313569, 3.441659>,
      <-1.964700, 0.261790, 4.750235>, <-1.137710, -1.677396, 5.076037>, <-0.902013, -1.636578, 5.221266>, <-1.760189, 0.301108, 4.930258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-1.064662, 0.313569, 3.441659>, <-1.625292, 2.263716, 3.286175>, <-1.856318, 2.225052, 3.118063>, <-1.316230, 0.273828, 3.314536>,
      <-1.760189, 0.301108, 4.930258>, <-2.512731, 2.238793, 4.700426>, <-2.690582, 2.200976, 4.487706>, <-1.964700, 0.261790, 4.750235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.964700, 0.261790, 4.750235>, <-1.137710, -1.677396, 5.076037>, <-0.902013, -1.636578, 5.221266>, <-1.760189, 0.301108, 4.930258>,
      <-2.512063, 0.249752, 6.249207>, <-1.499279, -1.677396, 6.641065>, <-1.299995, -1.636578, 6.845390>, <-2.350083, 0.288647, 6.480034>,
      <-5.134947, 0.240798, 7.370330>, <-3.940870, -1.677396, 8.186144>, <-3.737551, -1.636578, 8.386454>, <-4.968403, 0.279720, 7.597881>,
      <-5.901700, 0.321312, 6.456437>, <-5.899866, 0.308805, 6.457873>, <-5.797303, 0.309063, 6.538170>, <-5.799137, 0.321570, 6.536734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.760189, 0.301108, 4.930258>, <-2.512731, 2.238793, 4.700426>, <-2.690582, 2.200976, 4.487706>, <-1.964700, 0.261790, 4.750235>,
      <-2.350083, 0.288647, 6.480034>, <-3.400171, 2.213871, 6.114677>, <-3.524846, 2.176899, 5.857348>, <-2.512063, 0.249752, 6.249207>,
      <-4.968403, 0.279720, 7.597881>, <-6.199255, 2.196018, 6.809307>, <-6.329025, 2.158993, 6.554516>, <-5.134947, 0.240798, 7.370330>,
      <-5.799137, 0.321570, 6.536734>, <-5.800970, 0.334078, 6.535299>, <-5.903533, 0.333820, 6.455002>, <-5.901700, 0.321312, 6.456437>
    }
  }
  texture {
    Texture4_1
  }
  scale <1.0, 0.5, 1.0>
  rotate -100.0*z
  translate  <-1.074794, 0.054329, -10.984257>
}
#declare blad4 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>,
      <-5.911110, 0.301031, 6.018708>, <-5.907548, -1.677396, 6.022361>, <-5.708263, -1.636578, 6.226686>, <-5.711826, 0.341851, 6.223033>,
      <-7.502055, 0.301031, 7.873211>, <-7.498420, -1.677396, 7.876791>, <-7.295101, -1.636578, 8.077102>, <-7.298736, 0.341851, 8.073521>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>,
      <-5.711826, 0.341851, 6.223033>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 0.301031, 6.018708>,
      <-7.298736, 0.341851, 8.073521>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 0.301031, 7.873211>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_1
  }
  scale 0.3
  rotate <0.0, 0.0, 82.996483>
  translate  <-0.757446, -0.139264, -11.81958>
}
union { // bloem
  object { blad1 }
  cylinder { // stengel
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture4_1
    }
    scale <0.2, 0.2, 12.6>
    translate  <-0.93634, -0.173648, -12.305768>
  }
  sphere { // bloemknop
    <0,0,0>,1
    texture {
      Texture3_1
    }
    scale <0.4, 0.6, 0.6>
    translate  <-0.942432, -0.163512, -0.071795>
  }
  object { bloemkop }
  object { blad3 }
  object { blad2 }
  object { blad4 }
  rotate 107.78186*z
  translate  <-52.217519, -37.821991, 12.973731>
}


#declare blad5 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>,
      <-5.911110, 0.301031, 6.018708>, <-5.907548, -1.677396, 6.022361>, <-5.708263, -1.636578, 6.226686>, <-5.711826, 0.341851, 6.223033>,
      <-7.502055, 0.301031, 7.873211>, <-7.498420, -1.677396, 7.876791>, <-7.295101, -1.636578, 8.077102>, <-7.298736, 0.341851, 8.073521>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>,
      <-5.711826, 0.341851, 6.223033>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 0.301031, 6.018708>,
      <-7.298736, 0.341851, 8.073521>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 0.301031, 7.873211>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_2
  }
  scale <1.0, 0.5, 1.0>
  translate  <-1.21971, -0.189983, -10.919306>
}
#declare Group4 = union {
  sphere { // Sphere34
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere35
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere36
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere37
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere38
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere39
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere40
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere41
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture2_3
  }
}
#declare Group5 = union {
  sphere { // Sphere26
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere27
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere28
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere29
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere30
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere31
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere32
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere33
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  object { Group4 }
  texture {
    Texture2_3
  }
}
#declare Group6 = union {
  sphere { // Sphere42
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere43
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere44
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere45
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere46
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere47
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere48
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere49
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture2_3
  }
  rotate -20.0*z
}
#declare bloemkop1 = union {
  object { Group5 }
  sphere { // knop1
    <0,0,0>,1
    texture {
      Texture3_2
    }
    scale <1.2, 1.2, 0.2>
    translate  <0.035568, 0.0, -0.556193>
  }
  object { Group6 }
  rotate 90.0*y
}
#declare blad6 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.462065, 0.301031, 1.206538>, <-3.457852, -1.677396, 1.209135>, <-3.222154, -1.636578, 1.354364>, <-3.226368, 0.341851, 1.351767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-3.226368, 0.341851, 1.351767>, <-3.230581, 2.320280, 1.349171>, <-3.466279, 2.279458, 1.203942>, <-3.462065, 0.301031, 1.206538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.462065, 0.301031, 1.206538>, <-3.457852, -1.677396, 1.209135>, <-3.222154, -1.636578, 1.354364>, <-3.226368, 0.341851, 1.351767>,
      <-6.529815, 0.301031, -1.096392>, <-6.526252, -1.677396, -1.092740>, <-6.326968, -1.636578, -0.888415>, <-6.330530, 0.341851, -0.892067>,
      <-8.120759, 0.301031, 0.758110>, <-8.117124, -1.677396, 0.761691>, <-7.913806, -1.636578, 0.962002>, <-7.917440, 0.341851, 0.958421>,
      <-9.072559, 0.321312, 0.965436>, <-9.070726, 0.308805, 0.966872>, <-8.968163, 0.309063, 1.047168>, <-8.969997, 0.321570, 1.045733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.226368, 0.341851, 1.351767>, <-3.230581, 2.320280, 1.349171>, <-3.466279, 2.279458, 1.203942>, <-3.462065, 0.301031, 1.206538>,
      <-6.330530, 0.341851, -0.892067>, <-6.334093, 2.320280, -0.895720>, <-6.533377, 2.279458, -1.100045>, <-6.529815, 0.301031, -1.096392>,
      <-7.917440, 0.341851, 0.958421>, <-7.921075, 2.320280, 0.954840>, <-8.124394, 2.279458, 0.754529>, <-8.120759, 0.301031, 0.758110>,
      <-8.969997, 0.321570, 1.045733>, <-8.971830, 0.334078, 1.044298>, <-9.074393, 0.333820, 0.964001>, <-9.072559, 0.321312, 0.965436>
    }
  }
  texture {
    Texture4_2
  }
  scale <1.0, 0.5, 1.0>
  rotate -187.0*z
  translate  <-0.834792, 0.253424, -10.980845>
}
#declare blad7 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-1.316230, 0.273828, 3.314536>, <-0.776142, -1.677396, 3.511009>, <-0.504031, -1.636578, 3.597142>, <-1.064662, 0.313569, 3.441659>,
      <-1.964700, 0.261790, 4.750235>, <-1.137710, -1.677396, 5.076037>, <-0.902013, -1.636578, 5.221266>, <-1.760189, 0.301108, 4.930258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-1.064662, 0.313569, 3.441659>, <-1.625292, 2.263716, 3.286175>, <-1.856318, 2.225052, 3.118063>, <-1.316230, 0.273828, 3.314536>,
      <-1.760189, 0.301108, 4.930258>, <-2.512731, 2.238793, 4.700426>, <-2.690582, 2.200976, 4.487706>, <-1.964700, 0.261790, 4.750235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.964700, 0.261790, 4.750235>, <-1.137710, -1.677396, 5.076037>, <-0.902013, -1.636578, 5.221266>, <-1.760189, 0.301108, 4.930258>,
      <-2.512063, 0.249752, 6.249207>, <-1.499279, -1.677396, 6.641065>, <-1.299995, -1.636578, 6.845390>, <-2.350083, 0.288647, 6.480034>,
      <-5.134947, 0.240798, 7.370330>, <-3.940870, -1.677396, 8.186144>, <-3.737551, -1.636578, 8.386454>, <-4.968403, 0.279720, 7.597881>,
      <-5.901700, 0.321312, 6.456437>, <-5.899866, 0.308805, 6.457873>, <-5.797303, 0.309063, 6.538170>, <-5.799137, 0.321570, 6.536734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.760189, 0.301108, 4.930258>, <-2.512731, 2.238793, 4.700426>, <-2.690582, 2.200976, 4.487706>, <-1.964700, 0.261790, 4.750235>,
      <-2.350083, 0.288647, 6.480034>, <-3.400171, 2.213871, 6.114677>, <-3.524846, 2.176899, 5.857348>, <-2.512063, 0.249752, 6.249207>,
      <-4.968403, 0.279720, 7.597881>, <-6.199255, 2.196018, 6.809307>, <-6.329025, 2.158993, 6.554516>, <-5.134947, 0.240798, 7.370330>,
      <-5.799137, 0.321570, 6.536734>, <-5.800970, 0.334078, 6.535299>, <-5.903533, 0.333820, 6.455002>, <-5.901700, 0.321312, 6.456437>
    }
  }
  texture {
    Texture4_2
  }
  scale <1.0, 0.5, 1.0>
  rotate -100.0*z
  translate  <-1.074794, 0.054329, -10.984257>
}
#declare blad8 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>,
      <-5.911110, 0.301031, 6.018708>, <-5.907548, -1.677396, 6.022361>, <-5.708263, -1.636578, 6.226686>, <-5.711826, 0.341851, 6.223033>,
      <-7.502055, 0.301031, 7.873211>, <-7.498420, -1.677396, 7.876791>, <-7.295101, -1.636578, 8.077102>, <-7.298736, 0.341851, 8.073521>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>,
      <-5.711826, 0.341851, 6.223033>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 0.301031, 6.018708>,
      <-7.298736, 0.341851, 8.073521>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 0.301031, 7.873211>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_2
  }
  scale 0.3
  rotate <0.0, 0.0, 82.996483>
  translate  <-0.757446, -0.139264, -11.81958>
}
union { // bloem1
  object { blad5 }
  cylinder { // stengel1
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture4_2
    }
    scale <0.2, 0.2, 12.6>
    translate  <-0.93634, -0.173648, -12.305768>
  }
  sphere { // bloemknop1
    <0,0,0>,1
    texture {
      Texture3_2
    }
    scale <0.4, 0.6, 0.6>
    translate  <-0.942432, -0.163512, -0.071795>
  }
  object { bloemkop1 }
  object { blad6 }
  object { blad7 }
  object { blad8 }
  rotate 65.925385*z
  translate  <-59.410473, -36.607554, 13.370109>
}


#declare blad9 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>,
      <-5.911110, 0.301031, 6.018708>, <-5.907548, -1.677396, 6.022361>, <-5.708263, -1.636578, 6.226686>, <-5.711826, 0.341851, 6.223033>,
      <-7.502055, 0.301031, 7.873211>, <-7.498420, -1.677396, 7.876791>, <-7.295101, -1.636578, 8.077102>, <-7.298736, 0.341851, 8.073521>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>,
      <-5.711826, 0.341851, 6.223033>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 0.301031, 6.018708>,
      <-7.298736, 0.341851, 8.073521>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 0.301031, 7.873211>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_3
  }
  scale <1.0, 0.5, 1.0>
  translate  <-1.21971, -0.189983, -10.919306>
}
#declare Group7 = union {
  sphere { // Sphere58
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere59
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere60
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere61
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere62
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere63
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere64
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere65
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture2_4
  }
}
#declare Group8 = union {
  sphere { // Sphere50
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere51
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere52
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere53
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere54
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere55
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere56
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere57
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  object { Group7 }
  texture {
    Texture2_4
  }
}
#declare Group9 = union {
  sphere { // Sphere66
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere67
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere68
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere69
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere70
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere71
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere72
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere73
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture2_4
  }
  rotate -20.0*z
}
#declare bloemkop2 = union {
  object { Group8 }
  sphere { // knop2
    <0,0,0>,1
    texture {
      Texture3_3
    }
    scale <1.2, 1.2, 0.2>
    translate  <0.035568, 0.0, -0.556193>
  }
  object { Group9 }
  rotate 90.0*y
}
#declare blad10 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.462065, 0.301031, 1.206538>, <-3.457852, -1.677396, 1.209135>, <-3.222154, -1.636578, 1.354364>, <-3.226368, 0.341851, 1.351767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-3.226368, 0.341851, 1.351767>, <-3.230581, 2.320280, 1.349171>, <-3.466279, 2.279458, 1.203942>, <-3.462065, 0.301031, 1.206538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.462065, 0.301031, 1.206538>, <-3.457852, -1.677396, 1.209135>, <-3.222154, -1.636578, 1.354364>, <-3.226368, 0.341851, 1.351767>,
      <-6.529815, 0.301031, -1.096392>, <-6.526252, -1.677396, -1.092740>, <-6.326968, -1.636578, -0.888415>, <-6.330530, 0.341851, -0.892067>,
      <-8.120759, 0.301031, 0.758110>, <-8.117124, -1.677396, 0.761691>, <-7.913806, -1.636578, 0.962002>, <-7.917440, 0.341851, 0.958421>,
      <-9.072559, 0.321312, 0.965436>, <-9.070726, 0.308805, 0.966872>, <-8.968163, 0.309063, 1.047168>, <-8.969997, 0.321570, 1.045733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.226368, 0.341851, 1.351767>, <-3.230581, 2.320280, 1.349171>, <-3.466279, 2.279458, 1.203942>, <-3.462065, 0.301031, 1.206538>,
      <-6.330530, 0.341851, -0.892067>, <-6.334093, 2.320280, -0.895720>, <-6.533377, 2.279458, -1.100045>, <-6.529815, 0.301031, -1.096392>,
      <-7.917440, 0.341851, 0.958421>, <-7.921075, 2.320280, 0.954840>, <-8.124394, 2.279458, 0.754529>, <-8.120759, 0.301031, 0.758110>,
      <-8.969997, 0.321570, 1.045733>, <-8.971830, 0.334078, 1.044298>, <-9.074393, 0.333820, 0.964001>, <-9.072559, 0.321312, 0.965436>
    }
  }
  texture {
    Texture4_3
  }
  scale <1.0, 0.5, 1.0>
  rotate -187.0*z
  translate  <-0.834792, 0.253424, -10.980845>
}
#declare blad12 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>,
      <-5.911110, 0.301031, 6.018708>, <-5.907548, -1.677396, 6.022361>, <-5.708263, -1.636578, 6.226686>, <-5.711826, 0.341851, 6.223033>,
      <-7.502055, 0.301031, 7.873211>, <-7.498420, -1.677396, 7.876791>, <-7.295101, -1.636578, 8.077102>, <-7.298736, 0.341851, 8.073521>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>,
      <-5.711826, 0.341851, 6.223033>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 0.301031, 6.018708>,
      <-7.298736, 0.341851, 8.073521>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 0.301031, 7.873211>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_3
  }
  scale 0.3
  rotate <0.0, 0.0, 82.996483>
  translate  <-0.757446, -0.139264, -11.81958>
}
#declare blad11 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.367198, -1.304695>, <-0.087079, -0.423504, -1.337213>, <0.198338, -0.407191, -1.336542>, <0.193235, 0.383512, -1.304024>,
      <-0.092182, 0.254719, 1.132302>, <-0.087079, -1.722037, 1.051007>, <0.198338, -1.681253, 1.052684>, <0.193235, 0.295505, 1.133979>,
      <-0.620187, 0.292076, 2.704284>, <-0.776142, -1.820249, 3.439118>, <-0.504031, -1.783005, 3.526856>, <-0.368619, 0.326560, 2.832932>,
      <-1.218104, 0.219755, 4.169885>, <-1.137710, -1.884557, 5.002824>, <-0.902013, -1.849741, 5.149608>, <-1.011330, 0.251685, 4.350325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.383512, -1.304024>, <0.188133, 1.174215, -1.271506>, <-0.097284, 1.157900, -1.272177>, <-0.092182, 0.367198, -1.304695>,
      <0.193235, 0.295505, 1.133979>, <0.188133, 2.272263, 1.215274>, <-0.097284, 2.231476, 1.213597>, <-0.092182, 0.254719, 1.132302>,
      <-0.368619, 0.326560, 2.832932>, <-0.233207, 2.436125, 2.139009>, <-0.464233, 2.404402, 1.969450>, <-0.620187, 0.292076, 2.704284>,
      <-1.011330, 0.251685, 4.350325>, <-1.120647, 2.353111, 3.551041>, <-1.298497, 2.324066, 3.336946>, <-1.218104, 0.219755, 4.169885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.218104, 0.219755, 4.169885>, <-1.137710, -1.884557, 5.002824>, <-0.902013, -1.849741, 5.149608>, <-1.011330, 0.251685, 4.350325>,
      <-1.816020, 0.147433, 5.635487>, <-1.499279, -1.948865, 6.566531>, <-1.299995, -1.916477, 6.772360>, <-1.654040, 0.176810, 5.867717>,
      <-4.593581, 0.247095, 8.495401>, <-2.548785, -1.703001, 6.872896>, <-2.345466, -1.670448, 7.074714>, <-4.427037, 0.276634, 8.724359>,
      <-6.211052, 0.365094, 9.944400>, <-6.209218, 0.352538, 9.945320>, <-6.106656, 0.349496, 10.025559>, <-6.108489, 0.362052, 10.024639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.011330, 0.251685, 4.350325>, <-1.120647, 2.353111, 3.551041>, <-1.298497, 2.324066, 3.336946>, <-1.218104, 0.219755, 4.169885>,
      <-1.654040, 0.176810, 5.867717>, <-2.008086, 2.270097, 4.963074>, <-2.132761, 2.243730, 4.704442>, <-1.816020, 0.147433, 5.635487>,
      <-4.427037, 0.276634, 8.724359>, <-6.508608, 2.223716, 10.374004>, <-6.638377, 2.197192, 10.117907>, <-4.593581, 0.247095, 8.495401>,
      <-6.108489, 0.362052, 10.024639>, <-6.110322, 0.374608, 10.023719>, <-6.212885, 0.377650, 9.943479>, <-6.211052, 0.365094, 9.944400>
    }
  }
  texture {
    Texture4_3
  }
  scale <1.0, 0.5, 1.0>
  rotate <0.0, -0.0, -100.0>
  translate  <-1.074794, 0.054329, -10.984257>
}
union { // bloem2
  object { blad9 }
  cylinder { // stengel2
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture4_3
    }
    scale <0.2, 0.2, 12.6>
    translate  <-0.93634, -0.173648, -12.305768>
  }
  sphere { // bloemknop2
    <0,0,0>,1
    texture {
      Texture3_3
    }
    scale <0.4, 0.6, 0.6>
    translate  <-0.942432, -0.163512, -0.071795>
  }
  object { bloemkop2 }
  object { blad10 }
  object { blad12 }
  object { blad11 }
  scale 0.6
  rotate 54.052235*z
  translate  <-47.578506, -24.155495, 2.993673>
}


#declare blad13 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>,
      <-5.911110, 0.301031, 6.018708>, <-5.907548, -1.677396, 6.022361>, <-5.708263, -1.636578, 6.226686>, <-5.711826, 0.341851, 6.223033>,
      <-7.502055, 0.301031, 7.873211>, <-7.498420, -1.677396, 7.876791>, <-7.295101, -1.636578, 8.077102>, <-7.298736, 0.341851, 8.073521>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>,
      <-5.711826, 0.341851, 6.223033>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 0.301031, 6.018708>,
      <-7.298736, 0.341851, 8.073521>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 0.301031, 7.873211>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_4
  }
  scale 0.3
  rotate <0.0, 0.0, 82.996483>
  translate  <-0.757446, -0.139264, -11.81958>
}
#declare blad15 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.727662, 1.481150>, <-0.087079, -0.824135, 1.841420>, <0.198338, -0.789571, 1.819707>, <0.193235, 0.765354, 1.470293>,
      <-0.394316, 1.363371, 3.686629>, <-0.389451, 0.447284, 3.865330>, <-0.117341, 0.527667, 3.916553>, <-0.122206, 1.423973, 3.755307>,
      <-3.152713, 1.734137, 4.833607>, <-3.148500, 1.115236, 4.928609>, <-2.912802, 1.227054, 5.029873>, <-2.917016, 1.811378, 4.955959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.765354, 1.470293>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.727662, 1.481150>,
      <-0.122206, 1.423973, 3.755307>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 1.363371, 3.686629>,
      <-2.917016, 1.811378, 4.955959>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 1.734137, 4.833607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 1.734137, 4.833607>, <-3.148500, 1.115236, 4.928609>, <-2.912802, 1.227054, 5.029873>, <-2.917016, 1.811378, 4.955959>,
      <-5.911110, 2.031323, 6.003472>, <-5.907548, 1.783188, 5.991888>, <-5.708263, 1.926442, 6.143193>, <-5.711826, 2.123361, 6.181287>,
      <-7.502055, 2.524552, 7.715905>, <-7.498420, 2.769645, 7.562180>, <-7.295101, 2.910763, 7.710086>, <-7.298736, 2.615522, 7.890013>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 1.811378, 4.955959>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 1.734137, 4.833607>,
      <-5.711826, 2.123361, 6.181287>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 2.031323, 6.003472>,
      <-7.298736, 2.615522, 7.890013>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 2.524552, 7.715905>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_4
  }
  scale 0.5
  translate  <-1.21971, -0.189983, -10.76616>
}
#declare blad16 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-1.863739, 0.301031, 4.514863>, <-1.858874, -1.677396, 4.516403>, <-1.586764, -1.636578, 4.602536>, <-1.591628, 0.341851, 4.600997>,
      <-2.069980, 0.301031, 2.173264>, <-2.065767, -1.677396, 2.175860>, <-1.830070, -1.636578, 2.321089>, <-1.834283, 0.341851, 2.318493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-1.591628, 0.341851, 4.600997>, <-1.596493, 2.320280, 4.599457>, <-1.868603, 2.279458, 4.513324>, <-1.863739, 0.301031, 4.514863>,
      <-1.834283, 0.341851, 2.318493>, <-1.838497, 2.320280, 2.315897>, <-2.074194, 2.279458, 2.170668>, <-2.069980, 0.301031, 2.173264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.069980, 0.301031, 2.173264>, <-2.065767, -1.677396, 2.175860>, <-1.830070, -1.636578, 2.321089>, <-1.834283, 0.341851, 2.318493>,
      <-2.276222, 0.301031, -0.168336>, <-2.272660, -1.677396, -0.164683>, <-2.073375, -1.636578, 0.039642>, <-2.076938, 0.341851, 0.035989>,
      <-3.867167, 0.301031, 1.686167>, <-3.863532, -1.677396, 1.689748>, <-3.660213, -1.636578, 1.890058>, <-3.663848, 0.341851, 1.886478>,
      <-4.818967, 0.321312, 1.893493>, <-4.817133, 0.308805, 1.894928>, <-4.714571, 0.309063, 1.975225>, <-4.716404, 0.321570, 1.973790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.834283, 0.341851, 2.318493>, <-1.838497, 2.320280, 2.315897>, <-2.074194, 2.279458, 2.170668>, <-2.069980, 0.301031, 2.173264>,
      <-2.076938, 0.341851, 0.035989>, <-2.080500, 2.320280, 0.032337>, <-2.279785, 2.279458, -0.171988>, <-2.276222, 0.301031, -0.168336>,
      <-3.663848, 0.341851, 1.886478>, <-3.667482, 2.320280, 1.882897>, <-3.870801, 2.279458, 1.682586>, <-3.867167, 0.301031, 1.686167>,
      <-4.716404, 0.321570, 1.973790>, <-4.718238, 0.334078, 1.972354>, <-4.820800, 0.333820, 1.892057>, <-4.818967, 0.321312, 1.893493>
    }
  }
  texture {
    Texture4_4
  }
  scale <1.0, 0.5, 1.0>
  rotate 173.0*z
  translate  <-0.834792, 0.253424, -10.980845>
}
#declare Group10 = union {
  sphere { // Sphere74
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere75
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere76
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere77
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere78
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere79
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere80
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere81
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture1_2
  }
  rotate <-90.0, 70.0, -90.0>
}
#declare Group11 = union {
  sphere { // Sphere90
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere91
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere92
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere93
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere94
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere95
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere96
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere97
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture1_2
  }
}
#declare Group12 = union {
  sphere { // Sphere82
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere83
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere84
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere85
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere86
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere87
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere88
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere89
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  object { Group11 }
  texture {
    Texture1_2
  }
  rotate 90.0*y
}
#declare blad14 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, -0.537441, -1.047998>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, -0.521113, -1.047998>,
      <-0.865562, -0.549687, 0.850196>, <-0.860460, -1.677396, 0.579513>, <-0.575043, -1.636578, 0.579513>, <-0.580145, -0.508867, 0.850196>,
      <-2.552094, -0.576890, -0.111593>, <-1.627138, -1.677396, 0.245530>, <-1.391950, -1.636578, 0.407240>, <-1.961815, -0.537150, 0.354021>,
      <-4.711303, -0.588929, 0.453241>, <-3.806012, -1.677396, 1.084487>, <-2.158022, -1.636578, 2.156892>, <-3.644706, -0.549611, 1.599583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, -0.521113, -1.047998>, <0.188133, -0.580461, -0.777315>, <-0.097284, -0.596789, -0.777315>, <-0.092182, -0.537441, -1.047998>,
      <-0.580145, -0.508867, 0.850196>, <-0.585247, 0.618843, 1.120879>, <-0.870664, 0.578021, 1.120879>, <-0.865562, -0.549687, 0.850196>,
      <-1.961815, -0.537150, 0.354021>, <-2.531679, 0.562279, 0.300802>, <-3.477050, 0.523615, -0.468717>, <-2.552094, -0.576890, -0.111593>,
      <-3.644706, -0.549611, 1.599583>, <-5.208728, 0.537356, 1.119613>, <-5.693932, 0.499539, -0.100668>, <-4.711303, -0.588929, 0.453241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.711303, -0.588929, 0.453241>, <-3.806012, -1.677396, 1.084487>, <-2.158022, -1.636578, 2.156892>, <-3.644706, -0.549611, 1.599583>,
      <-6.947851, -0.600967, 1.095413>, <-5.984886, -1.677396, 1.923444>, <-2.924094, -1.636578, 3.906544>, <-5.404936, -0.562072, 2.922484>,
      <-10.161920, -0.609920, 3.000730>, <-9.509209, -1.677396, 3.623199>, <-9.305890, -1.636578, 3.823510>, <-9.995376, -0.570999, 3.228281>,
      <-10.387306, 0.321312, 1.738817>, <-10.385473, 0.308805, 1.740252>, <-10.282910, 0.309063, 1.820549>, <-10.284744, 0.321570, 1.819114>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.644706, -0.549611, 1.599583>, <-5.208728, 0.537356, 1.119613>, <-5.693932, 0.499539, -0.100668>, <-4.711303, -0.588929, 0.453241>,
      <-5.404936, -0.562072, 2.922484>, <-7.885777, 0.512434, 1.938423>, <-7.910815, 0.475462, 0.267381>, <-6.947851, -0.600967, 1.095413>,
      <-9.995376, -0.570999, 3.228281>, <-10.684862, 0.494581, 2.633052>, <-10.814631, 0.457556, 2.378261>, <-10.161920, -0.609920, 3.000730>,
      <-10.284744, 0.321570, 1.819114>, <-10.286577, 0.334078, 1.817678>, <-10.389140, 0.333820, 1.737381>, <-10.387306, 0.321312, 1.738817>
    }
  }
  texture {
    Texture4_4
  }
  scale <1.0, 0.5, 1.0>
  rotate <0.0, -0.0, -100.0>
  translate  <-1.074794, 0.054329, -10.984257>
}
union { // bloemMwit
  object { blad13 }
  sphere { // bloemknop3
    <0,0,0>,1
    texture {
      Texture3_4
    }
    scale <0.4, 0.6, 0.6>
    translate  <-0.942432, -0.163512, -0.071795>
  }
  cylinder { // stengel3
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture4_4
    }
    scale <0.2, 0.2, 12.6>
    translate  <-0.93634, -0.173648, -12.305768>
  }
  object { blad15 }
  sphere { // knop3
    <0,0,0>,1
    texture {
      Texture2_5
    }
    scale <1.2, 1.2, 0.2>
    rotate 90.0*y
    translate  <-0.556193, 0.0, -0.035568>
  }
  object { blad16 }
  object { Group10 }
  object { Group12 }
  object { blad14 }
  scale 0.6
  rotate 86.810303*z
  translate  <-20.287989, -31.331254, 6.849356>
}


#declare Group13 = union {
  sphere { // Sphere98
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere99
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere100
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere101
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere102
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere103
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere104
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere105
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -3.712625>
  translate  <-0.111263, 0.0, 6.342018>
}
#declare Group14 = union {
  sphere { // Sphere106
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere107
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere108
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere109
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere110
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere111
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere112
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere113
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -7.798976>
  translate  <0.0, 0.076196, 4.228012>
}
#declare Group15 = union {
  sphere { // Sphere114
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere115
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere116
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere117
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere118
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere119
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere120
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere121
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <0.0, 0.0, -7.548573>
  translate  <-0.111263, 0.0, 2.55906>
}
#declare Group16 = union {
  sphere { // Sphere122
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere123
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere124
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere125
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere126
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere127
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere128
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere129
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <-0.0, 0.0, 25.721674>
  translate  <-0.111263, 0.0, 1.668952>
}
#declare Group17 = union {
  sphere { // Sphere130
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere131
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere132
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere133
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere134
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere135
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere136
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
}
#declare Group18 = union {
  sphere { // Sphere137
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere138
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere139
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere140
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere141
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere142
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere143
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere144
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -10.270803>
  translate  <0.006062, -0.038098, 5.006856>
}
#declare Group19 = union {
  sphere { // Sphere145
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere146
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere147
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere148
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere149
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere150
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere151
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere152
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -19.235001>
  translate  <-0.111263, 0.0, 7.565916>
}
#declare Group20 = union {
  sphere { // Sphere153
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere154
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere155
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere156
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere157
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere158
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere159
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere160
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, 9.616993>
  translate  <-0.111263, 0.0, 10.124976>
}
#declare Group21 = union {
  sphere { // Sphere161
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere162
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere163
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere164
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere165
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere166
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere167
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere168
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -26.79118>
  translate  <-0.222527, 0.0, 8.678551>
}
#declare Group22 = union {
  sphere { // Sphere169
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere170
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere171
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere172
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere173
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere174
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere175
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere176
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -27.888746>
  translate  <0.111263, 0.0, 12.684036>
}
#declare Group23 = union {
  sphere { // Sphere177
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere178
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere179
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere180
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere181
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere182
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere183
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere184
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <-10.689362, -1.89129, -9.917496>
  translate  <-0.111263, -0.063143, 14.684173>
}
#declare Group24 = union {
  sphere { // Sphere185
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere186
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere187
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere188
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere189
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere190
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere191
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere192
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <6.312906, 1.121453, -10.032603>
  translate  <-0.111263, -0.051765, 15.168819>
}
#declare Group25 = union {
  sphere { // Sphere193
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere194
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere195
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere196
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere197
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere198
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere199
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere200
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -10.094448>
  translate  <-0.111263, 0.0, 11.571401>
}
#declare Group26 = union {
  sphere { // Sphere201
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere202
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere203
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere204
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere205
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere206
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere207
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere208
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.2
  rotate <-18.509361, -3.234712, -9.567235>
  translate  <-0.111263, 0.0, 13.797043>
}
#declare NAALDEN = union {
  object { Group13 }
  object { Group14 }
  object { Group15 }
  object { Group16 }
  object { Group17 }
  object { Group18 }
  object { Group19 }
  object { Group20 }
  object { Group21 }
  object { Group22 }
  object { Group23 }
  object { Group24 }
  object { Group25 }
  object { Group26 }
  texture {
    Texture2_6
  }
}
union { // NAALDBOOM
  object { NAALDEN }
  cone { // Cone001
    <0,0,0>, 0.2, <0,0,1>, 0.4
    texture {
      Texture1_3
    }
    scale <0.5, 0.5, 16.0>
    rotate 180.0*x
    translate  <0.0, -0.089026, 15.713739>
  }
  scale 2.0
  translate  <-35.54163, -35.180671, 0.016938>
}


#declare Group27 = union {
  sphere { // Sphere209
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere210
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere211
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere212
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere213
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere214
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere215
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere216
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -3.712625>
  translate  <-0.111263, 0.0, 6.342018>
}
#declare Group28 = union {
  sphere { // Sphere217
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere218
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere219
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere220
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere221
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere222
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere223
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere224
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -7.798976>
  translate  <0.0, 0.076196, 4.228012>
}
#declare Group29 = union {
  sphere { // Sphere225
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere226
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere227
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere228
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere229
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere230
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere231
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere232
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <0.0, 0.0, -7.548573>
  translate  <-0.111263, 0.0, 2.55906>
}
#declare Group30 = union {
  sphere { // Sphere233
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere234
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere235
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere236
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere237
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere238
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere239
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere240
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <-0.0, 0.0, 25.721674>
  translate  <-0.111263, 0.0, 1.668952>
}
#declare Group31 = union {
  sphere { // Sphere241
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere242
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere243
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere244
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere245
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere246
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere247
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere248
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
}
#declare Group32 = union {
  sphere { // Sphere249
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere250
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere251
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere252
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere253
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere254
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere255
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere256
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -10.270803>
  translate  <0.006062, -0.038098, 5.006856>
}
#declare Group33 = union {
  sphere { // Sphere257
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere258
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere259
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere260
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere261
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere262
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere263
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere264
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -19.235001>
  translate  <-0.111263, 0.0, 7.565916>
}
#declare Group34 = union {
  sphere { // Sphere265
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere266
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere267
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere268
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere269
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere270
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere271
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere272
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, 9.616993>
  translate  <-0.111263, 0.0, 10.124976>
}
#declare Group35 = union {
  sphere { // Sphere273
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere274
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere275
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere276
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere277
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere278
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere279
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere280
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -26.79118>
  translate  <-0.222527, 0.0, 8.678551>
}
#declare Group36 = union {
  sphere { // Sphere281
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere282
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere283
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere284
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere285
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere286
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere287
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere288
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -27.888746>
  translate  <0.111263, 0.0, 12.684036>
}
#declare Group37 = union {
  sphere { // Sphere289
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere290
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere291
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere292
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere293
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere294
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere295
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere296
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <-10.689362, -1.89129, -9.917496>
  translate  <-0.111263, -0.063143, 14.684173>
}
#declare Group38 = union {
  sphere { // Sphere297
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere298
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere299
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere300
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere301
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere302
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere303
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere304
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <6.312906, 1.121453, -10.032603>
  translate  <-0.111263, -0.051765, 15.168819>
}
#declare Group39 = union {
  sphere { // Sphere305
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere306
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere307
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere308
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere309
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere310
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere311
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere312
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -10.094448>
  translate  <-0.111263, 0.0, 11.571401>
}
#declare Group40 = union {
  sphere { // Sphere313
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere314
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere315
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere316
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere317
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere318
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere319
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere320
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.2
  rotate <-18.509361, -3.234712, -9.567235>
  translate  <-0.111263, 0.0, 13.797043>
}
#declare NAALDEN1 = union {
  object { Group27 }
  object { Group28 }
  object { Group29 }
  object { Group30 }
  object { Group31 }
  object { Group32 }
  object { Group33 }
  object { Group34 }
  object { Group35 }
  object { Group36 }
  object { Group37 }
  object { Group38 }
  object { Group39 }
  object { Group40 }
  texture {
    Texture2_7
  }
}
union { // NAALDBOOM1
  object { NAALDEN1 }
  cone { // Cone2
    <0,0,0>, 0.2, <0,0,1>, 0.4
    texture {
      Texture1_4
    }
    scale <0.5, 0.5, 16.0>
    rotate 180.0*x
    translate  <0.0, -0.089026, 15.713739>
  }
  rotate <-4.497031, 0.0, 0.0>
  translate  <-21.105396, -43.193957, 4.730771>
}


#declare Group41 = union {
  sphere { // Sphere321
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere322
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere323
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere324
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere325
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere326
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere327
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere328
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -3.712625>
  translate  <-0.111263, 0.0, 6.342018>
}
#declare Group42 = union {
  sphere { // Sphere329
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere330
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere331
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere332
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere333
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere334
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere335
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere336
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -7.798976>
  translate  <0.0, 0.076196, 4.228012>
}
#declare Group43 = union {
  sphere { // Sphere337
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere338
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere339
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere340
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere341
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere342
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere343
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere344
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <0.0, 0.0, -7.548573>
  translate  <-0.111263, 0.0, 2.55906>
}
#declare Group44 = union {
  sphere { // Sphere345
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere346
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere347
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere348
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere349
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere350
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere351
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere352
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <-0.0, 0.0, 25.721674>
  translate  <-0.111263, 0.0, 1.668952>
}
#declare Group45 = union {
  sphere { // Sphere353
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere354
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere355
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere356
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere357
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere358
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere359
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere360
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
}
#declare Group46 = union {
  sphere { // Sphere361
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere362
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere363
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere364
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere365
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere366
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere367
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere368
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -10.270803>
  translate  <0.006062, -0.038098, 5.006856>
}
#declare Group47 = union {
  sphere { // Sphere369
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere370
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere371
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere372
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere373
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere374
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere375
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere376
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -19.235001>
  translate  <-0.111263, 0.0, 7.565916>
}
#declare Group48 = union {
  sphere { // Sphere377
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere378
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere379
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere380
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere381
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere382
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere383
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere384
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, 9.616993>
  translate  <-0.111263, 0.0, 10.124976>
}
#declare Group49 = union {
  sphere { // Sphere385
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere386
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere387
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere388
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere389
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere390
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere391
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere392
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -26.79118>
  translate  <-0.222527, 0.0, 8.678551>
}
#declare Group50 = union {
  sphere { // Sphere393
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere394
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere395
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere396
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere397
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere398
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere399
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere400
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -27.888746>
  translate  <0.111263, 0.0, 12.684036>
}
#declare Group51 = union {
  sphere { // Sphere401
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere402
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere403
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere404
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere405
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere406
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere407
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere408
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <-10.689362, -1.89129, -9.917496>
  translate  <-0.111263, -0.063143, 14.684173>
}
#declare Group52 = union {
  sphere { // Sphere409
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere410
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere411
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere412
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere413
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere414
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere415
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere416
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <6.312906, 1.121453, -10.032603>
  translate  <-0.111263, -0.051765, 15.168819>
}
#declare Group53 = union {
  sphere { // Sphere417
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere418
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere419
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere420
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere421
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere422
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere423
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere424
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -10.094448>
  translate  <-0.111263, 0.0, 11.571401>
}
#declare Group54 = union {
  sphere { // Sphere425
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere426
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere427
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere428
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere429
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere430
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere431
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere432
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.2
  rotate <-18.509361, -3.234712, -9.567235>
  translate  <-0.111263, 0.0, 13.797043>
}
#declare NAALDEN2 = union {
  object { Group41 }
  object { Group42 }
  object { Group43 }
  object { Group44 }
  object { Group45 }
  object { Group46 }
  object { Group47 }
  object { Group48 }
  object { Group49 }
  object { Group50 }
  object { Group51 }
  object { Group52 }
  object { Group53 }
  object { Group54 }
  texture {
    Texture2_8
  }
}
union { // NAALDBOOM2
  object { NAALDEN2 }
  cone { // Cone3
    <0,0,0>, 0.2, <0,0,1>, 0.4
    texture {
      Texture1_5
    }
    scale <0.5, 0.5, 16.0>
    rotate 180.0*x
    translate  <0.0, -0.089026, 15.713739>
  }
  scale 4.0
  rotate 10.885867*z
  translate  <-82.340319, -62.687245, 15.061709>
}


#declare blad17 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>,
      <-5.911110, 0.301031, 6.018708>, <-5.907548, -1.677396, 6.022361>, <-5.708263, -1.636578, 6.226686>, <-5.711826, 0.341851, 6.223033>,
      <-7.502055, 0.301031, 7.873211>, <-7.498420, -1.677396, 7.876791>, <-7.295101, -1.636578, 8.077102>, <-7.298736, 0.341851, 8.073521>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>,
      <-5.711826, 0.341851, 6.223033>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 0.301031, 6.018708>,
      <-7.298736, 0.341851, 8.073521>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 0.301031, 7.873211>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_5
  }
  scale 0.3
  rotate <0.0, 0.0, 82.996483>
  translate  <-0.757446, -0.139264, -11.81958>
}
#declare blad18 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-1.316230, 0.273828, 3.314536>, <-0.776142, -1.677396, 3.511009>, <-0.504031, -1.636578, 3.597142>, <-1.064662, 0.313569, 3.441659>,
      <-1.914146, 0.261790, 4.718962>, <-1.137710, -1.677396, 5.076037>, <-0.902013, -1.636578, 5.221266>, <-1.707372, 0.301108, 4.960846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-1.064662, 0.313569, 3.441659>, <-1.625292, 2.263716, 3.286175>, <-1.856318, 2.225052, 3.118063>, <-1.316230, 0.273828, 3.314536>,
      <-1.707372, 0.301108, 4.960846>, <-2.512731, 2.238793, 4.700426>, <-2.690582, 2.200976, 4.403827>, <-1.914146, 0.261790, 4.718962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.914146, 0.261790, 4.718962>, <-1.137710, -1.677396, 5.076037>, <-0.902013, -1.636578, 5.221266>, <-1.707372, 0.301108, 4.960846>,
      <-2.512063, 0.249752, 6.165328>, <-1.499279, -1.677396, 6.641065>, <-1.299995, -1.636578, 6.845390>, <-2.350083, 0.288647, 6.480034>,
      <-5.134947, 0.240798, 7.370330>, <-3.940870, -1.677396, 8.186144>, <-3.737551, -1.636578, 8.386454>, <-4.968403, 0.279720, 7.597881>,
      <-5.901700, 0.321312, 6.456437>, <-5.899866, 0.308805, 6.457873>, <-5.797303, 0.309063, 6.538170>, <-5.799137, 0.321570, 6.536734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.707372, 0.301108, 4.960846>, <-2.512731, 2.238793, 4.700426>, <-2.690582, 2.200976, 4.403827>, <-1.914146, 0.261790, 4.718962>,
      <-2.350083, 0.288647, 6.480034>, <-3.400171, 2.213871, 6.114677>, <-3.524846, 2.176899, 5.689591>, <-2.512063, 0.249752, 6.165328>,
      <-4.968403, 0.279720, 7.597881>, <-6.199255, 2.196018, 6.809307>, <-6.329025, 2.158993, 6.554516>, <-5.134947, 0.240798, 7.370330>,
      <-5.799137, 0.321570, 6.536734>, <-5.800970, 0.334078, 6.535299>, <-5.903533, 0.333820, 6.455002>, <-5.901700, 0.321312, 6.456437>
    }
  }
  texture {
    Texture4_5
  }
  scale <1.0, 0.5, 1.0>
  rotate -100.0*z
  translate  <-1.074794, 0.054329, -10.984257>
}
#declare blad19 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.727662, 1.481150>, <-0.087079, -0.824135, 1.841420>, <0.198338, -0.789571, 1.819707>, <0.193235, 0.765354, 1.470293>,
      <-0.394316, 1.363371, 3.686629>, <-0.389451, 0.447284, 3.865330>, <-0.117341, 0.527667, 3.916553>, <-0.122206, 1.423973, 3.755307>,
      <-3.152713, 1.734137, 4.833607>, <-3.148500, 1.115236, 4.928609>, <-2.912802, 1.227054, 5.029873>, <-2.917016, 1.811378, 4.955959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.765354, 1.470293>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.727662, 1.481150>,
      <-0.122206, 1.423973, 3.755307>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 1.363371, 3.686629>,
      <-2.917016, 1.811378, 4.955959>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 1.734137, 4.833607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 1.734137, 4.833607>, <-3.148500, 1.115236, 4.928609>, <-2.912802, 1.227054, 5.029873>, <-2.917016, 1.811378, 4.955959>,
      <-5.911110, 2.031323, 6.003472>, <-5.907548, 1.783188, 5.991888>, <-5.708263, 1.926442, 6.143193>, <-5.711826, 2.123361, 6.181287>,
      <-7.502055, 2.524552, 7.715905>, <-7.498420, 2.769645, 7.562180>, <-7.295101, 2.910763, 7.710086>, <-7.298736, 2.615522, 7.890013>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 1.811378, 4.955959>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 1.734137, 4.833607>,
      <-5.711826, 2.123361, 6.181287>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 2.031323, 6.003472>,
      <-7.298736, 2.615522, 7.890013>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 2.524552, 7.715905>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_5
  }
  scale 0.5
  translate  <-1.21971, -0.189983, -10.76616>
}
#declare blad20 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-1.863739, 0.301031, 4.514863>, <-1.858874, -1.677396, 4.516403>, <-1.586764, -1.636578, 4.602536>, <-1.591628, 0.341851, 4.600997>,
      <-2.069980, 0.301031, 2.173264>, <-2.065767, -1.677396, 2.175860>, <-1.830070, -1.636578, 2.321089>, <-1.834283, 0.341851, 2.318493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-1.591628, 0.341851, 4.600997>, <-1.596493, 2.320280, 4.599457>, <-1.868603, 2.279458, 4.513324>, <-1.863739, 0.301031, 4.514863>,
      <-1.834283, 0.341851, 2.318493>, <-1.838497, 2.320280, 2.315897>, <-2.074194, 2.279458, 2.170668>, <-2.069980, 0.301031, 2.173264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.069980, 0.301031, 2.173264>, <-2.065767, -1.677396, 2.175860>, <-1.830070, -1.636578, 2.321089>, <-1.834283, 0.341851, 2.318493>,
      <-2.276222, 0.301031, -0.168336>, <-2.272660, -1.677396, -0.164683>, <-2.073375, -1.636578, 0.039642>, <-2.076938, 0.341851, 0.035989>,
      <-3.867167, 0.301031, 1.686167>, <-3.863532, -1.677396, 1.689748>, <-3.660213, -1.636578, 1.890058>, <-3.663848, 0.341851, 1.886478>,
      <-4.818967, 0.321312, 1.893493>, <-4.817133, 0.308805, 1.894928>, <-4.714571, 0.309063, 1.975225>, <-4.716404, 0.321570, 1.973790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.834283, 0.341851, 2.318493>, <-1.838497, 2.320280, 2.315897>, <-2.074194, 2.279458, 2.170668>, <-2.069980, 0.301031, 2.173264>,
      <-2.076938, 0.341851, 0.035989>, <-2.080500, 2.320280, 0.032337>, <-2.279785, 2.279458, -0.171988>, <-2.276222, 0.301031, -0.168336>,
      <-3.663848, 0.341851, 1.886478>, <-3.667482, 2.320280, 1.882897>, <-3.870801, 2.279458, 1.682586>, <-3.867167, 0.301031, 1.686167>,
      <-4.716404, 0.321570, 1.973790>, <-4.718238, 0.334078, 1.972354>, <-4.820800, 0.333820, 1.892057>, <-4.818967, 0.321312, 1.893493>
    }
  }
  texture {
    Texture4_5
  }
  scale <1.0, 0.5, 1.0>
  rotate 173.0*z
  translate  <-0.834792, 0.253424, -10.980845>
}
#declare Group55 = union {
  sphere { // Sphere433
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere434
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere435
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere436
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere437
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere438
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere439
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere440
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture1_6
  }
  rotate <-90.0, 70.0, -90.0>
}
#declare Group56 = union {
  sphere { // Sphere449
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere450
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere451
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere452
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere453
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere454
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere455
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere456
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture1_6
  }
}
#declare Group57 = union {
  sphere { // Sphere441
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere442
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere443
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere444
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere445
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere446
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere447
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere448
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  object { Group56 }
  texture {
    Texture1_6
  }
  rotate 90.0*y
}
union { // bloem4
  object { blad17 }
  sphere { // bloemknop4
    <0,0,0>,1
    texture {
      Texture3_5
    }
    scale <0.4, 0.6, 0.6>
    translate  <-0.942432, -0.163512, -0.071795>
  }
  object { blad18 }
  cylinder { // stengel4
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture4_5
    }
    scale <0.2, 0.2, 12.6>
    translate  <-0.93634, -0.173648, -12.305768>
  }
  object { blad19 }
  sphere { // knop4
    <0,0,0>,1
    texture {
      Texture2
    }
    scale <1.2, 1.2, 0.2>
    rotate 90.0*y
    translate  <-0.556193, 0.0, -0.035568>
  }
  object { blad20 }
  object { Group55 }
  object { Group57 }
  rotate <-0.0, -0.0, 108.275436>
  translate  <-14.609797, -26.292113, 8.138802>
}


#declare Group58 = union {
  sphere { // Sphere457
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere458
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere459
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere460
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere461
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere462
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere463
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere464
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -3.712625>
  translate  <-0.111263, 0.0, 6.342018>
}
#declare Group59 = union {
  sphere { // Sphere465
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere466
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere467
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere468
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere469
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere470
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere471
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere472
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -7.798976>
  translate  <0.0, 0.076196, 4.228012>
}
#declare Group60 = union {
  sphere { // Sphere473
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere474
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere475
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere476
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere477
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere478
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere479
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere480
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <0.0, 0.0, -7.548573>
  translate  <-0.111263, 0.0, 2.55906>
}
#declare Group61 = union {
  sphere { // Sphere481
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere482
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere483
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere484
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere485
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere486
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere487
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere488
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <-0.0, 0.0, 25.721674>
  translate  <-0.111263, 0.0, 1.668952>
}
#declare Group62 = union {
  sphere { // Sphere489
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere490
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere491
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere492
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere493
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere494
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere495
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere496
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
}
#declare Group63 = union {
  sphere { // Sphere497
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere498
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere499
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere500
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere501
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere502
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere503
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere504
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -10.270803>
  translate  <0.006062, -0.038098, 5.006856>
}
#declare Group64 = union {
  sphere { // Sphere505
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere506
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere507
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere508
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere509
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere510
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere511
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere512
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -19.235001>
  translate  <-0.111263, 0.0, 7.565916>
}
#declare Group65 = union {
  sphere { // Sphere513
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere514
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere515
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere516
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere517
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere518
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere519
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere520
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, 9.616993>
  translate  <-0.111263, 0.0, 10.124976>
}
#declare Group66 = union {
  sphere { // Sphere521
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere522
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere523
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere524
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere525
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere526
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere527
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere528
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -26.79118>
  translate  <-0.222527, 0.0, 8.678551>
}
#declare Group67 = union {
  sphere { // Sphere529
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere530
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere531
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere532
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere533
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere534
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere535
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere536
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -27.888746>
  translate  <0.111263, 0.0, 12.684036>
}
#declare Group68 = union {
  sphere { // Sphere537
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere538
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere539
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere540
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere541
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere542
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere543
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere544
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <-10.689362, -1.89129, -9.917496>
  translate  <-0.111263, -0.063143, 14.684173>
}
#declare Group69 = union {
  sphere { // Sphere545
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere546
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere547
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere548
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere549
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere550
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere551
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere552
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <6.312906, 1.121453, -10.032603>
  translate  <-0.111263, -0.051765, 15.168819>
}
#declare Group70 = union {
  sphere { // Sphere553
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere554
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere555
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere556
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere557
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere558
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere559
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere560
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -10.094448>
  translate  <-0.111263, 0.0, 11.571401>
}
#declare Group71 = union {
  sphere { // Sphere561
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere562
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere563
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere564
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere565
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere566
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere567
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere568
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.2
  rotate <-18.509361, -3.234712, -9.567235>
  translate  <-0.111263, 0.0, 13.797043>
}
#declare NAALDEN3 = union {
  object { Group58 }
  object { Group59 }
  object { Group60 }
  object { Group61 }
  object { Group62 }
  object { Group63 }
  object { Group64 }
  object { Group65 }
  object { Group66 }
  object { Group67 }
  object { Group68 }
  object { Group69 }
  object { Group70 }
  object { Group71 }
  texture {
    Texture6
  }
  rotate <0.0, -0.0, -0.0>
  translate  -0.0*z
}
union { // NAALDBOOM3
  cone { // Cone4
    <0,0,0>, 0.2, <0,0,1>, 0.4
    texture {
      Texture1_5
    }
    scale <0.5, 0.5, 16.0>
    rotate 180.0*x
    translate  <0.0, -0.089026, 15.713739>
  }
  object { NAALDEN3 }
  scale 1.5
  rotate -67.790306*z
  translate  <-5.251703, -22.304805, -4.808479>
}


#declare Group72 = union {
  sphere { // Sphere569
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere570
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere571
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere572
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere573
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere574
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere575
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere576
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -3.712625>
  translate  <-0.111263, 0.0, 6.342018>
}
#declare Group73 = union {
  sphere { // Sphere577
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere578
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere579
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere580
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere581
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere582
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere583
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere584
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -7.798976>
  translate  <0.0, 0.076196, 4.228012>
}
#declare Group74 = union {
  sphere { // Sphere585
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere586
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere587
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere588
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere589
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere590
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere591
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere592
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <0.0, 0.0, -7.548573>
  translate  <-0.111263, 0.0, 2.55906>
}
#declare Group75 = union {
  sphere { // Sphere593
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere594
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere595
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere596
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere597
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere598
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere599
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere600
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <-0.0, 0.0, 25.721674>
  translate  <-0.111263, 0.0, 1.668952>
}
#declare Group76 = union {
  sphere { // Sphere601
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere602
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere603
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere604
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere605
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere606
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere607
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere608
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
}
#declare Group77 = union {
  sphere { // Sphere609
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere610
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere611
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere612
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere613
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere614
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere615
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere616
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -10.270803>
  translate  <0.006062, -0.038098, 5.006856>
}
#declare Group78 = union {
  sphere { // Sphere617
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere618
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere619
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere620
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere621
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere622
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere623
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere624
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -19.235001>
  translate  <-0.111263, 0.0, 7.565916>
}
#declare Group79 = union {
  sphere { // Sphere625
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere626
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere627
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere628
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere629
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere630
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere631
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere632
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, 9.616993>
  translate  <-0.111263, 0.0, 10.124976>
}
#declare Group80 = union {
  sphere { // Sphere633
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere634
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere635
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere636
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere637
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere638
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere639
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere640
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -26.79118>
  translate  <-0.222527, 0.0, 8.678551>
}
#declare Group81 = union {
  sphere { // Sphere641
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere642
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere643
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere644
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere645
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere646
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere647
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere648
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -27.888746>
  translate  <0.111263, 0.0, 12.684036>
}
#declare Group82 = union {
  sphere { // Sphere649
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere650
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere651
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere652
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere653
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere654
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere655
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere656
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <-10.689362, -1.89129, -9.917496>
  translate  <-0.111263, -0.063143, 14.684173>
}
#declare Group83 = union {
  sphere { // Sphere657
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere658
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere659
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere660
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere661
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere662
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere663
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere664
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <6.312906, 1.121453, -10.032603>
  translate  <-0.111263, -0.051765, 15.168819>
}
#declare Group84 = union {
  sphere { // Sphere665
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere666
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere667
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere668
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere669
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere670
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere671
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere672
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -10.094448>
  translate  <-0.111263, 0.0, 11.571401>
}
#declare Group85 = union {
  sphere { // Sphere673
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere674
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere675
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere676
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere677
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere678
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere679
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere680
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.2
  rotate <-18.509361, -3.234712, -9.567235>
  translate  <-0.111263, 0.0, 13.797043>
}
#declare NAALDEN4 = union {
  object { Group72 }
  object { Group73 }
  object { Group74 }
  object { Group75 }
  object { Group76 }
  object { Group77 }
  object { Group78 }
  object { Group79 }
  object { Group80 }
  object { Group81 }
  object { Group82 }
  object { Group83 }
  object { Group84 }
  object { Group85 }
  texture {
    Texture6
  }
  rotate 0.0*x
  translate  -0.0*x
}
union { // NAALDBOOM4
  cone { // Cone5
    <0,0,0>, 0.2, <0,0,1>, 0.4
    texture {
      Texture7
    }
    scale <0.5, 0.5, 16.0>
    rotate 180.0*x
    translate  <-0.0, -0.089026, 15.713739>
  }
  object { NAALDEN4 }
  rotate -5.273328*x
  translate  <-53.139986, -45.399416, 5.723049>
}


#declare blad21 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-0.394316, 0.301031, 3.509469>, <-0.389451, -1.677396, 3.511009>, <-0.117341, -1.636578, 3.597142>, <-0.122206, 0.341851, 3.595602>,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-0.122206, 0.341851, 3.595602>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 0.301031, 3.509469>,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 0.301031, 4.764088>, <-3.148500, -1.677396, 4.766685>, <-2.912802, -1.636578, 4.911914>, <-2.917016, 0.341851, 4.909318>,
      <-5.911110, 0.301031, 6.018708>, <-5.907548, -1.677396, 6.022361>, <-5.708263, -1.636578, 6.226686>, <-5.711826, 0.341851, 6.223033>,
      <-7.502055, 0.301031, 7.873211>, <-7.498420, -1.677396, 7.876791>, <-7.295101, -1.636578, 8.077102>, <-7.298736, 0.341851, 8.073521>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 0.341851, 4.909318>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 0.301031, 4.764088>,
      <-5.711826, 0.341851, 6.223033>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 0.301031, 6.018708>,
      <-7.298736, 0.341851, 8.073521>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 0.301031, 7.873211>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_4
  }
  scale 0.3
  rotate <0.0, 0.0, 82.996483>
  translate  <-0.757446, -0.139264, -11.81958>
}
#declare blad22 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.727662, 1.481150>, <-0.087079, -0.824135, 1.841420>, <0.198338, -0.789571, 1.819707>, <0.193235, 0.765354, 1.470293>,
      <-0.394316, 1.363371, 3.686629>, <-0.389451, 0.447284, 3.865330>, <-0.117341, 0.527667, 3.916553>, <-0.122206, 1.423973, 3.755307>,
      <-3.152713, 1.734137, 4.833607>, <-3.148500, 1.115236, 4.928609>, <-2.912802, 1.227054, 5.029873>, <-2.917016, 1.811378, 4.955959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.765354, 1.470293>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.727662, 1.481150>,
      <-0.122206, 1.423973, 3.755307>, <-0.127070, 2.320280, 3.594062>, <-0.399180, 2.279458, 3.507929>, <-0.394316, 1.363371, 3.686629>,
      <-2.917016, 1.811378, 4.955959>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 1.734137, 4.833607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.152713, 1.734137, 4.833607>, <-3.148500, 1.115236, 4.928609>, <-2.912802, 1.227054, 5.029873>, <-2.917016, 1.811378, 4.955959>,
      <-5.911110, 2.031323, 6.003472>, <-5.907548, 1.783188, 5.991888>, <-5.708263, 1.926442, 6.143193>, <-5.711826, 2.123361, 6.181287>,
      <-7.502055, 2.524552, 7.715905>, <-7.498420, 2.769645, 7.562180>, <-7.295101, 2.910763, 7.710086>, <-7.298736, 2.615522, 7.890013>,
      <-8.221841, 0.321312, 10.478016>, <-8.220007, 0.308805, 10.479451>, <-8.117445, 0.309063, 10.559748>, <-8.119278, 0.321570, 10.558313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.917016, 1.811378, 4.955959>, <-2.921229, 2.320280, 4.906721>, <-3.156927, 2.279458, 4.761492>, <-3.152713, 1.734137, 4.833607>,
      <-5.711826, 2.123361, 6.181287>, <-5.715388, 2.320280, 6.219380>, <-5.914673, 2.279458, 6.015056>, <-5.911110, 2.031323, 6.003472>,
      <-7.298736, 2.615522, 7.890013>, <-7.302370, 2.320280, 8.069940>, <-7.505689, 2.279458, 7.869630>, <-7.502055, 2.524552, 7.715905>,
      <-8.119278, 0.321570, 10.558313>, <-8.121112, 0.334078, 10.556877>, <-8.223674, 0.333820, 10.476580>, <-8.221841, 0.321312, 10.478016>
    }
  }
  texture {
    Texture4_4
  }
  scale 0.5
  translate  <-1.21971, -0.189983, -10.76616>
}
#declare blad23 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, 0.313277, -1.318681>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, 0.329605, -1.318681>,
      <-0.092182, 0.301031, 1.120879>, <-0.087079, -1.677396, 1.120879>, <0.198338, -1.636578, 1.120879>, <0.193235, 0.341851, 1.120879>,
      <-1.863739, 0.301031, 4.514863>, <-1.858874, -1.677396, 4.516403>, <-1.586764, -1.636578, 4.602536>, <-1.591628, 0.341851, 4.600997>,
      <-2.069980, 0.301031, 2.173264>, <-2.065767, -1.677396, 2.175860>, <-1.830070, -1.636578, 2.321089>, <-1.834283, 0.341851, 2.318493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, 0.329605, -1.318681>, <0.188133, 1.120976, -1.318681>, <-0.097284, 1.104648, -1.318681>, <-0.092182, 0.313277, -1.318681>,
      <0.193235, 0.341851, 1.120879>, <0.188133, 2.320280, 1.120879>, <-0.097284, 2.279458, 1.120879>, <-0.092182, 0.301031, 1.120879>,
      <-1.591628, 0.341851, 4.600997>, <-1.596493, 2.320280, 4.599457>, <-1.868603, 2.279458, 4.513324>, <-1.863739, 0.301031, 4.514863>,
      <-1.834283, 0.341851, 2.318493>, <-1.838497, 2.320280, 2.315897>, <-2.074194, 2.279458, 2.170668>, <-2.069980, 0.301031, 2.173264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.069980, 0.301031, 2.173264>, <-2.065767, -1.677396, 2.175860>, <-1.830070, -1.636578, 2.321089>, <-1.834283, 0.341851, 2.318493>,
      <-2.276222, 0.301031, -0.168336>, <-2.272660, -1.677396, -0.164683>, <-2.073375, -1.636578, 0.039642>, <-2.076938, 0.341851, 0.035989>,
      <-3.867167, 0.301031, 1.686167>, <-3.863532, -1.677396, 1.689748>, <-3.660213, -1.636578, 1.890058>, <-3.663848, 0.341851, 1.886478>,
      <-4.818967, 0.321312, 1.893493>, <-4.817133, 0.308805, 1.894928>, <-4.714571, 0.309063, 1.975225>, <-4.716404, 0.321570, 1.973790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.834283, 0.341851, 2.318493>, <-1.838497, 2.320280, 2.315897>, <-2.074194, 2.279458, 2.170668>, <-2.069980, 0.301031, 2.173264>,
      <-2.076938, 0.341851, 0.035989>, <-2.080500, 2.320280, 0.032337>, <-2.279785, 2.279458, -0.171988>, <-2.276222, 0.301031, -0.168336>,
      <-3.663848, 0.341851, 1.886478>, <-3.667482, 2.320280, 1.882897>, <-3.870801, 2.279458, 1.682586>, <-3.867167, 0.301031, 1.686167>,
      <-4.716404, 0.321570, 1.973790>, <-4.718238, 0.334078, 1.972354>, <-4.820800, 0.333820, 1.892057>, <-4.818967, 0.321312, 1.893493>
    }
  }
  texture {
    Texture4_4
  }
  scale <1.0, 0.5, 1.0>
  rotate 173.0*z
  translate  <-0.834792, 0.253424, -10.980845>
}
#declare Group86 = union {
  sphere { // Sphere681
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere682
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere683
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere684
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere685
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere686
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere687
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere688
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture1_2
  }
  rotate <-90.0, 70.0, -90.0>
}
#declare Group87 = union {
  sphere { // Sphere697
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere698
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere699
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere700
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere701
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere702
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere703
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere704
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  texture {
    Texture1_2
  }
}
#declare Group88 = union {
  sphere { // Sphere689
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 135.0>
    translate  <-1.298111, 1.292586, -0.391216>
  }
  sphere { // Sphere690
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -135.0>
    translate  <-1.259289, -1.269647, -0.391216>
  }
  sphere { // Sphere691
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, 45.0>
    translate  <1.279578, 1.194789, -0.391216>
  }
  sphere { // Sphere692
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -45.0>
    translate  <1.317501, -1.305164, -0.391216>
  }
  sphere { // Sphere693
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, 90.0>
    translate  <-0.026485, -1.87889, -0.391216>
  }
  sphere { // Sphere694
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, 20.0, -90.0>
    translate  <0.012337, 1.775879, -0.391216>
  }
  sphere { // Sphere695
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate <0.0, -20.0, -180.0>
    translate  <-1.883193, -0.085585, -0.421309>
  }
  sphere { // Sphere696
    <0,0,0>,1
    scale <2.0, 0.5, 0.1>
    rotate -20.0*y
    translate  <1.788216, -0.085585, -0.391216>
  }
  object { Group87 }
  texture {
    Texture1_2
  }
  rotate 90.0*y
}
#declare blad24 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.092182, -0.537441, -1.047998>, <-0.087079, -0.478093, -1.318681>, <0.198338, -0.461766, -1.318681>, <0.193235, -0.521113, -1.047998>,
      <-0.865562, -0.549687, 0.850196>, <-0.860460, -1.677396, 0.579513>, <-0.575043, -1.636578, 0.579513>, <-0.580145, -0.508867, 0.850196>,
      <-2.552094, -0.576890, -0.111593>, <-1.627138, -1.677396, 0.245530>, <-1.391950, -1.636578, 0.407240>, <-1.961815, -0.537150, 0.354021>,
      <-4.711303, -0.588929, 0.453241>, <-3.806012, -1.677396, 1.084487>, <-2.158022, -1.636578, 2.156892>, <-3.644706, -0.549611, 1.599583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193235, -0.521113, -1.047998>, <0.188133, -0.580461, -0.777315>, <-0.097284, -0.596789, -0.777315>, <-0.092182, -0.537441, -1.047998>,
      <-0.580145, -0.508867, 0.850196>, <-0.585247, 0.618843, 1.120879>, <-0.870664, 0.578021, 1.120879>, <-0.865562, -0.549687, 0.850196>,
      <-1.961815, -0.537150, 0.354021>, <-2.531679, 0.562279, 0.300802>, <-3.477050, 0.523615, -0.468717>, <-2.552094, -0.576890, -0.111593>,
      <-3.644706, -0.549611, 1.599583>, <-5.208728, 0.537356, 1.119613>, <-5.693932, 0.499539, -0.100668>, <-4.711303, -0.588929, 0.453241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.711303, -0.588929, 0.453241>, <-3.806012, -1.677396, 1.084487>, <-2.158022, -1.636578, 2.156892>, <-3.644706, -0.549611, 1.599583>,
      <-6.947851, -0.600967, 1.095413>, <-5.984886, -1.677396, 1.923444>, <-2.924094, -1.636578, 3.906544>, <-5.404936, -0.562072, 2.922484>,
      <-10.161920, -0.609920, 3.000730>, <-9.509209, -1.677396, 3.623199>, <-9.305890, -1.636578, 3.823510>, <-9.995376, -0.570999, 3.228281>,
      <-10.387306, 0.321312, 1.738817>, <-10.385473, 0.308805, 1.740252>, <-10.282910, 0.309063, 1.820549>, <-10.284744, 0.321570, 1.819114>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.644706, -0.549611, 1.599583>, <-5.208728, 0.537356, 1.119613>, <-5.693932, 0.499539, -0.100668>, <-4.711303, -0.588929, 0.453241>,
      <-5.404936, -0.562072, 2.922484>, <-7.885777, 0.512434, 1.938423>, <-7.910815, 0.475462, 0.267381>, <-6.947851, -0.600967, 1.095413>,
      <-9.995376, -0.570999, 3.228281>, <-10.684862, 0.494581, 2.633052>, <-10.814631, 0.457556, 2.378261>, <-10.161920, -0.609920, 3.000730>,
      <-10.284744, 0.321570, 1.819114>, <-10.286577, 0.334078, 1.817678>, <-10.389140, 0.333820, 1.737381>, <-10.387306, 0.321312, 1.738817>
    }
  }
  texture {
    Texture4_4
  }
  scale <1.0, 0.5, 1.0>
  rotate <0.0, -0.0, -100.0>
  translate  <-1.074794, 0.054329, -10.984257>
}
union { // bloemMwit1
  object { blad21 }
  sphere { // bloemknop5
    <0,0,0>,1
    texture {
      Texture3_4
    }
    scale <0.4, 0.6, 0.6>
    translate  <-0.942432, -0.163512, -0.071795>
  }
  cylinder { // stengel5
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture4_4
    }
    scale <0.2, 0.2, 12.6>
    translate  <-0.93634, -0.173648, -12.305768>
  }
  object { blad22 }
  sphere { // knop5
    <0,0,0>,1
    texture {
      Texture2_5
    }
    scale <1.2, 1.2, 0.2>
    rotate 90.0*y
    translate  <-0.556193, 0.0, -0.035568>
  }
  object { blad23 }
  object { Group86 }
  object { Group88 }
  object { blad24 }
  scale 0.4
  rotate 106.926407*z
  translate  <-47.985028, -29.01805, 3.549478>
}


sphere { // lelie1
  <0,0,0>,1
  texture {
    Green_Vein_Pistachio_Plastic
  }
  scale <2.0, 2.0, 0.2>
  rotate 0.225502*x
  translate  <-26.348307, -3.171889, -8.15395>
}


sphere { // lelie2
  <0,0,0>,1
  texture {
    Green_Vein_Pistachio_Plastic
  }
  scale <1.5, 1.5, 0.2>
  rotate 0.225502*x
  translate  <-21.421063, -10.677398, -8.041087>
}


#declare BezPtch8 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
}
#declare BezPtch7 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate 45.0*z
  translate  <-0.503726, -0.171481, 0.0>
}
#declare BezPtch6 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate 135.0*z
  translate  <-0.482291, -1.168216, 0.0>
}
#declare BezPtch5 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -135.0*z
  translate  <0.525161, -1.168216, 0.0>
}
#declare BezPtch4 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -45.0*z
  translate  <0.493009, -0.203634, 0.0>
}
#declare BezPtch3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate 90.0*z
  translate  <-0.696643, -0.696643, 0.0>
}
#declare BezPtch9 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -90.0*z
  translate  <0.713876, -0.677967, 0.0>
}
#declare BezPtch10 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -179.112*z
  translate  <0.023313, -1.368609, 0.0>
}
#declare bladeren = union {
  object { BezPtch8 }
  object { BezPtch7 }
  object { BezPtch6 }
  object { BezPtch5 }
  object { BezPtch4 }
  object { BezPtch3 }
  object { BezPtch9 }
  object { BezPtch10 }
  texture {
    Texture3_6
  }
}
union { // leliebloem
  object { bladeren }
  cylinder { // steel
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture1_10
    }
    scale <0.2, 0.2, 3.0>
    translate  <0.005678, -0.704461, 0.0>
  }
  sphere { // knop6
    <0,0,0>,1
    texture {
      Texture2_12
    }
    scale <1.5, 1.2, 1.2>
    translate  <-0.024921, -0.695423, 3.106571>
  }
  scale 0.7
  translate  <-24.060433, 0.976793, -9.130592>
}


sphere { // lelie3
  <0,0,0>,1
  texture {
    Green_Vein_Pistachio_Plastic
  }
  scale <1.5, 1.5, 0.2>
  rotate 0.225502*x
  translate  <-11.807879, -4.970898, -8.10222>
}


sphere { // lelie4
  <0,0,0>,1
  texture {
    Green_Vein_Pistachio_Plastic
  }
  scale <1.2, 1.4, 0.2>
  rotate 0.225502*x
  translate  <-24.979787, -10.62846, -8.163353>
}


#declare BezPtch11 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
}
#declare BezPtch12 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate 45.0*z
  translate  <-0.503726, -0.171481, 0.0>
}
#declare BezPtch13 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate 135.0*z
  translate  <-0.482291, -1.168216, 0.0>
}
#declare BezPtch14 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -135.0*z
  translate  <0.525161, -1.168216, 0.0>
}
#declare BezPtch15 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -45.0*z
  translate  <0.493009, -0.203634, 0.0>
}
#declare BezPtch16 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate 90.0*z
  translate  <-0.696643, -0.696643, 0.0>
}
#declare BezPtch17 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -90.0*z
  translate  <0.713876, -0.677967, 0.0>
}
#declare BezPtch18 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -179.112*z
  translate  <0.023313, -1.368609, 0.0>
}
#declare bladeren1 = union {
  object { BezPtch11 }
  object { BezPtch12 }
  object { BezPtch13 }
  object { BezPtch14 }
  object { BezPtch15 }
  object { BezPtch16 }
  object { BezPtch17 }
  object { BezPtch18 }
  texture {
    Texture3_6
  }
}
union { // leliebloem1
  object { bladeren1 }
  cylinder { // steel1
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture1_10
    }
    scale <0.2, 0.2, 3.0>
    translate  <0.005678, -0.704461, 0.0>
  }
  sphere { // knop7
    <0,0,0>,1
    texture {
      Texture2_12
    }
    scale <1.5, 1.2, 1.2>
    translate  <-0.024921, -0.695423, 3.106571>
  }
  scale 0.6
  translate  <-30.61091, -6.549653, -8.733563>
}


#declare BezPtch19 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
}
#declare BezPtch20 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate 45.0*z
  translate  <-0.503726, -0.171481, 0.0>
}
#declare BezPtch21 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate 135.0*z
  translate  <-0.482291, -1.168216, 0.0>
}
#declare BezPtch22 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -135.0*z
  translate  <0.525161, -1.168216, 0.0>
}
#declare BezPtch23 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -45.0*z
  translate  <0.493009, -0.203634, 0.0>
}
#declare BezPtch24 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate 90.0*z
  translate  <-0.696643, -0.696643, 0.0>
}
#declare BezPtch25 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -90.0*z
  translate  <0.713876, -0.677967, 0.0>
}
#declare BezPtch26 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491377, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.762704, 0.951049>, <0.000000, -0.491375, 0.951049>,
      <-1.000000, 1.822842, 1.492774>, <-1.000000, 1.551515, 1.492774>, <1.000000, 1.551515, 1.492774>, <1.000000, 1.822844, 1.492774>,
      <-1.000000, 1.822842, 3.492774>, <-1.000000, 1.551515, 3.492774>, <1.000000, 1.551515, 3.492774>, <1.000000, 1.822844, 3.492774>,
      <-0.004715, 0.919346, 5.682984>, <-0.004715, 0.917803, 5.682984>, <0.004715, 0.917803, 5.682984>, <0.004715, 0.919346, 5.682984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.491375, 0.951049>, <0.000000, -0.220047, 0.951049>, <0.000000, -0.220050, 0.951049>, <0.000000, -0.491377, 0.951049>,
      <1.000000, 1.822844, 1.492774>, <1.000000, 2.094172, 1.492774>, <-1.000000, 2.094169, 1.492774>, <-1.000000, 1.822842, 1.492774>,
      <1.000000, 1.822844, 3.492774>, <1.000000, 2.094172, 3.492774>, <-1.000000, 2.094169, 3.492774>, <-1.000000, 1.822842, 3.492774>,
      <0.004715, 0.919346, 5.682984>, <0.004715, 0.920890, 5.682984>, <-0.004715, 0.920890, 5.682984>, <-0.004715, 0.919346, 5.682984>
    }
  }
  rotate -179.112*z
  translate  <0.023313, -1.368609, 0.0>
}
#declare bladeren2 = union {
  object { BezPtch19 }
  object { BezPtch20 }
  object { BezPtch21 }
  object { BezPtch22 }
  object { BezPtch23 }
  object { BezPtch24 }
  object { BezPtch25 }
  object { BezPtch26 }
  texture {
    Texture3_6
  }
}
union { // leliebloem2
  object { bladeren2 }
  cylinder { // steel2
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture1_10
    }
    scale <0.2, 0.2, 3.0>
    translate  <0.005678, -0.704461, 0.0>
  }
  sphere { // knop8
    <0,0,0>,1
    texture {
      Texture2_12
    }
    scale <1.5, 1.2, 1.2>
    translate  <-0.024921, -0.695423, 3.106571>
  }
  scale 0.7
  rotate -16.958612*z
  translate  <-25.632216, -6.843563, -8.898155>
}


#declare rechter_oog = union {
  sphere { // oogMrechts
    <0,0,0>,1
    texture {
      Texture2_11
    }
    scale <0.6, 0.3, 0.8>
    translate  <1.594061, -0.716434, 1.707139>
  }
  sphere { // pupilMrechts
    <0,0,0>,1
    texture {
      Texture3
    }
    scale <0.3, 0.2, 0.5>
    translate  <1.599925, -0.889277, 1.555201>
  }
}
#declare linker_oog = union {
  sphere { // oogMlinks
    <0,0,0>,1
    texture {
      Texture2_11
    }
    scale <0.6, 0.3, 0.8>
    translate  <-1.61429, -0.779957, 1.666003>
  }
  sphere { // pupilMlinks
    <0,0,0>,1
    texture {
      Texture3
    }
    scale <0.3, 0.2, 0.5>
    translate  <-1.678664, -0.928959, 1.604573>
  }
}
#declare lijf = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 3,
      <0.077513, 0.000000, 0.003107>, <0.077513, -0.001803, 0.003107>, <0.077510, -0.003278, 0.001632>, <0.077506, -0.003278, -0.000171>,
      <0.424018, 0.000000, 0.689039>, <0.424018, -0.379486, 0.689039>, <0.423332, -0.689975, 0.378551>, <0.422493, -0.689975, -0.000934>,
      <1.002209, 0.000000, 0.997786>, <1.002209, -0.550000, 0.997786>, <1.001214, -1.000000, 0.547787>, <1.040296, -1.000000, 0.279880>,
      <1.502208, 0.000000, 0.996681>, <1.502208, -0.550000, 0.996681>, <1.558968, -0.882089, 0.504403>, <1.578045, -0.882089, 0.160301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 3,
      <0.077506, -0.003278, -0.000171>, <0.077502, -0.003278, -0.001974>, <0.077499, -0.001803, -0.003450>, <0.077499, 0.000000, -0.003450>,
      <0.422493, -0.689975, -0.000934>, <0.421654, -0.689975, -0.380420>, <0.501564, -0.379486, -0.126726>, <0.501564, 0.000000, -0.126726>,
      <1.040296, -1.000000, 0.279880>, <1.079379, -1.000000, 0.011972>, <1.078384, -0.550000, -0.438027>, <1.078384, 0.000000, -0.438027>,
      <1.578045, -0.882089, 0.160301>, <1.597121, -0.882089, -0.183802>, <1.578383, -0.550000, -0.439133>, <1.578383, 0.000000, -0.439133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 3,
      <0.077499, 0.000000, -0.003450>, <0.077499, 0.001803, -0.003450>, <0.077502, 0.003278, -0.001974>, <0.077506, 0.003278, -0.000171>,
      <0.501564, 0.000000, -0.126726>, <0.501564, 0.379486, -0.126726>, <0.421654, 0.689975, -0.380420>, <0.422493, 0.689975, -0.000934>,
      <1.078384, 0.000000, -0.438027>, <1.078384, 0.550000, -0.438027>, <1.079379, 1.000000, 0.011972>, <1.040296, 1.000000, 0.279880>,
      <1.578383, 0.000000, -0.439133>, <1.578383, 0.550000, -0.439133>, <1.597121, 0.882089, -0.183802>, <1.578045, 0.882089, 0.160301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 3,
      <0.077506, 0.003278, -0.000171>, <0.077510, 0.003278, 0.001632>, <0.077513, 0.001803, 0.003107>, <0.077513, 0.000000, 0.003107>,
      <0.422493, 0.689975, -0.000934>, <0.423332, 0.689975, 0.378551>, <0.424018, 0.379486, 0.689039>, <0.424018, 0.000000, 0.689039>,
      <1.040296, 1.000000, 0.279880>, <1.001214, 1.000000, 0.547787>, <1.002209, 0.550000, 0.997786>, <1.002209, 0.000000, 0.997786>,
      <1.578045, 0.882089, 0.160301>, <1.558968, 0.882089, 0.504403>, <1.502208, 0.550000, 0.996681>, <1.502208, 0.000000, 0.996681>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 3,
      <1.502208, 0.000000, 0.996681>, <1.502208, -0.550000, 0.996681>, <1.558968, -0.882089, 0.504403>, <1.578045, -0.882089, 0.160301>,
      <2.002206, 0.000000, 0.995575>, <2.002206, -0.550000, 0.995575>, <2.116723, -0.764179, 0.461019>, <2.115794, -0.764179, 0.040721>,
      <2.502205, 0.000000, 0.994470>, <2.502205, -0.550000, 0.994470>, <2.498811, -0.764179, 0.460174>, <2.457583, -0.764179, 0.080175>,
      <2.948472, 0.000000, 1.154559>, <2.948472, -0.550000, 1.154559>, <2.839839, -0.764179, 0.582511>, <2.841028, -0.764179, 0.593974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 3,
      <1.578045, -0.882089, 0.160301>, <1.597121, -0.882089, -0.183802>, <1.578383, -0.550000, -0.439133>, <1.578383, 0.000000, -0.439133>,
      <2.115794, -0.764179, 0.040721>, <2.114864, -0.764179, -0.379576>, <2.078381, -0.550000, -0.440238>, <2.078381, 0.000000, -0.440238>,
      <2.457583, -0.764179, 0.080175>, <2.416355, -0.764179, -0.299823>, <2.497783, -0.550000, -0.360747>, <2.497783, 0.000000, -0.360747>,
      <2.841028, -0.764179, 0.593974>, <2.842217, -0.764179, 0.605437>, <2.826628, -0.550000, 0.429412>, <2.826628, 0.000000, 0.429412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 3,
      <1.578383, 0.000000, -0.439133>, <1.578383, 0.550000, -0.439133>, <1.597121, 0.882089, -0.183802>, <1.578045, 0.882089, 0.160301>,
      <2.078381, 0.000000, -0.440238>, <2.078381, 0.550000, -0.440238>, <2.114864, 0.764179, -0.379576>, <2.115794, 0.764179, 0.040721>,
      <2.497783, 0.000000, -0.360747>, <2.497783, 0.550000, -0.360747>, <2.416355, 0.764179, -0.299823>, <2.457583, 0.764179, 0.080175>,
      <2.826628, 0.000000, 0.429412>, <2.826628, 0.550000, 0.429412>, <2.842217, 0.764179, 0.605437>, <2.841028, 0.764179, 0.593974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 3,
      <1.578045, 0.882089, 0.160301>, <1.558968, 0.882089, 0.504403>, <1.502208, 0.550000, 0.996681>, <1.502208, 0.000000, 0.996681>,
      <2.115794, 0.764179, 0.040721>, <2.116723, 0.764179, 0.461019>, <2.002206, 0.550000, 0.995575>, <2.002206, 0.000000, 0.995575>,
      <2.457583, 0.764179, 0.080175>, <2.498811, 0.764179, 0.460174>, <2.502205, 0.550000, 0.994470>, <2.502205, 0.000000, 0.994470>,
      <2.841028, 0.764179, 0.593974>, <2.839839, 0.764179, 0.582511>, <2.948472, 0.550000, 1.154559>, <2.948472, 0.000000, 1.154559>
    }
  }
  texture {
    kikkerMvel
  }
  scale 3.2
  rotate <0.0, 0.0, -90.0>
  translate  <-0.033775, 11.484875, -2.304248>
}
#declare kopMtotaal = difference {
  superellipsoid { // kop
    <1.0, 1.0>
    texture {
      kikkerMvel
    }
    scale <3.0, 3.0, 2.0>
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 0.0, 0.0>
  }
  sphere { // bek
    <0,0,0>,1
    texture {
      Texture4
    }
    scale <2.0, 1.0, 0.2>
    rotate <0.0, -0.0, -0.0>
    translate  <0.034155, -2.300755, -0.44899>
  }
  cylinder { // neusgat1
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture3
    }
    scale <0.2, 0.2, 1.0>
    rotate <45.0, -0.0, -0.0>
    translate  <0.945291, -2.238882, 0.393209>
  }
  cylinder { // neusgat2
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture3
    }
    scale <0.2, 0.2, 1.0>
    rotate <45.0, -0.0, -0.0>
    translate  <-1.069634, -2.238882, 0.393209>
  }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, -0.0, 0.0>
}
#declare BezPtch001 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -0.550000, 0.000000>, <-0.550000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>,
      <-1.000000, 0.000000, 0.500000>, <-1.000000, -0.550000, 0.500000>, <-0.550000, -1.000000, 0.500000>, <0.000000, -1.000000, 0.500000>,
      <-1.026075, 0.032885, 1.631512>, <-1.026075, -0.467563, 1.403361>, <-0.576096, -0.875205, 1.212713>, <-0.026122, -0.872988, 1.207849>,
      <-1.021215, -0.174515, 2.086442>, <-1.021215, -0.674962, 1.858292>, <-0.571236, -1.082605, 1.667644>, <-0.021262, -1.080387, 1.662780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.000000, 0.000000>, <0.550000, -1.000000, 0.000000>, <1.000000, -0.550000, 0.000000>, <1.000000, 0.000000, 0.000000>,
      <0.000000, -1.000000, 0.500000>, <0.550000, -1.000000, 0.500000>, <1.000000, -0.550000, 0.500000>, <1.000000, 0.000000, 0.500000>,
      <-0.026122, -0.872988, 1.207849>, <0.523852, -0.870770, 1.202985>, <0.973831, -0.459499, 1.385673>, <0.973831, 0.040949, 1.613824>,
      <-0.021262, -1.080387, 1.662780>, <0.528712, -1.078169, 1.657915>, <0.978691, -0.666898, 1.840604>, <0.978691, -0.166451, 2.068754>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 0.550000, 0.000000>, <0.550000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>,
      <1.000000, 0.000000, 0.500000>, <1.000000, 0.550000, 0.500000>, <0.550000, 1.000000, 0.500000>, <0.000000, 1.000000, 0.500000>,
      <0.973831, 0.040949, 1.613824>, <0.973831, 0.541396, 1.841974>, <0.523852, 0.949038, 2.032622>, <-0.026122, 0.946821, 2.037486>,
      <0.978691, -0.166451, 2.068754>, <0.978691, 0.333996, 2.296904>, <0.528712, 0.741639, 2.487553>, <-0.021262, 0.739421, 2.492417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.000000, 0.000000>, <-0.550000, 1.000000, 0.000000>, <-1.000000, 0.550000, 0.000000>, <-1.000000, 0.000000, 0.000000>,
      <0.000000, 1.000000, 0.500000>, <-0.550000, 1.000000, 0.500000>, <-1.000000, 0.550000, 0.500000>, <-1.000000, 0.000000, 0.500000>,
      <-0.026122, 0.946821, 2.037486>, <-0.576096, 0.944603, 2.042350>, <-1.026075, 0.533332, 1.859662>, <-1.026075, 0.032885, 1.631512>,
      <-0.021262, 0.739421, 2.492417>, <-0.571236, 0.737204, 2.497281>, <-1.021215, 0.325933, 2.314592>, <-1.021215, -0.174515, 2.086442>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.021215, -0.174515, 2.086442>, <-1.021215, -0.674962, 1.858292>, <-0.571236, -1.082605, 1.667644>, <-0.021262, -1.080387, 1.662780>,
      <-1.016355, -0.381914, 2.541373>, <-1.016355, -0.882362, 2.313223>, <-0.566376, -1.290004, 2.122575>, <-0.016402, -1.287786, 2.117710>,
      <-1.011495, -0.589314, 2.996303>, <-1.011495, -1.089761, 2.768153>, <-0.561516, -1.497403, 2.577505>, <-0.011542, -1.495186, 2.572641>,
      <-1.006635, -0.796713, 3.451234>, <-1.006635, -1.297160, 3.223084>, <-0.556656, -1.704803, 3.032436>, <-0.006682, -1.702585, 3.027571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.021262, -1.080387, 1.662780>, <0.528712, -1.078169, 1.657915>, <0.978691, -0.666898, 1.840604>, <0.978691, -0.166451, 2.068754>,
      <-0.016402, -1.287786, 2.117710>, <0.533572, -1.285569, 2.112846>, <0.983551, -0.874298, 2.295535>, <0.983551, -0.373850, 2.523685>,
      <-0.011542, -1.495186, 2.572641>, <0.538432, -1.492968, 2.567777>, <0.988411, -1.081697, 2.750465>, <0.988411, -0.581250, 2.978615>,
      <-0.006682, -1.702585, 3.027571>, <0.543292, -1.700368, 3.022707>, <0.993270, -1.289097, 3.205396>, <0.993270, -0.788649, 3.433546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.978691, -0.166451, 2.068754>, <0.978691, 0.333996, 2.296904>, <0.528712, 0.741639, 2.487553>, <-0.021262, 0.739421, 2.492417>,
      <0.983551, -0.373850, 2.523685>, <0.983551, 0.126597, 2.751835>, <0.533572, 0.534239, 2.942483>, <-0.016402, 0.532022, 2.947347>,
      <0.988411, -0.581250, 2.978615>, <0.988411, -0.080803, 3.206766>, <0.538432, 0.326840, 3.397414>, <-0.011542, 0.324622, 3.402278>,
      <0.993270, -0.788649, 3.433546>, <0.993270, -0.288202, 3.661696>, <0.543292, 0.119441, 3.852344>, <-0.006682, 0.117223, 3.857209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.021262, 0.739421, 2.492417>, <-0.571236, 0.737204, 2.497281>, <-1.021215, 0.325933, 2.314592>, <-1.021215, -0.174515, 2.086442>,
      <-0.016402, 0.532022, 2.947347>, <-0.566376, 0.529804, 2.952212>, <-1.016355, 0.118533, 2.769523>, <-1.016355, -0.381914, 2.541373>,
      <-0.011542, 0.324622, 3.402278>, <-0.561516, 0.322405, 3.407142>, <-1.011495, -0.088866, 3.224454>, <-1.011495, -0.589314, 2.996303>,
      <-0.006682, 0.117223, 3.857209>, <-0.556656, 0.115005, 3.862073>, <-1.006635, -0.296266, 3.679384>, <-1.006635, -0.796713, 3.451234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.006635, -0.796713, 3.451234>, <-1.006635, -1.297160, 3.223084>, <-0.556656, -1.704803, 3.032436>, <-0.006682, -1.702585, 3.027571>,
      <-1.001775, -1.004113, 3.906165>, <-1.001775, -1.504560, 3.678014>, <-0.551796, -1.912202, 3.487366>, <-0.001822, -1.909985, 3.482502>,
      <-0.996915, -1.211512, 4.361095>, <-0.996915, -1.711959, 4.132945>, <-0.546937, -2.119602, 3.942297>, <0.003037, -2.117384, 3.937433>,
      <-0.992055, -1.418912, 4.816026>, <-0.992055, -1.919359, 4.587876>, <-0.542077, -2.327001, 4.397227>, <0.007897, -2.324784, 4.392363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.006682, -1.702585, 3.027571>, <0.543292, -1.700368, 3.022707>, <0.993270, -1.289097, 3.205396>, <0.993270, -0.788649, 3.433546>,
      <-0.001822, -1.909985, 3.482502>, <0.548152, -1.907767, 3.477638>, <0.998130, -1.496496, 3.660326>, <0.998130, -0.996049, 3.888477>,
      <0.003037, -2.117384, 3.937433>, <0.553011, -2.115167, 3.932568>, <1.002990, -1.703896, 4.115257>, <1.002990, -1.203448, 4.343407>,
      <0.007897, -2.324784, 4.392363>, <0.557871, -2.322566, 4.387499>, <1.007850, -1.911295, 4.570188>, <1.007850, -1.410848, 4.798338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.993270, -0.788649, 3.433546>, <0.993270, -0.288202, 3.661696>, <0.543292, 0.119441, 3.852344>, <-0.006682, 0.117223, 3.857209>,
      <0.998130, -0.996049, 3.888477>, <0.998130, -0.495601, 4.116627>, <0.548152, -0.087959, 4.307275>, <-0.001822, -0.090177, 4.312139>,
      <1.002990, -1.203448, 4.343407>, <1.002990, -0.703001, 4.571557>, <0.553011, -0.295358, 4.762206>, <0.003037, -0.297576, 4.767070>,
      <1.007850, -1.410848, 4.798338>, <1.007850, -0.910400, 5.026488>, <0.557871, -0.502758, 5.217136>, <0.007897, -0.504975, 5.222000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.006682, 0.117223, 3.857209>, <-0.556656, 0.115005, 3.862073>, <-1.006635, -0.296266, 3.679384>, <-1.006635, -0.796713, 3.451234>,
      <-0.001822, -0.090177, 4.312139>, <-0.551796, -0.092394, 4.317003>, <-1.001775, -0.503665, 4.134315>, <-1.001775, -1.004113, 3.906165>,
      <0.003037, -0.297576, 4.767070>, <-0.546937, -0.299794, 4.771934>, <-0.996915, -0.711065, 4.589245>, <-0.996915, -1.211512, 4.361095>,
      <0.007897, -0.504975, 5.222000>, <-0.542077, -0.507193, 5.226865>, <-0.992055, -0.918464, 5.044176>, <-0.992055, -1.418912, 4.816026>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.992055, -1.418912, 4.816026>, <-0.992055, -1.919359, 4.587876>, <-0.542077, -2.327001, 4.397227>, <0.007897, -2.324784, 4.392363>,
      <-0.987196, -1.626311, 5.270956>, <-0.987196, -2.126758, 5.042806>, <-0.537217, -2.534401, 4.852158>, <0.012757, -2.532183, 4.847294>,
      <-1.568816, -2.012532, 6.112677>, <-1.568816, -2.516170, 6.163309>, <-1.118837, -2.929995, 6.203819>, <-0.275623, -2.932143, 6.302725>,
      <-1.563956, -1.811616, 6.217560>, <-1.563956, -2.315254, 6.268193>, <-1.113977, -2.729079, 6.308702>, <-0.270763, -2.731227, 6.584082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.007897, -2.324784, 4.392363>, <0.557871, -2.322566, 4.387499>, <1.007850, -1.911295, 4.570188>, <1.007850, -1.410848, 4.798338>,
      <0.012757, -2.532183, 4.847294>, <0.562731, -2.529966, 4.842430>, <1.012710, -2.118694, 5.025118>, <1.012710, -1.618247, 5.253268>,
      <-0.275623, -2.932143, 6.302725>, <0.567591, -2.934291, 6.401632>, <1.017570, -2.523981, 6.216794>, <1.017570, -2.020344, 5.995776>,
      <-0.270763, -2.731227, 6.584082>, <0.572451, -2.733375, 6.859462>, <0.578607, -2.323066, 6.991641>, <0.800518, -1.819428, 6.612115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.007850, -1.410848, 4.798338>, <1.007850, -0.910400, 5.026488>, <0.557871, -0.502758, 5.217136>, <0.007897, -0.504975, 5.222000>,
      <1.012710, -1.618247, 5.253268>, <1.012710, -1.117800, 5.481419>, <0.562731, -0.710157, 5.672067>, <0.012757, -0.712375, 5.676931>,
      <1.017570, -2.020344, 5.995776>, <1.017570, -1.516706, 5.774758>, <0.567591, -0.917557, 6.126997>, <-0.275623, -0.919774, 6.133943>,
      <0.800518, -1.819428, 6.612115>, <1.022430, -1.315790, 6.232589>, <0.572451, -0.901965, 6.055761>, <-0.270763, -0.899817, 6.090172>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.007897, -0.504975, 5.222000>, <-0.542077, -0.507193, 5.226865>, <-0.992055, -0.918464, 5.044176>, <-0.992055, -1.418912, 4.816026>,
      <0.012757, -0.712375, 5.676931>, <-0.537217, -0.714592, 5.681795>, <-0.987196, -1.125864, 5.499107>, <-0.987196, -1.626311, 5.270956>,
      <-0.275623, -0.919774, 6.133943>, <-1.118837, -0.921992, 6.140889>, <-1.568816, -1.508894, 6.062044>, <-1.568816, -2.012532, 6.112677>,
      <-0.270763, -0.899817, 6.090172>, <-1.113977, -0.897668, 6.124584>, <-1.563956, -1.307978, 6.166928>, <-1.563956, -1.811616, 6.217560>
    }
  }
  translate  <-2.935799, 6.334376, -3.66498>
}
#declare CSG3 = difference {
  sphere { // voetMlinks2
    <0,0,0>,1
    texture {
      Texture1_9
    }
    scale <2.0, 3.0, 0.2>
    translate  <-2.961321, 7.19209, -3.671609>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    rotate -43.621658*z
    translate  <-4.21963, 5.804696, -3.95309>
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    rotate 40.026978*z
    translate  <-1.62288, 5.774165, -3.95309>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    translate  <-2.999925, 4.869838, -3.95309>
  }
  rotate <0.0, 0.0, -180.0>
  translate  <-5.862048, 13.179088, -0.107345>
}
#declare voorpoot_links = union {
  object { BezPtch001 }
  object { CSG3 }
  texture {
    kikkerMvel
  }
  scale 0.5
  rotate <0.0, -0.0, 180.0>
  translate  <-3.848417, 5.732833, -2.563316>
}
#declare CSG001 = difference {
  sphere { // voetMlinks
    <0,0,0>,1
    texture {
      kikkerMvel
    }
    scale <2.0, 3.0, 0.2>
    translate  <-2.961321, 7.19209, -3.671609>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    rotate -43.621658*z
    translate  <-4.21963, 5.804696, -3.95309>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    rotate 40.026978*z
    translate  <-1.62288, 5.774165, -3.95309>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    translate  <-2.999925, 4.869838, -3.95309>
  }
}
#declare pootMlinks = union {
  sphere { // bilMlinks
    <0,0,0>,1
    texture {
      kikkerMvel
    }
    scale <1.0, 2.0, 3.0>
    translate  <-2.991611, 8.057945, -0.74143>
  }
  object { CSG001 }
  texture {
    kikkerMvel
  }
  rotate <0.0, -0.0, -0.0>
  translate  <0.13352, 0.005921, -0.609896>
}
#declare CSG2 = difference {
  sphere { // voetMlinks1
    <0,0,0>,1
    texture {
      Texture1_9
    }
    scale <2.0, 3.0, 0.2>
    translate  <-2.961321, 7.19209, -3.671609>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    rotate -43.621658*z
    translate  <-4.21963, 5.804696, -3.95309>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    rotate 40.026978*z
    translate  <-1.62288, 5.774165, -3.95309>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    translate  <-2.999925, 4.869838, -3.95309>
  }
  texture {
    kikkerMvel
  }
}
#declare pootMrechts = union {
  sphere { // bilMlinks1
    <0,0,0>,1
    texture {
      kikkerMvel
    }
    scale <1.0, 2.0, 3.0>
    translate  <-2.991611, 8.057945, -0.74143>
  }
  object { CSG2 }
  texture {
    kikkerMvel
  }
  rotate <0.0, -0.0, -0.0>
  translate  <5.290812, 0.519647, -0.553155>
}
#declare BezPtch2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -0.550000, 0.000000>, <-0.550000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>,
      <-1.000000, 0.000000, 0.500000>, <-1.000000, -0.550000, 0.500000>, <-0.550000, -1.000000, 0.500000>, <0.000000, -1.000000, 0.500000>,
      <-1.026075, 0.032885, 1.631512>, <-1.026075, -0.467563, 1.403361>, <-0.576096, -0.875205, 1.212713>, <-0.026122, -0.872988, 1.207849>,
      <-1.021215, -0.174515, 2.086442>, <-1.021215, -0.674962, 1.858292>, <-0.571236, -1.082605, 1.667644>, <-0.021262, -1.080387, 1.662780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.000000, 0.000000>, <0.550000, -1.000000, 0.000000>, <1.000000, -0.550000, 0.000000>, <1.000000, 0.000000, 0.000000>,
      <0.000000, -1.000000, 0.500000>, <0.550000, -1.000000, 0.500000>, <1.000000, -0.550000, 0.500000>, <1.000000, 0.000000, 0.500000>,
      <-0.026122, -0.872988, 1.207849>, <0.523852, -0.870770, 1.202985>, <0.973831, -0.459499, 1.385673>, <0.973831, 0.040949, 1.613824>,
      <-0.021262, -1.080387, 1.662780>, <0.528712, -1.078169, 1.657915>, <0.978691, -0.666898, 1.840604>, <0.978691, -0.166451, 2.068754>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 0.550000, 0.000000>, <0.550000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>,
      <1.000000, 0.000000, 0.500000>, <1.000000, 0.550000, 0.500000>, <0.550000, 1.000000, 0.500000>, <0.000000, 1.000000, 0.500000>,
      <0.973831, 0.040949, 1.613824>, <0.973831, 0.541396, 1.841974>, <0.523852, 0.949038, 2.032622>, <-0.026122, 0.946821, 2.037486>,
      <0.978691, -0.166451, 2.068754>, <0.978691, 0.333996, 2.296904>, <0.528712, 0.741639, 2.487553>, <-0.021262, 0.739421, 2.492417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.000000, 0.000000>, <-0.550000, 1.000000, 0.000000>, <-1.000000, 0.550000, 0.000000>, <-1.000000, 0.000000, 0.000000>,
      <0.000000, 1.000000, 0.500000>, <-0.550000, 1.000000, 0.500000>, <-1.000000, 0.550000, 0.500000>, <-1.000000, 0.000000, 0.500000>,
      <-0.026122, 0.946821, 2.037486>, <-0.576096, 0.944603, 2.042350>, <-1.026075, 0.533332, 1.859662>, <-1.026075, 0.032885, 1.631512>,
      <-0.021262, 0.739421, 2.492417>, <-0.571236, 0.737204, 2.497281>, <-1.021215, 0.325933, 2.314592>, <-1.021215, -0.174515, 2.086442>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.021215, -0.174515, 2.086442>, <-1.021215, -0.674962, 1.858292>, <-0.571236, -1.082605, 1.667644>, <-0.021262, -1.080387, 1.662780>,
      <-1.016355, -0.381914, 2.541373>, <-1.016355, -0.882362, 2.313223>, <-0.566376, -1.290004, 2.122575>, <-0.016402, -1.287786, 2.117710>,
      <-1.011495, -0.589314, 2.996303>, <-1.011495, -1.089761, 2.768153>, <-0.561516, -1.497403, 2.577505>, <-0.011542, -1.495186, 2.572641>,
      <-1.006635, -0.796713, 3.451234>, <-1.006635, -1.297160, 3.223084>, <-0.556656, -1.704803, 3.032436>, <-0.006682, -1.702585, 3.027571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.021262, -1.080387, 1.662780>, <0.528712, -1.078169, 1.657915>, <0.978691, -0.666898, 1.840604>, <0.978691, -0.166451, 2.068754>,
      <-0.016402, -1.287786, 2.117710>, <0.533572, -1.285569, 2.112846>, <0.983551, -0.874298, 2.295535>, <0.983551, -0.373850, 2.523685>,
      <-0.011542, -1.495186, 2.572641>, <0.538432, -1.492968, 2.567777>, <0.988411, -1.081697, 2.750465>, <0.988411, -0.581250, 2.978615>,
      <-0.006682, -1.702585, 3.027571>, <0.543292, -1.700368, 3.022707>, <0.993270, -1.289097, 3.205396>, <0.993270, -0.788649, 3.433546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.978691, -0.166451, 2.068754>, <0.978691, 0.333996, 2.296904>, <0.528712, 0.741639, 2.487553>, <-0.021262, 0.739421, 2.492417>,
      <0.983551, -0.373850, 2.523685>, <0.983551, 0.126597, 2.751835>, <0.533572, 0.534239, 2.942483>, <-0.016402, 0.532022, 2.947347>,
      <0.988411, -0.581250, 2.978615>, <0.988411, -0.080803, 3.206766>, <0.538432, 0.326840, 3.397414>, <-0.011542, 0.324622, 3.402278>,
      <0.993270, -0.788649, 3.433546>, <0.993270, -0.288202, 3.661696>, <0.543292, 0.119441, 3.852344>, <-0.006682, 0.117223, 3.857209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.021262, 0.739421, 2.492417>, <-0.571236, 0.737204, 2.497281>, <-1.021215, 0.325933, 2.314592>, <-1.021215, -0.174515, 2.086442>,
      <-0.016402, 0.532022, 2.947347>, <-0.566376, 0.529804, 2.952212>, <-1.016355, 0.118533, 2.769523>, <-1.016355, -0.381914, 2.541373>,
      <-0.011542, 0.324622, 3.402278>, <-0.561516, 0.322405, 3.407142>, <-1.011495, -0.088866, 3.224454>, <-1.011495, -0.589314, 2.996303>,
      <-0.006682, 0.117223, 3.857209>, <-0.556656, 0.115005, 3.862073>, <-1.006635, -0.296266, 3.679384>, <-1.006635, -0.796713, 3.451234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.006635, -0.796713, 3.451234>, <-1.006635, -1.297160, 3.223084>, <-0.556656, -1.704803, 3.032436>, <-0.006682, -1.702585, 3.027571>,
      <-1.001775, -1.004113, 3.906165>, <-1.001775, -1.504560, 3.678014>, <-0.551796, -1.912202, 3.487366>, <-0.001822, -1.909985, 3.482502>,
      <-0.996915, -1.211512, 4.361095>, <-0.996915, -1.711959, 4.132945>, <-0.546937, -2.119602, 3.942297>, <0.003037, -2.117384, 3.937433>,
      <-1.007906, -1.418912, 4.974534>, <-1.007906, -1.919359, 4.746384>, <-0.542077, -2.327001, 4.397227>, <0.007897, -2.324784, 4.392363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.006682, -1.702585, 3.027571>, <0.543292, -1.700368, 3.022707>, <0.993270, -1.289097, 3.205396>, <0.993270, -0.788649, 3.433546>,
      <-0.001822, -1.909985, 3.482502>, <0.548152, -1.907767, 3.477638>, <0.998130, -1.496496, 3.660326>, <0.998130, -0.996049, 3.888477>,
      <0.003037, -2.117384, 3.937433>, <0.553011, -2.115167, 3.932568>, <1.002990, -1.703896, 4.115257>, <1.002990, -1.203448, 4.343407>,
      <0.007897, -2.324784, 4.392363>, <0.557871, -2.322566, 4.387499>, <1.007850, -1.911295, 4.570188>, <1.007850, -1.410848, 4.798338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.993270, -0.788649, 3.433546>, <0.993270, -0.288202, 3.661696>, <0.543292, 0.119441, 3.852344>, <-0.006682, 0.117223, 3.857209>,
      <0.998130, -0.996049, 3.888477>, <0.998130, -0.495601, 4.116627>, <0.548152, -0.087959, 4.307275>, <-0.001822, -0.090177, 4.312139>,
      <1.002990, -1.203448, 4.343407>, <1.002990, -0.703001, 4.571557>, <0.553011, -0.295358, 4.762206>, <0.003037, -0.297576, 4.767070>,
      <1.007850, -1.410848, 4.798338>, <1.007850, -0.910400, 5.026488>, <0.754372, -0.502758, 5.408729>, <0.098222, -0.504975, 5.397051>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.006682, 0.117223, 3.857209>, <-0.556656, 0.115005, 3.862073>, <-1.006635, -0.296266, 3.679384>, <-1.006635, -0.796713, 3.451234>,
      <-0.001822, -0.090177, 4.312139>, <-0.551796, -0.092394, 4.317003>, <-1.001775, -0.503665, 4.134315>, <-1.001775, -1.004113, 3.906165>,
      <0.003037, -0.297576, 4.767070>, <-0.546937, -0.299794, 4.771934>, <-0.996915, -0.711065, 4.589245>, <-0.996915, -1.211512, 4.361095>,
      <0.098222, -0.504975, 5.397051>, <-0.557928, -0.507193, 5.385373>, <-1.007906, -0.918464, 5.202684>, <-1.007906, -1.418912, 4.974534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.007906, -1.418912, 4.974534>, <-1.007906, -1.919359, 4.746384>, <-0.542077, -2.327001, 4.397227>, <0.007897, -2.324784, 4.392363>,
      <-1.018897, -1.626311, 5.587973>, <-1.018897, -2.126758, 5.359823>, <-0.537217, -2.534401, 4.852158>, <0.012757, -2.532183, 4.847294>,
      <-1.118900, -2.012532, 6.504432>, <-1.095647, -2.516170, 6.532033>, <-0.611611, -2.929995, 6.520835>, <0.020039, -2.932143, 6.506099>,
      <-1.062823, -1.811616, 6.554943>, <-1.039569, -2.315254, 6.582544>, <-0.606751, -2.729079, 6.625719>, <-0.054122, -2.731227, 6.667591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.007897, -2.324784, 4.392363>, <0.557871, -2.322566, 4.387499>, <1.007850, -1.911295, 4.570188>, <1.007850, -1.410848, 4.798338>,
      <0.012757, -2.532183, 4.847294>, <0.562731, -2.529966, 4.842430>, <1.012710, -2.118694, 5.025118>, <1.012710, -1.618247, 5.253268>,
      <0.020039, -2.932143, 6.506099>, <0.651689, -2.934291, 6.491364>, <0.828107, -2.523981, 6.484758>, <0.932494, -2.020344, 6.344620>,
      <-0.054122, -2.731227, 6.667591>, <0.498507, -2.733375, 6.709463>, <0.455487, -2.323066, 6.773286>, <0.639750, -1.819428, 6.633207>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.007850, -1.410848, 4.798338>, <1.007850, -0.910400, 5.026488>, <0.754372, -0.502758, 5.408729>, <0.098222, -0.504975, 5.397051>,
      <1.012710, -1.618247, 5.253268>, <1.012710, -1.117800, 5.481419>, <0.955732, -0.710157, 6.055252>, <0.193407, -0.712375, 6.027032>,
      <0.932494, -2.020344, 6.344620>, <1.036881, -1.516706, 6.204483>, <0.744316, -0.917557, 6.361060>, <0.066352, -0.919774, 6.409483>,
      <0.639750, -1.819428, 6.633207>, <0.824012, -1.315790, 6.493128>, <0.769574, -0.901965, 6.328137>, <0.081412, -0.899817, 6.384869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.098222, -0.504975, 5.397051>, <-0.557928, -0.507193, 5.385373>, <-1.007906, -0.918464, 5.202684>, <-1.007906, -1.418912, 4.974534>,
      <0.193407, -0.712375, 6.027032>, <-0.568918, -0.714592, 5.998811>, <-1.018897, -1.125864, 5.816123>, <-1.018897, -1.626311, 5.587973>,
      <0.066352, -0.919774, 6.409483>, <-0.611611, -0.921992, 6.457905>, <-1.142154, -1.508894, 6.476831>, <-1.118900, -2.012532, 6.504432>,
      <0.081412, -0.899817, 6.384869>, <-0.606751, -0.897668, 6.441600>, <-1.086076, -1.307978, 6.527342>, <-1.062823, -1.811616, 6.554943>
    }
  }
  rotate <2.719929, -0.630984, -175.309464>
  translate  <-2.926249, 6.800326, -3.735178>
}
#declare CSG4 = difference {
  sphere { // voetMlinks3
    <0,0,0>,1
    texture {
      Texture1_9
    }
    scale <2.0, 3.0, 0.2>
    rotate <-0.0, -0.0, -0.0>
    translate  <-2.961321, 7.19209, -3.671609>
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    rotate <-0.0, 0.0, -43.621658>
    translate  <-4.21963, 5.804696, -3.95309>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    rotate <0.0, 0.0, 40.026978>
    translate  <-1.62288, 5.774165, -3.95309>
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.8, 0.5>
    rotate <-0.0, -0.0, -0.0>
    translate  <-2.999925, 4.869838, -3.95309>
  }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.0, 0.0>
}
#declare voorpoot_rechts = union {
  object { BezPtch2 }
  object { CSG4 }
  texture {
    kikkerMvel
  }
  scale 0.5
  rotate <0.0, -0.0, -0.0>
  translate  <3.429635, -0.707193, -2.642446>
}
union { // kikker
  object { rechter_oog }
  object { linker_oog }
  object { lijf }
  sphere { // schouderMlinks
    <0,0,0>,1
    texture {
      kikkerMvel
    }
    rotate <0.0, -0.0, -0.0>
    translate  <-1.981644, 3.67863, -1.152722>
  }
  sphere { // schouderMrechts
    <0,0,0>,1
    texture {
      kikkerMvel
    }
    rotate <0.0, -0.0, -0.0>
    translate  <1.939922, 3.672565, -1.074487>
  }
  sphere { // oogkasMrechts
    <0,0,0>,1
    texture {
      kikkerMvel
    }
    rotate <0.0, -0.0, -0.0>
    translate  <1.568125, -0.0, 1.725916>
  }
  sphere { // oogkasMlinks
    <0,0,0>,1
    texture {
      kikkerMvel
    }
    rotate <0.0, -0.0, -0.0>
    translate  <-1.541231, -0.020291, 1.705348>
  }
  object { kopMtotaal }
  object { voorpoot_links }
  object { pootMlinks }
  object { pootMrechts }
  object { voorpoot_rechts }
  scale 0.6
  rotate <-1.736547, -0.411305, 172.313324>
  translate  <-18.223992, -1.612238, -5.211553>
}


#declare Group103 = union {
  sphere { // Sphere818
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere819
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere820
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere821
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere822
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere823
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere824
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere825
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -3.712625>
  translate  <-0.111263, 0.0, 6.342018>
}
#declare Group104 = union {
  sphere { // Sphere826
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere827
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere828
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere829
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere830
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere831
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere832
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere833
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -7.798976>
  translate  <0.0, 0.076196, 4.228012>
}
#declare Group105 = union {
  sphere { // Sphere834
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere835
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere836
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere837
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere838
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere839
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere840
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere841
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <0.0, 0.0, -7.548573>
  translate  <-0.111263, 0.0, 2.55906>
}
#declare Group106 = union {
  sphere { // Sphere842
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere843
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere844
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere845
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere846
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere847
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere848
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere849
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.8
  rotate <-0.0, 0.0, 25.721674>
  translate  <-0.111263, 0.0, 1.668952>
}
#declare Group107 = union {
  sphere { // Sphere850
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere851
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere852
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere853
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere854
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere855
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere856
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere857
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
}
#declare Group108 = union {
  sphere { // Sphere858
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere859
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere860
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere861
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere862
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere863
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere864
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere865
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.56
  rotate <0.080718, -0.609101, -10.270803>
  translate  <0.006062, -0.038098, 5.006856>
}
#declare Group109 = union {
  sphere { // Sphere866
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere867
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere868
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere869
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere870
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere871
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere872
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere873
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -19.235001>
  translate  <-0.111263, 0.0, 7.565916>
}
#declare Group110 = union {
  sphere { // Sphere874
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere875
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere876
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere877
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere878
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere879
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere880
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere881
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, 9.616993>
  translate  <-0.111263, 0.0, 10.124976>
}
#declare Group111 = union {
  sphere { // Sphere882
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere883
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere884
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere885
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere886
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere887
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere888
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere889
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.4
  rotate <-0.0, -0.0, -26.79118>
  translate  <-0.222527, 0.0, 8.678551>
}
#declare Group112 = union {
  sphere { // Sphere890
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere891
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere892
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere893
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere894
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere895
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere896
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere897
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -27.888746>
  translate  <0.111263, 0.0, 12.684036>
}
#declare Group113 = union {
  sphere { // Sphere898
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere899
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere900
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere901
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere902
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere903
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere904
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere905
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <-10.689362, -1.89129, -9.917496>
  translate  <-0.111263, -0.063143, 14.684173>
}
#declare Group114 = union {
  sphere { // Sphere906
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere907
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere908
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere909
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere910
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere911
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere912
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere913
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.1
  rotate <6.312906, 1.121453, -10.032603>
  translate  <-0.111263, -0.051765, 15.168819>
}
#declare Group115 = union {
  sphere { // Sphere914
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere915
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere916
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere917
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere918
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere919
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere920
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere921
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.3
  rotate <-0.0, -0.0, -10.094448>
  translate  <-0.111263, 0.0, 11.571401>
}
#declare Group116 = union {
  sphere { // Sphere922
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-5.121, 0.255708, 134.988571>
    translate  <2.628771, 2.548734, 1.958565>
  }
  sphere { // Sphere923
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.291583, -0.511803, -134.953903>
    translate  <-2.666869, 2.358243, 1.958565>
  }
  sphere { // Sphere924
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-11.289298, -0.560802, 45.055431>
    translate  <2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere925
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-10.831519, 0.53834, -45.051033>
    translate  <-2.552575, -2.708809, 1.958565>
  }
  sphere { // Sphere926
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <-14.202625, -0.0, -90.0>
    translate  <-3.771715, -0.156234, 1.958565>
  }
  sphere { // Sphere927
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate 12.6863*x
    translate  <0.0, 3.655715, 1.958565>
  }
  sphere { // Sphere928
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate <21.106897, 0.0, -90.0>
    translate  <3.649047, -0.046603, 1.958565>
  }
  sphere { // Sphere929
    <0,0,0>,1
    scale <0.2, 4.0, 0.2>
    rotate -12.929847*x
    translate  <0.0, -3.775556, 1.958565>
  }
  scale 0.2
  rotate <-18.509361, -3.234712, -9.567235>
  translate  <-0.111263, 0.0, 13.797043>
}
#declare NAALDEN6 = union {
  object { Group103 }
  object { Group104 }
  object { Group105 }
  object { Group106 }
  object { Group107 }
  object { Group108 }
  object { Group109 }
  object { Group110 }
  object { Group111 }
  object { Group112 }
  object { Group113 }
  object { Group114 }
  object { Group115 }
  object { Group116 }
  texture {
    Texture2_6
  }
}
union { // NAALDBOOM6
  object { NAALDEN6 }
  cone { // Cone7
    <0,0,0>, 0.2, <0,0,1>, 0.4
    texture {
      Texture1_3
    }
    scale <0.5, 0.5, 16.0>
    rotate 180.0*x
    translate  <0.0, -0.089026, 15.713739>
  }
  scale 2.0
  translate  <-70.773537, -38.360238, 1.243953>
}


#declare BezPtch002 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.216685, 0.009011, -2.257436>, <3.216066, -0.133072, -2.254861>, <3.216436, -0.138223, -2.432283>, <3.217055, 0.003861, -2.434858>,
      <3.937827, 0.025414, -1.229621>, <3.937208, -0.116669, -1.227046>, <3.937578, -0.121820, -1.404468>, <3.938197, 0.020264, -1.407043>,
      <5.269569, 0.016705, -0.026609>, <5.268950, -0.125377, -0.024035>, <5.269320, -0.130528, -0.201456>, <5.269939, 0.011555, -0.204031>,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.217055, 0.003861, -2.434858>, <3.217673, 0.145944, -2.437432>, <3.217303, 0.151094, -2.260010>, <3.216685, 0.009011, -2.257436>,
      <3.938197, 0.020264, -1.407043>, <3.938816, 0.162347, -1.409617>, <3.938445, 0.167497, -1.232195>, <3.937827, 0.025414, -1.229621>,
      <5.269939, 0.011555, -0.204031>, <5.270557, 0.153639, -0.206605>, <5.270187, 0.158788, -0.029184>, <5.269569, 0.016705, -0.026609>,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>,
      <7.999804, 0.009010, 0.073990>, <7.999804, -0.133074, 0.076564>, <8.000196, -0.138223, -0.100858>, <8.000196, 0.003862, -0.103432>,
      <9.991770, -0.043210, 0.074171>, <9.999804, -0.133074, 0.076745>, <10.000196, -0.138223, -0.100677>, <9.992162, -0.048359, -0.103251>,
      <12.022759, -0.005525, 0.074352>, <12.030813, -0.017016, 0.076927>, <12.031207, -0.017674, -0.100495>, <12.023152, -0.006183, -0.103070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>,
      <8.000196, 0.003862, -0.103432>, <8.000196, 0.145946, -0.106007>, <7.999804, 0.151094, 0.071415>, <7.999804, 0.009010, 0.073990>,
      <9.992162, -0.048359, -0.103251>, <9.984128, 0.041506, -0.105825>, <9.983736, 0.046654, 0.071596>, <9.991770, -0.043210, 0.074171>,
      <12.023152, -0.006183, -0.103070>, <12.015098, 0.005307, -0.105644>, <12.014704, 0.005965, 0.071778>, <12.022759, -0.005525, 0.074352>
    }
  }
  translate  <-7.547783, -0.005938, -0.02014>
}
#declare BezPtch27 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  translate  0.688547*x
}
#declare BezPtch28 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  translate  <1.932764, 0.0, 0.02416>
}
#declare BezPtch29 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  translate  <3.019945, 0.0, 0.0>
}
#declare BezPtch30 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate 18.008755*y
  translate  <3.998407, 0.0, 0.0>
}
#declare BezPtch31 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  translate  <3.418577, 0.0, 0.01208>
}
#declare BezPtch32 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate 4.213355*y
  translate  <3.756811, 0.0, 0.048319>
}
#declare BezPtch33 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  translate  <1.340855, 0.0, 0.036239>
}
#declare BezPtch34 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate 64.398323*y
  translate  <4.433279, 0.0, 0.01208>
}
#declare BezPtch35 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate 37.852127*y
  translate  <4.203763, 0.0, 0.02416>
}
#declare BezPtch36 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  translate  <2.524674, 0.0, 0.0>
}
#declare BezPtch37 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
}
#declare BezPtch38 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <-0.0, -9.919693, 0.0>
  translate  <-0.363724, 0.0, 0.03031>
}
#declare BezPtch39 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <-0.0, -16.600996, 0.0>
  translate  <-0.757758, -0.0, -0.060621>
}
#declare bladhelft = union {
  object { BezPtch27 }
  object { BezPtch28 }
  object { BezPtch29 }
  object { BezPtch30 }
  object { BezPtch31 }
  object { BezPtch32 }
  object { BezPtch33 }
  object { BezPtch34 }
  object { BezPtch35 }
  object { BezPtch36 }
  object { BezPtch37 }
  object { BezPtch38 }
  object { BezPtch39 }
  rotate 90.0*x
}
#declare BezPtch40 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <90.0, 0.0, -180.0>
  translate  <1.343798, -0.015998, 0.0>
}
#declare BezPtch41 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  rotate <90.0, 0.0, -180.0>
  translate  <1.93571, -0.047993, 0.0>
}
#declare BezPtch42 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  rotate <90.0, 0.0, -180.0>
  translate  <2.991551, -0.095986, 0.0>
}
#declare BezPtch43 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  rotate <90.0, 0.0, -180.0>
  translate  <3.425209, -0.04556, 0.0>
}
#declare BezPtch44 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate <90.0, -0.0, 162.731384>
  translate  <4.000057, 0.01495, 0.0>
}
#declare BezPtch45 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate <90.0, -0.0, 143.62674>
  translate  <4.4438, -0.015305, 0.0>
}
#declare BezPtch46 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -180.0>
  translate  <0.712683, -0.096309, 0.0>
}
#declare BezPtch47 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate <90.0, 0.0, -180.0>
  translate  <3.758016, -0.035475, 0.0>
}
#declare BezPtch48 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate <90.0, -0.0, 158.457932>
  translate  <4.211844, -0.015305, 0.0>
}
#declare BezPtch49 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  rotate <90.0, 0.0, -180.0>
  translate  <2.511623, 0.015998, 0.0>
}
#declare BezPtch50 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  rotate <90.0, 0.0, -180.0>
  translate  -0.038523*y
}
#declare BezPtch51 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -170.391083>
  translate  <-0.363724, 0.022097, 0.0>
}
#declare BezPtch52 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale <0.8, 0.8, 0.78>
  rotate <90.0, 0.0, -162.149979>
  translate  <-0.757758, 0.022097, 0.0>
}
#declare bladhelft2 = union {
  object { BezPtch40 }
  object { BezPtch41 }
  object { BezPtch42 }
  object { BezPtch43 }
  object { BezPtch44 }
  object { BezPtch45 }
  object { BezPtch46 }
  object { BezPtch47 }
  object { BezPtch48 }
  object { BezPtch49 }
  object { BezPtch50 }
  object { BezPtch51 }
  object { BezPtch52 }
}
#declare blad = union {
  object { bladhelft }
  object { bladhelft2 }
}
#declare stengel6 = union {
  object { BezPtch002 }
  object { blad }
  texture {
    Texture1_1
  }
  rotate -39.233891*y
  translate  <1.444903, 0.0, 3.34609>
}
#declare BezPtch53 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.216685, 0.009011, -2.257436>, <3.216066, -0.133072, -2.254861>, <3.216436, -0.138223, -2.432283>, <3.217055, 0.003861, -2.434858>,
      <3.937827, 0.025414, -1.229621>, <3.937208, -0.116669, -1.227046>, <3.937578, -0.121820, -1.404468>, <3.938197, 0.020264, -1.407043>,
      <5.269569, 0.016705, -0.026609>, <5.268950, -0.125377, -0.024035>, <5.269320, -0.130528, -0.201456>, <5.269939, 0.011555, -0.204031>,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.217055, 0.003861, -2.434858>, <3.217673, 0.145944, -2.437432>, <3.217303, 0.151094, -2.260010>, <3.216685, 0.009011, -2.257436>,
      <3.938197, 0.020264, -1.407043>, <3.938816, 0.162347, -1.409617>, <3.938445, 0.167497, -1.232195>, <3.937827, 0.025414, -1.229621>,
      <5.269939, 0.011555, -0.204031>, <5.270557, 0.153639, -0.206605>, <5.270187, 0.158788, -0.029184>, <5.269569, 0.016705, -0.026609>,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>,
      <7.999804, 0.009010, 0.073990>, <7.999804, -0.133074, 0.076564>, <8.000196, -0.138223, -0.100858>, <8.000196, 0.003862, -0.103432>,
      <9.991770, -0.043210, 0.074171>, <9.999804, -0.133074, 0.076745>, <10.000196, -0.138223, -0.100677>, <9.992162, -0.048359, -0.103251>,
      <12.022759, -0.005525, 0.074352>, <12.030813, -0.017016, 0.076927>, <12.031207, -0.017674, -0.100495>, <12.023152, -0.006183, -0.103070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>,
      <8.000196, 0.003862, -0.103432>, <8.000196, 0.145946, -0.106007>, <7.999804, 0.151094, 0.071415>, <7.999804, 0.009010, 0.073990>,
      <9.992162, -0.048359, -0.103251>, <9.984128, 0.041506, -0.105825>, <9.983736, 0.046654, 0.071596>, <9.991770, -0.043210, 0.074171>,
      <12.023152, -0.006183, -0.103070>, <12.015098, 0.005307, -0.105644>, <12.014704, 0.005965, 0.071778>, <12.022759, -0.005525, 0.074352>
    }
  }
  translate  <-7.547783, -0.005938, -0.02014>
}
#declare BezPtch54 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  translate  0.688547*x
}
#declare BezPtch55 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  translate  <1.932764, 0.0, 0.02416>
}
#declare BezPtch56 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  translate  <3.019945, 0.0, 0.0>
}
#declare BezPtch57 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate 18.008755*y
  translate  <3.998407, 0.0, 0.0>
}
#declare BezPtch58 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  translate  <3.418577, 0.0, 0.01208>
}
#declare BezPtch59 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate 4.213355*y
  translate  <3.756811, 0.0, 0.048319>
}
#declare BezPtch60 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  translate  <1.340855, 0.0, 0.036239>
}
#declare BezPtch61 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate 64.398323*y
  translate  <4.433279, 0.0, 0.01208>
}
#declare BezPtch62 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate 37.852127*y
  translate  <4.203763, 0.0, 0.02416>
}
#declare BezPtch63 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  translate  <2.524674, 0.0, 0.0>
}
#declare BezPtch64 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
}
#declare BezPtch65 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <-0.0, -9.919693, 0.0>
  translate  <-0.363724, 0.0, 0.03031>
}
#declare BezPtch66 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <-0.0, -16.600996, 0.0>
  translate  <-0.757758, -0.0, -0.060621>
}
#declare bladhelft1 = union {
  object { BezPtch54 }
  object { BezPtch55 }
  object { BezPtch56 }
  object { BezPtch57 }
  object { BezPtch58 }
  object { BezPtch59 }
  object { BezPtch60 }
  object { BezPtch61 }
  object { BezPtch62 }
  object { BezPtch63 }
  object { BezPtch64 }
  object { BezPtch65 }
  object { BezPtch66 }
  rotate 90.0*x
}
#declare BezPtch67 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <90.0, 0.0, -180.0>
  translate  <1.343798, -0.015998, 0.0>
}
#declare BezPtch68 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  rotate <90.0, 0.0, -180.0>
  translate  <1.93571, -0.047993, 0.0>
}
#declare BezPtch69 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  rotate <90.0, 0.0, -180.0>
  translate  <2.991551, -0.095986, 0.0>
}
#declare BezPtch70 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  rotate <90.0, 0.0, -180.0>
  translate  <3.425209, -0.04556, 0.0>
}
#declare BezPtch71 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate <90.0, -0.0, 162.731384>
  translate  <4.000057, 0.01495, 0.0>
}
#declare BezPtch72 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate <90.0, -0.0, 143.62674>
  translate  <4.4438, -0.015305, 0.0>
}
#declare BezPtch73 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -180.0>
  translate  <0.712683, -0.096309, 0.0>
}
#declare BezPtch74 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate <90.0, 0.0, -180.0>
  translate  <3.758016, -0.035475, 0.0>
}
#declare BezPtch75 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate <90.0, -0.0, 158.457932>
  translate  <4.211844, -0.015305, 0.0>
}
#declare BezPtch76 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  rotate <90.0, 0.0, -180.0>
  translate  <2.511623, 0.015998, 0.0>
}
#declare BezPtch77 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  rotate <90.0, 0.0, -180.0>
  translate  -0.038523*y
}
#declare BezPtch78 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -170.391083>
  translate  <-0.363724, 0.022097, 0.0>
}
#declare BezPtch79 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale <0.8, 0.8, 0.78>
  rotate <90.0, 0.0, -162.149979>
  translate  <-0.757758, 0.022097, 0.0>
}
#declare bladhelft3 = union {
  object { BezPtch67 }
  object { BezPtch68 }
  object { BezPtch69 }
  object { BezPtch70 }
  object { BezPtch71 }
  object { BezPtch72 }
  object { BezPtch73 }
  object { BezPtch74 }
  object { BezPtch75 }
  object { BezPtch76 }
  object { BezPtch77 }
  object { BezPtch78 }
  object { BezPtch79 }
}
#declare blad25 = union {
  object { bladhelft1 }
  object { bladhelft3 }
}
#declare stengel7 = union {
  object { BezPtch53 }
  object { blad25 }
  texture {
    Texture1_1
  }
  scale 0.9
  rotate <-0.0, -39.233891, 137.29274>
  translate  <-1.688238, 1.187311, 2.985795>
}
#declare BezPtch80 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.216685, 0.009011, -2.257436>, <3.216066, -0.133072, -2.254861>, <3.216436, -0.138223, -2.432283>, <3.217055, 0.003861, -2.434858>,
      <3.937827, 0.025414, -1.229621>, <3.937208, -0.116669, -1.227046>, <3.937578, -0.121820, -1.404468>, <3.938197, 0.020264, -1.407043>,
      <5.269569, 0.016705, -0.026609>, <5.268950, -0.125377, -0.024035>, <5.269320, -0.130528, -0.201456>, <5.269939, 0.011555, -0.204031>,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.217055, 0.003861, -2.434858>, <3.217673, 0.145944, -2.437432>, <3.217303, 0.151094, -2.260010>, <3.216685, 0.009011, -2.257436>,
      <3.938197, 0.020264, -1.407043>, <3.938816, 0.162347, -1.409617>, <3.938445, 0.167497, -1.232195>, <3.937827, 0.025414, -1.229621>,
      <5.269939, 0.011555, -0.204031>, <5.270557, 0.153639, -0.206605>, <5.270187, 0.158788, -0.029184>, <5.269569, 0.016705, -0.026609>,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>,
      <7.999804, 0.009010, 0.073990>, <7.999804, -0.133074, 0.076564>, <8.000196, -0.138223, -0.100858>, <8.000196, 0.003862, -0.103432>,
      <9.991770, -0.043210, 0.074171>, <9.999804, -0.133074, 0.076745>, <10.000196, -0.138223, -0.100677>, <9.992162, -0.048359, -0.103251>,
      <12.022759, -0.005525, 0.074352>, <12.030813, -0.017016, 0.076927>, <12.031207, -0.017674, -0.100495>, <12.023152, -0.006183, -0.103070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>,
      <8.000196, 0.003862, -0.103432>, <8.000196, 0.145946, -0.106007>, <7.999804, 0.151094, 0.071415>, <7.999804, 0.009010, 0.073990>,
      <9.992162, -0.048359, -0.103251>, <9.984128, 0.041506, -0.105825>, <9.983736, 0.046654, 0.071596>, <9.991770, -0.043210, 0.074171>,
      <12.023152, -0.006183, -0.103070>, <12.015098, 0.005307, -0.105644>, <12.014704, 0.005965, 0.071778>, <12.022759, -0.005525, 0.074352>
    }
  }
  translate  <-7.547783, -0.005938, -0.02014>
}
#declare BezPtch81 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  translate  0.688547*x
}
#declare BezPtch82 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  translate  <1.932764, 0.0, 0.02416>
}
#declare BezPtch83 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  translate  <3.019945, 0.0, 0.0>
}
#declare BezPtch84 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate 18.008755*y
  translate  <3.998407, 0.0, 0.0>
}
#declare BezPtch85 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  translate  <3.418577, 0.0, 0.01208>
}
#declare BezPtch86 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate 4.213355*y
  translate  <3.756811, 0.0, 0.048319>
}
#declare BezPtch87 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  translate  <1.340855, 0.0, 0.036239>
}
#declare BezPtch88 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate 64.398323*y
  translate  <4.433279, 0.0, 0.01208>
}
#declare BezPtch89 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate 37.852127*y
  translate  <4.203763, 0.0, 0.02416>
}
#declare BezPtch90 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  translate  <2.524674, 0.0, 0.0>
}
#declare BezPtch91 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
}
#declare BezPtch92 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <-0.0, -9.919693, 0.0>
  translate  <-0.363724, 0.0, 0.03031>
}
#declare BezPtch93 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <-0.0, -16.600996, 0.0>
  translate  <-0.757758, -0.0, -0.060621>
}
#declare bladhelft4 = union {
  object { BezPtch81 }
  object { BezPtch82 }
  object { BezPtch83 }
  object { BezPtch84 }
  object { BezPtch85 }
  object { BezPtch86 }
  object { BezPtch87 }
  object { BezPtch88 }
  object { BezPtch89 }
  object { BezPtch90 }
  object { BezPtch91 }
  object { BezPtch92 }
  object { BezPtch93 }
  rotate 90.0*x
}
#declare BezPtch94 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <90.0, 0.0, -180.0>
  translate  <1.343798, -0.015998, 0.0>
}
#declare BezPtch95 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  rotate <90.0, 0.0, -180.0>
  translate  <1.93571, -0.047993, 0.0>
}
#declare BezPtch96 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  rotate <90.0, 0.0, -180.0>
  translate  <2.991551, -0.095986, 0.0>
}
#declare BezPtch97 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  rotate <90.0, 0.0, -180.0>
  translate  <3.425209, -0.04556, 0.0>
}
#declare BezPtch98 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate <90.0, -0.0, 162.731384>
  translate  <4.000057, 0.01495, 0.0>
}
#declare BezPtch99 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate <90.0, -0.0, 143.62674>
  translate  <4.4438, -0.015305, 0.0>
}
#declare BezPtch100 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -180.0>
  translate  <0.712683, -0.096309, 0.0>
}
#declare BezPtch101 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate <90.0, 0.0, -180.0>
  translate  <3.758016, -0.035475, 0.0>
}
#declare BezPtch102 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate <90.0, -0.0, 158.457932>
  translate  <4.211844, -0.015305, 0.0>
}
#declare BezPtch103 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  rotate <90.0, 0.0, -180.0>
  translate  <2.511623, 0.015998, 0.0>
}
#declare BezPtch104 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  rotate <90.0, 0.0, -180.0>
  translate  -0.038523*y
}
#declare BezPtch105 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -170.391083>
  translate  <-0.363724, 0.022097, 0.0>
}
#declare BezPtch106 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale <0.8, 0.8, 0.78>
  rotate <90.0, 0.0, -162.149979>
  translate  <-0.757758, 0.022097, 0.0>
}
#declare bladhelft5 = union {
  object { BezPtch94 }
  object { BezPtch95 }
  object { BezPtch96 }
  object { BezPtch97 }
  object { BezPtch98 }
  object { BezPtch99 }
  object { BezPtch100 }
  object { BezPtch101 }
  object { BezPtch102 }
  object { BezPtch103 }
  object { BezPtch104 }
  object { BezPtch105 }
  object { BezPtch106 }
}
#declare blad26 = union {
  object { bladhelft4 }
  object { bladhelft5 }
}
#declare stengel8 = union {
  object { BezPtch80 }
  object { blad26 }
  texture {
    Texture2_1
  }
  scale 0.7
  rotate <0.0, -39.233891, -104.827202>
  translate  <-0.797636, -1.254474, 1.980476>
}
union { // varen
  object { stengel6 }
  object { stengel7 }
  object { stengel8 }
  scale 4.0
  rotate <5.49159, 5.445736, 64.602974>
  translate  <-97.908491, -42.235642, 8.842887>
}


#declare BezPtch107 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.216685, 0.009011, -2.257436>, <3.216066, -0.133072, -2.254861>, <3.216436, -0.138223, -2.432283>, <3.217055, 0.003861, -2.434858>,
      <3.937827, 0.025414, -1.229621>, <3.937208, -0.116669, -1.227046>, <3.937578, -0.121820, -1.404468>, <3.938197, 0.020264, -1.407043>,
      <5.269569, 0.016705, -0.026609>, <5.268950, -0.125377, -0.024035>, <5.269320, -0.130528, -0.201456>, <5.269939, 0.011555, -0.204031>,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.217055, 0.003861, -2.434858>, <3.217673, 0.145944, -2.437432>, <3.217303, 0.151094, -2.260010>, <3.216685, 0.009011, -2.257436>,
      <3.938197, 0.020264, -1.407043>, <3.938816, 0.162347, -1.409617>, <3.938445, 0.167497, -1.232195>, <3.937827, 0.025414, -1.229621>,
      <5.269939, 0.011555, -0.204031>, <5.270557, 0.153639, -0.206605>, <5.270187, 0.158788, -0.029184>, <5.269569, 0.016705, -0.026609>,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>,
      <7.999804, 0.009010, 0.073990>, <7.999804, -0.133074, 0.076564>, <8.000196, -0.138223, -0.100858>, <8.000196, 0.003862, -0.103432>,
      <9.991770, -0.043210, 0.074171>, <9.999804, -0.133074, 0.076745>, <10.000196, -0.138223, -0.100677>, <9.992162, -0.048359, -0.103251>,
      <12.022759, -0.005525, 0.074352>, <12.030813, -0.017016, 0.076927>, <12.031207, -0.017674, -0.100495>, <12.023152, -0.006183, -0.103070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>,
      <8.000196, 0.003862, -0.103432>, <8.000196, 0.145946, -0.106007>, <7.999804, 0.151094, 0.071415>, <7.999804, 0.009010, 0.073990>,
      <9.992162, -0.048359, -0.103251>, <9.984128, 0.041506, -0.105825>, <9.983736, 0.046654, 0.071596>, <9.991770, -0.043210, 0.074171>,
      <12.023152, -0.006183, -0.103070>, <12.015098, 0.005307, -0.105644>, <12.014704, 0.005965, 0.071778>, <12.022759, -0.005525, 0.074352>
    }
  }
  translate  <-7.547783, -0.005938, -0.02014>
}
#declare BezPtch108 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  translate  0.688547*x
}
#declare BezPtch109 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  translate  <1.932764, 0.0, 0.02416>
}
#declare BezPtch110 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  translate  <3.019945, 0.0, 0.0>
}
#declare BezPtch111 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate 18.008755*y
  translate  <3.998407, 0.0, 0.0>
}
#declare BezPtch112 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  translate  <3.418577, 0.0, 0.01208>
}
#declare BezPtch113 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate 4.213355*y
  translate  <3.756811, 0.0, 0.048319>
}
#declare BezPtch114 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  translate  <1.340855, 0.0, 0.036239>
}
#declare BezPtch115 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate 64.398323*y
  translate  <4.433279, 0.0, 0.01208>
}
#declare BezPtch116 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate 37.852127*y
  translate  <4.203763, 0.0, 0.02416>
}
#declare BezPtch117 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  translate  <2.524674, 0.0, 0.0>
}
#declare BezPtch118 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
}
#declare BezPtch119 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <-0.0, -9.919693, 0.0>
  translate  <-0.363724, 0.0, 0.03031>
}
#declare BezPtch120 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <-0.0, -16.600996, 0.0>
  translate  <-0.757758, -0.0, -0.060621>
}
#declare bladhelft6 = union {
  object { BezPtch108 }
  object { BezPtch109 }
  object { BezPtch110 }
  object { BezPtch111 }
  object { BezPtch112 }
  object { BezPtch113 }
  object { BezPtch114 }
  object { BezPtch115 }
  object { BezPtch116 }
  object { BezPtch117 }
  object { BezPtch118 }
  object { BezPtch119 }
  object { BezPtch120 }
  rotate 90.0*x
}
#declare BezPtch121 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <90.0, 0.0, -180.0>
  translate  <1.343798, -0.015998, 0.0>
}
#declare BezPtch122 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  rotate <90.0, 0.0, -180.0>
  translate  <1.93571, -0.047993, 0.0>
}
#declare BezPtch123 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  rotate <90.0, 0.0, -180.0>
  translate  <2.991551, -0.095986, 0.0>
}
#declare BezPtch124 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  rotate <90.0, 0.0, -180.0>
  translate  <3.425209, -0.04556, 0.0>
}
#declare BezPtch125 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate <90.0, -0.0, 162.731384>
  translate  <4.000057, 0.01495, 0.0>
}
#declare BezPtch126 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate <90.0, -0.0, 143.62674>
  translate  <4.4438, -0.015305, 0.0>
}
#declare BezPtch127 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -180.0>
  translate  <0.712683, -0.096309, 0.0>
}
#declare BezPtch128 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate <90.0, 0.0, -180.0>
  translate  <3.758016, -0.035475, 0.0>
}
#declare BezPtch129 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate <90.0, -0.0, 158.457932>
  translate  <4.211844, -0.015305, 0.0>
}
#declare BezPtch130 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  rotate <90.0, 0.0, -180.0>
  translate  <2.511623, 0.015998, 0.0>
}
#declare BezPtch131 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  rotate <90.0, 0.0, -180.0>
  translate  -0.038523*y
}
#declare BezPtch132 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -170.391083>
  translate  <-0.363724, 0.022097, 0.0>
}
#declare BezPtch133 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale <0.8, 0.8, 0.78>
  rotate <90.0, 0.0, -162.149979>
  translate  <-0.757758, 0.022097, 0.0>
}
#declare bladhelft7 = union {
  object { BezPtch121 }
  object { BezPtch122 }
  object { BezPtch123 }
  object { BezPtch124 }
  object { BezPtch125 }
  object { BezPtch126 }
  object { BezPtch127 }
  object { BezPtch128 }
  object { BezPtch129 }
  object { BezPtch130 }
  object { BezPtch131 }
  object { BezPtch132 }
  object { BezPtch133 }
}
#declare blad27 = union {
  object { bladhelft6 }
  object { bladhelft7 }
}
#declare stengel9 = union {
  object { BezPtch107 }
  object { blad27 }
  texture {
    Texture1_1
  }
  rotate -39.233891*y
  translate  <1.444903, 0.0, 3.34609>
}
#declare BezPtch134 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.216685, 0.009011, -2.257436>, <3.216066, -0.133072, -2.254861>, <3.216436, -0.138223, -2.432283>, <3.217055, 0.003861, -2.434858>,
      <3.937827, 0.025414, -1.229621>, <3.937208, -0.116669, -1.227046>, <3.937578, -0.121820, -1.404468>, <3.938197, 0.020264, -1.407043>,
      <5.269569, 0.016705, -0.026609>, <5.268950, -0.125377, -0.024035>, <5.269320, -0.130528, -0.201456>, <5.269939, 0.011555, -0.204031>,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.217055, 0.003861, -2.434858>, <3.217673, 0.145944, -2.437432>, <3.217303, 0.151094, -2.260010>, <3.216685, 0.009011, -2.257436>,
      <3.938197, 0.020264, -1.407043>, <3.938816, 0.162347, -1.409617>, <3.938445, 0.167497, -1.232195>, <3.937827, 0.025414, -1.229621>,
      <5.269939, 0.011555, -0.204031>, <5.270557, 0.153639, -0.206605>, <5.270187, 0.158788, -0.029184>, <5.269569, 0.016705, -0.026609>,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>,
      <7.999804, 0.009010, 0.073990>, <7.999804, -0.133074, 0.076564>, <8.000196, -0.138223, -0.100858>, <8.000196, 0.003862, -0.103432>,
      <9.991770, -0.043210, 0.074171>, <9.999804, -0.133074, 0.076745>, <10.000196, -0.138223, -0.100677>, <9.992162, -0.048359, -0.103251>,
      <12.022759, -0.005525, 0.074352>, <12.030813, -0.017016, 0.076927>, <12.031207, -0.017674, -0.100495>, <12.023152, -0.006183, -0.103070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>,
      <8.000196, 0.003862, -0.103432>, <8.000196, 0.145946, -0.106007>, <7.999804, 0.151094, 0.071415>, <7.999804, 0.009010, 0.073990>,
      <9.992162, -0.048359, -0.103251>, <9.984128, 0.041506, -0.105825>, <9.983736, 0.046654, 0.071596>, <9.991770, -0.043210, 0.074171>,
      <12.023152, -0.006183, -0.103070>, <12.015098, 0.005307, -0.105644>, <12.014704, 0.005965, 0.071778>, <12.022759, -0.005525, 0.074352>
    }
  }
  translate  <-7.547783, -0.005938, -0.02014>
}
#declare BezPtch135 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  translate  0.688547*x
}
#declare BezPtch136 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  translate  <1.932764, 0.0, 0.02416>
}
#declare BezPtch137 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  translate  <3.019945, 0.0, 0.0>
}
#declare BezPtch138 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate 18.008755*y
  translate  <3.998407, 0.0, 0.0>
}
#declare BezPtch139 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  translate  <3.418577, 0.0, 0.01208>
}
#declare BezPtch140 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate 4.213355*y
  translate  <3.756811, 0.0, 0.048319>
}
#declare BezPtch141 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  translate  <1.340855, 0.0, 0.036239>
}
#declare BezPtch142 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate 64.398323*y
  translate  <4.433279, 0.0, 0.01208>
}
#declare BezPtch143 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate 37.852127*y
  translate  <4.203763, 0.0, 0.02416>
}
#declare BezPtch144 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  translate  <2.524674, 0.0, 0.0>
}
#declare BezPtch145 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
}
#declare BezPtch146 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <-0.0, -9.919693, 0.0>
  translate  <-0.363724, 0.0, 0.03031>
}
#declare BezPtch147 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <-0.0, -16.600996, 0.0>
  translate  <-0.757758, -0.0, -0.060621>
}
#declare bladhelft8 = union {
  object { BezPtch135 }
  object { BezPtch136 }
  object { BezPtch137 }
  object { BezPtch138 }
  object { BezPtch139 }
  object { BezPtch140 }
  object { BezPtch141 }
  object { BezPtch142 }
  object { BezPtch143 }
  object { BezPtch144 }
  object { BezPtch145 }
  object { BezPtch146 }
  object { BezPtch147 }
  rotate 90.0*x
}
#declare BezPtch148 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <90.0, 0.0, -180.0>
  translate  <1.343798, -0.015998, 0.0>
}
#declare BezPtch149 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  rotate <90.0, 0.0, -180.0>
  translate  <1.93571, -0.047993, 0.0>
}
#declare BezPtch150 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  rotate <90.0, 0.0, -180.0>
  translate  <2.991551, -0.095986, 0.0>
}
#declare BezPtch151 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  rotate <90.0, 0.0, -180.0>
  translate  <3.425209, -0.04556, 0.0>
}
#declare BezPtch152 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate <90.0, -0.0, 162.731384>
  translate  <4.000057, 0.01495, 0.0>
}
#declare BezPtch153 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate <90.0, -0.0, 143.62674>
  translate  <4.4438, -0.015305, 0.0>
}
#declare BezPtch154 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -180.0>
  translate  <0.712683, -0.096309, 0.0>
}
#declare BezPtch155 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate <90.0, 0.0, -180.0>
  translate  <3.758016, -0.035475, 0.0>
}
#declare BezPtch156 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate <90.0, -0.0, 158.457932>
  translate  <4.211844, -0.015305, 0.0>
}
#declare BezPtch157 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  rotate <90.0, 0.0, -180.0>
  translate  <2.511623, 0.015998, 0.0>
}
#declare BezPtch158 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  rotate <90.0, 0.0, -180.0>
  translate  -0.038523*y
}
#declare BezPtch159 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -170.391083>
  translate  <-0.363724, 0.022097, 0.0>
}
#declare BezPtch160 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale <0.8, 0.8, 0.78>
  rotate <90.0, 0.0, -162.149979>
  translate  <-0.757758, 0.022097, 0.0>
}
#declare bladhelft9 = union {
  object { BezPtch148 }
  object { BezPtch149 }
  object { BezPtch150 }
  object { BezPtch151 }
  object { BezPtch152 }
  object { BezPtch153 }
  object { BezPtch154 }
  object { BezPtch155 }
  object { BezPtch156 }
  object { BezPtch157 }
  object { BezPtch158 }
  object { BezPtch159 }
  object { BezPtch160 }
}
#declare blad28 = union {
  object { bladhelft8 }
  object { bladhelft9 }
}
#declare stengel10 = union {
  object { BezPtch134 }
  object { blad28 }
  texture {
    Texture1_1
  }
  scale 0.9
  rotate <-0.0, -39.233891, 137.29274>
  translate  <-1.688238, 1.187311, 2.985795>
}
#declare BezPtch161 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.216685, 0.009011, -2.257436>, <3.216066, -0.133072, -2.254861>, <3.216436, -0.138223, -2.432283>, <3.217055, 0.003861, -2.434858>,
      <3.937827, 0.025414, -1.229621>, <3.937208, -0.116669, -1.227046>, <3.937578, -0.121820, -1.404468>, <3.938197, 0.020264, -1.407043>,
      <5.269569, 0.016705, -0.026609>, <5.268950, -0.125377, -0.024035>, <5.269320, -0.130528, -0.201456>, <5.269939, 0.011555, -0.204031>,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.217055, 0.003861, -2.434858>, <3.217673, 0.145944, -2.437432>, <3.217303, 0.151094, -2.260010>, <3.216685, 0.009011, -2.257436>,
      <3.938197, 0.020264, -1.407043>, <3.938816, 0.162347, -1.409617>, <3.938445, 0.167497, -1.232195>, <3.937827, 0.025414, -1.229621>,
      <5.269939, 0.011555, -0.204031>, <5.270557, 0.153639, -0.206605>, <5.270187, 0.158788, -0.029184>, <5.269569, 0.016705, -0.026609>,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.634686, 0.012858, 0.023690>, <6.634377, -0.129226, 0.026265>, <6.634758, -0.134376, -0.151157>, <6.635067, 0.007709, -0.153732>,
      <7.999804, 0.009010, 0.073990>, <7.999804, -0.133074, 0.076564>, <8.000196, -0.138223, -0.100858>, <8.000196, 0.003862, -0.103432>,
      <9.991770, -0.043210, 0.074171>, <9.999804, -0.133074, 0.076745>, <10.000196, -0.138223, -0.100677>, <9.992162, -0.048359, -0.103251>,
      <12.022759, -0.005525, 0.074352>, <12.030813, -0.017016, 0.076927>, <12.031207, -0.017674, -0.100495>, <12.023152, -0.006183, -0.103070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.635067, 0.007709, -0.153732>, <6.635377, 0.149793, -0.156306>, <6.634995, 0.154941, 0.021116>, <6.634686, 0.012858, 0.023690>,
      <8.000196, 0.003862, -0.103432>, <8.000196, 0.145946, -0.106007>, <7.999804, 0.151094, 0.071415>, <7.999804, 0.009010, 0.073990>,
      <9.992162, -0.048359, -0.103251>, <9.984128, 0.041506, -0.105825>, <9.983736, 0.046654, 0.071596>, <9.991770, -0.043210, 0.074171>,
      <12.023152, -0.006183, -0.103070>, <12.015098, 0.005307, -0.105644>, <12.014704, 0.005965, 0.071778>, <12.022759, -0.005525, 0.074352>
    }
  }
  translate  <-7.547783, -0.005938, -0.02014>
}
#declare BezPtch162 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  translate  0.688547*x
}
#declare BezPtch163 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  translate  <1.932764, 0.0, 0.02416>
}
#declare BezPtch164 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  translate  <3.019945, 0.0, 0.0>
}
#declare BezPtch165 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate 18.008755*y
  translate  <3.998407, 0.0, 0.0>
}
#declare BezPtch166 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  translate  <3.418577, 0.0, 0.01208>
}
#declare BezPtch167 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate 4.213355*y
  translate  <3.756811, 0.0, 0.048319>
}
#declare BezPtch168 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  translate  <1.340855, 0.0, 0.036239>
}
#declare BezPtch169 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate 64.398323*y
  translate  <4.433279, 0.0, 0.01208>
}
#declare BezPtch170 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate 37.852127*y
  translate  <4.203763, 0.0, 0.02416>
}
#declare BezPtch171 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  translate  <2.524674, 0.0, 0.0>
}
#declare BezPtch172 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
}
#declare BezPtch173 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <-0.0, -9.919693, 0.0>
  translate  <-0.363724, 0.0, 0.03031>
}
#declare BezPtch174 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <-0.0, -16.600996, 0.0>
  translate  <-0.757758, -0.0, -0.060621>
}
#declare bladhelft10 = union {
  object { BezPtch162 }
  object { BezPtch163 }
  object { BezPtch164 }
  object { BezPtch165 }
  object { BezPtch166 }
  object { BezPtch167 }
  object { BezPtch168 }
  object { BezPtch169 }
  object { BezPtch170 }
  object { BezPtch171 }
  object { BezPtch172 }
  object { BezPtch173 }
  object { BezPtch174 }
  rotate 90.0*x
}
#declare BezPtch175 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.8
  rotate <90.0, 0.0, -180.0>
  translate  <1.343798, -0.015998, 0.0>
}
#declare BezPtch176 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.7
  rotate <90.0, 0.0, -180.0>
  translate  <1.93571, -0.047993, 0.0>
}
#declare BezPtch177 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.5
  rotate <90.0, 0.0, -180.0>
  translate  <2.991551, -0.095986, 0.0>
}
#declare BezPtch178 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.4
  rotate <90.0, 0.0, -180.0>
  translate  <3.425209, -0.04556, 0.0>
}
#declare BezPtch179 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.2
  rotate <90.0, -0.0, 162.731384>
  translate  <4.000057, 0.01495, 0.0>
}
#declare BezPtch180 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.1
  rotate <90.0, -0.0, 143.62674>
  translate  <4.4438, -0.015305, 0.0>
}
#declare BezPtch181 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -180.0>
  translate  <0.712683, -0.096309, 0.0>
}
#declare BezPtch182 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.3
  rotate <90.0, 0.0, -180.0>
  translate  <3.758016, -0.035475, 0.0>
}
#declare BezPtch183 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.15
  rotate <90.0, -0.0, 158.457932>
  translate  <4.211844, -0.015305, 0.0>
}
#declare BezPtch184 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.6
  rotate <90.0, 0.0, -180.0>
  translate  <2.511623, 0.015998, 0.0>
}
#declare BezPtch185 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  rotate <90.0, 0.0, -180.0>
  translate  -0.038523*y
}
#declare BezPtch186 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale 0.9
  rotate <90.0, 0.0, -170.391083>
  translate  <-0.363724, 0.022097, 0.0>
}
#declare BezPtch187 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.093168, 0.005041, 0.000000>, <-0.093168, -0.013764, 0.000000>, <0.093168, -0.013764, 0.000000>, <0.093168, 0.005041, 0.000000>,
      <-0.369085, -0.048805, 1.994384>, <-0.369085, -0.212755, 2.011281>, <0.369085, -0.212755, 2.011281>, <0.369085, -0.048803, 1.994384>,
      <-0.369085, -0.048805, 4.344219>, <-0.369085, -0.212755, 4.699671>, <0.369085, -0.212755, 4.699671>, <0.369085, -0.048803, 4.344219>,
      <0.003175, -1.703837, 4.334717>, <0.003175, -1.710476, 4.334717>, <-0.003175, -1.710476, 4.334717>, <-0.003175, -1.703837, 4.334717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.093168, 0.005041, 0.000000>, <0.093168, 0.023846, 0.000000>, <-0.093168, 0.023846, 0.000000>, <-0.093168, 0.005041, 0.000000>,
      <0.369085, -0.048803, 1.994384>, <0.369085, 0.115148, 1.977488>, <-0.369085, 0.115145, 1.977488>, <-0.369085, -0.048805, 1.994384>,
      <0.369085, -0.048803, 4.344219>, <0.369085, 0.115148, 3.988768>, <-0.369085, 0.115145, 3.988768>, <-0.369085, -0.048805, 4.344219>,
      <-0.003175, -1.703837, 4.334717>, <-0.003175, -1.697198, 4.334717>, <0.003175, -1.697198, 4.334717>, <0.003175, -1.703837, 4.334717>
    }
  }
  scale <0.8, 0.8, 0.78>
  rotate <90.0, 0.0, -162.149979>
  translate  <-0.757758, 0.022097, 0.0>
}
#declare bladhelft11 = union {
  object { BezPtch175 }
  object { BezPtch176 }
  object { BezPtch177 }
  object { BezPtch178 }
  object { BezPtch179 }
  object { BezPtch180 }
  object { BezPtch181 }
  object { BezPtch182 }
  object { BezPtch183 }
  object { BezPtch184 }
  object { BezPtch185 }
  object { BezPtch186 }
  object { BezPtch187 }
}
#declare blad29 = union {
  object { bladhelft10 }
  object { bladhelft11 }
}
#declare stengel11 = union {
  object { BezPtch161 }
  object { blad29 }
  texture {
    Texture2_1
  }
  scale 0.7
  rotate <0.0, -39.233891, -104.827202>
  translate  <-0.797636, -1.254474, 1.980476>
}
union { // varen1
  object { stengel9 }
  object { stengel10 }
  object { stengel11 }
  scale 3.0
  rotate <5.49159, 5.445736, 135.371246>
  translate  <-70.595363, -22.059372, -0.787032>
}


