// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "skies.inc"



#declare Land = texture
{
    pigment {
        gradient z
        frequency 2
        turbulence .4
        octaves 20
        omega 1
        color_map {
              [ .00 rgb <.972,.821,.473>  ]
              [ .35 rgb <.789,.656,.354>  ]
              [ .45 rgb <.655,.529,.392>  ]
              [ .55 rgb <.529,.462,.2845> ]
              [ .60 rgb <.569,.416,.2745> ]
              [ .65 rgb <.258,.371, 1>    ]
              [ .70 rgb <.254,.741,.131>  ]
              [ .75 rgb <.275,.492,.237>  ]
              [ .85 rgb <.396,.484,.1576> ]
              [ .95 rgbf <1,1,1,1>           ]
              [ 1   rgbf <1,1,1,1>           ]
         }
    }
    normal {
        bozo 0.4
        turbulence 1
        octaves 10
        omega .7
        lambda 2
        scale .3
        
    }
    finish {
        diffuse 0.5
    }
}

#declare Water = texture {
    pigment {
        bozo
        turbulence 2.0
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.3 color rgbf<0, 0, .5, 0>
                      color rgbf<0, 0, .5, 0>]
            [0.3, 0.4 color rgbf<1, 1, 1, .1>
                      color rgbf<1, 1, 1, 1> ]
            [0.4, 0.7 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    } }

#declare Planet=
union
{
    sphere { <0,0,0> 9.901
    texture {Land scale 10
        
   
      
    }
    
  }
        
    sphere { <0,0,0>, 10 texture  { Water scale 10 } rotate<0,0,0> }
    sphere { <0,0,0>, 10.1 texture{pigment{ Clouds turbulence .2 scale .5
    rotate 50*x
    
    }} }

sphere { <0,0,0>, 10.11 texture{pigment{ Clouds turbulence .2 scale 5
    
    
    }} }
}
