
// Persistence of Vision Ray Tracer Scene Description File
// File: space.pov
// Vers: 3
// Date:5/28/98 
// Auth:Joel Williams 


#include "colors.inc"
#include "textures.inc"
#include "SKIES.INC"


camera
{
  location  <-150.0 , 0 ,-100.0>
  look_at   <-80.0 , 0.0 , 0.0>
}
#include "planet.inc"

object { Planet scale 0 translate <0, 0, 0>}

#include "moon.inc"
object { Moon translate <20,10,0> scale 2}

// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1.5,.9,.9>       // light's color
  spotlight               // this kind of light source
  translate <-500, 1, 700> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)


looks_like { sphere
{
  <0, 0, 0> ,450


  texture {
    pigment{
        image_map {
            gif  "sunspot2.gif"
            map_type 1 }
            }scale 1000 rotate 50*x}
  finish{ambient 1}

}
 }}




   #declare galaxy_colour1 = <1.250, 0.750, 0.750>
   #declare galaxy_colour2 = <0.950, 0.550, 1.050>
   #declare galaxy_pattern_scale = 1.120
   #declare galaxy_pattern_origin = <-6.021, 19.294, -8.019>
   #declare galaxy_turb_origin = <-15.857, -19.642, -10.859>
   #declare galaxy_star_colouration = -0.461

   #declare galaxy_bgstars = 2
   #declare galaxy_bgnebula = 2
   #declare galaxy_nebula_sphere = 5
   #declare galaxy_nebula_ambient = <0.974, 0.996, 0.981>



   #declare star_type = 2
   #declare star_colour = <1.000, 1.000, 1.000>
   #declare star_colour_turb = <0.100, 0.100, 0.100>
#declare galaxy_seed = -10000
#include "Galaxy.inc"



fog {
    distance 150
    colour rgbt<0.3, 0.5, 0.2, .9>
    turbulence 0.2
    turb_depth 0.3

  }
