#include "colors.inc"
#include "shapes.inc"

camera {  
  location  <-.5, .5, -.5> 
  up        <0.0,     1.0,  0.0>  // Where Z is up
  right     <800/600,  0.0,  0.0>
  look_at <0,.5,0>
}

//#declare fast=1

light_source 
{ 
  <3,3,0> 
  color White
  #ifndef (fast)
    jitter
  #end 
}

#ifndef (fast)
object 
{
  sphere { <0,0,0> 1 }
  texture 
  {
    pigment 
    { 
      image_map 
      {
	png "moon.png"
	map_type 1
	interpolate 2
      }
    }
    finish { ambient 1 }
    translate <0,-.5,0>
    rotate <0,-45,0>
  }
  scale .1
  translate <1, 1, 1>
  rotate <0, 23, 0> //for 4/3 aspect ratio
  //rotate <0, 30, 0> for 3/2 aspect ratio
}
#end



height_field 
{
  //gforge -mesh 500 -dimension 2.0 -power 1.0 -seed 1 -name mountain.tga -type tga -peak .5 .5
  png "mountain.png"
  translate <-.5,-.5,-.5>
  scale <1,1,1>
  texture 
  {
    pigment 
    {
      #ifndef (fast)
      granite
      warp { turbulence 2}
      scale 1/2
      color_map 
      {
	[ 0.0 rgb .8 ]
	[ 0.7 rgb .8 ]
	[ 0.7 rgb .2 ]
	[ 1.0 rgb .2 ]
      }
#else
      color White
#end
    }
    
    finish { ambient 0 diffuse 1}
  }
}

sky_sphere 
{
  pigment 
  {
    gradient y
    color_map 
    {
      [ .2 color rgb <.4, .4, .5>*.9 ]
      [ .3 color rgb <.1, .1, .5>*.8 ]
      [ .4 color Black               ]
    }
  }
  scale 1
  translate <0,-.5,0> 	  
}
 

