//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 20 textures and 141 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 06/21/1998    (21.06.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray V3.01 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.553,0.651,0.671> }

fog {
  fog_type 2    // Ground Fog
  distance     1000.0
  color <0.6,0.6,0.6,0.0,0.0>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      30.0
}

camera {  //  Camera Camera01
  location  <-18.274, -61.545, 6.272>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-2.220, -1.302, 3.156>
}

//
// *******  L I G H T S *******
//

light_source {   // Light002
  <16.091, -148.364, 142.150>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light001
  <-13.269, -48.019, 4.177>
  color rgb <1.000, 1.000, 1.000>
}


//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//
// ********  TEXTURES  *******
//

#include "swans.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cone6 = object {
  cone { // Cone6
    <0,0,0>, 1.2, <0,0,1>, 0.3
    texture {
      wood_T
      scale 3.0
      rotate -63.035679*x
    }
  }
}
#declare Cone7 = object {
  object { // Cone7->Cone6
    Cone6
    scale <0.75, 0.75, 0.85>
    translate  0.6*z
  }
}
#declare Cone8 = object {
  object { // Cone8->Cone7
    Cone7
    scale <0.75, 0.75, 0.85>
    translate  0.69*z
  }
}
#declare Group001 = union {
  object { Cone6 }
  object { Cone7 }
  object { Cone8 }
  object { // Cone9->Cone8
    Cone8
    scale <0.75, 0.75, 0.85>
    translate  0.7035*z
  }
}
#declare pine = union {
  object { Group001 }
  cone { // Cone002
    <0,0,0>, 0.15, <0,0,1>, 0.01
    texture {
      wood_2_T
    }
    scale <1.0, 1.0, 3.2>
    translate  <0.0, 0.0, -0.798396>
  }
  scale 10.0
  translate  <96.516216, 973.806048, 6.93131>
}
#declare pine4 = object {
  object { // pine4->pine
    pine
    rotate <-0.0, 0.0, -120.0>
    translate  <-770.566452, 1544.294567, 25.527508>
  }
}
#declare pines1 = union { // pines1
  object { pine }
  object { // pine1->pine
    pine
    rotate <-0.0, 0.0, -30.0>
    translate  <-491.972303, 178.72338, 5.578859>
  }
  object { // pine2->pine
    pine
    rotate <-0.0, 0.0, -60.0>
    translate  <-831.082668, 570.488519, 10.988662>
  }
  object { // pine3->pine
    pine
    rotate <-0.0, 0.0, -90.0>
    translate  <-931.289832, 1070.322264, 19.779592>
  }
  object { pine4 }
  object { // pine5->pine4
    pine4
    rotate <0.0, -0.0, -0.0>
    translate  <-18.0, 0.0, -3.043014>
  }
  object { // pine6->pine4
    pine4
    rotate <0.0, -0.0, -0.0>
    translate  <-36.0, 0.0, -7.776592>
  }
}


#declare HgtFld2 = object { 
  height_field {
    tga "C:\GRAPHICS\ART\MorayW\Maps\Hf\F_mountain.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    ground_T_2
    scale 0.25
  }
  scale <70.0, 70.0, 21.0>
  rotate 42.232697*z
  translate  <145.960426, 251.701512, 2.00371>
}


#declare Disc001 = object {
  disc { // Disc001
    <0,0,0>, <0,0,1>, 1.0
    texture {
      leaves_T
    }
    scale <0.5, 1.0, 1.0>
    rotate <5.794873, -4.42366, -0.224342>
    translate  <-2.761782, 73.064652, -1.123701>
  }
}
#declare leaves_ = union {
  object { Disc001 }
  object { // Disc2->Disc001
    Disc001
    texture {
      leaf_simple_T
    }
    rotate -0.0*z
    translate  <-5.824877, -8.350246, 0.0>
  }
  object { // Disc3->Disc001
    Disc001
    texture {
      leaf_simple_T
    }
    rotate <-0.883675, -0.0, -0.0>
    translate  <11.313422, -1.043781, 0.825925>
  }
  object { // Disc4->Disc001
    Disc001
    texture {
      leaf_simple_T
    }
    rotate 10.819127*z
    translate  <2.357203, 15.656711, 0.0>
  }
  translate  <28.18208, -15.656711, 0.283732>
}
#declare BezPtch4 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.257143, -13.961806, 3.557163>, <-1.085714, -13.961806, 3.557163>, <0.085714, -13.961806, 3.557163>, <1.257143, -13.961806, 3.557163>, 
      <-1.782258, 6.319814, 2.079528>, <-0.927419, 6.319814, 2.079528>, <-0.072581, 6.319814, 2.079528>, <0.782258, 6.319814, 2.079528>, 
      <-1.625000, 1.971424, -0.111498>, <-0.875000, 1.971424, -0.111498>, <-0.125000, 1.971424, -0.111498>, <0.625000, 1.971424, -0.111498>, 
      <-1.230441, -1.331226, -3.557403>, <-0.639132, -4.824058, -6.283136>, <-0.360868, -4.824058, -6.283136>, <0.230441, -1.331226, -3.557403>
    }
  }
  texture {
    leaves_T_1
  }
  scale <0.2, 0.75, 0.75>
  rotate <71.803696, 2.222296, -7.156938>
  translate  <0.56818, 5.892093, 3.08757>
}
#declare Group24 = union {
  object { BezPtch4 }
  object { // BezPtch5->BezPtch4
    BezPtch4
    rotate -40.0*z
    translate  <-0.537481, 0.410727, -0.0>
  }
  object { // BezPtch6->BezPtch4
    BezPtch4
    rotate -80.0*z
    translate  <-0.407834, 1.284562, -0.0>
  }
  object { // BezPtch7->BezPtch4
    BezPtch4
    rotate -120.0*z
    translate  <0.600241, 1.917018, -0.0>
  }
  object { // BezPtch8->BezPtch4
    BezPtch4
    rotate -160.0*z
    translate  <2.102773, 1.620175, -0.0>
  }
  object { // BezPtch9->BezPtch4
    BezPtch4
    rotate 160.0*z
    translate  <3.276686, 0.149599, -0.0>
  }
  object { // BezPtch10->BezPtch4
    BezPtch4
    rotate 120.0*z
    translate  <3.277084, -2.078573, -0.0>
  }
  object { // BezPtch11->BezPtch4
    BezPtch4
    rotate 80.0*z
    translate  <1.711792, -4.109475, -0.0>
  }
  object { // BezPtch12->BezPtch4
    BezPtch4
    rotate 40.0*z
    translate  <-1.070101, -4.8728, -0.0>
  }
  object { // BezPtch13->BezPtch4
    BezPtch4
    rotate -0.0*z
    translate  <-4.038879, -3.715769, -0.0>
  }
  object { // BezPtch14->BezPtch4
    BezPtch4
    rotate -40.0*z
    translate  <-5.893138, -0.787784, -0.0>
  }
  object { // BezPtch15->BezPtch4
    BezPtch4
    rotate -80.0*z
    translate  <-5.645224, 2.924449, -0.0>
  }
  rotate <-9.158199, -0.208937, -173.472855>
  translate  <-1.991747, -3.062825, -4.191057>
}
#declare CSG001 = difference {
  torus { // Torus001
    1.5, 0.01  rotate -x*90
    scale <4.0, 8.0, 1.0>
    rotate -90.0*x
    translate  <-0.149186, 0.0, -12.979193>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 1.0, 14.0>
    rotate -13.677211*y
    translate  <-3.546525, 0.0, -13.077812>
  }
}
#declare Group25 = union {
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <2.0, 2.0, 4.0>
    rotate 180.0*x
  }
  cone { // Cone2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.8, 1.8, 3.6>
    rotate 180.0*x
    translate  0.658344*z
  }
  cone { // Cone3
    <0,0,0>, 0.2, <0,0,1>, 1.0
    scale <1.6, 1.6, 3.2>
    rotate 180.0*x
    translate  1.368662*z
  }
  cone { // Cone4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.8, 1.8, 3.6>
    rotate 180.0*x
    translate  -1.227717*z
  }
  cone { // Cone5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.6, 1.6, 3.2>
    rotate 180.0*x
    translate  -2.286995*z
  }
  texture {
    plant_T
  }
  scale <0.5, 0.5, 0.375>
  rotate <18.596691, 61.740887, 10.228283>
  translate  <-0.981532, 0.0, -1.51349>
}
#declare Group29 = union {
  object { Group25 }
  object { // Group26->Group25
    Group25
    translate  <0.723628, -0.329403, -0.65491>
  }
  object { // Group27->Group25
    Group25
    rotate <-3.757567, -3.440934, 2.608576>
    translate  <1.335095, -0.401168, -1.436734>
  }
  object { // Group28->Group25
    Group25
    rotate <5.586965, -52.647541, 132.773788>
    translate  <1.192151, -1.228803, -1.550336>
  }
  rotate <13.22271, -22.491606, 6.177366>
  translate  <0.330889, -0.500941, 0.356777>
}
#declare Group30 = union {
  object { CSG001 }
  object { Group29 }
  texture {
    leaves_T_1
  }
  rotate <4.907032, -6.388641, -37.65263>
  translate  <-4.774921, 1.636386, 10.150331>
}
#declare plant1 = union {
  object { Group24 }
  object { Group30 }
  object { // Group31->Group30
    Group30
    rotate <11.638757, 18.799725, 32.584976>
    translate  <1.710423, -1.453822, 0.19891>
  }
  object { // Group32->Group30
    Group30
    rotate <-18.023712, -14.554158, 64.593803>
    translate  <-3.250959, -3.243334, 0.0>
  }
  rotate -11.526608*y
}
#declare plants = union {
  object { plant1 }
  object { // plant2->plant1
    plant1
    rotate <0.0, 0.0, 30.0>
    translate  5.0*x
  }
  object { // plant3->plant1
    plant1
    rotate <0.0, 0.0, 60.0>
    translate  10.0*x
  }
  object { // plant4->plant1
    plant1
    rotate <0.0, 0.0, 90.0>
    translate  15.0*x
  }
  scale 0.6
  translate  <60.255898, 93.791925, 5.557598>
}
#declare BezPtch001 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.548829, -2.662728, 0.453103>, <-0.099982, -2.574492, 0.240243>, <0.364149, -2.295432, 0.518023>, <0.373166, -0.934002, 0.460064>, 
      <-0.937981, -2.533870, 0.213708>, <-0.486118, -2.254809, 0.031424>, <-0.055352, -1.034723, 0.000000>, <0.387682, -0.195083, 0.460064>, 
      <-1.311849, -2.214187, 0.464954>, <-0.893351, -0.986202, 0.000000>, <-0.462585, -0.146562, 0.000000>, <-0.052916, 1.235117, -0.263588>, 
      <-1.260698, -1.064081, 0.460064>, <-1.288316, -0.098041, 0.460064>, <-0.890915, 1.266947, -0.300210>, <-0.464905, 1.443211, -0.828925>
    }
  }
  texture {
    petal_T
    scale <1.6, 2.0, 1.0>
    translate <-0.489235, 0.294653, -0.421185>
  }
  rotate 35.861847*x
  translate  <0.447734, 2.580483, 0.0>
}
#declare petal1 = union {
  object { BezPtch001 }
  object { // BezPtch2->BezPtch001
    BezPtch001
    rotate -120.0*z
  }
  object { // BezPtch3->BezPtch001
    BezPtch001
    rotate 120.0*z
    translate  0.0*x
  }
}
#declare sPatchObj4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.307874, -0.329770, 0.590963>, <-7.307874, -0.253683, 0.590963>, <-7.258752, -0.199080, 0.642943>, <-7.206493, -0.199080, 0.698244>, 
      <-7.307874, -0.329770, 0.590963>, <-7.307874, -0.329770, 0.590963>, <-7.258752, -0.277494, 0.642943>, <-7.206493, -0.277494, 0.698244>, 
      <-7.307874, -0.329770, 0.590963>, <-7.307874, -0.329770, 0.590963>, <-7.258752, -0.382046, 0.642943>, <-7.206493, -0.382046, 0.698244>, 
      <-7.307874, -0.329770, 0.590963>, <-7.307874, -0.405857, 0.590963>, <-7.258752, -0.460460, 0.642943>, <-7.206493, -0.460460, 0.698244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.105112, -0.329770, 0.805525>, <-7.105112, -0.405857, 0.805525>, <-7.154234, -0.460460, 0.753544>, <-7.206493, -0.460460, 0.698244>, 
      <-7.105112, -0.329770, 0.805525>, <-7.105112, -0.329770, 0.805525>, <-7.154234, -0.382046, 0.753544>, <-7.206493, -0.382046, 0.698244>, 
      <-7.105112, -0.329770, 0.805525>, <-7.105112, -0.329770, 0.805525>, <-7.154234, -0.277494, 0.753544>, <-7.206493, -0.277494, 0.698244>, 
      <-7.105112, -0.329770, 0.805525>, <-7.105112, -0.253683, 0.805525>, <-7.154234, -0.199080, 0.753544>, <-7.206493, -0.199080, 0.698244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.847323, -0.329770, 0.326896>, <-6.224660, -0.329770, 0.470485>, <-6.727775, -0.329770, 0.661936>, <-7.105112, -0.329770, 0.805525>, 
      <-5.847323, -0.279310, 0.326896>, <-6.224660, -0.279310, 0.470485>, <-6.727775, -0.253683, 0.661936>, <-7.105112, -0.253683, 0.805525>, 
      <-5.792996, -0.225425, 0.370145>, <-6.220450, -0.220100, 0.483098>, <-6.726781, -0.204405, 0.640591>, <-7.154234, -0.199080, 0.753544>, 
      <-5.781649, -0.216831, 0.321734>, <-6.209102, -0.211506, 0.434687>, <-6.779040, -0.204405, 0.585291>, <-7.206493, -0.199080, 0.698244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.847323, -0.329770, 0.326896>, <-5.847323, -0.368724, 0.326896>, <-5.790409, -0.412875, 0.359106>, <-5.781649, -0.406241, 0.321734>, 
      <-6.224660, -0.329770, 0.470485>, <-6.224660, -0.368724, 0.470485>, <-6.217862, -0.429141, 0.472059>, <-6.209102, -0.422507, 0.434687>, 
      <-6.727775, -0.329770, 0.661936>, <-6.727775, -0.405857, 0.661936>, <-6.726781, -0.444194, 0.640591>, <-6.779040, -0.444194, 0.585291>, 
      <-7.105112, -0.329770, 0.805525>, <-7.105112, -0.405857, 0.805525>, <-7.154234, -0.460460, 0.753544>, <-7.206493, -0.460460, 0.698244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.847323, -0.329770, 0.326896>, <-5.847323, -0.279310, 0.326896>, <-5.792996, -0.225425, 0.370145>, <-5.781649, -0.216831, 0.321734>, 
      <-5.847323, -0.329770, 0.326896>, <-5.847323, -0.318263, 0.326896>, <-5.792996, -0.282248, 0.370145>, <-5.781649, -0.273654, 0.321734>, 
      <-5.847323, -0.329770, 0.326896>, <-5.847323, -0.318263, 0.326896>, <-5.790409, -0.356052, 0.359106>, <-5.781649, -0.349418, 0.321734>, 
      <-5.847323, -0.329770, 0.326896>, <-5.847323, -0.368724, 0.326896>, <-5.790409, -0.412875, 0.359106>, <-5.781649, -0.406241, 0.321734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.811085, -0.300351, -1.070313>, <-2.811085, -0.395757, -1.070313>, <-2.787800, -0.272347, -0.789315>, <-2.811085, -0.359339, -0.757813>, 
      <-3.080338, -0.300351, -1.022428>, <-3.080338, -0.395757, -1.022428>, <-3.057052, -0.272347, -0.741430>, <-3.080338, -0.359339, -0.709928>, 
      <-3.460444, -0.301049, -1.027716>, <-3.460444, -0.396455, -1.027716>, <-3.397146, -0.294906, -0.728027>, <-3.451493, -0.365037, -0.692952>, 
      <-3.709186, -0.300351, -0.914063>, <-3.709186, -0.395757, -0.914063>, <-3.654838, -0.289208, -0.636637>, <-3.709186, -0.359339, -0.601563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.952046, -0.300351, -1.226563>, <-2.212846, -0.300351, -1.202154>, <-2.553192, -0.300351, -1.116178>, <-2.811085, -0.300351, -1.070313>, 
      <-1.952046, -0.395757, -1.226563>, <-2.212846, -0.395757, -1.202154>, <-2.553192, -0.395757, -1.116178>, <-2.811085, -0.395757, -1.070313>, 
      <-1.943316, -0.271781, -0.950936>, <-2.204116, -0.271781, -0.926527>, <-2.529907, -0.272347, -0.835180>, <-2.787800, -0.272347, -0.789315>, 
      <-1.952046, -0.359339, -0.914063>, <-2.212846, -0.359339, -0.889654>, <-2.553192, -0.359339, -0.803678>, <-2.811085, -0.359339, -0.757813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.141602, -0.300351, -1.226563>, <-1.384733, -0.301485, -1.226563>, <-1.709971, -0.300351, -1.249219>, <-1.952046, -0.300351, -1.226563>, 
      <-1.141602, -0.395757, -1.226563>, <-1.384733, -0.396890, -1.226563>, <-1.709971, -0.395757, -1.249219>, <-1.952046, -0.395757, -1.226563>, 
      <-1.138228, -0.269321, -0.945489>, <-1.381361, -0.269321, -0.945489>, <-1.701241, -0.271781, -0.973592>, <-1.943316, -0.271781, -0.950936>, 
      <-1.141602, -0.359339, -0.914063>, <-1.384735, -0.359339, -0.914063>, <-1.709971, -0.359339, -0.936719>, <-1.952046, -0.359339, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.671515, -3.514867, 0.093750>, <-3.794589, -3.966228, 0.215556>, <-3.058551, -1.283856, -0.423020>, <-2.811085, -0.359339, -0.757813>, 
      <-3.387666, -3.573077, 0.073791>, <-3.510740, -4.024438, 0.195597>, <-3.327803, -1.283856, -0.375135>, <-3.080338, -0.359339, -0.709928>, 
      <-4.732855, -2.551004, -0.046495>, <-4.330447, -2.049430, -0.212448>, <-3.829807, -0.853215, -0.448800>, <-3.451493, -0.365037, -0.692952>, 
      <-5.050547, -2.031252, -0.048387>, <-4.648139, -1.529678, -0.214340>, <-4.087500, -0.847517, -0.357410>, <-3.709186, -0.359339, -0.601563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.183254, -2.619261, -0.250000>, <-2.113892, -1.941284, -0.449219>, <-2.017017, -1.010970, -0.639641>, <-1.952046, -0.359339, -0.914063>, 
      <-2.700058, -2.496456, -0.250000>, <-2.630696, -1.818479, -0.449219>, <-2.277817, -1.010970, -0.615233>, <-2.212846, -0.359339, -0.889654>, 
      <-3.919035, -3.464107, 0.111154>, <-4.042110, -3.915468, 0.232960>, <-2.800657, -1.283856, -0.468886>, <-2.553192, -0.359339, -0.803678>, 
      <-3.671515, -3.514867, 0.093750>, <-3.794589, -3.966228, 0.215556>, <-3.058551, -1.283856, -0.423020>, <-2.811085, -0.359339, -0.757813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.283361, -4.082350, 0.093750>, <-1.303638, -4.614882, 0.237906>, <-1.182552, -1.451838, -0.532667>, <-1.141602, -0.359339, -0.914063>, 
      <-1.034457, -4.111164, 0.093750>, <-1.054734, -4.643696, 0.237906>, <-1.425685, -1.451838, -0.532667>, <-1.384735, -0.359339, -0.914063>, 
      <-1.671968, -2.740755, -0.250000>, <-1.602606, -2.062778, -0.449219>, <-1.774942, -1.010970, -0.662298>, <-1.709971, -0.359339, -0.936719>, 
      <-2.183254, -2.619261, -0.250000>, <-2.113892, -1.941284, -0.449219>, <-2.017017, -1.010970, -0.639641>, <-1.952046, -0.359339, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.129277, -2.886966, -0.250000>, <0.056747, -2.128678, -0.449219>, <-0.044097, -1.093476, -0.637810>, <-0.112488, -0.359339, -0.914063>, 
      <-0.422153, -3.008471, -0.250000>, <-0.494683, -2.250183, -0.449219>, <-0.351626, -1.093476, -0.665060>, <-0.420017, -0.359339, -0.941314>, 
      <-1.550800, -4.051390, 0.093750>, <-1.571077, -4.583922, 0.237906>, <-0.873817, -1.451838, -0.532667>, <-0.832868, -0.359339, -0.914063>, 
      <-1.283361, -4.082350, 0.093750>, <-1.303638, -4.614882, 0.237906>, <-1.182552, -1.451838, -0.532667>, <-1.141602, -0.359339, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.311473, -3.510591, 0.093750>, <1.352452, -3.961340, 0.210445>, <1.107229, -1.280933, -0.398159>, <1.024984, -0.359339, -0.722079>, 
      <1.503506, -3.464848, 0.093750>, <1.544485, -3.915598, 0.210445>, <0.766757, -1.280933, -0.460138>, <0.684511, -0.359339, -0.784058>, 
      <0.533606, -2.797874, -0.250000>, <0.461077, -2.039586, -0.449219>, <0.300621, -1.093476, -0.607264>, <0.232229, -0.359339, -0.883517>, 
      <0.129277, -2.886966, -0.250000>, <0.056747, -2.128678, -0.449219>, <-0.044097, -1.093476, -0.637810>, <-0.112488, -0.359339, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.086153, -2.420835, -0.250000>, <1.969651, -1.802386, -0.350355>, <1.807374, -0.960004, -0.401977>, <1.697813, -0.359339, -0.584517>, 
      <1.703366, -2.578954, -0.250000>, <1.586864, -1.960505, -0.350355>, <1.604331, -0.960004, -0.436900>, <1.494770, -0.359339, -0.619441>, 
      <1.119379, -3.556348, 0.093750>, <1.160358, -4.007097, 0.210445>, <1.309922, -1.280933, -0.361261>, <1.227677, -0.359339, -0.685181>, 
      <1.311473, -3.510591, 0.093750>, <1.352452, -3.961340, 0.210445>, <1.107229, -1.280933, -0.398159>, <1.024984, -0.359339, -0.722079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.471052, -2.618528, 0.093750>, <3.608631, -2.941678, 0.173928>, <2.781934, -1.019068, -0.219248>, <2.509215, -0.359339, -0.466789>, 
      <3.648921, -2.515128, 0.082377>, <3.786500, -2.838278, 0.162555>, <2.542009, -1.019068, -0.273440>, <2.269290, -0.359339, -0.520981>, 
      <2.485583, -2.255841, -0.250000>, <2.369081, -1.637392, -0.350355>, <2.049784, -0.960004, -0.360282>, <1.940223, -0.359339, -0.542822>, 
      <2.086153, -2.420835, -0.250000>, <1.969651, -1.802386, -0.350355>, <1.807374, -0.960004, -0.401977>, <1.697813, -0.359339, -0.584517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.918919, -1.355404, -0.367188>, <4.329788, -1.056585, -0.189079>, <4.896928, -0.699530, 0.082339>, <5.288482, -0.359339, 0.226510>, 
      <3.784559, -1.734341, -0.228907>, <4.195428, -1.435522, -0.050797>, <4.063148, -0.699530, -0.125651>, <4.454702, -0.359339, 0.018520>, 
      <3.296063, -2.720253, 0.104939>, <3.433642, -3.043403, 0.185117>, <3.620149, -1.019068, -0.029919>, <3.347430, -0.359339, -0.277461>, 
      <3.471052, -2.618528, 0.093750>, <3.608631, -2.941678, 0.173928>, <2.781934, -1.019068, -0.219248>, <2.509215, -0.359339, -0.466789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.866744, -0.291772, 0.325856>, <-5.866744, -0.422507, 1.018448>, <-4.373328, -0.344654, -0.366030>, <-3.709186, -0.359339, -0.601563>, 
      <-5.703278, -0.448700, 0.253275>, <-5.703278, -0.579435, 0.945867>, <-4.751641, -0.832831, -0.121877>, <-4.087500, -0.847517, -0.357410>, 
      <-5.485323, -0.657937, 0.156501>, <-5.403930, -1.022853, 0.116809>, <-4.844224, -1.208877, -0.215508>, <-4.648139, -1.529678, -0.214340>, 
      <-5.321857, -0.814865, 0.083921>, <-5.240464, -1.179781, 0.044229>, <-5.246632, -1.710451, -0.049555>, <-5.050547, -2.031252, -0.048387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.866744, -0.291772, 0.325856>, <-5.866744, -0.422507, 1.018448>, <-4.373328, -0.344654, -0.366030>, <-3.709186, -0.359339, -0.601563>, 
      <-5.866744, -0.291772, 0.325856>, <-5.866744, -0.284033, 0.284859>, <-4.318980, -0.274523, -0.401104>, <-3.654838, -0.289208, -0.636637>, 
      <-5.866744, -0.291772, 0.325856>, <-5.866744, -0.284033, 0.284859>, <-4.388206, -0.393850, -0.603811>, <-3.709186, -0.395757, -0.914063>, 
      <-5.866744, -0.291772, 0.325856>, <-5.866744, -0.153299, -0.407733>, <-4.388206, -0.298445, -0.603811>, <-3.709186, -0.300351, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.709186, -0.232783, -0.601563>, <-4.373297, -0.245604, -0.366041>, <-5.219477, -0.274075, 0.047630>, <-5.866744, -0.291772, 0.325856>, 
      <-3.654693, -0.303449, -0.636731>, <-4.318804, -0.316270, -0.401209>, <-5.219477, -0.404810, 0.740222>, <-5.866744, -0.422507, 1.018448>, 
      <-3.709186, -0.204435, -0.914063>, <-3.709186, -0.299840, -0.914063>, <-4.318980, -0.274523, -0.401104>, <-4.373328, -0.344654, -0.366030>, 
      <-3.709186, -0.300351, -0.914063>, <-3.709186, -0.395757, -0.914063>, <-3.654838, -0.289208, -0.636637>, <-3.709186, -0.359339, -0.601563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.709186, -0.232783, -0.601563>, <-4.373297, -0.245604, -0.366041>, <-5.219477, -0.274075, 0.047630>, <-5.866744, -0.291772, 0.325856>, 
      <-3.709186, -0.232783, -0.601563>, <-4.318804, -0.316270, -0.401209>, <-5.219477, -0.135602, -0.685959>, <-5.866744, -0.153299, -0.407733>, 
      <-3.709186, -0.232783, -0.601563>, <-4.318804, -0.316270, -0.401209>, <-4.388206, -0.202528, -0.603811>, <-4.388206, -0.298445, -0.603811>, 
      <-3.709186, -0.232783, -0.601563>, <-3.654693, -0.303449, -0.636731>, <-3.709186, -0.204435, -0.914063>, <-3.709186, -0.300351, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.811085, -0.232783, -0.757813>, <-3.080338, -0.232783, -0.709928>, <-3.451480, -0.227808, -0.692957>, <-3.709186, -0.232783, -0.601563>, 
      <-2.787727, -0.320280, -0.789414>, <-3.056979, -0.320280, -0.741528>, <-3.396987, -0.298474, -0.728125>, <-3.654693, -0.303449, -0.636731>, 
      <-2.811085, -0.204435, -1.070313>, <-3.080338, -0.204435, -1.022428>, <-3.457930, -0.203502, -1.022042>, <-3.709186, -0.204435, -0.914063>, 
      <-2.811085, -0.300351, -1.070313>, <-3.080338, -0.300351, -1.022428>, <-3.457930, -0.299418, -1.022042>, <-3.709186, -0.300351, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.811085, -0.232783, -0.757813>, <-3.080338, -0.232783, -0.709928>, <-3.451480, -0.227808, -0.692957>, <-3.709186, -0.232783, -0.601563>, 
      <-2.787727, -0.320280, -0.789414>, <-3.056979, -0.320280, -0.741528>, <-3.396987, -0.298474, -0.728125>, <-3.654693, -0.303449, -0.636731>, 
      <-2.811085, -0.204435, -1.070313>, <-3.080338, -0.204435, -1.022428>, <-3.460444, -0.205133, -1.027716>, <-3.709186, -0.204435, -0.914063>, 
      <-2.811085, -0.300351, -1.070313>, <-3.080338, -0.300351, -1.022428>, <-3.460444, -0.301049, -1.027716>, <-3.709186, -0.300351, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.952046, -0.232783, -0.914063>, <-2.212846, -0.232783, -0.889654>, <-2.553192, -0.232783, -0.803678>, <-2.811085, -0.232783, -0.757813>, 
      <-1.943297, -0.320861, -0.951018>, <-2.204097, -0.320861, -0.926610>, <-2.529834, -0.320280, -0.835279>, <-2.787727, -0.320280, -0.789414>, 
      <-1.952046, -0.204435, -1.226563>, <-2.212846, -0.204435, -1.202154>, <-2.553192, -0.204435, -1.116178>, <-2.811085, -0.204435, -1.070313>, 
      <-1.952046, -0.300351, -1.226563>, <-2.212846, -0.300351, -1.202154>, <-2.553192, -0.300351, -1.116178>, <-2.811085, -0.300351, -1.070313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.952046, -0.232783, -0.914063>, <-2.212846, -0.232783, -0.889654>, <-2.553192, -0.232783, -0.803678>, <-2.811085, -0.232783, -0.757813>, 
      <-1.943297, -0.320861, -0.951018>, <-2.204097, -0.320861, -0.926610>, <-2.529834, -0.320280, -0.835279>, <-2.787727, -0.320280, -0.789414>, 
      <-1.952046, -0.204435, -1.226563>, <-2.212846, -0.204435, -1.202154>, <-2.553192, -0.204435, -1.116178>, <-2.811085, -0.204435, -1.070313>, 
      <-1.952046, -0.300351, -1.226563>, <-2.212846, -0.300351, -1.202154>, <-2.553192, -0.300351, -1.116178>, <-2.811085, -0.300351, -1.070313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.141602, -0.232783, -0.914063>, <-1.381182, -0.225100, -0.873364>, <-1.709971, -0.232783, -0.936719>, <-1.952046, -0.232783, -0.914063>, 
      <-1.138217, -0.323306, -0.945593>, <-1.377796, -0.315623, -0.904894>, <-1.701221, -0.320861, -0.973675>, <-1.943297, -0.320861, -0.951018>, 
      <-1.141602, -0.204435, -1.226563>, <-1.384735, -0.204435, -1.226563>, <-1.709971, -0.204435, -1.249219>, <-1.952046, -0.204435, -1.226563>, 
      <-1.141602, -0.300351, -1.226563>, <-1.384735, -0.300351, -1.226563>, <-1.709971, -0.300351, -1.249219>, <-1.952046, -0.300351, -1.226563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.141602, -0.232783, -0.914063>, <-1.381182, -0.225100, -0.873364>, <-1.709971, -0.232783, -0.936719>, <-1.952046, -0.232783, -0.914063>, 
      <-1.138217, -0.323306, -0.945593>, <-1.377796, -0.315623, -0.904894>, <-1.701221, -0.320861, -0.973675>, <-1.943297, -0.320861, -0.951018>, 
      <-1.141602, -0.204435, -1.226563>, <-1.384733, -0.205568, -1.226563>, <-1.709971, -0.204435, -1.249219>, <-1.952046, -0.204435, -1.226563>, 
      <-1.141602, -0.300351, -1.226563>, <-1.384733, -0.301485, -1.226563>, <-1.709971, -0.300351, -1.249219>, <-1.952046, -0.300351, -1.226563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.112488, -0.291772, -1.226563>, <-0.434366, -0.291772, -1.255085>, <-0.823186, -0.242994, -0.968155>, <-1.141602, -0.232783, -0.914063>, 
      <-0.112488, -0.291772, -1.226563>, <-0.741906, -0.291772, -1.282337>, <-0.819801, -0.333516, -0.999685>, <-1.138217, -0.323306, -0.945593>, 
      <-0.112488, -0.291772, -1.226563>, <-0.741906, -0.291772, -1.282337>, <-0.832861, -0.202995, -1.226563>, <-1.141602, -0.204435, -1.226563>, 
      <-0.112488, -0.291772, -1.226563>, <-0.420028, -0.291772, -1.253815>, <-0.832861, -0.298911, -1.226563>, <-1.141602, -0.300351, -1.226563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.112488, -0.291772, -1.226563>, <-0.112488, -0.312042, -1.132813>, <-0.120819, -0.269907, -0.947716>, <-0.112488, -0.359339, -0.914063>, 
      <0.232239, -0.291772, -1.196016>, <0.232239, -0.312042, -1.102266>, <0.223898, -0.269907, -0.917170>, <0.232229, -0.359339, -0.883517>, 
      <0.684502, -0.300351, -1.096560>, <0.684502, -0.395757, -1.096560>, <0.676507, -0.269649, -0.815583>, <0.684511, -0.359339, -0.784058>, 
      <1.024984, -0.300351, -1.034579>, <1.024984, -0.395757, -1.034579>, <1.016980, -0.269649, -0.753603>, <1.024984, -0.359339, -0.722079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.112488, -0.291772, -1.226563>, <-0.420028, -0.291772, -1.253815>, <-0.832861, -0.298911, -1.226563>, <-1.141602, -0.300351, -1.226563>, 
      <-0.112488, -0.312042, -1.132813>, <-0.420028, -0.312042, -1.160065>, <-0.832861, -0.394317, -1.226563>, <-1.141602, -0.395757, -1.226563>, 
      <-0.120819, -0.269907, -0.947716>, <-0.428349, -0.269907, -0.974966>, <-0.829494, -0.269321, -0.945489>, <-1.138228, -0.269321, -0.945489>, 
      <-0.112488, -0.359339, -0.914063>, <-0.420017, -0.359339, -0.941314>, <-0.832868, -0.359339, -0.914063>, <-1.141602, -0.359339, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.024984, -0.232783, -0.722079>, <0.657309, -0.232783, -0.789010>, <0.259770, -0.291772, -1.193577>, <-0.112488, -0.291772, -1.226563>, 
      <1.024984, -0.232783, -0.722079>, <0.649281, -0.322982, -0.820629>, <0.604497, -0.291772, -1.163030>, <0.232239, -0.291772, -1.196016>, 
      <1.024984, -0.232783, -0.722079>, <0.649281, -0.322982, -0.820629>, <0.684502, -0.204435, -1.096560>, <0.684502, -0.300351, -1.096560>, 
      <1.024984, -0.232783, -0.722079>, <1.016956, -0.322982, -0.753697>, <1.024984, -0.204435, -1.034579>, <1.024984, -0.300351, -1.034579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.697813, -0.291772, -0.897017>, <1.488824, -0.283466, -0.888961>, <1.230909, -0.232783, -0.684593>, <1.024984, -0.232783, -0.722079>, 
      <1.697813, -0.291772, -0.897017>, <1.285769, -0.284640, -0.923887>, <1.222881, -0.322982, -0.716211>, <1.016956, -0.322982, -0.753697>, 
      <1.697813, -0.291772, -0.897017>, <1.285769, -0.284640, -0.923887>, <1.227693, -0.204435, -0.997678>, <1.024984, -0.204435, -1.034579>, 
      <1.697813, -0.291772, -0.897017>, <1.494758, -0.292946, -0.931943>, <1.227693, -0.300351, -0.997678>, <1.024984, -0.300351, -1.034579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.697813, -0.291772, -0.897017>, <1.488824, -0.283466, -0.888961>, <1.230909, -0.232783, -0.684593>, <1.024984, -0.232783, -0.722079>, 
      <1.494758, -0.292946, -0.931943>, <1.285769, -0.284640, -0.923887>, <0.863235, -0.232783, -0.751524>, <0.657309, -0.232783, -0.789010>, 
      <1.227693, -0.300351, -0.997678>, <0.887211, -0.300351, -1.059659>, <0.604497, -0.291772, -1.163030>, <0.259770, -0.291772, -1.193577>, 
      <1.024984, -0.300351, -1.034579>, <0.684502, -0.300351, -1.096560>, <0.232239, -0.291772, -1.196016>, <-0.112488, -0.291772, -1.226563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.697813, -0.291772, -0.897017>, <1.494758, -0.292946, -0.931943>, <1.227693, -0.300351, -0.997678>, <1.024984, -0.300351, -1.034579>, 
      <1.697813, -0.312042, -0.803267>, <1.494758, -0.313216, -0.838193>, <1.227693, -0.395757, -0.997678>, <1.024984, -0.395757, -1.034579>, 
      <1.681323, -0.268933, -0.611991>, <1.478280, -0.268933, -0.646915>, <1.219673, -0.269649, -0.716705>, <1.016980, -0.269649, -0.753603>, 
      <1.697813, -0.359339, -0.584517>, <1.494770, -0.359339, -0.619441>, <1.227677, -0.359339, -0.685181>, <1.024984, -0.359339, -0.722079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.823247, -0.311536, 0.224180>, <-6.246520, -0.314996, 0.401200>, <-6.862486, -0.324300, 0.480928>, <-7.307874, -0.329770, 0.590963>, 
      <-5.823247, -0.366410, 0.224180>, <-6.246520, -0.369870, 0.401200>, <-6.862486, -0.400387, 0.480928>, <-7.307874, -0.405857, 0.590963>, 
      <-5.769309, -0.396895, 0.269089>, <-6.196762, -0.413161, 0.382042>, <-6.831299, -0.444194, 0.529990>, <-7.258752, -0.460460, 0.642943>, 
      <-5.781649, -0.406241, 0.321734>, <-6.209102, -0.422507, 0.434687>, <-6.779040, -0.444194, 0.585291>, <-7.206493, -0.460460, 0.698244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.823247, -0.311536, 0.224180>, <-5.823247, -0.366410, 0.224180>, <-5.769309, -0.396895, 0.269089>, <-5.781649, -0.406241, 0.321734>, 
      <-5.823247, -0.311536, 0.224180>, <-5.823247, -0.311536, 0.224180>, <-5.769309, -0.340072, 0.269089>, <-5.781649, -0.349418, 0.321734>, 
      <-5.823247, -0.311536, 0.224180>, <-5.823247, -0.311536, 0.224180>, <-5.769309, -0.264309, 0.269089>, <-5.781649, -0.273654, 0.321734>, 
      <-5.823247, -0.311536, 0.224180>, <-5.823247, -0.256662, 0.224180>, <-5.769309, -0.207485, 0.269089>, <-5.781649, -0.216831, 0.321734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.823247, -0.311536, 0.224180>, <-5.823247, -0.256662, 0.224180>, <-5.769309, -0.207485, 0.269089>, <-5.781649, -0.216831, 0.321734>, 
      <-6.246520, -0.314996, 0.401200>, <-6.246520, -0.260122, 0.401200>, <-6.196762, -0.202160, 0.382042>, <-6.209102, -0.211506, 0.434687>, 
      <-6.862486, -0.324300, 0.480928>, <-6.862486, -0.248213, 0.480928>, <-6.831299, -0.204405, 0.529990>, <-6.779040, -0.204405, 0.585291>, 
      <-7.307874, -0.329770, 0.590963>, <-7.307874, -0.253683, 0.590963>, <-7.258752, -0.199080, 0.642943>, <-7.206493, -0.199080, 0.698244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.823247, -0.311536, 0.224180>, <-5.158730, -0.306104, -0.053731>, <-4.370968, -0.302808, -0.629658>, <-3.709186, -0.300351, -0.914063>, 
      <-5.836296, -0.305607, 0.254683>, <-5.171779, -0.300175, -0.023228>, <-4.370968, -0.206892, -0.629658>, <-3.709186, -0.204435, -0.914063>, 
      <-5.889396, -0.315909, 0.332193>, <-5.242128, -0.298213, 0.053967>, <-4.318804, -0.316270, -0.401209>, <-3.654693, -0.303449, -0.636731>, 
      <-5.866744, -0.291772, 0.325856>, <-5.219477, -0.274075, 0.047630>, <-4.373297, -0.245604, -0.366041>, <-3.709186, -0.232783, -0.601563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.823247, -0.311536, 0.224180>, <-5.158730, -0.306104, -0.053731>, <-4.370968, -0.302808, -0.629658>, <-3.709186, -0.300351, -0.914063>, 
      <-5.836296, -0.305607, 0.254683>, <-5.171779, -0.300175, -0.023228>, <-4.370968, -0.398214, -0.629658>, <-3.709186, -0.395757, -0.914063>, 
      <-5.889396, -0.315909, 0.332193>, <-5.889396, -0.446644, 1.024785>, <-4.318980, -0.274523, -0.401104>, <-3.654838, -0.289208, -0.636637>, 
      <-5.866744, -0.291772, 0.325856>, <-5.866744, -0.422507, 1.018448>, <-4.373328, -0.344654, -0.366030>, <-3.709186, -0.359339, -0.601563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.823247, -0.311536, 0.224180>, <-5.836296, -0.305607, 0.254683>, <-5.889396, -0.315909, 0.332193>, <-5.866744, -0.291772, 0.325856>, 
      <-5.823247, -0.311536, 0.224180>, <-5.171779, -0.300175, -0.023228>, <-5.889396, -0.177436, -0.401396>, <-5.866744, -0.153299, -0.407733>, 
      <-5.823247, -0.311536, 0.224180>, <-5.171779, -0.300175, -0.023228>, <-5.049988, -0.300902, -0.319406>, <-4.388206, -0.298445, -0.603811>, 
      <-5.823247, -0.311536, 0.224180>, <-5.158730, -0.306104, -0.053731>, <-4.370968, -0.302808, -0.629658>, <-3.709186, -0.300351, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.112488, -0.300351, -1.226563>, <0.232229, -0.300351, -1.196017>, <0.684511, -0.300351, -1.096559>, <1.024984, -0.300351, -1.034579>, 
      <-0.420017, -0.300351, -1.253813>, <-0.075300, -0.300351, -1.223268>, <0.344029, -0.300351, -1.158540>, <0.684502, -0.300351, -1.096560>, 
      <-0.832868, -0.300351, -1.226563>, <-0.524126, -0.298911, -1.226563>, <-0.075301, -0.291772, -1.223268>, <0.232239, -0.291772, -1.196016>, 
      <-1.141602, -0.300351, -1.226563>, <-0.832861, -0.298911, -1.226563>, <-0.420028, -0.291772, -1.253815>, <-0.112488, -0.291772, -1.226563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.112488, -0.300351, -1.226563>, <-0.420017, -0.300351, -1.253813>, <-0.832868, -0.300351, -1.226563>, <-1.141602, -0.300351, -1.226563>, 
      <-0.112488, -0.297777, -1.226563>, <-0.420017, -0.297777, -1.253813>, <-0.832868, -0.204435, -1.226563>, <-1.141602, -0.204435, -1.226563>, 
      <-0.112712, -0.294172, -1.227466>, <-0.434590, -0.294172, -1.255988>, <-0.819801, -0.333516, -0.999685>, <-1.138217, -0.323306, -0.945593>, 
      <-0.112488, -0.291772, -1.226563>, <-0.434366, -0.291772, -1.255085>, <-0.823186, -0.242994, -0.968155>, <-1.141602, -0.232783, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.112488, -0.300351, -1.226563>, <0.232229, -0.300351, -1.196017>, <0.684511, -0.300351, -1.096559>, <1.024984, -0.300351, -1.034579>, 
      <-0.112488, -0.297777, -1.226563>, <0.232229, -0.297777, -1.196017>, <0.684511, -0.204435, -1.096559>, <1.024984, -0.204435, -1.034579>, 
      <-0.112712, -0.294172, -1.227466>, <0.259547, -0.294172, -1.194480>, <0.649281, -0.322982, -0.820629>, <1.016956, -0.322982, -0.753697>, 
      <-0.112488, -0.291772, -1.226563>, <0.259770, -0.291772, -1.193577>, <0.657309, -0.232783, -0.789010>, <1.024984, -0.232783, -0.722079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.112488, -0.300351, -1.226563>, <-0.420017, -0.300351, -1.253813>, <-0.832868, -0.300351, -1.226563>, <-1.141602, -0.300351, -1.226563>, 
      <-0.112488, -0.300351, -1.226563>, <-0.420017, -0.297777, -1.253813>, <-0.524126, -0.298911, -1.226563>, <-0.832861, -0.298911, -1.226563>, 
      <-0.112488, -0.300351, -1.226563>, <-0.420017, -0.297777, -1.253813>, <-0.420252, -0.294172, -1.254717>, <-0.420028, -0.291772, -1.253815>, 
      <-0.112488, -0.300351, -1.226563>, <-0.112488, -0.297777, -1.226563>, <-0.112712, -0.294172, -1.227466>, <-0.112488, -0.291772, -1.226563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.112488, -0.300351, -1.226563>, <-0.112488, -0.297777, -1.226563>, <-0.112712, -0.294172, -1.227466>, <-0.112488, -0.291772, -1.226563>, 
      <-0.112488, -0.300351, -1.226563>, <0.232229, -0.297777, -1.196017>, <0.232015, -0.294172, -1.196919>, <0.232239, -0.291772, -1.196016>, 
      <-0.112488, -0.300351, -1.226563>, <0.232229, -0.297777, -1.196017>, <0.344029, -0.300351, -1.158540>, <0.684502, -0.300351, -1.096560>, 
      <-0.112488, -0.300351, -1.226563>, <0.232229, -0.300351, -1.196017>, <0.684511, -0.300351, -1.096559>, <1.024984, -0.300351, -1.034579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.697813, -0.300351, -0.897017>, <1.697813, -0.297777, -0.897017>, <1.697371, -0.294198, -0.897754>, <1.697813, -0.291772, -0.897017>, 
      <1.494774, -0.301525, -0.931940>, <1.494774, -0.298951, -0.931940>, <1.488381, -0.285892, -0.889699>, <1.488824, -0.283466, -0.888961>, 
      <1.227677, -0.300351, -0.997681>, <1.227677, -0.204435, -0.997681>, <1.222881, -0.322982, -0.716211>, <1.230909, -0.232783, -0.684593>, 
      <1.024984, -0.300351, -1.034579>, <1.024984, -0.204435, -1.034579>, <1.016956, -0.322982, -0.753697>, <1.024984, -0.232783, -0.722079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.697813, -0.300351, -0.897017>, <1.697813, -0.297777, -0.897017>, <1.697371, -0.294198, -0.897754>, <1.697813, -0.291772, -0.897017>, 
      <1.697813, -0.300351, -0.897017>, <1.494774, -0.298951, -0.931940>, <1.494315, -0.295372, -0.932680>, <1.494758, -0.292946, -0.931943>, 
      <1.697813, -0.300351, -0.897017>, <1.494774, -0.298951, -0.931940>, <1.430386, -0.300351, -0.960780>, <1.227693, -0.300351, -0.997678>, 
      <1.697813, -0.300351, -0.897017>, <1.494774, -0.301525, -0.931940>, <1.227677, -0.300351, -0.997681>, <1.024984, -0.300351, -1.034579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.509215, -0.291772, -0.779289>, <2.272628, -0.291772, -0.846625>, <1.940232, -0.298950, -0.855321>, <1.697813, -0.300351, -0.897017>, 
      <2.272641, -0.291772, -0.846622>, <2.036054, -0.291772, -0.913958>, <1.737193, -0.300123, -0.890244>, <1.494774, -0.301525, -0.931940>, 
      <1.943406, -0.301533, -0.906484>, <1.740351, -0.302706, -0.941409>, <1.430386, -0.300351, -0.960780>, <1.227677, -0.300351, -0.997681>, 
      <1.697813, -0.291772, -0.897017>, <1.494758, -0.292946, -0.931943>, <1.227693, -0.300351, -0.997678>, <1.024984, -0.300351, -1.034579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.509215, -0.291772, -0.779289>, <2.272628, -0.291772, -0.846625>, <1.940232, -0.298950, -0.855321>, <1.697813, -0.300351, -0.897017>, 
      <2.509215, -0.291772, -0.779289>, <2.036054, -0.291772, -0.913958>, <1.940232, -0.296376, -0.855321>, <1.697813, -0.297777, -0.897017>, 
      <2.509215, -0.291772, -0.779289>, <2.036054, -0.291772, -0.913958>, <1.942964, -0.303959, -0.907221>, <1.697371, -0.294198, -0.897754>, 
      <2.509215, -0.291772, -0.779289>, <2.272641, -0.291772, -0.846622>, <1.943406, -0.301533, -0.906484>, <1.697813, -0.291772, -0.897017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.509215, -0.291772, -0.779289>, <2.272628, -0.291772, -0.846625>, <1.940232, -0.298950, -0.855321>, <1.697813, -0.300351, -0.897017>, 
      <2.272641, -0.291772, -0.846622>, <2.036054, -0.291772, -0.913958>, <1.737193, -0.300123, -0.890244>, <1.494774, -0.301525, -0.931940>, 
      <1.940219, -0.290371, -0.855323>, <1.737164, -0.291545, -0.890249>, <1.430386, -0.300351, -0.960780>, <1.227677, -0.300351, -0.997681>, 
      <1.697813, -0.291772, -0.897017>, <1.494758, -0.292946, -0.931943>, <1.227693, -0.300351, -0.997678>, <1.024984, -0.300351, -1.034579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.509215, -0.291772, -0.779289>, <2.272641, -0.291772, -0.846622>, <1.940219, -0.290371, -0.855323>, <1.697813, -0.291772, -0.897017>, 
      <2.509215, -0.312042, -0.685539>, <2.272641, -0.312042, -0.752872>, <1.940219, -0.310641, -0.761573>, <1.697813, -0.312042, -0.803267>, 
      <2.474595, -0.275590, -0.498213>, <2.234669, -0.275590, -0.552405>, <1.923733, -0.268933, -0.570296>, <1.681323, -0.268933, -0.611991>, 
      <2.509215, -0.359339, -0.466789>, <2.269290, -0.359339, -0.520981>, <1.940223, -0.359339, -0.542822>, <1.697813, -0.359339, -0.584517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.509215, -0.291772, -0.779289>, <2.272641, -0.291772, -0.846622>, <1.940219, -0.290371, -0.855323>, <1.697813, -0.291772, -0.897017>, 
      <2.509215, -0.291772, -0.779289>, <2.036054, -0.291772, -0.913958>, <1.939776, -0.292797, -0.856060>, <1.697371, -0.294198, -0.897754>, 
      <2.509215, -0.291772, -0.779289>, <2.036054, -0.291772, -0.913958>, <1.940232, -0.296376, -0.855321>, <1.697813, -0.297777, -0.897017>, 
      <2.509215, -0.291772, -0.779289>, <2.272628, -0.291772, -0.846625>, <1.940232, -0.298950, -0.855321>, <1.697813, -0.300351, -0.897017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.509215, -0.291772, -0.779289>, <2.509215, -0.312042, -0.685539>, <2.474595, -0.275590, -0.498213>, <2.509215, -0.359339, -0.466789>, 
      <3.308953, -0.291772, -0.551672>, <3.308953, -0.312042, -0.457922>, <3.312809, -0.275590, -0.308885>, <3.347430, -0.359339, -0.277461>, 
      <4.352964, -0.291772, -0.175285>, <4.413529, -0.293244, -0.153367>, <4.501560, -0.318628, 0.035774>, <4.454702, -0.359339, 0.018520>, 
      <5.143142, -0.291772, 0.083574>, <5.203708, -0.293244, 0.105492>, <5.335340, -0.318628, 0.243763>, <5.288482, -0.359339, 0.226510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.143142, -0.300351, 0.083574>, <4.352964, -0.297777, -0.175285>, <3.308956, -0.291772, -0.551671>, <2.509215, -0.291772, -0.779289>, 
      <5.143142, -0.300351, 0.083574>, <4.352964, -0.295204, -0.175285>, <4.108694, -0.291772, -0.324054>, <3.308953, -0.291772, -0.551672>, 
      <5.143142, -0.300351, 0.083574>, <4.352964, -0.295204, -0.175285>, <4.363345, -0.274395, -0.198618>, <4.361473, -0.272769, -0.199307>, 
      <5.143142, -0.300351, 0.083574>, <5.143142, -0.297777, 0.083574>, <5.145014, -0.293398, 0.084263>, <5.143142, -0.291772, 0.083574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.143142, -0.300351, 0.083574>, <5.143142, -0.297777, 0.083574>, <5.145014, -0.293398, 0.084263>, <5.143142, -0.291772, 0.083574>, 
      <5.143142, -0.300351, 0.083574>, <4.352964, -0.295204, -0.175285>, <4.354836, -0.293398, -0.174596>, <4.352964, -0.291772, -0.175285>, 
      <5.143142, -0.300351, 0.083574>, <4.352964, -0.295204, -0.175285>, <4.108694, -0.291772, -0.324054>, <3.308953, -0.291772, -0.551672>, 
      <5.143142, -0.300351, 0.083574>, <4.352964, -0.297777, -0.175285>, <3.308956, -0.291772, -0.551671>, <2.509215, -0.291772, -0.779289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.050547, 1.439130, -0.048387>, <-5.246632, 1.118329, -0.049555>, <-5.240464, 0.587658, 0.044229>, <-5.321857, 0.222742, 0.083921>, 
      <-4.648139, 0.937556, -0.214340>, <-4.844224, 0.616755, -0.215508>, <-5.403930, 0.433304, 0.116809>, <-5.485323, 0.068388, 0.156501>, 
      <-4.086488, 0.256503, -0.358063>, <-4.750598, 0.243682, -0.122541>, <-5.060692, -0.104875, 0.003212>, <-5.707959, -0.122572, 0.281437>, 
      <-3.709186, -0.232783, -0.601563>, <-4.373297, -0.245604, -0.366041>, <-5.219477, -0.274075, 0.047630>, <-5.866744, -0.291772, 0.325856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.671515, 2.922744, 0.093750>, <-3.387666, 2.980954, 0.073791>, <-4.732855, 1.958882, -0.046495>, <-5.050547, 1.439130, -0.048387>, 
      <-3.794589, 3.374104, 0.215556>, <-3.510740, 3.432314, 0.195597>, <-4.330447, 1.457308, -0.212448>, <-4.648139, 0.937556, -0.214340>, 
      <-3.058002, 0.692149, -0.423762>, <-3.327255, 0.692149, -0.375876>, <-3.828782, 0.261478, -0.449457>, <-4.086488, 0.256503, -0.358063>, 
      <-2.811085, -0.232783, -0.757813>, <-3.080338, -0.232783, -0.709928>, <-3.451480, -0.227808, -0.692957>, <-3.709186, -0.232783, -0.601563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.183254, 2.027138, -0.250000>, <-2.700058, 1.904333, -0.250000>, <-3.919035, 2.871984, 0.111154>, <-3.671515, 2.922744, 0.093750>, 
      <-2.113892, 1.349162, -0.449219>, <-2.630696, 1.226357, -0.449219>, <-4.042110, 3.323344, 0.232960>, <-3.794589, 3.374104, 0.215556>, 
      <-2.016815, 0.419226, -0.640494>, <-2.277616, 0.419226, -0.616085>, <-2.800109, 0.692149, -0.469627>, <-3.058002, 0.692149, -0.423762>, 
      <-1.952046, -0.232783, -0.914063>, <-2.212846, -0.232783, -0.889654>, <-2.553192, -0.232783, -0.803678>, <-2.811085, -0.232783, -0.757813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.283361, 3.490227, 0.093750>, <-1.034457, 3.519041, 0.093750>, <-1.671968, 2.148632, -0.250000>, <-2.183254, 2.027138, -0.250000>, 
      <-1.303638, 4.022759, 0.237906>, <-1.054734, 4.051573, 0.237906>, <-1.602606, 1.470655, -0.449219>, <-2.113892, 1.349162, -0.449219>, 
      <-1.182469, 0.859987, -0.533435>, <-1.422049, 0.867669, -0.492736>, <-1.774740, 0.419226, -0.663150>, <-2.016815, 0.419226, -0.640494>, 
      <-1.141602, -0.232783, -0.914063>, <-1.381182, -0.225100, -0.873364>, <-1.709971, -0.232783, -0.936719>, <-1.952046, -0.232783, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.129277, 2.294843, -0.250000>, <-0.422153, 2.416348, -0.250000>, <-1.550800, 3.459267, 0.093750>, <-1.283361, 3.490227, 0.093750>, 
      <0.056747, 1.518858, -0.542969>, <-0.494683, 1.640364, -0.542969>, <-1.571077, 3.991799, 0.237906>, <-1.303638, 4.022759, 0.237906>, 
      <-0.040167, 0.484549, -0.934436>, <-0.362045, 0.484549, -0.962958>, <-0.864053, 0.849776, -0.587527>, <-1.182469, 0.859987, -0.533435>, 
      <-0.112488, -0.291772, -1.226563>, <-0.434366, -0.291772, -1.255085>, <-0.823186, -0.242994, -0.968155>, <-1.141602, -0.232783, -0.914063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.311473, 2.918468, 0.093750>, <1.503506, 2.872725, 0.093750>, <0.533606, 2.205751, -0.250000>, <0.129277, 2.294843, -0.250000>, 
      <1.352452, 3.369217, 0.210445>, <1.544485, 3.323474, 0.210445>, <0.461077, 1.429766, -0.542969>, <0.056747, 1.518858, -0.542969>, 
      <1.107035, 0.689096, -0.398922>, <0.739361, 0.689096, -0.465854>, <0.332091, 0.484549, -0.901450>, <-0.040167, 0.484549, -0.934436>, 
      <1.024984, -0.232783, -0.722079>, <0.657309, -0.232783, -0.789010>, <0.259770, -0.291772, -1.193577>, <-0.112488, -0.291772, -1.226563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.086153, 1.828712, -0.250000>, <1.703366, 1.986831, -0.250000>, <1.119379, 2.964225, 0.093750>, <1.311473, 2.918468, 0.093750>, 
      <1.969651, 1.192567, -0.444105>, <1.586864, 1.350686, -0.444105>, <1.160358, 3.414974, 0.210445>, <1.352452, 3.369217, 0.210445>, 
      <1.813898, 0.344661, -0.703607>, <1.604909, 0.352967, -0.695551>, <1.312960, 0.689096, -0.361436>, <1.107035, 0.689096, -0.398922>, 
      <1.697813, -0.291772, -0.897017>, <1.488824, -0.283466, -0.888961>, <1.230909, -0.232783, -0.684593>, <1.024984, -0.232783, -0.722079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.471052, 2.026405, 0.093750>, <3.608631, 2.357993, 0.218628>, <2.797766, 0.403681, -0.517377>, <2.509215, -0.291772, -0.779289>, 
      <3.648921, 1.923006, 0.082377>, <3.786500, 2.254593, 0.207255>, <2.561192, 0.403681, -0.584710>, <2.272641, -0.291772, -0.846622>, 
      <2.485583, 1.663719, -0.250000>, <2.369081, 1.027573, -0.444105>, <2.059492, 0.334900, -0.713073>, <1.943406, -0.301533, -0.906484>, 
      <2.086153, 1.828712, -0.250000>, <1.969651, 1.192567, -0.444105>, <1.813898, 0.344661, -0.703607>, <1.697813, -0.291772, -0.897017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.471052, 2.026405, 0.093750>, <3.648921, 1.923006, 0.082377>, <2.485583, 1.663719, -0.250000>, <2.086153, 1.828712, -0.250000>, 
      <3.608631, 2.357993, 0.218628>, <3.786500, 2.254593, 0.207255>, <2.369081, 1.027573, -0.444105>, <1.969651, 1.192567, -0.444105>, 
      <2.797766, 0.403681, -0.517377>, <2.561192, 0.403681, -0.584710>, <2.056304, 0.346062, -0.661913>, <1.813898, 0.344661, -0.703607>, 
      <2.509215, -0.291772, -0.779289>, <2.272641, -0.291772, -0.846622>, <1.940219, -0.290371, -0.855323>, <1.697813, -0.291772, -0.897017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.918919, 0.763282, -0.367188>, <4.286186, 0.446766, -0.231959>, <4.777055, 0.026293, -0.051220>, <5.143142, -0.291772, 0.083574>, 
      <3.784559, 1.142219, -0.228907>, <4.151826, 0.825703, -0.093678>, <3.995386, 0.045296, -0.334101>, <4.361473, -0.272769, -0.199307>, 
      <3.296063, 2.128130, 0.104939>, <3.433642, 2.459718, 0.229817>, <3.597504, 0.403681, -0.289760>, <3.308953, -0.291772, -0.551672>, 
      <3.471052, 2.026405, 0.093750>, <3.608631, 2.357993, 0.218628>, <2.797766, 0.403681, -0.517377>, <2.509215, -0.291772, -0.779289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.918919, 0.763282, -0.367188>, <3.784559, 1.142219, -0.228907>, <3.296063, 2.128130, 0.104939>, <3.471052, 2.026405, 0.093750>, 
      <4.286186, 0.446766, -0.231959>, <4.151826, 0.825703, -0.093678>, <3.433642, 2.459718, 0.229817>, <3.608631, 2.357993, 0.218628>, 
      <4.777055, 0.026293, -0.051220>, <3.986877, 0.026293, -0.310079>, <3.597504, 0.403681, -0.289760>, <2.797766, 0.403681, -0.517377>, 
      <5.143142, -0.291772, 0.083574>, <4.352964, -0.291772, -0.175285>, <3.308953, -0.291772, -0.551672>, <2.509215, -0.291772, -0.779289>
    }
  }
  texture {
    leaves_T
    scale <20.0, 2.0, 1.0>
    rotate -180.0*z
    translate <-3.229412, -0.318393, 0.000000>
  }
  scale 0.12
  rotate <-8.344958, 8.001472, -122.622665>
  translate  <-1.113169, -30.515076, -1.16>
}
#declare floating_leaves = union {
  object { sPatchObj4 }
  object { // sPatchObj5->sPatchObj4
    sPatchObj4
    rotate <0.465928, -1.620804, -24.314322>
    translate  <-3.837203, 4.327501, 0.505032>
  }
  object { // sPatchObj6->sPatchObj4
    sPatchObj4
    rotate <-19.339325, 23.793661, -124.764656>
    translate  <8.227795, -25.936243, -9.569642>
  }
  object { // sPatchObj7->sPatchObj4
    sPatchObj4
    rotate <0.465928, -1.620804, -24.314322>
    translate  <10.753055, 56.744355, 0.505032>
  }
}


#declare sPatchObj = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.001936, 0.000000, 5.770173>, <3.001936, -0.042253, 5.770173>, <3.013039, -0.098672, 5.765720>, <3.040430, -0.098672, 5.797892>, 
      <2.751332, 0.000000, 5.808716>, <2.751332, -0.042253, 5.819580>, <2.762192, -0.132026, 5.861273>, <2.789584, -0.132026, 5.893446>, 
      <2.418672, 0.000000, 5.866498>, <2.418672, -0.108073, 5.893658>, <2.412010, -0.180359, 5.893524>, <2.444924, -0.180359, 5.996463>, 
      <2.166590, 0.000000, 5.907703>, <2.166590, -0.108073, 5.907703>, <2.171363, -0.209851, 6.013464>, <2.204276, -0.209851, 6.116403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.040430, 0.098672, 5.797892>, <3.013039, 0.098672, 5.765720>, <3.001936, 0.042253, 5.770173>, <3.001936, 0.000000, 5.770173>, 
      <2.789584, 0.132026, 5.893446>, <2.762192, 0.132026, 5.861273>, <2.751332, 0.042253, 5.819580>, <2.751332, 0.000000, 5.808716>, 
      <2.447242, 0.172331, 6.003591>, <2.414329, 0.172331, 5.900652>, <2.418672, 0.108073, 5.893658>, <2.418672, 0.000000, 5.866498>, 
      <2.204276, 0.209851, 6.116403>, <2.171363, 0.209851, 6.013464>, <2.166590, 0.108073, 5.907703>, <2.166590, 0.000000, 5.907703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.113370, 0.000000, 5.901055>, <3.113370, 0.061869, 5.901055>, <3.080538, 0.098672, 5.845000>, <3.040430, 0.098672, 5.797892>, 
      <2.857580, 0.000000, 5.999531>, <2.857580, 0.061869, 5.999531>, <2.829692, 0.132026, 5.940553>, <2.789584, 0.132026, 5.893446>, 
      <2.497102, 0.000000, 6.090540>, <2.497102, 0.094514, 6.090540>, <2.476026, 0.172331, 6.093615>, <2.447242, 0.172331, 6.003591>, 
      <2.260736, 0.000000, 6.229310>, <2.260736, 0.094514, 6.229310>, <2.233060, 0.209851, 6.206427>, <2.204276, 0.209851, 6.116403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.113370, 0.000000, 5.901055>, <2.857580, 0.000000, 5.999531>, <2.497102, 0.000000, 6.090540>, <2.260736, 0.000000, 6.229310>, 
      <3.113370, -0.061869, 5.901055>, <2.857580, -0.061869, 5.999531>, <2.497102, -0.094514, 6.090540>, <2.260736, -0.094514, 6.229310>, 
      <3.080538, -0.098672, 5.845000>, <2.829692, -0.132026, 5.940553>, <2.473708, -0.180359, 6.086487>, <2.233060, -0.209851, 6.206427>, 
      <3.040430, -0.098672, 5.797892>, <2.789584, -0.132026, 5.893446>, <2.444924, -0.180359, 5.996463>, <2.204276, -0.209851, 6.116403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.615103, 0.000000, 5.996861>, <1.780549, 0.000000, 5.978262>, <2.002282, 0.000000, 5.934560>, <2.166590, 0.000000, 5.907703>, 
      <1.608377, -0.204128, 6.016276>, <1.773823, -0.204128, 5.997676>, <2.002282, -0.108073, 5.934560>, <2.166590, -0.108073, 5.907703>, 
      <1.696076, -0.257390, 6.244216>, <1.833755, -0.243128, 6.146125>, <2.020432, -0.228348, 6.088689>, <2.171363, -0.209851, 6.013464>, 
      <1.745344, -0.257390, 6.443371>, <1.883024, -0.243128, 6.345281>, <2.053346, -0.228348, 6.191628>, <2.204276, -0.209851, 6.116403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.763574, 0.295850, 6.390752>, <1.895785, 0.270050, 6.308447>, <2.062482, 0.231747, 6.182240>, <2.204276, 0.209851, 6.116403>, 
      <1.715888, 0.295850, 6.197994>, <1.848099, 0.270050, 6.115689>, <2.029569, 0.231747, 6.079301>, <2.171363, 0.209851, 6.013464>, 
      <1.621613, 0.197571, 5.978070>, <1.787059, 0.197571, 5.959470>, <2.002282, 0.108073, 5.934560>, <2.166590, 0.108073, 5.907703>, 
      <1.615103, 0.000000, 5.996861>, <1.780549, 0.000000, 5.978262>, <2.002282, 0.000000, 5.934560>, <2.166590, 0.000000, 5.907703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.784419, 0.000000, 6.681277>, <1.927314, 0.000000, 6.545687>, <2.090862, 0.000000, 6.329042>, <2.260736, 0.000000, 6.229310>, 
      <1.789672, 0.159425, 6.666114>, <1.932567, 0.159425, 6.530524>, <2.090862, 0.094514, 6.329042>, <2.260736, 0.094514, 6.229310>, 
      <1.802053, 0.295850, 6.546293>, <1.934264, 0.270050, 6.463988>, <2.091266, 0.231747, 6.272264>, <2.233060, 0.209851, 6.206427>, 
      <1.763574, 0.295850, 6.390752>, <1.895785, 0.270050, 6.308447>, <2.062482, 0.231747, 6.182240>, <2.204276, 0.209851, 6.116403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.784419, 0.000000, 6.681277>, <1.779957, -0.135424, 6.694157>, <1.778030, -0.257390, 6.575496>, <1.745344, -0.257390, 6.443371>, 
      <1.927314, 0.000000, 6.545687>, <1.922852, -0.135424, 6.558567>, <1.915710, -0.243128, 6.477406>, <1.883024, -0.243128, 6.345281>, 
      <2.090862, 0.000000, 6.329042>, <2.090862, -0.094514, 6.329042>, <2.082130, -0.228348, 6.281652>, <2.053346, -0.228348, 6.191628>, 
      <2.260736, 0.000000, 6.229310>, <2.260736, -0.094514, 6.229310>, <2.233060, -0.209851, 6.206427>, <2.204276, -0.209851, 6.116403>
    }
  }
  texture {
    SOrange_T_1
    rotate 16.231646*y
    translate <2.529422, 0.000000, 6.964370>
  }
}
#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.106119, 0.000000, 6.003459>, <1.230615, 0.000000, 5.928324>, <1.445410, 0.000000, 6.002116>, <1.590820, 0.000000, 6.001540>, 
      <1.106494, -0.349876, 6.000226>, <1.230990, -0.349876, 5.925090>, <1.448572, -0.205252, 6.001053>, <1.593983, -0.205252, 6.000478>, 
      <1.193354, -0.676717, 6.245970>, <1.371715, -0.620752, 6.161406>, <1.492821, -0.392502, 6.301894>, <1.650337, -0.270709, 6.252382>, 
      <1.230093, -0.676684, 6.593927>, <1.408454, -0.620719, 6.509363>, <1.597629, -0.392502, 6.478400>, <1.755145, -0.270709, 6.428889>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.228651, 0.669049, 6.606364>, <1.400702, 0.617415, 6.524617>, <1.591014, 0.412471, 6.484208>, <1.746312, 0.302509, 6.431855>, 
      <1.191818, 0.669016, 6.257516>, <1.363869, 0.617382, 6.175770>, <1.482932, 0.412471, 6.302188>, <1.638230, 0.302509, 6.249836>, 
      <1.105743, 0.350771, 6.006700>, <1.230239, 0.350771, 5.931565>, <1.442148, 0.211662, 6.003211>, <1.587558, 0.211662, 6.002636>, 
      <1.106119, 0.000000, 6.003459>, <1.230615, 0.000000, 5.928324>, <1.445410, 0.000000, 6.002116>, <1.590820, 0.000000, 6.001540>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.255265, 0.000134, 7.416021>, <1.550746, 0.000134, 7.277625>, <1.720020, 0.000040, 6.813000>, <1.919201, 0.000000, 6.554563>, 
      <1.254831, 0.405572, 7.419768>, <1.550312, 0.405572, 7.281371>, <1.717824, 0.142589, 6.813738>, <1.917004, 0.142548, 6.555301>, 
      <1.271225, 0.669087, 7.009578>, <1.443275, 0.617453, 6.927831>, <1.663804, 0.412471, 6.606792>, <1.819102, 0.302509, 6.554440>, 
      <1.228651, 0.669049, 6.606364>, <1.400702, 0.617415, 6.524617>, <1.591014, 0.412471, 6.484208>, <1.746312, 0.302509, 6.431855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.255265, 0.000134, 7.416021>, <1.255705, -0.410932, 7.412222>, <1.273257, -0.676645, 7.002738>, <1.230093, -0.676684, 6.593927>, 
      <1.550746, 0.000134, 7.277625>, <1.551187, -0.410932, 7.273826>, <1.451619, -0.620680, 6.918174>, <1.408454, -0.620719, 6.509363>, 
      <1.720020, 0.000040, 6.813000>, <1.722045, -0.131383, 6.812320>, <1.664739, -0.392502, 6.591418>, <1.597629, -0.392502, 6.478400>, 
      <1.919201, 0.000000, 6.554563>, <1.921226, -0.131424, 6.553882>, <1.822254, -0.270709, 6.541907>, <1.755145, -0.270709, 6.428889>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.133736, 0.000000, 6.277398>, <1.125451, 0.000000, 6.195216>, <1.035402, 0.000000, 6.046138>, <1.106119, 0.000000, 6.003459>, 
      <1.133420, -0.536623, 6.277459>, <1.125135, -0.536623, 6.195277>, <1.035777, -0.349876, 6.042905>, <1.106494, -0.349876, 6.000226>, 
      <0.292026, -0.727436, 6.853539>, <0.389790, -0.722104, 6.798372>, <0.914390, -0.764249, 6.378232>, <1.193354, -0.676717, 6.245970>, 
      <0.299561, -0.727436, 7.119007>, <0.397326, -0.722104, 7.063840>, <0.951129, -0.764216, 6.726189>, <1.230093, -0.676684, 6.593927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.300422, 0.736432, 7.118841>, <0.397945, 0.729353, 7.064998>, <0.950789, 0.752438, 6.738384>, <1.228651, 0.669049, 6.606364>, 
      <0.292864, 0.736432, 6.852588>, <0.390387, 0.729353, 6.798745>, <0.913956, 0.752405, 6.389537>, <1.191818, 0.669016, 6.257516>, 
      <1.134053, 0.538210, 6.277337>, <1.125768, 0.538210, 6.195155>, <1.035026, 0.350771, 6.049380>, <1.105743, 0.350771, 6.006700>, 
      <1.133736, 0.000000, 6.277398>, <1.125451, 0.000000, 6.195216>, <1.035402, 0.000000, 6.046138>, <1.106119, 0.000000, 6.003459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151806, 0.000000, 6.913993>, <1.182844, 0.000040, 7.064602>, <1.116010, 0.000134, 7.481245>, <1.255265, 0.000134, 7.416021>, 
      <1.152066, 0.441583, 6.913943>, <1.183103, 0.441623, 7.064551>, <1.115575, 0.405572, 7.484992>, <1.254831, 0.405572, 7.419768>, 
      <0.306623, 0.736432, 7.337293>, <0.404145, 0.729353, 7.283450>, <0.993363, 0.752476, 7.141598>, <1.271225, 0.669087, 7.009578>, 
      <0.300422, 0.736432, 7.118841>, <0.397945, 0.729353, 7.064998>, <0.950789, 0.752438, 6.738384>, <1.228651, 0.669049, 6.606364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151806, 0.000000, 6.913993>, <1.151547, -0.439616, 6.914043>, <0.305734, -0.727436, 7.336486>, <0.299561, -0.727436, 7.119007>, 
      <1.182844, 0.000040, 7.064602>, <1.182585, -0.439576, 7.064651>, <0.403499, -0.722104, 7.281319>, <0.397326, -0.722104, 7.063840>, 
      <1.116010, 0.000134, 7.481245>, <1.116450, -0.410932, 7.477446>, <0.994294, -0.764177, 7.135000>, <0.951129, -0.764216, 6.726189>, 
      <1.255265, 0.000134, 7.416021>, <1.255705, -0.410932, 7.412222>, <1.273257, -0.676645, 7.002738>, <1.230093, -0.676684, 6.593927>
    }
  }
  texture {
    SBlack_T
  }
}
#declare sPatchObj2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.943200, 1.386041, 0.602709>, <-5.696690, 1.480386, 0.593326>, <-5.378792, 1.644144, 0.590880>, <-5.121500, 1.700524, 0.571432>, 
      <-5.782026, 1.464418, 0.523792>, <-5.535516, 1.558763, 0.514409>, <-5.296464, 1.764318, 0.415124>, <-5.039172, 1.820698, 0.395676>, 
      <-5.576892, 1.522019, 0.365830>, <-5.356112, 1.582056, 0.272747>, <-5.039219, 1.726210, 0.238886>, <-4.815230, 1.756451, 0.139252>, 
      <-5.419903, 1.580295, 0.264311>, <-5.199123, 1.640333, 0.171227>, <-4.907960, 1.750179, 0.053666>, <-4.683971, 1.780420, -0.045968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.657162, 0.978634, 0.870115>, <-6.283535, 0.900474, 1.061385>, <-5.807548, 0.735540, 1.348557>, <-5.411738, 0.718102, 1.507682>, 
      <-6.442974, 1.100856, 0.789893>, <-6.069346, 1.022696, 0.981163>, <-5.720477, 1.030266, 1.067682>, <-5.324666, 1.012829, 1.226807>, 
      <-6.156639, 1.282249, 0.707216>, <-5.910128, 1.376594, 0.697833>, <-5.528945, 1.424966, 0.911429>, <-5.271653, 1.481347, 0.891981>, 
      <-5.943200, 1.386041, 0.602709>, <-5.696690, 1.480386, 0.593326>, <-5.378792, 1.644144, 0.590880>, <-5.121500, 1.700524, 0.571432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.116657, 1.786292, 0.464645>, <-4.037989, 1.900799, 0.183420>, <-3.830399, 1.803910, -0.208714>, <-3.707717, 1.811460, -0.497297>, 
      <-4.418526, 1.755014, 0.486063>, <-4.339858, 1.869520, 0.204839>, <-4.141687, 1.787062, -0.124980>, <-4.019006, 1.794613, -0.413563>, 
      <-4.825118, 1.765470, 0.549029>, <-4.742790, 1.885644, 0.373273>, <-4.522516, 1.795971, 0.009048>, <-4.391257, 1.819940, -0.176172>, 
      <-5.121500, 1.700524, 0.571432>, <-5.039172, 1.820698, 0.395676>, <-4.815230, 1.756451, 0.139252>, <-4.683971, 1.780420, -0.045968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.349717, 0.876978, 1.797759>, <-4.279799, 1.149772, 1.397825>, <-4.239331, 1.607730, 0.903187>, <-4.116657, 1.786292, 0.464645>, 
      <-4.677357, 0.845297, 1.742958>, <-4.607438, 1.118091, 1.343023>, <-4.541200, 1.576451, 0.924606>, <-4.418526, 1.755014, 0.486063>, 
      <-5.102381, 0.704473, 1.632050>, <-5.015310, 0.999200, 1.351175>, <-4.975271, 1.546293, 0.869578>, <-4.825118, 1.765470, 0.549029>, 
      <-5.411738, 0.718102, 1.507682>, <-5.324666, 1.012829, 1.226807>, <-5.271653, 1.481347, 0.891981>, <-5.121500, 1.700524, 0.571432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.080621, 1.911991, 0.426626>, <-3.009606, 2.028907, 0.128464>, <-2.794363, 1.896126, -0.283091>, <-2.671681, 1.889327, -0.587256>, 
      <-3.393328, 1.918799, 0.444606>, <-3.322314, 2.035715, 0.146443>, <-3.106978, 1.903993, -0.273749>, <-2.984296, 1.897193, -0.577913>, 
      <-3.805801, 1.818501, 0.442589>, <-3.727133, 1.933008, 0.161364>, <-3.528696, 1.820238, -0.289870>, <-3.406014, 1.827788, -0.578452>, 
      <-4.116657, 1.786292, 0.464645>, <-4.037989, 1.900799, 0.183420>, <-3.830399, 1.803910, -0.208714>, <-3.707717, 1.811460, -0.497297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.256501, 0.926504, 1.868169>, <-3.203737, 1.222150, 1.435706>, <-3.194600, 1.724341, 0.905177>, <-3.080621, 1.911991, 0.426626>, 
      <-3.582312, 0.923484, 1.913621>, <-3.529548, 1.219130, 1.481158>, <-3.507307, 1.731150, 0.923157>, <-3.393328, 1.918799, 0.444606>, 
      <-4.026710, 0.908211, 1.851786>, <-3.956792, 1.181005, 1.451851>, <-3.928475, 1.639939, 0.881131>, <-3.805801, 1.818501, 0.442589>, 
      <-4.349717, 0.876978, 1.797759>, <-4.279799, 1.149772, 1.397825>, <-4.239331, 1.607730, 0.903187>, <-4.116657, 1.786292, 0.464645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.880578, 1.737607, 0.336077>, <-1.803999, 1.845361, 0.078736>, <-1.635636, 1.750957, -0.292830>, <-1.530661, 1.756679, -0.562361>, 
      <-2.230715, 1.819946, 0.396974>, <-2.154136, 1.927700, 0.139633>, <-1.968437, 1.838838, -0.311090>, <-1.863462, 1.844560, -0.580621>, 
      <-2.716502, 1.904063, 0.405690>, <-2.645487, 2.020979, 0.107528>, <-2.449934, 1.887459, -0.293385>, <-2.327251, 1.880660, -0.597550>, 
      <-3.080621, 1.911991, 0.426626>, <-3.009606, 2.028907, 0.128464>, <-2.794363, 1.896126, -0.283091>, <-2.671681, 1.889327, -0.587256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.141304, 0.897447, 1.489674>, <-2.063086, 1.149495, 1.143595>, <-1.995780, 1.575507, 0.723206>, <-1.880578, 1.737607, 0.336077>, 
      <-2.452786, 0.854970, 1.651147>, <-2.374569, 1.107018, 1.305068>, <-2.345917, 1.657847, 0.784104>, <-2.230715, 1.819946, 0.396974>, 
      <-2.906495, 0.929748, 1.819341>, <-2.853731, 1.225394, 1.386878>, <-2.830481, 1.716413, 0.884241>, <-2.716502, 1.904063, 0.405690>, 
      <-3.256501, 0.926504, 1.868169>, <-3.203737, 1.222150, 1.435706>, <-3.194600, 1.724341, 0.905177>, <-3.080621, 1.911991, 0.426626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.052668, 1.435093, 0.073916>, <-0.990551, 1.459483, -0.104017>, <-0.843282, 1.398499, -0.315234>, <-0.753545, 1.382816, -0.482012>, 
      <-1.301041, 1.525847, 0.152564>, <-1.238924, 1.550237, -0.025369>, <-1.076417, 1.510658, -0.339338>, <-0.986680, 1.494975, -0.506117>, 
      <-1.615790, 1.675339, 0.290024>, <-1.539210, 1.783093, 0.032683>, <-1.384768, 1.684712, -0.279065>, <-1.279793, 1.690434, -0.548597>, 
      <-1.880578, 1.737607, 0.336077>, <-1.803999, 1.845361, 0.078736>, <-1.635636, 1.750957, -0.292830>, <-1.530661, 1.756679, -0.562361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.202229, 1.206646, 0.803233>, <-1.157361, 1.275180, 0.584438>, <-1.129034, 1.405109, 0.292664>, <-1.052668, 1.435093, 0.073916>, 
      <-1.483952, 1.113886, 1.009165>, <-1.439083, 1.182420, 0.790370>, <-1.377407, 1.495863, 0.371312>, <-1.301041, 1.525847, 0.152564>, 
      <-1.823061, 0.940846, 1.324696>, <-1.744843, 1.192894, 0.978617>, <-1.730991, 1.513239, 0.677153>, <-1.615790, 1.675339, 0.290024>, 
      <-2.141304, 0.897447, 1.489674>, <-2.063086, 1.149495, 1.143595>, <-1.995780, 1.575507, 0.723206>, <-1.880578, 1.737607, 0.336077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.943200, -1.353848, 0.602709>, <-5.696690, -1.448193, 0.593326>, <-5.378792, -1.611951, 0.590880>, <-5.121500, -1.668331, 0.571432>, 
      <-5.782026, -1.432225, 0.523792>, <-5.535516, -1.526570, 0.514409>, <-5.296464, -1.732125, 0.415124>, <-5.039172, -1.788505, 0.395676>, 
      <-5.576892, -1.489826, 0.365830>, <-5.356112, -1.549863, 0.272747>, <-5.039219, -1.694017, 0.238886>, <-4.815230, -1.724258, 0.139252>, 
      <-5.419903, -1.548102, 0.264311>, <-5.199123, -1.608140, 0.171227>, <-4.907960, -1.717986, 0.053666>, <-4.683971, -1.748227, -0.045968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.657162, -0.946441, 0.870115>, <-6.283535, -0.868281, 1.061385>, <-5.807548, -0.703347, 1.348557>, <-5.411738, -0.685909, 1.507682>, 
      <-6.442974, -1.068663, 0.789893>, <-6.069346, -0.990503, 0.981163>, <-5.720477, -0.998073, 1.067682>, <-5.324666, -0.980636, 1.226807>, 
      <-6.156639, -1.250056, 0.707216>, <-5.910128, -1.344401, 0.697833>, <-5.528945, -1.392773, 0.911429>, <-5.271653, -1.449154, 0.891981>, 
      <-5.943200, -1.353848, 0.602709>, <-5.696690, -1.448193, 0.593326>, <-5.378792, -1.611951, 0.590880>, <-5.121500, -1.668331, 0.571432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.116657, -1.754099, 0.464645>, <-4.037989, -1.868606, 0.183420>, <-3.830399, -1.771717, -0.208714>, <-3.707717, -1.779267, -0.497297>, 
      <-4.418526, -1.722821, 0.486063>, <-4.339858, -1.837327, 0.204839>, <-4.141687, -1.754869, -0.124980>, <-4.019006, -1.762420, -0.413563>, 
      <-4.825118, -1.733277, 0.549029>, <-4.742790, -1.853451, 0.373273>, <-4.522516, -1.763778, 0.009048>, <-4.391257, -1.787747, -0.176172>, 
      <-5.121500, -1.668331, 0.571432>, <-5.039172, -1.788505, 0.395676>, <-4.815230, -1.724258, 0.139252>, <-4.683971, -1.748227, -0.045968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.349717, -0.844785, 1.797759>, <-4.279799, -1.117579, 1.397825>, <-4.239331, -1.575537, 0.903187>, <-4.116657, -1.754099, 0.464645>, 
      <-4.677357, -0.813104, 1.742958>, <-4.607438, -1.085898, 1.343023>, <-4.541200, -1.544259, 0.924606>, <-4.418526, -1.722821, 0.486063>, 
      <-5.102381, -0.672280, 1.632050>, <-5.015310, -0.967007, 1.351175>, <-4.975271, -1.514100, 0.869578>, <-4.825118, -1.733277, 0.549029>, 
      <-5.411738, -0.685909, 1.507682>, <-5.324666, -0.980636, 1.226807>, <-5.271653, -1.449154, 0.891981>, <-5.121500, -1.668331, 0.571432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.080621, -1.879798, 0.426626>, <-3.009606, -1.996714, 0.128464>, <-2.794363, -1.863933, -0.283091>, <-2.671681, -1.857134, -0.587256>, 
      <-3.393328, -1.886606, 0.444606>, <-3.322314, -2.003522, 0.146443>, <-3.106978, -1.871799, -0.273749>, <-2.984296, -1.865000, -0.577913>, 
      <-3.805801, -1.786309, 0.442589>, <-3.727133, -1.900815, 0.161364>, <-3.528696, -1.788045, -0.289870>, <-3.406014, -1.795595, -0.578452>, 
      <-4.116657, -1.754099, 0.464645>, <-4.037989, -1.868606, 0.183420>, <-3.830399, -1.771717, -0.208714>, <-3.707717, -1.779267, -0.497297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.256501, -0.894311, 1.868169>, <-3.203737, -1.189957, 1.435706>, <-3.194600, -1.692148, 0.905177>, <-3.080621, -1.879798, 0.426626>, 
      <-3.582312, -0.891291, 1.913621>, <-3.529548, -1.186937, 1.481158>, <-3.507307, -1.698957, 0.923157>, <-3.393328, -1.886606, 0.444606>, 
      <-4.026710, -0.876018, 1.851786>, <-3.956792, -1.148813, 1.451851>, <-3.928475, -1.607747, 0.881131>, <-3.805801, -1.786309, 0.442589>, 
      <-4.349717, -0.844785, 1.797759>, <-4.279799, -1.117579, 1.397825>, <-4.239331, -1.575537, 0.903187>, <-4.116657, -1.754099, 0.464645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.880578, -1.705414, 0.336077>, <-1.803999, -1.813168, 0.078736>, <-1.635636, -1.718764, -0.292830>, <-1.530661, -1.724486, -0.562361>, 
      <-2.230715, -1.787753, 0.396974>, <-2.154136, -1.895507, 0.139633>, <-1.968437, -1.806645, -0.311090>, <-1.863462, -1.812367, -0.580621>, 
      <-2.716502, -1.871870, 0.405690>, <-2.645487, -1.988786, 0.107528>, <-2.449934, -1.855266, -0.293385>, <-2.327251, -1.848467, -0.597550>, 
      <-3.080621, -1.879798, 0.426626>, <-3.009606, -1.996714, 0.128464>, <-2.794363, -1.863933, -0.283091>, <-2.671681, -1.857134, -0.587256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.141304, -0.865254, 1.489674>, <-2.063086, -1.117302, 1.143595>, <-1.995780, -1.543314, 0.723206>, <-1.880578, -1.705414, 0.336077>, 
      <-2.452786, -0.822777, 1.651147>, <-2.374569, -1.074825, 1.305068>, <-2.345917, -1.625654, 0.784104>, <-2.230715, -1.787753, 0.396974>, 
      <-2.906495, -0.897555, 1.819341>, <-2.853731, -1.193201, 1.386878>, <-2.830481, -1.684220, 0.884241>, <-2.716502, -1.871870, 0.405690>, 
      <-3.256501, -0.894311, 1.868169>, <-3.203737, -1.189957, 1.435706>, <-3.194600, -1.692148, 0.905177>, <-3.080621, -1.879798, 0.426626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.052668, -1.402900, 0.073916>, <-0.990551, -1.427290, -0.104017>, <-0.843282, -1.366306, -0.315234>, <-0.753545, -1.350623, -0.482012>, 
      <-1.301041, -1.493654, 0.152564>, <-1.238924, -1.518044, -0.025369>, <-1.076417, -1.478465, -0.339338>, <-0.986680, -1.462782, -0.506117>, 
      <-1.615790, -1.643146, 0.290024>, <-1.539210, -1.750900, 0.032683>, <-1.384768, -1.652519, -0.279065>, <-1.279793, -1.658241, -0.548597>, 
      <-1.880578, -1.705414, 0.336077>, <-1.803999, -1.813168, 0.078736>, <-1.635636, -1.718764, -0.292830>, <-1.530661, -1.724486, -0.562361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.202229, -1.174453, 0.803233>, <-1.157361, -1.242987, 0.584438>, <-1.129034, -1.372916, 0.292664>, <-1.052668, -1.402900, 0.073916>, 
      <-1.483952, -1.081693, 1.009165>, <-1.439083, -1.150227, 0.790370>, <-1.377407, -1.463670, 0.371312>, <-1.301041, -1.493654, 0.152564>, 
      <-1.823061, -0.908653, 1.324696>, <-1.744843, -1.160701, 0.978617>, <-1.730991, -1.481046, 0.677153>, <-1.615790, -1.643146, 0.290024>, 
      <-2.141304, -0.865254, 1.489674>, <-2.063086, -1.117302, 1.143595>, <-1.995780, -1.543314, 0.723206>, <-1.880578, -1.705414, 0.336077>
    }
  }
  texture {
    SWing_T_1
  }
}
#declare sPatchObj3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.940074, 0.059975, 1.069265>, <-8.653002, 0.041982, 0.768863>, <-8.283578, 0.009442, 0.355397>, <-7.983167, 0.000000, 0.067925>, 
      <-8.940074, -0.091658, 1.069265>, <-8.653002, -0.109650, 0.768863>, <-8.283578, -0.239694, 0.355397>, <-7.983167, -0.249136, 0.067925>, 
      <-8.922060, -0.316282, 1.005182>, <-8.638830, -0.379318, 0.793537>, <-8.205940, -0.455535, 0.386025>, <-7.917015, -0.526402, 0.184811>, 
      <-8.851186, -0.316282, 1.139232>, <-8.567955, -0.379318, 0.927587>, <-8.196008, -0.455535, 0.634963>, <-7.907083, -0.526402, 0.433749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.851186, 0.436231, 1.139232>, <-8.567955, 0.463282, 0.927587>, <-8.194841, 0.473672, 0.634150>, <-7.907083, 0.526402, 0.433749>, 
      <-8.922059, 0.436231, 1.005182>, <-8.638828, 0.463282, 0.793538>, <-8.204773, 0.473672, 0.385211>, <-7.917015, 0.526402, 0.184811>, 
      <-8.940074, 0.211607, 1.069265>, <-8.653002, 0.193615, 0.768863>, <-8.283578, 0.258578, 0.355397>, <-7.983167, 0.249136, 0.067925>, 
      <-8.940074, 0.059975, 1.069265>, <-8.653002, 0.041982, 0.768863>, <-8.283578, 0.009442, 0.355397>, <-7.983167, 0.000000, 0.067925>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.831084, 0.059975, 1.275407>, <-8.564337, 0.041982, 1.223262>, <-8.210967, 0.008779, 1.143261>, <-7.941925, 0.000000, 1.101591>, 
      <-8.831084, 0.214599, 1.275407>, <-8.564337, 0.196607, 1.223262>, <-8.210967, 0.337241, 1.143261>, <-7.941925, 0.328462, 1.101591>, 
      <-8.778914, 0.436231, 1.275927>, <-8.495682, 0.463282, 1.064282>, <-8.181746, 0.473672, 0.962350>, <-7.893988, 0.526402, 0.761949>, 
      <-8.851186, 0.436231, 1.139232>, <-8.567955, 0.463282, 0.927587>, <-8.194841, 0.473672, 0.634150>, <-7.907083, 0.526402, 0.433749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.831084, 0.059975, 1.275407>, <-8.831084, -0.094649, 1.275407>, <-8.778914, -0.316282, 1.275927>, <-8.851186, -0.316282, 1.139232>, 
      <-8.564337, 0.041982, 1.223262>, <-8.564337, -0.112642, 1.223262>, <-8.495682, -0.379318, 1.064282>, <-8.567955, -0.379318, 0.927587>, 
      <-8.210967, 0.008779, 1.143261>, <-8.210967, -0.319682, 1.143261>, <-8.182913, -0.455535, 0.963163>, <-8.196008, -0.455535, 0.634963>, 
      <-7.941925, 0.000000, 1.101591>, <-7.941925, -0.328462, 1.101591>, <-7.893988, -0.526402, 0.761949>, <-7.907083, -0.526402, 0.433749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.031871, 0.000000, -0.756752>, <-7.031871, -0.374153, -0.756752>, <-6.925890, -0.790550, -0.581419>, <-6.917607, -0.790550, -0.207358>, 
      <-7.347017, 0.000000, -0.548574>, <-7.347017, -0.374153, -0.548574>, <-7.243608, -0.700438, -0.432015>, <-7.235326, -0.700438, -0.057954>, 
      <-7.710354, -0.008575, -0.193139>, <-7.710354, -0.257711, -0.193139>, <-7.625414, -0.597926, -0.018267>, <-7.615482, -0.597926, 0.230672>, 
      <-7.983167, 0.000000, 0.067925>, <-7.983167, -0.249136, 0.067925>, <-7.917015, -0.526402, 0.184811>, <-7.907083, -0.526402, 0.433749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.917607, 0.790550, -0.207358>, <-6.925890, 0.790550, -0.581419>, <-7.031871, 0.374153, -0.756752>, <-7.031871, 0.000000, -0.756752>, 
      <-7.235326, 0.700438, -0.057954>, <-7.243608, 0.700438, -0.432015>, <-7.347017, 0.374153, -0.548574>, <-7.347017, 0.000000, -0.548574>, 
      <-7.612942, 0.580302, 0.228902>, <-7.622874, 0.580302, -0.020036>, <-7.710354, 0.240562, -0.193139>, <-7.710354, -0.008575, -0.193139>, 
      <-7.907083, 0.526402, 0.433749>, <-7.917015, 0.526402, 0.184811>, <-7.983167, 0.249136, 0.067925>, <-7.983167, 0.000000, 0.067925>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.993176, 0.000000, 0.990744>, <-6.993176, 0.554749, 0.990744>, <-6.905326, 0.790550, 0.347255>, <-6.917607, 0.790550, -0.207358>, 
      <-7.279730, 0.000000, 0.988742>, <-7.279730, 0.554749, 0.988742>, <-7.223044, 0.700438, 0.496659>, <-7.235326, 0.700438, -0.057954>, 
      <-7.658888, -0.009236, 1.057753>, <-7.658888, 0.319226, 1.057753>, <-7.599846, 0.580302, 0.557102>, <-7.612942, 0.580302, 0.228902>, 
      <-7.941925, 0.000000, 1.101591>, <-7.941925, 0.328462, 1.101591>, <-7.893988, 0.526402, 0.761949>, <-7.907083, 0.526402, 0.433749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.993176, 0.000000, 0.990744>, <-7.279730, 0.000000, 0.988742>, <-7.658888, -0.009236, 1.057753>, <-7.941925, 0.000000, 1.101591>, 
      <-6.993176, -0.554749, 0.990744>, <-7.279730, -0.554749, 0.988742>, <-7.658888, -0.337698, 1.057753>, <-7.941925, -0.328462, 1.101591>, 
      <-6.905326, -0.790550, 0.347255>, <-7.223044, -0.700438, 0.496659>, <-7.602387, -0.597926, 0.558872>, <-7.893988, -0.526402, 0.761949>, 
      <-6.917607, -0.790550, -0.207358>, <-7.235326, -0.700438, -0.057954>, <-7.615482, -0.597926, 0.230672>, <-7.907083, -0.526402, 0.433749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.964610, 0.000000, -1.265487>, <-5.964610, -0.514232, -1.265487>, <-5.859989, -1.086525, -1.004067>, <-5.932188, -1.086525, -0.494928>, 
      <-6.284716, 0.000000, -1.112715>, <-6.284716, -0.514232, -1.112715>, <-6.153729, -0.982086, -0.929699>, <-6.225928, -0.982086, -0.420560>, 
      <-6.735919, 0.000000, -0.952251>, <-6.735919, -0.374153, -0.952251>, <-6.644960, -0.870228, -0.713524>, <-6.636678, -0.870228, -0.339463>, 
      <-7.031871, 0.000000, -0.756752>, <-7.031871, -0.374153, -0.756752>, <-6.925890, -0.790550, -0.581419>, <-6.917607, -0.790550, -0.207358>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.932188, 1.086525, -0.494928>, <-5.859989, 1.086525, -1.004067>, <-5.964610, 0.514232, -1.265487>, <-5.964610, 0.000000, -1.265487>, 
      <-6.225928, 0.982086, -0.420560>, <-6.153729, 0.982086, -0.929699>, <-6.284716, 0.514232, -1.112715>, <-6.284716, 0.000000, -1.112715>, 
      <-6.636678, 0.870228, -0.339463>, <-6.644960, 0.870228, -0.713524>, <-6.735919, 0.374153, -0.952251>, <-6.735919, 0.000000, -0.952251>, 
      <-6.917607, 0.790550, -0.207358>, <-6.925890, 0.790550, -0.581419>, <-7.031871, 0.374153, -0.756752>, <-7.031871, 0.000000, -0.756752>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.301904, 0.000000, 1.113050>, <-6.301904, 0.762442, 1.113050>, <-6.039237, 1.086525, 0.259962>, <-5.932188, 1.086525, -0.494928>, 
      <-6.501515, 0.000000, 1.045903>, <-6.501515, 0.762442, 1.045903>, <-6.332977, 0.982086, 0.334329>, <-6.225928, 0.982086, -0.420560>, 
      <-6.782578, 0.000000, 0.992216>, <-6.782578, 0.554749, 0.992216>, <-6.624397, 0.870228, 0.215150>, <-6.636678, 0.870228, -0.339463>, 
      <-6.993176, 0.000000, 0.990744>, <-6.993176, 0.554749, 0.990744>, <-6.905326, 0.790550, 0.347255>, <-6.917607, 0.790550, -0.207358>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.301904, 0.000000, 1.113050>, <-6.501515, 0.000000, 1.045903>, <-6.782578, 0.000000, 0.992216>, <-6.993176, 0.000000, 0.990744>, 
      <-6.301904, -0.762442, 1.113050>, <-6.501515, -0.762442, 1.045903>, <-6.782578, -0.554749, 0.992216>, <-6.993176, -0.554749, 0.990744>, 
      <-6.039237, -1.086525, 0.259962>, <-6.332977, -0.982086, 0.334329>, <-6.624397, -0.870228, 0.215150>, <-6.905326, -0.790550, 0.347255>, 
      <-5.932188, -1.086525, -0.494928>, <-6.225928, -0.982086, -0.420560>, <-6.636678, -0.870228, -0.339463>, <-6.917607, -0.790550, -0.207358>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.757906, 0.000000, -1.842013>, <-4.757906, -0.731660, -1.842013>, <-4.636992, -1.545929, -1.460060>, <-4.793063, -1.545929, -0.745240>, 
      <-5.144251, 0.000000, -1.733829>, <-5.144251, -0.731660, -1.733829>, <-4.993613, -1.429412, -1.434296>, <-5.149684, -1.429412, -0.719476>, 
      <-5.602527, 0.000000, -1.438293>, <-5.602527, -0.514232, -1.438293>, <-5.515333, -1.209067, -1.091325>, <-5.587532, -1.209067, -0.582186>, 
      <-5.964610, 0.000000, -1.265487>, <-5.964610, -0.514232, -1.265487>, <-5.859989, -1.086525, -1.004067>, <-5.932188, -1.086525, -0.494928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.793063, 1.545929, -0.745240>, <-4.636992, 1.545929, -1.460060>, <-4.757906, 0.731660, -1.842013>, <-4.757906, 0.000000, -1.842013>, 
      <-5.149684, 1.429412, -0.719476>, <-4.993613, 1.429412, -1.434296>, <-5.144251, 0.731660, -1.733829>, <-5.144251, 0.000000, -1.733829>, 
      <-5.587532, 1.209067, -0.582186>, <-5.515333, 1.209067, -1.091325>, <-5.602527, 0.514232, -1.438293>, <-5.602527, 0.000000, -1.438293>, 
      <-5.932188, 1.086525, -0.494928>, <-5.859989, 1.086525, -1.004067>, <-5.964610, 0.514232, -1.265487>, <-5.964610, 0.000000, -1.265487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.487022, 0.000000, 1.497402>, <-5.487022, 1.084817, 1.497402>, <-5.024466, 1.545929, 0.314609>, <-4.793063, 1.545929, -0.745240>, 
      <-5.728756, 0.000000, 1.376478>, <-5.728756, 1.084817, 1.376478>, <-5.381087, 1.429412, 0.340373>, <-5.149684, 1.429412, -0.719476>, 
      <-6.045718, 0.000000, 1.199229>, <-6.045718, 0.762442, 1.199229>, <-5.694581, 1.209067, 0.172703>, <-5.587532, 1.209067, -0.582186>, 
      <-6.301904, 0.000000, 1.113050>, <-6.301904, 0.762442, 1.113050>, <-6.039237, 1.086525, 0.259962>, <-5.932188, 1.086525, -0.494928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.487022, 0.000000, 1.497402>, <-5.728756, 0.000000, 1.376478>, <-6.045718, 0.000000, 1.199229>, <-6.301904, 0.000000, 1.113050>, 
      <-5.487022, -1.084817, 1.497402>, <-5.728756, -1.084817, 1.376478>, <-6.045718, -0.762442, 1.199229>, <-6.301904, -0.762442, 1.113050>, 
      <-5.024466, -1.545929, 0.314609>, <-5.381087, -1.429412, 0.340373>, <-5.694581, -1.209067, 0.172703>, <-6.039237, -1.086525, 0.259962>, 
      <-4.793063, -1.545929, -0.745240>, <-5.149684, -1.429412, -0.719476>, <-5.587532, -1.209067, -0.582186>, <-5.932188, -1.086525, -0.494928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.563826, 0.000000, -1.937752>, <-3.563826, -0.859345, -1.937752>, <-3.455408, -1.815717, -1.479861>, <-3.700363, -1.815717, -0.656167>, 
      <-3.923196, 0.000000, -1.936273>, <-3.923196, -0.859345, -1.936273>, <-3.790670, -1.775287, -1.506114>, <-4.035624, -1.775287, -0.682420>, 
      <-4.411844, 0.000000, -1.938917>, <-4.411844, -0.731660, -1.938917>, <-4.315788, -1.650874, -1.483266>, <-4.471859, -1.650874, -0.768446>, 
      <-4.757906, 0.000000, -1.842013>, <-4.757906, -0.731660, -1.842013>, <-4.636992, -1.545929, -1.460060>, <-4.793063, -1.545929, -0.745240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.700363, 1.815717, -0.656167>, <-3.455408, 1.815717, -1.479861>, <-3.563826, 0.859345, -1.937752>, <-3.563826, 0.000000, -1.937752>, 
      <-4.035624, 1.775287, -0.682420>, <-3.790670, 1.775287, -1.506114>, <-3.923196, 0.859345, -1.936273>, <-3.923196, 0.000000, -1.936273>, 
      <-4.471859, 1.650874, -0.768446>, <-4.315788, 1.650874, -1.483266>, <-4.411844, 0.731660, -1.938917>, <-4.411844, 0.000000, -1.938917>, 
      <-4.793063, 1.545929, -0.745240>, <-4.636992, 1.545929, -1.460060>, <-4.757906, 0.731660, -1.842013>, <-4.757906, 0.000000, -1.842013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.708179, 0.000000, 1.910289>, <-4.708179, 1.274134, 1.910289>, <-4.063553, 1.815717, 0.565107>, <-3.700363, 1.815717, -0.656167>, 
      <-4.964159, 0.000000, 1.843876>, <-4.964159, 1.274134, 1.843876>, <-4.398814, 1.775287, 0.538855>, <-4.035624, 1.775287, -0.682420>, 
      <-5.250508, 0.000000, 1.615715>, <-5.250508, 1.084817, 1.615715>, <-4.703262, 1.650874, 0.291403>, <-4.471859, 1.650874, -0.768446>, 
      <-5.487022, 0.000000, 1.497402>, <-5.487022, 1.084817, 1.497402>, <-5.024466, 1.545929, 0.314609>, <-4.793063, 1.545929, -0.745240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.708179, 0.000000, 1.910289>, <-4.964159, 0.000000, 1.843876>, <-5.250508, 0.000000, 1.615715>, <-5.487022, 0.000000, 1.497402>, 
      <-4.708179, -1.274134, 1.910289>, <-4.964159, -1.274134, 1.843876>, <-5.250508, -1.084817, 1.615715>, <-5.487022, -1.084817, 1.497402>, 
      <-4.063553, -1.815717, 0.565107>, <-4.398814, -1.775287, 0.538855>, <-4.703262, -1.650874, 0.291403>, <-5.024466, -1.545929, 0.314609>, 
      <-3.700363, -1.815717, -0.656167>, <-4.035624, -1.775287, -0.682420>, <-4.471859, -1.650874, -0.768446>, <-4.793063, -1.545929, -0.745240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.419342, 0.000000, -1.851639>, <-2.419342, -0.859345, -1.851639>, <-2.310925, -1.815717, -1.393749>, <-2.555880, -1.815717, -0.570055>, 
      <-2.760803, 0.000000, -1.895888>, <-2.760803, -0.859345, -1.895888>, <-2.651081, -1.848526, -1.435832>, <-2.896035, -1.848526, -0.612138>, 
      <-3.219513, 0.000000, -1.939169>, <-3.219513, -0.859345, -1.939169>, <-3.114598, -1.856816, -1.453173>, <-3.359553, -1.856816, -0.629479>, 
      <-3.563826, 0.000000, -1.937752>, <-3.563826, -0.859345, -1.937752>, <-3.455408, -1.815717, -1.479861>, <-3.700363, -1.815717, -0.656167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.555880, 1.815717, -0.570055>, <-2.310925, 1.815717, -1.393749>, <-2.419342, 0.859345, -1.851639>, <-2.419342, 0.000000, -1.851639>, 
      <-2.896035, 1.848526, -0.612138>, <-2.651081, 1.848526, -1.435832>, <-2.760803, 0.859345, -1.895888>, <-2.760803, 0.000000, -1.895888>, 
      <-3.359553, 1.856816, -0.629479>, <-3.114598, 1.856816, -1.453173>, <-3.219513, 0.859345, -1.939169>, <-3.219513, 0.000000, -1.939169>, 
      <-3.700363, 1.815717, -0.656167>, <-3.455408, 1.815717, -1.479861>, <-3.563826, 0.859345, -1.937752>, <-3.563826, 0.000000, -1.937752>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.563695, 0.000000, 1.996401>, <-3.563695, 1.274134, 1.996401>, <-2.919070, 1.815717, 0.651219>, <-2.555880, 1.815717, -0.570055>, 
      <-3.907401, 0.000000, 2.016886>, <-3.907401, 1.274134, 2.016886>, <-3.259225, 1.848526, 0.609136>, <-2.896035, 1.848526, -0.612138>, 
      <-4.374898, 0.000000, 1.996758>, <-4.374898, 1.274134, 1.996758>, <-3.722742, 1.856816, 0.591795>, <-3.359553, 1.856816, -0.629479>, 
      <-4.708179, 0.000000, 1.910289>, <-4.708179, 1.274134, 1.910289>, <-4.063553, 1.815717, 0.565107>, <-3.700363, 1.815717, -0.656167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.563695, 0.000000, 1.996401>, <-3.907401, 0.000000, 2.016886>, <-4.374898, 0.000000, 1.996758>, <-4.708179, 0.000000, 1.910289>, 
      <-3.563695, -1.274134, 1.996401>, <-3.907401, -1.274134, 2.016886>, <-4.374898, -1.274134, 1.996758>, <-4.708179, -1.274134, 1.910289>, 
      <-2.919070, -1.815717, 0.651219>, <-3.259225, -1.848526, 0.609136>, <-3.722742, -1.856816, 0.591795>, <-4.063553, -1.815717, 0.565107>, 
      <-2.555880, -1.815717, -0.570055>, <-2.896035, -1.848526, -0.612138>, <-3.359553, -1.856816, -0.629479>, <-3.700363, -1.815717, -0.656167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.113768, 0.000000, -1.620252>, <-1.113768, -0.787500, -1.620252>, <-1.073317, -1.590628, -1.098269>, <-1.366679, -1.590628, -0.367450>, 
      <-1.503858, 0.000000, -1.698067>, <-1.503858, -0.787500, -1.698067>, <-1.423850, -1.684317, -1.160573>, <-1.717211, -1.684317, -0.429754>, 
      <-2.024864, 0.000000, -1.800519>, <-2.024864, -0.859345, -1.800519>, <-1.947226, -1.780637, -1.348753>, <-2.192181, -1.780637, -0.525059>, 
      <-2.419342, 0.000000, -1.851639>, <-2.419342, -0.859345, -1.851639>, <-2.310925, -1.815717, -1.393749>, <-2.555880, -1.815717, -0.570055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.366679, 1.590628, -0.367450>, <-1.073317, 1.590628, -1.098269>, <-1.113768, 0.787500, -1.620252>, <-1.113768, 0.000000, -1.620252>, 
      <-1.717211, 1.684317, -0.429754>, <-1.423850, 1.684317, -1.160573>, <-1.503858, 0.787500, -1.698067>, <-1.503858, 0.000000, -1.698067>, 
      <-2.192181, 1.780637, -0.525059>, <-1.947226, 1.780637, -1.348753>, <-2.024864, 0.859345, -1.800519>, <-2.024864, 0.000000, -1.800519>, 
      <-2.555880, 1.815717, -0.570055>, <-2.310925, 1.815717, -1.393749>, <-2.419342, 0.859345, -1.851639>, <-2.419342, 0.000000, -1.851639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.477614, 0.000000, 1.777346>, <-2.477614, 1.116183, 1.777346>, <-1.782482, 1.590628, 0.668394>, <-1.366679, 1.590628, -0.367450>, 
      <-2.801445, 0.000000, 1.852272>, <-2.801445, 1.116183, 1.852272>, <-2.133014, 1.684317, 0.606090>, <-1.717211, 1.684317, -0.429754>, 
      <-3.231898, 0.000000, 1.976626>, <-3.231898, 1.274134, 1.976626>, <-2.555371, 1.780637, 0.696215>, <-2.192181, 1.780637, -0.525059>, 
      <-3.563695, 0.000000, 1.996401>, <-3.563695, 1.274134, 1.996401>, <-2.919070, 1.815717, 0.651219>, <-2.555880, 1.815717, -0.570055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.477614, 0.000000, 1.777346>, <-2.801445, 0.000000, 1.852272>, <-3.231898, 0.000000, 1.976626>, <-3.563695, 0.000000, 1.996401>, 
      <-2.477614, -1.116183, 1.777346>, <-2.801445, -1.116183, 1.852272>, <-3.231898, -1.274134, 1.976626>, <-3.563695, -1.274134, 1.996401>, 
      <-1.782482, -1.590628, 0.668394>, <-2.133014, -1.684317, 0.606090>, <-2.555371, -1.780637, 0.696215>, <-2.919070, -1.815717, 0.651219>, 
      <-1.366679, -1.590628, -0.367450>, <-1.717211, -1.684317, -0.429754>, <-2.192181, -1.780637, -0.525059>, <-2.555880, -1.815717, -0.570055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.090839, 0.000000, -1.387151>, <-0.090839, -0.701868, -1.387151>, <-0.305557, -1.296974, -0.855040>, <-0.615035, -1.296974, -0.225085>, 
      <-0.386725, 0.000000, -1.494464>, <-0.386725, -0.701868, -1.494464>, <-0.530658, -1.381028, -0.906972>, <-0.840135, -1.381028, -0.277018>, 
      <-0.805104, 0.000000, -1.558680>, <-0.805104, -0.787500, -1.558680>, <-0.839250, -1.528067, -1.056665>, <-1.132612, -1.528067, -0.325846>, 
      <-1.113768, 0.000000, -1.620252>, <-1.113768, -0.787500, -1.620252>, <-1.073317, -1.590628, -1.098269>, <-1.366679, -1.590628, -0.367450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.615035, 1.296974, -0.225085>, <-0.305557, 1.296974, -0.855040>, <-0.090839, 0.701868, -1.387151>, <-0.090839, 0.000000, -1.387151>, 
      <-0.840997, 1.379002, -0.276515>, <-0.531519, 1.379002, -0.906469>, <-0.386725, 0.701868, -1.494464>, <-0.386725, 0.000000, -1.494464>, 
      <-1.132612, 1.528067, -0.325846>, <-0.839250, 1.528067, -1.056665>, <-0.805104, 0.787500, -1.558680>, <-0.805104, 0.000000, -1.558680>, 
      <-1.366679, 1.590628, -0.367450>, <-1.073317, 1.590628, -1.098269>, <-1.113768, 0.787500, -1.620252>, <-1.113768, 0.000000, -1.620252>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.520875, 0.000000, 1.523748>, <-1.520875, 0.910119, 1.523748>, <-1.016337, 1.296974, 0.591783>, <-0.615035, 1.296974, -0.225085>, 
      <-1.806401, 0.000000, 1.605260>, <-1.806401, 0.910119, 1.605260>, <-1.242299, 1.379002, 0.540353>, <-0.840997, 1.379002, -0.276515>, 
      <-2.188323, 0.000000, 1.710412>, <-2.188323, 1.116183, 1.710412>, <-1.548415, 1.528067, 0.709998>, <-1.132612, 1.528067, -0.325846>, 
      <-2.477614, 0.000000, 1.777346>, <-2.477614, 1.116183, 1.777346>, <-1.782482, 1.590628, 0.668394>, <-1.366679, 1.590628, -0.367450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.520875, 0.000000, 1.523748>, <-1.806401, 0.000000, 1.605260>, <-2.188323, 0.000000, 1.710412>, <-2.477614, 0.000000, 1.777346>, 
      <-1.520875, -0.910119, 1.523748>, <-1.806401, -0.910119, 1.605260>, <-2.188323, -1.116183, 1.710412>, <-2.477614, -1.116183, 1.777346>, 
      <-1.016337, -1.296974, 0.591783>, <-1.241437, -1.381028, 0.539850>, <-1.548415, -1.528067, 0.709998>, <-1.782482, -1.590628, 0.668394>, 
      <-0.615035, -1.296974, -0.225085>, <-0.840135, -1.381028, -0.277018>, <-1.132612, -1.528067, -0.325846>, <-1.366679, -1.590628, -0.367450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.857556, 0.000000, -0.905288>, <0.844749, -0.581801, -0.906813>, <0.473680, -1.010391, -0.515505>, <0.187216, -1.010391, -0.008951>, 
      <0.638462, 0.000000, -1.137335>, <0.625655, -0.581801, -1.138861>, <0.233005, -1.096366, -0.580345>, <-0.053459, -1.096366, -0.073791>, 
      <0.209175, 0.000000, -1.278341>, <0.209175, -0.701868, -1.278341>, <-0.064124, -1.206821, -0.799338>, <-0.373601, -1.206821, -0.169384>, 
      <-0.090839, 0.000000, -1.387151>, <-0.090839, -0.701868, -1.387151>, <-0.305557, -1.296974, -0.855040>, <-0.615035, -1.296974, -0.225085>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.231700, 1.010391, -0.003653>, <0.515116, 1.010391, -0.504816>, <0.870227, 0.575609, -0.903779>, <0.857556, 0.000000, -0.905288>, 
      <-0.022321, 1.096366, -0.070083>, <0.261095, 1.096366, -0.571246>, <0.651133, 0.575609, -1.135826>, <0.638462, 0.000000, -1.137335>, 
      <-0.361083, 1.204786, -0.167285>, <-0.051606, 1.204786, -0.797239>, <0.209175, 0.701868, -1.278341>, <0.209175, 0.000000, -1.278341>, 
      <-0.615035, 1.296974, -0.225085>, <-0.305557, 1.296974, -0.855040>, <-0.090839, 0.701868, -1.387151>, <-0.090839, 0.000000, -1.387151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.231700, 1.010391, -0.003653>, <0.515116, 1.010391, -0.504816>, <0.870227, 0.575609, -0.903779>, <0.857556, 0.000000, -0.905288>, 
      <0.231700, 1.010391, -0.003653>, <0.501771, 0.404156, -0.506405>, <0.857420, -0.006191, -0.905304>, <0.844749, -0.581801, -0.906813>, 
      <0.231700, 1.010391, -0.003653>, <0.501771, 0.404156, -0.506405>, <0.487026, -0.404156, -0.513915>, <0.473680, -1.010391, -0.515505>, 
      <0.231700, 1.010391, -0.003653>, <0.218355, 0.404156, -0.005242>, <0.200561, -0.404156, -0.007362>, <0.187216, -1.010391, -0.008951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.309486, 0.000000, 1.158388>, <-0.295623, 0.629777, 1.160039>, <-0.078387, 1.010391, 0.544672>, <0.231700, 1.010391, -0.003653>, 
      <-0.681226, 0.000000, 1.235165>, <-0.667363, 0.629777, 1.236817>, <-0.332407, 1.096366, 0.478243>, <-0.022321, 1.096366, -0.070083>, 
      <-1.155871, 0.000000, 1.419547>, <-1.155871, 0.910119, 1.419547>, <-0.762386, 1.204786, 0.649583>, <-0.361083, 1.204786, -0.167285>, 
      <-1.520875, 0.000000, 1.523748>, <-1.520875, 0.910119, 1.523748>, <-1.016337, 1.296974, 0.591783>, <-0.615035, 1.296974, -0.225085>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.309486, 0.000000, 1.158388>, <-0.681226, 0.000000, 1.235165>, <-1.155871, 0.000000, 1.419547>, <-1.520875, 0.000000, 1.523748>, 
      <-0.323261, -0.625766, 1.156748>, <-0.695001, -0.625766, 1.233525>, <-1.155871, -0.910119, 1.419547>, <-1.520875, -0.910119, 1.523748>, 
      <-0.120896, -1.010391, 0.535882>, <-0.361571, -1.096366, 0.471042>, <-0.774903, -1.206821, 0.647484>, <-1.016337, -1.296974, 0.591783>, 
      <0.187216, -1.010391, -0.008951>, <-0.053459, -1.096366, -0.073791>, <-0.373601, -1.206821, -0.169384>, <-0.615035, -1.296974, -0.225085>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.309486, 0.000000, 1.158388>, <-0.295623, 0.629777, 1.160039>, <-0.078387, 1.010391, 0.544672>, <0.231700, 1.010391, -0.003653>, 
      <-0.309486, 0.000000, 1.158388>, <-0.309398, 0.004011, 1.158399>, <-0.091732, 0.404156, 0.543083>, <0.218355, 0.404156, -0.005242>, 
      <-0.309486, 0.000000, 1.158388>, <-0.309398, 0.004011, 1.158399>, <-0.107551, -0.404156, 0.537471>, <0.200561, -0.404156, -0.007362>, 
      <-0.309486, 0.000000, 1.158388>, <-0.323261, -0.625766, 1.156748>, <-0.120896, -1.010391, 0.535882>, <0.187216, -1.010391, -0.008951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.741071, 0.000000, 6.074897>, <0.741071, -0.377921, 6.074897>, <0.790040, -0.691223, 6.393750>, <0.865328, -0.691223, 6.687135>, 
      <0.841656, 0.000000, 6.042017>, <0.841656, -0.377921, 6.042017>, <0.949378, -0.664432, 6.317447>, <1.033883, -0.664432, 6.634219>, 
      <0.985573, 0.000000, 6.040434>, <0.989900, -0.318162, 6.049374>, <1.163811, -0.580011, 6.308397>, <1.255232, -0.580011, 6.589974>, 
      <1.090359, 0.000000, 6.025664>, <1.094686, -0.318162, 6.034604>, <1.323311, -0.532349, 6.243461>, <1.422334, -0.532349, 6.548333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.865328, 0.691223, 6.687135>, <0.790040, 0.691223, 6.393750>, <0.741071, 0.377921, 6.074897>, <0.741071, 0.000000, 6.074897>, 
      <1.034047, 0.657587, 6.628445>, <0.948720, 0.657587, 6.311707>, <0.841656, 0.377921, 6.042017>, <0.841656, 0.000000, 6.042017>, 
      <1.248427, 0.553089, 6.568606>, <1.163323, 0.553089, 6.304525>, <0.981501, 0.299402, 6.032021>, <0.985573, 0.000000, 6.040434>, 
      <1.412612, 0.493889, 6.517807>, <1.318636, 0.493889, 6.230938>, <1.086288, 0.299402, 6.017251>, <1.090359, 0.000000, 6.025664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.190437, 0.000000, 7.457479>, <1.190437, 0.418687, 7.457479>, <0.985789, 0.691223, 7.088119>, <0.865328, 0.691223, 6.687135>, 
      <1.310974, 0.000000, 7.369608>, <1.310974, 0.418687, 7.369608>, <1.154507, 0.657587, 7.029429>, <1.034047, 0.657587, 6.628445>, 
      <1.434019, 0.000000, 7.208862>, <1.431186, 0.299149, 7.199965>, <1.357996, 0.553089, 6.847122>, <1.248427, 0.553089, 6.568606>, 
      <1.538412, 0.000000, 7.102313>, <1.535578, 0.299149, 7.093414>, <1.522182, 0.493889, 6.796324>, <1.412612, 0.493889, 6.517807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.190437, 0.000000, 7.457479>, <1.310974, 0.000000, 7.369608>, <1.434019, 0.000000, 7.208862>, <1.538412, 0.000000, 7.102313>, 
      <1.190437, -0.418687, 7.457479>, <1.310974, -0.418687, 7.369608>, <1.436859, -0.299736, 7.217778>, <1.541252, -0.299736, 7.111229>, 
      <0.985789, -0.691223, 7.088119>, <1.154344, -0.664432, 7.035203>, <1.365017, -0.580011, 6.869038>, <1.532119, -0.532349, 6.827398>, 
      <0.865328, -0.691223, 6.687135>, <1.033883, -0.664432, 6.634219>, <1.255232, -0.580011, 6.589974>, <1.422334, -0.532349, 6.548333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.271683, 0.000000, 6.197015>, <0.271683, -0.387505, 6.197015>, <0.330109, -0.691223, 6.485872>, <0.422768, -0.691223, 6.862135>, 
      <0.416463, 0.000000, 6.188469>, <0.416463, -0.387505, 6.188469>, <0.463837, -0.704421, 6.521358>, <0.556826, -0.704421, 6.814828>, 
      <0.597452, 0.000000, 6.121845>, <0.597452, -0.377921, 6.121845>, <0.621920, -0.712629, 6.367474>, <0.730652, -0.712629, 6.729415>, 
      <0.741071, 0.000000, 6.074897>, <0.741071, -0.377921, 6.074897>, <0.790040, -0.691223, 6.393750>, <0.865328, -0.691223, 6.687135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.422768, 0.691223, 6.862135>, <0.330109, 0.691223, 6.485872>, <0.271683, 0.387505, 6.197015>, <0.271683, 0.000000, 6.197015>, 
      <0.559034, 0.704036, 6.821502>, <0.466034, 0.704036, 6.528036>, <0.416463, 0.387505, 6.188469>, <0.416463, 0.000000, 6.188469>, 
      <0.732811, 0.717641, 6.733233>, <0.624080, 0.717641, 6.371291>, <0.597452, 0.377921, 6.121845>, <0.597452, 0.000000, 6.121845>, 
      <0.865328, 0.691223, 6.687135>, <0.790040, 0.691223, 6.393750>, <0.741071, 0.377921, 6.074897>, <0.741071, 0.000000, 6.074897>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.663360, 0.000000, 7.740222>, <0.663360, 0.441171, 7.740222>, <0.528260, 0.691223, 7.290508>, <0.422768, 0.691223, 6.862135>, 
      <0.839439, 0.000000, 7.705669>, <0.839439, 0.441171, 7.705669>, <0.664526, 0.704036, 7.249875>, <0.559034, 0.704036, 6.821502>, 
      <1.045438, 0.000000, 7.563182>, <1.045438, 0.418687, 7.563182>, <0.853272, 0.717641, 7.134217>, <0.732811, 0.717641, 6.733233>, 
      <1.190437, 0.000000, 7.457479>, <1.190437, 0.418687, 7.457479>, <0.985789, 0.691223, 7.088119>, <0.865328, 0.691223, 6.687135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.663360, 0.000000, 7.740222>, <0.839439, 0.000000, 7.705669>, <1.045438, 0.000000, 7.563182>, <1.190437, 0.000000, 7.457479>, 
      <0.663360, -0.441171, 7.740222>, <0.839439, -0.441171, 7.705669>, <1.045438, -0.418687, 7.563182>, <1.190437, -0.418687, 7.457479>, 
      <0.528260, -0.691223, 7.290508>, <0.662318, -0.704421, 7.243202>, <0.851112, -0.712629, 7.130400>, <0.985789, -0.691223, 7.088119>, 
      <0.422768, -0.691223, 6.862135>, <0.556826, -0.704421, 6.814828>, <0.730652, -0.712629, 6.729415>, <0.865328, -0.691223, 6.687135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.064261, 0.000000, 6.251356>, <-0.048720, -0.383429, 6.264810>, <-0.097189, -0.590884, 6.667008>, <-0.153840, -0.590884, 7.046785>, 
      <0.040988, 0.000000, 6.248300>, <0.056529, -0.383429, 6.261753>, <0.079489, -0.608847, 6.715588>, <0.022838, -0.608847, 7.095365>, 
      <0.170948, 0.000000, 6.227660>, <0.170948, -0.387505, 6.227660>, <0.157232, -0.674203, 6.546877>, <0.249892, -0.674203, 6.923141>, 
      <0.271683, 0.000000, 6.197015>, <0.271683, -0.387505, 6.197015>, <0.330109, -0.691223, 6.485872>, <0.422768, -0.691223, 6.862135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.201738, 0.590884, 7.005319>, <-0.146635, 0.590884, 6.635922>, <-0.079377, 0.372949, 6.238270>, <-0.064261, 0.000000, 6.251356>, 
      <-0.015039, 0.609865, 7.056654>, <0.040064, 0.609865, 6.687257>, <0.025872, 0.372949, 6.235214>, <0.040988, 0.000000, 6.248300>, 
      <0.237077, 0.673762, 6.917506>, <0.144418, 0.673762, 6.541242>, <0.170948, 0.387505, 6.227660>, <0.170948, 0.000000, 6.227660>, 
      <0.422768, 0.691223, 6.862135>, <0.330109, 0.691223, 6.485872>, <0.271683, 0.387505, 6.197015>, <0.271683, 0.000000, 6.197015>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.287440, 0.000000, 7.747496>, <-0.302318, 0.367091, 7.734616>, <-0.255975, 0.590884, 7.368914>, <-0.201738, 0.590884, 7.005319>, 
      <-0.021792, 0.000000, 7.851409>, <-0.036671, 0.367091, 7.838529>, <-0.069277, 0.609865, 7.420249>, <-0.015039, 0.609865, 7.056654>, 
      <0.383450, 0.000000, 7.795151>, <0.383450, 0.441171, 7.795151>, <0.342569, 0.673762, 7.345878>, <0.237077, 0.673762, 6.917506>, 
      <0.663360, 0.000000, 7.740222>, <0.663360, 0.441171, 7.740222>, <0.528260, 0.691223, 7.290508>, <0.422768, 0.691223, 6.862135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.287440, 0.000000, 7.747496>, <-0.021792, 0.000000, 7.851409>, <0.383450, 0.000000, 7.795151>, <0.663360, 0.000000, 7.740222>, 
      <-0.272972, -0.356973, 7.760022>, <-0.007324, -0.356973, 7.863934>, <0.383450, -0.441171, 7.795151>, <0.663360, -0.441171, 7.740222>, 
      <-0.206583, -0.590884, 7.400358>, <-0.029905, -0.608847, 7.448938>, <0.355384, -0.674203, 7.351514>, <0.528260, -0.691223, 7.290508>, 
      <-0.153840, -0.590884, 7.046785>, <0.022838, -0.608847, 7.095365>, <0.249892, -0.674203, 6.923141>, <0.422768, -0.691223, 6.862135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.315752, 0.000000, 6.166789>, <-0.315752, -0.305020, 6.166789>, <-0.466360, -0.578392, 6.346397>, <-0.687017, -0.578392, 6.556986>, 
      <-0.287957, 0.000000, 6.241377>, <-0.287957, -0.305020, 6.241377>, <-0.365597, -0.591420, 6.538406>, <-0.586254, -0.591420, 6.748995>, 
      <-0.143826, 0.000000, 6.253666>, <-0.128285, -0.383429, 6.267120>, <-0.305649, -0.569690, 6.609689>, <-0.362300, -0.569690, 6.989466>, 
      <-0.064261, 0.000000, 6.251356>, <-0.048720, -0.383429, 6.264810>, <-0.097189, -0.590884, 6.667008>, <-0.153840, -0.590884, 7.046785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.687017, 0.578392, 6.556986>, <-0.466360, 0.578392, 6.346397>, <-0.315752, 0.305020, 6.166789>, <-0.315752, 0.000000, 6.166789>, 
      <-0.597802, 0.590747, 6.733584>, <-0.377145, 0.590747, 6.522995>, <-0.287957, 0.305020, 6.241377>, <-0.287957, 0.000000, 6.241377>, 
      <-0.391972, 0.571543, 6.953012>, <-0.336869, 0.571543, 6.583615>, <-0.158942, 0.372949, 6.240580>, <-0.143826, 0.000000, 6.253666>, 
      <-0.201738, 0.590884, 7.005319>, <-0.146635, 0.590884, 6.635922>, <-0.079377, 0.372949, 6.238270>, <-0.064261, 0.000000, 6.251356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.200480, 0.000000, 7.011147>, <-1.200480, 0.346151, 7.011147>, <-0.937429, 0.578392, 6.795971>, <-0.687017, 0.578392, 6.556986>, 
      <-1.024567, 0.000000, 7.315911>, <-1.024567, 0.346151, 7.315911>, <-0.848214, 0.590747, 6.972570>, <-0.597802, 0.590747, 6.733584>, 
      <-0.615150, 0.000000, 7.619306>, <-0.630029, 0.367091, 7.606426>, <-0.446209, 0.571543, 7.316607>, <-0.391972, 0.571543, 6.953012>, 
      <-0.287440, 0.000000, 7.747496>, <-0.302318, 0.367091, 7.734616>, <-0.255975, 0.590884, 7.368914>, <-0.201738, 0.590884, 7.005319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.200480, 0.000000, 7.011147>, <-1.024567, 0.000000, 7.315911>, <-0.615150, 0.000000, 7.619306>, <-0.287440, 0.000000, 7.747496>, 
      <-1.200480, -0.346151, 7.011147>, <-1.024567, -0.346151, 7.315911>, <-0.600682, -0.356973, 7.631832>, <-0.272972, -0.356973, 7.760022>, 
      <-0.937429, -0.578392, 6.795971>, <-0.836666, -0.591420, 6.987980>, <-0.415043, -0.569690, 7.343039>, <-0.206583, -0.590884, 7.400358>, 
      <-0.687017, -0.578392, 6.556986>, <-0.586254, -0.591420, 6.748995>, <-0.362300, -0.569690, 6.989466>, <-0.153840, -0.590884, 7.046785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.307538, 0.000000, 5.598527>, <-0.307538, -0.292783, 5.598527>, <-0.585122, -0.497576, 5.634242>, <-0.875511, -0.497576, 5.671606>, 
      <-0.346913, 0.000000, 5.764415>, <-0.346913, -0.292783, 5.764415>, <-0.613749, -0.507431, 5.905203>, <-0.904138, -0.507431, 5.942567>, 
      <-0.375288, 0.000000, 6.007025>, <-0.375288, -0.305020, 6.007025>, <-0.592826, -0.562041, 6.105409>, <-0.813483, -0.562041, 6.315998>, 
      <-0.315752, 0.000000, 6.166789>, <-0.315752, -0.305020, 6.166789>, <-0.466360, -0.578392, 6.346397>, <-0.687017, -0.578392, 6.556986>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.875511, 0.497576, 5.671606>, <-0.585122, 0.497576, 5.634242>, <-0.307538, 0.292783, 5.598527>, <-0.307538, 0.000000, 5.598527>, 
      <-0.904138, 0.507431, 5.942567>, <-0.613749, 0.507431, 5.905203>, <-0.346913, 0.292783, 5.764415>, <-0.346913, 0.000000, 5.764415>, 
      <-0.809718, 0.561400, 6.314103>, <-0.589061, 0.561400, 6.103514>, <-0.375288, 0.305020, 6.007025>, <-0.375288, 0.000000, 6.007025>, 
      <-0.687017, 0.578392, 6.556986>, <-0.466360, 0.578392, 6.346397>, <-0.315752, 0.305020, 6.166789>, <-0.315752, 0.000000, 6.166789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.443484, 0.000000, 5.744686>, <-1.443484, 0.292783, 5.744686>, <-1.165900, 0.497576, 5.708970>, <-0.875511, 0.497576, 5.671606>, 
      <-1.474513, 0.000000, 6.130309>, <-1.474513, 0.292783, 6.130309>, <-1.194528, 0.507431, 5.979930>, <-0.904138, 0.507431, 5.942567>, 
      <-1.393879, 0.000000, 6.676088>, <-1.393879, 0.346151, 6.676088>, <-1.060130, 0.561400, 6.553089>, <-0.809718, 0.561400, 6.314103>, 
      <-1.200480, 0.000000, 7.011147>, <-1.200480, 0.346151, 7.011147>, <-0.937429, 0.578392, 6.795971>, <-0.687017, 0.578392, 6.556986>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.443484, 0.000000, 5.744686>, <-1.474513, 0.000000, 6.130309>, <-1.393879, 0.000000, 6.676088>, <-1.200480, 0.000000, 7.011147>, 
      <-1.443484, -0.292783, 5.744686>, <-1.474513, -0.292783, 6.130309>, <-1.393879, -0.346151, 6.676088>, <-1.200480, -0.346151, 7.011147>, 
      <-1.165900, -0.497576, 5.708970>, <-1.194528, -0.507431, 5.979930>, <-1.063896, -0.562041, 6.554984>, <-0.937429, -0.578392, 6.795971>, 
      <-0.875511, -0.497576, 5.671606>, <-0.904138, -0.507431, 5.942567>, <-0.813483, -0.562041, 6.315998>, <-0.687017, -0.578392, 6.556986>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.060928, 0.000000, 4.579806>, <0.060928, -0.291600, 4.579806>, <-0.189072, -0.497576, 4.460552>, <-0.452261, -0.497576, 4.335006>, 
      <-0.081512, 0.000000, 4.871920>, <-0.081512, -0.291600, 4.871920>, <-0.360514, -0.497576, 4.844629>, <-0.623703, -0.497576, 4.719083>, 
      <-0.232484, 0.000000, 5.282319>, <-0.232484, -0.292783, 5.282319>, <-0.540959, -0.482373, 5.216240>, <-0.831348, -0.482373, 5.253604>, 
      <-0.307538, 0.000000, 5.598527>, <-0.307538, -0.292783, 5.598527>, <-0.585122, -0.497576, 5.634242>, <-0.875511, -0.497576, 5.671606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.452261, 0.497576, 4.335006>, <-0.189072, 0.497576, 4.460552>, <0.060928, 0.291600, 4.579806>, <0.060928, 0.000000, 4.579806>, 
      <-0.623703, 0.497576, 4.719083>, <-0.360514, 0.497576, 4.844629>, <-0.081512, 0.291600, 4.871920>, <-0.081512, 0.000000, 4.871920>, 
      <-0.831348, 0.482373, 5.253604>, <-0.540959, 0.482373, 5.216240>, <-0.232484, 0.292783, 5.282319>, <-0.232484, 0.000000, 5.282319>, 
      <-0.875511, 0.497576, 5.671606>, <-0.585122, 0.497576, 5.634242>, <-0.307538, 0.292783, 5.598527>, <-0.307538, 0.000000, 5.598527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.965448, 0.000000, 4.090206>, <-0.965448, 0.291599, 4.090206>, <-0.715450, 0.497576, 4.209461>, <-0.452261, 0.497576, 4.335006>, 
      <-1.163347, 0.000000, 4.567448>, <-1.163347, 0.291599, 4.567448>, <-0.886892, 0.497576, 4.593538>, <-0.623703, 0.497576, 4.719083>, 
      <-1.402046, 0.000000, 5.229704>, <-1.402046, 0.292783, 5.229704>, <-1.121738, 0.482373, 5.290967>, <-0.831348, 0.482373, 5.253604>, 
      <-1.443484, 0.000000, 5.744686>, <-1.443484, 0.292783, 5.744686>, <-1.165900, 0.497576, 5.708970>, <-0.875511, 0.497576, 5.671606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.965448, 0.000000, 4.090206>, <-1.163347, 0.000000, 4.567448>, <-1.402046, 0.000000, 5.229704>, <-1.443484, 0.000000, 5.744686>, 
      <-0.965448, -0.291599, 4.090206>, <-1.163347, -0.291599, 4.567448>, <-1.402046, -0.292783, 5.229704>, <-1.443484, -0.292783, 5.744686>, 
      <-0.715450, -0.497576, 4.209461>, <-0.886892, -0.497576, 4.593538>, <-1.121738, -0.482373, 5.290967>, <-1.165900, -0.497576, 5.708970>, 
      <-0.452261, -0.497576, 4.335006>, <-0.623703, -0.497576, 4.719083>, <-0.831348, -0.482373, 5.253604>, <-0.875511, -0.497576, 5.671606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.722330, 0.000000, 3.486486>, <0.722330, -0.291599, 3.486486>, <0.472332, -0.497576, 3.367232>, <0.209143, -0.497576, 3.241686>, 
      <0.527996, 0.000000, 3.816920>, <0.527996, -0.291599, 3.816920>, <0.273911, -0.497576, 3.695228>, <0.010722, -0.497576, 3.569682>, 
      <0.228943, 0.000000, 4.235244>, <0.228943, -0.291600, 4.235244>, <-0.032817, -0.497576, 4.110499>, <-0.296007, -0.497576, 3.984954>, 
      <0.060928, 0.000000, 4.579806>, <0.060928, -0.291600, 4.579806>, <-0.189072, -0.497576, 4.460552>, <-0.452261, -0.497576, 4.335006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.209143, 0.497576, 3.241686>, <0.472332, 0.497576, 3.367232>, <0.722330, 0.291599, 3.486486>, <0.722330, 0.000000, 3.486486>, 
      <0.010722, 0.497576, 3.569682>, <0.273911, 0.497576, 3.695228>, <0.527996, 0.291599, 3.816920>, <0.527996, 0.000000, 3.816920>, 
      <-0.296007, 0.497576, 3.984954>, <-0.032817, 0.497576, 4.110499>, <0.228943, 0.291600, 4.235244>, <0.228943, 0.000000, 4.235244>, 
      <-0.452261, 0.497576, 4.335006>, <-0.189072, 0.497576, 4.460552>, <0.060928, 0.291600, 4.579806>, <0.060928, 0.000000, 4.579806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.304046, 0.000000, 2.996886>, <-0.304046, 0.291600, 2.996886>, <-0.054046, 0.497576, 3.116140>, <0.209143, 0.497576, 3.241686>, 
      <-0.507101, 0.000000, 3.322033>, <-0.507101, 0.291600, 3.322033>, <-0.252467, 0.497576, 3.444136>, <0.010722, 0.497576, 3.569682>, 
      <-0.818610, 0.000000, 3.736101>, <-0.818610, 0.291599, 3.736101>, <-0.559195, 0.497576, 3.859408>, <-0.296007, 0.497576, 3.984954>, 
      <-0.965448, 0.000000, 4.090206>, <-0.965448, 0.291599, 4.090206>, <-0.715450, 0.497576, 4.209461>, <-0.452261, 0.497576, 4.335006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.304046, 0.000000, 2.996886>, <-0.507101, 0.000000, 3.322033>, <-0.818610, 0.000000, 3.736101>, <-0.965448, 0.000000, 4.090206>, 
      <-0.304046, -0.291600, 2.996886>, <-0.507101, -0.291600, 3.322033>, <-0.818610, -0.291599, 3.736101>, <-0.965448, -0.291599, 4.090206>, 
      <-0.054046, -0.497576, 3.116140>, <-0.252467, -0.497576, 3.444136>, <-0.559195, -0.497576, 3.859408>, <-0.715450, -0.497576, 4.209461>, 
      <0.209143, -0.497576, 3.241686>, <0.010722, -0.497576, 3.569682>, <-0.296007, -0.497576, 3.984954>, <-0.452261, -0.497576, 4.335006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.443164, 0.000000, 2.229535>, <1.443164, -0.294444, 2.229535>, <1.162075, -0.497576, 2.189690>, <0.870545, -0.497576, 2.148366>, 
      <1.293503, 0.000000, 2.637652>, <1.293503, -0.294444, 2.637652>, <1.053993, -0.470950, 2.556517>, <0.762463, -0.470950, 2.515192>, 
      <0.942695, 0.000000, 3.111790>, <0.942695, -0.291599, 3.111790>, <0.670752, -0.497576, 3.039236>, <0.407564, -0.497576, 2.913690>, 
      <0.722330, 0.000000, 3.486486>, <0.722330, -0.291599, 3.486486>, <0.472332, -0.497576, 3.367232>, <0.209143, -0.497576, 3.241686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.870545, 0.497576, 2.148366>, <1.162075, 0.497576, 2.189690>, <1.443164, 0.294444, 2.229535>, <1.443164, 0.000000, 2.229535>, 
      <0.762463, 0.470950, 2.515192>, <1.053993, 0.470950, 2.556517>, <1.293503, 0.294444, 2.637652>, <1.293503, 0.000000, 2.637652>, 
      <0.407564, 0.497576, 2.913690>, <0.670752, 0.497576, 3.039236>, <0.942695, 0.291599, 3.111790>, <0.942695, 0.000000, 3.111790>, 
      <0.209143, 0.497576, 3.241686>, <0.472332, 0.497576, 3.367232>, <0.722330, 0.291599, 3.486486>, <0.722330, 0.000000, 3.486486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.297926, 0.000000, 2.067198>, <0.297926, 0.294444, 2.067198>, <0.579016, 0.497576, 2.107042>, <0.870545, 0.497576, 2.148366>, 
      <0.186277, 0.000000, 2.380146>, <0.186277, 0.294444, 2.380146>, <0.470934, 0.470950, 2.473868>, <0.762463, 0.470950, 2.515192>, 
      <-0.128045, 0.000000, 2.715060>, <-0.128045, 0.291600, 2.715060>, <0.144375, 0.497576, 2.788144>, <0.407564, 0.497576, 2.913690>, 
      <-0.304046, 0.000000, 2.996886>, <-0.304046, 0.291600, 2.996886>, <-0.054046, 0.497576, 3.116140>, <0.209143, 0.497576, 3.241686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.297926, 0.000000, 2.067198>, <0.186277, 0.000000, 2.380146>, <-0.128045, 0.000000, 2.715060>, <-0.304046, 0.000000, 2.996886>, 
      <0.297926, -0.294444, 2.067198>, <0.186277, -0.294444, 2.380146>, <-0.128045, -0.291600, 2.715060>, <-0.304046, -0.291600, 2.996886>, 
      <0.579016, -0.497576, 2.107042>, <0.470934, -0.470950, 2.473868>, <0.144375, -0.497576, 2.788144>, <-0.054046, -0.497576, 3.116140>, 
      <0.870545, -0.497576, 2.148366>, <0.762463, -0.470950, 2.515192>, <0.407564, -0.497576, 2.913690>, <0.209143, -0.497576, 3.241686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.782106, 0.000000, 0.596531>, <1.782106, -0.450930, 0.596531>, <1.307739, -0.664332, 0.784508>, <0.886057, -0.664332, 0.944264>, 
      <1.873984, 0.000000, 1.088365>, <1.873984, -0.450930, 1.088365>, <1.303086, -0.614305, 1.145738>, <0.881403, -0.614305, 1.305495>, 
      <1.615427, 0.000000, 1.759782>, <1.615427, -0.294444, 1.759782>, <1.264902, -0.522907, 1.840697>, <0.973373, -0.522907, 1.799372>, 
      <1.443164, 0.000000, 2.229535>, <1.443164, -0.294444, 2.229535>, <1.162075, -0.497576, 2.189690>, <0.870545, -0.497576, 2.148366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.782106, 0.000000, 0.596531>, <1.782106, -0.450930, 0.596531>, <1.307739, -0.664332, 0.784508>, <0.886057, -0.664332, 0.944264>, 
      <1.684951, 0.000000, 0.076451>, <1.684951, -0.450930, 0.076451>, <1.098087, -0.768150, 0.498543>, <0.676405, -0.768150, 0.658300>, 
      <1.220778, 0.000000, -0.520590>, <1.207971, -0.581801, -0.522116>, <0.683333, -0.906573, -0.229540>, <0.396868, -0.906573, 0.277014>, 
      <0.857556, 0.000000, -0.905288>, <0.844749, -0.581801, -0.906813>, <0.473680, -1.010391, -0.515505>, <0.187216, -1.010391, -0.008951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.886057, 0.664332, 0.944264>, <1.307739, 0.664332, 0.784508>, <1.782106, 0.450930, 0.596531>, <1.782106, 0.000000, 0.596531>, 
      <0.881403, 0.614305, 1.305495>, <1.303086, 0.614305, 1.145738>, <1.873984, 0.450930, 1.088365>, <1.873984, 0.000000, 1.088365>, 
      <0.973373, 0.522907, 1.799372>, <1.264902, 0.522907, 1.840697>, <1.615427, 0.294444, 1.759782>, <1.615427, 0.000000, 1.759782>, 
      <0.870545, 0.497576, 2.148366>, <1.162075, 0.497576, 2.189690>, <1.443164, 0.294444, 2.229535>, <1.443164, 0.000000, 2.229535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.886057, 0.664332, 0.944264>, <1.307739, 0.664332, 0.784508>, <1.782106, 0.450930, 0.596531>, <1.782106, 0.000000, 0.596531>, 
      <0.689750, 0.768150, 0.659889>, <1.111432, 0.768150, 0.500133>, <1.684951, 0.450930, 0.076451>, <1.684951, 0.000000, 0.076451>, 
      <0.428007, 0.906573, 0.280722>, <0.711423, 0.906573, -0.220441>, <1.233450, 0.575609, -0.519081>, <1.220778, 0.000000, -0.520590>, 
      <0.231700, 1.010391, -0.003653>, <0.515116, 1.010391, -0.504816>, <0.870227, 0.575609, -0.903779>, <0.857556, 0.000000, -0.905288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.886057, 0.664332, 0.944264>, <0.886057, 0.265733, 0.944264>, <0.886057, -0.265733, 0.944264>, <0.886057, -0.664332, 0.944264>, 
      <0.886057, 0.664332, 0.944264>, <1.307739, 0.265733, 0.784508>, <1.307739, -0.265733, 0.784508>, <1.307739, -0.664332, 0.784508>, 
      <0.886057, 0.664332, 0.944264>, <1.307739, 0.265733, 0.784508>, <1.782106, 0.000000, 0.596531>, <1.782106, -0.450930, 0.596531>, 
      <0.886057, 0.664332, 0.944264>, <1.307739, 0.664332, 0.784508>, <1.782106, 0.450930, 0.596531>, <1.782106, 0.000000, 0.596531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.360119, 0.000000, 1.135257>, <0.360119, 0.335217, 1.135257>, <0.572583, 0.664332, 1.063025>, <0.886057, 0.664332, 0.944264>, 
      <0.515821, 0.000000, 1.368219>, <0.515821, 0.335217, 1.368219>, <0.567929, 0.614305, 1.424256>, <0.881403, 0.614305, 1.305495>, 
      <0.392081, 0.000000, 1.803286>, <0.392081, 0.294444, 1.803286>, <0.681843, 0.522907, 1.758048>, <0.973373, 0.522907, 1.799372>, 
      <0.297926, 0.000000, 2.067198>, <0.297926, 0.294444, 2.067198>, <0.579016, 0.497576, 2.107042>, <0.870545, 0.497576, 2.148366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.360119, 0.000000, 1.135257>, <0.360119, 0.335217, 1.135257>, <0.572583, 0.664332, 1.063025>, <0.886057, 0.664332, 0.944264>, 
      <0.248428, 0.000000, 0.968144>, <0.248428, 0.335217, 0.968144>, <0.376276, 0.768150, 0.778650>, <0.689750, 0.768150, 0.659889>, 
      <-0.112639, 0.000000, 1.117732>, <-0.098776, 0.629777, 1.119384>, <0.117920, 0.906573, 0.829048>, <0.428007, 0.906573, 0.280722>, 
      <-0.309486, 0.000000, 1.158388>, <-0.295623, 0.629777, 1.160039>, <-0.078387, 1.010391, 0.544672>, <0.231700, 1.010391, -0.003653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.360119, 0.000000, 1.135257>, <0.515821, 0.000000, 1.368219>, <0.392081, 0.000000, 1.803286>, <0.297926, 0.000000, 2.067198>, 
      <0.360119, -0.335217, 1.135257>, <0.515821, -0.335217, 1.368219>, <0.392081, -0.294444, 1.803286>, <0.297926, -0.294444, 2.067198>, 
      <0.572583, -0.664332, 1.063025>, <0.567929, -0.614305, 1.424256>, <0.681843, -0.522907, 1.758048>, <0.579016, -0.497576, 2.107042>, 
      <0.886057, -0.664332, 0.944264>, <0.881403, -0.614305, 1.305495>, <0.973373, -0.522907, 1.799372>, <0.870545, -0.497576, 2.148366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.360119, 0.000000, 1.135257>, <0.248428, 0.000000, 0.968144>, <-0.112639, 0.000000, 1.117732>, <-0.309486, 0.000000, 1.158388>, 
      <0.360119, -0.335217, 1.135257>, <0.248428, -0.335217, 0.968144>, <-0.126414, -0.625766, 1.116092>, <-0.323261, -0.625766, 1.156748>, 
      <0.572583, -0.664332, 1.063025>, <0.362930, -0.768150, 0.777061>, <0.088757, -0.906573, 0.821846>, <-0.120896, -1.010391, 0.535882>, 
      <0.886057, -0.664332, 0.944264>, <0.676405, -0.768150, 0.658300>, <0.396868, -0.906573, 0.277014>, <0.187216, -1.010391, -0.008951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.360119, 0.000000, 1.135257>, <0.360119, -0.335217, 1.135257>, <0.572583, -0.664332, 1.063025>, <0.886057, -0.664332, 0.944264>, 
      <0.360119, 0.000000, 1.135257>, <0.360119, 0.000000, 1.135257>, <0.572583, -0.265733, 1.063025>, <0.886057, -0.265733, 0.944264>, 
      <0.360119, 0.000000, 1.135257>, <0.360119, 0.000000, 1.135257>, <0.572583, 0.265733, 1.063025>, <0.886057, 0.265733, 0.944264>, 
      <0.360119, 0.000000, 1.135257>, <0.360119, 0.335217, 1.135257>, <0.572583, 0.664332, 1.063025>, <0.886057, 0.664332, 0.944264>
    }
  }
  texture {
    SWhite_T
  }
}
#declare swan = union {
  object { sPatchObj }
  object { sPatchObj1 }
  object { sPatchObj2 }
  object { sPatchObj3 }
  sphere { // Sphere002
    <0,0,0>,1
    texture {
      eye_T
    }
    scale <0.16, 0.232558, 0.16>
    rotate <9.616549, 32.934322, 31.22748>
    translate  <0.703581, -0.63427, 6.932835>
  }
  scale 0.7
  rotate 18.08*z
  translate  <11.940694, 10.28369, -0.0>
}


#declare Blob002 = blob {
  threshold 0.6
  component 1.0, 0.605384, <-1.054852, -0.734177, 0.0>

  component 1.0, 0.483523, <-0.7173, -0.413502, 0.0>

  component 1.0, 0.483523, <-0.396624, -0.075949, 0.0>

  component 1.0, 0.392655, <0.008439, 0.075949, -0.126582>

  component 1.0, 0.392655, <0.396624, 0.109705, -0.278481>

  component 1.0, 0.392655, <0.767932, 0.21097, -0.278481>

  component 1.0, 0.284395, <1.088608, 0.278481, -0.413502>

  component 1.0, 0.284395, <1.375527, 0.295359, -0.464135>

  component 1.0, 0.23656, <1.578059, 0.379747, -0.464135>

  component 1.0, 0.23656, <1.780063, 0.514241, -0.464135>

  component 1.0, 0.23656, <1.993671, 0.540612, -0.411392>

  scale <3.5, 1.8, 1.6>
  rotate <90.0, 18.111671, 0.0>
  translate  <-31.085984, 0.0, 16.915195>
}

#declare Cylndr001 = object {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 3.0>
  }
}
#declare Group003 = union {
  object { // Cylndr2->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.9>
    rotate <-0.480495, 44.121243, 8.744754>
    translate  <1.144049, -0.925073, 4.949111>
  }
  object { // Cylndr3->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <11.774568, 35.187328, 66.266769>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr4->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.6>
    rotate <32.620377, 8.527026, 86.696739>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr5->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <47.066917, 39.079086, 60.633724>
    translate  <3.008537, -0.612521, 6.898665>
  }
}
#declare Group10 = union {
  object { // Cylndr7->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.9>
    rotate <-0.480495, 44.121243, 8.744754>
    translate  <1.144049, -0.925073, 4.949111>
  }
  object { // Cylndr8->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <-7.745753, 30.962833, 27.452753>
    translate  <2.564326, -0.621265, 6.442093>
  }
  object { // Cylndr9->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.6>
    rotate <32.620377, 8.527026, 86.696739>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr10->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.6>
    rotate <53.312031, 39.143646, 65.295067>
    translate  <2.685748, -0.682496, 6.549398>
  }
  rotate -77.09375*z
  translate  <1.757245, 0.39538, 0.0>
}
#declare Group11 = union {
  object { // Cylndr11->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.9>
    rotate <-0.480495, 44.121243, 8.744754>
    translate  <1.144049, -0.925073, 4.949111>
  }
  object { // Cylndr12->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <29.468626, 0.895617, 118.921516>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr13->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.8>
    rotate <34.329365, -5.065557, 100.592751>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr14->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <-2.566739, -26.527941, 159.504822>
    translate  <3.008537, -0.612521, 6.898665>
  }
  scale 0.7
  rotate <12.775398, -48.289116, 44.559227>
  translate  <1.474555, 1.386426, 2.283467>
}
#declare Group004 = union {
  object { Group003 }
  object { // Cylndr6->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.8>
    rotate <32.499905, 19.04624, 24.320543>
    translate  <0.007788, -0.012287, 3.031352>
  }
  object { Group10 }
  object { Group11 }
}
#declare Group12 = union {
  object { // Cylndr15->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.9>
    rotate <-0.480495, 44.121243, 8.744754>
    translate  <1.144049, -0.925073, 4.949111>
  }
  object { // Cylndr16->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <11.774568, 35.187328, 66.266769>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr17->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.6>
    rotate <32.620377, 8.527026, 86.696739>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr18->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <33.203659, -16.321775, 148.194855>
    translate  <3.008537, -0.612521, 6.898665>
  }
  scale 0.6
  translate  <0.488376, -0.303992, 1.963242>
}
#declare Group13 = union {
  object { // Cylndr20->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.9>
    rotate <-0.480495, 44.121243, 8.744754>
    translate  <1.144049, -0.925073, 4.949111>
  }
  object { // Cylndr21->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <-7.745753, 30.962833, 27.452753>
    translate  <2.564326, -0.621265, 6.442093>
  }
  object { // Cylndr22->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.6>
    rotate <32.620377, 8.527026, 86.696739>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr23->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.6>
    rotate <53.312031, 39.143646, 65.295067>
    translate  <2.685748, -0.682496, 6.549398>
  }
  rotate <-12.250274, 8.415288, -86.569145>
  translate  <0.947915, 0.901982, 0.200821>
}
#declare Group14 = union {
  object { // Cylndr24->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.9>
    rotate <-0.480495, 44.121243, 8.744754>
    translate  <1.144049, -0.925073, 4.949111>
  }
  object { // Cylndr25->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <29.468626, 0.895617, 118.921516>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr26->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.8>
    rotate <34.329365, -5.065557, 100.592751>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr27->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <-2.566739, -26.527941, 159.504822>
    translate  <3.008537, -0.612521, 6.898665>
  }
  scale 0.8
  rotate <47.828053, -49.378448, 89.584221>
  translate  <-2.194834, 0.129474, 2.97791>
}
#declare Group15 = union {
  object { Group12 }
  object { // Cylndr19->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.8>
    rotate <32.499905, 19.04624, 24.320543>
    translate  <0.007788, -0.012287, 3.031352>
  }
  object { Group13 }
  object { Group14 }
  scale 0.75
  rotate <-0.936338, -14.601057, 119.136147>
  translate  <-0.277864, 0.540276, 0.877115>
}
#declare Group16 = union {
  object { // Cylndr28->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.7>
    rotate <-1.110193, 43.732574, 19.592222>
    translate  <1.129579, -0.881795, 4.876897>
  }
  object { // Cylndr29->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <32.348705, -50.299515, -177.641022>
    translate  <1.824893, -0.552616, 5.669562>
  }
  object { // Cylndr30->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.6>
    rotate <33.360596, 8.284032, 68.959953>
    translate  <2.064082, -0.529982, 5.95188>
  }
  object { // Cylndr31->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <33.890057, -30.296076, 159.812225>
    translate  <2.279716, -0.426168, 6.183382>
  }
  scale 0.7
  rotate <-5.339105, 15.332171, -34.672207>
  translate  <0.03303, 0.259259, 1.961607>
}
#declare Group17 = union {
  object { // Cylndr33->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.9>
    rotate <-0.480495, 44.121243, 8.744754>
    translate  <1.144049, -0.925073, 4.949111>
  }
  object { // Cylndr34->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <-7.745753, 30.962833, 27.452753>
    translate  <2.564326, -0.621265, 6.442093>
  }
  object { // Cylndr35->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.6>
    rotate <32.620377, 8.527026, 86.696739>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr36->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.6>
    rotate <53.312031, 39.143646, 65.295067>
    translate  <2.685748, -0.682496, 6.549398>
  }
  rotate -77.09375*z
  translate  <1.757245, 0.39538, 0.0>
}
#declare Group18 = union {
  object { // Cylndr37->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.9>
    rotate <-0.480495, 44.121243, 8.744754>
    translate  <1.144049, -0.925073, 4.949111>
  }
  object { // Cylndr38->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <29.468626, 0.895617, 118.921516>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr39->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.8>
    rotate <34.329365, -5.065557, 100.592751>
    translate  <2.997287, -0.612521, 6.902415>
  }
  object { // Cylndr40->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.4>
    rotate <-2.566739, -26.527941, 159.504822>
    translate  <3.008537, -0.612521, 6.898665>
  }
  scale 0.7
  rotate <12.775398, -48.289116, 44.559227>
  translate  <1.474555, 1.386426, 2.283467>
}
#declare Group19 = union {
  object { Group16 }
  object { // Cylndr32->Cylndr001
    Cylndr001
    scale <1.0, 1.0, 0.8>
    rotate <32.499905, 19.04624, 24.320543>
    translate  <0.007788, -0.012287, 3.031352>
  }
  object { Group17 }
  object { Group18 }
  rotate -164.793411*z
}
#declare small_branch = union {
  object { Cylndr001 }
  object { Group004 }
  object { Group15 }
  object { Group19 }
  scale <0.669978, 0.694098, 0.526847>
  rotate <47.938637, -22.805819, 83.5998>
  translate  <-29.307163, 0.640609, 18.404835>
}
#declare Group2 = union {
  object { Blob002 }
  object { // Blob3->Blob002
    Blob002
    scale 0.5
    rotate <0.0, 38.672153, -24.736736>
    translate  <-21.370723, -3.250149, -1.261975>
  }
  object { // Blob4->Blob002
    Blob002
    scale 0.6
    rotate <0.0, -13.730322, 13.456311>
    translate  <-9.532543, 5.43373, 12.893676>
  }
  object { small_branch }
  object { // small_branch1->small_branch
    small_branch
    scale <0.828437, 0.862846, 0.999262>
    rotate <11.255516, 59.571453, -43.931919>
    translate  <-28.610897, 4.563047, -13.392409>
  }
  object { // small_branch2->small_branch
    small_branch
    scale <0.828437, 0.862846, 0.999262>
    rotate <-21.862673, 72.037697, 60.096592>
    translate  <-27.265824, -10.310541, -12.958037>
  }
  scale <1.4, 1.0, 1.0>
  rotate 12.482747*y
  translate  <10.272107, -0.058324, -12.223067>
}
#declare Blob001 = blob {
  threshold 0.6
  component 1.0, 1.692098, <-0.382384, -1.700949, 0.0>

  component 1.0, 1.344622, <-0.435127, -0.276899, 0.0>

  component 1.0, 1.166463, <-0.487869, 0.90981, 0.0>

  component 1.0, 1.166463, <-0.487869, 2.017405, 0.0>

  component 1.0, 1.166463, <-0.482873, 3.122579, 0.0>

  component 1.0, 0.958907, <-0.482873, 4.989688, 0.0>

  component 1.0, 0.958907, <-0.482873, 5.955434, 0.0>

  component 1.0, 0.790735, <-0.482873, 6.921181, 0.0>

  component 1.0, 0.958907, <-0.482873, 4.088326, 0.0>

  scale <1.6, 1.75, 1.6>
  rotate 90.0*x
  translate  <-34.503141, 0.0, 3.118928>
}

#declare tree_first = union {
  object { Group2 }
  object { // Group3->Group2
    Group2
    rotate <-40.343399, -0.0, -90.0>
    translate  <-45.323461, -35.945264, 2.834623>
  }
  object { // Group4->Group2
    Group2
    rotate <85.039368, 18.823389, 180.0>
    translate  <-68.17965, -16.047731, 3.065667>
  }
  object { // Group5->Group2
    Group2
    rotate <-96.90712, 15.54923, 101.396202>
    translate  <-26.985634, 36.445057, 7.633633>
  }
  object { Blob001 }
  translate  35.310327*x
}
#declare Group6 = object {
  object { // Group6->Group2
    Group2
    scale 0.8
    rotate <-0.0, 0.0, -0.0>
    translate  <28.336109, 0.155479, 10.386539>
  }
}
#declare Group002 = union {
  object { // Blob2->Blob001
    Blob001
    scale 0.5
    rotate -0.0*x
    translate  <17.417143, 0.020513, 15.056681>
  }
  object { Group6 }
  object { // Group7->Group6
    Group6
    rotate <0.0, -0.0, -90.0>
  }
  object { // Group8->Group6
    Group6
    rotate <0.0, -0.0, 180.0>
    translate  -0.0*y
  }
  object { // Group9->Group6
    Group6
    rotate <0.0, -0.0, 90.0>
    translate  -0.0*x
  }
  rotate -27.840633*z
}
#declare tree = union {
  object { tree_first }
  object { Group002 }
  object { // Group33->Group002
    Group002
    scale 0.8
    rotate -38.169327*z
    translate  10.583048*z
  }
  object { // Group34->Group002
    Group002
    scale <0.5, 0.5, 0.7>
    rotate -67.0*z
    translate  <0.0, 0.14538, 18.023005>
  }
  texture {
    Wood_3_T
  }
  translate  <77.380304, 119.559853, 5.385678>
}




//
// ********  OBJECTS  *******
//

sphere { // Sphere2
  <0,0,0>,1
  texture {
    DD_Cloud2
    scale <0.9, 1.0, 1.0>
  }
  scale <93.333328, 93.333328, 1.1>
  translate  <61.405321, 155.875047, -1.59911>
}




object { // pines2->pines1
  pines1
  translate  <139.017184, 380.32061, 8.314394>
}


object { pines1 }


#declare HgtFld001 = object { 
  height_field {
    tga "C:\GRAPHICS\ART\MorayW\Maps\Hf\F_mountain.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    ground_T_2
    scale 0.15
  }
  scale <75.0, 75.0, 12.0>
  rotate 42.232697*z
  translate  <62.373072, 160.228558, 2.00371>
}
union { // land
  object { // HgtFld4->HgtFld2
    HgtFld2
    scale <3.0, 2.0, 2.0>
    rotate -0.0*z
    translate  <-311.192767, 825.085049, -2.471094>
  }
  object { HgtFld001 }
  object { HgtFld2 }
  object { // HgtFld3->HgtFld2
    HgtFld2
    scale <2.0, 2.0, 1.6>
    rotate -0.0*z
    translate  <-299.035662, 458.355059, -2.518336>
  }
}


union { // earth
  plane { // Plane4
    z,0
    texture {
      Stormy_Cloud_Sky
      scale 40.0
    }
    hollow
    rotate -90.0*x
    translate  <0.948359, 181.749791, 0.0>
  }
  plane { // Plane3
    z,0
    texture {
      Stormy_Cloud_Sky
      scale 40.0
      translate <0.529682, 0.096054, -0.471314>
    }
    hollow
    rotate <-101.519203, -0.0, -47.757526>
    translate  <0.948359, 95.891678, 0.0>
  }
  plane { // Plane2
    z,0
    texture {
      Water2
      scale <3.0, 3.0, 1.0>
    }
    translate  <-1.312611, 0.0, -1.171975>
  }
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      Stormy_Cloud_Sky_1
      scale <0.32, 0.15, 0.15>
    }
    scale 700.0
    translate  <534.05778, 2155.315161, 122.439147>
  }
}




#declare leaves = union {
  object { leaves_ }
  object { // leaves_2->leaves_
    leaves_
    rotate 18.78694*z
    translate  <15.305868, 6.039162, 0.0>
  }
  object { // leaves_3->leaves_
    leaves_
    rotate 48.311188*z
    translate  <27.604312, -2.787305, 0.0>
  }
  object { // leaves_4->leaves_
    leaves_
    rotate -26.863817*z
    translate  <-12.322755, 3.716407, 0.0>
  }
}
#declare Petal = union {
  object { petal1 }
  object { // petal2->petal1
    petal1
    rotate -60.0*z
    translate  -0.1*z
  }
}
#declare Group20 = union {
  cylinder { // Cylndr41
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_heart_1
    }
    scale <0.05, 0.05, 2.0>
    rotate <-5.0, 0.0, -0.0>
    translate  <-15.55, -0.05, 0.0>
  }
  sphere { // Sphere5
    <0,0,0>,1
    scale <0.1, 0.4, 0.1>
    rotate 120.0*z
    translate  <-15.75, -0.2, 2.0>
  }
  translate  <15.3, -0.05, -2.0>
}
#declare Group21 = union {
  sphere { // Sphere6
    <0,0,0>,1
    scale <0.1, 0.4, 0.1>
    translate  <-15.3, 0.05, 2.0>
  }
  cylinder { // Cylndr42
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_heart_1
    }
    scale <0.05, 0.05, 2.0>
    rotate <-5.01853, 4.981869, -0.425957>
    translate  <-15.55, -0.05, 0.0>
  }
  rotate 5.0*z
  translate  <15.3, 1.4, -1.9>
}
#declare Group22 = union {
  cylinder { // Cylndr43
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_heart_1
    }
    scale <0.05, 0.05, 2.0>
    rotate <5.671774, 13.987695, 5.471925>
    translate  <-15.55, -0.05, 0.0>
  }
  sphere { // Sphere7
    <0,0,0>,1
    scale <0.1, 0.4, 0.1>
    rotate -120.0*z
    translate  <-14.95, -0.25, 2.0>
  }
  translate  <15.3, -0.05, -2.0>
}
#declare Group23 = union {
  cylinder { // Cylndr44
    <0,0,1>, <0,0,0>, 1 
    texture {
      T_heart_1
    }
    scale <0.05, 0.05, 2.0>
    rotate <-5.01853, -4.981869, 0.425957>
    translate  <-15.55, -0.05, 0.0>
  }
  sphere { // Sphere8
    <0,0,0>,1
    scale <0.1, 0.4, 0.1>
    rotate 0.0*z
    translate  <-15.65, 0.25, 2.0>
  }
  translate  <15.3, -0.05, -2.0>
}
#declare flower_heart1 = union {
  object { Group20 }
  object { Group21 }
  object { Group22 }
  object { Group23 }
  texture {
    T_flower_heart
  }
  scale <0.625, 0.625, 0.9>
  translate  <0.042638, 0.07757, 0.448172>
}
#declare Lily = union {
  object { Petal }
  object { flower_heart1 }
  scale 0.18
  rotate <19.162216, -0.0, -33.719002>
  translate  <-11.681877, -30.882018, -0.931483>
}
union { // scene
  object { leaves }
  object { plants }
  object { Lily }
  object { floating_leaves }
  object { // floating_leaves1->floating_leaves
    floating_leaves
    rotate -45.0*z
    translate  <19.816613, -6.350923, 0.0>
  }
  object { // plants1->plants
    plants
    rotate -0.0*x
    translate  <-14.082199, 1.465405, 0.0>
  }
}


union { // swans
  object { swan }
  object { // swan1->swan
    swan
    rotate <-0.0, 0.0, 14.017204>
    translate  <-19.477313, 4.053489, 0.0>
  }
  object { // swan2->swan
    swan
    rotate <-0.0, 0.0, -4.0>
    translate  <-12.654945, -13.263315, 0.0>
  }
  translate  <-4.076323, 28.596808, -0.335382>
}


union { // trees
  object { tree }
  object { // tree1->tree
    tree
    rotate -0.0*x
    translate  <9.433522, 58.300565, 6.2462>
  }
  object { // tree2->tree
    tree
    rotate <-0.0, 0.0, -45.0>
    translate  <-100.229865, 124.107955, 0.34608>
  }
  object { // tree3->tree
    tree
    rotate <-0.0, 0.0, -180.0>
    translate  <126.127893, 230.996072, -3.277888>
  }
}


