// TOUCAN.pov                // IRTC May-June 1998


#include "colors.inc"
camera {  
      location < -7, 3, -38 >  
      look_at < -3, -1.5, 0 > 
        angle 30 
       }
background { color rgb < 0.7, 0.5, 0.4 > }
light_source { < 50, 50, -100 > color Gray75 shadowless }
light_source { < 0, 150, -100 > color Gray60 } 
 
//SHADOWS
plane { y, 30                    // shadows of trees above
         pigment { 
                  bozo
                  turbulence 0.2   
                  color_map {
                             [ 0.0 color Clear ]
                             [ 0.08 color Clear ]
                             [ 0.13 color rgbt < 0.3, 0.3, 0.3 0.3 > ]
                             [ 0.5 color rgbt < 0.3, 0.3, 0.3 0.3 > ]
                             [ 0.65 color Clear ] 
                             [ 0.8 color Clear ] 
                             [ 1 color rgbt < 0.3, 0.3, 0.3 0.3 > ]
                             }
                  translate -1*x
                 }
   }

// THE FRACTAL BACKGROUND
plane { z, 100
        pigment {
                 image_map { 
                              gif "fract016.gif" once
                           }
                              translate < -0.5, -0.5, 0 >
                              scale < 80, 60, 1 >
                 }          
        finish { ambient 1          
                 diffuse 0 }
        translate < 10, -14, 0 >
     }


// THE SNAKE
#declare Top =
           union {
                sphere { < 0, 0, 0 >,0.1  scale < 3, 1, 1 > }
                        
                sphere { < 0, 0, 0 >,0.05  
                         translate < 0.05, 0.03, -0.1 >
                         pigment { color Black }
                       }
                       pigment { color rgb < 0.3, 1, 0.1 > }
                       finish { ambient 0.2 }

                 }
#declare Asnake =  
             
                torus { 1.5, 0.1   scale < 2, 1, 1 >
                       rotate 90*x
                       clipped_by {
                              box { < 0, 0, -1 >,< 2, -3, 1 >  }
                                  }
                       translate < 0, 1.45, -0.4 > 
                         
                       rotate 90*z
                       pigment { color rgb < 0.3, 1, 0.1 > }
                       finish { ambient 0.2 }
                       
                     }

#declare Bsnake =  
                torus { 0.32, 0.1  scale < 1.26, 1, 1 >
                       rotate < -20, 0, -45 > 
                       clipped_by {
                               box { < -1, -1, -1 >,< 1, 1, 0 > }
                                  }
                       
                       pigment { color rgb < 0.3, 1, 0.1 > }
                       finish { ambient 0.2 }
                       }
#declare Dsnake =  
                torus { 0.32, 0.1  scale < 1.26, 1, 1 >
                       rotate < 0, 0, 45 > 
                       clipped_by {
                               box { < -1, -1, 0 >,< 1, 1, 1 > }
                                  }
                      
                       pigment { color rgb < 0.3, 1, 0.1 > }
                       finish { ambient 0.2 }
                       }

#declare Csnake =
               union { 
                     cylinder { < 0, 0, 0 >,< 0, 0, 0.5 >,0.09 
                              translate 2*x }
                     cone { < 0, 0, 0 >,0.09,< 0, 0, -0.2 >,0.085
                              translate 2*x }
                     cone { < 0, 0, 0 >,0.085,< 0, 0, -0.2 >,0.08
                              translate 2*x rotate 5*y }
                     cone { < 0, 0, 0 >,0.08,< 0, 0, -0.2 >,0.07
                              translate 2*x rotate 10*y }
                     cone { < 0, 0, 0 >,0.07,< 0, 0, -0.2 >,0.06
                              translate 2*x rotate 15*y }
                     cone { < 0, 0, 0 >,0.06,< 0, 0, -0.2 >,0.05
                              translate 2*x rotate 20*y }
                     cone { < 0, 0, 0 >,0.05,< 0, 0, -0.2 >,0.04
                              translate 2*x rotate 25*y } 
                     cone { < 0, 0, 0 >,0.04,< 0, 0, -0.4 >,0.01
                              translate 2*x rotate 30*y }
                           translate < -1.6, 0, 1.8 >
                          
                           rotate < 90, 180, 90 >
                       pigment { color rgb < 0.3, 1, 0.1 > }
                       finish { ambient 0.2 }
                       }

#declare Snake = 
     union {
          object { Top rotate -15*z translate < 1.9, 0.65, 0.175 > }
          object { Asnake rotate 90*z translate < 1.7, 0.65, 0.6 > }
          object { Bsnake  }
          object { Dsnake translate -0.6*y }  
          object { Bsnake translate -1.2*y }
          object { Csnake translate < -2.25, -1.1, 0.2 > }   
           rotate < 0, 180, -90 >
           translate -10*z
           }

// THE LEAF

#declare Wave =
              cone { < 0, 0, 0 >,0.0,< 0, 0, -2 >,1 
                     scale < 1, 0.37, 1 >
                     rotate 40*x
                     translate 7.6*y
                  pigment { color Green }
                  normal { bumps 0.5 scale < 0.1, 0.1, 0.7 > } 
                  finish { ambient 0.2 }
                     }
#declare Bwave =
              cone { < 0, 0, 0 >,0.0,< 0, 0, 2 >,1 
                     scale < 1, 0.37, 1 >
                     rotate -40*x
                     translate 7.6*y 
                  pigment { color Green }
                  normal { bumps 0.5 scale < 0.1, 0.1, 0.7 > } 
                  finish { ambient 0.2 }
                     }


#declare Shape =
             union {            
                   object { Wave }
                   object { Wave rotate 18*z }
                   object { Wave rotate -18*z }
                   object { Bwave }
                   object { Bwave rotate 18*z }
                   object { Bwave rotate -18*z }
                    }
#declare Mlef =
             difference {
                    torus { 9, 1 rotate 90*x  scale < 1, 1, 1.25 > }   
                    object { Shape  }
                        }

#declare Main =
         union {
               object { Mlef }
               torus { 8, 0.1 rotate 90*x }
               clipped_by {
                           sphere { < 0, 5, 0 >,4 }   
                          }
                  pigment { color Green }
                  normal { bumps 0.5 scale < 0.1, 0.1, 0.7 > } 
                  finish { ambient 0.2 }
                }
#declare Stem =
               torus { 8, 0.15  rotate 90*x
                       clipped_by {
                               box { < 3, 5, -2 >,< 6.5, 7.5, 2 > }
                                  }
                       pigment { color rgb < 0.5, 1, 0.1 > }
                       finish { ambient 0.2 }
                      }
#declare Unit =
               union {
                    object { Main scale < 1.2, 1, 1 > }
                    object { Stem }
                        translate < -6.2, -5, 0 >
                        scale  < 1.2, 1.1, 2 >
                     }
#declare Set =
            union {
                object { Unit }
                object { Unit rotate 60*y }
                object { Unit rotate 120*y }  
                object { Unit rotate -60*y }  
                object { Unit rotate -120*y }  
                  }
#declare Mstem =                                       // main stem
              torus { 4, 0.3 rotate 90*x
                    clipped_by {
                                box { < -5, 0, -2 >,< -2, -5, 2 > }
                                }     
                    translate < 4, 0, 0 > 
                       pigment { color rgb < 0.5, 1, 0.1 > }
                       finish { ambient 0.2 }
                    }
#declare Fruit =
           sphere { < 0, 0, 0 >,0.225
                  pigment { color rgb < 0.65, 0.3, 0.6 > }
                  normal { bumps 1 scale 0.025 }
                  finish { ambient 0.25 
                           phong 1 }
                  }

#declare Fstem =                                            // fruit stem
              torus { 5, 0.08 rotate 90*x
                    clipped_by {
                                box { < 0, 0, -2 >,< 5.5, 5.5, 2 > }
                                }                
                  pigment { 
                           bozo
                           color_map {
                                      [ 0.0 color rgb < 0.2, 0.6, 0.2 > ]
                                      [ 0.5 color rgb < 0.8, 0.6, 0.2 > ]
                                      [ 0.7 color rgb < 0.6, 0.4, 0.2 > ] 
                                      [ 1.0 color rgb < 0.2, 0.6, 0.2 > ]
                                      }   
                            }          
                  normal { bumps 0.8 scale < 0.03, 0.03, 0.7 > }
                  finish { ambient 0.2 }   
                    }
#declare Bunch =
               union {
                      object { Fstem }
                      object { Fruit  translate 5*y }
                      object { Fruit  translate 4.675*x rotate 84*z }
                      object { Fruit  translate 5.325*x rotate 84*z }     
                      object { Fruit  translate < 5, 0, 0.325 > 
                              rotate 81*z }     
                      object { Fruit  translate < 5, 0, -0.325 > 
                              rotate 81*z }       
                      object { Fruit  scale 1.1
                               translate 4.674*x rotate 64*z }
                      object { Fruit  scale 1.15
                              translate 5.325*x rotate 74*z }     
                      object { Fruit  scale 1.1
                              translate < 5, 0, 0.325 > 
                              rotate 60*z }     
                      object { Fruit  scale 1.15
                              translate < 5, 0, -0.325 > 
                              rotate 50*z }       
                              
                      }
#declare Frustem =                          // main stem  + Bunch
            union {
              torus { 4, 0.3 rotate 90*x 
                      clipped_by {
                                box { < -5, 0, -2 >,< -2, -5, 2 > }
                                }     
                    translate < 4, 0, 0 > 
                       pigment { color rgb < 0.5, 1, 0.1 > }
                       finish { ambient 0.2 }
                    }
             object { Bunch translate -5*x scale 2.5 }
                  }
#declare Sprig =
            union { 
               object { Set }
               object { Mstem }
                   translate < -2, 3.5, 0 >
                   scale 0.2
                   }
#declare Frusprig =
            union { 
               object { Set }
               object { Frustem  }
               object { Frustem    rotate -30*y }    
                   translate < -2, 3.5, 0 >
                   scale 0.2
                   }

#declare Spray =
             object { Sprig rotate 90*y translate 5.5*y }
#declare Bspray =
             object { Sprig rotate < 30, 0, 30 > translate 5.5*y }
#declare Cspray =
             object { Sprig rotate < -50, 190, -30 > translate 5.5*y }

// THE BRANCHES

#declare Tharc =
            union {
              torus { 5.5, 0.15 rotate 90*z
                     clipped_by {
                                box { < -1, 6, 0 >,< 1, 0, -6 > 
                                      rotate 75*x   
                                      translate 3*y  } 
                                }
                  pigment { color rgb < 0.5, 0.8, 0.2 > }
                  normal { bumps 0.8 scale < 0.03, 0.03, 0.7 > }
                  finish { ambient 0.2 }  
                    }
                object { Spray rotate 40*x }
              }
#declare Arc =
          union {
              object { Tharc }
              object { Cspray rotate -50*x translate < 0.2, 0.2, 1.7 > }  
              object { Bspray rotate -44*x translate < -0.2, -0.2, 0.8 > }
              object { Cspray rotate -63*x translate < 0.2, 0.2, 1.7 > }
              object { Bspray rotate -82*x translate 1.7*z }
              object { Cspray rotate -90*x translate 2.2*z }
              torus { 5.5, 0.22 rotate 90*z
                     clipped_by {
                                box { < -1, 6, 0 >,< 1, 0, -6 > 
                                      rotate 45*x   
                                      translate 2.8*y  }
                                }
                  pigment { 
                           bozo
                           color_map {
                                      [ 0.0 color rgb < 0.2, 0.6, 0.2 > ]
                                      [ 0.5 color rgb < 0.8, 0.6, 0.2 > ]
                                      [ 0.7 color rgb < 0.6, 0.4, 0.2 > ] 
                                      [ 1.0 color rgb < 0.2, 0.6, 0.2 > ]
                                      }
                         
                           }      
                  normal { bumps 0.8 scale < 0.03, 0.03, 0.7 > }
                  finish { ambient 0.2 }  
                    }
                 }
#declare Brc =
              torus { 5.5, 0.27 rotate 90*z
                     clipped_by {
                                box { < -1, 6, 0 >,< 1, -1, -6 > 
                                      rotate -25*x  }
                                }
                  pigment { 
                           bozo
                           color_map {
                                      [ 0.0 color rgb < 0.2, 0.6, 0.2 > ]
                                      [ 0.5 color rgb < 0.8, 0.6, 0.2 > ]
                                      [ 0.7 color rgb < 0.6, 0.4, 0.2 > ] 
                                      [ 1.0 color rgb < 0.2, 0.6, 0.2 > ]
                                      }
                           
                           } 
                  normal { bumps 0.8 scale < 0.03, 0.03, 0.7 > }
                  finish { ambient 0.2 }  
                    }
#declare Crc =
              torus { 5.5, 0.37 rotate 90*z
                     clipped_by {
                                box { < -1, 6, 0 >,< 1, -1, -6 > 
                                      rotate -30*x }
                                }
                  pigment { 
                           bozo
                           color_map {
                                      [ 0.0 color rgb < 0.2, 0.6, 0.2 > ]
                                      [ 0.5 color rgb < 0.8, 0.6, 0.2 > ]
                                      [ 0.7 color rgb < 0.6, 0.4, 0.2 > ] 
                                      [ 1.0 color rgb < 0.2, 0.6, 0.2 > ]
                                      }
                           
                           }
                  normal { bumps 0.8 scale < 0.03, 0.03, 0.7 > }
                  finish { ambient 0.2 }  
                    }
#declare Drc =
              torus { 5.5, 0.42 rotate 90*z
                     clipped_by {
                                box { < -1, 6, 0 >,< 1, -1, -6 > }
                                      rotate -45*x
                                }
                  pigment { 
                           bozo
                           color_map {
                                      [ 0.0 color rgb < 0.2, 0.6, 0.2 > ]
                                      [ 0.5 color rgb < 0.8, 0.6, 0.2 > ]
                                      [ 0.7 color rgb < 0.6, 0.4, 0.2 > ] 
                                      [ 1.0 color rgb < 0.2, 0.6, 0.2 > ]
                                      }
                          
                           }
                  normal { bumps 0.8 scale < 0.03, 0.03, 0.7 > }
                  finish { ambient 0.2 }  
                    }

#declare Perch =
            union { 
                   object { Arc translate < 0, 0, 1.1 > }
                   object { Brc scale < 1, 1, 0.45 > }
                   object { Crc scale < 1, 1, 0.45 > }
                   object { Drc scale < 1, 1, 0.45 > }
                       translate < -1.5, -5.96, -0.9 >
                   }
#declare Rspray =
                 object { Sprig rotate 50*y translate 0.2*z }
#declare Lspray =
                 object { Sprig rotate -50*y translate -0.2*z }
#declare Fspray =
                 object { Frusprig rotate -50*y translate -0.2*z }

#declare Asp =
                 object { Rspray  rotate -90*x translate -10*z }
#declare Bsp =
                 object { Lspray rotate -110*x translate -10*z }
#declare Csp =
                 object { Rspray rotate -70*x translate -10*z }
#declare Dsp =
                 object { Lspray  rotate -90*x translate -10*z }
#declare Esp =
                 object { Rspray rotate -105*x translate -10*z }
#declare Fsp =
                 object { Lspray rotate -75*x translate -10*z }
#declare Gsp =
                 object { Fspray  rotate -90*x translate -10*z }




#declare Branch =
            union {
                 torus { 10, 0.22  } 
              object { Asp  }
              object { Bsp rotate -20*y  }
              object { Csp rotate 20*y  }
              object { Bsp rotate -40*y  }
              object { Csp rotate -60*y  translate < 0.3, -0.3, -0.2 > }
              object { Bsp rotate -80*y  }
              object { Csp rotate -100*y  translate < 0.3, -0.3, -0.2 > }  
              
              object { Dsp rotate -25*y  }
              object { Esp rotate 25*y  }
              object { Fsp rotate -47*y  }
           
              object { Dsp rotate -65*y  translate < 0.75, -0.25, -0.2 > }  
              object { Gsp rotate -65*y  translate < 0.75, -0.25, -0.2 > } 
              object { Fsp rotate -88*y  }
              object { Dsp rotate -95*y  }  
              object { Snake rotate 71*y }   // SNAKE  
                  scale < 1.25, 1, 1 >
                  pigment { 
                           bozo
                           color_map {
                                      [ 0.0 color rgb < 0.2, 1, 0.2 > ]
                                      [ 0.5 color rgb < 0.7, 1, 0.5 > ]
                                      [ 0.7 color rgb < 0.6, 1, 0.2 > ] 
                                      [ 1.0 color rgb < 0.7, 1, 0.5 > ]
                                      }
                          
                           }
                           
                  normal { bumps 0.8 scale < 0.03, 0.03, 0.7 > }
                  finish { ambient 0.2 }  
                    }    
                 

// THE TOUCAN

#declare Afethr =               
              union {
                    disc { < 0, 0, 0 >,< 0, 0, -1 >,0.25
                          scale < 2, 1, 1 >
                          pigment { color rgbt < 0.2, 0.1, 0.2, 0.1 > }
                          finish { ambient 0.2 }
                          }
                    cone { < -0.5, 0, 0 >,0.05, < 0.5, 0, 0 >,0.005
                          pigment { color rgbt < 0.13, 0.1, 0.1, 0.05 > }
                         }
                         translate 0.5*x
                     }

#declare Wfethr =               
              union {
                    disc { < 0, 0, 0 >,< 0, 0, -1 >,0.25
                          scale < 5, 1, 1 >
                          pigment { color rgbt < 0.2, 0.1, 0.2, 0.1 > }
                          finish { ambient 0.2 
                                   phong 1 }
                          }
                    cone { < -1.25, 0, 0 >,0.05, < 1.25, 0, 0 >,0.005
                          pigment { color rgbt < 0.13, 0.1, 0.1, 0.05 > }
                         }
                         translate 1.25*x
                     }
#declare Ledg =
           object { Afethr scale 0.6 rotate 45*y translate -1.42*z }

#declare Wing =
       union {
           object { Wfethr translate -1.47*z rotate 15*x }
           object { Wfethr scale 0.85 translate -1.39*z rotate 28*x } 
           object { Wfethr scale 0.75 translate -1.28*z rotate 40*x }  
           object { Wfethr translate < -1, 0, -1.57 >  }
           object { Wfethr scale 0.85 translate < -1, 0, -1.49 > rotate 10*x } 
           object { Wfethr scale 0.75 translate < -1, 0, -1.41 > rotate 20*x }  
           object { Wfethr translate < -1.4, 0, -1.62 > rotate -5*x }
           object { Wfethr scale 0.85 translate < -1.7, 0, -1.54 > rotate 5*x } 
           object { Wfethr scale 0.75 translate < -2, 0, -1.46 > rotate 15*x }  
           object { Ledg translate -1.4*x rotate -4*x  }
           object { Ledg translate  -1.7*x rotate 6*x }
           object { Ledg translate -2*x rotate 16*x }
           object { Ledg translate -1.6*x rotate -7*x  }
           object { Ledg translate  -1.9*x rotate 3*x }
           object { Ledg translate -2.2*x rotate 13*x }

                 }
#declare Rwing =
       union {
           object { Wfethr translate 1.47*z rotate -15*x }
           object { Wfethr scale 0.85 translate 1.39*z rotate -28*x } 
           object { Wfethr scale 0.75 translate 1.28*z rotate -40*x }  
           object { Wfethr translate < -1, 0, 1.57 >  }
           object { Wfethr scale 0.85 translate < -1, 0, 1.49 > rotate -10*x } 
           object { Wfethr scale 0.75 translate < -1, 0, 1.41 > rotate -20*x }  
           object { Wfethr translate < -1.4, 0, 1.62 > rotate 5*x }
           object { Wfethr scale 0.85 translate < -1.7, 0, 1.54 > rotate -5*x } 
           object { Wfethr scale 0.75 translate < -2, 0, 1.46 > rotate -15*x }  

                 }

                 
                 
#declare Bfethr =               
              union {
                    disc { < 0, 0, 0 >,< 0, 0, -1 >,0.25
                          scale < 2, 1, 1 >
                          pigment { color rgbt < 1, 0.1, 0.1, 0.1 > }
                          finish { ambient 0.2 }
                          }
                    cone { < -0.5, 0, 0 >,0.05, < 0.5, 0, 0 >,0.005
                          pigment { color rgbt < 1, 0.05, 0.1, 0.05 > }
                         }
                         scale 0.8
                         translate 0.5*x
                     }
#declare Cfethr =               
             
                    disc { < 0, 0, 0 >,< 0, 0, -1 >,0.25
                          scale < 0.7, 0.3, 0.3 >
                          pigment { color White }
                          finish { ambient 0.2 }   
                          translate 0.5*x
                         }

#declare Skul =
            union {
              sphere { < 0, 0, 0 >,1  scale < 1.25, 0.95, 0.6 >   
                       translate -0.4*x
                        clipped_by {
                                  box { < -1.2, 2, 2 >,< 2, -2, -2 > }
                                   }
                       translate 0.35*y                         
                       pigment { color Gray10 }
                       normal { bumps 0.2  scale < 0.2, 0.1, 0.03 > } 
                       finish { ambient 0.2
                                phong 0.5
                                phong_size 50
                              }
                     }
              sphere { < 0, 0, 0 >,1  scale < 1, 0.5, 0.6 >   
                       translate < 0.6, 0.9, 0 >
                       pigment { color Gray10 }
                       normal { bumps 0.2  scale < 0.2, 0.1, 0.03 > } 
                       finish { ambient 0.2
                                phong 0.5
                                phong_size 50
                              }
                     }
                  }
#declare Throt =
           union {
              sphere { < 0, 0, 0 >,1.01  scale < 1.3, 0.8, 0.6 >
                        translate -0.4*x 
                        clipped_by {
                                  box { < -1.1, 0.2, 2 >,< 2, -2, -2 > } 
                                    //    rotate -10*z  }
                                   }
                       translate 0.125*y                            
                       pigment { color rgb < 1, 1, 0.95 > }
                       normal { bumps 0.2  scale < 0.1, 0.05, 0.03 > }
                       finish { ambient 0.25
                                phong 0.5
                                phong_size 50
                              }
                     }
             object { Cfethr rotate 8*y translate < -1.4, 0.32, -0.52> } 
             object { Cfethr rotate 8*y translate < -1.25, 0.32, -0.52> }   
             object { Cfethr rotate 6*y translate < -1.15, 0.34, -0.55 > }
             object { Cfethr rotate 6*y translate < -1.05, 0.33, -0.56 > }
             object { Cfethr rotate 6*y translate < -0.9, 0.35, -0.56 > } 
             object { Cfethr rotate -6*y translate < -0.65, 0.25, -0.7 > }
             object { Cfethr rotate -8*y translate < -0.55, 0.2, -0.68 > }
             object { Cfethr rotate -8*y translate < -0.8, 0.225, -0.68 > } 
             object { Cfethr rotate -8*y translate < -0.25, 0.2, -0.68 > } 
             object { Cfethr rotate -8*y translate < -0.05, 0.15 -0.62 > }
             object { Cfethr rotate -8*y translate < 0, 0.05, -0.62 > } 

                 }

#declare Epach =
            union {
               triangle {
                < -1.1, 0.65, -0.5 >,< -0.4, 0.3, -0.65 >,< -1.1, 0.5, -0.5 >
                        }

               triangle {
                 < -1.1, 0.1, -0.53 >,< -0.4, 0.3, -0.65 >,< -1.1, 0.5, -0.5 >
                        }
               sphere { < 0, 0, 0 >,0.26  scale < 1, 0.65, 0.2 >
                       translate < -0.75, 0.25, -0.53 >
                      }
                 pigment { color rgb < 1, 0.4, 0.2 > }
                 finish { ambient 0.2 }
                        }
#declare Eye =
         union {
             sphere { < 0, 0, 0 >,0.12
                     translate < -0.9, 0.35, -0.58 >
                     pigment { color Black }
                     finish { phong 1 }
                     }
            torus { 0.14, 0.02
                    rotate 90*x
                    translate < -0.9, 0.35, -0.58 > 
                    pigment { color White }
                    finish { ambient 0.2 }
                   }
            torus { 0.125, 0.075   scale < 3, 0.3, 1.5 >
                    rotate < 90, 11, -25 >
                    translate < -0.9, 0.35, -0.5 > 
                    pigment { color Red }
                    finish { ambient 0.2 }
                   }
              clipped_by {
                         box { < -1.1, 0.1, -1 >,< -0.3, 0.7, 0.5 >}
                         }
               }
#declare Tbill =
               difference {
                     sphere { < 0, 0, 0 >,3.75 }
                     union { 
                            box { < 0, -0.25, -4 >,< 4, 4, 4 > }
                            box { < -4, -0.2, -4 >,< 4.5, -4, 4 > }
                            cylinder { < 0, 0, -4 >,< 0, 0, 4 >,3.75  
                                       scale  < 1, 0.5, 1 > 
                                     }
                           }
                      scale < 1.1, 0.5, 0.12 >        
                      translate < 0.5, -0.8, 0 >           
                   texture {
                      pigment { 
                                gradient y
                                     color_map {
                                             [ 0.0 color rgb < 0.8, 0, 0 > ]
                                             [ 1.0 color rgb < 1, 1, 0.3 > ]
                                               }
                                      scale 1.15                     
                               }
                      finish { ambient 0.2 
                               phong 0.4
                               phong_size 80 }
                             } 
                    texture {          
                      pigment { 
                                gradient y
                                turbulence 0.1
                                     color_map {
                                             [ 0.0 color Gray20 ]
                                             [ 0.2 color Gray30 ]
                                             [ 0.2 color Clear ]
                                             [ 0.8 color Clear ]
                                             [ 0.8 color Gray50 ]
                                             [ 1.0 color Gray40 ]

                                               }
                                      scale 2.5
                                      rotate  -8*z 
                                      translate -5*x
                               }

                      finish { ambient 0.2 
                               phong 0.4
                               phong_size 80 }
                                          
                            }
                           }
#declare Bbill =
            union {
              cone { < -1.12, -0.16, 0 >,0.49,< -1, -0.16, 0 >,0.5
                      scale < 1, 0.85, 1 >
                      rotate 10*z
                      pigment { color Gray05 }
                      finish { ambient 0.2 }
                   }
              cone { < -0.8, -0.15, 0 >,0.3,< -3, -0.1, 0 >,0.01  // tongue
                      scale < 1, 0.7, 0.9 >
                      rotate 10*z
                      pigment { color Red }
                      finish { ambient 0.2 }
                   }


              cone { < -1, 0, 0 >,0.5,< -4.5, 0, 0 >,0.15
                      scale < 1, 2, 0.8 >
                      clipped_by {
                            cylinder { < 0, 0, -4 >,< 0, 0, 4 >,1
                                       scale  < 4.3, 0.75, 1 >  
                                       translate -0.25*y  }
                                 }
                      scale < 1.08, 0.44, 1.04 >
                      translate -0.1*y
                      rotate 10*z
                   texture {
                      pigment { 
                                gradient y
                                     color_map { 
                                           [ 0.0 color rgb < 0.7, 0.3, 0 > ]
                                            
                                           [ 0.8 color rgb < 1, 0.7, 0 > ]
                                           
                                           [ 1.0 color rgb < 1, 0.7, 0 > ] 
                                               } 
                                 rotate 10*z                        
                               }  
                      finish { ambient 0.2 }
                           }
                   }
                 }
#declare Head =
           union {
                object { Fruit translate < -4.55, -0.55, 0 > }
                object { Skul }
                object { Throt }   
                object { Tbill translate -1.5*x }
                object { Bbill scale < 1.1, 1.2, 1 > translate 0.25*y }  
                object { Epach translate 0.2*y }
                object { Eye translate 0.2*y }
                 }
#declare Toe =
             torus { 0.3, 0.08
                    rotate 90*x
                    translate  -0.3*y
                    pigment { color Gray55 }
                    finish { ambient 0.2 
                              phong 1 }
                    }
#declare Pants =
             union {
                object { Afethr rotate -40*z
                         translate < -0.6, 0.8, -0.4 > 
                       }   
                object { Afethr scale < 0.8, 0.8, 1 > 
                         rotate -40*z
                         translate < -0.7, 0.7, -0.45 > 
                        }    
                       
                object { Afethr scale < 0.8, 0.8, 1 > 
                         rotate -50*z
                         translate < -0.55, 0.6, -0.42 > 
                       }  
                object { Afethr scale < 0.8, 0.8, 1 > 
                         rotate -50*z
                         translate < -0.4, 0.25, -0.45 > 
                        }    
                object { Afethr scale < 0.8, 0.8, 1 > 
                         rotate -50*z
                         translate < -0.2, 0.25, -0.45 > 
                       } 
                object { Afethr scale < 0.6, 0.7, 1 > 
                         rotate -45*z
                         translate < 0, 0, -0.45 > 
                        } 
                object { Afethr scale < 0.6, 0.6, 1 > 
                         rotate -35*z
                         translate < -0.05, 0.2, -0.45 > 
                       }     
                object { Afethr scale < 0.6, 0.6, 1 > 
                         rotate -35*z
                         translate < -0.25, 0.4, -0.45 > 
                       }     
                object { Afethr scale < 0.6, 0.6, 1 > 
                         rotate -35*z
                         translate < -0.25, 0.6, -0.45 > 
                       }     
                object { Afethr scale < 0.6, 0.6, 1 > 
                         rotate -35*z
                         translate < -0.25, 0.8, -0.45 > 
                       }     
                object { Afethr scale < 0.6, 0.7, 1 > 
                         rotate < 0, 15, -45 >
                         translate < 0, 0, -0.45 > 
                        } 
                object { Afethr scale < 0.6, 0.6, 1 > 
                         rotate < 0, 15, -35 >
                         translate < -0.05, 0.2, -0.4 > 
                       }     
                object { Afethr scale < 0.6, 0.6, 1 > 
                         rotate < 0, 15, -35 >  
                         translate < -0.25, 0.4, -0.4 > 
                       }     
                object { Afethr scale < 0.6, 0.6, 1 > 
                         rotate < 0, 15, -35 >  
                         translate < -0.25, 0.6, -0.4 > 
                       }     
                object { Afethr scale < 0.6, 0.6, 1 > 
                         rotate < 0, 15, -35 >  
                         translate < -0.25, 0.8, -0.4 > 
                       }     
                object { Afethr scale < 0.6, 0.6, 1 > 
                         rotate < -15, 0, -35 >
                         translate < 0, 0.85, -0.4 > 
                       }     
                object { Afethr scale < 0.6, 0.6, 1 > 
                         rotate < -15, 0, -35 >
                         translate < 0.25, 0.8, -0.4 > 
                       }     
                object { Afethr scale < 0.7, 0.6, 1 > 
                         rotate < -18, 0, -35 >
                         translate < 0.45, 0.9, -0.36 > 
                       }     
                object { Afethr scale < 0.7, 0.6, 1 > 
                         rotate < -21, 0, -25 >
                         translate < 0.65, 0.9, -0.35 > 
                       }     
                object { Afethr scale < 0.8, 0.6, 1 > 
                         rotate < -23, -8, -15 >
                         translate < 1, 1, -0.4 > 
                       }     
                object { Afethr scale < 0.85, 0.6, 1 > 
                         rotate < -27, -10, -10>
                         translate < 1.25, 1.05, -0.45 > 
                       }     
                object { Afethr scale < 0.9, 0.6, 1 > 
                         rotate < -30, -13, 0 >
                         translate < 1.8, 1.1, -0.33 > 
                       }     
                object { Afethr scale < 0.9, 0.6, 1 > 
                         rotate < -15, -13, 0 >
                         translate < 1.7, 1.1, -0.33 > 
                       }  
                }
#declare Scal =
             sphere { < 0, 0, 0 >,0.1
                     pigment { color Gray55 }
                     finish { ambient 0.2 
                              phong 1 }
                     }
#declare Shin =
            union {
                  cone { < 0, 0, 0 >,0.08, < 1.5, 0, 0 >,0.1 }
                  object { Scal }
                  object { Scal translate 0.1*x }
                  object { Scal translate 0.2*x }
                  object { Scal scale 0.92 translate 0.3*x }
                  object { Scal scale 0.81 translate 0.4*x }
                  rotate 18*z
                  translate < -1.5, -0.5, 0 >
                     pigment { color Gray55 }
                     finish { ambient 0.2 
                              phong 1 } 
                  }
#declare Leg =                             
             union {
                   object { Toe rotate 30*y
                           translate < -1.5, -0.5, 0 >
                           }
                   object { Toe rotate -30*y
                           translate < -1.5, -0.5, 0 >
                           }

                   sphere { < 0, 0, 0 >,0.25 }
                   object { Shin }    
                   pigment { color Gray15 }
                   finish { ambient 0.2 }
                   }
#declare Body =
             union {
                    
                    object { Branch    
                         rotate < 90, 85, 0 >
                         translate < -15, -5, 0 >
                           }
                    object { Branch    
                         rotate < 90, 45, 0 >
                         translate < -15, -10, 15 >
                           }
              
                   object { Perch translate < 0.35, -1.52, 0 > }
                   
                   
                   union {
                   sphere { < 0, 0, 0 >,1  scale < 1.2, 0.46, 0.6 > }
                   object { Bfethr translate -0.55*z rotate -45*x }
                   object { Bfethr translate < -0.5, 0, -0.6 > 
                            rotate -45*x } 
                   object { Bfethr translate < -1, 0, -0.61 > 
                            rotate -45*x }  
                   object { Bfethr translate < -1.5, 0, -0.63 > 
                            rotate -55*x }  
                            
                   object { Bfethr translate < 0.3, 0, -0.4 > 
                            rotate -45*x }   
                   object { Bfethr translate < 0.6, 0, -0.3 > 
                            rotate -45*x }   
                   object { Bfethr translate < 0.9, 0, -0.2 > 
                            rotate -45*x }   
                   object { Bfethr translate -0.46*z rotate -30*x }
                   object { Bfethr translate < -0.5, 0, -0.46 > 
                            rotate -30*x } 
                   object { Bfethr translate < 0.3, 0, -0.4 > 
                            rotate -30*x }   
                   object { Bfethr translate < 0.6, 0, -0.3 > 
                            rotate -30*x }   
                   object { Bfethr translate < 0.9, 0, -0.2 > 
                            rotate -30*x }  
                             rotate 15*z
                             translate < 3, 0.15, 0 >         // under tail
                             pigment { color Red }
                             finish { ambient 0.2 }
                          }

                   object { Leg translate < 0.35, -1.35, -1.35 > }
                   object { Leg translate < 0.35, -1.35, 1.35 > }  
                   object { Pants 
                               translate < 0.05, -1.35, -1 > }
                   object { Pants scale 0.55 
                               translate < -0.05, -1.35, -1 >  }
                   object { Pants 
                               translate < 0.05, -1.35, 1.6 > }
                   object { Pants scale 0.55 
                               translate < -0.15, -1.2, 1.65 >  }

                   cone { < 0, 0, 0 >,0.4,< 0.35, -1.35, -1.35 >,0.25 } // leg
                   sphere { < 0, 0, 0 >,3  scale < 1, 0.4, 0.5 > 
                       pigment { color Gray10 }
                       normal { bumps 0.2  scale < 0.2, 0.1, 0.03 > } 
                       finish { ambient 0.2
                                phong 0.5
                                phong_size 50  }
                         }                                  // body 
                   sphere { < 0, 0, 0 >,3.05  scale < 1, 0.4, 0.5 > // chest
                             clipped_by {
                                     box { < -4, -0.25, 3 >,< 0, -2, -3 >
                                            rotate -40*z           
                                            translate -1.85*y
                                            }   
                                         }   
                       pigment { color rgb < 1, 1, 0.95 > }
                       normal { bumps 0.2  scale < 0.1, 0.05, 0.03 > }
                       finish { ambient 0.35
                                phong 0.5
                                phong_size 50
                              }
                         }                
                   object { Afethr scale < 0.8, 0.8, 1 >  // breast feathers
                         rotate < -20, 0 -5 >
                         translate < -1.1, -0.3, -0.5 >             
                        }    

                   cone { < 1, 0, 0 >,1.25< 3, 0, 0 >,1        // over tail
                           scale < 1, 0.36, 1 >
                           translate 0.5*y
                           pigment { color White }
                           normal { bumps 0.2  scale < 0.1, 0.05, 0.03 > }
                        }
                   object { Cfethr scale 4  rotate < 90, 0, 15 > 
                              translate < 0.5, 0.182, 0 > }
                   object { Cfethr scale 4  rotate < 75, 0, 15 > 
                              translate < 0.52, 0.182, -0.85 > }
                   object { Cfethr scale 4  rotate < 105, 0, 15 > 
                              translate < 0.52, 0.182, 0.85 > }
                   object { Cfethr scale 3.4  rotate < 70, 0, 15 > 
                              translate < 0.75, 0, -1.25 > }
                   object { Cfethr scale 3.4  rotate < 70, 0, 15 > 
                              translate < 0.75, 0, 1.25 > }




                   sphere { < 0, 0, 0 >,5  scale < 1, 0.01, 0.4 >  // tail
                             clipped_by {
                                        sphere { < 0, 0, 0 >,4
                                                translate -4*x
                                                }
                                        }  
                           rotate 15*z             
                           translate < 6.5,  1.5, 0 >
                          }
                    object { Wfethr scale < 1.5, 3, 1 >       // centre
                             rotate < 90, 0, 15 >
                             translate < 2.8, 0.8, 0 >
                            }
                    object { Wfethr scale < 1.5, 3, 1 >
                             rotate < 80, 5, 15 >
                             translate < 2.8, 0.7, -0.4 >
                            }
                    object { Wfethr scale < 1.5, 3, 1 >
                             rotate < 80, 10, 15 >
                             translate < 2.8, 0.6, -0.8 >
                            }
                    object { Wfethr scale < 1.5, 3, 1 >    // outer left
                             rotate < 70, 18, 15 >
                             translate < 2.8, 0.56, -1.051 >
                            }
                    object { Wfethr scale < 1.5, 3, 1 >
                             rotate < 100, -5, 15 >
                             translate < 2.8, 0.7, 0.4 >
                            }
                    object { Wfethr scale < 1.5, 3, 1 >
                             rotate < 100, -10, 15 >
                             translate < 2.8, 0.6, 0.8 >
                            }
                    object { Wfethr scale < 1.5, 3, 1 >     // outer right
                             rotate < 110, -18, 15 >
                             translate < 2.8, 0.56, 1.051 >
                            }   
                    object { Wing }
                    object { Rwing } 
                       pigment { color Gray05 }
                       normal { bumps 0.2  scale < 0.1, 0.05, 0.03 > } 
                       finish { ambient 0.2
                                phong 0.5
                                phong_size 50
                              }   
                   }
#declare Bird =
            union {
                  object { Head }
                  object { Body  rotate < 0, -20, 30 >
                                 translate < 2.5, 1.3, 1 >
                         }
                 }
object { Bird }
  
