
// Persistence of Vision Ray Tracer Scene Description File
// File: endevour.inc
// Vers: 3.1 beta 5
// Desc: Inc file for the Endevour Ship model
// Date: Aug 98
// Auth: Nathan O'Brien
// Email : no13@no13.net
// Web : www.no13.net

#declare Hull_Switch = on;

#declare Endevour =
union {

#if (Hull_Switch = on)
	#include "hull.inc"
	object {Hull_Main}
#end

#declare Centre_Board =
union {
	difference {
		cylinder {<1.5,60,-40.6529><-1.5,60,-40.6529>,92}
		box {<100,0,500><-100,-100,-500>}
		box {<100,63,-160><-100,160,-124>}
		box {<100,50,-124.6529><-100,160,10>}
		box {<100,60,9><-100,160,136.0770>}
	}
	difference {
		box {<1.5,0,10><-1.5,60,136.0770>}
		box {<100,-100,0><-100,200,200> rotate <15,0,0> translate <0,0,120>}
	}
}

object {Centre_Board texture{T_Timber3}}

#declare Rudder_Hinge1 =
union {
	cylinder {<1.5,5.2386,115.9040><1.5,3.7343,121.5182>,.5}
	cylinder {<1.5,4.2173,121.6476><1.5,2.2854,121.1300>,.5}
	cylinder {<1.5,2.7684,121.2594><1.5,1.5228,125.9078>,.5}

	cylinder {<-1.5,5.2386,115.9040><-1.5,3.7343,121.5182>,.5}
	cylinder {<-1.5,4.2173,121.6476><-1.5,2.2854,121.1300>,.5}
	cylinder {<-1.5,2.7684,121.2594><-1.5,1.5228,125.9078>,.5}
}

#declare Rudder_Hinge2 =
union {
	cylinder {<1.5,43.8757,126.2567><1.5,42.3713,131.8710>,.5}
	cylinder {<1.5,42.8543,132.0004><1.5,40.9224,131.4828>,.5}
	cylinder {<1.5,41.4054,131.6122><1.5,40.8473,133.6949>,.5}

	cylinder {<-1.5,43.8757,126.2567><-1.5,42.3713,131.8710>,.5}
	cylinder {<-1.5,42.8543,132.0004><-1.5,40.9224,131.4828>,.5}
	cylinder {<-1.5,41.4054,131.6122><-1.5,40.8473,133.6949>,.5}
}

#declare Rudder =
union {
	difference {
		box {<1.5,1,121.3032><-1.5,49,136.1995>}
		box {<100,-100,0><-100,200,-100> rotate <15,0,0> translate <1.5,1,121.3032>}
		box {<100,-100,0><-100,200,100> rotate <5,0,0> translate <-1.5,49,136.1995>}
	}
	object {Rudder_Hinge1 pigment{Yellow}}
	object {Rudder_Hinge1 translate <0,4.8296,1.2941> pigment{Yellow}}
	object {Rudder_Hinge1 translate <0,9.6593,2.5882> pigment{Yellow}}
	object {Rudder_Hinge1 translate <0,14.4889,3.8823> pigment{Yellow}}
	object {Rudder_Hinge1 translate <0,19.3185,5.1764> pigment{Yellow}}
	object {Rudder_Hinge1 translate <0,24.1481,6.4705> pigment{Yellow}}
	object {Rudder_Hinge1 translate <0,28.9778,7.7646> pigment{Yellow}}
	object {Rudder_Hinge2 pigment{Yellow}}
	object {Rudder_Hinge2 translate <0,4.8296,1.2941> pigment{Yellow}}
	object {Rudder_Hinge2 translate <0,-4.8296,-1.2941> pigment{Yellow}}
}

object {Rudder pigment{Green}}

#declare Ladder1 = box {<45,0,0><-45,1,8> texture{T_Hbl}}

difference {
	union {
		object {Ladder1 translate <0,38,2>}
		object {Ladder1 translate <0,40,2>}
		object {Ladder1 translate <0,42,2>}
		object {Ladder1 translate <0,44,2>}
		object {Ladder1 translate <0,46,2>}
		object {Ladder1 translate <0,48,2>}
		object {Ladder1 translate <0,50,2>}
		object {Ladder1 translate <0,52,2>}
		object {Ladder1 translate <0,54,2>}
		object {Ladder1 translate <0,56,2>}
		object {Ladder1 translate <0,58,2>}
		object {Ladder1 translate <0,60,2>}

		box {<45,38,-4><-45,57,-5.5> texture{T_Hbl}}
		box {<45,38,-10><-45,58,-11.5> texture{T_Hbl}}
	}
	box {<0,200,50><200,-200,-50> rotate <0,0,7> translate <40,44,0> texture{T_Hbl}}
	box {<0,200,50><-200,-200,-50> rotate <0,0,-7> translate <-40,44,0> texture{T_Hbl}}
}

#declare Rail_P1 = box {<-0.5,0,-0.5><0.5,-8,0.5> texture{T_Hbl}}

#declare Rail_P2 =
union {
	box {<-0.5,0,-0.5><0.5,-3,0.5> texture{T_Hbl}}
	sphere {<0,0,0>,1 texture{T_Hbl}}
}

#declare Rail_P3 =
union {
	cylinder {<0,0,0><0,-10,0>,.75 texture{T_Hbl} scale<1.5,1,1>}
	sphere {<0,0,0>,.75 texture{T_Hbl} scale<1.5,1,1>}
	sphere {<0,-10,0>,.75 texture{T_Hbl} scale<1.5,1,1>}
}

#declare Rail_One =
union {
	box {<1,62,-20><-1,63,0> texture{T_Hbl}}
	box {<1,0,0><-1,1,-45.2> rotate<5,0,0> translate <0,62,-20> texture{T_Hbl}}

	object {Rail_P1 translate<0,66.2402,-62.5000>}
	object {Rail_P1 translate<0,65.6883,-58.5000>}
	object {Rail_P1 translate<0,65.4137,-54.5000>}
	object {Rail_P1 translate<0,64.2973,-39.5000>}
	object {Rail_P1 translate<0,63.7482,-34.5000>}
	object {Rail_P1 translate<0,62.4940,-19.5000>}
	object {Rail_P1 translate<0,62.4940,-10.5000>}
	object {Rail_P2 translate<0,60.2610,-49.5000>}
	object {Rail_P2 translate<0,59.5834,-44.5000>}
	object {Rail_P2 translate<0,58.2848,-29.5000>}
	object {Rail_P2 translate<0,57.9460,-24.5000>}
}

#declare Rail_Two =
union {
	box {<1,69,0><-1,70,10> texture{T_Hbl}}
	box {<1,78,112.8268><-1,79,148.0653> texture{T_Hbl}}
	box {<1,0,0><-1,1,103.3071> rotate<-5,0,0> translate <0,69,10> texture{T_Hbl}}

	object {Rail_P1 translate<0,69.5000,1.5000>}
	object {Rail_P1 translate<0,69.5000,10.5000>}
	object {Rail_P1 translate<0,70.3842,19.5000>}
	object {Rail_P1 translate<0,71.5896,34.5000>}
	object {Rail_P1 translate<0,72.6754,43.5000>}
	object {Rail_P1 translate<0,73.5911,58.5000>}
	object {Rail_P1 translate<0,74.4999,67.5000>}
	object {Rail_P1 translate<0,76.6555,89.3907>}
	object {Rail_P1 translate<0,77.9488,105.6740>}
	object {Rail_P1 translate<0,78.7033,126.0550>}

	object {Rail_P2 translate<0,65.7554,24.5000>}
	object {Rail_P2 translate<0,66.2312,29.5000>}
	object {Rail_P2 translate<0,67.8439,48.5000>}
	object {Rail_P2 translate<0,68.3488,53.5000>}
	object {Rail_P2 translate<0,71.7977,93.2915>}
	object {Rail_P2 translate<0,72.5521,101.1636>}
	object {Rail_P2 translate<0,74.2766,132.5439>}

	object {Rail_P3 translate<0,78.5859,80.7500>}
	object {Rail_P3 translate<0,79.6636,96.2500>}
	object {Rail_P3 translate<0,81.4084,115.7500>}
	object {Rail_P3 rotate <30,0,0> translate<0,80.5434,149.0973>}
}


object {Rail_One translate <35,0,0>}
object {Rail_One translate <-35,0,0>}

object {Rail_Two translate <34,0,0>}
object {Rail_Two translate <-34,0,0>}

#include "mast1.inc"
object {Mast1 translate <0,60,-100> pigment{White}finish{phong 1}}
object {Mast1 translate <0,61,15> pigment{White}finish{phong 1}}
object {Mast2 translate <0,67,78> pigment{White}finish{phong 1}}

#include "prow.inc"
object {Prow translate <0,58,-125> pigment{White}finish{phong 1}}

#include "ropes.inc"
object {Ropes
texture {
	pigment{
		gradient x+y
		color_map {
			[0.0 rgb <0.392, 0.196, 0.078>]
			[0.5 rgb <0.392, 0.196, 0.078>]
			[0.5 rgb <0.525, 0.353, 0.196>]
			[1.0 rgb <0.525, 0.353, 0.196>]
		}
		scale .2
	}
	finish {phong 0.5}
}
}

#include "sail3.inc"
object {Front_Sail rotate <-90,180,0> scale <-1,1,1>}

#include "anchor.inc"

object {Anchor rotate <0,-45,0> translate <0,60,-100> pigment{White}}
object {Anchor rotate <0,-45,0> translate <0,60,-100> scale <-1,1,1> pigment{White}}

// rear flag stuff
cylinder {<0,127.8114,186.8098><0,66.5278,135.3868>,1 texture {T_Timber4}}
sphere {<0,66.5278,135.3868>,1.5 texture {T_Timber4}}   
#include "flag2.inc"
object {Flag02}

//sphere {<-6,58,-126>,3 pigment{Red}} 
torus {2.5,1 sturm rotate <90,15,0> translate <-6,58,-127> texture{T_Iron}}
torus {2.5,1 sturm rotate <90,-15,0> translate <6,58,-127> texture{T_Iron}}

#declare link_point1 = <-26,58,-125>
#declare link_point2 = <-6,58,-128> 
#declare link_looseness = 4;   
#declare link_size = 3;    
#declare link_twist = 0.5;

#include "linkobjs.inc"

#declare link_object = Iron_Chain 

#include "LINK.INC"

#declare link_point1 = <26,58,-125>
#declare link_point2 = <6,58,-128> 

#include "LINK.INC"

}
