
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: OCEAN HEIGHT FIELD
// Date: July 98
// Auth: Nathan O'Brien
// Email : no13@no13.net
// Web : www.no13.net

#include "colors.inc"

camera {
	location <0,0,-3>
	look_at  <0,0,0>
}

box {<20,20,1><-20,-20,0>
	pigment{White}
	normal {granite 1 poly_wave 0.5 scale <7,5,5> turbulence 0.5}
}

#macro Peak (P1,P2,P3,P4)
	light_source {
		<0,0,-3>
		color (<0.6,0.6,0.6> * P2)
		spotlight
		point_at P1
		radius (5 * P3)
		tightness 50
		falloff (20 * P4)
	}
#end

#declare Apple = seed(31);

#declare Counter = 0;
#while (Counter < 40)

	#declare S1 = rand(Apple);
	#if (S1 > 0.5) #declare S1 = 1; #else #declare S1 = -1; #end
	#declare S2 = rand(Apple);
	#if (S2 > 0.5) #declare S2 = 2; #else #declare S2 = -1; #end	
	#declare Px = (rand(Apple) * 2);
	#declare Py = (rand(Apple) * 1.5);
	#declare Pn = <(Px * S1),(Py * S2),0>;
	
	#declare S1 = rand(Apple);
	#if (S1 > 0.25) #declare S1 = 1; #else #declare S1 = -1; #end
	
	#declare Cint = (((rand(Apple) * 0.75) + 0.25) * S1);
	#declare Pr = ((rand(Apple) * 0.5) + 0.5);
	#declare Pf = ((rand(Apple) * 0.5) + 0.5);

	Peak (Pn,Cint,Pr,Pf)
	
	#declare Counter = (Counter + 1);

#end
