
/*
#include "colors.inc"


// ----------------------------------------
camera
{
  location  <0.0, 0.5, -20.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}
*/
// -------------------------Head of figure--------------------------------

#declare Head = union{

#declare Angle = 0
#declare Rad = 1.5
#declare Srad = 0.75
#declare Count = 35

#while (Count>0)

       sphere{0,Srad
          #if(Count<5) scale<0.75,1,0.75> #end
             translate<0,Rad,0>
                 rotate z*Angle
             }

       #declare Count = Count -1
       #declare Angle = Angle + 2
       #declare Srad = Srad + 0.01

#end
}

#declare Hat = union{

#declare Angle = 0
#declare Rad = 0.5
#declare Srad = 0.75
#declare Xinc = 0
#declare Count = 0

#while (Count<500)

       sphere{0,Srad
             translate<Xinc,Rad*sin(Xinc),Rad*cos(Xinc)>
             }

       #declare Xinc = Xinc + 0.025
       #declare Count = Count +1
       #declare Srad = Srad - 0.0025

#end
}

#declare Fhead = union{
         object{Head
               rotate z*-65
               translate<-1.405,-0.575,0.49>
               }
         object{Hat rotate z*-90}
         rotate z*10
         }   //end of union

//-----------------------------------body---------------------------------------------

#declare Skirt = union{

#declare Angle = 0
#declare Rad = 5
#declare Srad = 0.1
#declare Count = 0

#while (Count<150)

       sphere{0,Srad
             translate<0,Rad,0>
                 rotate z*Angle
             }

       #declare Count = Count + 1
       #declare Angle = Angle + 0.3
       #declare Srad = Srad + 0.00175

#end
translate<0,-Rad,0>
rotate z*90
rotate y*-90
scale <1,1.25,1>
}


#declare Fullskirt = union{
#declare Angle = 0
#declare Rad = 0.25
#declare Count = 0

#while (Count<150)

       object{Skirt
             translate<0,0,Rad>
                 rotate y*Angle
             }

       #declare Count = Count + 1
       #declare Angle = Angle + 36


#end
}

#declare Body = union{

#declare Angle = 0
#declare Rad = 5
#declare Count = 0

#while (Count<150)

       sphere{0,0.35
             translate<0,Rad,0>
                 rotate z*Angle
             }

       #declare Count = Count + 1
       #declare Angle = Angle + 0.1


#end
rotate y*180
translate<0,-Rad,0>
}

//-----------------------Arm--------------------------------

#declare Arm = merge{

#declare Angle = 0
#declare Rad = 3
#declare Srad = 0.1
#declare Count = 0

#while (Count<150)

       sphere{0,Srad
             translate<0,Rad,0>
                 rotate z*Angle
             }

       #declare Count = Count + 1
       #declare Angle = Angle + 0.3
       #declare Srad = Srad + 0.005

#end
translate<0,-Rad,0>
rotate z*120
//rotate y*20
scale <1,1.25,0.1>
clipped_by{plane{x,1.5}}
}

#declare Arm2 = merge{

#declare Angle = 0
#declare Rad = 3
#declare Srad = 0.1
#declare Count = 0

#while (Count<150)

       sphere{0,Srad
             translate<0,Rad,0>
                 rotate z*Angle
             }

       #declare Count = Count + 1
       #declare Angle = Angle + 0.3
       #declare Srad = Srad + 0.005

#end
translate<0,-Rad,0>
rotate z*150
//rotate y*-20
scale <1,1.25,0.1>
clipped_by{plane{x,1.25}}
}
// -----------------------------All together now!-------------------------------------
#include "hand.inc"
#declare Figure = union{
        object{Fullskirt rotate z*10 translate<-0.025,0,0>}
        object{Body rotate z*90 translate<0,-0.2,0> }
        object{Fhead
              scale 0.375
              translate<0.6,1.4,0>
        }
object {LHand scale 0.055 translate<1.45,1.25,1>rotate y*180}
object {RHand scale 0.0525 translate<1.8,0.35,-0.985>rotate y*180}
        object{Arm rotate y*180 translate <0.25,1,1.00>}
        object{Arm2 rotate y*180  translate <0.25,1,-1.00>}

}
/*
object{Figure
       pigment{White}
          normal{bumps 0.5 scale 0.01}
          rotate y*180

}
*/




