#version 3.0
global_settings { assumed_gamma 2.2 }

#include "Finished_Elements.inc"
#include "Mud1.inc"
#include "cobblestone.inc"
#include "FloorRing.inc"
#include "HotPlate.inc"

#declare R1=seed(3456)

#declare RockMarble5=
  texture {
    pigment {
      bozo
      turbulence 0.71
      color_map {
        [0.00 rgb<0.25, 0.69, 0.25>]
        [0.40 rgb<0.00, 0.23, 0.00>]
        [0.42 rgb<0.04, 0.09, 0.16>]
        [1.00 rgb<0.22, 0.57, 0.37>]
      }
    }
    normal {bozo 7 turbulence 0.71 scale 0.2}
    finish {specular 0.2 roughness 0.01}
    scale <4, 1, 2>
    rotate -62*z
  }
  texture {
    pigment {
      granite
      color_map {
        [0.00 rgbf<0.25, 0.69, 0.25, 0.80>]
        [0.40 rgbf<0.00, 0.23, 0.00, 0.20>]
        [0.42 rgbf<0.04, 0.09, 0.16, 0.50>]
        [1.00 rgbf<0.22, 0.57, 0.37, 0.70>]
      }
    }
    normal {granite 7 turbulence 0.71 scale 3}
    finish {specular 0.2 roughness 0.03 }
    scale 2
  }

#declare RockMarble6=
  texture {
    pigment {
      bozo
      turbulence 0.71
      color_map {
        [0.00 rgb<0.80, 0.78, 0.50>]
        [0.40 rgb<0.10, 0.03, 0.00>]
        [0.42 rgb<0.35, 0.08, 0.10>]
        [1.00 rgb<0.76, 0.74, 0.50>]
      }
    }
    normal {bozo 7 turbulence 0.71 scale 0.2}
    finish {specular 0.173 roughness 0.1 ambient 0.25 diffuse 0.8632 brilliance 1.7}
    scale <4, 1, 2>
    rotate -62*z
  }
  texture {
    pigment {
      granite
      color_map {
        [0.00 rgbf<0.80, 0.78, 0.50, 0.80>]
        [0.40 rgbf<0.10, 0.03, 0.00, 0.20>]
        [0.42 rgbf<0.35, 0.08, 0.10, 0.50>]
        [1.00 rgbf<0.76, 0.74, 0.50, 0.70>]
      }
    }
    normal {granite 6.4 scale 3 turbulence 0.71}
    finish {specular 0.1 roughness 0.03 }
    scale 2
  }

// FINAL CAMERA POS.

camera {
  location <-4, 8, -40>
  right <4/3, 0, 0>
  up <0, 1, 0>
  sky <0, 1, 0>
  look_at  <0, 0, 10>
}

// SPOTS HIGHLIGHTING THE 4 ELEMENTS

light_source {
  <0, 28, 0>
  color rgb<0.15, 0.15, 0.15>
  spotlight
  point_at <-20, 0, 0>
  radius 15
  falloff 25
  tightness 0.5
}
light_source {
  <0, 28,  0>
  color rgb<0.15, 0.15, 0.15>
  spotlight
  point_at <20, 0, 0>
  radius 15
  falloff 25
  tightness 0.5
}
light_source {
  <0, 28, 0>
  color rgb<0.15, 0.15, 0.15>
  spotlight
  point_at <0, 0, 20>
  radius 15
  falloff 25
  tightness 0.5
}

light_source {
  <0, 28,  0>
  color rgb<0.15, 0.15, 0.15>
  spotlight
  point_at <0, 0, -20>
  radius 15
  falloff 25
  tightness 0.5
}

// LIGHTS USED TO SIMULATE GLOW OF 5TH ELEMENT

light_source { < 0.5, 14, -6 > color rgb<0.4, 0.10, 0.05> }

light_source { < 0.5, 14, 2 > color rgb<0.4, 0.10, 0.05> }

// CIRCULAR WALL

#declare Block1=
superellipsoid {<0.25, 0.25> scale <9.9, 2.9, 3>}

#declare Counter1=0
#declare Counter2=0

#while (Counter2 < 20)
#while (Counter1 < 360)
  object {Block1
    translate <0, (-10.00+(24*Counter2)), -100>
    rotate Counter1*y
    texture {RockMarble5 scale 13 rotate <360*rand(R1), 360*rand(R1), 360*rand(R1)>}
  }
  object {Block1
    translate <0, (-4+(24*Counter2)), -100>
    rotate (Counter1+2.875)*y
    texture {RockMarble5 scale 13 rotate <360*rand(R1), 360*rand(R1), 360*rand(R1)>}
  }
  object {Block1
    translate <0, (2+(24*Counter2)), -100>
    rotate (Counter1+5.75)*y
    texture {RockMarble5 scale 13 rotate <360*rand(R1), 360*rand(R1), 360*rand(R1)>}
  }
  object {Block1
    translate <0, (8+(24*Counter2)), -100>
    rotate (Counter1+8.625)*y
    texture {RockMarble5 scale 13 rotate <360*rand(R1), 360*rand(R1), 360*rand(R1)>}
  }
 #declare Counter1=Counter1+11.5
#end
#declare Counter1=0
#declare Counter2=Counter2+1
#end

// SPIRAL STAIRCASE

#declare Block2=
superellipsoid {<0.25, 0.25> scale <3.5, 0.75, 15>}

#declare Stairs1=
union {
  object {Block2
    translate <0, -12.00, 98>
    rotate -32*y
    texture {RockMarble6 scale 13 rotate <360*rand(R1), 360*rand(R1), 360*rand(R1)>}
  }
  object {Block2
    translate <0, -10.5, 98>
    rotate -29.125*y
    texture {RockMarble6 scale 13 rotate <360*rand(R1), 360*rand(R1), 360*rand(R1)>}
  }
  object {Block2
    translate <0, -9.0, 98>
    rotate -26.25*y
    texture {RockMarble6 scale 13 rotate <360*rand(R1), 360*rand(R1), 360*rand(R1)>}
  }
  object {Block2
    translate <0, -7.5, 98>
    rotate -23.375*y
    texture {RockMarble6 scale 13 rotate <360*rand(R1), 360*rand(R1), 360*rand(R1)>}
  }
}
#declare Counter1=0
#declare Counter2=0

#while (Counter2 < 80)
  object {Stairs1
    translate (6*Counter2)*y
    rotate (11.5*Counter2)*y
  }
  #declare Counter2=Counter2+1
#end

// GROUT FOR COBBLESTONE FLOOR

plane {y, -9.75 pigment {color rgb<0.10, 0.10, 0.10>}}

// COBBLESTONE FLOOR

object {FLL2 translate <-10, 0, 10>}

// CENTRAL WELL UNDER 5TH ELEMENT

object {StoneWell2}

// PATTERNED FLOOR RING IN CENTER OF ROOM

object {FloorRing1}

// THE FIFTH ELEMENT

object {HotPlate2 scale 0.75 rotate -90*x translate <0.5, 4, -2>}

// EARTHEN CREATURE

object {
  Mud1
  scale 0.575
  rotate 168*y
  translate <-12, -5.85, -7>
}

// AIR ICON

object {Air1
  scale 2
  texture {AirTex1}
  translate <20, 10.15, 0>
}

// COLUMN FOR AIR ICON

object {
  FullColumn1
  rotate -90*y
  translate <20, 0, 0>
}

// FIRE ICON

object {Fire1
  scale 2
  texture {FlameTex1 scale <1, 3, 1>}
  translate <0.5, -3.5, 0.5>
  translate <0, 7.75, 20>
}

// COLUMN FOR FIRE ICON

object {
  FullColumn1
  rotate 180*y
  translate <0, 0, 20>
}

// WATER ICON

object {Water1
  scale 2
  texture {WaterTex1}
  translate <-20, 10.05, 0>
}

// COLUMN FOR WATER ICON

object {
  FullColumn1
  rotate 90*y
  translate <-20, 0, 0>
}

// BROKEN COLUMN

object {BottomColumnPiece
  rotate -90*y
  translate <0, 0, -20>
}

// TOP OF BROKEN COLUMN

object {TopColumnPiece2
  rotate 180*y
  translate -1*y
  rotate 82.5*x
  rotate 22*y
  translate <7, -7.55, 3>
  translate <0, 0, -20>
}
