////////////////////  #DECLARE 1 UNIT == 0.25 INCHES    \\\\\\\\\\\\\\\\\\\\\
////////////////////  TEXTURE DECLARATIONS              \\\\\\\\\\\\\\\\\\\\\

//////////////////////////
// TEXTURE DECLARATIONS //
//////////////////////////

#declare R1=seed(76456)

#declare HotRed=
  texture {
    pigment {
      gradient z
      color_map {
        [0.0 rgb<0.6, 0.15, 0.05>]
        [0.375 rgb<0.45, 0.10, 0.0375>]
        [0.5 rgb<0, 0, 0>]
        [1.0 rgb<0, 0, 0>]
      }
    }
    finish {specular 0.134 roughness 0.3 ambient 1.2}
  }

#declare DustyGrey=
  texture {
    pigment {
      gradient z
      color_map {
        [0.0 rgb<0.1, 0.1, 0.1>]
        [0.675 rgb<0.05, 0.05, 0.05>]
        [1.0 rgb<0, 0, 0>]
      }
    }
    finish {specular 0.134 roughness 0.3 /*ambient 1.5*/}
  }

////////////////////  OBJECT DECLARATIONS AND PLACEMENT \\\\\\\\\\\\\\\\\\\\\

#declare Element1=
  difference {
    sphere {0, 0.5}
    cylinder {<0, 0, -2>, <0, 0, 2>, 0.375 scale <2, 1, 1> inverse}
  }

#declare Spin1=0
#declare TR1=-4
#declare RT1=0

#declare HotPlate1=
  union {
    #while (Spin1 < 1455)
      #if (Spin1 > 20)
        object {
          Element1
          texture {
            HotRed
            normal {
              bumps 0.35
              scale <0.01, 0.02, 0.05>
              rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
            }
          }
          translate TR1*z
          rotate RT1*y
        }
      #end
      #declare Spin1=Spin1+1
      #declare TR1=TR1-(2/500)
      #declare RT1=RT1-(360/500)
    #end
  }

#declare HotLink1=
  union {
    difference {
      torus {2.5, 0.5 rotate -90*x}
      box {<-4, 0, -4>, <0, 2.875, 4> inverse}
      texture {
        HotRed
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
      texture {
        pigment {
          gradient x
          color_map {
            [0.0 rgb<0, 0, 0>]
            [0.75 rgbt<0, 0, 0, 1>]
            [1.0 rgbt<0, 0, 0, 1>]
          }
          scale 3
          translate -2.75*x
        }
      }
      translate <0, -2.5, -4.08>
      rotate -14.4*y
    }
    difference {
      torus {2.5, 0.5
        rotate -90*z
      }
      box {<-4, 0, 0>, <4, -4, 4> inverse}
      translate -2.5*z
      rotate 14.4*y
      translate -2.5*x
      translate <0, -2.5, -4.08>
      rotate -14.4*y
      texture {
        DustyGrey
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
    }
    cylinder {<0, 0, -5>, <0, 0, 5>, 0.5
      translate -5*z
      translate -2.5*y
      rotate 14.4*y
      translate -2.5*x
      translate <0, -2.5, -4.08>
      rotate -14.4*y
      translate -2.5*z
      texture {
        DustyGrey
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
    }
  }

#declare HotLink2=
  union {
    difference {
      torus {2.5, 0.5 rotate -90*x}
      box {<4, 0, -4>, <0, 2.875, 4> inverse}
      texture {
        HotRed
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
      texture {
        pigment {
          gradient x
          color_map {
            [0.0 rgb<0, 0, 0>]
            [0.75 rgbt<0, 0, 0, 1>]
            [1.0 rgbt<0, 0, 0, 1>]
          }
          scale 3
          translate 2.75*x
        }
      }
      translate -2.5*y
      translate -9.82*z
      rotate -1047.6*y
    }
    difference {
      torus {2.5, 0.5
        rotate -90*z
      }
      box {<-4, 0, 0>, <4, -4, 4> inverse}
      translate -2.5*z
      rotate -32*y
      translate <2.5, -2.5, 0>
      translate -9.82*z
      rotate -1047.6*y
      texture {
        DustyGrey
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
    }
    cylinder {<0, -5, -7.5>, <0, -5, -2.5>, 0.5
      rotate -32*y
      translate 2.5*x
      translate -9.82*z
      rotate -1047.6*y
      texture {
        DustyGrey
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
    }
  }

////////////////////////////////////////////////////////
////////////////////////////////////////////////////////

#declare Spin1=0
#declare TR1=-4
#declare RT1=0

#declare HotPlate2=
  union {
    #while (Spin1 < 1455)
      #if (Spin1 > 20)
        object {
          Element1
          texture {
            DustyGrey
            normal {
              bumps 0.35
              scale <0.01, 0.02, 0.05>
              rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
            }
          }
          translate TR1*z
          rotate RT1*y
        }
      #end
      #declare Spin1=Spin1+1
      #declare TR1=TR1-(2/500)
      #declare RT1=RT1-(360/500)
    #end
  }

#declare HotLink3=
  union {
    difference {
      torus {2.5, 0.5 rotate -90*x}
      box {<-4, 0, -4>, <0, 2.875, 4> inverse}
      texture {
        DustyGrey
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
      translate <0, -2.5, -4.08>
      rotate -14.4*y
    }
    difference {
      torus {2.5, 0.5
        rotate -90*z
      }
      box {<-4, 0, 0>, <4, -4, 4> inverse}
      translate -2.5*z
      rotate 14.4*y
      translate -2.5*x
      translate <0, -2.5, -4.08>
      rotate -14.4*y
      texture {
        DustyGrey
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
    }
    cylinder {<0, 0, -5>, <0, 0, 5>, 0.5
      translate -5*z
      translate -2.5*y
      rotate 14.4*y
      translate -2.5*x
      translate <0, -2.5, -4.08>
      rotate -14.4*y
      translate -2.5*z
      texture {
        DustyGrey
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
    }
  }

#declare HotLink4=
  union {
    difference {
      torus {2.5, 0.5 rotate -90*x}
      box {<4, 0, -4>, <0, 2.875, 4> inverse}
      texture {
        DustyGrey
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
      translate -2.5*y
      translate -9.82*z
      rotate -1047.6*y
    }
    difference {
      torus {2.5, 0.5
        rotate -90*z
      }
      box {<-4, 0, 0>, <4, -4, 4> inverse}
      translate -2.5*z
      rotate -32*y
      translate <2.5, -2.5, 0>
      translate -9.82*z
      rotate -1047.6*y
      texture {
        DustyGrey
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
    }
    cylinder {<0, -5, -7.5>, <0, -5, -2.5>, 0.5
      rotate -32*y
      translate 2.5*x
      translate -9.82*z
      rotate -1047.6*y
      texture {
        DustyGrey
        normal {
          bumps 0.35
          scale <0.01, 0.02, 0.05>
          rotate <180*rand(R1), 180*rand(R1), 180*rand(R1)>
        }
      }
    }
  }


#declare HotPlate2=
  union {
    object {HotPlate1}
    object {HotLink1}
    object {HotLink2}
    union {
      sphere {<0, 0, 0>, 3
        scale <1, 0.2, 1>
      }
      cylinder {<0, -1.5, 0>, <0, 0, 0>, 3 open}
      texture {
        pigment {color rgb<0.25, 0.25, 0.25>}
        normal {
          dents 1
          scale <1, 3, 1>
          scale 0.1
        }
        finish {
          specular 0.25
          roughness 0.3
        }
      }
      translate <-0.3, 0, 0.3>
    }
    box {<-10.75, -1.5, -0.2>, <0, -0.5, 0.2>
      pigment {color rgb<0.25, 0.25, 0.25>}
      rotate -22.5*y
    }
    box {<-9.6, -1.5, -0.2>, <0, -0.5, 0.2>
      pigment {color rgb<0.25, 0.25, 0.25>}
      rotate -157.5*y
    }
    box {<-10, -1.5, -0.2>, <0, -0.5, 0.2>
      pigment {color rgb<0.25, 0.25, 0.25>}
      rotate 90*y
    }
  }


