//////////////////////////
// TEXTURE DECLARATIONS //
//////////////////////////

#declare TX2=
  texture {
    pigment {
      crackle
      turbulence 0.43
      color_map {
        [0.0 color rgb<1, 0.7, 0.3>]
        [0.5 color rgb<0.405, 0.405, 0.375>]
        [1.0 color rgb<0.810, 0.850, 0.000>]
      }
    }
    normal {
      crackle 1
      turbulence 0.43
    }
    finish {specular 0.3 roughness 0.3}
  }

#declare TX3=
  texture {
    pigment {
      crackle
      turbulence 0.43
      color_map {
        [0.0 color rgb<0.200, 0.350, 0.000>]
        [0.5 color rgb<0.400, 0.435, 0.400>]
        [1.0 color rgb<1, 0.7, 0.3>]

      }
    }
    normal {
      crackle 1
      turbulence 0.43
    }
    finish {specular 0.3 roughness 0.3}
  }

/////////////////////////
// OBJECT DECLARATIONS //
/////////////////////////

#declare IC=0
#declare ROT1=0
#declare BL_STR=2
#declare Y_INC=0
#declare X_INC=2
#declare R1=seed(234)

#declare Mud1=
  blob {
    threshold 0.65
    #while (IC < 200)
      sphere {0, BL_STR, 1
        scale <(BL_STR/2)+1, 1-(0.25*BL_STR), 1-(0.125*BL_STR)>
        rotate <32.5*BL_STR, -6*BL_STR, 6*BL_STR>
        #if (rand(R1) < 0.5)
          translate <X_INC+0.5, Y_INC+0.5, 0>
          texture {TX2 scale 0.25}
        #else
          translate <X_INC, Y_INC, 0>
          texture {TX3 scale 0.25}
        #end
        rotate rand(R1*5)*z
        rotate (ROT1+rand(R1*5))*y
      }
      #declare ROT1=ROT1+15
      #declare IC=IC+1
      #declare BL_STR=BL_STR-0.007995
      #declare Y_INC=Y_INC+0.04485
      #declare X_INC=X_INC-0.00995
    #end
    //////////////////////////////////////////////////////
    #declare IC=0
    #declare ROT1=0
    #declare ROT2=0
    #declare BL_STR=2
    #declare Y_INC=0
    #declare X_INC=2
    #while (IC < 200)
      sphere {0, BL_STR, 1
        scale <(BL_STR/2)+1, 1-(0.25*BL_STR), 1-(0.125*BL_STR)>
        rotate <32.5*BL_STR, -6*BL_STR, 6*BL_STR>
        #if (rand(R1) < 0.5)
          translate <X_INC+0.5, Y_INC+0.5, 0>
          texture {TX2 scale 0.25}
        #else
          translate <X_INC, Y_INC, 0>
          texture {TX3 scale 0.25}
        #end
        rotate rand(R1*5)*z
        rotate (ROT1+rand(R1*5))*y
        rotate ROT2*z
        rotate -110*z
        rotate <0, 15, 0>
        translate <3, -1, 0>
      }
      #declare ROT1=ROT1+5
      #if (IC < 50)
        #declare ROT2=ROT2+1
      #else
        #if (IC < 100)
          #declare ROT2=ROT2-1
        #else
          #if (IC < 150)
            #declare ROT2=ROT2+1
          #else
            #declare ROT2=ROT2-1
          #end
        #end
      #end
      #declare IC=IC+1
      #declare BL_STR=BL_STR-0.00995
      #declare Y_INC=Y_INC+0.05985
      #declare X_INC=X_INC-0.00995
    #end
    //////////////////////////////////////////////////////
    #declare IC=0
    #declare ROT1=0
    #declare ROT2=0
    #declare BL_STR=2
    #declare Y_INC=0
    #declare X_INC=2
    #while (IC < 200)
      sphere {0, BL_STR, 1
        scale <(BL_STR/2)+1, 1-(0.25*BL_STR), 1-(0.125*BL_STR)>
        rotate <32.5*BL_STR, -6*BL_STR, 6*BL_STR>
        #if (rand(R1) < 0.5)
          translate <X_INC+0.5, Y_INC+0.5, 0>
          texture {TX2 scale 0.25}
        #else
          translate <X_INC, Y_INC, 0>
          texture {TX3 scale 0.25}
        #end
        rotate rand(R1*5)*z
        rotate -(ROT1+rand(R1*5))*y
        rotate ROT2*z
        rotate -110*z
        rotate <0, 180, 0>
        translate <-3, -1, 0>
      }
      #declare ROT1=ROT1+5
      #if (IC < 50)
        #declare ROT2=ROT2+1
      #else
        #if (IC < 100)
          #declare ROT2=ROT2-1
        #else
          #if (IC < 150)
            #declare ROT2=ROT2+1
          #else
            #declare ROT2=ROT2-1
          #end
        #end
      #end
      #declare IC=IC+1
      #declare BL_STR=BL_STR-0.00995
      #declare Y_INC=Y_INC+0.05985
      #declare X_INC=X_INC-0.00995
    #end
    //////////////////////////////////////////////////////
    #declare IC=0
    #declare ROT1=0
    #declare BL_STR=2
    #declare Y_INC=0
    #declare X_INC=2
    #while (IC < 200)
      sphere {0, BL_STR, 1
        scale <(BL_STR/2)+1, 1-(0.05*BL_STR), 1-(0.025*BL_STR)>
        rotate <32.5*BL_STR, -6*BL_STR, 6*BL_STR>
        #if (rand(R1) < 0.5)
          translate <X_INC+0.5, Y_INC+0.5, 0>
          texture {TX2 scale 0.25}
        #else
          translate <X_INC, Y_INC, 0>
          texture {TX3 scale 0.25}
        #end
        rotate rand(R1*5)*z
        rotate (ROT1+rand(R1*5))*y
      }
      #declare ROT1=ROT1-15
      #declare IC=IC+1
      #declare BL_STR=BL_STR+0.00995
      #declare Y_INC=Y_INC-0.04985
      #declare X_INC=X_INC-0.00995
    #end
  }
