#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "SKIES.inc"

camera
{
 location -z*8
 look_at 0
}

light_source { -z*10 White }
light_source { <500,1000,200> Orange*0.8 }

#declare terrain = on
#declare lava = on         // yes, it's *meant* to be lava
#declare clouds = on
#declare fire = on
#declare bubbles = on

#if (clouds = on)
object
{
 O_Cloud1
}
#end

#if (terrain = on)
#declare rock =
height_field
{
  tga "terrain.tga"
  smooth
  texture { T_Stone3 }
  finish
  {
   specular 0.0
   phong 0.0
   reflection 0.2
   crand 0.02
  }
  pigment { rgb <0.4,0.2,0.1> }
  translate <-0.5,-0.5,0>
  scale <20,8,26>
  rotate <-25,10,0>
  translate -y*2
  pigment
  {
   granite
   color_map
   {
    [0.0, 0.3 color Mica color <0.6,0.3,0.1> ]
    [0.3, 0.4 color <0.6,0.3,0.1> color <0.6,0.3,0.1> ]
    [0.4, 0.6 color <0.6,0.3,0.1> color <0.6,0.3,0.1> ]
    [0.6, 1.0 color <0.6,0.3,0.1> color <0.9,0.3,0.1> ]
   }
  }
}

object { rock }
object { rock scale <1,1.5,1> translate <-30,0,30> }
#end

#if (lava = on)
plane
{
 y,-3
 pigment { rgb <0.6,0.3,0.1> }
 normal { bumps 0.8 scale 0.4 }
 finish
 {
  specular 0.1
  phong 0.1
  reflection 0.1
  diffuse 0.8
  ambient 0.1
 }
}
#end

#if (fire = on)
#declare Count = 1
 #while (Count < 3)
 sphere
 {
  0,1
  pigment { color rgbt <1,1,1,1> }
  halo
  {
   emitting
   spherical_mapping
   linear
   turbulence 1.5
   color_map
   {
    [ 0 color rgbt <1,0,0,1> ]
    [ 1 color rgbt <1,1,0,-1> ]
   }
   samples 10
   scale 0.5
  }
  hollow
  scale <6,10,6>
  translate <15*Count-27,3-3*Count,37.5-22.5*Count>
 }
 #declare Count = Count + 1
 #end 

sphere
{
 0,1
 pigment { color rgbt <1,1,1,1> } 
 halo
 {
  emitting
  cylindrical_mapping
  cubic
  turbulence 4.0
  color_map
  {
   [ 0 color rgbt <1,0,0,1> ]
   [ 1 color rgbt <0.8,0.8,0,-1> ]
  }
  samples 10
  scale 0.25
 }
 halo
 {
  spherical_mapping
  linear
  turbulence 1.5
  color_map
  {
   [ 0 color rgbt <1,0,0,1> ]
   [ 1 color rgbt <0.9,0.9,0,-1> ]
  }
  frequency 2
  samples 10
  scale <0.25,1,0.5>
 }
 hollow
 scale <1,1.5,1>
 scale 3.5
 translate <-1.5,7,15>
}
#end

#if (bubbles = on)
#declare bubble =
sphere
{
 0,1
 pigment { rgbt <0.6,0.3,0.1,0.93> }
 finish
 {
  irid
  {
   0.2
   thickness 0.02
   turbulence 2.0
  }
  refraction on
  ior 1.9
  reflection 0.4
  phong 0.2
  ambient 0.1
  diffuse 0.5
 }
}

union
{
 object { bubble scale 0.65 translate <0.02,-3,0> }
 object { bubble scale 0.35 translate <0.68,-3,-0.38> }
 object { bubble scale 0.20 translate <-0.44,-2.98,-0.42> }
 object { bubble scale 0.10 translate <-0.06,-2.98,-0.66> }
 object { bubble scale 0.10 translate <0.94,-2.97,-0.66> }
 object { bubble scale 0.10 translate <-0.6,-2.98,-0.26> }
 object { bubble scale 0.10 translate <-0.44,-2.99,-0.68> }
 object { bubble scale 0.10 translate <-0.6,-3,-0.62> }
 object { bubble scale 0.10 translate <-0.6,-3,-0.8> }

 translate <-2.2,0,4>
}

#end

background { rgb <0.45,0.25,0.16> }
